<?php

class ModelPrescriptionAcupuncture extends Model {

    public function getAcupunctures($data = array()) {
        return array();
    }

    public function getAcupunctureList($data) {
        $sort = isset($data['sort']) ? $data['sort'] : "name";
        $order = isset($data['order']) ? $data['order'] : "ASC";

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "acupuncture.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "acupuncture.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
        $filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "acupuncture.status ='" . $filter_status . "'" : "";

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "acupuncture ,
		(
			SELECT *
			FROM " . DB_PREFIX . "acupuncture_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "acupuncture.acupuncture_id = a.acupuncture_id
		AND " . DB_PREFIX . "acupuncture.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
	    $filter_status_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAcupunctureItemList($acupuncture_id) {
        $acupunctureItemList = array();

        $sql = "
		SELECT *
		FROM " . DB_PREFIX . "acupuncture
		WHERE parent_id = $acupuncture_id";

        $query = $this->db->query($sql);
        $acupunctureItemRows = $query->rows;

        if (!empty($acupunctureItemRows)) {
            foreach ($acupunctureItemRows as $row => $acupunctureItem) {
                $data = array();
                $data["code"] = $acupunctureItem["code"];
                $data["pinyin"] = $acupunctureItem["pinyin"];
                $data["acupuncture_id"] = $acupunctureItem["acupuncture_id"];
                $data['x_coordinate'] = $acupunctureItem['x_coordinate'];
                $data['y_coordinate'] = $acupunctureItem['y_coordinate'];
                $data['location'] = $acupunctureItem['location'];
                $data['ways'] = $acupunctureItem['ways'];
                $data['symptoms'] = $acupunctureItem['symptoms'];
                $data['acupuncture_part_list'] = unserialize($acupunctureItem['acupuncture_parts']);

                $data["acupuncture_name"] = array();
                $sql = "
				SELECT *
				FROM " . DB_PREFIX . "acupuncture_name
				WHERE acupuncture_id = " . $acupunctureItem["acupuncture_id"];
                $query = $this->db->query($sql);
                $names = $query->rows;

                foreach ($names as $row => $name) {
                    $data["acupuncture_name"][$name["language_id"]]["name"] = $name["name"];
                }

                $acupunctureItemList[] = $data;
            }
        }

        return $acupunctureItemList;
    }

    public function getAcupunctureItem($acupuncture_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "acupuncture  d LEFT JOIN " . DB_PREFIX . "acupuncture_name dn ON (d.acupuncture_id = dn.acupuncture_id) WHERE d.parent_id = '" . (int) $acupuncture_id . "' AND dn.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getAcupunctureColumn($acupuncture_id, $column_name, $multirow = false, $language_id = NULL) {
        $language_id = $language_id ? $language_id : (int) $this->config->get('config_language_id');

        $sql = "
		SELECT b." . $column_name . "
		FROM(
			SELECT " . DB_PREFIX . "acupuncture.acupuncture_id, " . DB_PREFIX . "acupuncture.code, " . DB_PREFIX . "acupuncture.pinyin, a.name, " . DB_PREFIX . "acupuncture.sort_order, " . DB_PREFIX . "acupuncture.status, " . DB_PREFIX . "acupuncture.image
			FROM " . DB_PREFIX . "acupuncture ,
			(
				SELECT *
				FROM " . DB_PREFIX . "acupuncture_name
				WHERE language_id = $language_id
			)a
			WHERE " . DB_PREFIX . "acupuncture.acupuncture_id = a.acupuncture_id
			AND " . DB_PREFIX . "acupuncture.parent_id = 0
			AND " . DB_PREFIX . "acupuncture.acupuncture_id = " . $acupuncture_id . "
		)b";
        $query = $this->db->query($sql);
        return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
    }

    public function addAcupuncture($data, $parent_id = 0) {
        // post data
        $names = $data['acupuncture_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $x_coordinate = !empty($data['x_coordinate']) ? $data['x_coordinate'] : '';
        $y_coordinate = !empty($data['y_coordinate']) ? $data['y_coordinate'] : '';
        $location = !empty($data['location']) ? $data['location'] : '';
        $ways = !empty($data['ways']) ? $data['ways'] : '';
        $symptoms = !empty($data['symptoms']) ? $data['symptoms'] : '';
        $acupuncture_parts = isset($data['acupuncture_part_list']) ? serialize($data['acupuncture_part_list']) : serialize(array());
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $image = isset($data['image']) ? $data['image'] : '';

        $acupunctureitems = isset($data['acupunctureitem']) ? $data['acupunctureitem'] : false;

        // insert acupuncture
        $sql = "INSERT INTO " . DB_PREFIX . "acupuncture(code, pinyin, parent_id, status, image, sort_order, x_coordinate, y_coordinate, location, ways, symptoms, acupuncture_parts, createby, createdate)
				VALUES('$code', '$pinyin', '$parent_id', '$status', '$image', '$sort_order', '$x_coordinate', '$y_coordinate', '$location' , '$ways' , '$symptoms' , '$acupuncture_parts' , '" . $this->session->data['user_id'] . "', NOW())";
        $query = $this->db->query($sql);

        // get last insert id
        $lastid = $this->db->getLastId();

        // insert acupuncture name
        foreach ($names as $language_id => $value) {
            $name = $value['name'];

            $sql = "
			INSERT INTO
			" . DB_PREFIX . "acupuncture_name SET
			acupuncture_id = '" . (int) $lastid . "',
			language_id = '" . (int) $language_id . "',
			name = '" . $this->db->escape($name) . "'";

            $query = $this->db->query($sql);
        }

        // If have child, insert child
        if ($acupunctureitems) {
            foreach ($acupunctureitems as $acupunctureitem) {
                $acupunctureitem['status'] = $status;
                $this->addAcupuncture($acupunctureitem, $lastid);
            }
        }

        return $lastid;
    }

    public function editAcupuncture($id, $data) {
        // post data
        $names = $data['acupuncture_name'];
        $code = $data['code'];
        $pinyin = isset($data['pinyin']) ? $data['pinyin'] : '';
        $x_coordinate = !empty($data['x_coordinate']) ? $data['x_coordinate'] : '';
        $y_coordinate = !empty($data['y_coordinate']) ? $data['y_coordinate'] : '';
        $location = !empty($data['location']) ? $data['location'] : '';
        $ways = !empty($data['ways']) ? $data['ways'] : '';
        $symptoms = !empty($data['symptoms']) ? $data['symptoms'] : '';
        $acupuncture_parts = isset($data['acupuncture_part_list']) ? serialize($data['acupuncture_part_list']) : serialize(array());
        $status = isset($data['status']) ? $data['status'] : false;
        $sort_order = isset($data['sort_order']) ? $data['sort_order'] : 0;
        $image = isset($data['image']) ? $data['image'] : '';

        $acupunctureitems = isset($data['acupunctureitem']) ? $data['acupunctureitem'] : false;

        //general update
        $sql = "
		UPDATE " . DB_PREFIX . "acupuncture SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order', 
		image = '$image', 
		x_coordinate = '$x_coordinate', 
		y_coordinate = '$y_coordinate', 
		location = '$location',
		ways = '$ways',
		symptoms = '$symptoms',
		acupuncture_parts = '$acupuncture_parts',
		modifyby = '" . $this->session->data['user_id'] . "',
		modifydate = NOW()
		WHERE acupuncture_id = '$id'
		";
        $query = $this->db->query($sql);

        //name update
        foreach ($names as $language_id => $value) {
            $newname = $value['name'];
            $sql = "
			UPDATE " . DB_PREFIX . "acupuncture_name SET
			name = '$newname'
			WHERE acupuncture_id = '$id'
			AND language_id = $language_id
			";
            $query = $this->db->query($sql);
        }

        if ($acupunctureitems) {
            $survive_id = array();

            $updated_data = array();
            $new_data = array();
            $removed_data = array();

            foreach ($acupunctureitems as $acupunctureitempos => $acupunctureitem) {
                if (!empty($acupunctureitem["acupuncture_id"])) {

                    $acupunctureitem['status'] = $status;

                    $survive_id[] = $acupunctureitem["acupuncture_id"]; //track for survice acupuncture

                    $updated_data[] = array(//track for update acupuncture
                        'acupuncture_id' => $acupunctureitem["acupuncture_id"],
                        'data' => $acupunctureitem
                    );
                } else {
                    $acupunctureitem['status'] = $status;

                    $new_data[] = array(//track for new acupuncture
                        'data' => $acupunctureitem,
                        'parent_id' => $id
                    );
                }
            }

            // kill oudated acupuncture item
            $survive_id_statement = !empty($survive_id) ?
                    "AND acupuncture_id NOT IN('" . implode("','", $survive_id) . "')" :
                    NULL;
            $sql = "
			SELECT acupuncture_id
			FROM " . DB_PREFIX . "acupuncture
			WHERE parent_id = $id
			$survive_id_statement
			";



            $query = $this->db->query($sql);
            $outdatedAcupuncture = $query->rows;
            foreach ($outdatedAcupuncture as $oacupuncture)
                $this->deleteAcupuncture($oacupuncture['acupuncture_id']);

            // update acupuncture item
            foreach ($updated_data as $data)
                $this->editAcupuncture($data['acupuncture_id'], $data['data']);

            // add new acupuncture item
            foreach ($new_data as $data)
                $this->addAcupuncture($data['data'], $data['parent_id']);
        } else {
            // no child item, just kill all

            $sql = "
			SELECT COUNT(*) as total
			FROM " . DB_PREFIX . "acupuncture
			WHERE parent_id = $id
			";
            $query = $this->db->query($sql);
            $total = $query->row['total'];

            if ($total > 0) {
                $sql = "DELETE FROM " . DB_PREFIX . "acupuncture WHERE parent_id = $id";
                $query = $this->db->query($sql); //kill all child
            }
        }
    }

    public function deleteAcupuncture($acupuncture_id) {
        //delete acupuncture multi language name
        $sql = "
		SELECT acupuncture_id
		FROM " . DB_PREFIX . "acupuncture
		WHERE acupuncture_id = $acupuncture_id
		OR parent_id = $acupuncture_id
		";
        $query = $this->db->query($sql);
        $rows = $query->rows;
        foreach ($rows as $row => $row_data) {
            $row_id = $row_data['acupuncture_id'];

            //delete acupuncture
            $sql = "
			DELETE FROM " . DB_PREFIX . "acupuncture_name
			WHERE acupuncture_id = $row_id";
            $query = $this->db->query($sql);
        }

        //delete acupuncture and acupuncture item
        $sql = "
		DELETE FROM " . DB_PREFIX . "acupuncture
		WHERE acupuncture_id = $acupuncture_id
		OR parent_id = $acupuncture_id";
        $query = $this->db->query($sql);

        $this->cache->delete('category');
    }

    public function totalAcupuncture($data) {

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
        $filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;

        $filter_name_statement = $filter_name ? "AND a.name LIKE '%" . $filter_name . "%'" : "";
        $filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "acupuncture.code LIKE '%" . $filter_code . "%'" : "";
        $filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "acupuncture.pinyin LIKE '%" . $filter_pinyin . "%'" : "";

        $sql = "
		SELECT COUNT(*) AS total
		FROM " . DB_PREFIX . "acupuncture ,
		(
			SELECT *
			FROM " . DB_PREFIX . "acupuncture_name
			WHERE language_id = " . (int) $this->config->get('config_language_id') . "
		)a
		WHERE " . DB_PREFIX . "acupuncture.acupuncture_id = a.acupuncture_id
		AND " . DB_PREFIX . "acupuncture.parent_id = 0
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getAcupunctureBodyParts() {
        $sql = "SELECT ap.acupuncture_part_id, apd.name
				FROM " . DB_PREFIX . "acupuncture_part ap
				LEFT JOIN " . DB_PREFIX . "acupuncture_part_description apd
				ON apd.acupuncture_part_id = ap.acupuncture_part_id
				AND apd.language_id = '" . $this->config->get('config_language_id') . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

}

?>