<?php

class ModelPosPos extends Model {

    public function editSettingValue($key = '', $value = ''){
        $this->db->query("DELETE FROM " . DB_PREFIX . "setting WHERE `key` = '" . $this->db->escape($key) . "' AND store_id=0");
        $this->db->query("INSERT INTO " . DB_PREFIX . "setting values('',0,'pos','".$key."','" . $value . "',0)");
    }

    public function loadConfig(){

        $this->config->set('default_store',$this->config->get('config_name'));//set default store name

        if(isset($this->session->data['store_id'])){
            $store_id = $this->session->data['store_id'];
            if($store_id){
                $settings = $this->model_setting_setting->getSetting('config', $store_id);
                foreach($settings as $key=>$value){
                    $this->config->set($key,$value);
                }
            }
        }
    }

    public function getProduct($product_id) {
        $query = $this->db->query("SELECT DISTINCT *, pd.name AS name, p.image, m.name AS manufacturer, (SELECT price FROM " . DB_PREFIX . "product_discount pd2 WHERE pd2.product_id = p.product_id AND pd2.customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "' AND pd2.quantity = '1' AND ((pd2.date_start = '0000-00-00' OR pd2.date_start < NOW()) AND (pd2.date_end = '0000-00-00' OR pd2.date_end > NOW())) ORDER BY pd2.priority ASC, pd2.price ASC LIMIT 1) AS discount, (SELECT price FROM " . DB_PREFIX . "product_special ps WHERE ps.product_id = p.product_id AND ps.customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "' AND ((ps.date_start = '0000-00-00' OR ps.date_start < NOW()) AND (ps.date_end = '0000-00-00' OR ps.date_end > NOW())) ORDER BY ps.priority ASC, ps.price ASC LIMIT 1) AS special, (SELECT points FROM " . DB_PREFIX . "product_reward pr WHERE pr.product_id = p.product_id AND customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "') AS reward, (SELECT ss.name FROM " . DB_PREFIX . "stock_status ss WHERE ss.stock_status_id = p.stock_status_id AND ss.language_id = '" . (int) $this->config->get('config_language_id') . "') AS stock_status, (SELECT wcd.unit FROM " . DB_PREFIX . "weight_class_description wcd WHERE p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "') AS weight_class, (SELECT lcd.unit FROM " . DB_PREFIX . "length_class_description lcd WHERE p.length_class_id = lcd.length_class_id AND lcd.language_id = '" . (int) $this->config->get('config_language_id') . "') AS length_class, (SELECT AVG(rating) AS total FROM " . DB_PREFIX . "review r1 WHERE r1.product_id = p.product_id AND r1.status = '1' GROUP BY r1.product_id) AS rating, (SELECT COUNT(*) AS total FROM " . DB_PREFIX . "review r2 WHERE r2.product_id = p.product_id AND r2.status = '1' GROUP BY r2.product_id) AS reviews, p.sort_order FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN " . DB_PREFIX . "manufacturer m ON (p.manufacturer_id = m.manufacturer_id) WHERE p.product_id = '" . (int) $product_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.internal_status = '1' AND p.date_available <= NOW() AND p2s.store_id = '" . (int) $this->session->data['store_id'] . "'");

        if ($query->num_rows) {
            return array(
                'product_id' => $query->row['product_id'],
                'name' => $query->row['name'],
                'description' => $query->row['description'],
                'meta_title' => $query->row['meta_title'],
                'meta_description' => $query->row['meta_description'],
                'meta_keyword' => $query->row['meta_keyword'],
                'tag' => $query->row['tag'],
                'model' => $query->row['model'],
                'sku' => $query->row['sku'],
                'upc' => $query->row['upc'],
                'ean' => $query->row['ean'],
                'jan' => $query->row['jan'],
                'isbn' => $query->row['isbn'],
                'mpn' => $query->row['mpn'],
                'location' => $query->row['location'],
                'quantity' => $query->row['quantity'],
                'stock_status' => $query->row['stock_status'],
                'image' => $query->row['image'],
                'manufacturer_id' => $query->row['manufacturer_id'],
                'manufacturer' => $query->row['manufacturer'],
                'price' => ($query->row['discount'] ? $query->row['discount'] : $query->row['price']),
                'special' => $query->row['special'],
                'reward' => $query->row['reward'],
                'points' => $query->row['points'],
                'tax_class_id' => $query->row['tax_class_id'],
                'date_available' => $query->row['date_available'],
                'weight' => $query->row['weight'],
                'weight_class_id' => $query->row['weight_class_id'],
                'length' => $query->row['length'],
                'width' => $query->row['width'],
                'height' => $query->row['height'],
                'length_class_id' => $query->row['length_class_id'],
                'subtract' => $query->row['subtract'],
                'rating' => round($query->row['rating']),
                'reviews' => $query->row['reviews'] ? $query->row['reviews'] : 0,
                'minimum' => $query->row['minimum'],
                'sort_order' => $query->row['sort_order'],
                'status' => $query->row['internal_status'],
                'date_added' => $query->row['date_added'],
                'date_modified' => $query->row['date_modified'],
                'viewed' => $query->row['viewed']
            );
        } else {
            return false;
        }
    }

    public function addPayment($data) {
        $sql = "update " . DB_PREFIX . "user set cash = cash + " . $data['cash'] . ", card= card + " . $data['card'] . " where user_id = " . $data['user_id'];
        $this->db->query($sql);
    }

    public function editPayment($order_id, $data) {
        $query = $this->db->query("select user_id, total, payment_method from " . DB_PREFIX . "order where order_id = '" . $order_id . "'");
        $row = $query->row;

        $cash = $card = 0;

        if ($row['total'] > $data['total'] || $data['payment_method'] != 'Card') {
            $cash = $data['total'] - $row['total'];
        } elseif ($data['payment_method'] == 'Card') {
            $card = $data['total'] - $row['total'];
        }

        $sql = "update " . DB_PREFIX . "user set cash = cash + " . $cash . ", card= card + " . $card . " where user_id = " . $data['user_id'];
        $this->db->query($sql);
    }

    public function addOrder($data) {
        $this->load->model('setting/store');

        $store_info = $this->model_setting_store->getStore($data['store_id']);

        if ($store_info) {
            $store_name = $store_info['name'];
            $store_url = $store_info['url'];
        } else {
            $store_name = $this->config->get('config_name');
            $store_url = HTTP_CATALOG;
        }

        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo',array('module'=>'pos/pos','store'=>$data['store_id']));


        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $country_info = $this->model_localisation_country->getCountry($data['shipping_country_id']);

        if ($country_info) {
            $shipping_country = $country_info['name'];
            $shipping_address_format = $country_info['address_format'];
        } else {
            $shipping_country = '';
            $shipping_address_format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }

        $zone_info = $this->model_localisation_zone->getZone($data['shipping_zone_id']);

        if ($zone_info) {
            $shipping_zone = $zone_info['name'];
        } else {
            $shipping_zone = '';
        }

        $country_info = $this->model_localisation_country->getCountry($data['payment_country_id']);

        if ($country_info) {
            $payment_country = $country_info['name'];
            $payment_address_format = $country_info['address_format'];
        } else {
            $payment_country = '';
            $payment_address_format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }

        $zone_info = $this->model_localisation_zone->getZone($data['payment_zone_id']);

        if ($zone_info) {
            $payment_zone = $zone_info['name'];
        } else {
            $payment_zone = '';
        }

        $this->load->model('localisation/currency');

        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }

//        $this->pos_cache->set('pos_'.$invoice_prefix, $data);

        $this->db->query("INSERT INTO `" . DB_PREFIX . "order` SET card_no ='" . $this->db->escape($data['card_no']) . "',  invoice_prefix = '" . $this->db->escape($invoice_prefix) . "', store_id = '" . (int) $data['store_id'] . "', store_name = '" . $this->db->escape($store_name) . "',store_url = '" . $this->db->escape($store_url) . "', customer_id = '" . (int) $data['customer_id'] . "', customer_group_id = '" . (int) $data['customer_group_id'] . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', fax = '" . $this->db->escape($data['fax']) ."', cash ='".$data['payment']['cash']."', card ='".$data['payment']['card']."', credit ='".$data['payment']['credit']."', points ='".$data['payment']['points']."', payment_firstname = '" . $this->db->escape($data['payment_firstname']) . "', payment_lastname = '" . $this->db->escape($data['payment_lastname']) . "', payment_company = '" . $this->db->escape($data['payment_company']) . "', payment_address_1 = '" . $this->db->escape($data['payment_address_1']) . "', payment_address_2 = '" . $this->db->escape($data['payment_address_2']) . "', payment_address_3 = '" . $this->db->escape($data['payment_address_3']) . "', payment_city = '" . $this->db->escape($data['payment_city']) . "', payment_postcode = '" . $this->db->escape($data['payment_postcode']) . "', payment_country = '" . $this->db->escape($payment_country) . "', payment_country_id = '" . (int) $data['payment_country_id'] . "', payment_zone = '" . $this->db->escape($payment_zone) . "', payment_zone_id = '" . (int) $data['payment_zone_id'] . "', payment_address_format = '" . $this->db->escape($payment_address_format) . "', payment_method = '" . $this->db->escape($data['payment_name']) . "', payment_code = '" . $this->db->escape($data['payment_code']) ."',shipping_address_id ='".(int)$data['shipping_address_id']. "', shipping_firstname = '" . $this->db->escape($data['shipping_firstname']) . "', shipping_lastname = '" . $this->db->escape($data['shipping_lastname']) . "', shipping_company = '" . $this->db->escape($data['shipping_company']) . "', shipping_address_1 = '" . $this->db->escape($data['shipping_address_1']) . "', shipping_address_2 = '" . $this->db->escape($data['shipping_address_2']) . "', shipping_address_3 = '" . $this->db->escape($data['shipping_address_3']) . "', shipping_city = '" . $this->db->escape($data['shipping_city']) . "', shipping_postcode = '" . $this->db->escape($data['shipping_postcode']) . "', shipping_country = '" . $this->db->escape($shipping_country) . "', shipping_country_id = '" . (int) $data['shipping_country_id'] . "', shipping_zone = '" . $this->db->escape($shipping_zone) . "', shipping_zone_id = '" . (int) $data['shipping_zone_id'] . "', shipping_address_format = '" . $this->db->escape($shipping_address_format) . "', shipping_method = '" . $this->db->escape($data['shipping_method']) . "', shipping_code = '" . $this->db->escape($data['shipping_code']) . "', comment = '" . $this->db->escape($data['comment']) . "', order_status_id = '" . (int) $data['order_status_id'] . "', affiliate_id  = '" . (int) $data['affiliate_id'] . "', language_id = '" . (int) $this->config->get('config_language_id') . "', currency_id = '" . (int) $currency_id ."', currency_code = '" . $this->db->escape($currency_code) . "', currency_value = '" . (float) $currency_value . "', date_added = NOW(), date_modified = NOW(), add_by='".(int)$this->session->data['user_id']."',modifi_by='".(int)$this->session->data['user_id']."'");

         $order_id = $this->db->getLastId();





        if (isset($data['order_product'])) {
            foreach ($data['order_product'] as $order_product) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $order_product['product_id'] . "', name = '" . $this->db->escape($order_product['name']) . "', model = '" . $this->db->escape($order_product['model']) . "', quantity = '" . (int) $order_product['quantity']."', tax_class_id ='".(int)$order_product['tax_class_id'] ."', tax_code ='".$this->db->escape($order_product['tax_code'])."', weight ='".(float)$order_product['weight']."' ,weight_class_id = '".(int)$order_product['weight_class_id']."', usedqty ='".(int)$order_product['usedqty']. "', price = '" . (float) $order_product['price'] . "', total = '" . (float) $order_product['total'] . "', tax = '" . (float) $order_product['tax'] ."', net_amount = '" . (float) $order_product['net_amount'] ."', total_net_amount = '" . (float) $order_product['total_net_amount'] . "', total_tax = '" . (float) $order_product['total_tax'] .  "', tax_format = '" . $this->db->escape($order_product['tax_format']) . "', reward = '" . (int) $order_product['reward'] . "', points ='".$order_product['points']."'");

     $order_product_id = $this->db->getLastId();

     $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p  WHERE p.product_id = '" . (int)$order_product['product_id'] . "'");

     if($product_query->row['promotion']==1){
          $promotion_query = $this->db->query("SELECT pr.promotion_product_id,p.model,pd.name,pr.quantity AS usedqty , pr.weight AS weight,pr.weight_class_id AS weight_class_id FROM  " . DB_PREFIX . "product_promotion pr LEFT JOIN " . DB_PREFIX . "product_description pd ON (pr.promotion_product_id = pd.product_id) LEFT JOIN ". DB_PREFIX ."product p ON (pr.promotion_product_id = p.product_id) WHERE pr.product_id = '" . (int)$order_product['product_id']. "' AND pd.language_id = '" . (int)$this->config->get('config_language_id')."'");


          foreach ($promotion_query->rows as  $product) {
          $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $product['promotion_product_id'] . "', name = '" . $this->db->escape($product['name']) . "', model = '" . $this->db->escape($product['model']) . "', quantity = '" . (int) $order_product['quantity'] ."', weight ='".(float)$product['weight']."', weight_class_id = '".(int)$product['weight_class_id']."', usedqty = '".(int)$product['usedqty']."'");


          $product_weight = $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
          $quntity = ($product_weight*$product['usedqty'])*$order_product['quantity'];

          if ($product_query->row['subtract'] == 1) {
          $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $product['promotion_product_id'] . "' AND store_id =".(int)$data['store_id']);
            }
          }
     }else{

       $product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));
       $quntity = $product_weight*$order_product['quantity'];
        if ($product_query->row['subtract'] == 1) {
       $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $order_product['product_id'] . "' AND store_id =".(int)$data['store_id']);
    }
     }


     if (isset($order_product['order_option'])) {
                    foreach ($order_product['order_option'] as $order_option) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "order_option SET order_id = '" . (int) $order_id . "', order_product_id = '" . (int) $order_product_id . "', product_option_id = '" . (int) $order_option['product_option_id'] . "', product_option_value_id = '" . (int) $order_option['product_option_value_id'] . "', name = '" . $this->db->escape($order_option['name']) . "', `value` = '" . $this->db->escape($order_option['value']) . "', `type` = '" . $this->db->escape($order_option['type']) . "'");

                        $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET quantity = (quantity - " . (int) $order_product['quantity'] . ") WHERE product_option_value_id = '" . (int) $order_option['product_option_value_id'] . "' AND subtract = '1'");
                    }
                }
            }
        }




      //addservice
      if(isset($data['order_service'])){

       foreach ($data['order_service'] as $order_service) {
          $this->db->query("UPDATE " . DB_PREFIX . "service_form SET order_action ='".(int)$data['order_status_id']."', order_id ='".(int)$order_id."', order_invoice_prefix = '".$this->db->escape($invoice_prefix)."' WHERE service_form_id = '" . (int) $order_service['service_id'] . "' AND invoice_prefix ='".$this->db->escape($order_service['invoice_prefix']). "'" );

        }

      }

      // add herbals

     if(isset($data['order_herbals'])){
       $herbal_product = '';
       foreach ($data['order_herbals'] as $order_herbals) {
          $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET order_action ='".(int)$data['order_status_id']."', order_id ='".(int)$order_id."', order_invoice_prefix = '".$this->db->escape($invoice_prefix)."' WHERE clinical_sale_id = '" . (int) $order_herbals['herbal_id'] . "' AND invoice_prefix ='".$this->db->escape($order_herbals['invoice_prefix']). "'" );

        $query = $this->db->query("SELECT cp.t_qty AS quantity,weight,weight_class_id,product_id FROM " . DB_PREFIX . "clinicalsale_product cp WHERE cp.clinical_sale_id = '" . (int)$order_herbals['herbal_id']. "'");
        $herbal_products = $query->rows;

        foreach($herbal_products as $herbal_product){
             $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p  WHERE p.product_id = '" . (int)$herbal_product['product_id'] . "'");

            if ($product_query->row['subtract'] == 1) {
             $product_weight = $this->weight->convert($herbal_product['weight'], $herbal_product['weight_class_id'], $this->config->get('config_weight_class_id'));
             $quntity = $product_weight*$herbal_product['quantity'];

             if ($data['order_status_id'] != '1') {
                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $herbal_product['product_id'] . "' AND store_id =".(int)$data['store_id']);
             }             
            }
         }

        }

      }

    // Add Brewing
    if (isset($data['order_brewing'])) {
        $brewing_product = '';
        foreach ($data['order_brewing'] as $order_brewing) {
            $this->db->query("UPDATE `" . DB_PREFIX . "herbal_transfer` SET payment_status = '" . (int)$data['order_status_id'] . "', order_id = '" . (int)$order_id . "', order_invoice_prefix = '" . $this->db->escape($invoice_prefix). "' WHERE herbal_transfer_id = '" . (int)$order_brewing['brewing_id'] . "' AND tranfer_invoice = '" . $this->db->escape($order_brewing['invoice_prefix']) . "'");
            $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$order_brewing['brewing_id'] . "'");
            $brewing_products = $query->rows;
            foreach ($brewing_products as $brewing_product) {
                $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_product['product_id'] . "'");
                if ($product_query->row['subtract'] == 1) {
                    $product_weight = $this->weight->convert($brewing_product['weight'], $brewing_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                    $quantity = $product_weight * $brewing_product['quantity'];
                    $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity - " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                }
            }
        }
    }

       //Add Brewing Order
      if (isset($data['order_brewing_order'])) {
            $brewing_order_product = '';
            foreach ($data['order_brewing_order'] as $order_brewing_order) {
                $this->db->query("UPDATE `" . DB_PREFIX . "herbal_transfer` SET payment_status = '" . (int)$data['order_status_id'] . "', order_id = '" . (int)$order_id . "', order_invoice_prefix = '" . $this->db->escape($data['invoice_prefix']). "' WHERE herbal_transfer_id = '" . (int)$order_brewing_order['brewing_id'] . "' AND tranfer_invoice = '" . $this->db->escape($order_brewing_order['invoice_prefix']) . "'");
                $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$order_brewing_order['brewing_id'] . "'");
                $brewing_order_products = $query->rows;
                foreach ($brewing_order_products as $brewing_order_product) {
                    $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_order_product['product_id'] . "'");
                    if ($product_query->row['subtract'] == 1) {
                        $product_weight = $this->weight->convert($brewing_order_product['weight'], $brewing_order_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $brewing_order_product['quantity'];
                        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity - " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_order_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                    }
                }
            }
        }


      //add payment
      $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payments SET order_id = '" . (int) $order_id ."', card_no ='" . $this->db->escape($data['card_no']) .  "', customer_id = '" . (int)$data['customer_id']. "', invoice = '" .$this->db->escape($invoice_prefix) . "', description = '" .$this->db->escape($data['payment_method']) . "', amount = '" .$data['payment']['total']."', date_added = NOW()");

     if($data['payment']['credit']){
        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_transaction SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($invoice_prefix). "', amount = '" .-$data['payment']['total']."', date_added = NOW()");
     }

      if($data['payment']['points']){
       $this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($invoice_prefix). "', points = '" .-$data['payment']['total']."', date_added = NOW()");
     }

     if($data['customer_id'] !=0 && $data['order_status_id'] == 5 && $data['payment_method'] != 'Points' ){
         $this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($invoice_prefix). "', points = '" .$data['reward']."', date_added = NOW()");
     }


     if($data['shipping_detail']){
       $this->db->query("INSERT INTO " . DB_PREFIX . "shipping_transaction SET order_id = '".(int) $order_id ."',title = '".$this->db->escape($data['shipping_detail']['title']). "',code = '" .$this->db->escape($data['shipping_detail']['code']). "', cost = '" .$data['shipping_detail']['cost']."', tax_class_id ='".$data['shipping_detail']['tax_class_id']. "', tax ='".$data['shipping_detail']['tax']."', total='".$data['shipping_detail']['total']."', date_added = NOW() ,modifi_by='".(int)$this->session->data['user_id']."'");
     }




        // Vouchers
        if (isset($data['vouchers'])) {
            foreach ($data['vouchers'] as $voucher) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_voucher SET order_id = '" . (int)$order_id . "', description = '" . $this->db->escape($voucher['description']) . "', code = '" . $this->db->escape($voucher['code']) . "', from_name = '" . $this->db->escape($voucher['from_name']) . "', from_email = '" . $this->db->escape($voucher['from_email']) . "', to_name = '" . $this->db->escape($voucher['to_name']) . "', to_email = '" . $this->db->escape($voucher['to_email']) . "', voucher_theme_id = '" . (int)$voucher['voucher_theme_id'] . "', message = '" . $this->db->escape($voucher['message']) . "', amount = '" . (float)$voucher['amount'] . "'");
                $order_voucher_id = $this->db->getLastId();
                $voucher_id = $this->model_checkout_voucher->addVoucher($order_id, $voucher);
                $this->db->query("UPDATE " . DB_PREFIX . "order_voucher SET voucher_id = '" . (int)$voucher_id . "' WHERE order_voucher_id = '" . (int)$order_voucher_id . "'");
            }
        }

        // Get the total
        $total = 0;
        
        if (!empty($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = '" . $this->db->escape($order_total['code']). "',tax_key ='".(int) $order_total['key']."', tax_code = '" . $this->db->escape($order_total['tax_code']) . "', title = '" . $this->db->escape($order_total['title']) . "',  `value` = '" . (float) $order_total['value'] . "', sort_order = '" . (int) $order_total['sort_order'] . "'");
            }

            $total += $order_total['value'];
        }

        // Affiliate
        $affiliate_id = 0;
        $commission = 0;

        if (!empty($this->request->post['affiliate_id'])) {
            $affiliate_id = (int) $this->request->post['affiliate_id'];
        }

        if ($affiliate_id > 0) {
            $this->load->model('sale/affiliate');

            $affiliate_info = $this->model_sale_affiliate->getAffiliate($affiliate_id);

            if ($affiliate_info) {
                $commission = ($total / 100) * $affiliate_info['commission'];
            }
        }

        // Update order total
        $this->db->query("UPDATE `" . DB_PREFIX . "order` SET user_id = '" . $this->user->getId() . "', total = '" . (float) $total . "', shipping_total ='".(float)$data['shipping_total']."', affiliate_id = '" . (int) $affiliate_id . "', commission = '" . (float) $commission . "' WHERE order_id = '" . (int) $order_id . "'");

        if($order_id !=0){
          $this->load->controller('setting/transaction_no/setTransactionNo',array('module'=>'pos/pos','store'=>$data['store_id']));
        }

        return $order_id;
    }

    public function editOrder($order_id, $data) {
        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $country_info = $this->model_localisation_country->getCountry($data['shipping_country_id']);

        if ($country_info) {
            $shipping_country = $country_info['name'];
            $shipping_address_format = $country_info['address_format'];
        } else {
            $shipping_country = '';
            $shipping_address_format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }

        $zone_info = $this->model_localisation_zone->getZone($data['shipping_zone_id']);

        if ($zone_info) {
            $shipping_zone = $zone_info['name'];
        } else {
            $shipping_zone = '';
        }

        $country_info = $this->model_localisation_country->getCountry($data['payment_country_id']);

        if ($country_info) {
            $payment_country = $country_info['name'];
            $payment_address_format = $country_info['address_format'];
        } else {
            $payment_country = '';
            $payment_address_format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
        }

        $zone_info = $this->model_localisation_zone->getZone($data['payment_zone_id']);

        if ($zone_info) {
            $payment_zone = $zone_info['name'];
        } else {
            $payment_zone = '';
        }
        
        //Restock service before subtracting the service
        $service_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "service_form` WHERE order_action > '0' AND order_id = '" . (int) $order_id . "'");

         foreach ($service_query->rows as $service) {
           $this->db->query("UPDATE " . DB_PREFIX . "service_form SET order_id ='0',order_action='17',order_invoice_prefix ='' WHERE order_id = '" . (int)     $order_id. "'");
         }

        // Add Brewing
        $brewing_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` WHERE payment_status > '0' AND order_id = '" . (int)$order_id . "'");
        foreach ($brewing_query->rows as $brewing) {
            $this->db->query("UPDATE " . DB_PREFIX . "herbal_transfer SET order_id = '0', payment_status = '17', order_invoice_prefix = '' WHERE order_id = '" . (int)$order_id . "'");
            $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$brewing['herbal_transfer_id'] . "'");
                $brewing_products = $query->rows;
            foreach ($brewing_products as $brewing_product) {
                    $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_product['product_id'] . "'");
                if ($product_query->row['subtract'] == 1) {
                        $product_weight = $this->weight->convert($brewing_product['weight'], $brewing_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $brewing_product['quantity'];
                        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity + " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                }
            }
        }

        //Brewing Order
        $brewing_order_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` WHERE payment_status <> '17' AND order_id = '" . (int)$order_id . "'");
        foreach ($brewing_order_query->rows as $brewing_order) {
            $this->db->query("UPDATE " . DB_PREFIX . "herbal_transfer SET order_id = '0', payment_status = '17', order_invoice_prefix = '' WHERE order_id = '" . (int)$order_id . "'");
            $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$brewing_order['herbal_transfer_id'] . "'");
                $brewing_order_products = $query->rows;
            foreach ($brewing_order_products as $brewing_order_product) {
                    $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_order_product['product_id'] . "'");
                if ($product_query->row['subtract'] == 1) {
                        $product_weight = $this->weight->convert($brewing_order_product['weight'], $brewing_order_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $brewing_order_product['quantity'];
                        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity + " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_order_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                }
            }
        }


        $this->db->query("UPDATE `" . DB_PREFIX . "order` SET customer_id='".$this->db->escape($data['customer_id'])."', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', fax = '" . $this->db->escape($data['fax']) . "', payment_firstname = '" . $this->db->escape($data['payment_firstname']) . "', payment_lastname = '" . $this->db->escape($data['payment_lastname']) . "', payment_company = '" . $this->db->escape($data['payment_company']) . "', payment_address_1 = '" . $this->db->escape($data['payment_address_1']) . "', payment_address_2 = '" . $this->db->escape($data['payment_address_2']) . "', payment_address_3 = '" . $this->db->escape($data['payment_address_3']) .  "', payment_city = '" . $this->db->escape($data['payment_city']) . "', payment_postcode = '" . $this->db->escape($data['payment_postcode']) . "', payment_country = '" . $this->db->escape($payment_country) . "', payment_country_id = '" . (int) $data['payment_country_id'] . "', payment_zone = '" . $this->db->escape($payment_zone) . "', payment_zone_id = '" . (int) $data['payment_zone_id'] . "', payment_address_format = '" . $this->db->escape($payment_address_format) . "', payment_method = '" . $this->db->escape($data['payment_name']) . "', payment_code = '" . $this->db->escape($data['payment_code']) ."',shipping_address_id ='".(int)$data['shipping_address_id'] . "', shipping_firstname = '" . $this->db->escape($data['shipping_firstname']) . "', shipping_lastname = '" . $this->db->escape($data['shipping_lastname']) . "',  shipping_company = '" . $this->db->escape($data['shipping_company']) . "', shipping_address_1 = '" . $this->db->escape($data['shipping_address_1']) . "', shipping_address_2 = '" . $this->db->escape($data['shipping_address_2']) . "', shipping_address_3 = '" . $this->db->escape($data['shipping_address_3']) . "', shipping_city = '" . $this->db->escape($data['shipping_city']) . "', shipping_postcode = '" . $this->db->escape($data['shipping_postcode']) . "', shipping_country = '" . $this->db->escape($shipping_country) . "', shipping_country_id = '" . (int) $data['shipping_country_id'] . "', shipping_zone = '" . $this->db->escape($shipping_zone) . "', shipping_zone_id = '" . (int) $data['shipping_zone_id'] . "', shipping_address_format = '" . $this->db->escape($shipping_address_format) . "', shipping_method = '" . $this->db->escape($data['shipping_method']) . "', shipping_code = '" . $this->db->escape($data['shipping_code']) . "', comment = '" . $this->db->escape($data['comment']) . "', order_status_id = '" . (int) $data['order_status_id'] . "', affiliate_id  = '" . (int) $data['affiliate_id'] ."',modifi_by='".(int)$this->session->data['user_id']."', date_modified = NOW() WHERE order_id = '" . (int) $order_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "order_product WHERE order_id = '" . (int) $order_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "order_option WHERE order_id = '" . (int) $order_id . "'");



        if (isset($data['order_product'])) {
            foreach ($data['order_product'] as $order_product) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $order_product['product_id'] . "', name = '" . $this->db->escape($order_product['name']) . "', model = '" . $this->db->escape($order_product['model']) . "', quantity = '" . (int) $order_product['quantity']."', tax_class_id ='".(int)$order_product['tax_class_id'] ."', tax_code ='".$this->db->escape($order_product['tax_code']) ."', weight ='".(float)$order_product['weight']."' ,weight_class_id = '".(int)$order_product['weight_class_id']."', usedqty ='".(int)$order_product['usedqty']. "', price = '" . (float) $order_product['price'] . "', total = '" . (float) $order_product['total'] . "', tax = '" . (float) $order_product['tax']. "', net_amount = '" . (float) $order_product['net_amount'] ."', total_net_amount = '" . (float) $order_product['total_net_amount'] . "', total_tax = '" . (float) $order_product['total_tax'] .  "', tax_format = '" . $this->db->escape($order_product['tax_format']) . "', reward = '" . (int) $order_product['reward'] . "'");

     $order_product_id = $this->db->getLastId();

     $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p  WHERE p.product_id = '" . (int)$order_product['product_id'] . "'");

     if($product_query->row['promotion']==1){

          $promotion_query = $this->db->query("SELECT pr.promotion_product_id,p.model,pd.name,pr.quantity AS usedqty , pr.weight AS weight,pr.weight_class_id AS weight_class_id FROM  " . DB_PREFIX . "product_promotion pr LEFT JOIN " . DB_PREFIX . "product_description pd ON (pr.promotion_product_id = pd.product_id) LEFT JOIN ". DB_PREFIX ."product p ON (pr.promotion_product_id = p.product_id) WHERE pr.product_id = '" . (int)$order_product['product_id']. "' AND pd.language_id = '" . (int)$this->config->get('config_language_id')."'");

          foreach ($promotion_query->rows as  $product) {
          $this->db->query("INSERT INTO " . DB_PREFIX . "order_product SET order_id = '" . (int) $order_id . "', product_id = '" . (int) $product['promotion_product_id'] . "', name = '" . $this->db->escape($product['name']) . "', model = '" . $this->db->escape($product['model']) . "', quantity = '" . (int) $order_product['quantity'] ."', weight ='".(float)$product['weight']."', weight_class_id = '".(int)$product['weight_class_id']."', usedqty = '".(int)$product['usedqty']."'");


          $product_weight = $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
          $quntity = ($product_weight*$product['usedqty'])*$order_product['quantity'];

          $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $product['promotion_product_id'] . "' AND store_id =".(int)$data['store_id']);
          }
     }else{

       $product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));
       $quntity = $product_weight*$order_product['quantity'];
       $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $order_product['product_id'] . "' AND store_id =".(int)$data['store_id']);

     }

      if (isset($order_product['order_option'])) {
                    foreach ($order_product['order_option'] as $order_option) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "order_option SET order_id = '" . (int) $order_id . "', order_product_id = '" . (int) $order_product_id . "', product_option_id = '" . (int) $order_option['product_option_id'] . "', product_option_value_id = '" . (int) $order_option['product_option_value_id'] . "', name = '" . $this->db->escape($order_option['name']) . "', `value` = '" . $this->db->escape($order_option['value']) . "', `type` = '" . $this->db->escape($order_option['type']) . "'");

                        $this->db->query("UPDATE " . DB_PREFIX . "product_option_value SET quantity = (quantity - " . (int) $order_product['quantity'] . ") WHERE product_option_value_id = '" . (int) $order_option['product_option_value_id'] . "' AND subtract = '1'");
                    }
                }
            }
        }

         //addservice

       if(isset($data['order_service'])){

       foreach ($data['order_service'] as $order_service) {
          $this->db->query("UPDATE " . DB_PREFIX . "service_form SET order_action ='".(int)$data['order_status_id']."', order_id ='".(int)$order_id."', order_invoice_prefix ='". $this->db->escape($data['invoice_prefix']) ."' WHERE service_form_id = '" . (int) $order_service['service_id'] . "' AND invoice_prefix ='".$this->db->escape($order_service['invoice_prefix']). "'" );

        }

      }

     // add herbals
     if(isset($data['order_herbals'])){
       foreach ($data['order_herbals'] as $order_herbals) {
          $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET order_action ='".(int)$data['order_status_id']."', order_id ='".(int)$order_id."', order_invoice_prefix = '".$this->db->escape($data['invoice_prefix'])."' WHERE clinical_sale_id = '" . (int) $order_herbals['herbal_id'] . "' AND invoice_prefix ='".$this->db->escape($order_herbals['invoice_prefix']). "'" );

         $query = $this->db->query("SELECT cp.t_qty AS quantity,weight,weight_class_id,product_id FROM " . DB_PREFIX . "clinicalsale_product cp WHERE cp.clinical_sale_id = '" . (int)$order_herbals['herbal_id']. "'");
         $herbal_products = $query->rows;

         foreach($herbal_products as $herbal_product){

         $product_weight = $this->weight->convert($herbal_product['weight'], $herbal_product['weight_class_id'], $this->config->get('config_weight_class_id'));
         $quntity = $product_weight*$herbal_product['quantity'];
            if ($data['order_status_id'] != '1') {
                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity - " .(float)$quntity. ") WHERE product_id = '" . (int) $herbal_product['product_id'] . "' AND store_id =".(int)$data['store_id']);
            }
        }

        }

      }

      //Add Brewing
      if (isset($data['order_brewing'])) {
            $brewing_product = '';
            foreach ($data['order_brewing'] as $order_brewing) {
                $this->db->query("UPDATE `" . DB_PREFIX . "herbal_transfer` SET payment_status = '" . (int)$data['order_status_id'] . "', order_id = '" . (int)$order_id . "', order_invoice_prefix = '" . $this->db->escape($data['invoice_prefix']). "' WHERE herbal_transfer_id = '" . (int)$order_brewing['brewing_id'] . "' AND tranfer_invoice = '" . $this->db->escape($order_brewing['invoice_prefix']) . "'");
                $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$order_brewing['brewing_id'] . "'");
                $brewing_products = $query->rows;
                foreach ($brewing_products as $brewing_product) {
                    $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_product['product_id'] . "'");
                    if ($product_query->row['subtract'] == 1) {
                        $product_weight = $this->weight->convert($brewing_product['weight'], $brewing_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $brewing_product['quantity'];
                        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity - " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                    }
                }
            }
        }


        //Add Brewing Order
      if (isset($data['order_brewing_order'])) {
            $brewing_product = '';
            foreach ($data['order_brewing_order'] as $order_brewing_order) {
                $this->db->query("UPDATE `" . DB_PREFIX . "herbal_transfer` SET payment_status = '" . (int)$data['order_status_id'] . "', order_id = '" . (int)$order_id . "', order_invoice_prefix = '" . $this->db->escape($data['invoice_prefix']). "' WHERE herbal_transfer_id = '" . (int)$order_brewing_order['brewing_id'] . "' AND tranfer_invoice = '" . $this->db->escape($order_brewing_order['invoice_prefix']) . "'");
                $query = $this->db->query("SELECT htp.t_qty AS quantity, weight, weight_class_id, product_id FROM `" . DB_PREFIX . "herbal_transfer_product` htp WHERE htp.herbal_transfer_id = '" . (int)$order_brewing_order['brewing_id'] . "'");
                $brewing_order_products = $query->rows;
                foreach ($brewing_order_products as $brewing_order_product) {
                    $product_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p WHERE p.product_id = '" . (int)$brewing_order_product['product_id'] . "'");
                    if ($product_query->row['subtract'] == 1) {
                        $product_weight = $this->weight->convert($brewing_order_product['weight'], $brewing_order_product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $brewing_order_product['quantity'];
                        $this->db->query("UPDATE `" . DB_PREFIX . "product_to_store` SET onhand_quantity = (onhand_quantity - " .(float)$quantity .") WHERE product_id = '" . (int)$brewing_order_product['product_id'] . "' AND store_id = '" . (int)$data['store_id'] . "'");
                    }
                }
            }
        }


      //payment and shipping

     $this->db->query("DELETE FROM " . DB_PREFIX . "customer_payments WHERE order_id = '" . (int) $order_id . "'");
     $this->db->query("DELETE FROM " . DB_PREFIX . "customer_transaction WHERE order_id = '" . (int) $order_id . "'");
     $this->db->query("DELETE FROM " . DB_PREFIX . "customer_reward WHERE order_id = '" . (int) $order_id . "'");
     $this->db->query("DELETE FROM " . DB_PREFIX . "shipping_transaction WHERE order_id = '" . (int) $order_id . "'");

     $this->db->query("INSERT INTO " . DB_PREFIX . "customer_payments SET order_id = '" . (int) $order_id ."', card_no ='" . $this->db->escape($data['card_no']) . "', customer_id = '" . (int)$data['customer_id']. "', invoice = '" .$this->db->escape($data['invoice_prefix']) . "', description = '" .$this->db->escape($data['payment_method']) . "', amount = '" .$data['payment']['total']."', date_added = NOW()");

     if($data['payment']['credit']){
        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_transaction SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($data['invoice_prefix']). "', amount = '" .-$data['payment']['total']."', date_added = NOW()");
     }

      if($data['payment']['points']){
        $this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($data['invoice_prefix']). "', points = '" .-$data['payment']['total']."', date_added = NOW()");
     }

     if($data['customer_id'] !=0 && $data['order_status_id'] == 5 && $data['payment_method'] != 'Points'){
         $this->db->query("INSERT INTO " . DB_PREFIX . "customer_reward SET order_id = '" . (int) $order_id . "', customer_id = '" . (int)$data['customer_id']. "',description = '" .$this->db->escape($data['invoice_prefix']). "', points = '" .$data['reward']."', date_added = NOW()");
     }

      if($data['shipping_detail']){
       $this->db->query("INSERT INTO " . DB_PREFIX . "shipping_transaction SET order_id = '".(int) $order_id ."',title = '".$this->db->escape($data['shipping_detail']['title']). "',code = '" .$this->db->escape($data['shipping_detail']['code']). "', cost = '" .$data['shipping_detail']['cost']."', tax_class_id ='".$data['shipping_detail']['tax_class_id']. "', tax ='".$data['shipping_detail']['tax']."', total='".$data['shipping_detail']['total']."', date_added = NOW() ,modifi_by='".(int)$this->session->data['user_id']."'");
     }

        $this->db->query("DELETE FROM " . DB_PREFIX . "order_voucher WHERE order_id = '" . (int) $order_id . "'");

        // Vouchers
        if (isset($data['vouchers'])) {
            foreach ($data['vouchers'] as $voucher) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_voucher SET order_id = '" . (int)$order_id . "', description = '" . $this->db->escape($voucher['description']) . "', code = '" . $this->db->escape($voucher['code']) . "', from_name = '" . $this->db->escape($voucher['from_name']) . "', from_email = '" . $this->db->escape($voucher['from_email']) . "', to_name = '" . $this->db->escape($voucher['to_name']) . "', to_email = '" . $this->db->escape($voucher['to_email']) . "', voucher_theme_id = '" . (int)$voucher['voucher_theme_id'] . "', message = '" . $this->db->escape($voucher['message']) . "', amount = '" . (float)$voucher['amount'] . "'");
                $order_voucher_id = $this->db->getLastId();
                $voucher_id = $this->model_checkout_voucher->addVoucher($order_id, $voucher);
                $this->db->query("UPDATE " . DB_PREFIX . "order_voucher SET voucher_id = '" . (int)$voucher_id . "' WHERE order_voucher_id = '" . (int)$order_voucher_id . "'");
            }
        }

        // Get the total
        $total = 0;
        $this->db->query("DELETE FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int) $order_id . "'");

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $order_id . "', code = '" . $this->db->escape($order_total['code']). "', tax_key ='".(int) $order_total['key']. "', tax_code = '" . $this->db->escape($order_total['tax_code']) . "', title = '" . $this->db->escape($order_total['title']) . "', `value` = '" . (float) $order_total['value'] . "', sort_order = '" . (int) $order_total['sort_order'] . "'");
            }

            $total += $order_total['value'];
        }

        // Affiliate
        $affiliate_id = 0;
        $commission = 0;

        if (!empty($this->request->post['affiliate_id'])) {
            $affiliate_id = (int) $this->request->post['affiliate_id'];
        }

        if ($affiliate_id > 0) {
            $this->load->model('sale/affiliate');

            $affiliate_info = $this->model_sale_affiliate->getAffiliate($affiliate_id);

            if ($affiliate_info) {
                $commission = ($total / 100) * $affiliate_info['commission'];
            }
        }

        // Update order total
        $this->db->query("UPDATE `" . DB_PREFIX . "order` SET user_id = '" . $this->user->getId() . "', total = '" . (float) $total . "', shipping_total ='".(float)$data['shipping_total']. "', affiliate_id = '" . (int) $affiliate_id . "', commission = '" . (float) $commission . "' WHERE order_id = '" . (int) $order_id . "'");

        return $order_id;
    }

    // add for Browse begin
    public function getTopCategories() {
            // get top categories
            $query = $this->db->query("SELECT c.image, c.category_id, c.parent_id, cd.name FROM `" . DB_PREFIX . "category` c LEFT JOIN " . DB_PREFIX . "category_to_store c2s ON (c.category_id = c2s.category_id) LEFT JOIN `" . DB_PREFIX . "category_description` cd ON c.category_id = cd.category_id WHERE c.parent_id = 0 and cd.language_id = '". (int)$this->config->get('config_language_id') . "' AND c2s.store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY c.sort_order, LCASE(cd.name)");
            return $query->rows;
    }

    public function getCategories() {
            // get all categories
            $query = $this->db->query("SELECT c.image, c.category_id, c.parent_id, cd.name FROM `" . DB_PREFIX . "category` c LEFT JOIN " . DB_PREFIX . "category_to_store c2s ON (c.category_id = c2s.category_id) LEFT JOIN `" . DB_PREFIX . "category_description` cd ON c.category_id = cd.category_id WHERE c2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND cd.language_id = '". (int)$this->config->get('config_language_id') . "'");
            return $query->rows;
    }

    public function getSubCategories($category_id) {
            // get all sub categories under the given category
            $query = $this->db->query("SELECT c.category_id, c.image, cd.name FROM `" . DB_PREFIX . "category` c LEFT JOIN " . DB_PREFIX . "category_to_store c2s ON (c.category_id = c2s.category_id) LEFT JOIN `" . DB_PREFIX . "category_description` cd ON c.category_id = cd.category_id WHERE c2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND cd.language_id = '". (int)$this->config->get('config_language_id') . "' AND c.parent_id = '" . $category_id . "'");
            return $query->rows;
    }

    public function getProductByBarcode($barcode) {
            // get all products in the given category
            $query = $this->db->query("SELECT p.product_id, GROUP_CONCAT(po.option_id) as options from `" . DB_PREFIX . "product` p LEFT JOIN `" . DB_PREFIX . "product_option` po ON p.product_id = po.product_id  LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND p.isbn = '" . $barcode . "'");
            return $query->row;
    }

    public function total_products($category_id) {
        // get all products in the given category
        $query = $this->db->query("SELECT count(p.product_id) as total FROM `" . DB_PREFIX . "product_to_category` pc LEFT JOIN `" . DB_PREFIX . "product` p ON pc.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN `" . DB_PREFIX . "product_description` pd ON p.product_id = pd.product_id WHERE p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND pd.language_id = '". (int)$this->config->get('config_language_id') . "' AND pc.category_id = '" . $category_id . "' AND p.internal_status = '1' AND p.quantity >= 0  AND p.selling_product = 1");
        $result = $query->row;
        return $result['total'];
    }

    public function getProducts($category_id, $limit = 20, $offset = 0) {
        // get all products in the given category
        $query = $this->db->query("SELECT p.product_id, p.price, p.quantity, p.image, pd.name, GROUP_CONCAT(po.option_id) as options FROM `" . DB_PREFIX . "product_to_category` pc LEFT JOIN `" . DB_PREFIX . "product` p ON pc.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN `" . DB_PREFIX . "product_description` pd ON p.product_id = pd.product_id LEFT JOIN `" . DB_PREFIX . "product_option` po ON p.product_id = po.product_id WHERE pd.language_id = '". (int)$this->config->get('config_language_id') . "' AND p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND pc.category_id = '" . $category_id . "'  AND p.internal_status = '1'  AND p.selling_product = 1 GROUP BY p.product_id ORDER BY pd.name ASC LIMIT ".$offset.", ".$limit);
        return $query->rows;
    }


    public function getProductByCode($product_code) {
        // get all product By Code
      $query = $this->db->query("SELECT p.product_id, GROUP_CONCAT(po.option_id) as options from `" . DB_PREFIX . "product` p LEFT JOIN `" . DB_PREFIX . "product_option` po ON p.product_id = po.product_id  LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) WHERE p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND p.selling_product = 1 AND p.internal_status = '1' AND p.code = '" . $product_code . "'");
        return $query->rows;
    }



    public function total_search_products($q){
        // get all products in the given category
        $query = $this->db->query("SELECT count( p.product_id ) AS total from `" . DB_PREFIX . "product` p LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN `" . DB_PREFIX . "product_description` pd ON p.product_id = pd.product_id WHERE p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND pd.language_id = '". (int)$this->config->get('config_language_id') . "'  AND pd.name like '%".$q."%' AND p.status = '1' AND p.quantity > 0");
        $result= $query->row;
        return $result['total'];
    }

    public function searchProducts($q, $limit = 20, $offset = 0){
        // get all products in the given category
        $query = $this->db->query("SELECT p.product_id, p.price, p.quantity, p.image, pd.name, GROUP_CONCAT(po.option_id) as options FROM `" . DB_PREFIX . "product_to_category` pc LEFT JOIN `" . DB_PREFIX . "product` p ON pc.product_id = p.product_id LEFT JOIN " . DB_PREFIX . "product_to_store p2s ON (p.product_id = p2s.product_id) LEFT JOIN `" . DB_PREFIX . "product_description` pd ON p.product_id = pd.product_id LEFT JOIN `" . DB_PREFIX . "product_option` po ON p.product_id = po.product_id WHERE p2s.store_id = '" . (int)$this->session->data['store_id'] . "' AND pd.language_id = '". (int)$this->config->get('config_language_id') . "'  AND pd.name like '%".$q."%' AND p.internal_status = '1' GROUP BY p.product_id LIMIT ".$offset.", ".$limit);
        return $query->rows;
    }

    public function getCustomer($customer_id) {
        //search customer by name
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer`  WHERE customer_id = '" . $customer_id . "'");
        return $query->row;
    }

    public function searchCustomer($q) {
        //search customer by name
        $query = $this->db->query("SELECT c.firstname, c.lastname, c.customer_id FROM `" . DB_PREFIX . "customer` c WHERE c.firstname like '%" . $q . "%' or c.lastname like '%" . $q . "%'");
        return $query->rows;
    }

    public function getStatistics() {
        $query = $this->db->query("select user_id, username, firstname, lastname, cash, card from " . DB_PREFIX . "user");
        return $query->rows;
    }

    public function withdraw($data) {
        //user_id, amount
        //1) insert into oc_pos_withdraw
        //2) cash = cash - amount on user
        $this->db->query("insert into `" . DB_PREFIX . "pos_withdraw` set pos_withdraw_id = '', user_id ='" . $data['user_id'] . "', amount= '" . $data['amount'] . "', date = NOW()");
        $this->db->query("update `" . DB_PREFIX . "user` set cash = cash - " . $data['amount'] . " where user_id = '" . $data['user_id'] . "'");
    }

    public function total_history($user_id) {
        $query = $this->db->query("select count(*) as total from `" . DB_PREFIX . "pos_withdraw` pw left join `" . DB_PREFIX . "user` u on pw.user_id = u.user_id where pw.user_id='" . $user_id . "'");
        $row = $query->row;
        return $row['total'];
    }

    public function history($user_id, $limit = 10, $offset = 0) {
        $query = $this->db->query("select u.username, u.firstname, u.lastname, pw.* from `" . DB_PREFIX . "pos_withdraw` pw left join `" . DB_PREFIX . "user` u on pw.user_id = u.user_id where pw.user_id='" . $user_id . "' ORDER BY pw.date DESC LIMIT " . $offset . ", " . $limit);
        return $query->rows;
    }

    public function hold_cart($data) {
        $this->db->query("insert into `" . DB_PREFIX . "cart_holder` set cart_holder_id = '', user_id ='" . $data['user_id'] . "', name= '" . $data['name'] . "', cart = '" . serialize($data['cart']) . "', date_created = NOW()");
        return $this->db->getLastId();
    }

    public function get_hold_cart_list() {
        $query = $this->db->query('select cart_holder_id, name, date_created from `' . DB_PREFIX . 'cart_holder` where user_id = "' . $this->user->getId() . '"');
        return $query->rows;
    }

    public function hold_cart_select($id) {
        $query = $this->db->query('SELECT * FROM `' . DB_PREFIX . 'cart_holder` WHERE cart_holder_id="' . $id . '"');
        return $query->row;
    }

    public function hold_cart_delete($id) {
        $this->db->query('DELETE FROM `' . DB_PREFIX . 'cart_holder` WHERE cart_holder_id="' . $id . '"');
    }

    public function get_today_card($user_id) {
        $query = $this->db->query('SELECT sum(total) as total FROM `' . DB_PREFIX . 'order` WHERE user_id="' . $user_id . '" AND payment_method="Card" AND DATE(date_added) = DATE(NOW())');
        $row = $query->row;
        return $row['total'];
    }

    public function get_today_cash($user_id) {
        $query = $this->db->query('SELECT sum(total) as total FROM `' . DB_PREFIX . 'order` WHERE user_id="' . $user_id . '" AND payment_method="Cash" AND DATE(date_added) = DATE(NOW())');
        $row = $query->row;
        return $row['total'];
    }

    public function get_user_balance($user_id) {
        $query = $this->db->query('SELECT cash, card FROM `' . DB_PREFIX . 'user` WHERE user_id="' . $user_id . '"');
        return $query->row;
    }


    //add member tines

    public function getTotalAmount($customer_id) {
        $query = $this->db->query("SELECT SUM(amount) AS total FROM `" . DB_PREFIX . "customer_transaction` WHERE customer_id = '" . (int)$customer_id . "' GROUP BY customer_id");

        if ($query->num_rows) {
            return $query->row['total'];
        } else {
            return 0;
        }
    }

    public function getTotalReward($customer_id) {
        $query = $this->db->query("SELECT SUM(points) AS points FROM `" . DB_PREFIX . "customer_reward` WHERE customer_id = '" . (int)$customer_id . "' GROUP BY customer_id");

        if ($query->num_rows) {
            return $query->row['points'];
        } else {
            return 0;
        }
    }

    public function getShippingMethod($order_id){
        $query = $this->db->query("SELECT code FROM `" . DB_PREFIX . "shipping_transaction` WHERE order_id = '" . (int)$order_id . "'");
        if ($query->num_rows) {
            return $query->row['code'];
        } else {
            return 0;
        }

    }

    public function getShippingId($order_id){
        $query = $this->db->query("SELECT shipping_address_id FROM `" . DB_PREFIX . "order` WHERE order_id = '" . (int)$order_id . "'");
        if ($query->num_rows) {
            return $query->row['shipping_address_id'];
        } else {
            return 0;
        }

    }

    public function getPayment($order_id){
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_payments` WHERE order_id = '" . (int)$order_id . "'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }
    }


    //get service tines

    public function getServices($customer_id){
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "service_form` WHERE customer_id = '" . (int)$customer_id . "' AND serviceform_action ='".(int)5 ."' AND order_action = '".(int)17 ."' AND store_id ='".(int)$this->session->data['store_id']."'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }

    }

    public function getServicesByServiceId($service_id){
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "service_form` WHERE service_form_id = '" . (int)$service_id . "' AND serviceform_action ='".(int)5 ."' AND order_action = '".(int)17 ."' AND store_id ='".(int)$this->session->data['store_id']."'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }

    }

    public function getAllItemsByFilterData($data) {
        $sql = "SELECT * FROM(
                    #herbal remedies clinical sale data
                    SELECT cs.clinical_sale_id as id, cs.invoice_prefix AS invoice_prefix, cs.date_added AS date_added, cs.date_modified AS date_modified , cs.total_d_gst AS total, c.customer_id AS customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer_name, c.customer_ic AS customer_ic, 1 AS type, 'clinical_sale' AS item_type, cs.store_id AS store_id  FROM  `" . DB_PREFIX . "clinical_sale` cs
                    LEFT JOIN `" . DB_PREFIX . "customer` c ON cs.customer_id = c.customer_id
                    WHERE 1 AND cs.clinicalsale_action = 5 AND cs.order_action = 17 AND cs.store_id = '" . $this->session->data['store_id'] . "'

                    UNION ALL

                    #service form data
                    SELECT sf.service_form_id as id, sf.invoice_prefix AS invoice_prefix, sf.date_added AS date_added, sf.date_modified AS date_modified, sf.total_price AS total, c.customer_id AS customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer_name, c.customer_ic AS customer_ic, 2 AS type, 'service' AS item_type, sf.store_id AS store_id FROM `" . DB_PREFIX . "service_form` sf
                    LEFT JOIN `" . DB_PREFIX . "customer` c ON sf.customer_id = c.customer_id
                    WHERE 1 AND sf.serviceform_action = 5 AND sf.order_action = 17 AND sf.store_id = '" . $this->session->data['store_id'] . "'
                ) a WHERE 1 " ;
         $sort_data = array(
            'a.date_added',
            'a.invoice_prefix',
            'a.date_modified',
            'a.customer_name',
            'a.customer_ic',
            'a.total',
        );
        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND a.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'" ;
        }
        if (isset($data['filter_total'])) {
            $sql .= " AND a.total LIKE '%" .  (float)$data['filter_total'] . "%'" ;
        }
        if (!empty($data['filter_customer_name'])) {
            $sql .= " AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" ;
        }
        if (!empty($data['filter_customer_ic'])) {
            $sql .= " AND a.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" ;
        }
        if (!empty($data['filter_date_added'])) {
            $sql .= " AND a.date_added LIKE '%" . $this->db->escape($data['filter_date_added']) . "%'" ;
        }
        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND a.date_modified LIKE '%" . $this->db->escape($data['filter_date_modified']) . "%'" ;
        }
        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.date_added) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }
        if (!empty($data['filter_type'])) {
            $sql .= " AND a.type = " . (int)$data['filter_type'] ;
        }
        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY a.date_added ";
        }
        if (isset($data['order']) && $data['order'] == 'DESC') {
            $sql .= " DESC ";
        } else {
            $sql .= " ASC ";
        }
        if (isset($data['start']) || isset($data['limit'])) {
            //start
            if ($data['start'] < 0) {
                $data['start'] = 0 ;
            }
            //limit
            if ($data['limit'] < 1) {
                $data['limit'] = 5 ;
            }
            $sql .=  " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAllItemsTotalByFilterData($data) {
        $sql = "SELECT COUNT(*) AS count FROM(
                    #herbal remedies clinical sale data
                    SELECT cs.clinical_sale_id as id, cs.invoice_prefix AS invoice_prefix, cs.date_added AS date_added, cs.date_modified AS date_modified , cs.total_d_gst AS total, c.customer_id AS customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer_name, c.customer_ic AS customer_ic, 1 AS type, 'clinical_sale' AS item_type, cs.store_id AS store_id  FROM  `" . DB_PREFIX . "clinical_sale` cs
                    LEFT JOIN `" . DB_PREFIX . "customer` c ON cs.customer_id = c.customer_id
                    WHERE 1 AND cs.clinicalsale_action = 5 AND cs.order_action = 17 AND cs.store_id = '" . $this->session->data['store_id'] . "'

                    UNION ALL

                    #service form data
                    SELECT sf.service_form_id as id, sf.invoice_prefix AS invoice_prefix, sf.date_added AS date_added, sf.date_modified AS date_modified, sf.total_price AS total, c.customer_id AS customer_id, CONCAT(c.firstname, ' ', c.lastname) AS customer_name, c.customer_ic AS customer_ic, 2 AS type, 'service' AS item_type, sf.store_id AS store_id FROM `" . DB_PREFIX . "service_form` sf
                    LEFT JOIN `" . DB_PREFIX . "customer` c ON sf.customer_id = c.customer_id
                    WHERE 1 AND sf.serviceform_action = 5 AND sf.order_action = 17 AND sf.store_id = '" . $this->session->data['store_id'] . "'
                ) a WHERE 1 " ;
        if (!empty($data['filter_invoice_prefix'])) {
            $sql .= " AND a.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'" ;
        }
        if (isset($data['filter_total'])) {
            $sql .= " AND a.total LIKE '%" .  (float)$data['filter_total'] . "%'" ;
        }
        if (!empty($data['filter_customer_name'])) {
            $sql .= " AND a.customer_name LIKE '%" . $this->db->escape($data['filter_customer_name']) . "%'" ;
        }
        if (!empty($data['filter_customer_ic'])) {
            $sql .= " AND a.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'" ;
        }
        if (!empty($data['filter_date_added'])) {
            $sql .= " AND a.date_added LIKE '%" . $this->db->escape($data['filter_date_added']) . "%'" ;
        }
        if (!empty($data['filter_date_modified'])) {
            $sql .= " AND a.date_modified LIKE '%" . $this->db->escape($data['filter_date_modified']) . "%'" ;
        }
        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.date_added) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }
        if (!empty($data['filter_type'])) {
            $sql .= " AND a.type = " . (int)$data['filter_type'] ;
        }
        $query = $this->db->query($sql);
        return $query->row['count'];
    }

    public function getOrderCartServices($order_id){
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_form WHERE order_id = '" . (int)$order_id . "'");

        return $query->rows;
     }


    //tines Herbal

    public function getHerbal($customer_id){

        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "clinical_sale` WHERE customer_id = '" . (int)$customer_id . "' AND clinicalsale_action ='".(int)5 ."' AND order_action = '".(int)17 ."' AND store_id ='".(int)$this->session->data['store_id']."'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }

    }

    public function getHerbalByClinicalsaleId($clinical_sale_id){

        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "clinical_sale` WHERE clinical_sale_id = '" . (int)$clinical_sale_id . "' AND clinicalsale_action ='".(int)5 ."' AND order_action = '".(int)17 ."' AND store_id ='".(int)$this->session->data['store_id']."'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }

    }

    public function getHerbalTotalTax($herbal_id){

        $query = $this->db->query("SELECT value,tax_key FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int)$herbal_id . "' AND code='tax' AND id=2");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }

    }

    public function getOrderCartherbal($order_id){
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE order_id = '" . (int)$order_id . "'");

        return $query->rows;
     }

     //Add by Chew Yi Xuan 25/7/2017 FOR Brewing purpose
    public function getBrewing($customer_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` ht WHERE 1 AND ht.customer_id = '" . (int)$customer_id . "' AND ht.status <> '4' AND ht.payment_status = '17' AND ht.store_id = '" . (int)$this->session->data['store_id'] . "'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }
     }

     public function getBrewingOrder($customer_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` ht WHERE 1 AND ht.from_store_customer_id = '" . (int)$customer_id . "' AND ht.status NOT IN('0','4') AND ht.payment_status = '17' AND ht.store_id = '" . (int)$this->session->data['store_id'] . "'");
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return 0;
        }
     }

    public function getOrderCartBrewing($order_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` ht WHERE 1 AND ht.order_id = '" . (int)$order_id . "'");
        return $query->rows;
    }

    public function getOrderCartBrewingOrder($order_id) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "herbal_transfer` ht WHERE 1 AND ht.order_id = '" . (int)$order_id . "'");
        return $query->rows;
    }
}

?>
