<?php

class ModelNotificationNotification extends Model {

    public function get_notifications($current_time, $five_seconds_ago) {
        $sql = "SELECT * FROM " . DB_PREFIX . "notification WHERE date_added BETWEEN '" . $this->db->escape($five_seconds_ago) . "' AND '" . $this->db->escape($current_time) . "' ORDER BY date_added ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_all_notification() {
        $sql = "SELECT *, TIME_TO_SEC(TIMEDIFF(NOW(), date_added)) AS time_ago FROM " . DB_PREFIX . "notification ORDER BY date_added DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function get_total_unread_notification() {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "notification WHERE had_read = 0";

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function get_header_notifications($hours) {
        $sql = "SELECT *, TIME_TO_SEC(TIMEDIFF(NOW(), date_added)) AS time_ago FROM " . DB_PREFIX . "notification WHERE date_added > NOW() - INTERVAL " . (int) $hours . " HOUR ORDER BY date_added DESC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function mark_notification_read($notification_id) {
        $sql = "UPDATE " . DB_PREFIX . "notification SET had_read = '1' WHERE notification_id = '" . (int) $notification_id . "'";

        $query = $this->db->query($sql);

        return $this->db->countAffected();
    }

    public function delete_all_notification() {
        $sql = "DELETE FROM " . DB_PREFIX . "notification";

        $query = $this->db->query($sql);
    }

}

?>
