<?php
class ModelLocalisationWarehouse extends Model
{
	public function addWarehouse($data)
	{
		$user_id = $this->session->data['user_id'];
		if ($data['wms_row']) {
			foreach ($data['wms_row'] as $row) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "wms_location SET 
				store_id = '" . (int)$this->session->data['store_id'] . "',
				warehouse = '" . $this->db->escape($row['warehouse']) . "',
				zone = '" . $this->db->escape($row['zone']) . "',
				lot = '" . $this->db->escape($row['lot']) . "',
				added_by = '" . $user_id . "',
				modified_by = '" . $user_id . "'
				");
			}
		} else {
			$this->db->query("INSERT INTO " . DB_PREFIX . "wms_location SET 
			store_id = '" . (int)$this->session->data['store_id'] . "',
			warehouse = '" . $this->db->escape($data['warehouse']) . "',
			zone = '" . $this->db->escape($data['zone']) . "',
			lot = '" . $this->db->escape($data['lot']) . "',
			added_by = '" . $user_id . "',
			modified_by = '" . $user_id . "'
			");
		}

		// $this->cache->delete('zone');

		return $this->db->getLastId();
	}

	public function editWarehouse($location_id, $data)
	{
		$user_id = $this->session->data['user_id'];
		$this->db->query("UPDATE " . DB_PREFIX . "wms_location SET 
        warehouse = '" . $this->db->escape($data['warehouse']) . "',
        zone = '" . $this->db->escape($data['zone']) . "',
        lot = '" . $this->db->escape($data['lot']) . "',
		modified_by = '" . $user_id . "',
		date_modified = NOW()
        WHERE location_id = '" . (int)$location_id . "'");
	}

	public function deleteWarehouse($location_id)
	{
		$this->db->query("DELETE FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
	}

	public function getWarehouse($location_id)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");

		return $query->row;
	}

	public function getWarehouses($data = array())
	{
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";


		$filter_location_search = !empty($data['filter_location_search']) ? explode(',', $data['filter_location_search']) : array();


		$start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;

		// $filter_location_search_statement = '';
		// if ($filter_location_search) {
		// 	$filter_location_search_wildcard = "%" . $filter_location_search . "%";
		// 	$filter_location_search_statement = " AND (a.warehouse LIKE '" . $filter_location_search_wildcard . "' OR a.zone LIKE '" . $filter_location_search_wildcard . "' OR a.lot LIKE '" . $filter_location_search_wildcard . "')";
		// }

		$filter_location_search_statement = "";

		foreach ($filter_location_search as $search_location) {
			$filter_location_search_statement .= empty($filter_location_search_statement) ? " a.location_text LIKE '%" . trim($search_location) . "%'" : " OR a.location_text LIKE '%" . trim($search_location) . "%'";
		}
		$filter_location_search_statement = !empty($filter_location_search_statement) ? " AND ($filter_location_search_statement)" : "";



		$filter_location_id_statement = !empty($data['filter_location_id']) ?
			"AND a.warehouse in ('" . implode("','", $data['filter_location_id']) . "')" :
			"";


		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in ('" . implode("','", $data['filter_store_id']) . "')" :

			"";


		$filter_add_by_statement = !empty($data['filter_add_by']) ?

			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :

			"";


		$filter_zone_statement = !empty($data['filter_zone']) ?

			"AND a.zone in ('" . implode("','", $data['filter_zone']) . "')" :

			"";

		// $sort_data = array(
		// 	'warehouse',
		// 	'zone',
		// 	'lot'
		// );

		//start generate SQL Statement
		$sql = "
		
		SELECT * 
		FROM( 
			
			SELECT

			" . DB_PREFIX . "wms_location.added_by as user_id,
			" . DB_PREFIX . "wms_location.date_added,
			" . DB_PREFIX . "wms_location.warehouse,
			" . DB_PREFIX . "wms_location.zone,
			" . DB_PREFIX . "wms_location.lot,
			" . DB_PREFIX . "wms_location.store_id,
			" . DB_PREFIX . "wms_location.location_id,
			" . DB_PREFIX . "wms_location.date_modified,

			CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'added_by',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


			FROM

			" . DB_PREFIX . "wms_location
			
			LEFT JOIN " . DB_PREFIX . "user
			ON(" . DB_PREFIX . "wms_location.added_by = " . DB_PREFIX . "user.user_id)
			
			
			WHERE 1
			
		)a

		WHERE 1

        $filter_location_search_statement

		$filter_location_id_statement

		$filter_store_id_statement

		$filter_add_by_statement

		$filter_zone_statement


		ORDER BY a.$sort $order

		LIMIT $start, $limit";

		$query = $this->db->query($sql);



		return $query->rows;
	}

	public function getTotalWarehouses($data = array())
	{
		$filter_location_search = !empty($data['filter_location_search']) ? explode(',', $data['filter_location_search']) : array();

		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;


		// $filter_location_search_statement = '';

		// if ($filter_location_search) {
		// 	$filter_location_search_wildcard = "%" . $filter_location_search . "%";
		// 	$filter_location_search_statement = " AND (a.warehouse LIKE '" . $filter_location_search_wildcard . "' OR a.zone LIKE '" . $filter_location_search_wildcard . "' OR a.lot LIKE '" . $filter_location_search_wildcard . "')";
		// }



		$filter_location_search_statement = "";

		foreach ($filter_location_search as $search_location) {
			$filter_location_search_statement .= empty($filter_location_search_statement) ? " a.location_text LIKE '%" . trim($search_location) . "%'" : " OR a.location_text LIKE '%" . trim($search_location) . "%'";
		}
		$filter_location_search_statement = !empty($filter_location_search_statement) ? " AND ($filter_location_search_statement)" : "";

		$filter_location_id_statement = !empty($data['filter_location_id']) ?
			"AND a.warehouse in ('" . implode("','", $data['filter_location_id']) . "')" :
			"";

		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in ('" . implode(',', $data['filter_store_id']) . "')" :

			"";

		$filter_add_by_statement = !empty($data['filter_add_by']) ?

			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :

			"";

		$filter_zone_statement = !empty($data['filter_zone']) ?

			"AND a.zone in ('" . implode("','", $data['filter_zone']) . "')" :

			"";
		//start generate SQL statement
		$sql = "
		SELECT COUNT(*) AS total
	    FROM(
			
			SELECT
			
			" . DB_PREFIX . "wms_location.added_by as user_id,
			" . DB_PREFIX . "wms_location.date_added,
			" . DB_PREFIX . "wms_location.warehouse,
			" . DB_PREFIX . "wms_location.zone,
			" . DB_PREFIX . "wms_location.lot,
			" . DB_PREFIX . "wms_location.store_id,
			" . DB_PREFIX . "wms_location.location_id,
			" . DB_PREFIX . "wms_location.date_modified,
	


			CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text',

			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'added_by',

			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'
			FROM

			" . DB_PREFIX . "wms_location
			
			LEFT JOIN " . DB_PREFIX . "user
			ON(" . DB_PREFIX . "wms_location.added_by = " . DB_PREFIX . "user.user_id)
			
			
			
			WHERE 1
			
		)a

		WHERE 1
		$filter_location_search_statement

		$filter_location_id_statement

		$filter_store_id_statement

		$filter_add_by_statement

		$filter_zone_statement
		";


		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getLocations($user_view = 1)
	{

		// $sql = "SELECT DISTINCT warehouse FROM " . DB_PREFIX . "wms_location";

		// if ($user_view != 1) {
		// 	$sql .= " WHERE store_id = '" . (int)$this->session->data['store_id'] . "'";
		// }
		// $sql .= " ORDER BY warehouse ASC";
		// $query = $this->db->query($sql);

		// return $query->rows;

		$query = $this->db->query("SELECT DISTINCT warehouse FROM " . DB_PREFIX . "wms_location 
		 WHERE store_id = '" . (int)$this->session->data['store_id'] . "'
		 AND Warehouse !='' 
		 ORDER BY warehouse asc");

		return $query->rows;
	}

	public function getZones()
	{

		$query = $this->db->query("SELECT DISTINCT(wms.zone) FROM " . DB_PREFIX . "wms_location wms
		WHERE zone !=' '
		ORDER BY zone asc");

		return $query->rows;
	}

	public function getStores()
	{
		$store_data = $this->cache->get('store');

		if (!$store_data) {
			$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store ORDER BY url");

			$store_data = $query->rows;

			$this->cache->set('store', $store_data);
		}

		return $store_data;
	}

	public function getTotalProductsByWmsId($location_id)
	{
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "product_to_location WHERE location_id='$location_id'";
		$query = $this->db->query($sql);
		return $query->row['total'];
	}

	public function getTotalWmsIdUsed($location_id)
	{
		$total = 0;
		$tables = array(
			'stock_received_product',
			'stock_take_product',
		);
		foreach ($tables as $table) {
			$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "$table WHERE location_id='$location_id'";
			$query = $this->db->query($sql);
			if (!empty($query->row['total'])) {
				$total = $total + $query->row['total'];
			}
		}
		return $total;
	}
	public function getStaffs()
	{
		$query = $this->db->query("SELECT DISTINCT(wms.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "wms_location wms
		LEFT JOIN " . DB_PREFIX . "user u on (wms.added_by = u.user_id)
		ORDER BY staff_name asc");

		return $query->rows;
	}

	public function getLocation($location_id) 
	{
		$sql = "SELECT

		" . DB_PREFIX . "wms_location.added_by as user_id,
		" . DB_PREFIX . "wms_location.date_added,
		" . DB_PREFIX . "wms_location.warehouse,
		" . DB_PREFIX . "wms_location.zone,
		" . DB_PREFIX . "wms_location.lot,
		" . DB_PREFIX . "wms_location.store_id,
		" . DB_PREFIX . "wms_location.location_id,
		" . DB_PREFIX . "wms_location.date_modified,

		CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text',

		(CASE WHEN " . DB_PREFIX . "wms_location.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname

		FROM

		" . DB_PREFIX . "wms_location

		LEFT JOIN " . DB_PREFIX . "store s
        ON(s.store_id = " . DB_PREFIX . "wms_location.store_id)

		LEFT JOIN " . DB_PREFIX . "setting sett
        ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "wms_location.store_id)
		
		
		
		WHERE " . DB_PREFIX . "wms_location.location_id ='" . (int)$location_id . "'";

		$query = $this->db->query($sql);
        return $query->row;
	}

	public function getLocationAll() 
	{
		$sql = "SELECT

		" . DB_PREFIX . "wms_location.added_by as user_id,
		" . DB_PREFIX . "wms_location.date_added,
		" . DB_PREFIX . "wms_location.warehouse,
		" . DB_PREFIX . "wms_location.zone,
		" . DB_PREFIX . "wms_location.lot,
		" . DB_PREFIX . "wms_location.store_id,
		" . DB_PREFIX . "wms_location.location_id,
		" . DB_PREFIX . "wms_location.date_modified,

		CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text'


		FROM

		" . DB_PREFIX . "wms_location
		
		GROUP BY " . DB_PREFIX . "wms_location.location_id";

		$query = $this->db->query($sql);
        return $query->rows;
	}

	public function getLocationSearched($data)
	{
		$filter_location_search = !empty($data['filter_location_search']) ? explode(',', $data['filter_location_search']) : array();

		// $filter_location_search_statement = '';
		// if ($filter_location_search) {
		// 	$filter_location_search_wildcard = "%" . $filter_location_search . "%";
		// 	$filter_location_search_statement = " AND (a.warehouse LIKE '" . $filter_location_search_wildcard . "' OR a.zone LIKE '" . $filter_location_search_wildcard . "' OR a.lot LIKE '" . $filter_location_search_wildcard . "')";
		// }

		$filter_location_search_statement = "";

		foreach ($filter_location_search as $search_location) {
			$filter_location_search_statement .= empty($filter_location_search_statement) ? " a.location_text LIKE '%" . trim($search_location) . "%'" : " OR a.location_text LIKE '%" . trim($search_location) . "%'";
		}
		$filter_location_search_statement = !empty($filter_location_search_statement) ? " AND ($filter_location_search_statement)" : "";



		$filter_location_id_statement = !empty($data['filter_location_id']) ?
			"AND a.warehouse in ('" . implode("','", $data['filter_location_id']) . "')" :
			"";


		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :

			"";


		$filter_add_by_statement = !empty($data['filter_add_by']) ?

			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :

			"";


		$filter_zone_statement = !empty($data['filter_zone']) ?

			"AND a.zone in ('" . implode("','", $data['filter_zone']) . "')" :

			"";

		// $sort_data = array(
		// 	'warehouse',
		// 	'zone',
		// 	'lot'
		// );

		//start generate SQL Statement
		$sql = "
		
		SELECT * 
		FROM( 
			
			SELECT

			" . DB_PREFIX . "wms_location.added_by as user_id,
			" . DB_PREFIX . "wms_location.date_added,
			" . DB_PREFIX . "wms_location.warehouse,
			" . DB_PREFIX . "wms_location.zone,
			" . DB_PREFIX . "wms_location.lot,
			" . DB_PREFIX . "wms_location.store_id,
			" . DB_PREFIX . "wms_location.location_id,
			" . DB_PREFIX . "wms_location.date_modified,

			CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'added_by',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


			FROM

			" . DB_PREFIX . "wms_location
			
			LEFT JOIN " . DB_PREFIX . "user
			ON(" . DB_PREFIX . "wms_location.added_by = " . DB_PREFIX . "user.user_id)
			
			
			WHERE 1
			
		)a

		WHERE 1

        $filter_location_search_statement

		$filter_location_id_statement

		$filter_store_id_statement

		$filter_add_by_statement

		$filter_zone_statement
";

		$query = $this->db->query($sql);



		return $query->rows;
	}


	public function getLocationSelected($location_id) 
	{
		$sql = "
			
			SELECT

			" . DB_PREFIX . "wms_location.added_by as user_id,
			" . DB_PREFIX . "wms_location.date_added,
			" . DB_PREFIX . "wms_location.warehouse,
			" . DB_PREFIX . "wms_location.zone,
			" . DB_PREFIX . "wms_location.lot,
			" . DB_PREFIX . "wms_location.store_id,
			" . DB_PREFIX . "wms_location.location_id,
			" . DB_PREFIX . "wms_location.date_modified,

			CONCAT(" . DB_PREFIX . "wms_location.warehouse, ' ', " . DB_PREFIX . "wms_location.zone,' '," . DB_PREFIX . "wms_location.lot) AS 'location_text',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'added_by',
			CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


			FROM

			" . DB_PREFIX . "wms_location
			
			LEFT JOIN " . DB_PREFIX . "user
			ON(" . DB_PREFIX . "wms_location.added_by = " . DB_PREFIX . "user.user_id)
			
			
			WHERE " . DB_PREFIX . "wms_location.location_id = '" . (int)$location_id . "'";
			
		$query = $this->db->query($sql);



		return $query->rows;
	}
}
