<?php
class ModelHerbalWaiting extends Model {
    public function getHerbalServiceTotal($herbal_id) {
        $query = $this->db->query("SELECT SUM(rowtotal) AS total FROM " . DB_PREFIX . "clinecal_service_item cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return !empty($query->row['total']) ? $query->row['total'] : 0;
    }

    public function getCustomerbyid($customer_id) {
        $sql = "
			SELECT 
					* 
				FROM `oc_customer` 
				WHERE 1 
				AND customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function addCustomer($data) {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);
            $this->load->model('setting/setting');

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape($customer_card) . "',
						dob = '" . $this->db->escape($data['dob']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						marital_status = '" . (int) $data['marital_status'] . "',
						race = '" . (int) $data['race'] . "',
						religion = '" . (int) $data['religion'] . "',
						nationality = '" . $this->db->escape($data['nationality']) . "',
						occupation = '" . $this->db->escape($data['occupation']) . "',
						allergic = '" . $this->db->escape($data['allergic']) . "',
						diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
						date_added = NOW()
				");
            }
        } while ($insert_customer == false);

        $customer_id = $this->db->getLastId();

        $customer_firstname = !empty($data['firstname']) ? $data['firstname'] : '';
        $customer_lastname = !empty($data['lastname']) ? $data['lastname'] : '';

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($customer_firstname) . "',
				lastname = '" . $this->db->escape($customer_lastname) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }

        return $customer_id;
    }

    public function getTotalHerbal($data = array()) {
        $sql = "
        SELECT 
                COUNT(*) AS total 
            FROM oc_clinical_sale cs  
                LEFT JOIN oc_customer c 
                    ON (cs.customer_id = c.customer_id) 
		";

        $implode = array();

        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
        }

        //history
        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "cs.diagnostic LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['filter_customer_lastname'])) {
            $implode[] = "c.lastname LIKE '%" . $this->db->escape($data['filter_customer_lastname']) . "%'";
        }

        if (!empty($data['filter_customer_occupation'])) {
            $implode[] = "c.occupation LIKE '%" . $this->db->escape($data['filter_customer_occupation']) . "%'";
        }

        if (!empty($data['filter_address'])) {
            /*$implode[] = " ( CONCAT(a_id.address_1,a_id.address_2,a_id.address_3,a_id.city,a_id.postcode,a_id.zone_name,a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT(a_id.address_1,' ',a_id.address_2,' ',a_id.address_3,' ',a_id.city,' ',a_id.postcode,' ',a_id.zone_name,' ',a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT ((CASE WHEN a_id.address_1 THEN CONCAT(a_id.address_1,',') ELSE '' END),
                                (CASE WHEN a_id.address_2 THEN CONCAT(a_id.address_2,',') ELSE '' END),
                                (CASE WHEN a_id.address_3 THEN CONCAT(a_id.address_3,',') ELSE '' END),
                                (CASE WHEN a_id.postcode THEN CONCAT(a_id.postcode,',') ELSE '' END),
                                (CASE WHEN a_id.city THEN CONCAT(a_id.city,',') ELSE '' END),
                                (CASE WHEN a_id.zone_name THEN CONCAT(a_id.zone_name,',') ELSE '' END),
                                (CASE WHEN a_id.country_name THEN CONCAT(a_id.country_name) ELSE '' END)
            ) LIKE '%" . $this->db->escape($data['filter_address']) . "%' ) ";*/
        }

        //end filter history
        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = " (CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%' OR  CONCAT(c.lastname,' ',c.firstname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%') ";
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        if ($data['filter_gender'] != '') {
            $implode[] = " c.gender in (" . $data['filter_gender'] . ")";
        }

        if ($data['filter_doctor'] != '') {
            $implode[] = " (CASE WHEN cs.doctor_id is NULL THEN 0 ELSE cs.doctor_id END) in (" . $data['filter_doctor'] . ")";
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
            $sql .= " AND cs.hide = 0 ";
        } else {
            $sql .= " WHERE 1 AND cs.hide = 0 ";
        }


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getHerbals($data = array()) {
        $sql = "
			SELECT 
				cs.*,
                cs.top AS tick_top,
				CONCAT(
					(CASE WHEN cs.diagnostic != '' THEN CONCAT(cs.diagnostic,' ') ELSE '' END),
					(CASE WHEN cs.pulse != '' THEN CONCAT(',',cs.pulse,' ') ELSE '' END),
					(CASE WHEN cs.disease != '' THEN CONCAT(',',cs.disease,' ') ELSE '' END),
					(CASE WHEN cs.symptom != '' THEN CONCAT(',',cs.symptom,' ') ELSE '' END),
					(CASE WHEN cs.treatment != '' THEN CONCAT(',',cs.treatment,' ') ELSE '' END),
					(CASE WHEN cs.acupuncture != '' THEN CONCAT(',',cs.acupuncture,' ') ELSE '' END),
					(CASE WHEN cs.doctoradvice != '' THEN CONCAT(',',cs.doctoradvice,' ') ELSE '' END),
					(CASE WHEN cs.remark != '' THEN CONCAT(',',cs.remark,' ') ELSE '' END)
				) AS diagnostic_text,
                cgd.name AS customer_group,
                CONCAT(u.firstname,' ',u.lastname) AS doctor_name,
                sf.total_price AS service_total_price,
				c.customer_group_id,
				c.customer_ic,
				c.customer_card,
                c.firstname,
                c.lastname,
                c.gender,
                c.email,
                c.dob,
                c.telephone,
                c.occupation,
                (SELECT CONCAT(u.firstname,' ',u.lastname) FROM oc_user u WHERE cs.add_by = u.user_id ) AS add_by,
                (SELECT CONCAT(u.firstname,' ',u.lastname) FROM oc_user u WHERE cs.modifi_by = u.user_id ) AS modifi_by,
			( SELECT 
					os.name 
				FROM oc_order_status os 
				WHERE os.order_status_id = cs.clinicalsale_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status,
			( SELECT 
					os.name 
				FROM oc_order_status os 
				WHERE os.order_status_id = cs.order_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS order_status 
			FROM 
				oc_clinical_sale cs  
					LEFT JOIN oc_customer c 
						ON (cs.customer_id = c.customer_id) 
                            LEFT JOIN oc_customer_group_description cgd
                                ON c.customer_group_id = cgd.customer_group_id AND cgd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                                    LEFT JOIN oc_user u
                                        ON cs.doctor_id = u.user_id   
                                            LEFT JOIN oc_service_form sf
                                                ON cs.clinical_sale_id = sf.clinical_sale_id  ";

        $implode = array();

        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
        }

        //history
        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "CONCAT(
				(CASE WHEN cs.diagnostic != '' THEN cs.diagnostic ELSE '' END),
				(CASE WHEN cs.pulse != '' THEN CONCAT(cs.pulse,',') ELSE '' END),
				(CASE WHEN cs.disease != '' THEN CONCAT(cs.disease,',') ELSE '' END),
				(CASE WHEN cs.symptom != '' THEN CONCAT(cs.symptom,',') ELSE '' END),
				(CASE WHEN cs.treatment != '' THEN CONCAT(cs.treatment,',') ELSE '' END),
				(CASE WHEN cs.acupuncture != '' THEN CONCAT(cs.acupuncture,',') ELSE '' END),
				(CASE WHEN cs.doctoradvice != '' THEN CONCAT(cs.doctoradvice,',') ELSE '' END),
				(CASE WHEN cs.remark != '' THEN CONCAT(cs.remark,',') ELSE '' END)
			) LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        //end filter history
        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = " (CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%' OR  CONCAT(c.lastname,' ',c.firstname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%') ";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['filter_customer_lastname'])) {
            $implode[] = "c.lastname LIKE '%" . $this->db->escape($data['filter_customer_lastname']) . "%'";
        }

        if (!empty($data['filter_customer_occupation'])) {
            $implode[] = "c.occupation LIKE '%" . $this->db->escape($data['filter_customer_occupation']) . "%'";
        }

        if (!empty($data['filter_address'])) {
            /*$implode[] = " ( CONCAT(a_id.address_1,a_id.address_2,a_id.address_3,a_id.city,a_id.postcode,a_id.zone_name,a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT(a_id.address_1,' ',a_id.address_2,' ',a_id.address_3,' ',a_id.city,' ',a_id.postcode,' ',a_id.zone_name,' ',a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT ((CASE WHEN a_id.address_1 THEN CONCAT(a_id.address_1,',') ELSE '' END),
                                (CASE WHEN a_id.address_2 THEN CONCAT(a_id.address_2,',') ELSE '' END),
                                (CASE WHEN a_id.address_3 THEN CONCAT(a_id.address_3,',') ELSE '' END),
                                (CASE WHEN a_id.postcode THEN CONCAT(a_id.postcode,',') ELSE '' END),
                                (CASE WHEN a_id.city THEN CONCAT(a_id.city,',') ELSE '' END),
                                (CASE WHEN a_id.zone_name THEN CONCAT(a_id.zone_name,',') ELSE '' END),
                                (CASE WHEN a_id.country_name THEN CONCAT(a_id.country_name) ELSE '' END)
            ) LIKE '%" . $this->db->escape($data['filter_address']) . "%' ) ";*/
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        if ($data['filter_doctor'] != '') {
            $implode[] = " (CASE WHEN cs.doctor_id is NULL THEN 0 ELSE cs.doctor_id END) in (" . $data['filter_doctor'] . ")";
        }

        if ($data['filter_gender'] != '') {
            $implode[] = " c.gender in (" . $data['filter_gender'] . ")";
        }

        if (!empty($data['filter_store_id'])) {
            $implode[] = " cs.store_id in (" . $data['filter_store_id'] . ")";
        }

        // if (empty($data['user_view']) && $this->user->user_position  == 2) {
        //     $implode[] = "(CASE WHEN cs.doctor_id is NULL THEN 0 ELSE cs.doctor_id END) = '" . (int)$this->session->data['user_id'] . "'";
        // } else {
        //     if (!empty($data['filter_doctor'])) {
        //         $implode[] = "(CASE WHEN cs.doctor_id is NULL THEN 0 ELSE cs.doctor_id END) = '" . (int) $data['filter_doctor'] . "'";
        //     }
        // }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
            $sql .= " AND cs.hide = 0 ";
        } else {
            $sql .= " WHERE 1 AND cs.hide = 0 ";
        }

        $sort_data = array(
            'cs.sales_date',
            'cs.invoice_prefix',
            'c.firstname',
            'c.customer_ic',
            'c.customer_card',
            'c.telephone'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY cs.top DESC, " . $data['sort'];
        } else {
            $sql .= " ORDER BY cs.top DESC , cs.sales_date ASC, cs.invoice_prefix ASC ";
        }

        // if (isset($data['order']) && ($data['order'] == 'DESC')) {
        //     $sql .= " DESC";
        // } else {
        //     $sql .= " ASC";
        // }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);


        return $query->rows;
    }

    public function getDoctors() {
        $sql = "SELECT CONCAT(firstname, ' ', lastname) AS doctor_name, user_id FROM " . DB_PREFIX . "user WHERE position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getHerbal($herbal_id) {

        $query = $this->db->query("
			SELECT 
					(SELECT 
							u.firstname 
						FROM `oc_user` u 
						WHERE u.user_id = cs.doctor_id
					) AS doctor_firstname,
					(SELECT 
							u.lastname 
						FROM `oc_user` u 
						WHERE u.user_id = cs.doctor_id
					) AS doctor_lastname,
					ad.*,
					c.*,
                    sf.total_price AS service_total_price,
					CONCAT(c.firstname,' ',c.lastname) AS customer_name,
					co.name AS country_name,
					zo.name AS zone_name,
					cs.* 
				FROM `oc_clinical_sale` cs  
					LEFT JOIN `oc_customer` c 
						ON (cs.customer_id = c.customer_id)
					LEFT JOIN `oc_address` ad
						ON (c.address_id = ad.address_id) 
					LEFT JOIN `oc_country` co
						ON ad.country_id = co.country_id
					LEFT JOIN `oc_zone` zo
						ON ad.zone_id = zo.zone_id
                    LEFT JOIN `oc_service_form`sf
                        ON cs.clinical_sale_id = sf.clinical_sale_id 
				WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'
			
		");

        return $query->row;
    }

    public function getHerbalPrescription($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_sales_prescription cp WHERE cp.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalTotals($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_total cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalService($herbal_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_service_item cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getImage($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_image  WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalImages($customer_id, $herbla_id = 0) {

        $query = $this->db->query("SELECT cs.clinical_sale_id,cs.sales_date,cs.customer_id,cs.invoice_prefix FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.clinical_sale_id IN(SELECT ci.clinical_sale_id
               FROM " . DB_PREFIX . "clinical_sale_image ci) AND customer_id ='" . (int) $customer_id . "' AND cs.clinical_sale_id !='" . $herbla_id . "' ORDER BY cs.sales_date DESC");

        return $query->rows;
    }

    public function getHerbalServiceAcupuncture($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);
        $clinical_service_items = $query->rows;

        $herbal_service_acupuncture_arr = array();

        foreach ($clinical_service_items as $item) {
            $clinical_service_id = $item['clinicalservice_id'];
            $acupuncture_parts_arr = unserialize($item['acupuncture_parts']);

            $herbal_service_acupuncture_arr[$clinical_service_id] = $acupuncture_parts_arr;
        }

        return $herbal_service_acupuncture_arr;
    }

    

    public function getAcupunctureNameById($acupuncture_id) {
        $sql = "SELECT name
				FROM " . DB_PREFIX . "acupuncture_name
				WHERE language_id = '" . $this->config->get('config_language_id') . "'
				AND acupuncture_id = '" . (int) $acupuncture_id . "'";

        $query = $this->db->query($sql);

        return $query->row['name'];
    }
    public function getHerbalRemediesImage($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getservicetotal($herbal_id){
        $sql = "SELECT  sf.*,
        CONCAT(u.firstname,' ',u.lastname) AS doctor_name,
        si.servicename,
        si.total
      

        FROM " . DB_PREFIX . "service_form sf 
        LEFT JOIN " . DB_PREFIX . "user u 
        ON sf.user_id = u.user_id 
        LEFT JOIN " . DB_PREFIX . "service_item si
        ON sf.service_form_id = si.service_form_id
        WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        

        return $query->rows;
    }

    public function gettotal($herbal_id){
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_total  WHERE clinical_sale_id = '" . (int) $herbal_id . "' AND id = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getserviceitemtotal($herbal_id){
        $sql = "SELECT   
        
        st.title,
        st.value

        FROM " . DB_PREFIX . "service_form sf
        LEFT JOIN " . DB_PREFIX . "service_total st
        ON sf.service_form_id = st.service_form_id
        WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getallclinicaldata($clinical_sale_id){
        $sql = "SELECT clinical_sale_id FROM " . DB_PREFIX . "clinical_sale WHERE clinicalsale_action = '1' AND order_action = '17' AND clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);
        return $query->row;
    }

    public function delete($clinical_sale_id){
        $sql = "UPDATE " . DB_PREFIX . "clinical_sale SET `clinicalsale_action` = '7' WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'";

        $query = $this->db->query($sql);
        
    }
    


}