<?php

class ModelHerbalNewHerbal extends Model {
    public function getPrescriptionDetails($herbal_id) {
        $sql = "
            SELECT 
                    cp.`prescription_id`,
                    '' AS prescription_name,
                    GROUP_CONCAT(pd.name,' ',TRIM(cp.`t_weight`) + 0,wcd.`unit` SEPARATOR ' ,  ') AS prescription_product_name,
                    CONCAT('共', MAX(cp.`times`),'剂') AS time,
                    CONCAT('每日', MAX(cp.`day`),'次') AS day,
                    MAX(cp.`cook`) AS consume_method,
                    MAX(cp.`taketype`) AS take_type,
                    SUM(cp.`t_weight`) AS total_weight,
                    MAX(wcd.`unit`) AS uom,
                    COUNT(cp.`product_id`) AS total_products
                FROM `" . DB_PREFIX . "clinicalsale_product` cp 
                    LEFT JOIN `" . DB_PREFIX . "product_description` pd 
                        ON (cp.`product_id` = pd.`product_id` AND pd.`language_id` = '" .  (int) $this->config->get('config_language_id') . "')
                    LEFT JOIN `" . DB_PREFIX . "weight_class_description` wcd 
                        ON (cp.`weight_class_id` = wcd.`weight_class_id` AND wcd.`language_id` = '" .  (int) $this->config->get('config_language_id') . "')
                    WHERE 1
                        AND cp.clinical_sale_id = '" . (int)$herbal_id . "'
                    GROUP BY cp.`prescription_id`
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    /* New */
    public function getHerbalServiceTotal($herbal_id) {
        $query = $this->db->query("SELECT SUM(rowtotal) AS total FROM " . DB_PREFIX . "clinecal_service_item cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return !empty($query->row['total']) ? $query->row['total'] : 0;
    }

    public function getServiceFormTotal($herbal_id) {
        $query = $this->db->query("SELECT SUM(total_price) AS total FROM " . DB_PREFIX . "service_form sf WHERE sf.clinical_sale_id = '" . (int) $herbal_id . "'");

        return !empty($query->row['total']) ? $query->row['total'] : 0;
    }

    public function getLatestHerbalByCustomerId($customer_id) {
        $query = $this->db->query(" 
            SELECT 
                    date_added
                FROM `oc_clinical_sale`
                WHERE 1
                    AND customer_id = '" . (int) $customer_id . "'
                ORDER BY date_added DESC
                LIMIT 1
        ");
        return !empty($query->row['date_added']) ? $query->row['date_added'] : '';
    }

    public function getUserPosition($user_id) {
        $query = $this->db->query("
			SELECT
					position
				FROM `oc_user`
				WHERE 1
					AND user_id = '" . (int) $user_id . "'
		");
        return !empty($query->row['position']) ? $query->row['position'] : 1;
    }

    public function getCustomerbyid($customer_id) {
        $sql = "
			SELECT 
					* 
				FROM `oc_customer` 
				WHERE 1 
				AND customer_id = '" . (int) $customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getAutocompleteCustomers($data) {
        $sql = "SELECT 
                        c.customer_id, 
                        CONCAT(firstname,' ',lastname) AS customer_name, 
                        c.firstname AS customer_firstname, 
                        c.lastname AS customer_lastname, 
                        c.customer_ic, 
                        c.customer_card, 
                        c.customer_group_id, 
                        c.gender, 
                        c.occupation,
                        c.email, 
                        c.telephone, 
                        c.dob,
                        address.customer_address
                    FROM " . DB_PREFIX . "customer c
                        LEFT JOIN (
                            SELECT
                                    a.address_id,
                                    CONCAT (
                                        (CASE WHEN a.address_1 THEN CONCAT(a.address_1,',') ELSE '' END),
                                        (CASE WHEN a.address_2 THEN CONCAT(a.address_2,',') ELSE '' END),
                                        (CASE WHEN a.address_3 THEN CONCAT(a.address_3,',') ELSE '' END),
                                        (CASE WHEN a.postcode THEN CONCAT(a.postcode,',') ELSE '' END),
                                        (CASE WHEN a.city THEN CONCAT(a.city,',') ELSE '' END),
                                        (CASE WHEN zo.name THEN CONCAT(zo.name,',') ELSE '' END),
                                        (CASE WHEN co.name THEN CONCAT(co.name) ELSE '' END)
                                    ) AS customer_address
                                FROM " . DB_PREFIX . "address a
                                    LEFT JOIN " . DB_PREFIX . "country co
                                        ON a.country_id = co.country_id
                                    LEFT JOIN " . DB_PREFIX . "zone zo
                                        ON a.zone_id = zo.zone_id
                        ) address
                        ON c.address_id = address.address_id
                    WHERE 1
                        AND c.status = '1' 
                        AND c.approved = '1'
        ";

        if (!empty($data['filter_search'])) {
            $sql .= " AND (
                        c.telephone LIKE '%" . $this->db->escape($data['filter_search']) . "%'  
			OR c.customer_ic LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                        OR c.customer_card LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                        OR c.occupation LIKE '%" . $this->db->escape($data['filter_search']) . "%'
			OR c.email LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                        OR (CASE WHEN c.gender = '1' THEN '男' ELSE '女' END) LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                        OR (CASE WHEN c.gender = '1' THEN 'MALE' ELSE 'FEMALE' END) LIKE '%" . $this->db->escape($data['filter_search']) . "%'
			OR CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_search']) . "%'
			OR CONCAT(c.lastname,' ',c.firstname) LIKE '%" . $this->db->escape($data['filter_search']) . "%'
                        OR address.customer_address LIKE '%" . $this->db->escape($data['filter_search']) . "%'
            )";
        }

        $sql .= " GROUP BY c.customer_id";
        $sql .= " ORDER BY CONCAT(c.firstname,' ',c.lastname) ASC ";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function customerExistsByIc($v) {
        $sql = "
			SELECT 
					* 
				FROM `oc_customer` 
				WHERE customer_ic = '" . $this->db->escape($v) . "'
		";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function customerExistsByTelephone($v) {
        $sql = "
			SELECT 
					* 
				FROM `oc_customer` 
				WHERE telephone = '" . $this->db->escape($v) . "'
		";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function customerExistsByEmail($v) {
        $sql = "
			SELECT 
					* 
				FROM `oc_customer` 
				WHERE email = '" . $this->db->escape($v) . "'
		";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getServiceDetails($service_id) {
        $query = $this->db->query("
			SELECT
					price,
					staff_id
				FROM `oc_clinical_service`
				WHERE 1
					AND clinicalservice_id = '" . (int) $service_id . "'
		");
        return $query->row;
    }

    public function getPrescriptionName($prescription_id) {
        $query = $this->db->query("
			SELECT 
					name
				FROM `oc_prescription_name`
				WHERE 1
					AND prescription_id = '" . (int) $prescription_id . "'
					AND language_id = '" . (int) $this->config->get('config_language_id') . "'
		");
        return $query->row['name'];
    }

    public function getPreferredCookType() {
        $query = $this->db->query("
			SELECT 
					ctd.name AS name
				FROM `oc_cook_type` ct 
					LEFT JOIN `oc_cook_type_description` ctd 
						ON (ct.cook_type_id = ctd.cook_type_id) 
				WHERE ct.status = '" . (int) 1 . "' 
				AND ctd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LIMIT 1
		");
        return $query->row['name'];
    }

    public function getTotalCS($data) {
        $query = $this->db->query("
			SELECT 
					COUNT(*) AS total
				FROM `oc_clinical_sale` cs
				WHERE 1
                                        AND cs.hide = 0
					AND cs.customer_id = '" . (int) $data->customer_id . "'
					AND cs.sales_date BETWEEN '" . $data->date_start . "' 
					AND '" . $data->date_end . "'			
		");
        return $query->row['total'];
    }

    public function getTotalHoldCS($data) {
        $query = $this->db->query("
			SELECT 
					COUNT(*) AS total
				FROM `oc_clinical_sale` cs
				WHERE 1
                                        AND cs.hide = 0
					AND cs.customer_id = '" . (int) $data->customer_id . "'
					AND cs.order_action = '17'
					AND cs.clinicalsale_action = '5'
					AND cs.sales_date BETWEEN '" . $data->date_start . "' 
					AND '" . $data->date_end . "'		
		");
        return $query->row['total'];
    }

    public function getTotalPaidCS($data) {
        $query = $this->db->query("
			SELECT 
					SUM(cs.total_d_gst) AS total
				FROM `oc_clinical_sale` cs
					LEFT JOIN `oc_currency` cr
						ON cs.currency_id = cr.currency_id
				WHERE 1
                                        AND cs.hide = 0
					AND cs.customer_id = '" . (int) $data->customer_id . "'
					AND cs.order_action = '5'
					AND cs.clinicalsale_action = '5'
					AND cs.sales_date BETWEEN '" . $data->date_start . "' 
					AND '" . $data->date_end . "'		
		");
        return $query->row['total'];
    }

    public function getTotalUnPaidCS($data) {
        $query = $this->db->query("
			SELECT 
					SUM(cs.total_d_gst) AS total
				FROM `oc_clinical_sale` cs
				WHERE 1
                                        AND cs.hide = 0
					AND cs.customer_id = '" . (int) $data->customer_id . "'
					AND cs.order_action <> '5'
					AND cs.clinicalsale_action <> '5'	
					AND cs.sales_date BETWEEN '" . $data->date_start . "' 
					AND '" . $data->date_end . "'		
		");
        return $query->row['total'];
    }

    public function getProductLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					p.product_id AS item_id,
					p.code AS item_code,
					p_id.name AS item_name
				FROM `oc_product` p
					LEFT JOIN 
					( SELECT
							pd.product_id,
							pd.name
						FROM `oc_product_description` pd
						WHERE 1
							AND pd.language_id = '" . $language_id . "'
						GROUP BY pd.product_id
					) p_id
					ON p.product_id = p_id.product_id
				WHERE 1
					AND p.internal_status = 1
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					p.code LIKE '" . $this->db->escape($data->search) . "%'
					OR p_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY p.product_id';
        $sql .= " ORDER BY p_id.name ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSubPrescriptionLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					p.prescription_id AS item_id,
					p.code AS item_code,
					p_id.name AS item_name
				FROM `oc_prescription` p
					LEFT JOIN 
					( SELECT
							pn.prescription_id,
							pn.name
						FROM `oc_prescription_name` pn
						WHERE 1
							AND pn.language_id = '" . $language_id . "'
						GROUP BY pn.prescription_id
					) p_id
					ON p.prescription_id = p_id.prescription_id
				WHERE 1
					AND p.status = 1
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					p.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR p_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY p.prescription_id';
        $sql .= " ORDER BY p_id.name ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					c.clinicalservice_id AS item_id,
					'' AS item_code,
					c_id.name AS item_name
				FROM `oc_clinical_service` c
					LEFT JOIN 
					( SELECT
							cn.clinicalservice_id,
							cn.name
						FROM `oc_clinical_service_description` cn
						WHERE 1
							AND cn.language_id = '" . $language_id . "'
						GROUP BY cn.clinicalservice_id
					) c_id
					ON c.clinicalservice_id = c_id.clinicalservice_id
					LEFT JOIN `oc_user` u
						ON c.staff_id = u.user_id
				WHERE 1
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					c_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY c.clinicalservice_id';
        $sql .= " ORDER BY c_id.name ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDiagnosticLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					d.diagnostic_id AS diagnostic_id,
					d.code AS diagnostic_code,
					d_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "diagnostic d
					LEFT JOIN 
					( SELECT
							dn.diagnostic_id,
							dn.name
						FROM " . DB_PREFIX . "diagnostic_name dn
						WHERE 1
							AND dn.language_id = '" . $language_id . "'
						GROUP BY dn.diagnostic_id
					) d_id
					ON d.diagnostic_id = d_id.diagnostic_id
				WHERE 1
					AND d.status = 1
					AND d.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					d.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR d_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY d.diagnostic_id';
        $sql .= " ORDER BY d.parent_id ASC, d_id.name ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPulseLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = " SELECT
					p.pulse_id AS diagnostic_id,
					p.code AS diagnostic_code,
					p_id.name AS diagnostic_name
                        FROM " . DB_PREFIX . "pulse p
					LEFT JOIN 
					( SELECT
							pn.pulse_id,
							pn.name
						FROM " . DB_PREFIX . "pulse_name pn
						WHERE 1
							AND pn.language_id = '" . $language_id . "'
						GROUP BY pn.pulse_id
					) p_id
					ON p.pulse_id = p_id.pulse_id
				WHERE 1
					AND p.status = 1
					AND p.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					p.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR p_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY p.pulse_id';
        $sql .= " ORDER BY p.parent_id ASC, p.pulse_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDiseaseLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					d.disease_id AS diagnostic_id,
					d.code AS diagnostic_code,
					d_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "disease d
					LEFT JOIN 
					( SELECT
							dn.disease_id,
							dn.name
						FROM " . DB_PREFIX . "disease_name dn
						WHERE 1
							AND dn.language_id = '" . $language_id . "'
						GROUP BY dn.disease_id
					) d_id
					ON d.disease_id = d_id.disease_id
				WHERE 1
					AND d.status = 1
					AND d.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					d.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR d_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY d.disease_id';
        $sql .= " ORDER BY d.parent_id ASC, d.disease_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTreatmentLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					t.treatment_id AS diagnostic_id,
					t.code AS diagnostic_code,
					t_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "treatment t
					LEFT JOIN 
					( SELECT
							tn.treatment_id,
							tn.name
						FROM " . DB_PREFIX . "treatment_name tn
						WHERE 1
							AND tn.language_id = '" . $language_id . "'
						GROUP BY tn.treatment_id
					) t_id
					ON t.treatment_id = t_id.treatment_id
				WHERE 1
					AND t.status = 1
					AND t.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					t.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR t_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY t.treatment_id';
        $sql .= " ORDER BY t.parent_id ASC, t.treatment_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSymptomLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					s.symptom_id AS diagnostic_id,
					s.code AS diagnostic_code,
					s_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "symptom s
					LEFT JOIN 
					( SELECT
							sn.symptom_id,
							sn.name
						FROM " . DB_PREFIX . "symptom_name sn
						WHERE 1
							AND sn.language_id = '" . $language_id . "'
						GROUP BY sn.symptom_id
					) s_id
					ON s.symptom_id = s_id.symptom_id
				WHERE 1
					AND s.status = 1
					AND s.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					s.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR s_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY s.symptom_id';
        $sql .= " ORDER BY s.parent_id ASC, s.symptom_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAcupunctureLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					a.acupuncture_id AS diagnostic_id,
					a.code AS diagnostic_code,
					a_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "acupuncture a
					LEFT JOIN 
					( SELECT
							an.acupuncture_id,
							an.name
						FROM " . DB_PREFIX . "acupuncture_name an
						WHERE 1
							AND an.language_id = '" . $language_id . "'
						GROUP BY an.acupuncture_id
					) a_id
					ON a.acupuncture_id = a_id.acupuncture_id
				WHERE 1
					AND a.status = 1
					AND a.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					a.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR a_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY a.acupuncture_id';
        $sql .= " ORDER BY a.parent_id ASC, a.acupuncture_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctorAdviceLists($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
			SELECT
					da.doctoradvice_id AS diagnostic_id,
					da.code AS diagnostic_code,
					da_id.name AS diagnostic_name
				FROM " . DB_PREFIX . "doctoradvice da
					LEFT JOIN 
					( SELECT
							dan.doctoradvice_id,
							dan.name
						FROM " . DB_PREFIX . "doctoradvice_name dan
						WHERE 1
							AND dan.language_id = '" . $language_id . "'
						GROUP BY dan.doctoradvice_id
					) da_id
					ON da.doctoradvice_id = da_id.doctoradvice_id
				WHERE 1
					AND da.status = 1
					AND da.parent_id <> 0
		";
        if (!empty($data->search)) {
            $sql .= "
				AND (
					da.code LIKE '%" . $this->db->escape($data->search) . "%'
					OR da_id.name LIKE '%" . $this->db->escape($data->search) . "%'
				)
			";
        }
        $sql .= ' GROUP BY da.doctoradvice_id';
        $sql .= " ORDER BY da.parent_id ASC, da.doctoradvice_id ASC";
        if (!empty($data->pagination_entry)) {
            $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPatientMedicalRecordList($data) {
        $language_id = $this->config->get('config_language_id');
        $sql = "
		SELECT 
                cs.*
			FROM `oc_clinical_sale` cs
				LEFT JOIN `oc_weight_class_description` wcd
					ON cs.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $language_id . "'
			WHERE 1
				AND cs.customer_id = '" . $data->customer_id . "'
				AND cs.clinical_sale_id != '" . $data->clinical_sale_id . "'
				AND cs.hide = 0
                AND cs.clinicalsale_action IN (1,5)
			GROUP BY cs.clinical_sale_id 
		";
        if (!empty($data->search)) {
            /*$sql .= "
				WHERE 1
				AND (
					a.invoice_prefix LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.diagnostic LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.doctoradvice LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.pulse LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.disease LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.treatment LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.acupuncture LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.symptom LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.total LIKE '%" . $this->db->escape($data->search) . "%'
					OR a.prescription_text LIKE '%" . $this->db->escape($data->search) . "%'
					OR CONVERT(a.date,char) LIKE '%" . $this->db->escape($data->search) . "%'
					)
			";*/
        }
        $sql .= "ORDER BY cs.clinical_sale_id DESC";
        $sql .= " LIMIT " . $data->pagination_offset . "," . $data->pagination_entry;
        $query = $this->db->query($sql);
        return $query->rows;
    }

    protected function validateDate($date, $format = 'Y-m-d H:i:s') {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    /*     * Old */

    public function addCustomer($data) {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);
            $this->load->model('setting/setting');

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape($customer_card) . "',
						dob = '" . $this->db->escape($data['dob']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						marital_status = '" . (int) $data['marital_status'] . "',
						race = '" . (int) $data['race'] . "',
						religion = '" . (int) $data['religion'] . "',
						nationality = '" . $this->db->escape($data['nationality']) . "',
						occupation = '" . $this->db->escape($data['occupation']) . "',
						allergic = '" . $this->db->escape($data['allergic']) . "',
						diagnostic_history = '" . $this->db->escape($data['diagnostic_history']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
						date_added = NOW()
				");
            }
        } while ($insert_customer == false);

        $customer_id = $this->db->getLastId();

        $customer_firstname = !empty($data['firstname']) ? $data['firstname'] : '';
        $customer_lastname = !empty($data['lastname']) ? $data['lastname'] : '';

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($customer_firstname) . "',
				lastname = '" . $this->db->escape($customer_lastname) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }

        return $customer_id;
    }

    public function check_unique_id($unique_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getAllOrderByDate($invoice_prefix) {
        $query = $this->db->query("SELECT o.* FROM `" . DB_PREFIX . "order` o WHERE 1 AND DATE(o.date_added) BETWEEN DATE('2017-09-01') AND DATE('2017-10-17') AND o.invoice_prefix = '" . $invoice_prefix . "' ORDER BY o.order_id ASC");
        return $query->rows;
    }

    public function checkOrderExists($order_id) {
        $query = $this->db->query("SELECT cs.clinical_sale_id FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.order_id = '" . (int) $order_id . "' AND cs.collect_consultation_price = 1");
        return $query->rows;
    }

    public function getErrorHerbal() {
        $query = $this->db->query("SELECT cs.clinical_sale_id, cs.sales_date, cs.collect_consultation_price, cs.clinicalsale_concultation, cs.invoice_prefix, cs.doctor_id FROM `" . DB_PREFIX . "clinical_sale` cs WHERE 1 AND cs.collect_consultation_price = 1 AND DATE(cs.sales_date) BETWEEN DATE('2017-09-01') AND DATE('2017-10-06') ORDER BY cs.clinical_sale_id ASC");
        return $query->rows;
    }

    public function updatErrorOrderTotal($data) {
        // Get the total
        $order_total = 0;
        $this->db->query("DELETE FROM " . DB_PREFIX . "order_total WHERE order_id = '" . (int) $data['order_id'] . "'");
        if (isset($data['total_data'])) {
            foreach ($data['total_data'] as $total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "order_total SET order_id = '" . (int) $data['order_id'] . "', code = '" . $this->db->escape($total['code']) . "', tax_key ='" . (int) $total['key'] . "', tax_code = '" . $this->db->escape($total['tax_code']) . "', title = '" . $this->db->escape($total['title']) . "', `value` = '" . (float) $total['value'] . "', sort_order = '" . (int) $total['sort_order'] . "'");
            }
            /* foreach ($data['total_data'] as $total) {
              $this->db->query("UPDATE " . DB_PREFIX . "order_total SET `value` = '" . (float) $total['value'] . "' WHERE order_id = '" . (int)$data['order_id'] ."' AND code = '" . $total['code']."'");
              } */
            $order_total += $total['value'];
        }
        // Update order total
        $this->db->query("UPDATE `" . DB_PREFIX . "order` SET total = '" . (float) $order_total . "' WHERE order_id = '" . (int) $data['order_id'] . "'");
    }

    public function getErrorHerbalTotal($clinical_sale_id) {
        $query = $this->db->query("SELECT cst.* FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE 1 AND clinical_sale_id = '" . (int) $clinical_sale_id . "'");
        return $query->rows;
    }

    public function updateErrorHerbal($data) {
        $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale` SET d_net_amount = '" . (float) $data['d_net_amount'] . "', d_gst = '" . (float) $data['d_gst'] . "', total_d_gst = '" . (float) $data['total_d_gst'] . "', total = '" . (float) $data['total'] . "' WHERE clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'");
    }

    public function updateErrorHerbalTotal($data) {
        if (!empty($data['order_totals'])) {
            foreach ($data['order_totals'] as $order_total) {
                $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale_total` SET value = '" . $order_total['value'] . "' WHERE clinical_sale_total_id = '" . (int) $order_total['clinical_sale_total_id'] . "' AND clinical_sale_id = '" . (int) $order_total['clinical_sale_id'] . "' AND code = '" . $order_total['code'] . "'");
            }
        }
    }

    public function getTotalHerbal($data = array()) {
        $sql = "
        SELECT 
                COUNT(*) AS total 
            FROM oc_clinical_sale cs  
                LEFT JOIN oc_customer c 
                    ON (cs.customer_id = c.customer_id) 
		";

        $implode = array();

        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
        }

        //history
        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "cs.diagnostic LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['filter_customer_lastname'])) {
            $implode[] = "c.lastname LIKE '%" . $this->db->escape($data['filter_customer_lastname']) . "%'";
        }

        if (!empty($data['filter_customer_occupation'])) {
            $implode[] = "c.occupation LIKE '%" . $this->db->escape($data['filter_customer_occupation']) . "%'";
        }

        if (!empty($data['filter_address'])) {
            /*$implode[] = " ( CONCAT(a_id.address_1,a_id.address_2,a_id.address_3,a_id.city,a_id.postcode,a_id.zone_name,a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT(a_id.address_1,' ',a_id.address_2,' ',a_id.address_3,' ',a_id.city,' ',a_id.postcode,' ',a_id.zone_name,' ',a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT ((CASE WHEN a_id.address_1 THEN CONCAT(a_id.address_1,',') ELSE '' END),
                                (CASE WHEN a_id.address_2 THEN CONCAT(a_id.address_2,',') ELSE '' END),
                                (CASE WHEN a_id.address_3 THEN CONCAT(a_id.address_3,',') ELSE '' END),
                                (CASE WHEN a_id.postcode THEN CONCAT(a_id.postcode,',') ELSE '' END),
                                (CASE WHEN a_id.city THEN CONCAT(a_id.city,',') ELSE '' END),
                                (CASE WHEN a_id.zone_name THEN CONCAT(a_id.zone_name,',') ELSE '' END),
                                (CASE WHEN a_id.country_name THEN CONCAT(a_id.country_name) ELSE '' END)
            ) LIKE '%" . $this->db->escape($data['filter_address']) . "%' ) ";*/
        }

        //end filter history
        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = " (CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%' OR  CONCAT(c.lastname,' ',c.firstname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%') ";
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        if (empty($data['user_view']) && $this->user->user_position  == 2) {
            $implode[] = "cs.doctor_id = '" . $this->session->data['user_id'] . "'";
        } else {
            if (!empty($data['filter_doctor'])) {
                $implode[] = "cs.doctor_id = '" . (int) $data['filter_doctor'] . "'";
            }
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
            $sql .= " AND cs.hide = 0 ";
        } else {
            $sql .= " WHERE 1 AND cs.hide = 0 ";
        }


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getHerbals($data = array()) {
        $sql = "
			SELECT 
				cs.*,
                cs.top AS tick_top,
				CONCAT(
					(CASE WHEN cs.diagnostic != '' THEN CONCAT(cs.diagnostic,' ') ELSE '' END),
					(CASE WHEN cs.pulse != '' THEN CONCAT(',',cs.pulse,' ') ELSE '' END),
					(CASE WHEN cs.disease != '' THEN CONCAT(',',cs.disease,' ') ELSE '' END),
					(CASE WHEN cs.symptom != '' THEN CONCAT(',',cs.symptom,' ') ELSE '' END),
					(CASE WHEN cs.treatment != '' THEN CONCAT(',',cs.treatment,' ') ELSE '' END),
					(CASE WHEN cs.acupuncture != '' THEN CONCAT(',',cs.acupuncture,' ') ELSE '' END),
					(CASE WHEN cs.doctoradvice != '' THEN CONCAT(',',cs.doctoradvice,' ') ELSE '' END),
					(CASE WHEN cs.remark != '' THEN CONCAT(',',cs.remark,' ') ELSE '' END)
				) AS diagnostic_text,
				c.*,
			( SELECT 
					os.name 
				FROM oc_order_status os 
				WHERE os.order_status_id = cs.clinicalsale_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS status,
			( SELECT 
					os.name 
				FROM oc_order_status os 
				WHERE os.order_status_id = cs.order_action AND os.language_id = '" . (int) $this->config->get('config_language_id') . "') AS order_status 
			FROM 
				oc_clinical_sale cs  
					LEFT JOIN oc_customer c 
						ON (cs.customer_id = c.customer_id) 
                                                ";

        $implode = array();

        if (!empty($data['filter_date_from']) && !empty($data['filter_date_to'])) {
            $implode[] = "DATE(cs.sales_date) BETWEEN DATE('" . $this->db->escape($data['filter_date_from']) . "') AND DATE('" . $this->db->escape($data['filter_date_to']) . "')";
        }

        if (!empty($data['filter_transaction_from']) && !empty($data['filter_transaction_to'])) {
            $implode[] = "cs.invoice_prefix BETWEEN '" . $this->db->escape($data['filter_transaction_from']) . "' AND '" . $this->db->escape($data['filter_transaction_to']) . "'";
        }


        if (isset($data['filter_customer_ic'])) {
            $implode[] = "c.customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
        }

        if (!empty($data['filter_customer_card'])) {
            $implode[] = "c.customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
        }

        //history
        if (!empty($data['customer_id'])) {
            $implode[] = "cs.customer_id = '" . $this->db->escape($data['customer_id']) . "'";
        }

        if (!empty($data['herbal_id'])) {
            $implode[] = "cs.clinical_sale_id < '" . (int) $data['herbal_id'] . "'";
        }

        if (!empty($data['filter_diagnostic'])) {
            $implode[] = "CONCAT(
				(CASE WHEN cs.diagnostic != '' THEN cs.diagnostic ELSE '' END),
				(CASE WHEN cs.pulse != '' THEN CONCAT(cs.pulse,',') ELSE '' END),
				(CASE WHEN cs.disease != '' THEN CONCAT(cs.disease,',') ELSE '' END),
				(CASE WHEN cs.symptom != '' THEN CONCAT(cs.symptom,',') ELSE '' END),
				(CASE WHEN cs.treatment != '' THEN CONCAT(cs.treatment,',') ELSE '' END),
				(CASE WHEN cs.acupuncture != '' THEN CONCAT(cs.acupuncture,',') ELSE '' END),
				(CASE WHEN cs.doctoradvice != '' THEN CONCAT(cs.doctoradvice,',') ELSE '' END),
				(CASE WHEN cs.remark != '' THEN CONCAT(cs.remark,',') ELSE '' END)
			) LIKE '%" . $this->db->escape($data['filter_diagnostic']) . "%'";
        }

        if (!empty($data['filter_doctoradvice'])) {
            $implode[] = "cs.doctoradvice LIKE '%" . $this->db->escape($data['filter_doctoradvice']) . "%'";
        }

        if (!empty($data['filter_pulse'])) {
            $implode[] = "cs.pulse LIKE '%" . $this->db->escape($data['filter_pulse']) . "%'";
        }

        if (!empty($data['filter_disease'])) {
            $implode[] = "cs.disease LIKE '%" . $this->db->escape($data['filter_disease']) . "%'";
        }

        if (!empty($data['filter_treatment'])) {
            $implode[] = "cs.treatment LIKE '" . $this->db->escape($data['filter_treatment']) . "%'";
        }

        if (!empty($data['filter_acupuncture'])) {
            $implode[] = "cs.acupuncture LIKE '" . $this->db->escape($data['filter_acupuncture']) . "%'";
        }

        if (!empty($data['filter_symptoms'])) {
            $implode[] = "cs.symptom LIKE '" . $this->db->escape($data['filter_symptoms']) . "%'";
        }

        //end filter history
        if (!empty($data['filter_customer_firstname'])) {
            $implode[] = " (CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%' OR  CONCAT(c.lastname,' ',c.firstname) LIKE '%" . $this->db->escape($data['filter_customer_firstname']) . "%') ";
        }

        if (!empty($data['filter_telephone'])) {
            $implode[] = "c.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['filter_customer_lastname'])) {
            $implode[] = "c.lastname LIKE '%" . $this->db->escape($data['filter_customer_lastname']) . "%'";
        }

        if (!empty($data['filter_customer_occupation'])) {
            $implode[] = "c.occupation LIKE '%" . $this->db->escape($data['filter_customer_occupation']) . "%'";
        }

        if (!empty($data['filter_address'])) {
            /*$implode[] = " ( CONCAT(a_id.address_1,a_id.address_2,a_id.address_3,a_id.city,a_id.postcode,a_id.zone_name,a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT(a_id.address_1,' ',a_id.address_2,' ',a_id.address_3,' ',a_id.city,' ',a_id.postcode,' ',a_id.zone_name,' ',a_id.country_name) LIKE '%" . $this->db->escape($data['filter_address']) . "%' "
                . " OR CONCAT ((CASE WHEN a_id.address_1 THEN CONCAT(a_id.address_1,',') ELSE '' END),
                                (CASE WHEN a_id.address_2 THEN CONCAT(a_id.address_2,',') ELSE '' END),
                                (CASE WHEN a_id.address_3 THEN CONCAT(a_id.address_3,',') ELSE '' END),
                                (CASE WHEN a_id.postcode THEN CONCAT(a_id.postcode,',') ELSE '' END),
                                (CASE WHEN a_id.city THEN CONCAT(a_id.city,',') ELSE '' END),
                                (CASE WHEN a_id.zone_name THEN CONCAT(a_id.zone_name,',') ELSE '' END),
                                (CASE WHEN a_id.country_name THEN CONCAT(a_id.country_name) ELSE '' END)
            ) LIKE '%" . $this->db->escape($data['filter_address']) . "%' ) ";*/
        }

        if (isset($data['filter_payment_status']) && !is_null($data['filter_payment_status'])) {
            $implode[] = "cs.order_action = '" . (int) $data['filter_payment_status'] . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $implode[] = "cs.clinicalsale_action = '" . (int) $data['filter_status'] . "'";
        }

        /*if ($data['filter_doctor'] != '') {
            $implode[] = " (CASE WHEN cs.doctor_id is NULL THEN 0 ELSE cs.doctor_id END) in (" . $data['filter_doctor'] . ")";
        }*/

        if (!empty($data['filter_store_id'])) {
            $implode[] = " cs.store_id in (" . $data['filter_store_id'] . ")";
        }

        if (empty($data['user_view']) && $this->user->user_position  == 2) {
            $implode[] = " cs.doctor_id = '" . (int)$this->session->data['user_id'] . "'";
        } else {
            if (!empty($data['filter_doctor'])) {
                $implode[] = "cs.doctor_id = '" . (int) $data['filter_doctor'] . "'";
            }
        }

        if ($implode) {
            $sql .= " WHERE " . implode(" AND ", $implode);
            $sql .= " AND cs.hide = 0 ";
        } else {
            $sql .= " WHERE 1 AND cs.hide = 0 ";
        }

        $sort_data = array(
            'cs.sales_date',
            'cs.invoice_prefix',
            'c.firstname',
            'c.customer_ic',
            'c.customer_card',
            'c.telephone'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY cs.top DESC, " . $data['sort'];
        } else {
            $sql .= " ORDER BY cs.top DESC, cs.sales_date DESC, cs.invoice_prefix ";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getherbals2($data) {
        $sql = " SELECT csp.clinical_sale_id, csp_id.prescription_name,
				csp_id.prescription_product_name,
			GROUP_CONCAT(csp.name) AS prescription_name,
			GROUP_CONCAT(cspt_id.prescription_product_name) AS prescription_product_name,
			CONCAT(GROUP_CONCAT(csp.name),',',GROUP_CONCAT(cspt_id.prescription_product_name)) AS prescription_text
		FROM `oc_clinecal_sales_prescription` csp
		LEFT JOIN 
								(
								SELECT
										cspt.prescription_id,
										GROUP_CONCAT(pd.name,'x',(cspt.quantity * cspt.times),wcd.unit,' ') AS prescription_product_name
									FROM `oc_clinicalsale_product` cspt
									LEFT JOIN `oc_product_description` pd
										ON cspt.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'
									LEFT JOIN `oc_weight_class_description` wcd
										ON cspt.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
									GROUP BY cspt.prescription_id
								) cspt_id
								ON csp.clinical_sale_prescription_id = cspt_id.prescription_id
							WHERE 1
							GROUP BY csp.clinical_sale_id";

        if (!empty($data['filter_prescription'])) {
            $implode[] = "csp_id.prescription_text LIKE '%" . $this->db->escape($data['filter_prescription']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function addHerbal($data) {

        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        // $consultation_price = ($data['enable_doctorprice'] == '1') ? $data['doctor_price'] : '0';
        // $consultation_price =  $data['doctor_price'];


        $this->db->query("
			INSERT INTO " . DB_PREFIX . "clinical_sale SET
				customer_id = '" . (int) $data['customer_id'] . "',
				doctor_id = '" . (int) $data['doctor_id'] . "',
				invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
                saved = '1',
				sales_date = Now(),
				store_id = '" . (int) $this->session->data['store_id'] . "',
				clinicalsale_action = '" . (int) 1 . "',
                clinicalsale_concultation = '" . (float) $data['consultationprice'] . "',
				collect_consultation_price = '" . (int) $data['enable_consultation_price'] . "',
				order_action = '" . (int) 17 . "',
				add_by = '" . (int) $this->session->data['user_id'] . "',
				date_added = NOW(),
				modifi_by = '" . (int) $this->session->data['user_id'] . "',
				date_modified = NOW()
		");

        $clinical_sale_id = $this->db->getLastId();

        if ($clinical_sale_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
        }
        return $clinical_sale_id;
    }

    public function getHerbal($herbal_id) {

        $query = $this->db->query("
			SELECT 
					(SELECT 
							u.firstname 
						FROM `oc_user` u 
						WHERE u.user_id = cs.doctor_id
					) AS doctor_firstname,
					(SELECT 
							u.lastname 
						FROM `oc_user` u 
						WHERE u.user_id = cs.doctor_id
					) AS doctor_lastname,
					ad.*,
					c.*,
					CONCAT(c.firstname,' ',c.lastname) AS customer_name,
					co.name AS country_name,
					zo.name AS zone_name,
					cs.* 
				FROM `oc_clinical_sale` cs  
					LEFT JOIN `oc_customer` c 
						ON (cs.customer_id = c.customer_id)
					LEFT JOIN `oc_address` ad
						ON (c.address_id = ad.address_id) 
					LEFT JOIN `oc_country` co
						ON ad.country_id = co.country_id
					LEFT JOIN `oc_zone` zo
						ON ad.zone_id = zo.zone_id
				WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'
			
		");

        return $query->row;
    }

    public function getImage($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_image  WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalPrescription($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_sales_prescription cp WHERE cp.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalService($herbal_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_service_item cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalService2($herbal_id) {
        $query = $this->db->query("SELECT si.*, si.user_id AS staffincharge, si.total AS price FROM `" . DB_PREFIX . "service_item` si LEFT JOIN `" . DB_PREFIX . "service_form` sf ON (si.service_form_id = sf.service_form_id) WHERE sf.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalProduct($prescription_id) {
        $query = $this->db->query("SELECT cp.*, p.price AS product_price FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) WHERE cp.prescription_id = '" . (int) $prescription_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getHerbalInfoProduct($prescription_id) {
        $query = $this->db->query("SELECT *,cp.quantity AS quantity,cp.price AS product_price, cp.weight, cp.weight_class_id FROM " . DB_PREFIX . "clinicalsale_product cp LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id) WHERE cp.prescription_id = '" . (int) $prescription_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'");
        return $query->rows;
    }

    public function getHerbalTotals($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale_total cs WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->rows;
    }

    public function getHerbalDateModified($herbal_id) {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id) WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");

        return $query->row['date_modified'];
    }

    public function getCookType() {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cook_type ct LEFT JOIN " . DB_PREFIX . "cook_type_description ctd ON (ct.cook_type_id = ctd.cook_type_id) WHERE ct.status = '" . (int) 1 . "' AND ctd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

        return $query->rows;
    }

    public function getServiceFormByHerbalId($herbal_id) {
        $sql = "SELECT `service_form_id` FROM `" . DB_PREFIX . "service_form` WHERE 1 AND clinical_sale_id = '" . (int)$herbal_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function editOrder($herbal_id, $data) {

        $this->load->model('localisation/currency');

        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale 
            SET
                customer_id = '" . (int) $data['customer_id'] . "',
                saved = '1',
                shipping_address_id = '" . (int) $data['shipping_address_id'] . "',
                clinicalsale_action = '" . (int) $data['status'] . "',
                doctor_id = '" . (int) $data['doctor_id'] . "',
                diagnostic = '" . $this->db->escape($data['diagnostic']) . "',
                doctoradvice = '" . $this->db->escape($data['doctoradvice']) . "',
                pulse = '" . $this->db->escape($data['pulse']) . "',
                disease = '" . $this->db->escape($data['disease']) . "',
                treatment = '" . $this->db->escape($data['treatment']) . "',
                sales_date = '" . $this->db->escape($data['sales_date']) . "',
                date_added = '" . $this->db->escape($data['sales_date']) . "',
                acupuncture = '" . $this->db->escape($data['acupuncture']) . "',
                symptom = '" . $this->db->escape($data['symptom']) . "',
                remark = '" . $this->db->escape($data['remark']) . "',
                modifi_by = '" . (int) $this->session->data['user_id'] . "',
                date_modified = NOW()
		        WHERE clinical_sale_id = '" . (int) $herbal_id . "'
        ");

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE clinical_sale_id = '" . (int) $herbal_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinicalsale_product WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        $product_total = 0;
        $product_tax = 0;
        $product_sutotal = 0;
        $weight = 0;
        $times = 0;
        $total_times = 0;
        $per_time = 0;

        if (!empty($data['prescription'])) {
            foreach ($data['prescription'] as $key => $itmes) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_sales_prescription SET clinical_sale_id = '" . (int) $herbal_id . "',prescription_id = '" . $this->db->escape($itmes['id']) . "', name = '" . $this->db->escape($itmes['name']) . "', modifi_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");

                $prescription_id = $this->db->getLastId();
                if (!empty($data['products'])) {
                    foreach ($data['products'][$key] as $product_id => $product) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "clinicalsale_product SET
                            clinical_sale_id = '" . (int) $herbal_id . "',
                            product_id = '" . (int) $product['product_id'] . "',
                            prescription_id = '" . (int) $prescription_id . "',
                            quantity = '" . (float) $product['quantity'] . "',
                            times = '" . (int) $product['times'] . "',
                            price = '" . (float) $product['price'] . "',
                            day = '" . (int) $product['day'] . "',
                            t_qty = '" . (float) $product['quantity'] * (int) $product['times'] . "',
                            weight = '" . (float) $product['product_weight'] . "',
                            weight_class_id = '" . (int) $product['weight_class_id'] . "',
                            t_weight = '" . (float) $product['weight'] . "',
                            cook = '" . $this->db->escape($product['cook']) . "',
                            taketype = '" . $this->db->escape($product['taketype']) . "',
                            t_gst = '" . (float) $product['tax'] . "',
                            discount = '" . (float) $product['discount'] . "',
                            t_net_price = '" . (float) $product['subtotal'] . "',
                            tax_class_id = '" . (int) $product['tax_class_id'] . "',
                            tax_code = '" . $this->db->escape($product['tax_code']) . "',
                            tax_format = '" . $this->db->escape($product['tax_format']) . "',
                            gst = '" . (float) $product['product_tax'] . "',
                            net_price = '" . (float) $product['product_subtotal'] . "',
                            rowtotal = '" . (float) $product['total'] . "',
                            modifi_by = '" . (int) $this->session->data['user_id'] . "',
                            date_modified = NOW()
                        ");
                        $product_total += $product['total'];
                        $product_sutotal += $product['subtotal'];
                        $product_tax += $product['tax'];
                        $times = $product['quantity'] * $product['times'];
                        $total_times += $times;
                    }
                }
                $per_time = $product['day'];
            }

            $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET clinicalsale_total = '" . (float) $product_total . "', net_total = '" . (float) $product_sutotal . "', gst = '" . (float) $product_tax . "' WHERE clinical_sale_id = '" . (int) $prescription_id . "'");
        } //end add product and prescription

        $check_service_form_exists = $this->getServiceFormByHerbalId($herbal_id);

        if (empty($check_service_form_exists)) {
            $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $herbal_id . "'");
            if (!empty($data['service'])) {
                foreach ($data['service'] as $key => $service) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_service_item SET
                        clinical_sale_id = '" . (int) $herbal_id . "',
                        clinicalservice_id = '" . (int) $service['service_id'] . "',
                        staffincharge ='" . (int) $service['staff_id'] . "',
                        servicename ='" . $this->db->escape($service['service_name']) . "',
                        serviceminutes ='" . $this->db->escape($service['service_minute']) . "',
                        price = '" . (float) $service['price'] . "',
                        tax_class_id = '" . (int) $service['tax_class_id'] . "',
                        tax_code = '" . $this->db->escape($service['tax_code']) . "',
                        tax_format = '" . $this->db->escape($service['tax_format']) . "',
                        t_gst = '" . (float) $service['tax'] . "',
                        t_net_price = '" . (int) $service['subtotal'] . "',
                        gst = '" . $service['nat_tax'] . "',
                        net_price = '" . (float) $service['net_price'] . "',
                        rowtotal = '" . (float) $service['total'] . "',
                        modifi_by = '" . (int) $this->session->data['user_id'] . "',
                        date_modified = NOW()");

                    $clinecal_service_item_id = $this->db->getLastId();

                    if (!empty($data['acupuncture_list'][$service['service_id']])) {
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize($data['acupuncture_list'][$service['service_id']])) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                    } else {
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize(array())) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                    }
                }
            }

            // ADD new service form
            if ($data['status'] == 5 && !empty($data['service'])) {
                $this->load->model('setting/setting');
                $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

                $this->db->query("INSERT INTO " . DB_PREFIX . "service_form SET invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',  clinical_sale_id = '" . (int)$herbal_id . "', customer_id = '" . (int) $data['customer_id'] . "', user_id = '" . (int) $service['staff_id'] . "', service_date = NOW(), store_id = '" . (int) $this->session->data['store_id'] . "', serviceform_action = '" . (int) 5 . "', order_action = '" . (int) 17 . "', add_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW(), modifi_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()
			    ");

                $service_form_id = $this->db->getLastId();
                if (!empty($service_form_id)) {
                    $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

                    $this->db->query("UPDATE `" . DB_PREFIX . "clinical_sale` SET `service_form_id` = '" . (int)$service_form_id . "' WHERE clinical_sale_id = '" . (int)$herbal_id . "'");

                    $service_subtotal = 0;
                    $service_total = 0;
                    $service_gst = 0;
                    foreach ($data['service'] as $key => $service) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item SET service_form_id = '" . (int) $service_form_id . "', clinicalservice_id = '" . (int) $service['service_id'] . "', servicename ='" . $this->db->escape($service['service_name']) . "',
                        serviceminutes = '" . $this->db->escape($service['service_minute']) . "', user_id = '" . (int) $this->session->data['user_id'] . "',price = '" . (float) $service['price'] . "', total = '" . (float) $service['total_whit_gst'] . "', net_amount = '" . (float) $service['net_total'] . "', tax_class_id = '" . (int) $service['tax_class_id'] . "', tax_code = '" . $this->db->escape($service['tax_code']) . "', tax_format = '" . $this->db->escape($service['tax_format']) . "', gst = '" . $service['nat_tax'] . "', modifi_by = '" . (int) $this->session->data['user_id'] . "', date_modified = NOW()");

                        $service_item_id = $this->db->getLastId();
                        if (!empty($data['acupuncture_list'][$service['service_id']])) {
                            foreach ($data['acupuncture_list'][$service['service_id']] as $acupuncture) {
                                $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point SET service_Item_id = '" . (int) $service_item_id . "', acupuncture_id = '" . (int) $acupuncture['acupuncture_id'] . "', num_of_acupuncture = '" . (int) $acupuncture['num_of_acupuncture'] . "'");
                            }
                        }

                        $service_subtotal += $service['subtotal'];
                        $service_total += $service['total'];
                        $service_gst += $service['tax'];
                    }

                    $this->db->query("UPDATE " . DB_PREFIX . "service_form SET total_price = '" . (float) $service_total . "', net_amount = '" . (float) $service_subtotal . "', t_gst = '" . (float) $service_gst . "' WHERE service_form_id = '" . (int) $service_form_id . "'");

                    $this->db->query("INSERT `" . DB_PREFIX . "service_total` SET `service_form_id` = '" . (int)$service_form_id . "', `id` = '1', `code` = 'sub_total', `tax_key` = 0, tax_code = '', title = 'Sub-Total', value = '" . (float)$service_total . "', sort_order = '1'");

                    $this->db->query("INSERT `" . DB_PREFIX . "service_total` SET `service_form_id` = '" . (int)$service_form_id . "', `id` = '1', `code` = 'tax', `tax_key` = '88', tax_code = '', title = 'Tax (0%)', value = '" . (float)$service_gst . "', sort_order = '5'");

                    $this->db->query("INSERT `" . DB_PREFIX . "service_total` SET `service_form_id` = '" . (int)$service_form_id . "', `id` = '1', `code` = 'total', `tax_key` = 0, tax_code = '', title = 'Total', value = '" . (float)$service_total . "', sort_order = '9'");
                }
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $herbal_id . "'");
        if (!empty($data['images'])) {
            foreach ($data['images'] as $key => $image) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_image SET
			  clinical_sale_id = '" . (int) $herbal_id . "',
			  folder = '" . $this->db->escape($image['name']) . "',
			  customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
			  category_id = '" . (int) $image['category_id'] . "',
			  remark = '" . $this->db->escape($image['remark']) . "',
			  image ='" . $this->db->escape($image['path']) . "',
			  modifi_by = '" . (int) $this->session->data['user_id'] . "',
			  date_modified = NOW()");
            }
        }

        // Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $herbal_id . "' AND id ='1' ");
        $subtotal = 0;
        $tax = 0;
        $total = 0;

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $herbal_id . "',id ='1',tax_code ='" . $this->db->escape($order_total['tax_code']) . "', code = '" . $this->db->escape($order_total['code']) . "', tax_key = '" . (int) $order_total['key'] . "', title = '" . $this->db->escape($order_total['title']) . "',  `value` = '" . (float) $order_total['value'] . "', sort_order = '" . (int) $order_total['sort_order'] . "'");

                if ($order_total['code'] == 'sub_total') {
                    $subtotal += $order_total['value'];
                }
                if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                }
                if ($order_total['code'] == 'total') {
                    $total += $order_total['value'];
                }
            }
        }

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET clinicalsale_total = '" . (float) $total . "', net_total = '" . (float) $subtotal . "', gst ='" . (float) $tax . "' WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        $subtotal = 0;
        $tax = 0;
        $total = 0;

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $herbal_id . "' AND id ='2' ");
        if (isset($data['total_doctor_data'])) {
            foreach ($data['total_doctor_data'] as $total_doctor_data) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $herbal_id . "',id ='2', tax_code ='" . $this->db->escape($total_doctor_data['tax_code']) . "', code = '" . $this->db->escape($total_doctor_data['code']) . "', tax_key = '" . (int) $total_doctor_data['key'] . "', title = '" . $this->db->escape($total_doctor_data['title']) . "',  `value` = '" . (float) $total_doctor_data['value'] . "', sort_order = '" . (int) $total_doctor_data['sort_order'] . "'");

                if ($total_doctor_data['code'] == 'sub_total') {
                    $subtotal += $total_doctor_data['value'];
                }
                if ($total_doctor_data['code'] == 'tax') {
                    $tax += $total_doctor_data['value'];
                }
                if ($total_doctor_data['code'] == 'total') {
                    $total += $total_doctor_data['value'];
                }
            }
        }

        $total_sales = ($data['enable_doctorprice'] == '1') ? $product_total + $data['doctor_price'] : $data['doctor_total'];

        $total_weight = $total_times; //($total_times * $per_time) * $this->config->get('config_herbal_weight');
        $weight_class_id = $this->config->get('config_herbal_weight_class_id');
        $consultation_price = $data['doctor_price'];

        // $total_all = $product_total + $consultation_price;
        $total_net =  ($data['enable_doctorprice'] == '1') ?  $data['doctor_price'] : 0;
        $total_dgst =  ($data['enable_doctorprice'] == '1') ? $data['doctor_price'] : 0;

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET total_d_gst = '" . (float) $total_dgst . "', collect_consultation_price = '" . (int) $data['enable_doctorprice'] . "', clinicalsale_concultation = '" . (float) $consultation_price . "', d_gst ='" . (float) $data['doctor_tax'] . "',d_net_amount ='" . (float) $total_net . "', tax_format='" . $this->db->escape($data['doctor_format']) . "', tax_class_id ='" . (int) $data['tax_class_id'] . "',total ='" . (float) $total_sales . "',subtotal ='" . (float) $total_sales . "',tax_code ='" . $this->db->escape($data['tax_code']) . "', currency_id = '" . (int) $currency_id . "', currency_code = '" . $this->db->escape($currency_code) . "',weight ='" . (float) $total_weight . "', weight_class_id ='" . (int) $weight_class_id . "', currency_value = '" . (float) $currency_value . "' WHERE clinical_sale_id = '" . (int) $herbal_id . "'");

        unset($this->session->data['prescription']);
        unset($this->session->data['product']);
        unset($this->session->data['service']);
        unset($this->session->data['image']);
        unset($this->session->data['shipping_addres_id']);
        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        return $herbal_id;
    }

    public function deleteHerbal($herbal_id) {
        //$this->event->trigger('pre.admin.herbal.delete', $herbal_id);
        //delete ServiceForm and ServiceForm item
        $sql = "
			UPDATE `oc_clinical_sale`
			SET
				hide = 1,
                                saved = 1,
				modifi_by 	= '" . $this->session->data['user_id'] . "',
				date_modified = NOW()
			WHERE 1 
				AND clinical_sale_id = '" . (int) $herbal_id . "'";
        $query = $this->db->query($sql);

        $this->cache->delete('herbal');

        //$this->event->trigger('post.admin.herbal.delete', $herbal_id);
    }

    public function check_got_saved_medical_record() {
        $sql = "
            SELECT 
                    COUNT(*) AS total
                FROM `oc_clinical_sale`
                WHERE 1 
                    AND saved = 1 
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row['total'])) {
            $this->update_saved_medical_record();
        }
        return !empty($query->row['total']) ? $query->row['total'] : 0;
    }

    public function update_saved_medical_record() {
        $sql = "
            UPDATE `oc_clinical_sale`
                SET
                    saved = '0'
                WHERE 1 
                    AND saved = 1
        ";
        $this->db->query($sql);
    }

    public function tickToTop($herbal_id, $top) {
        $sql = "
            UPDATE `oc_clinical_sale`
                SET
                    top = '" . (int) $top . "',
                    modifi_by 	= '" . $this->session->data['user_id'] . "',
                    date_modified = NOW()
                WHERE 1 
                AND clinical_sale_id = '" . (int) $herbal_id . "'";
        $this->db->query($sql);
    }

    public function selectHerbal($data = array()) {

        $filter_invoice_prefix_statement = isset($data['invoice_prefix']) ? "AND cs.invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "'" : "";
        $filter_clinical_sale_id_statement = isset($data['clinical_sale_id']) ? "AND cs.clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'" : "";

        $filter_clinicalsale_action_statement = isset($data['clinicalsale_action']) ? "AND cs.clinicalsale_action = '" . (int) $data['clinicalsale_action'] . "'" : "";

        $filter_customer_card_statement = isset($data['customer_card']) ? "AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'" : "";

        $filter_customer_ic_statement = isset($data['customer_ic']) ? "AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'" : "";



        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $sql = "
		SELECT
			cs.*,
			c.customer_card,
			c.customer_ic,
			c.firstname,
			c.lastname,
			c.email,
			a.address_1,
			a.address_2,
			a.address_3,
			a.city,
			a.postcode,
			a.country_id,
			ctry.name AS country,
			a.zone_id,
			z.name AS state
		FROM " . DB_PREFIX . "clinical_sale	cs
		LEFT JOIN " . DB_PREFIX . "customer c
		ON cs.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "address a
		ON c.address_id = a.address_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON a.zone_id = z.zone_id
		LEFT JOIN " . DB_PREFIX . "country ctry
		ON a.country_id = ctry.country_id
		WHERE 1
		$filter_invoice_prefix_statement
		$filter_clinical_sale_id_statement
		$filter_clinicalsale_action_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		$limit_statement
		";

        /*
          echo "<pre>";
          print_r($sql);
          echo "</pre>";
         */

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function totalSelectHerbal($data = array()) {
        $filter_invoice_prefix_statement = isset($data['invoice_prefix']) ? "AND cs.invoice_prefix = '" . $this->db->escape($data['invoice_prefix']) . "'" : "";
        $filter_clinical_sale_id_statement = isset($data['clinical_sale_id']) ? "AND cs.clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "'" : "";
        $filter_clinicalsale_action_statement = isset($data['clinicalsale_action']) ? "AND cs.clinicalsale_action = '" . (int) $data['clinicalsale_action'] . "'" : "";
        $filter_customer_card_statement = isset($data['customer_card']) ? "AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'" : "";

        $filter_customer_ic_statement = isset($data['customer_ic']) ? "AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'" : "";

        $sql = "
		SELECT
			COUNT(*) AS num
		FROM " . DB_PREFIX . "clinical_sale	cs
		LEFT JOIN " . DB_PREFIX . "customer c
		ON cs.customer_id = c.customer_id
		LEFT JOIN " . DB_PREFIX . "address a
		ON c.address_id = a.address_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON a.zone_id = z.zone_id
		LEFT JOIN " . DB_PREFIX . "country ctry
		ON a.country_id = ctry.country_id
		WHERE 1
		$filter_invoice_prefix_statement
		$filter_clinical_sale_id_statement
		$filter_clinicalsale_action_statement
		$filter_customer_card_statement
		$filter_customer_ic_statement
		";

        $query = $this->db->query($sql);

        return $query->row['num'];
    }

    public function getHerbalImages($customer_id, $herbla_id = 0) {

        $query = $this->db->query("SELECT cs.clinical_sale_id,cs.sales_date,cs.customer_id,cs.invoice_prefix FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.clinical_sale_id IN(SELECT ci.clinical_sale_id
               FROM " . DB_PREFIX . "clinical_sale_image ci) AND customer_id ='" . (int) $customer_id . "' AND cs.clinical_sale_id !='" . $herbla_id . "' ORDER BY cs.sales_date DESC");

        return $query->rows;
    }

    // added by lunguang 20160408 1815
    public function getHerbalRemediesBasicData($herbal_id) {
        $sql = "SELECT CONCAT(c.firstname, ' ', c.lastname) AS customer_name,
					   c.customer_ic,
					   cs.invoice_prefix,
					   cs.date_added,
					   CONCAT(u.firstname, ' ', u.lastname) AS doctor_name,
					   c.gender,
					   c.telephone,
					   cs.diagnostic,
					   cs.doctoradvice,
					   cs.pulse,
					   cs.disease,
					   cs.treatment,
					   cs.acupuncture,
					   cs.symptom,
                       cs.weight,
                       cs.weight_class_id,
					   csp.times,
					   csp.day,
					   csp.cook,
					   csp.taketype,
                       cs.store_id
				FROM " . DB_PREFIX . "clinical_sale cs
				LEFT JOIN " . DB_PREFIX . "customer c
				ON c.customer_id = cs.customer_id
				LEFT JOIN " . DB_PREFIX . "user u
				ON u.user_id = cs.doctor_id
				LEFT JOIN " . DB_PREFIX . "clinicalsale_product csp
				ON csp.clinical_sale_id = cs.clinical_sale_id
				WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    // added by lunguang 20160411 1716
    public function getHerbalRemediesImage($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    // added by lunguang 20160412 1257
    public function getDoctors() {
        $sql = "SELECT CONCAT(firstname, ' ', lastname) AS doctor_name, user_id FROM " . DB_PREFIX . "user WHERE position = '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    //added by lunguang 20160801 1204
    public function getTotalCustomers($data = array()) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '1' AND status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    //added by lunguang 20160801 1204
    public function getCustomers($data = array()) {
        $sql = "SELECT customer_id,
					   CONCAT(firstname, ' ', lastname) AS customer_name,
					   customer_ic,
					   customer_card
				FROM " . DB_PREFIX . "customer
				WHERE status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerByIC($data = array()) {
        $sql = "SELECT customer_id, CONCAT(firstname, ' ', lastname) AS customer_name, customer_card, customer_ic FROM " . DB_PREFIX . "customer WHERE status = '1'";

        if (isset($data['customer_ic'])) {
            $sql .= " AND customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateCustomer($herbal_id, $customer_id) {
        $sql = "UPDATE " . DB_PREFIX . "clinical_sale
				SET customer_id = '" . (int) $customer_id . "'
				WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);
    }

    public function getPatientPrescription($herbal_id) {
        $prescriptions = array();

        $sql = "SELECT *
				FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE
				clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);

        $prescription_rows = $query->rows;
        if (!empty($prescription_rows)) {
            foreach ($prescription_rows as $prescription) {
                $sql_prescription_item = "SELECT cp.product_id,
												 pd.name AS product_name,
												 p.code,
												 cp.quantity,
												 cp.times,
												 cp.day
										  FROM " . DB_PREFIX . "clinicalsale_product cp
										  LEFT JOIN " . DB_PREFIX . "product p
										  ON p.product_id = cp.product_id
										  LEFT JOIN " . DB_PREFIX . "product_description pd
										  ON pd.product_id = cp.product_id
										  AND pd.language_id = " . $this->config->get('config_language_id') . "
										  WHERE prescription_id = '" . (int) $prescription['clinical_sale_prescription_id'] . "'";

                $prescription_item_query = $this->db->query($sql_prescription_item);

                $prescription_item_rows = $prescription_item_query->rows;

                if (!empty($prescription_item_rows)) {
                    foreach ($prescription_item_rows as $item) {
                        $prescription_items[$prescription['clinical_sale_prescription_id']][] = array(
                            'product_id' => $item['product_id'],
                            'product_name' => $item['product_name'],
                            'product_code' => $item['code'],
                            'quantity' => $item['quantity'],
                            'times' => $item['times'],
                            'day' => $item['day']
                        );
                    }
                } else {
                    $prescription_items[$prescription['clinical_sale_prescription_id']] = array();
                }

                $prescriptions[] = array(
                    'clinical_sale_prescription_id' => $prescription['clinical_sale_prescription_id'],
                    'prescription_name' => $prescription['name'],
                    'prescription_items' => $prescription_items[$prescription['clinical_sale_prescription_id']]
                );
            }
        } else {
            $prescription = array();
        }

        return $prescriptions;
    }

    public function getDoctorDevice($doctor_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int) $doctor_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAcupunctureNameById($acupuncture_id) {
        $sql = "SELECT name
				FROM " . DB_PREFIX . "acupuncture_name
				WHERE language_id = '" . $this->config->get('config_language_id') . "'
				AND acupuncture_id = '" . (int) $acupuncture_id . "'";

        $query = $this->db->query($sql);

        return $query->row['name'];
    }

    public function getHerbalServiceAcupuncture($herbal_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $herbal_id . "'";

        $query = $this->db->query($sql);
        $clinical_service_items = $query->rows;

        $herbal_service_acupuncture_arr = array();

        foreach ($clinical_service_items as $item) {
            $clinical_service_id = $item['clinicalservice_id'];
            $acupuncture_parts_arr = unserialize($item['acupuncture_parts']);

            $herbal_service_acupuncture_arr[$clinical_service_id] = $acupuncture_parts_arr;
        }

        return $herbal_service_acupuncture_arr;
    }

    public function getAutocompleteFormCustomers($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = '1' AND approved = '1'";

        if (!empty($data['filter_firstname'])) {
            $sql .= " AND firstname LIKE '%" . $this->db->escape($data['filter_firstname']) . "%'";
        }

        if (!empty($data['filter_lastname'])) {
            $sql .= " AND lastname LIKE '%" . $this->db->escape($data['filter_lastname']) . "%'";
        }

        if (!empty($data['filter_telephone'])) {
            $sql .= " AND telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (!empty($data['filter_customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['filter_customer_ic']) . "%'";
        }

        if (!empty($data['filter_customer_card'])) {
            $sql .= " AND customer_card LIKE '%" . $this->db->escape($data['filter_customer_card']) . "%'";
        }

        if (!empty($data['filter_email'])) {
            $sql .= " AND email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_occupation'])) {
            $sql .= " AND occupation LIKE '%" . $this->db->escape($data['filter_occupation']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }
    public function getProduct($product_id) {
        $language_id = $this->config->get('config_language_id');
        $query = $this->db->query("
			SELECT
					DISTINCT *,
					( SELECT
							ua.keyword
						FROM `oc_url_alias` ua
						WHERE ua.query = 'product_id=" . (int) $product_id . "'
					) AS keyword
				FROM `oc_product` p
					LEFT JOIN `oc_product_description` pd
						ON (p.product_id = pd.product_id)
				WHERE p.product_id = '" . (int) $product_id . "'
					AND pd.language_id = '" . (int) $language_id . "'
		");
        return $query->row;
    }

    public function getUserGroup($user_id) {
        $sql = "
			SELECT 
					(user_id),user_group_id
				FROM `oc_user` 
				WHERE user_group_id ='1'
				AND user_id = '" . (int) $user_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    //select customer for addCustomer page
    public function selectCustomers($data = array()) {
        $sql = "SELECT * from " . DB_PREFIX . "customer c WHERE c.status = '1' AND c.approved = '1'";

        //print_r($sql);

        if (isset($data['customer_ic']) && !is_null($data['customer_ic'])) {
            $sql .= " AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
        }

        if (isset($data['customer_card']) && !is_null($data['customer_card'])) {
            $sql .= " AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAddresses($customer_id) {
        $address_data = array();

        $query = $this->db->query("SELECT address_id FROM " . DB_PREFIX . "address WHERE customer_id = '" . (int) $customer_id . "'");

        foreach ($query->rows as $result) {
            $address_info = $this->getAddress($result['address_id']);

            if ($address_info) {
                $address_data[$result['address_id']] = $address_info;
            }
        }

        return $address_data;
    }

    public function getAddress($address_id) {
        $address_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = '" . (int) $address_id . "'");

        if ($address_query->num_rows) {
            $country_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "country` WHERE country_id = '" . (int) $address_query->row['country_id'] . "'");

            if ($country_query->num_rows) {
                $country = $country_query->row['name'];
                $iso_code_2 = $country_query->row['iso_code_2'];
                $iso_code_3 = $country_query->row['iso_code_3'];
                $address_format = $country_query->row['address_format'];
            } else {
                $country = '';
                $iso_code_2 = '';
                $iso_code_3 = '';
                $address_format = '';
            }

            $zone_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "zone` WHERE zone_id = '" . (int) $address_query->row['zone_id'] . "'");

            if ($zone_query->num_rows) {
                $zone = $zone_query->row['name'];
                $zone_code = $zone_query->row['code'];
            } else {
                $zone = '';
                $zone_code = '';
            }

            return array(
                'address_id' => $address_query->row['address_id'],
                'customer_id' => $address_query->row['customer_id'],
                'firstname' => $address_query->row['firstname'],
                'lastname' => $address_query->row['lastname'],
                'company' => $address_query->row['company'],
                'address_1' => $address_query->row['address_1'],
                'address_2' => $address_query->row['address_2'],
                'address_3' => $address_query->row['address_3'],
                'postcode' => $address_query->row['postcode'],
                'city' => $address_query->row['city'],
                'zone_id' => $address_query->row['zone_id'],
                'zone' => $zone,
                'zone_code' => $zone_code,
                'country_id' => $address_query->row['country_id'],
                'country' => $country,
                'iso_code_2' => $iso_code_2,
                'iso_code_3' => $iso_code_3,
                'address_format' => $address_format,
                'custom_field' => unserialize($address_query->row['custom_field'])
            );
        }
    }

    public function getUserInfo($user_id) {
        $query = $this->db->query("SELECT CONCAT(firstname,' ',lastname) AS name FROM `oc_user` WHERE 1 AND user_id = '" . (int)$user_id . "'");
        return $query->row;
    }

    public function getStoreInfo($store_id) {
        $query = $this->db->query("SELECT name FROM `oc_store` WHERE 1 AND store_id = '" . (int)$store_id . "'");
        return $query->row;
    }

    // *** NEW *** //
    // Put in herbal/customer.php
    public function getCustomer($value, $type) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "customer` WHERE 1 AND `status` = 1 ";

        switch ($type) {
            case 'customer_id':
                $sql .= " AND `customer_id` = '" . (int)$value . "'";
            case 'customer_card':
                $sql .= " AND `customer_card` = '" . $this->db->escape($value) . "'";
            case 'customer_ic':
                $sql .= " AND `customer_ic` = '" . $this->db->escape($value) . "'";
            case 'email':
                $sql .= " AND `email` = '" . $this->db->escape($value) . "'";
            case 'telephone':
                $sql .= " AND `telephone` = '" . $this->db->escape($value) . "'";
            default:
                $sql .= " AND `customer_id` = '0'";
        }

        $query = $this->db->query($sql);
        return $query->row;
    }
    // *** NEW END *** //

    public function installUpdateNewRelease() {
        /** INSERT NGP settings into oc_settings */
        $ngp_settings = [
            ['code' => 'config_ngp', 'key' => 'config_ngp_webservices_connection_url', 'value' => '', 'serialized' => 0],
            ['code' => 'config_ngp', 'key' => 'config_ngp_webservices_status', 'value' => '0', 'serialized' => 0],
            ['code' => 'config_ngp', 'key' => 'config_ngp_webservices_send_prescription_url', 'value' => '', 'serialized' => 0],
            ['code' => 'config_ngp', 'key' => 'config_ngp_webservices_send_prescription_location_url', 'value' => '', 'serialized' => 0]
        ];
        foreach ($ngp_settings as $nsetting) {
            if (!$this->checkSettingExists($nsetting['code'], $nsetting['key'])) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "setting` SET `store_id` = '" . (int) $this->session->data['store_id'] . "', `code` = '" . $this->db->escape($nsetting['code']) . "', `key` = '" . $this->db->escape($nsetting['key']) . "', `value` = '" . $this->db->escape($nsetting['value']) . "', `serialized` = '" . (int)$nsetting['serialized'] . "'");
            }
        }
        
        /** INSERT Herbal settings into oc_settings */
        $clinicalsale_edit_settings = [
            ['code' => 'config_herbal', 'key' => 'config_herbal_edit_form_edit_product_price', 'value' => '0', 'serialized' => 0]
        ];
        foreach ($clinicalsale_edit_settings as $csedsetting) {
            if (!$this->checkSettingExists($csedsetting['code'], $csedsetting['key'])) {
                $this->db->query("INSERT INTO `" . DB_PREFIX . "setting` SET `store_id` = '" . (int) $this->session->data['store_id'] . "', `code` = '" . $this->db->escape($csedsetting['code']) . "', `key` = '" . $this->db->escape($csedsetting['key']) . "', `value` = '" . $this->db->escape($csedsetting['value']) . "', `serialized` = '" . (int)$csedsetting['serialized'] . "'");
            }
        }

        /** Allow the total quantity to record decimal, so change the `t_qty` column from INT to Decimal (10,2) */
        $this->db->query("
            ALTER TABLE `oc_clinicalsale_product` CHANGE `t_qty` `t_qty` DECIMAL(10,2) NOT NULL;
        ");

    }

    protected function checkSettingExists($code,$key) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX ."setting` WHERE 1 AND `store_id` = '" . (int)$this->session->data['store_id'] . "' AND `code` = '" . $this->db->escape($code) .  "' AND `key` = '" . $this->db->escape($key) . "'");
        return $query->row;
    }
}
