<?php
class ModelCatalogStockTransfer extends Model {
    public function getTransfers($data = array()) {
        $sql = "SELECT *, a.status transfer_status FROM " . DB_PREFIX . "stock_transfer a INNER JOIN " . DB_PREFIX . "store b ON (a.from_store=b.store_id) WHERE stock_transfer_id != ''";

        if (!empty($data['filter_date'])) {
            $sql .= " AND DATE(a.transfer_date) = DATE('" . $this->db->escape($data['filter_date']) . "')";
        }

        if (!empty($data['filter_trans_no'])) {
            $sql .= " AND a.transfer_no LIKE '%" . $this->db->escape($data['filter_trans_no']) . "%'";
        }

        if (!empty($data['filter_from'])) {
            $sql .= " AND a.from_store = '" . (int)$data['filter_from'] . "'";
        }

        if (isset($data['filter_status'])) {
            $sql .= " AND a.status = '" . (int)$data['filter_status'] . "'";
        }

        if (!empty($data['filter_approved'])) {
            $sql .= " AND DATE(a.approved_date) = DATE('" . $this->db->escape($data['filter_approved']) . "')";
        }

        if ($data['filter_store_id'] != '0') {
            $sql .= " AND a.from_store = '" . (int)$data['filter_store_id'] . "'";
        }

        if ($this->session->data['store_id'] == 0) {
            $sql .= " AND a.status != 6";
        }
    

        $sort_data = array(
            'a.transfer_date',
            'a.transfer_no',
            'a.from_store',
            'a.to_store',
            'a.approved_date',
            'a.accepted_date',
            'a.delivered_date',
            'a.received_date',
            'a.status'
           
            
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY  a.transfer_date DESC, a.transfer_no ";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }


        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalTransfers($data = array()) {
        $sql = "SELECT COUNT(*) as total FROM " . DB_PREFIX . "stock_transfer a INNER JOIN " . DB_PREFIX . "store b ON (a.from_store=b.store_id) WHERE stock_transfer_id != ''";

        if (!empty($data['filter_date'])) {
            $sql .= " AND DATE(a.transfer_date) = DATE('" . $this->db->escape($data['filter_date']) . "')";
        }

        if (!empty($data['filter_trans_no'])) {
            $sql .= " AND a.transfer_no LIKE '%" . $this->db->escape($data['filter_trans_no']) . "%'";
        }

        if (!empty($data['filter_from'])) {
            $sql .= " AND a.from_store = '" . (int)$data['filter_from'] . "'";
        }

        if (isset($data['filter_status'])) {
            $sql .= " AND a.status = '" . (int)$data['filter_status'] . "'";
        }

        if ($this->session->data['store_id'] == 0) {
            $sql .= " AND a.status != 6";
        }

        if (!empty($data['filter_approved'])) {
            $sql .= " AND DATE(a.approved_date) = DATE('" . $this->db->escape($data['filter_approved']) . "')";
        }

        if ($data['filter_store_id'] != '0') {
            $sql .= " AND a.from_store = '" . (int)$data['filter_store_id'] . "'";
        }

        if ($this->session->data['store_id'] == 0) {
            $sql .= " AND a.status != 6";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getTransactionNo() {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "transaction_no tn WHERE tn.prefix LIKE '%-ST' AND tn.store_id = " . $this->session->data['store_id']);

        return $query->row;
    }

    public function getStockTransfer($stock_transfer_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "stock_transfer a LEFT JOIN " . DB_PREFIX . "stock_transfer_detail ad ON (a.stock_transfer_id = ad.stock_transfer_id) WHERE a.stock_transfer_id = '" . (int)$stock_transfer_id . "'");

        return $query->row;
    }

    public function getStockTransferDetails($stock_transfer_id) {
        $query = $this->db->query("SELECT *, (a.order_quantity * b.price) as total_row FROM " . DB_PREFIX . "stock_transfer_detail a INNER JOIN " . DB_PREFIX . "product b ON (a.product_id = b.product_id) INNER JOIN " . DB_PREFIX . "product_description c ON (a.product_id = c.product_id) WHERE a.stock_transfer_id = '" . (int)$stock_transfer_id . "' AND c.language_id = '" . (int)$this->config->get('config_language_id') . "'");

        if (!empty($query->rows)) {
            foreach ($query->rows as $transfer) {
                $data['transfers'][] = array(
                    'product_id'                => $transfer['product_id'],
                    'product_code'              => $transfer['code'],
                    'product_name'              => $transfer['name'],
                    'product_selling_price'     => $transfer['price'],
                    'product_quantity'          => $transfer['order_quantity'],
                    'transfer_quantity'         => $transfer['transfer_quantity'],
                    'received_quantity'         => $transfer['received_quantity'],
                    'total_row'                 => $transfer['total_row'],
                );
            }
        } else {
            $data['transfers'] = array();
        }

        return $data['transfers'];
    }

    public function updateTransactionNo() {
        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = lastrunningno + 1 WHERE prefix LIKE '%-ST' AND store_id = " . $this->session->data['store_id']);
    }

    public function getStore($store_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store st WHERE st.store_id = " . $store_id);

        return $query->row;
    }

    public function calculateProduct($product_code, $product_quantity) {
        $query = $this->db->query("SELECT p.price * " . $product_quantity . " as row_total FROM " . DB_PREFIX . "product p WHERE p.code = '" . $product_code . "'");

        return $query->row;
    }
    
    public function getProductByCode($code) {
        $query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "product` p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.code = '" . $this->db->escape($code) . "' AND p.code != ''");

        return $query->rows;
    }

    public function addStockTransfer($data, $transaction_no) {
        $this->db->query("INSERT INTO " . DB_PREFIX . "stock_transfer SET transfer_no = '" . $this->db->escape($transaction_no) . "', to_store = '" . (int)$data['to_branch'] . "', from_store = '" . (int)$data['from_branch'] . "', transfer_date = '" . $this->db->escape($data['transfer_date']) . "', status = '" . (int)$data['status'] . "', priority = '" . (int)$data['priority'] . "', remark = '" . $this->db->escape($data['remark']) . "', total = '" . $this->db->escape($data['product_total']) . "', created_by = '" . $this->user->getId() . "', created_date = NOW(), lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW()");

        $stock_transfer_id = $this->db->getLastId();

        if (!empty($data['transfer'])) {
            foreach ($data['transfer'] as $key => $value) {
                if ($value['product_code'] != '') {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "stock_transfer_detail SET stock_transfer_id = '" . (int)$stock_transfer_id . "', product_id = '" . (int)$value['product_id'] . "', order_quantity = '" . $value['product_quantity'] . "', created_by = '" . $this->user->getId() . "', created_date = NOW(), lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW()");
                }
            }
        }

        if ($stock_transfer_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_transfer', 'store' => $this->session->data['store_id']));
        }

        return $stock_transfer_id;
    }

    public function updateStockTransfer($data, $stock_transfer_id) {
        $diff = array();

        foreach ($data['transfer'] as $key => $value) {
            
            $transfer_qty = !empty($value['transfer_quantity']) ? $value['transfer_quantity'] : '';
            
            if ($value['product_quantity'] != $transfer_qty) {
                // status = approved (1)
                array_push($diff, 'approved');
            } else {
                // status = accepted (2)
                array_push($diff, 'accepted');
            }
        }

        if ($data['status'] == 1) {
            $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', lastmodified_date = NOW(), approved_date = NOW()";
            //$sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '2', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW(), accepted_date = NOW()";
             if (in_array('approved', $diff)) {
                 $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW()";
             } else {
                 $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW()";
            }
        }
        else if ($data['status'] == 2) {
            $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW(), accepted_date = NOW()";
        }
        else if ($data['status'] == 3) {
            $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW(), delivered_date = NOW()";
        }
        else if ($data['status'] == 4) {
            $sql = "UPDATE " . DB_PREFIX . "stock_transfer SET status = '" . (int)$data['status'] . "', remark = '" . $this->db->escape($data['remark']) . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW(), received_date = NOW()";
        }

        if ($data['status'] == 1) {
             if (in_array('approved', $diff)) {
                 $sql .= ", approved_date = NOW()";
            }
         } else if ($data['status'] == 2) {
             $sql .= ", accepted_date = NOW()";
         } else if ($data['status'] == 3) {
             $sql .= ", delivered_date = NOW()";
         } else if ($data['status'] == 4) {
             $sql .= ", received_date = NOW()";
         }

        $sql .= " WHERE stock_transfer_id = '" . (int)$stock_transfer_id . "'";

        $this->db->query($sql);

        //MINUS and PLUS onhand_quantity (oc_product_to_store)
        if ($data['status'] == 4) {
            foreach ($data['transfer'] as $key => $value) {
                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity - '" . $value['received_quantity'] . "', product_lastmodifiedby = '" . $this->user->getId() . "', product_lastmodifieddate = NOW() WHERE product_id = '" . (int)$value['product_id'] . "' AND store_id = '" . (int)$data['to_branch'] . "'");
                $this->db->query("UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity + '" . $value['received_quantity'] . "', product_lastmodifiedby = '" . $this->user->getId() . "', product_lastmodifieddate = NOW() WHERE product_id = '" . (int)$value['product_id'] . "' AND store_id = '" . (int)$data['from_branch'] . "'");
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "stock_transfer_detail WHERE stock_transfer_id = '" . (int)$stock_transfer_id . "'");

        foreach ($data['transfer'] as $key => $value) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "stock_transfer_detail SET stock_transfer_id = '" . (int)$stock_transfer_id . "', product_id = '" . (int)$value['product_id'] . "', order_quantity = '" . $value['product_quantity'] . "', transfer_quantity = " . ( empty($value['transfer_quantity']) ? 'NULL' : $value['transfer_quantity'] ) . ", received_quantity = " . ( empty($value['received_quantity']) ? 'NULL' : $value['received_quantity'] ) . ", created_by = '" . $this->user->getId() . "', created_date = NOW(), lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW()");
        }
    }   
}

?>