<?php

class ModelCatalogStockTake extends Model
{

	public function getStockTakeList($data)
	{

		

		// $filter_location_statement = (!empty($data['filter_location'])) ?
		// " AND stp.location_id = '" . (int)$data['filter_location'] . "'" :
		// "";
		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(stp.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(stp.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND stp.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND stp.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_doc_no = (!empty($data['filter_doc_no']))?
		" AND st.doc_no LIKE '%" . $this->db->escape($data['filter_doc_no']) . "%'" :
		"";
		

		$filter_remark = (!empty($data['filter_remark']))?
		" AND st.description LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : 
		"";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";
        $filter_location_statement = $data['filter_location'] != '' ? "AND stp.location_id in (" . $data['filter_location'] . ")" : '';


		$filter_staff='';
        if(!empty($data['filter_add_by'])){
            $staff = explode(',',$data['filter_add_by']);
            if(!empty($staff)){
                $staff_sql='';
                foreach($staff as $staffs){
                    $staff_sql .=",'" . $staffs . "'";
                }
                $add_by = substr($staff_sql,1);
            }
        }
		
		$filter_status = $data['filter_status'] != '' ? "AND st.status in (" . $data['filter_status'] . ")" : '';
		$filter_add_by = $data['filter_add_by'] != '' ? "AND stp.added_by in ( " . $add_by . ")" : '';
		$filter_category = $data['filter_category'] != '' ? "AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in ( " . $data['filter_category'] . ")" : '';


		// $filter_add_by = (!empty($data['filter_add_by']))?
		// " AND stp.added_by = '" . $add_by . "'" :
		// "";
		$filter_store_id = $data['filter_store_id'] != '' ? "AND st.store_id in (" . $data['filter_store_id']  . ")" : '';

		// $filter_store_id = ($data['filter_store_id'] != '')?
		// " AND st.store_id = '" . (int)$data['filter_store_id'] . "'" :
		// "";

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

		$sql = "
			SELECT 
			stp.stock_take_product_id AS stock_take_product_id,
			stp.product_id AS product_id,
			stp.batch_date AS batch_date,
			stp.stock_onhand AS onhand,
			stp.stock_balance AS balance,
			wcd.unit AS unit,
			stp.date_added  AS date_added,
			stp.date_modified AS date_modified,
			stp.location_id AS location_id,
			stp.qty AS qty,
			stp.location AS location,
			stp.added_by,
			stp.remark AS remark,
			p.model AS product_name,
			p.code AS product_code,
			CONCAT(u.firstname,'',u.lastname) AS add_by,
			CONCAT(u.firstname,'',u.lastname) AS modified_by,
			st.doc_no AS doc_no,
			st.status AS status,
			st.doc_date AS doc_date,
			st.description AS description,
			st.stock_take_id AS stock_take_id,
			st.store_id AS store_id,
			st.zerolise AS zerolise,
			(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,
			cd.name AS category,
			s.name AS store_name

			FROM
			" . DB_PREFIX . "stock_take_product stp
			LEFT JOIN " . DB_PREFIX . "stock_take st
			ON stp.stock_take_id = st.stock_take_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON stp.product_id = p.product_id
			LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
			ON stp.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
			LEFT JOIN " . DB_PREFIX . "user u
			ON stp.added_by = u.user_id 
			LEFT JOIN " . DB_PREFIX . "product_to_category ptc
			ON stp.product_id = ptc.product_id
			LEFT JOIN " . DB_PREFIX . "category_description cd
			ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
			LEFT JOIN " . DB_PREFIX . "store s
			ON st.store_id = s.store_id	
			WHERE 1 
			$filter_location_statement
			$filter_date_from
			$filter_date_to
			$filter_batch_date_from
			$filter_batch_date_to
			$filter_doc_no
			$filter_remark
			$filter_product_name
			$filter_product_code
			$filter_add_by
			$filter_store_id
			$filter_status
			$filter_category
			GROUP BY stp.stock_take_product_id
		 	ORDER BY st.doc_date DESC, st.doc_no DESC , stp.stock_take_product_id DESC
			LIMIT $start, $limit ";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function totalStockTake($data)
	{

		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(stp.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(stp.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND stp.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND stp.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_doc_no = (!empty($data['filter_doc_no']))?
		" AND st.doc_no LIKE '%" . $this->db->escape($data['filter_doc_no']) . "%'" :
		"";
		

		$filter_remark = (!empty($data['filter_remark']))?
		" AND st.description LIKE '%" . $this->db->escape($data['filter_remark']) . "%'" : 
		"";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";
        $filter_location_statement = $data['filter_location'] != '' ? "AND stp.location_id in (" . $data['filter_location'] . ")" : '';


		$filter_staff='';
        if(!empty($data['filter_add_by'])){
            $staff = explode(',',$data['filter_add_by']);
            if(!empty($staff)){
                $staff_sql='';
                foreach($staff as $staffs){
                    $staff_sql .=",'" . $staffs . "'";
                }
                $add_by = substr($staff_sql,1);
            }
        }
		
		$filter_status = $data['filter_status'] != '' ? "AND st.status in (" . $data['filter_status'] . ")" : '';
		$filter_add_by = $data['filter_add_by'] != '' ? "AND stp.added_by in ( " . $add_by . ")" : '';
		$filter_category = $data['filter_category'] != '' ? "AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in ( " . $data['filter_category'] . ")" : '';


		// $filter_add_by = (!empty($data['filter_add_by']))?
		// " AND stp.added_by = '" . $add_by . "'" :
		// "";
		$filter_store_id = $data['filter_store_id'] != '' ? "AND st.store_id in (" . $data['filter_store_id']  . ")" : '';

		// $filter_store_id = ($data['filter_store_id'] != '')?
		// " AND st.store_id = '" . (int)$data['filter_store_id'] . "'" :
		// "";

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

		$sql = "
			SELECT COUNT(DISTINCT stp.stock_take_product_id) AS total

			FROM
			" . DB_PREFIX . "stock_take_product stp
			LEFT JOIN " . DB_PREFIX . "stock_take st
			ON stp.stock_take_id = st.stock_take_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON stp.product_id = p.product_id
			LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
			ON stp.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
			LEFT JOIN " . DB_PREFIX . "user u
			ON stp.added_by = u.user_id 
			LEFT JOIN " . DB_PREFIX . "product_to_category ptc
			ON stp.product_id = ptc.product_id
			LEFT JOIN " . DB_PREFIX . "category_description cd
			ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
			LEFT JOIN " . DB_PREFIX . "store s
			ON st.store_id = s.store_id	
			WHERE 1 
			$filter_location_statement
			$filter_date_from
			$filter_date_to
			$filter_batch_date_from
			$filter_batch_date_to
			$filter_doc_no
			$filter_remark
			$filter_product_name
			$filter_product_code
			$filter_add_by
			$filter_store_id
			$filter_status
			$filter_category
			 ";



		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function totalStockTake_backup($data)
	{

		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;
		$filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
		$filter_batch_date_str = trim($filter_batch_date);
		$filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
			$filter_product_name_statement .= empty($filter_product_name_statement) ? " a.en_cn_product_name LIKE '%" . $product_name . "%'" : " OR a.en_cn_product_name LIKE '%" . $product_name . "%'";
		}
		$filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

		$filter_doc_no_statement = "";

		foreach ($filter_doc_no as $product_doc_no) {
			$filter_doc_no_statement .= empty($filter_doc_no_statement) ? " a.doc_no LIKE '%" . $product_doc_no . "%'" : " OR a.doc_no LIKE '%" . $product_doc_no . "%'";
		}
		$filter_doc_no_statement = !empty($filter_doc_no_statement) ? " AND ($filter_doc_no_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
			$filter_product_code_statement .= empty($filter_product_code_statement) ? " a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
		}
		$filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";



		$filter_store_id_statement = $data['filter_store_id'] != '' ?

			"AND a.store_id = '" . (int)$data['filter_store_id'] . "'" :

			"";

		$filter_location_id_statement = $data['filter_location'] != '' ?

			"AND a.location_id = '" . (int)$data['filter_location'] . "'" :

			"";


		$filter_add_by_statement = !empty($data['filter_add_by']) ?

			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :

			"";

		$filter_category_id_statement = !empty($data['filter_category']) ?

			"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

			"";

		$filter_status_statement = !empty($data['filter_status']) ?

			"AND a.status in (" . implode(',', $data['filter_status']) . ")" :

			"";

		$sql = "

		SELECT COUNT(*) AS total

		FROM(

			SELECT
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				" . DB_PREFIX . "stock_take_product.location,
				" . DB_PREFIX . "stock_take_product.date_added,
				" . DB_PREFIX . "stock_take_product.date_modified,
				" . DB_PREFIX . "stock_take_product.product_id,
				" . DB_PREFIX . "stock_take_product.location_id,

				" . DB_PREFIX . "product_description.name as product_name,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "category_description.category_id,
				" . DB_PREFIX . "category_description.name AS category,

				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				" . DB_PREFIX . "stock_take.doc_date,
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				" . DB_PREFIX . "stock_take_product.batch_date,
				" . DB_PREFIX . "stock_take_product.stock_onhand,
				" . DB_PREFIX . "stock_take_product.stock_balance,
				pd_cn.name as product_name2,
				CONCAT(" . DB_PREFIX . "product_description.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


			FROM

				" . DB_PREFIX . "stock_take_product 

				" . DB_PREFIX . "stock_take_product 

				LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "stock_take 
				ON (" . DB_PREFIX . "stock_take.stock_take_id=" . DB_PREFIX . "stock_take_product.stock_take_id)

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')


				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take_product.added_by = " . DB_PREFIX . "user.user_id)

				, " . DB_PREFIX . "product_to_category

				LEFT JOIN " . DB_PREFIX . "category_description  
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "')


			UNION

			SELECT
			" . DB_PREFIX . "stock_take.added_by as user_id,
				'None' as location,
				" . DB_PREFIX . "stock_take.date_added,
				" . DB_PREFIX . "stock_take.date_modified,
				'0' as product_id,
				'0' as location_id,
				'None' as batch_date,
				'None' as product_name,
				'None' as product_name2,
				'None' as product_code,
				'0.0000' AS stock_onhand,
				'0.0000' AS stock_balance,
				'' as category,
				'' as category_id,
				'None' AS 'en_cn_product_name',

				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				" . DB_PREFIX . "stock_take.doc_date,
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


			FROM

				" . DB_PREFIX . "stock_take

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take.added_by = " . DB_PREFIX . "user.user_id)

			WHERE 

			" . DB_PREFIX . "stock_take.stock_take_id NOT IN (SELECT DISTINCT(stock_take_id) FROM " . DB_PREFIX . "stock_take_product)

		)a

		WHERE 1

		$filter_doc_no_statement

		$filter_add_by_statement

        $filter_date_from_statement

		$filter_date_to_statement

		$filter_store_id_statement
		
		$filter_location_id_statement

		$filter_category_id_statement

		$filter_status_statement
		
		$filter_product_code_statement
		
		$filter_product_id_statement

		$filter_product_name_statement

		$filter_batch_date_from_statement

		$filter_batch_date_to_statement


		";

		$query = $this->db->query($sql);



		return $query->row['total'];
	}

	public function getStockTake($stock_take_id)
	{
		$stock_take_info = array();
		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];
		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT
				" . DB_PREFIX . "stock_take.*,
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'staff',
				" . DB_PREFIX . "stock_take.store_id
			FROM
				" . DB_PREFIX . "stock_take,
				" . DB_PREFIX . "user
			WHERE " . DB_PREFIX . "stock_take.added_by = " . DB_PREFIX . "user.user_id
			AND " . DB_PREFIX . "stock_take.stock_take_id = $stock_take_id
		";

		$query = $this->db->query($sql);
		$stock_take_info = $query->row;
		if (!empty($stock_take_info['store_id'])) {
			$store_id = $stock_take_info['store_id'];
		}

		$sql = "
			SELECT 
					stp.stock_take_product_id,
					st.store_id,
					stp.stock_adjustment_id,
					stp.product_id,
					p.code,
					pd_en.name AS product_name,
					pd_cn.name AS product_name2,
					GROUP_CONCAT(cd.name) AS category,
					stp.stock_balance,
					stp.qty,
					stp.weight_class_id,
					wcd.unit,
					stp.location_id,
					(CASE WHEN stp.location_id > 0 THEN stp.location ELSE 'Default Location' END) AS location,
					(CASE WHEN stp.batch_date <>'' THEN stp.batch_date ELSE '0000-00-00' END) AS batch_date,
					stp.remark,
					stp.date_modified,
					CONCAT(u.firstname,' ',u.lastname) AS modify_by
				FROM `" . DB_PREFIX . "stock_take_product` stp
					LEFT JOIN `" . DB_PREFIX . "stock_take` st
						ON (st.stock_take_id = stp.stock_take_id)
					LEFT JOIN `" . DB_PREFIX . "product` p
						ON (p.`product_id` = stp.`product_id`)
					LEFT JOIN `" . DB_PREFIX . "product_description` pd_en 
						ON (pd_en.`product_id` = p.`product_id` AND pd_en.`language_id`= '1') 
					LEFT JOIN  `" . DB_PREFIX . "product_description` pd_cn 
						ON (pd_cn.`product_id` = p.`product_id` AND pd_cn.`language_id` = 2) 
					LEFT JOIN `" . DB_PREFIX . "user` u
						ON (u.`user_id` = stp.`modified_by`) 
					LEFT JOIN `" . DB_PREFIX . "weight_class_description` wcd
						ON (wcd.`weight_class_id` = stp.`weight_class_id` AND wcd.`language_id` = '" . (int)$language_id . "')
					LEFT JOIN `" . DB_PREFIX . "product_to_category` ptc
						ON (ptc.`product_id` = p.`product_id`)
					LEFT JOIN `" . DB_PREFIX . "category_description` cd
						ON (ptc.`category_id` = cd.`category_id` AND cd.language_id = '" .  (int)$language_id . "')
				WHERE stp.stock_take_id = '" . (int)$stock_take_id . "'
				GROUP BY stp.stock_take_product_id
				ORDER BY stp.stock_take_product_id ASC
		";

		$query = $this->db->query($sql);
		$stock_take_items = $query->rows;
		foreach ($stock_take_items as $product) {
			$batch_date = !empty($product['batch_date']) ? $product['batch_date'] : NULL;
			$qty_onhand = $this->getProductStock($store_id, $product['product_id'], $product['location_id'], $batch_date);
			$stock_take_info['stock_take_item'][$product['stock_take_product_id']] = array(
				'stock_take_product_id' => $product['stock_take_product_id'],
				'store_id' => $store_id,
				'stock_adjustment_id' => $product['stock_adjustment_id'],
				'product_id' => $product['product_id'],
				'code' => $product['code'],
				'name' => $product['product_name'],
				'product_name2' => $product['product_name2'],
				'onhand_quantity' => "$qty_onhand", // Onhand Quantity
				'qty' => $product['qty'],
				'category' => $product['category'],
				'weight_class_id' => $product['weight_class_id'],
				'unit' => $product['unit'],
				'stock_balance' => $product['stock_balance'],
				'location' => $product['location_id'],
				'location_text' => ($product['location_id'] > 0) ? $product['location'] : 'Default Location',
				'batch_date' => $product['batch_date'],
				'remark' => $product['remark'],
				'date_modified' => $product['date_modified'],
				'modify_by' => $product['modify_by']
			);
		}

		return $stock_take_info;
	}

	public function getStockTakeProducts($stock_take_id)
	{
		$stock_take_info = array();
		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];
		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT
				stp.stock_take_product_id,
				stp.stock_adjustment_id,
				stp.location_id,
				stp.remark,
				stp.modified_by,
				stp.stock_take_id,
				stp.qty, 
                st.doc_no,
                st.description,
                stp.product_id, 
                p.code, 
                pd_en.name AS product_name, 
                pd_cn.name AS product_name2,
                GROUP_CONCAT(cd.name separator ', ') AS category,
                stp.batch_date,
                stp.location,
				(CASE WHEN st.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
				wcd.weight_class_id,
                wcd.unit,
                stp.stock_onhand,
				stp.stock_balance,
                DATE_FORMAT(stp.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'
			FROM

				" . DB_PREFIX . "stock_take_product stp LEFT JOIN 
                " . DB_PREFIX . "stock_take st ON (st.stock_take_id = stp.stock_take_id) LEFT JOIN
                " . DB_PREFIX . "product p ON p.product_id = stp.product_id LEFT JOIN 
                " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . $this->config->get('config_language_id') . "'LEFT JOIN 
                " . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = stp.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN
                "  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = stp.product_id) LEFT JOIN 
                " . DB_PREFIX . "product_description pd_en ON(stp.product_id = pd_en.product_id AND pd_en.language_id='1') LEFT JOIN  
                " . DB_PREFIX . "product_description pd_cn ON(stp.product_id = pd_cn.product_id AND pd_cn.language_id='2') LEFT JOIN
                " . DB_PREFIX . "user u2 ON(stp.modified_by = u2.user_id) LEFT JOIN 
                "  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN 
                " . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = st.store_id) LEFT JOIN 
                " . DB_PREFIX . "store s ON(s.store_id = st.store_id)
                WHERE 
                stp.stock_take_id = '" . (int)$stock_take_id . "' 
				GROUP BY stp.stock_take_product_id

		";

		$query = $this->db->query($sql);

		$stock_take_info = $query->rows;
		return $stock_take_info;
	}

	public function getStockTakeItemAll()
	{
		$sql = "

		SELECT *
		FROM(
			SELECT
				GROUP_CONCAT(DISTINCT  " . DB_PREFIX . "category_description.name separator ', ') AS category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				" . DB_PREFIX . "stock_take_product.location,
				" . DB_PREFIX . "stock_take_product.date_added,
				" . DB_PREFIX . "stock_take_product.date_modified,
				" . DB_PREFIX . "stock_take_product.product_id,
				" . DB_PREFIX . "stock_take_product.stock_take_product_id,
				" . DB_PREFIX . "stock_take_product.location_id,
				" . DB_PREFIX . "stock_take_product.qty,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_take.store_id = 0 THEN CONCAT(" . DB_PREFIX . "setting.value, ' (Default)') ELSE " . DB_PREFIX . "store.name END) AS store_name,
				" . DB_PREFIX . "stock_take_product.stock_onhand,
				" . DB_PREFIX . "stock_take_product.stock_balance,
				" . DB_PREFIX . "stock_take_product.batch_date,
				" . DB_PREFIX . "weight_class_description.unit,
				" . DB_PREFIX . "stock_take_product.remark,
				" . DB_PREFIX . "stock_take_product.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.invoice_prefix AS saDocNo,
				" . DB_PREFIX . "stock_adjustment.date_added AS saDate,
				" . DB_PREFIX . "stock_adjustment.description AS saDescription,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				CONCAT(" . DB_PREFIX . "product_description.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

				" . DB_PREFIX . "order_status.name AS status_name
			FROM
				" . DB_PREFIX . "stock_take_product 
				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_en.product_id AND pd_en.language_id='1')
				LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')
				LEFT JOIN " . DB_PREFIX . "stock_take 
				ON (" . DB_PREFIX . "stock_take.stock_take_id=" . DB_PREFIX . "stock_take_product.stock_take_id)
				LEFT JOIN " . DB_PREFIX . "stock_adjustment
				ON (" . DB_PREFIX . "stock_take_product.stock_adjustment_id=" . DB_PREFIX . "stock_adjustment.stock_adjustment_id)
				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product.product_id )
				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take_product.added_by = " . DB_PREFIX . "user.user_id)
				LEFT JOIN " . DB_PREFIX . "weight_class_description 
				ON(" . DB_PREFIX . "weight_class_description.weight_class_id = " . DB_PREFIX . "stock_take_product.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_take_product.product_id)
				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)
				LEFT JOIN " . DB_PREFIX . "store
				ON(" . DB_PREFIX . "stock_take.store_id = " . DB_PREFIX . "store.store_id)
				LEFT JOIN
				" . DB_PREFIX . "setting ON (" . DB_PREFIX . "setting.key = 'config_name' AND " . DB_PREFIX . "setting.store_id = " . DB_PREFIX . "stock_take.store_id)
				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_take.status = " . DB_PREFIX . "order_status.order_status_id)
				GROUP BY " . DB_PREFIX . "stock_take_product.stock_take_id
			UNION

			SELECT
				'' as category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				'' as location,
				" . DB_PREFIX . "stock_take.date_added,
				" . DB_PREFIX . "stock_take.date_modified,
				'' as stock_take_product_id,
				'0' as product_id,
				'' as location_id,
				'' as qty,
				'' as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				'' as store_name,
				'0.0000' AS stock_onhand,
				'0.0000' AS stock_balance,
				'0000-00-00' as batch_date,
				'' as unit,
				'' as remark,
				'' as stock_adjustment_id,
				'' as saDocNo,
				'' as saDate,
				'' as saDescription,
				'' as product_name,
				'No Product Added' as product_name2,
				'' AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',
				'' as status_name
			FROM
				" . DB_PREFIX . "stock_take
				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take.added_by = " . DB_PREFIX . "user.user_id)
			WHERE 
			" . DB_PREFIX . "stock_take.stock_take_id NOT IN (SELECT DISTINCT(stock_take_id) FROM " . DB_PREFIX . "stock_take_product)

		)a
		";


		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getStockTakeItemSelected($take_id)
	{
		$sql = "
		SELECT *
		FROM(
			SELECT
				GROUP_CONCAT(DISTINCT  " . DB_PREFIX . "category_description.name separator ', ') AS category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				" . DB_PREFIX . "stock_take_product.location,
				" . DB_PREFIX . "stock_take_product.date_added,
				" . DB_PREFIX . "stock_take_product.date_modified,
				" . DB_PREFIX . "stock_take_product.product_id,
				" . DB_PREFIX . "stock_take_product.stock_take_product_id,
				" . DB_PREFIX . "stock_take_product.location_id,
				" . DB_PREFIX . "stock_take_product.qty,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_take.store_id = 0 THEN CONCAT(" . DB_PREFIX . "setting.value, ' (Default)') ELSE " . DB_PREFIX . "store.name END) AS store_name,
				" . DB_PREFIX . "stock_take_product.stock_onhand,
				" . DB_PREFIX . "stock_take_product.stock_balance,
				" . DB_PREFIX . "stock_take_product.batch_date,
				" . DB_PREFIX . "weight_class_description.unit,
				" . DB_PREFIX . "stock_take_product.remark,
				" . DB_PREFIX . "stock_take_product.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.invoice_prefix AS saDocNo,
				" . DB_PREFIX . "stock_adjustment.date_added AS saDate,
				" . DB_PREFIX . "stock_adjustment.description AS saDescription,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				CONCAT(" . DB_PREFIX . "product_description.name, ' ', pd_cn.name) AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',
				" . DB_PREFIX . "order_status.name AS status_name
			FROM
				" . DB_PREFIX . "stock_take_product 
				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_en.product_id AND pd_en.language_id='1')
				LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')
				LEFT JOIN " . DB_PREFIX . "stock_take 
				ON (" . DB_PREFIX . "stock_take.stock_take_id=" . DB_PREFIX . "stock_take_product.stock_take_id)
				LEFT JOIN " . DB_PREFIX . "stock_adjustment
				ON (" . DB_PREFIX . "stock_take_product.stock_adjustment_id=" . DB_PREFIX . "stock_adjustment.stock_adjustment_id)
				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product.product_id )
				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take_product.added_by = " . DB_PREFIX . "user.user_id)
				LEFT JOIN " . DB_PREFIX . "weight_class_description 
				ON(" . DB_PREFIX . "weight_class_description.weight_class_id = " . DB_PREFIX . "stock_take_product.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_take_product.product_id)
				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)
				LEFT JOIN " . DB_PREFIX . "store
				ON(" . DB_PREFIX . "stock_take.store_id = " . DB_PREFIX . "store.store_id)
				LEFT JOIN
				" . DB_PREFIX . "setting ON (" . DB_PREFIX . "setting.key = 'config_name' AND " . DB_PREFIX . "setting.store_id = " . DB_PREFIX . "stock_take.store_id)
				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_take.status = " . DB_PREFIX . "order_status.order_status_id)
				GROUP BY " . DB_PREFIX . "stock_take_product.stock_take_id
			UNION

			SELECT
				'' as category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				'' as location,
				" . DB_PREFIX . "stock_take.date_added,
				" . DB_PREFIX . "stock_take.date_modified,
				'' as stock_take_product_id,
				'0' as product_id,
				'' as location_id,
				'' as qty,
				'' as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				'' as store_name,
				'0.0000' AS stock_onhand,
				'0.0000' AS stock_balance,
				'0000-00-00' as batch_date,
				'' as unit,
				'' as remark,
				'' as stock_adjustment_id,
				'' as saDocNo,
				'' as saDate,
				'' as saDescription,
				'' as product_name,
				'No Product Added' as product_name2,
				'' AS 'en_cn_product_name',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',
				'' as status_name
			FROM
				" . DB_PREFIX . "stock_take
				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take.added_by = " . DB_PREFIX . "user.user_id)
			WHERE 
			" . DB_PREFIX . "stock_take.stock_take_id NOT IN (SELECT DISTINCT(stock_take_id) FROM " . DB_PREFIX . "stock_take_product)
		)a
		WHERE a.stock_take_id = '" . (int)$take_id . "'";

		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getStockTakeItemSearched($data)
	{
		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;
		$filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;
		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;
		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;
		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;
		$filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();
		$filter_product_id_statement = $filter_product_id ? "AND a.product_id LIKE '%" . $filter_product_id . "%'" : "";
		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
			$filter_product_name_statement .= empty($filter_product_name_statement) ? " a.en_cn_product_name LIKE '%" . $product_name . "%'" : " OR a.en_cn_product_name LIKE '%" . $product_name . "%'";
		}
		$filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

		$filter_remark_statement = "";
		foreach ($filter_remark as $remark) {
			$filter_remark_statement .= empty($filter_remark_statement) ? " a.description LIKE '%" . $remark . "%'" : " OR a.description LIKE '%" . $remark . "%'";
		}
		$filter_remark_statement = !empty($filter_remark_statement) ? " AND ($filter_remark_statement)" : "";

		$filter_doc_no_statement = "";
		foreach ($filter_doc_no as $product_doc_no) {
			$filter_doc_no_statement .= empty($filter_doc_no_statement) ? " a.doc_no LIKE '%" . $product_doc_no . "%'" : " OR a.doc_no LIKE '%" . $product_doc_no . "%'";
		}
		$filter_doc_no_statement = !empty($filter_doc_no_statement) ? " AND ($filter_doc_no_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
			$filter_product_code_statement .= empty($filter_product_code_statement) ? " a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
		}
		$filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";
		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";
		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";
		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";
		$filter_add_by_statement = !empty($data['filter_add_by']) ?
			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :
			"";
		$filter_store_id_statement = !empty($data['filter_store_id']) ?
			"AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
			"";
		$filter_location_id_statement = !empty($data['filter_location']) ?
			"AND a.location_id in (" . implode(',', $data['filter_location']) . ")" :
			"";
		$filter_category_id_statement = !empty($data['filter_category']) ?
			"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :
			"";
		$filter_status_statement = !empty($data['filter_status']) ?
			"AND a.status in (" . implode(',', $data['filter_status']) . ")" :
			"";
		$sql = "
		SELECT *
		FROM(
			SELECT
				GROUP_CONCAT(DISTINCT  " . DB_PREFIX . "category_description.name separator ', ') AS category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				" . DB_PREFIX . "stock_take_product.location,
				" . DB_PREFIX . "stock_take_product.date_added,
				" . DB_PREFIX . "stock_take_product.date_modified,
				" . DB_PREFIX . "stock_take_product.product_id,
				" . DB_PREFIX . "stock_take_product.stock_take_product_id,
				" . DB_PREFIX . "stock_take_product.location_id,
				" . DB_PREFIX . "stock_take_product.qty,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				(CASE WHEN " . DB_PREFIX . "stock_take.store_id = 0 THEN CONCAT(" . DB_PREFIX . "setting.value, ' (Default)') ELSE " . DB_PREFIX . "store.name END) AS store_name,
				" . DB_PREFIX . "stock_take_product.stock_onhand,
				" . DB_PREFIX . "stock_take_product.stock_balance,
				" . DB_PREFIX . "stock_take_product.batch_date,
				" . DB_PREFIX . "weight_class_description.unit,
				" . DB_PREFIX . "stock_take_product.remark,
				" . DB_PREFIX . "stock_take_product.stock_adjustment_id,
				" . DB_PREFIX . "stock_adjustment.invoice_prefix AS saDocNo,
				" . DB_PREFIX . "stock_adjustment.date_added AS saDate,
				" . DB_PREFIX . "stock_adjustment.description AS saDescription,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				CONCAT(" . DB_PREFIX . "product_description.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

				" . DB_PREFIX . "order_status.name AS status_name

			FROM

				" . DB_PREFIX . "stock_take_product 

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_en.product_id AND pd_en.language_id='1')

				LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_take_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "stock_take 
				ON (" . DB_PREFIX . "stock_take.stock_take_id=" . DB_PREFIX . "stock_take_product.stock_take_id)

				LEFT JOIN " . DB_PREFIX . "stock_adjustment
				ON (" . DB_PREFIX . "stock_take_product.stock_adjustment_id=" . DB_PREFIX . "stock_adjustment.stock_adjustment_id)

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_take_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')


				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take_product.added_by = " . DB_PREFIX . "user.user_id)

				LEFT JOIN " . DB_PREFIX . "weight_class_description 
				ON(" . DB_PREFIX . "weight_class_description.weight_class_id = " . DB_PREFIX . "stock_take_product.weight_class_id AND " . DB_PREFIX . "weight_class_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN "  . DB_PREFIX . "product_to_category
				ON(" . DB_PREFIX . "product_to_category.product_id = " . DB_PREFIX . "stock_take_product.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description
				ON(" . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id
				AND " . DB_PREFIX . "category_description.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "store
				ON(" . DB_PREFIX . "stock_take.store_id = " . DB_PREFIX . "store.store_id)

				LEFT JOIN
				" . DB_PREFIX . "setting ON (" . DB_PREFIX . "setting.key = 'config_name' AND " . DB_PREFIX . "setting.store_id = " . DB_PREFIX . "stock_take.store_id)

				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_take.status = " . DB_PREFIX . "order_status.order_status_id)

				GROUP BY " . DB_PREFIX . "stock_take_product.stock_take_id
			UNION

			SELECT

				'' as category,
			    " . DB_PREFIX . "stock_take.added_by as user_id,
				'' as location,
				" . DB_PREFIX . "stock_take.date_added,
				" . DB_PREFIX . "stock_take.date_modified,
				'' as stock_take_product_id,
				'0' as product_id,
				'' as location_id,
				'' as qty,
				'' as product_code,
				" . DB_PREFIX . "stock_take.stock_take_id,
				" . DB_PREFIX . "stock_take.doc_no,
				DATE_FORMAT(" . DB_PREFIX . "stock_take.doc_date, '%Y-%m-%d %H:%i %a') AS 'doc_date',
				" . DB_PREFIX . "stock_take.status,
				" . DB_PREFIX . "stock_take.description,
				" . DB_PREFIX . "stock_take.store_id,
				'' as store_name,
				'0.0000' AS stock_onhand,
				'0.0000' AS stock_balance,
				'0000-00-00' as batch_date,
				'' as unit,
				'' as remark,
				'' as stock_adjustment_id,
				'' as saDocNo,
				'' as saDate,
				'' as saDescription,
				'' as product_name,
				'No Product Added' as product_name2,
				'' AS 'en_cn_product_name',

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

				'' as status_name

			FROM

				" . DB_PREFIX . "stock_take

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_take.added_by = " . DB_PREFIX . "user.user_id)

			WHERE 

			" . DB_PREFIX . "stock_take.stock_take_id NOT IN (SELECT DISTINCT(stock_take_id) FROM " . DB_PREFIX . "stock_take_product)

		)a
		
		WHERE 1

		$filter_doc_no_statement

		$filter_add_by_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_store_id_statement

		$filter_location_id_statement

		$filter_product_code_statement

		$filter_category_id_statement

		$filter_status_statement

		$filter_product_id_statement

		$filter_product_name_statement

		$filter_batch_date_from_statement

		$filter_batch_date_to_statement

		$filter_remark_statement";


		$query = $this->db->query($sql);



		return $query->rows;
	}




	public function getLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	//get all location if user can view other store data
	public function getAllLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getDefaultLocation($product_id)
	{
		$query = $this->db->query("SELECT location_id FROM " . DB_PREFIX . "product_to_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' AND product_id='" . (int)$product_id . "'");

		$location_id = isset($query->row['location_id']) ? $query->row['location_id'] : 0;
		return $location_id;
	}


	public function getLocationText($location_id)
	{
		$query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
		$loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
		return $loc_text;
	}

	public function getWeightClasses()
	{
		$sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getweightClassProduct($product_id)
	{
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
		$query = $this->db->query($sql);

		$weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
		return $weight_class_id;
	}

	public function addStockTake($data)
	{

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;
		$save_header = isset($this->request->post['add_product']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft || $save_header) {
			$status = '1';
		}

		$store_id = $this->session->data['store_id'];
		$doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_take', 'store' => $store_id));
		$user_id = $this->session->data['user_id'];

		$stock_take_item = isset($data['stock_take_item']) ? $data['stock_take_item'] : array();

		if ($data['zerolize'] == 1 && $submit) {
			$data2 = array();
			$data2['description'] = '';
			//action=1 (plus) 0 (minus)
			foreach ($stock_take_item as $item) {
				$product_id = $item['product_id'];
				// $qty_onhand = $item['onhand_quantity'];
				$location_id = $item['location'];
				$wcid = $item['weight_class_id'];
				$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;
				$qty_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				if ($qty_onhand < 0) {
					$action = 1;
				} else {
					$action = 0;
				}
				$adj_qty = abs($qty_onhand);
				if ($qty_onhand != 0) {
					$data2['stock_adjustment_item'][$product_id] = array(
						'product_id' => $product_id,
						'action' => $action,
						'qty' => $adj_qty,
						'unit' => $wcid,
						'remark' => 'stock take zerolize',
						'batch_date' => $batch_date,
						'location' => $location_id,
					);
				}
			}
		}

		$sql = "
		INSERT INTO " . DB_PREFIX . "stock_take SET
		store_id = " . $store_id . ",
		description = '" . $this->db->escape($data['description'])  . "',
		doc_no = '" . $this->db->escape($doc_no) . "',
		status = '$status',
		zerolise = '" . $this->db->escape($data['zerolize'])  . "',
		doc_date = '" . $data['doc_date'] . "',
		added_by = " . (int)$user_id . ",
		date_added = NOW(),
		modified_by = " . (int)$user_id . ",
		date_modified = NOW()
		";

		$query = $this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);

			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_take', 'store' => $store_id));

			if ($data['zerolize'] == 1 && $submit && !empty($data2['stock_adjustment_item'])) {
				//$this->load->model('catalog/stock_adjustment');
				$stock_adj_id = $this->addStockAdjustment($data2);
				$this->db->query("UPDATE " . DB_PREFIX . "stock_take SET
								stock_adjustment_id = '" . (int)$stock_adj_id . "'
								WHERE stock_take_id = '" . (int)$lastid . "'");
			}

			foreach ($stock_take_item as $row_id => $item) {


				$product_id = $item['product_id'];
				$qty = $item['qty'];
				$location = $this->getLocationText($item['location']);
				$location_id = $item['location'];
				$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;
				$remark = $item['remark'];
				$wcid = $item['weight_class_id'];

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = NULL;
					$batch = '0000-00-00';
				}
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				$item_sql = "
				INSERT INTO " . DB_PREFIX . "stock_take_product SET
				stock_take_id = " . $lastid . ",
				product_id = " . $product_id . ",
				qty = " . $qty . ",
				weight_class_id = " . $wcid . ",
				batch_date = " . $batch_date . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				stock_onhand = '" . (float)$stock_onhand . "',
				location_id = '" . (int)$item['location'] . "',
				location = '" . $this->db->escape($location) . "',
				remark = '" . $this->db->escape($remark) . "',
				added_by = " . $user_id . ",
				date_added = NOW(),
				modified_by = " . $user_id . ",
				date_modified = NOW()
				";

				$this->db->query($item_sql);
				if ($submit) {
					$stock_take_product_id =  $this->db->getLastId();

					//conversion function here if needed.
					$converted_qty = $this->weight->convert($qty, $wcid, $product_wcid);
					$calculation_sql = "
					UPDATE " . DB_PREFIX . "product_to_store SET
					onhand_quantity = onhand_quantity + $converted_qty
					WHERE product_id = $product_id
					AND store_id = $store_id
					AND location_id = $location_id
					AND batch_date = $batch
					";
					$this->db->query($calculation_sql);

					//update stock_balance in stock_take_product table
					$update_sql = "UPDATE " . DB_PREFIX . "stock_take_product SET
					stock_balance = stock_onhand + $converted_qty
					WHERE stock_take_product_id = '".(int)$stock_take_product_id."'";
					$this->db->query($update_sql);
				}
			}
		}
		return $lastid;
	}


	public function editStockTake($stock_take_id, $data)
	{

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft) {
			$status = '1';
		}

		$user_id = $this->session->data['user_id'];
		$store_id = $this->session->data['store_id'];

		$stock_take_item = $data['stock_take_item'];

		if ($data['zerolize'] == 1 && $submit) {
			$data2 = array();
			$data2['description'] = '';
			//action=1 (plus) 0 (minus)
			foreach ($stock_take_item as $item) {
				$product_id = $item['product_id'];
				// $qty_onhand = $item['onhand_quantity'];
				$location_id = $item['location'];
				$wcid = $item['weight_class_id'];
				$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;
				$qty_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				if ($qty_onhand < 0) {
					$action = 1;
				} else {
					$action = 0;
				}
				$adj_qty = abs($qty_onhand);
				if ($qty_onhand != 0) {
					$data2['stock_adjustment_item'][$product_id] = array(
						'product_id' => $product_id,
						'action' => $action,
						'qty' => $adj_qty,
						'unit' => $wcid,
						'remark' => 'stock take zerolize',
						'batch_date' => $batch_date,
						'location' => $location_id,
					);
				}
			}
		}

		$sql = "
		UPDATE " . DB_PREFIX . "stock_take SET
		description = '" . $this->db->escape($data['description'])  . "',
		status = '$status',
		zerolise = '" . $this->db->escape($data['zerolize'])  . "',
		doc_date = '" . $data['doc_date'] . "',
		modified_by = " . (int)$user_id . ",
		date_modified = NOW()
		WHERE stock_take_id = '" . (int)$stock_take_id . "'
		";

		$query = $this->db->query($sql);

		$sql_delete = "DELETE FROM " . DB_PREFIX . "stock_take_product WHERE stock_take_id='" . (int)$stock_take_id . "'";
		$this->db->query($sql_delete);
		$this->load->model('catalog/product');

		$this->load->library('weight');

		$this->weight = new Weight($this->registry);

		if ($data['zerolize'] == 1 && $submit && !empty($data2['stock_adjustment_item'])) {
			//get date_added
			//$this->load->model('catalog/stock_adjustment');
			$stock_adj_id = $this->addStockAdjustment($data2);
			$this->db->query("UPDATE " . DB_PREFIX . "stock_take SET
							stock_adjustment_id = '" . (int)$stock_adj_id . "'
							WHERE stock_take_id = '" . (int)$stock_take_id . "'");

			$query_date = $this->db->query("SELECT st.date_added FROM " . DB_PREFIX . "stock_take st WHERE st.stock_take_id = '" . (int)$stock_take_id . "'");
			$date_added = !empty($query_date->row['date_added']) ? $query_date->row['date_added'] : date("Y-m-d H:i:s");
			$deductTime = strtotime($date_added);
			$date_added = $deductTime - 30;
			$update_datetime = date("Y-m-d H:i:s", $date_added);

			$this->db->query("UPDATE " . DB_PREFIX . "stock_adjustment SET date_added = '" . $update_datetime . "' WHERE stock_adjustment_id = '" . (int)$stock_adj_id . "'");
			$this->db->query("UPDATE " . DB_PREFIX . "stock_adjustment_item SET date_added = '" . $update_datetime . "' WHERE stock_adjustment_id = '" . (int)$stock_adj_id . "'");
		}

		foreach ($stock_take_item as $row_id => $item) {
			$product_id = $item['product_id'];
			$qty = $item['qty'];
			$location = $this->getLocationText($item['location']);
			$location_id = $item['location'];
			$remark = $item['remark'];
			$wcid = $item['weight_class_id'];
			$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;

			$product_info = $this->model_catalog_product->getProduct($product_id);
			$product_wcid = $this->getweightClassProduct($product_id);
			$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

			$total_product_weight = $qty * $product_weight;
			$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

			if (!empty($batch_date)) {
				$batch_date = $batch_date;
				$batch = $batch_date;
			} else {
				$batch_date = NULL;
				$batch = '0000-00-00';
			}
			$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
			$item_sql = "INSERT INTO " . DB_PREFIX . "stock_take_product 
				SET stock_take_id = " . (int)$stock_take_id . ",
					product_id = " . (int)$product_id . ",
					qty = " . (float)$qty . ",
					weight_class_id = " . (int)$wcid . ",
					batch_date = '" . $this->db->escape($batch) . "',
					weight_quantity = '" . (float)$weight_quantity . "',
					stock_onhand = '" . (float)$stock_onhand . "',
					location_id = '" . (int)$item['location'] . "',
					location = '" . $this->db->escape($location) . "',
					remark = '" . $this->db->escape($remark) . "',
					added_by = " . $user_id . ",
					date_added = NOW(),
					modified_by = " . $user_id . ",
					date_modified = NOW()
			";

			$this->db->query($item_sql);
			if ($submit) {
				$stock_take_product_id =  $this->db->getLastId();

				//conversion function here if needed.
				$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));

				$query_pts = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id  . "' AND store_id = '" . (int)$store_id  . "' AND location_id = '" . (int)$location_id  . "' AND batch_date = '" . $this->db->escape($batch) . "'");
				if ($query_pts->num_rows) {
					$calculation_sql = "UPDATE " . DB_PREFIX . "product_to_store SET onhand_quantity = (onhand_quantity + " . (float)$converted_qty . ")
					WHERE  product_id = '" . (int)$product_id  . "' AND store_id = '" . (int)$store_id  . "' AND location_id = '" . (int)$location_id  . "' AND batch_date = '" . $this->db->escape($batch) . "'
					";
				} else {
					$calculation_sql = " INSERT INTO  " . DB_PREFIX . "product_to_store SET onhand_quantity = '" . (float)$converted_qty . "', product_id = '" . (int)$product_id  . "', store_id = '" . (int)$store_id  . "',
					location_id = '" . (int)$location_id  . "', batch_date = '" . $this->db->escape($batch) . "', product_lastmodifiedby = '" . (int)$this->session->data['user_id'] . "', product_lastmodifieddate = NOW()
					";
				}
				$this->db->query($calculation_sql);

				//update stock_balance in stock_take_product table
				$update_sql = "UPDATE " . DB_PREFIX . "stock_take_product SET stock_balance = (stock_onhand + " . (float)$converted_qty . ")
				WHERE stock_take_product_id = " . (int)$stock_take_product_id;
				$this->db->query($update_sql);
			}
		}
	}

	public function addStockTakeProduct($data)
	{
		$stock_take_id = !empty($data['stock_take_id']) ? $data['stock_take_id'] : 0;

		$stock_take_product_id = 0;

		if (!empty($stock_take_id)) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);



			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;

			$store_id = (int)$this->session->data['store_id'];

			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}


				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;


				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = NULL;
					$batch = '0000-00-00';
				}
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				$item_sql = "
				INSERT INTO " . DB_PREFIX . "stock_take_product SET
				stock_take_id = " . (int)$stock_take_id . ",
				product_id = " .(int) $product_id . ",
				qty = " . $qty . ",
				weight_class_id = " . $wcid . ",
				batch_date = '" . $this->db->escape($batch) . "',
				weight_quantity = '" . (float)$weight_quantity . "',
				stock_onhand = '" . (float)$stock_onhand . "',
				location_id = '" . (int)$location_id . "',
				location = '" . $this->db->escape($location) . "',
				remark = '" . $this->db->escape($remark) . "',
				added_by = " . (int)$user_id . ",
				date_added = NOW(),
				modified_by = " . (int)$user_id . ",
				date_modified = NOW()
				";

				$this->db->query($item_sql);
				$stock_take_product_id =  $this->db->getLastId();
			}
		}

		return array(
			'id' => $stock_take_product_id,
			'stock_onhand' => $stock_onhand
		);
	}

	public function editStockTakeProduct($data)
	{
		$stock_take_product_id = !empty($data['stock_take_product_id']) ? $data['stock_take_product_id'] : 0;
		if (!empty($stock_take_product_id)) {
			$this->load->model('catalog/product');
			$this->load->library('weight');
			$this->weight = new Weight($this->registry);

			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
			$store_id = (int)$this->session->data['store_id'];
			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {
				$qty = !empty($data['qty']) ? $data['qty'] : 1;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}

				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;
				$product_info = $this->model_catalog_product->getProduct($product_id);
				$product_wcid = $this->getweightClassProduct($product_id);
				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;
				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);
				if (!empty($batch_date)) {
					$batch_date = $batch_date;
					$batch = $batch_date;
				} else {
					$batch_date = NULL;
					$batch = '0000-00-00';
				}

				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);

				$item_sql = " UPDATE " . DB_PREFIX . "stock_take_product 
					SET product_id = " . (int)$product_id . ",
						qty = " . (float)$qty . ",
						weight_class_id = " . (int)$wcid . ",
						batch_date = '" . $this->db->escape($batch) . "',
						weight_quantity = '" . (float)$weight_quantity . "',
						stock_onhand = '" . (float)$stock_onhand . "',
						location_id = '" . (int)$location_id . "',
						location = '" . $this->db->escape($location) . "',
						remark = '" . $this->db->escape($remark) . "',
						modified_by = " . (int)$user_id . ",
						date_modified = NOW()
					WHERE stock_take_product_id = '" . (int)$stock_take_product_id . "'
				";
				$this->db->query($item_sql);
				$stock_take_product_id =  $this->db->getLastId();
			}
		}
		return array(
			'id' => $stock_take_product_id,
			'stock_onhand' => $stock_onhand
		);
	}

	public function deleteStockTakeProduct($stock_take_product_id)
	{
		$sql_delete = "DELETE FROM " . DB_PREFIX . "stock_take_product WHERE stock_take_product_id='" . (int)$stock_take_product_id . "'";
		$this->db->query($sql_delete);
	}


	public function deductItem($stock_take_product_id, $remark)
	{


		$sql = "SELECT * FROM " . DB_PREFIX . "stock_take_product WHERE stock_take_product_id ='$stock_take_product_id'";
		$query = $this->db->query($sql);
		$item = $query->row;


		$data2 = array();
		$data2['description'] = $remark;
		//action=1 (plus) 0 (minus)
		$product_id = $item['product_id'];
		$action = 0;

		$product_id = $item['product_id'];
		$wcid = $item['weight_class_id'];
		$location_id = $item['location_id'];
		$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

		//adjust quantity
		$qty = $item['qty'];
		$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));
		$data2['stock_adjustment_item'][] = array(
			'product_id' => $product_id,
			'action' => $action,
			'qty' => $converted_qty,
			'unit' => $wcid,
			'remark' => 'stock take cancel item',
			'batch_date' => $batch_date,
			'location' => $location_id,
		);
		$this->load->model('catalog/stock_adjustment');
		$stock_adj_id = $this->addStockAdjustment($data2);
		$this->db->query("UPDATE " . DB_PREFIX . "stock_take_product SET
						remark = '" . $this->db->escape($remark) . "',
						stock_adjustment_id = '" . (int)$stock_adj_id . "'
						WHERE stock_take_product_id = '" . (int)$stock_take_product_id . "'");
	}

	public function getProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		//$batch_date='NULL';
		if (empty($batch_date)) {
			$batch_condition = " AND batch_date = '0000-00-00' ";
		} else {
			$batch_condition = " AND batch_date = '" . $this->db->escape($batch_date) .  "'";
		}

		$sql = "SELECT onhand_quantity 
				FROM " . DB_PREFIX . "product_to_store 
				WHERE store_id='" . (int)$store_id . "' 
					AND product_id='" . (int)$product_id . "' 
					AND location_id='" . (int)$location_id . "'
					$batch_condition
		";

		$query = $this->db->query($sql);
		if (!empty($query->row['onhand_quantity'])) {
			return $query->row['onhand_quantity'];
		} else {
			//$this->addProductStock($store_id, $product_id, $location_id, $batch_date);
			return 0;
		}
	}

	public function addProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_update = "batch_date='0000-00-00',";
		} else {
			$batch_update = "batch_date=$batch_date,";
		}
		$user_id = (int)$this->session->data['user_id'];
		$sql = "INSERT INTO " . DB_PREFIX . "product_to_store SET
		store_id = " . (int)$store_id . ",
		product_id = " . (int)$product_id . ",
		location_id = " . (int)$location_id . ",
		$batch_update
		product_lastmodifiedby = " . (int)$user_id . ",
		product_lastmodifieddate = NOW()
		";
		$this->db->query($sql);
	}

	public function getLocationList($product_id)
	{
		$def_location = array();
		$sql = "SELECT DISTINCT(pts.location_id), CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) AS location_text FROM " . DB_PREFIX . "product_to_store pts
		LEFT JOIN " . DB_PREFIX . "wms_location wms on (pts.location_id = wms.location_id)
		 WHERE pts.store_id = '" . (int)$this->session->data['store_id'] . "' 
		 AND pts.product_id='" . (int)$product_id . "'
		 ORDER BY location_text asc";

		$query = $this->db->query($sql);
		$location = $query->rows;
		if (!empty($location)) {
			foreach ($location as $loc) {
				if ($loc['location_id'] == 0) {
					$def_location[$loc['location_id']] = 'Default Location';
				} else {
					$def_location[$loc['location_id']] = $loc['location_text'];
				}
			}
		}
		return $def_location;
	}

	public function getBatchDateList($product_id, $location_id)
	{
		$batchDateList = array();
		$sql = "SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'
		ORDER BY FIELD('0000-00-00', batch_date) DESC, batch_date DESC";
		$query = $this->db->query($sql);
		$list = $query->rows;
		if (!empty($list)) {
			foreach ($list as $date) {
				$batchDateList[] = $date['batch_date'];
			}
		}
		return $batchDateList;
	}
	public function editStockTakeInfo($stock_take_id, $data)
	{


		$user_id = (int)$this->session->data['user_id'];


		if (!empty($stock_take_id)) {
			$sql = "
                UPDATE " . DB_PREFIX . "stock_take
                    SET
                        description = '" . $this->db->escape($data['description'])  . "',
                        modified_by = " . (int)$user_id . ",
                        date_modified = NOW()
                        WHERE stock_take_id = '" . (int)$stock_take_id . "'
                
            ";
			$this->db->query($sql);
		}
	}
	public function getAllStockReceivedBatchDates()
	{
		$query = $this->db->query("SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "stock_take_product WHERE 1 ");

		return $query->rows;
	}

	public function getStaffs()
	{
		$query = $this->db->query("SELECT DISTINCT(st.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_take st
		LEFT JOIN " . DB_PREFIX . "user u on (st.added_by = u.user_id)
		ORDER BY staff_name asc");

		return $query->rows;
	}

	public function getStatus()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from " . DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

		return $query->rows;
	}

	public function getCategories()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

		return $query->rows;
	}

	public function getProductSummaryByStore($product_id, $store_id)
	{
		$sql = "SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id='" . (int)$product_id . "' AND store_id='" . $store_id . "'";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getStock($datetime, $product_id, $store_id, $location_id, $batch_date)
	{

		$store_id_statement = " AND column_store_id ='" . (int)$store_id . "'";

		$location_id_statement = " AND column_location_id='" . (int)$location_id . "'";

		$batch_date_statement = " AND batch_date = '" . $batch_date . "'";

		$product_statement = "AND table_name.product_id = '" . (int)$product_id . "'";

		$sql = "
        SELECT
            SUM((CASE WHEN a.action = 1 THEN a.quantity ELSE (a.quantity * -1) END)) AS stock
        FROM
        (
            #stock return
            SELECT
                    'Stock Return' AS type,
                    sr.product_id,
                    sr.action,
                    sr.qty AS quantity,
                    0 AS store_id,
                    0 AS location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_return` sr
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sr.product_id = product.product_id )
                         LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sr.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (sr.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (sr.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'sr', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND sr.doc_date <  '" . $this->db->escape($datetime) . "'
                    AND sr.status   = 5

            UNION ALL
            #stock take
            SELECT
                    'Stock Take' AS type,
                    stp.product_id,
                    1 AS action,
                    stp.qty AS quantity,
                    st.store_id,
                    stp.location_id,
                    (CASE WHEN stp.batch_date is NULL THEN '0000-00-00' ELSE stp.batch_date END) AS batch_date
                FROM
                    `oc_stock_take_product` stp
                        LEFT JOIN
                            `oc_stock_take` st
                                ON stp.stock_take_id = st.stock_take_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                                ON(stp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(stp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (stp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (stp.product_id = en.product_id AND en.language_id = '1')
                    
                WHERE
                    1
                    " . str_replace('table_name', 'stp', $product_statement) . " 
                    " . str_replace('column_location_id', 'stp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.store_id', $store_id_statement) . "
                    AND st.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status   = 5

            UNION ALL
            #lot transfer out
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    0 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.source_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.source_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5
            UNION ALL
            #lot transfer in
            SELECT
                    'Lot Transfer' AS type,
                    ltp.product_id,
                    1 AS action,
                    ltp.qty AS quantity,
                    lt.store_id,
                    ltp.target_location_id AS location_id,
                    (CASE WHEN ltp.batch_date is NULL THEN '0000-00-00' ELSE ltp.batch_date END) AS batch_date
                FROM
                    `oc_lot_transfer_product` ltp
                        LEFT JOIN
                            `oc_lot_transfer` lt
                                ON ltp.lot_transfer_id = lt.lot_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ltp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ltp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (ltp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (ltp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ltp', $product_statement) . " 
                    " . str_replace('column_location_id', 'ltp.target_location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'lt.store_id', $store_id_statement) . "
                    AND lt.doc_date  <  '" . $this->db->escape($datetime) . "'
                    AND lt.status   = 5

            UNION ALL
            #stock received
            SELECT
                    'Stock Received' AS type,
                    srp.product_id,
                    1 AS action,
                    srp.quantity AS quantity,
                    srv.store_id,
                    srp.location_id,
                    '0000-00-00' AS batch_date
                FROM
                    `oc_stock_received_product` srp
                        LEFT JOIN
                            `oc_stock_received` srv
                                ON srp.stock_received_id = srv.stock_received_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(srp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(srp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (srp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (srp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'srp', $product_statement) . " 
                    " . str_replace('column_location_id', 'srp.location_id', $location_id_statement) . "
                    " . str_replace('column_store_id', 'srv.store_id', $store_id_statement) . "
                    AND srv.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND srv.status   = 5

            UNION ALL
            #stock adjustment
            SELECT
                    'Stock Adjustment' AS type,
                    sai.product_id,
                    sai.action,
                    sai.qty AS quantity,
                    sa.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_adjustment_item` sai
                        LEFT JOIN
                            `oc_stock_adjustment` sa
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sai.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sai.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sai.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sai.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sai', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'sa.store_id', $store_id_statement) . "
                    AND sai.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND sa.status   = 5

            UNION ALL

            #stock issue
            SELECT
                    'Stock Issue' AS type,
                    sii.product_id,
                    0 AS action,
                    sii.quantity,
                    si.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(sii.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(sii.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (sii.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (sii.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'sii', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'si.store_id', $store_id_statement) . "
                    AND sii.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND si.status   = 5

            UNION ALL

            #received from store,出货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.to_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.to_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.received_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #tranfer to store,进货
            SELECT
                    'Stock Transfer' AS type,
                    std.product_id,
                    (CASE WHEN st.from_store = '" . (int)$store_id . "' THEN 1 ELSE 0 END) AS action,
                    std.received_quantity AS quantity,
                    st.from_store AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(std.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(std.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (std.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (std.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'std', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'st.from_store', $store_id_statement) . "
                    AND std.received_quantity > 0
                    AND st.transfer_date  <  '" . $this->db->escape($datetime) . "'
                    AND st.status >= 4

            UNION ALL

            #sold sale order
            SELECT
                    'Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0

            UNION ALL
            
            #sold order wholesaler
            SELECT
                    'Wholesale Order' AS type,
                    op.product_id,
                    0 as action,
                    ROUND(op.total_weight,2) AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_order_product` op
                        LEFT JOIN
                            `oc_order` o
                                ON op.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(op.product_id = product.product_id )    
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(op.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (op.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (op.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'op', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT
                    'Herbal Remedies' AS type,
                    csp.product_id,
                    0 as action,
                    t_weight AS quantity,
                    o.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(csp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(csp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (csp.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (csp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'csp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'o.store_id', $store_id_statement) . "
                    AND o.date_added  <  '" . $this->db->escape($datetime) . "'
                    AND o.order_status_id = '5'
                    AND o.invoice_prefix <>''

            UNION ALL

            #purchase receive
            SELECT
                    'Purchase Received' AS type,
                    prp.product_id,
                    1 AS action,
                    prp.quantity,
                    pr.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_receive_product` prp
                        LEFT JOIN
                            `oc_purchase_receive` pr
                                ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(prp.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(prp.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (prp.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (prp.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'prp', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pr.store_id', $store_id_statement) . "
                    AND pr.order_status_id = '5'
                    AND pr.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #purchase invoice
            SELECT
                    'Purchase Invoice' AS type,
                    pip.product_id,
                    1 AS action,
                    pip.quantity,
                    pi.store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN
                            `oc_purchase_invoice` pi
                                ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN " . DB_PREFIX . "product product
                            ON(pip.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(pip.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (pip.product_id = cn.product_id AND cn.language_id = '2')
                    
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (pip.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'pip', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', 'pi.store_id', $store_id_statement) . "
                    AND pip.product_id != 0
                    AND pi.type IN (3, 5, 6)
                    AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pi.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production
            SELECT
                    'Production' AS type,
                    ps.product_id,
                    0 as action,
                    ps.quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                        LEFT JOIN
                            `oc_production_stock` ps
                                ON ps.production_id = p.production_id
                        LEFT JOIN " . DB_PREFIX . "product product 
                            ON(ps.product_id = product.product_id )
                        LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(ps.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                        LEFT JOIN " . DB_PREFIX . "product_description cn
                            ON (ps.product_id = cn.product_id AND cn.language_id = '2')
                
                        LEFT JOIN " . DB_PREFIX . "product_description en
                            ON (ps.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'ps', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND ps.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'

            UNION ALL

            #production add stock
            SELECT
                    'Production' AS type,
                    p.product_id,
                    1 AS action,
                    (p.actual_quantity - a.total_reject_quantity) AS quantity,
                    0 AS store_id,
                    0 as location_id,
                    '0000-00-00' as batch_date
                FROM
                    `oc_production` p
                    LEFT JOIN 
                        (SELECT pro.production_id, (CASE WHEN SUM(proqc.reject_quantity) IS NULL THEN 0 ELSE SUM(proqc.reject_quantity) END) AS total_reject_quantity 
                            FROM `oc_production` pro 
                            LEFT JOIN `oc_production_qc` proqc 
                            ON proqc.production_id = pro.production_id 
                            GROUP BY pro.production_id)a 
                        ON a.production_id = p.production_id 
                    LEFT JOIN " . DB_PREFIX . "product product 
                        ON(p.product_id = product.product_id )
                    LEFT JOIN " . DB_PREFIX . "product_description pd
                            ON(p.product_id =pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description cn
                        ON (p.product_id = cn.product_id AND cn.language_id = '2')
                    
                    LEFT JOIN " . DB_PREFIX . "product_description en
                        ON (p.product_id = en.product_id AND en.language_id = '1')
                WHERE
                    1
                    " . str_replace('table_name', 'p', $product_statement) . " 
                    " . str_replace('column_location_id', '0', $location_id_statement) . "
                    " . str_replace('column_store_id', '0', $store_id_statement) . "
                    AND p.product_id != 0
                    AND p.status = '5'
                    AND p.date_added  <  '" . $this->db->escape($datetime) . "'
            ) a
        WHERE 1
        $batch_date_statement
		";

		$query = $this->db->query($sql);
		return $query->row['stock'] ? $query->row['stock'] : 0;
	}

	public function updateProductQuantity($data)
	{
		foreach ($data as $row) {
			$sql = "UPDATE " . DB_PREFIX . "product_to_store
            SET onhand_quantity = '" . $row['close_qty'] . "'
            WHERE 
            product_id = '" . $row['product_id'] . "' 
            AND store_id = '" . $row['store_id'] . "'
            AND location_id = '" . $row['location_id'] . "'
            AND batch_date = '" . $row['batch_date'] . "'
            ";
			$this->db->query($sql);
			$rows_affected = $this->db->countAffected();
			if ($rows_affected > 0) {
				$this->logQtyChanged($row);
			}
		}
	}

	public function logQtyChanged($data)
	{
		$sql = "INSERT INTO " . DB_PREFIX . "product_to_store_log SET 
        product_id = '" . (int)$data['product_id'] . "',
        store_id = '" . (int)$data['store_id'] . "',
        location_id = '" . (int)$data['location_id'] . "',
        batch_date = '" . $data['batch_date'] . "',
        onhand_qty_before = '" . $data['onhand_quantity'] . "',
        onhand_qty_after = '" . $data['close_qty'] . "',
        modify_by = '" . (int)$data['modify_by'] . "',
        date_modified = NOW()
        ";
		$this->db->query($sql);
	}

	public function addStockAdjustment($data)
	{
		$this->load->model('catalog/product');

		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;
		$save_header = isset($this->request->post['add_product']) ? true : false;

		if ($submit) {
			$status = '5';
		}
		if ($draft || $save_header) {
			$status = '1';
		}

		$invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));

		//$status = $data['action'];
		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];
		$stock_adjustment_item = isset($data['stock_adjustment_item']) ? $data['stock_adjustment_item'] : array();

		$sql = "INSERT INTO " . DB_PREFIX . "stock_adjustment 
			SET
				invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
				store_id = '" . (int)$store_id . "',
				status = '" . (int)$status . "',
				description = '" . $this->db->escape($data['description'])  . "',
				add_by = '" . (int)$user_id . "',
				date_added = NOW(),
				modify_by = '" . (int)$user_id . "',
				date_modified = NOW()

		";

		$this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if ($lastid != 0) {
			$this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_adjustment', 'store' => $this->session->data['store_id']));
			foreach ($stock_adjustment_item as $row_id => $item) {
				$product_id = $item['product_id'];
				$action = $item['action'];
				$qty = $item['qty'];
				$weight_class_id = $item['unit'];
				$remark = $item['remark'];
				$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : NULL;
				$location = $this->getLocationText($item['location']);
				$location_id = $item['location'];
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);

				if ($action == 1) {
					$stock_balance = $stock_onhand + $qty;
				} else {
					$stock_balance = $stock_onhand - $qty;
				}
				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = $batch_date;
				} else {
					$batch_date = '0000-00-00';
				}

				$item_sql = "INSERT INTO " . DB_PREFIX . "stock_adjustment_item 
					SET
						stock_adjustment_id = '" . (int)$lastid . "',
						product_id = '" . (int)$product_id . "',
						action = '" . (int)$action . "',
						qty = '" . (float)$qty . "',
						weight_class_id= '" . (int)$item['unit'] . "',
						weight_quantity = '" . (float)$weight_quantity . "',
						remark = '" . $this->db->escape($remark) . "',
						batch_date = '" . $this->db->escape($batch_date) . "',
						stock_onhand = '" . (float)$stock_onhand . "',
						stock_balance = '" . (float)$stock_balance . "',
						location_id = '" . (int)$item['location'] . "',
						location = '" . $this->db->escape($location) . "',
						add_by = '" . (int)$user_id . "',
						date_added = NOW(),
						modify_by = '" . (int)$user_id . "',
						date_modified = NOW()
				";
				$this->db->query($item_sql);

				//if($status == 5){
				$calculation = ($action == 1) ? "+" : "-";
				if ($submit) {
					$calculation_sql = " UPDATE " . DB_PREFIX . "product_to_store 
						SET onhand_quantity = (onhand_quantity $calculation " . (float)$qty . ")
						WHERE product_id = '" . (int)$product_id . "'
						AND store_id = '" . (int)$store_id . "'
						AND location_id = '" . (int)$location_id . "'
						AND batch_date = '" . $this->db->escape($batch_date) . "'
					";
					$this->db->query($calculation_sql);
				}
			}
		}
		return $lastid;
	}
}
