<?php

class ModelCatalogStockReturn extends Model {

    public function getStockReturnList($data){

		$sort 	= isset($data['sort']) ? $data['sort'] : "doc_date";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";



		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;



		$filter_doc_no_statement = "";

		foreach ($filter_doc_no as $doc_no) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$doc_no . "%'" : " OR a.doc_no LIKE '%" .$doc_no . "%'";
        }

		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement)? "a.en_cn_product_name LIKE '%" .$product_name . "%'" : " OR a.en_cn_product_name LIKE '%" .$product_name . "%'";
        }

        $filter_product_name_statement = !empty($filter_product_name_statement) ? "AND ($filter_product_name_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_add_by_statement = $filter_add_by ? "AND a.user_id LIKE '%" . $filter_add_by . "%'" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";
		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_location_id_statement = !empty($data['filter_location_id']) ?

			"AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :

			"";

		$filter_status_statement = !empty($data['filter_status']) ?

		"AND a.status in (" . implode(',', $data['filter_status']) . ")" :

		"";


		$filter_category_statement = !empty($data['filter_category']) ?

		"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

		"";

		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in(" . implode(',', $data['filter_store_id']) . ")" :

			"";

		$sql = "

		SELECT *

		FROM(

			SELECT

				u1.user_id,

				sr.product_id,
			
				sr.stock_return_id,

				sr.date_added,

				sr.doc_no,

				sr.description,

				sr.status,

				sr.location_id,

				CONCAT(u2.firstname , ' ', u2.lastname) AS modified_by,

				DATE_FORMAT(sr.date_modified, '%d-%m-%Y %H:%i %a') AS date_modified,

				sr.stock_onhand,
				
				sr.stock_balance,

				sr.batch_date,

				sr.qty,

				wcd.unit,

				pd_en.name as product_name,

				pd_cn.name as product_name2,

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				rd.name as doc_type,

				CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',

				GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

				ptl.location,
				
				(CASE WHEN sr.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

				p.code AS product_code,

				sr.store_id,
				
				cd.category_id

			FROM

				" . DB_PREFIX . "stock_return sr LEFT JOIN

				" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sr.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN

				" . DB_PREFIX . "product_description pd_en ON(pd_en.language_id=1 AND pd_en.product_id = sr.product_id) LEFT JOIN

				" . DB_PREFIX . "product_description pd_cn ON(pd_cn.language_id=2 AND pd_cn.product_id = sr.product_id) LEFT JOIN

				" . DB_PREFIX . "reason_description rd ON(rd.reason_id = sr.reason_id AND rd.language_id='".(int) $this->config->get('config_language_id')."') LEFT JOIN

				" . DB_PREFIX . "user u1 ON(u1.user_id = sr.added_by) LEFT JOIN

				" . DB_PREFIX . "user u2 ON(u2.user_id = sr.modified_by) LEFT JOIN
				
				" . DB_PREFIX . "product_to_location ptl ON(ptl.location_id = sr.location_id) LEFT JOIN 
				
				" . DB_PREFIX . "store s ON(s.store_id = sr.store_id) LEFT JOIN 
				
				" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sr.store_id) LEFT JOIN 
				
				" . DB_PREFIX . "product p ON(sr.product_id = p.product_id) LEFT JOIN

				" . DB_PREFIX . "user u ON(sr.added_by = u.user_id) LEFT JOIN

				"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sr.product_id) LEFT JOIN 

				"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "')

			WHERE 1 GROUP BY sr.stock_return_id

		)a

		WHERE 1

		$filter_doc_no_statement

		$filter_product_name_statement

		$filter_product_code_statement

		$filter_status_statement

		$filter_category_statement

		$filter_store_id_statement

		$filter_add_by_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_batch_date_to_statement

		$filter_batch_date_from_statement

		$filter_location_id_statement

		ORDER BY a.$sort $order

		LIMIT $start, $limit";



		$query = $this->db->query($sql);



		return $query->rows;

	}

    public function totalStockReturn($data){



		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;


		$filter_doc_no_statement = "";

		foreach ($filter_doc_no as $doc_no) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$doc_no . "%'" : " OR a.doc_no LIKE '%" .$doc_no . "%'";
        }

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement)? "a.en_cn_product_name LIKE '%" .$product_name . "%'" : " OR a.en_cn_product_name LIKE '%" .$product_name . "%'";
        }

        $filter_product_name_statement = !empty($filter_product_name_statement) ? "AND ($filter_product_name_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

		$filter_add_by_statement = $filter_add_by ? "AND a.add_by LIKE '%" . $filter_add_by . "%'" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";
		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_location_id_statement = !empty($data['filter_location_id']) ?

			"AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :

			"";

		$filter_status_statement = !empty($data['filter_status']) ?

		"AND a.status in (" . implode(',', $data['filter_status']) . ")" :

		"";

		$filter_category_statement = !empty($data['filter_category']) ?

		"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

		"";

		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in(" . implode(',', $data['filter_store_id']) . ")" :

			"";

		$sql = "

		SELECT COUNT(*) AS total

		FROM(

			SELECT
			
			u1.user_id,
			
			sr.stock_return_id,

			sr.date_added,

			sr.doc_no,

			sr.description,

			sr.status,

			sr.location_id,

			CONCAT(u2.firstname , ' ', u2.lastname) AS modified_by,

			DATE_FORMAT(sr.date_modified, '%d-%m-%Y %H:%i %a') AS date_modified,

			sr.stock_onhand,
			
			sr.stock_balance,

			sr.batch_date,

			sr.qty,

			wcd.unit,

			pd_en.name as product_name,

			pd_cn.name as product_name2,

			CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

			rd.name as doc_type,

			CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',

			GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

			ptl.location,
			
			(CASE WHEN sr.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

			p.code AS product_code,

			sr.store_id ,

			cd.category_id

		FROM

			" . DB_PREFIX . "stock_return sr LEFT JOIN

			" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sr.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN

			" . DB_PREFIX . "product_description pd_en ON(pd_en.language_id=1 AND pd_en.product_id = sr.product_id) LEFT JOIN

			" . DB_PREFIX . "product_description pd_cn ON(pd_cn.language_id=2 AND pd_cn.product_id = sr.product_id) LEFT JOIN

			" . DB_PREFIX . "reason_description rd ON(rd.reason_id = sr.reason_id AND rd.language_id='".(int) $this->config->get('config_language_id')."') LEFT JOIN

			" . DB_PREFIX . "user u1 ON(u1.user_id = sr.added_by) LEFT JOIN

			" . DB_PREFIX . "user u2 ON(u2.user_id = sr.modified_by) LEFT JOIN
			
			" . DB_PREFIX . "product_to_location ptl ON(ptl.location_id = sr.location_id) LEFT JOIN 
			
			" . DB_PREFIX . "store s ON(s.store_id = sr.store_id) LEFT JOIN 
			
			" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sr.store_id) LEFT JOIN 
			
			" . DB_PREFIX . "product p ON(sr.product_id = p.product_id) LEFT JOIN

			" . DB_PREFIX . "user u ON(sr.added_by = u.user_id) LEFT JOIN

			"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sr.product_id) LEFT JOIN 

			"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "')

			WHERE 1 GROUP BY sr.stock_return_id

		)a

		WHERE 1 

		$filter_doc_no_statement

		$filter_product_name_statement

		$filter_product_code_statement

		$filter_status_statement

		$filter_category_statement

		$filter_store_id_statement

		$filter_add_by_statement

        $filter_date_from_statement

		$filter_date_to_statement

		$filter_batch_date_to_statement

		$filter_batch_date_from_statement

		$filter_location_id_statement

		";



		$query = $this->db->query($sql);



		return $query->row['total'];

	}

	public function getStockReturnItemAll() 
	{
		$sql = "SELECT
			
		u1.user_id,
		
		sr.stock_return_id,

		sr.date_added,

		sr.doc_no,

		sr.description,

		sr.status,

		sr.location_id,

		CONCAT(u2.firstname , ' ', u2.lastname) AS modified_by,

		DATE_FORMAT(sr.date_modified, '%d-%m-%Y %H:%i %a') AS date_modified,

		sr.stock_onhand,
		
		sr.stock_balance,

		sr.batch_date,

		sr.qty,

		wcd.unit,

		pd_en.name as product_name,

		pd_cn.name as product_name2,

		CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

		rd.name as doc_type,

		CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',

		GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

		ptl.location,
		
		(CASE WHEN sr.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

		p.code AS product_code,

		sr.store_id ,

		cd.category_id,

		os.name as status_name

	FROM

		" . DB_PREFIX . "stock_return sr LEFT JOIN

		" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sr.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN

		" . DB_PREFIX . "product_description pd_en ON(pd_en.language_id=1 AND pd_en.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "product_description pd_cn ON(pd_cn.language_id=2 AND pd_cn.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "reason_description rd ON(rd.reason_id = sr.reason_id AND rd.language_id='".(int) $this->config->get('config_language_id')."') LEFT JOIN

		" . DB_PREFIX . "user u1 ON(u1.user_id = sr.added_by) LEFT JOIN

		" . DB_PREFIX . "user u2 ON(u2.user_id = sr.modified_by) LEFT JOIN
		
		" . DB_PREFIX . "product_to_location ptl ON(ptl.location_id = sr.location_id) LEFT JOIN 
		
		" . DB_PREFIX . "store s ON(s.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "product p ON(sr.product_id = p.product_id) LEFT JOIN

		" . DB_PREFIX . "user u ON(sr.added_by = u.user_id) LEFT JOIN

		"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sr.product_id) LEFT JOIN 

		"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "')

		LEFT JOIN " . DB_PREFIX . "order_status os
		ON(sr.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')
		
		GROUP BY sr.stock_return_id";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockReturnItemSearched($data) 
	{
		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;

		$filter_doc_no_statement = "";

		foreach ($filter_doc_no as $doc_no) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$doc_no . "%'" : " OR a.doc_no LIKE '%" .$doc_no . "%'";
        }

		$filter_product_name_statement = "";

		foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement)? "a.en_cn_product_name LIKE '%" .$product_name . "%'" : " OR a.en_cn_product_name LIKE '%" .$product_name . "%'";
        }

        $filter_product_name_statement = !empty($filter_product_name_statement) ? "AND ($filter_product_name_statement)" : "";

		$filter_product_code_statement = "";

		foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_add_by_statement = $filter_add_by ? "AND a.user_id LIKE '%" . $filter_add_by . "%'" : "";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";
		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_location_id_statement = !empty($data['filter_location_id']) ?

			"AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :

			"";

		$filter_status_statement = !empty($data['filter_status']) ?

		"AND a.status in (" . implode(',', $data['filter_status']) . ")" :

		"";


		$filter_category_statement = !empty($data['filter_category']) ?

		"AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

		"";

		$filter_store_id_statement = !empty($data['filter_store_id']) ?

			"AND a.store_id in(" . implode(',', $data['filter_store_id']) . ")" :

			"";

		$sql = "

		SELECT *

		FROM(
			SELECT
			
		u1.user_id,
		
		sr.stock_return_id,

		sr.date_added,

		sr.doc_no,

		sr.description,

		sr.status,

		sr.location_id,

		CONCAT(u2.firstname , ' ', u2.lastname) AS modified_by,

		DATE_FORMAT(sr.date_modified, '%d-%m-%Y %H:%i %a') AS date_modified,

		sr.stock_onhand,
		
		sr.stock_balance,

		sr.batch_date,

		sr.qty,

		wcd.unit,

		pd_en.name as product_name,

		pd_cn.name as product_name2,

		CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

		rd.name as doc_type,

		CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',

		GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

		ptl.location,
		
		(CASE WHEN sr.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

		p.code AS product_code,

		sr.store_id ,

		cd.category_id,

		os.name as status_name

	FROM

		" . DB_PREFIX . "stock_return sr LEFT JOIN

		" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sr.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN

		" . DB_PREFIX . "product_description pd_en ON(pd_en.language_id=1 AND pd_en.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "product_description pd_cn ON(pd_cn.language_id=2 AND pd_cn.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "reason_description rd ON(rd.reason_id = sr.reason_id AND rd.language_id='".(int) $this->config->get('config_language_id')."') LEFT JOIN

		" . DB_PREFIX . "user u1 ON(u1.user_id = sr.added_by) LEFT JOIN

		" . DB_PREFIX . "user u2 ON(u2.user_id = sr.modified_by) LEFT JOIN
		
		" . DB_PREFIX . "product_to_location ptl ON(ptl.location_id = sr.location_id) LEFT JOIN 
		
		" . DB_PREFIX . "store s ON(s.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "product p ON(sr.product_id = p.product_id) LEFT JOIN

		" . DB_PREFIX . "user u ON(sr.added_by = u.user_id) LEFT JOIN

		"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sr.product_id) LEFT JOIN 

		"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "')

		LEFT JOIN " . DB_PREFIX . "order_status os
		ON(sr.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')
		
		WHERE 1 GROUP BY sr.stock_return_id

		)a

		WHERE 1

		$filter_doc_no_statement

		$filter_product_name_statement

		$filter_product_code_statement

		$filter_status_statement

		$filter_category_statement

		$filter_store_id_statement

		$filter_add_by_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_batch_date_to_statement

		$filter_batch_date_from_statement

		$filter_location_id_statement";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockReturnItemSelected($return_id)
	{
		$sql = "SELECT
			
		u1.user_id,
		
		sr.stock_return_id,

		sr.date_added,

		sr.doc_no,

		sr.description,

		sr.status,

		sr.location_id,

		CONCAT(u2.firstname , ' ', u2.lastname) AS modified_by,

		DATE_FORMAT(sr.date_modified, '%d-%m-%Y %H:%i %a') AS date_modified,

		sr.stock_onhand,
		
		sr.stock_balance,

		sr.batch_date,

		sr.qty,

		wcd.unit,

		pd_en.name as product_name,

		pd_cn.name as product_name2,

		CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

		rd.name as doc_type,

		CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',

		GROUP_CONCAT(DISTINCT cd.name separator ', ') AS category,

		ptl.location,
		
		(CASE WHEN sr.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

		p.code AS product_code,

		sr.store_id ,

		cd.category_id,

		os.name as status_name

	FROM

		" . DB_PREFIX . "stock_return sr LEFT JOIN

		" . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sr.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN

		" . DB_PREFIX . "product_description pd_en ON(pd_en.language_id=1 AND pd_en.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "product_description pd_cn ON(pd_cn.language_id=2 AND pd_cn.product_id = sr.product_id) LEFT JOIN

		" . DB_PREFIX . "reason_description rd ON(rd.reason_id = sr.reason_id AND rd.language_id='".(int) $this->config->get('config_language_id')."') LEFT JOIN

		" . DB_PREFIX . "user u1 ON(u1.user_id = sr.added_by) LEFT JOIN

		" . DB_PREFIX . "user u2 ON(u2.user_id = sr.modified_by) LEFT JOIN
		
		" . DB_PREFIX . "product_to_location ptl ON(ptl.location_id = sr.location_id) LEFT JOIN 
		
		" . DB_PREFIX . "store s ON(s.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = sr.store_id) LEFT JOIN 
		
		" . DB_PREFIX . "product p ON(sr.product_id = p.product_id) LEFT JOIN

		" . DB_PREFIX . "user u ON(sr.added_by = u.user_id) LEFT JOIN

		"  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sr.product_id) LEFT JOIN 

		"  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "')

		LEFT JOIN " . DB_PREFIX . "order_status os
		ON(sr.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')
		
		WHERE sr.stock_return_id = '" . (int)$return_id ."'";
	
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockReturn ($stock_return_id){

		$stock_return_info = array();



		$store_id = $this->session->data['store_id'];

		$user_id = $this->session->data['user_id'];

		$language_id = $this->config->get('config_language_id');



		$sql = "

		SELECT

				" . DB_PREFIX . "stock_return.stock_return_id,

				" . DB_PREFIX . "stock_return.date_added,

				" . DB_PREFIX . "stock_return.party,

				" . DB_PREFIX . "stock_return.party_id,

				" . DB_PREFIX . "stock_return.product_id,

				" . DB_PREFIX . "stock_return.doc_no,

				" . DB_PREFIX . "stock_return.ref_no,

				" . DB_PREFIX . "stock_return.doc_date,

				" . DB_PREFIX . "stock_return.qty,

				" . DB_PREFIX . "stock_return.weight_class_id,

				" . DB_PREFIX . "stock_return.reason_id,

				" . DB_PREFIX . "stock_return.description,

				" . DB_PREFIX . "stock_return.location_id,

				" . DB_PREFIX . "stock_return.batch_date,

				" . DB_PREFIX . "stock_return.action,

				en_pd.name as product_name,

				cn_pd.name as product_name2,

				p.code AS product_code,

				" . DB_PREFIX . "product_description.description as product_desc,

				" . DB_PREFIX . "reason_description.name as doc_type,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by'

			FROM

				" . DB_PREFIX . "stock_return LEFT JOIN

				" . DB_PREFIX . "user ON(" . DB_PREFIX . "stock_return.added_by = " . DB_PREFIX . "user.user_id) LEFT JOIN

				" . DB_PREFIX . "product_description ON(" . DB_PREFIX . "stock_return.product_id = " . DB_PREFIX . "product_description.product_id) LEFT JOIN

				" . DB_PREFIX . "reason_description ON(" . DB_PREFIX . "stock_return.reason_id = " . DB_PREFIX . "reason_description.reason_id) LEFT JOIN

				" . DB_PREFIX . "product_description en_pd ON(en_pd.language_id=1 AND en_pd.product_id = " . DB_PREFIX . "stock_return.product_id) LEFT JOIN

				" . DB_PREFIX . "product_description cn_pd ON(cn_pd.language_id=2 AND cn_pd.product_id = " . DB_PREFIX . "stock_return.product_id) LEFT JOIN

				" . DB_PREFIX . "product p ON(" . DB_PREFIX . "stock_return.product_id = p.product_id)

			WHERE

			 " . DB_PREFIX . "stock_return.stock_return_id = $stock_return_id

		";



		$query = $this->db->query($sql);



		$stock_return_info = $query->row;

		return $stock_return_info;

	}

	public function getStockReturnProduct ($stock_return_id){




		$store_id = $this->session->data['store_id'];

		$user_id = $this->session->data['user_id'];

		$language_id = $this->config->get('config_language_id');



		$sql = "

		SELECT

				" . DB_PREFIX . "stock_return.stock_return_id,

				" . DB_PREFIX . "stock_return.date_added,

				" . DB_PREFIX . "stock_return.party,

				" . DB_PREFIX . "stock_return.party_id,

				" . DB_PREFIX . "stock_return.product_id,

				" . DB_PREFIX . "stock_return.doc_no,

				" . DB_PREFIX . "stock_return.ref_no,

				" . DB_PREFIX . "stock_return.doc_date,

				" . DB_PREFIX . "stock_return.qty,

				" . DB_PREFIX . "stock_return.weight_class_id,

				" . DB_PREFIX . "stock_return.reason_id,

				" . DB_PREFIX . "stock_return.description,

				" . DB_PREFIX . "stock_return.location_id,

				" . DB_PREFIX . "stock_return.batch_date,

				" . DB_PREFIX . "stock_return.action,

				en_pd.name as product_name,

				cn_pd.name as product_name2,

				p.code AS product_code,

				" . DB_PREFIX . "product_description.description as product_desc,

				" . DB_PREFIX . "reason_description.name as doc_type,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by'

			FROM

				" . DB_PREFIX . "stock_return LEFT JOIN

				" . DB_PREFIX . "user ON(" . DB_PREFIX . "stock_return.added_by = " . DB_PREFIX . "user.user_id) LEFT JOIN

				" . DB_PREFIX . "product_description ON(" . DB_PREFIX . "stock_return.product_id = " . DB_PREFIX . "product_description.product_id) LEFT JOIN

				" . DB_PREFIX . "reason_description ON(" . DB_PREFIX . "stock_return.reason_id = " . DB_PREFIX . "reason_description.reason_id) LEFT JOIN

				" . DB_PREFIX . "product_description en_pd ON(en_pd.language_id=1 AND en_pd.product_id = " . DB_PREFIX . "stock_return.product_id) LEFT JOIN

				" . DB_PREFIX . "product_description cn_pd ON(cn_pd.language_id=2 AND cn_pd.product_id = " . DB_PREFIX . "stock_return.product_id) LEFT JOIN

				" . DB_PREFIX . "product p ON(" . DB_PREFIX . "stock_return.product_id = p.product_id)

			WHERE

			 " . DB_PREFIX . "stock_return.stock_return_id = $stock_return_id

		";



		$query = $this->db->query($sql);


		return $query->row;

	}


	public function getWeightClasses() {
        $sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }

	public function getweightClassProduct($product_id){
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id."'";
		$query = $this->db->query($sql);

		return $query->row['weight_class_id'];

	}

	public function getReasons($party) {
		$sql = "SELECT r.*, rd.name as reason
		FROM " . DB_PREFIX . "reason r,
		" . DB_PREFIX . "reason_description rd
		WHERE r.reason_id = rd.reason_id AND rd.language_id = '".(int) $this->config->get('config_language_id')."' AND r.module='catalog/stock_return' AND party='".$this->db->escape($party)."' ORDER BY rd.name ASC";
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getReasonAction($reason_id){
		$sql ="SELECT operation FROM ".DB_PREFIX."reason WHERE reason_id='".(int)$reason_id."'";
		$query = $this->db->query($sql);
		if(!empty($query->row['operation'])){
			$operation =$query->row['operation'];
		}
		else{
			$operation ='none';
		}
		return $operation;
	}

	public function getProductQty($doc_type,$doc_id,$product_id){
		if($doc_type=='order'){
			$sql = "SELECT quantity as qty, weight_class_id FROM ".DB_PREFIX."order_product WHERE order_id='".(int)$doc_id."' AND product_id='".(int)$product_id."'";
		}
		if($doc_type=='invoice'){
			$sql = "SELECT quantity as qty, weight_class_id FROM ".DB_PREFIX."purchase_invoice_product WHERE purchase_invoice_product_id='".(int)$doc_id."' AND product_id='".(int)$product_id."'";
		}
		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getProductPurchaseDate($doc_type,$ref_no){
		if($doc_type=='order'){
			$sql = "SELECT date_completed as purchase_date FROM ".DB_PREFIX."order WHERE invoice_prefix='".$ref_no."'";
		}
		if($doc_type=='invoice'){
			$sql = "SELECT purchase_date FROM ".DB_PREFIX."purchase_invoice WHERE invoice_prefix='".$ref_no."'";
		}
		$query = $this->db->query($sql);

		return $query->row['purchase_date'];
	}

	public function getManufacturerInfo($manufacturer_id){
		$sql = "SELECT m.*, z.name as zone, c.name as country FROM ".DB_PREFIX."manufacturer m, 
		".DB_PREFIX."zone z,
		".DB_PREFIX."country c
		WHERE manufacturer_id = '".(int)$manufacturer_id."' 
		AND m.zone_id = z.zone_id AND m.country_id = c.country_id ";

		$query = $this->db->query($sql);
		return $query->row;
	}

	public function getRefId($doc_type,$ref_no){
		if($doc_type=='order'){
			$sql = "SELECT order_id as ref_id FROM ".DB_PREFIX."order WHERE invoice_prefix='".$ref_no."'";
		}
		if($doc_type=='invoice'){
			$sql = "SELECT purchase_invoice_id as ref_id FROM ".DB_PREFIX."purchase_invoice WHERE invoice_prefix='".$ref_no."'";
		}
		$query = $this->db->query($sql);

		return $query->row['ref_id'];
	}

	public function addStockReturn($data){

		$store_id = $this->session->data['store_id'];
		$doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_return', 'store' => $store_id));
		$user_id = $this->session->data['user_id'];

		$party = $data['parties'];
		if($party=='customer'){
			$party_id = $data['customer_id'];
			$ref_no = $data['order_no'];
		}
		elseif($party=='supplier'){
			$party_id = $data['supplier_id'];
			$ref_no = $data['invoice_no'];
		}
		else{
			$party_id = 0;
			$ref_no = '';
		}

		$batch_date = ($data['batch_date']=='')?'0000-00-00':$data['batch_date'];
		

		$sql = "
		INSERT INTO " . DB_PREFIX . "stock_return SET
		doc_no = '" . $doc_no . "',
		doc_date = '" . $data['doc_date'] . "',
		party = '" . $this->db->escape($party)  . "',
		party_id = '" . (int)($party_id)  . "',
		ref_no = '" . $this->db->escape($ref_no)  . "',
		product_id = '" . (int)($data['product_id'])  . "',
		qty = '" . $data['qty'] . "',
		weight_class_id = '" . (int)($data['weight_class_id'])  . "',
		stock_onhand = (SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store WHERE product_id = " . (int)($data['product_id'])  . " AND store_id = $store_id  AND location_id='" . (int)($data['location'])  . "' AND batch_date = '$batch_date'),
		reason_id = '" . (int)($data['reason'])  . "',
		store_id = '" . (int)($store_id)  . "',
		location_id = '" . (int)($data['location'])  . "',
		batch_date = '$batch_date',
		description = '" . $this->db->escape($data['description'])  . "',
		status='5',
		added_by = " . $user_id . ",
		date_added = NOW(),
		modified_by = " . $user_id . ",
		date_modified = NOW()
		";
		$query = $this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if($lastid !=0){
			$this->load->controller('setting/transaction_no/setTransactionNo',array('module'=>'catalog/stock_return','store'=>$store_id));
				//conversion function here if needed.
				$converted_qty = $this->weight->convert($data['qty'], $data['weight_class_id'], $this->getweightClassProduct($data['product_id']));

				$calc_action = $this->getReasonAction($data['reason']);
				//action=1 (plus) else 0 (minus)
				if($calc_action!='none'){
					if($calc_action=='plus'){
						$calc_sign = "+";
						$action = 1;
					}
					if($calc_action=='minus'){
						$calc_sign = "-";
						$action = 0;
					}
					$calculation_sql = "
					UPDATE " . DB_PREFIX . "product_to_store SET
					onhand_quantity = onhand_quantity $calc_sign $converted_qty
					WHERE product_id = ".(int)$data['product_id']."
					AND store_id = $store_id
					";
					$calculate_query = $this->db->query($calculation_sql);

					//update balance
					$update_sql = "UPDATE " . DB_PREFIX . "stock_return SET
					stock_balance = stock_onhand $calc_sign $converted_qty,
					action = $action
					WHERE stock_return_id = $lastid";
					$update_query = $this->db->query($update_sql);

				}
				else{
					//update balance
					$update_sql = "UPDATE " . DB_PREFIX . "stock_return SET
					stock_balance = stock_onhand 
					WHERE stock_return_id = $lastid";
					$update_query = $this->db->query($update_sql);
				}
		}
	}

	public function draftStockReturn($data){

		$store_id = $this->session->data['store_id'];
		$doc_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_return', 'store' => $store_id));
		$user_id = $this->session->data['user_id'];

		$party = $data['parties'];
		if($party=='customer'){
			$party_id = $data['customer_id'];
			$ref_no = $data['order_no'];
		}
		elseif($party=='supplier'){
			$party_id = $data['supplier_id'];
			$ref_no = $data['invoice_no'];
		}
		else{
			$party_id = 0;
			$ref_no = '';
		}

		$batch_date = ($data['batch_date']=='')?'0000-00-00':$data['batch_date'];

		$sql = "
		INSERT INTO " . DB_PREFIX . "stock_return SET
		doc_no = '" . $doc_no . "',
		doc_date = '" . $data['doc_date'] . "',
		party = '" . $this->db->escape($party)  . "',
		party_id = '" . (int)($party_id)  . "',
		ref_no = '" . $this->db->escape($ref_no)  . "',
		product_id = '" . (int)($data['product_id'])  . "',
		qty = '" . $data['qty'] . "',
		weight_class_id = '" . (int)($data['weight_class_id'])  . "',
		stock_onhand = (SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store WHERE product_id = " . (int)($data['product_id'])  . " AND store_id = $store_id  AND location_id='" . (int)($data['location'])  . "' AND batch_date = '$batch_date'),
		reason_id = '" . (int)($data['reason'])  . "',
		store_id = '" . (int)($store_id)  . "',
		location_id = '" . (int)($data['location'])  . "',
		batch_date = '$batch_date',
		description = '" . $this->db->escape($data['description'])  . "',
		status ='1',
		added_by = " . $user_id . ",
		date_added = NOW(),
		modified_by = " . $user_id . ",
		date_modified = NOW()
		";
		$query = $this->db->query($sql);
		$lastid =  $this->db->getLastId();

		if($lastid !=0){
			$this->load->controller('setting/transaction_no/setTransactionNo',array('module'=>'catalog/stock_return','store'=>$store_id));
		}
	}

	public function editStockReturn($stock_return_id, $data) {
		$user_id = $this->session->data['user_id'];
		$store_id = $this->session->data['store_id'];
		
		$party = $data['parties'];
		if($party=='customer'){
			$party_id = $data['customer_id'];
			$ref_no = $data['order_no'];
		}
		elseif($party=='supplier'){
			$party_id = $data['supplier_id'];
			$ref_no = $data['invoice_no'];
		}
		else{
			$party_id = 0;
			$ref_no = '';
		}

		$batch_date = ($data['batch_date']=='')?'0000-00-00':$data['batch_date'];

		$sql = "
		UPDATE " . DB_PREFIX . "stock_return SET
		doc_date = '" . $data['doc_date'] . "',
		party = '" . $this->db->escape($party)  . "',
		party_id = '" . (int)($party_id)  . "',
		ref_no = '" . $this->db->escape($ref_no)  . "',
		product_id = '" . (int)($data['product_id'])  . "',
		qty = '" . $data['qty'] . "',
		weight_class_id = '" . (int)($data['weight_class_id'])  . "',
		stock_onhand = (SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store WHERE product_id = " . (int)($data['product_id'])  . " AND store_id = $store_id  AND location_id='" . (int)($data['location'])  . "' AND batch_date = '$batch_date'),
		reason_id = '" . (int)($data['reason'])  . "',
		store_id = '" . (int)($store_id)  . "',
		location_id = '" . (int)($data['location'])  . "',
		batch_date = '$batch_date',
		description = '" . $this->db->escape($data['description'])  . "',
		status='5',
		modified_by = " . $user_id . ",
		date_modified = NOW()
		WHERE stock_return_id = '" . (int)$stock_return_id . "'
		";
		$query = $this->db->query($sql);

		//conversion function here if needed.
		$converted_qty = $this->weight->convert($data['qty'], $data['weight_class_id'], $this->getweightClassProduct($data['product_id']));

		$calc_action = $this->getReasonAction($data['reason']);
		//action=1 (plus) else 0 (minus)
		if($calc_action!='none'){
			if($calc_action=='plus'){
				$calc_sign = "+";
				$action = 1;
			}
			if($calc_action=='minus'){
				$calc_sign = "-";
				$action = 0;
			}
			$calculation_sql = "
			UPDATE " . DB_PREFIX . "product_to_store SET
			onhand_quantity = onhand_quantity $calc_sign $converted_qty
			WHERE product_id = ".(int)$data['product_id']."
			AND store_id = $store_id
			";
			$calculate_query = $this->db->query($calculation_sql);

			//update balance
			$update_sql = "UPDATE " . DB_PREFIX . "stock_return SET
			stock_balance = stock_onhand $calc_sign $converted_qty,
			action = $action
			WHERE stock_return_id = $stock_return_id";
			$update_query = $this->db->query($update_sql);

		}
		else{
			//update balance
			$update_sql = "UPDATE " . DB_PREFIX . "stock_return SET
			stock_balance = stock_onhand 
			WHERE stock_return_id = $stock_return_id";
			$update_query = $this->db->query($update_sql);
		}

	}

	public function editDraftStockReturn($stock_return_id, $data) {
		$user_id = $this->session->data['user_id'];
		$store_id = $this->session->data['store_id'];
		
		$party = $data['parties'];
		if($party=='customer'){
			$party_id = $data['customer_id'];
			$ref_no = $data['order_no'];
		}
		elseif($party=='supplier'){
			$party_id = $data['supplier_id'];
			$ref_no = $data['invoice_no'];
		}
		else{
			$party_id = 0;
			$ref_no = '';
		}

		$batch_date = ($data['batch_date']=='')?'0000-00-00':$data['batch_date'];

		$sql = "
		UPDATE " . DB_PREFIX . "stock_return SET
		doc_date = '" . $data['doc_date'] . "',
		party = '" . $this->db->escape($party)  . "',
		party_id = '" . (int)($party_id)  . "',
		ref_no = '" . $this->db->escape($ref_no)  . "',
		product_id = '" . (int)($data['product_id'])  . "',
		qty = '" . $data['qty'] . "',
		weight_class_id = '" . (int)($data['weight_class_id'])  . "',
		stock_onhand = (SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store WHERE product_id = " . (int)($data['product_id'])  . " AND store_id = $store_id  AND location_id='" . (int)($data['location'])  . "' AND batch_date = '$batch_date'),
		reason_id = '" . (int)($data['reason'])  . "',
		store_id = '" . (int)($store_id)  . "',
		location_id = '" . (int)($data['location'])  . "',
		batch_date = '$batch_date',
		description = '" . $this->db->escape($data['description'])  . "',
		status='1',
		modified_by = " . $user_id . ",
		date_modified = NOW()
		WHERE stock_return_id = '" . (int)$stock_return_id . "'
		";
		$query = $this->db->query($sql);

	}

	public function getAutocompleteOrders($data){
		$sql = "SELECT order_id, invoice_prefix FROM ". DB_PREFIX ."order WHERE 1";

		if (!empty($data['filter_doc_no'])){
			$sql .= " AND invoice_prefix like '%".$this->db->escape($data['filter_doc_no'])."%' ";
		}
		if (!empty($data['filter_customer_id'])){
			$sql .= " AND customer_id='".$this->db->escape($data['filter_customer_id'])."' ";
		}

		$sql .=" LIMIT 10";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getAutocompletePuchases($data){
		$sql = "SELECT purchase_invoice_id, invoice_prefix FROM ". DB_PREFIX ."purchase_invoice WHERE 1";

		if (!empty($data['filter_doc_no'])){
			$sql .= " AND invoice_prefix like '%".$this->db->escape($data['filter_doc_no'])."%' ";
		}
		if (!empty($data['filter_manufacturer_id'])){
			$sql .= " AND manufacturer_id='".$this->db->escape($data['filter_manufacturer_id'])."' ";
		}

		$sql .=" LIMIT 10";
		$query = $this->db->query($sql);
		return $query->rows;
	}

	public function getLocations(){
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '".(int)$this->session->data['store_id']."' ORDER BY warehouse,zone,lot");

        return $query->rows;
	}

	public function getStaffs()
	{
		$query = $this->db->query("SELECT DISTINCT(sr.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_return sr
		LEFT JOIN " . DB_PREFIX . "user u on (sr.added_by = u.user_id)
		ORDER BY staff_name asc");

		return $query->rows;
	}

	public function getStatus() {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from ". DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

		return $query->rows;
	}

	public function getLocationText($location_id)
	{
		$query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
		$loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
		return $loc_text;
	}
	public function getAllLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getCategories() {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

		return $query->rows;
	}
}

?>