<?php

class ModelCatalogStockReserved extends Model
{
	public function addStockReserved($data)
	{
		$this->db->query(" INSERT INTO `" . DB_PREFIX . "stock_reserved` SET `store_id` = " . (int)$this->session->data['store_id'] . ", `customer_id` = '" . (int)$data['customer_id'] . "', `customer_name` = '" . $data['customer_name'] . "', `doc_no` = '" . $this->db->escape($data['doc_no']) . "', `doc_date` = '" . $this->db->escape($data['doc_date']) . "', `description` = '" . $this->db->escape($data['description'])  . "', `status` = '1', `added_by` = " . (int)$this->session->data['user_id'] . ", `date_added` = NOW(), `modified_by` = " . (int)$this->session->data['user_id'] . ", `date_modified` = NOW() ");

		$stock_reserved_id = $this->db->getLastId();

		// if (!empty($stock_reserved_id)) {
		// 	$this->db->query(" INSERT INTO `" . DB_PREFIX . "stock_reserved_product` SET `stock_reserved_id` = '" . (int)$stock_reserved_id . "', store_id = '" . (int)$this->session->data['store_id'] . "', `customer_id` = '" . (int)$data['customer_id'] . "', `product_id` = 0, `name` = '', `code` = '', `qty` = 0, `weight_class_id` = 0, `weight_quantity` = 0, `stock_onhand` = 0, `stock_balance` = 0, `stock_reserved_onhand` = 0, `stock_reserved_balance` = 0, `location_id` = 0, `location` = '',  `batch_date` = '', `remark` = '', `stock_adjustment_id` = 0, `date_added` = NOW(), `added_by` = 0, `date_modified` = NOW(), modified_by = 0 ");
		// }

		return $stock_reserved_id;
	}

	public function editStockReserved($stock_reserved_id, $data)
	{
		$submit = isset($this->request->post['submit']) ? true : false;
		$draft = isset($this->request->post['draft']) ? true : false;


		if ($submit) {
			$status = '5';
		}
		if ($draft) {
			$status = '1';
		}

		if (!empty($stock_reserved_id)) {
			$this->db->query(" UPDATE `" . DB_PREFIX . "stock_reserved` SET `store_id` = " . (int)$this->session->data['store_id'] . ", `customer_id` = '" . (int)$data['customer_id'] . "', `doc_no` = '" . $this->db->escape($data['doc_no']) . "', `doc_date` = '" . $this->db->escape($data['doc_date']) . "', `description` = '" . $this->db->escape($data['description'])  . "', `status` = '".(int)$status."', `modified_by` = " . (int)$this->session->data['user_id'] . ", `date_modified` = NOW() 
			WHERE `stock_reserved_id` = " . (int)$stock_reserved_id);
		}
	}

	public function addStockReservedProduct($data)
	{
		$stock_reserved_id = !empty($data['stock_reserved_id']) ? $data['stock_reserved_id'] : 0;

		$stock_reserved_product_id = 0;
		$stock_onhand = 0;

		if (!empty($stock_reserved_id)) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);

			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;

			$store_id = (int)$this->session->data['store_id'];

			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 0;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}

				$name = $data['name'];
				$code = $data['code'];
				$quantity = $data['qty'];
				$available = $data['available_qty'];
				$customer_id = $data['customer_id'];
				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = "'" . $batch_date . "'";
				} else {
					$batch_date = 'NULL';
				}
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				$reserved_onhand  = $this->getProductReservedStock($store_id, $product_id, $location_id, $batch_date);

				$available = $stock_onhand - $reserved_onhand - $qty;
				$stock_reserved = $reserved_onhand + $qty;
				$stock_balance = $stock_onhand - $reserved_onhand;
				$item_sql = "
				INSERT INTO " . DB_PREFIX . "stock_reserved_product SET
				stock_reserved_id = " . $stock_reserved_id . ",
				store_id = ".(int)$this->session->data['store_id'].",
				product_id = " . $product_id . ",
				customer_id = " . (int)$customer_id . ",
				name ='" . $name . "',
				code = '"  . $code . "',
				qty = " . $qty . ",
				weight_class_id = " . $wcid . ",
				batch_date = " . $batch_date . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				stock_onhand = '" . (float)$stock_onhand . "',
				stock_balance = '".(float)$stock_balance ."',
				stock_reserved_balance = '" . (float)$stock_reserved . "',
				stock_reserved_onhand = '" . (float)$reserved_onhand . "',
				available_onhand = '" . (float)$available . "',
				location_id = '" . (int)$location_id . "',
				location = '" . $this->db->escape($location) . "',
				remark = '" . $this->db->escape($remark) . "',
				added_by = " . $user_id . ",
				date_added = NOW(),
				modified_by = " . $user_id . ",
				date_modified = NOW()
				";

				$this->db->query($item_sql);

				$stock_reserved_product_id =  $this->db->getLastId();

				if ($batch_date == 'NULL') {
					$batch_condition = " AND batch_date ='0000-00-00'";
				} else {
					$batch_condition = " AND batch_date=$batch_date";
				}
		
				$sql = "UPDATE " . DB_PREFIX . "product_to_store 
				SET onhand_reserve='" . (float)$stock_reserved . "'
				WHERE store_id='" . (int)$store_id . "' 
				AND product_id='" . (int)$product_id . "' 
				AND location_id='" . (int)$location_id . "'
				$batch_condition";
				$this->db->query($sql);

				
			}
		}

		return array(
			'id' => $stock_reserved_product_id,
			'stock_onhand' => $stock_onhand
		);
	}

	public function editStockReservedProduct($data)
	{
		$stock_reserved_product_id = !empty($data['stock_reserved_product_id']) ? $data['stock_reserved_product_id'] : 0;
	
		if (!empty($stock_reserved_product_id)) {

			$this->load->model('catalog/product');

			$this->load->library('weight');

			$this->weight = new Weight($this->registry);

			$product_id = !empty($data['product_id']) ? $data['product_id'] : 0;

			$store_id = (int)$this->session->data['store_id'];

			$user_id = (int)$this->session->data['user_id'];

			if (!empty($product_id)) {

				$qty = !empty($data['qty']) ? $data['qty'] : 0;
				$location_id = !empty($data['location']) ? $data['location'] : 0;
				if ($location_id) {
					$location = $this->getLocationText($data['location']);
				} else {
					$location = '';
				}
				$name = $data['name'];
				$code = $data['code'];
				$quantity = $data['qty'];
				$remark = $data['remark'];
				$wcid = $data['weight_class_id'];
				$batch_date = !empty($data['batch_date']) ? $data['batch_date'] : NULL;

				$product_info = $this->model_catalog_product->getProduct($product_id);

				$product_wcid = $this->getweightClassProduct($product_id);

				$product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;

				$total_product_weight = $qty * $product_weight;
				$weight_quantity = $this->weight->convert($total_product_weight, $wcid, $product_wcid);

				if (!empty($batch_date)) {
					$batch_date = "'" . $batch_date . "'";
				} else {
					$batch_date = 'NULL';
				}
				$stock_onhand = $this->getProductStock($store_id, $product_id, $location_id, $batch_date);
				$reserved_onhand  = $this->getProductReservedStock($store_id, $product_id, $location_id, $batch_date);
				$stock_reserved = $reserved_onhand + $qty ;
				$stock_balance = $stock_onhand - $reserved_onhand;
				$available = $stock_onhand - $reserved_onhand - $qty;
				$item_sql = "
				UPDATE " . DB_PREFIX . "stock_reserved_product SET
				product_id = " . $product_id . ",
				qty = " . $qty . ",
				name = '" . $name . "',
				code = '" . $code . "',
				weight_class_id = " . $wcid . ",
				batch_date = " . $batch_date . ",
				weight_quantity = '" . (float)$weight_quantity . "',
				stock_onhand = '" . (float)$stock_onhand . "',
				stock_balance = '".(float)$stock_balance."',
				stock_reserved_balance = '" . (float)$stock_reserved . "',
				stock_reserved_onhand = '" . (float)$reserved_onhand . "',
				available_onhand = '" . (float)$available . "',
				location_id = '" . (int)$location_id . "',
				location = '" . $this->db->escape($location) . "',
				remark = '" . $this->db->escape($remark) . "',
				modified_by = " . $user_id . ",
				date_modified = NOW()
				WHERE
				stock_reserved_product_id = '" . (int)$stock_reserved_product_id . "'
				";

				$this->db->query($item_sql);

				if ($batch_date == 'NULL') {
					$batch_condition = " AND batch_date ='0000-00-00'";
				} else {
					$batch_condition = " AND batch_date=$batch_date";
				}
		
				$sql = "UPDATE " . DB_PREFIX . "product_to_store 
				SET onhand_reserve='" . (float)$stock_reserved . "'
				WHERE store_id='" . (int)$store_id . "' 
				AND product_id='" . (int)$product_id . "' 
				AND location_id='" . (int)$location_id . "'
				$batch_condition";
				$this->db->query($sql);
			}
		}
		return array(
			'id' => $stock_reserved_product_id,
			'stock_onhand' => $stock_onhand,
			'reserve_onhand' => $reserved_onhand
		);
	}

	public function deleteStockReservedProduct($stock_reserved_product_id)
	{
		$sql_delete = "DELETE FROM " . DB_PREFIX . "stock_reserved_product WHERE stock_reserved_product_id='" . (int)$stock_reserved_product_id . "'";
		$this->db->query($sql_delete);
	}

	public function deductItem($stock_reserved_product_id, $remark)
	{
		$sql = "SELECT * FROM " . DB_PREFIX . "stock_reserved_product WHERE stock_reserved_product_id ='$stock_reserved_product_id'";
		$query = $this->db->query($sql);
		$item = $query->row;

		// $data2 = array();
		// $data2['description'] = $remark;
		//action=1 (plus) 0 (minus)
		$product_id = $item['product_id'];
		$action = 0;

		$product_id = $item['product_id'];
		$wcid = $item['weight_class_id'];
		$location_id = $item['location_id'];
		$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

		//adjust quantity
		$qty = $item['qty'];
		$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));
		// $data2['stock_adjustment_item'][] = array(
		// 	'product_id' => $product_id,
		// 	'action' => $action,
		// 	'qty' => $converted_qty,
		// 	'unit' => $wcid,
		// 	'remark' => 'stock take cancel item',
		// 	'batch_date' => $batch_date,
		// 	'location' => $location_id,
		// );
		$this->load->model('catalog/stock_adjustment');
		$stock_adj_id = $this->model_catalog_stock_adjustment->addStockAdjustment($data2);
		$this->db->query("UPDATE " . DB_PREFIX . "stock_reserved_product SET
						remark = '" . $this->db->escape($remark) . "',
						stock_adjustment_id = '" . (int)$stock_adj_id . "'
						WHERE stock_reserved_product_id = '" . (int)$stock_reserved_product_id . "'");
	}

	public function getStockReservedList($data)
	{

		// $sort 	= isset($data['sort']) ? $data['sort'] : "doc_no";
		// $order 	= isset($data['order']) ? $data['order'] : "ASC";
        $filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();

		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;


		$start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;

		$filter_remark_statement = "";

        foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "a.description LIKE '%" . $filter_remarks . "%'" : " OR a.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";

		$filter_doc_no_statement = "";

        foreach ($filter_doc_no as $invoice_prefix) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$invoice_prefix . "%'" : " OR a.doc_no LIKE '%" .$invoice_prefix . "%'";
        }

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

		$filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" a.en_cn_product_name LIKE '%" . $product_name . "%'":" OR a.en_cn_product_name LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id in (" . $data['filter_store_id'] . ")" : '';

		// $filter_store_id_statement = !empty($data['filter_store_id']) ?
		// 	"AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
		// 	"";

		$filter_status_statement = $data['filter_status'] != '' ?
		"AND a.status in (" . $data['filter_status'] . ")" : '';

		$filter_category_statement = $data['filter_category'] != '' ?
		"AND a.category_id in (" . $data['filter_category'] . ")" : '';

		$filter_location_id_statement = !empty($data['filter_location']) ?
			"AND a.location_id in (" . implode(',', $data['filter_location']) . ")" :
			"";

		$filter_add_by_statement = !empty($data['filter_add_by']) ?
			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :
			"";

		$sql = "

		SELECT *

		FROM(

			SELECT
			    sr.added_by as user_id,
				srp.location,
				srp.date_added,
				srp.stock_reserved_product_id,
				srp.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				p.code as product_code,
				sr.stock_reserved_id,
				sr.remark,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.batch_date,

				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				wcd.unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
				
				(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,

				(CASE WHEN srp.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname

				
			FROM

				" . DB_PREFIX . "stock_reserved_product srp

				LEFT JOIN " . DB_PREFIX . "stock_reserved sr
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

				LEFT JOIN " . DB_PREFIX . "product p
				ON(srp.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(srp.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "user u
				ON(srp.added_by = u.user_id)

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = srp.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = srp.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = srp.store_id)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = srp.store_id)

				GROUP BY srp.stock_reserved_product_id
			UNION

			SELECT
			
			    sr.added_by as user_id,
				srp.location,
				sr.date_added,
				srp.stock_reserved_product_id,
				sr.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				'None' as product_name,
				'None' as product_name2,
				p.code as product_code,
				sr.stock_reserved_id,
				sr.remark,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.batch_date,


				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				'' as en_cn_product_name,

				'' as unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

				(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,

				'' as sname



			FROM

				" . DB_PREFIX . "stock_reserved sr

				LEFT JOIN " . DB_PREFIX . "stock_reserved_product srp
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

				LEFT JOIN " . DB_PREFIX . "product p
				ON(srp.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "user u
				ON(sr.added_by = u.user_id)

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = srp.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

			WHERE 

			sr.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)

		)a

		WHERE 1

		$filter_doc_no_statement
		$filter_add_by_statement
		$filter_date_from_statement
		$filter_date_to_statement
		$filter_store_id_statement
		$filter_location_id_statement
		$filter_product_code_statement
		$filter_product_name_statement
		$filter_product_id_statement
		$filter_batch_date_from_statement
		$filter_batch_date_to_statement
		$filter_remark_statement
		$filter_category_statement
		$filter_status_statement

		ORDER BY a.doc_date, a.doc_no, a.stock_reserved_product_id DESC

		LIMIT $start, $limit";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTotalStockReserveds($data)
	{

		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
        $filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();
		
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;


		$filter_doc_no_statement = "";

        foreach ($filter_doc_no as $invoice_prefix) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$invoice_prefix . "%'" : " OR a.doc_no LIKE '%" .$invoice_prefix . "%'";
        }

		$filter_remark_statement = "";

		foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "a.description LIKE '%" . $filter_remarks . "%'" : " OR a.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

		$filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" a.en_cn_product_name LIKE '%" . $product_name . "%'":" OR a.en_cn_product_name LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";

		$filter_store_id_statement = $data['filter_store_id'] != '' ?
		"AND a.store_id in (" . $data['filter_store_id'] . ")" : '';

		// $filter_store_id_statement = !empty($data['filter_store_id']) ?
		// 	"AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
		// 	"";

		$filter_status_statement = $data['filter_status'] != '' ?
		"AND a.status in (" . $data['filter_status'] . ")" : '';

		$filter_category_statement = $data['filter_category'] != '' ?
		"AND a.category_id in (" . $data['filter_category'] . ")" : '';

		$filter_location_id_statement = !empty($data['filter_location']) ?
			"AND a.location_id in (" . implode(',', $data['filter_location']) . ")" :
			"";

		$filter_add_by_statement = !empty($data['filter_add_by']) ?
			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :
			"";

		$sql = "

		SELECT COUNT(*) AS total

		FROM(

			SELECT

			    sr.added_by as user_id,
				srp.location,
				srp.date_added,
				srp.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				p.code as product_code,
				sr.stock_reserved_id,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.batch_date,

				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				wcd.unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

				(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,

				(CASE WHEN srp.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

				srp.remark
				
			FROM

				" . DB_PREFIX . "stock_reserved_product  srp

				LEFT JOIN " . DB_PREFIX . "stock_reserved sr
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

				LEFT JOIN " . DB_PREFIX . "product p
				ON(srp.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(srp.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "user u
				ON(srp.added_by = u.user_id)

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = srp.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = srp.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = srp.store_id)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = srp.store_id)

				GROUP BY srp.stock_reserved_product_id
			UNION

			SELECT
				

			    sr.added_by as user_id,
				srp.location,
				sr.date_added,
				sr.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				'None' as product_name,
				'None' as product_name2,
				'None' as product_code,
				sr.stock_reserved_id,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.batch_date,


				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				'' as en_cn_product_name,

				'' as unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

				(CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,

				'' AS sname,

				srp.remark

			FROM

				" . DB_PREFIX . "stock_reserved sr

				LEFT JOIN " . DB_PREFIX . "user u
				ON(sr.added_by = u.user_id)

				LEFT JOIN " . DB_PREFIX . "stock_reserved_product srp
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = srp.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

			WHERE 

			sr.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)

		)a

		WHERE 1

		$filter_doc_no_statement
		$filter_add_by_statement
		$filter_date_from_statement
		$filter_date_to_statement
		$filter_store_id_statement
		$filter_location_id_statement
		$filter_product_code_statement
		$filter_product_name_statement
		$filter_product_id_statement
		$filter_batch_date_from_statement
		$filter_batch_date_to_statement
		$filter_remark_statement
		$filter_category_statement
		$filter_status_statement

		";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getStockReserved($stock_reserved_id)
	{
		$stock_reserved_info = array();
		$store_id = $this->session->data['store_id'];
		$user_id = $this->session->data['user_id'];
		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT
				" . DB_PREFIX . "stock_reserved.*,
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'staff',
				" . DB_PREFIX . "stock_reserved.store_id
			FROM
				" . DB_PREFIX . "stock_reserved,
				" . DB_PREFIX . "user
			WHERE " . DB_PREFIX . "stock_reserved.added_by = " . DB_PREFIX . "user.user_id
			AND " . DB_PREFIX . "stock_reserved.stock_reserved_id = $stock_reserved_id
		";

		$query = $this->db->query($sql);

		$stock_reserved_info = $query->row;

		if (!empty($stock_reserved_info['store_id'])) {
			$store_id = $stock_reserved_info['store_id'];
		}

		$sql ="
			SELECT
				sr.added_by as user_id,
				srp.stock_reserved_product_id,
				srp.location,
				srp.date_added,
				srp.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				p.code as product_code,
				sr.stock_reserved_id,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.name,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.available_onhand,
				srp.batch_date,

				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				wcd.unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

				(CASE WHEN srp.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

				srp.remark
				
			FROM

				" . DB_PREFIX . "stock_reserved_product srp

				LEFT JOIN " . DB_PREFIX . "stock_reserved sr
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

				LEFT JOIN " . DB_PREFIX . "product p
				ON(srp.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(srp.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "user u
				ON(srp.added_by = u.user_id)

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = srp.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = srp.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = s.store_id)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = srp.store_id)

				WHERE srp.stock_reserved_id = " . (int)$stock_reserved_id . "
			UNION

			SELECT
			
				sr.added_by as user_id,
				srp.stock_reserved_product_id,
				srp.location,
				sr.date_added,
				sr.date_modified,
				srp.product_id,
				srp.location_id,
				srp.qty,
				' None ' as product_name,
				' None ' as product_name2,
				srp.code as product_code,
				sr.stock_reserved_id,
				sr.doc_no,
				sr.doc_date,
				sr.status,
				sr.description,
				sr.store_id,
				srp.name,
				srp.stock_onhand,
				srp.stock_balance,
				srp.stock_reserved_onhand,
				srp.stock_reserved_balance,
				srp.available_onhand,
				srp.batch_date,


				CONCAT(u.firstname , ' ', u.lastname) AS 'add_by',
				CONCAT(u.firstname , ' ', u.lastname) AS 'modified_by',

				'' as en_cn_product_name,

				'' as unit,

				'' 	AS category,

				'' AS sname,

				srp.remark

			FROM

				" . DB_PREFIX . "stock_reserved sr

				LEFT JOIN " . DB_PREFIX . "user u
				ON(sr.added_by = u.user_id)

				LEFT JOIN " . DB_PREFIX . "stock_reserved_product srp
				ON (sr.stock_reserved_id = srp.stock_reserved_id)

			WHERE 

			srp.stock_reserved_id = $stock_reserved_id GROUP BY srp.stock_reserved_product_id" ;

		

		$query = $this->db->query($sql);

		
		$stock_reserved_items = $query->rows;

		foreach ($stock_reserved_items as $product) {
			$stock_reserved_info['stock_reserved_item'][$product['stock_reserved_product_id']] = array(
				'stock_reserved_id' => $product['stock_reserved_id'],
				'stock_reserved_product_id' => $product['stock_reserved_product_id'],
                // 'date_added' => date('d/m/Y h:i A', strtotime($stockTake['date_added'])),
                'doc_date' => date('Y/m/d', strtotime($product['doc_date'])),
                'doc_no' => $product['doc_no'],
                'location' => $product['location'],
                'qty' => $product['qty'],
                'batch_date' => $product['batch_date'],
                'location_id' => $product['location_id'],
                'product_id' => $product['product_id'],
				'name' => $product['name'],
                'product_name' => $product['product_name'],
                'product_name2' => $product['product_name2'],
                'product_code' => $product['product_code'],
                'status' => $product['status'],
                'onhand_quantity' => $product['stock_onhand'],
                'stock_balance' => $product['stock_balance'],
                'stock_reserved_onhand' => $product['stock_reserved_onhand'],
                'stock_reserved_balance' => $product['stock_reserved_balance'],
				'available_onhand' => $product['available_onhand'],
                'description' => $product['description'],
                'add_by' => $product['add_by'],
                'date_modified' => $product['date_modified'],
                'modified_by' => $product['modified_by'],
                'unit' => $product['unit'],
                'category' => $product['category'],
                'sname' => $product['sname'],
                'remark' => $product['remark']
			);
		}

		return $stock_reserved_info;
	}



	public function getStockreservedProducts($stock_reserved_id) 
	{
		$sql ="
			SELECT
			    " . DB_PREFIX . "stock_reserved.added_by as user_id,
				" . DB_PREFIX . "stock_reserved_product.location,
				" . DB_PREFIX . "stock_reserved_product.date_added,
				" . DB_PREFIX . "stock_reserved_product.date_modified,
				" . DB_PREFIX . "stock_reserved_product.product_id,
				" . DB_PREFIX . "stock_reserved_product.location_id,
				" . DB_PREFIX . "stock_reserved_product.qty,
				pd_en.name as product_name,
				pd_cn.name as product_name2,
				" . DB_PREFIX . "product.code as product_code,
				" . DB_PREFIX . "stock_reserved.stock_reserved_id,
				" . DB_PREFIX . "stock_reserved.doc_no,
				" . DB_PREFIX . "stock_reserved.doc_date,
				" . DB_PREFIX . "stock_reserved.status,
				" . DB_PREFIX . "stock_reserved.description,
				" . DB_PREFIX . "stock_reserved.store_id,
				" . DB_PREFIX . "stock_reserved_product.stock_onhand,
				" . DB_PREFIX . "stock_reserved_product.stock_balance,
				" . DB_PREFIX . "stock_reserved_product.batch_date,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

				CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

				wcd.unit,

				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

				(CASE WHEN " . DB_PREFIX . "stock_reserved_product.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

				" . DB_PREFIX . "stock_reserved_product.remark
				
			FROM

				" . DB_PREFIX . "stock_reserved_product 

				LEFT JOIN " . DB_PREFIX . "stock_reserved 
				ON (" . DB_PREFIX . "stock_reserved.stock_reserved_id=" . DB_PREFIX . "stock_reserved_product.stock_reserved_id)

				LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_reserved_product.added_by = " . DB_PREFIX . "user.user_id)

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = " . DB_PREFIX . "stock_reserved_product.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

				LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = " . DB_PREFIX . "stock_reserved_product.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

				LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)

				LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)

				WHERE " . DB_PREFIX . "stock_reserved.stock_reserved_id = " . (int)$stock_reserved_id . "
			UNION

			SELECT
			
			    " . DB_PREFIX . "stock_reserved.added_by as user_id,
				'None' as location,
				" . DB_PREFIX . "stock_reserved.date_added,
				" . DB_PREFIX . "stock_reserved.date_modified,
				'0' as product_id,
				'None' as location_id,
				'None' as qty,
				'None' as product_name,
				'None' as product_name2,
				'None' as product_code,
				" . DB_PREFIX . "stock_reserved.stock_reserved_id,
				" . DB_PREFIX . "stock_reserved.doc_no,
				" . DB_PREFIX . "stock_reserved.doc_date,
				" . DB_PREFIX . "stock_reserved.status,
				" . DB_PREFIX . "stock_reserved.description,
				" . DB_PREFIX . "stock_reserved.store_id,
				'0.0000' AS stock_onhand,
				'0.0000' AS stock_balance,
				'None' as batch_date,


				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

				'' as en_cn_product_name,

				'' as unit,

				'' as category,

				'' as sname,

				'' as remark

			FROM

				" . DB_PREFIX . "stock_reserved

				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_reserved.added_by = " . DB_PREFIX . "user.user_id)

			WHERE 

			" . DB_PREFIX . "stock_reserved.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)";

		

		

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockReservedItemAll() 
	{
		$sql ="SELECT
		" . DB_PREFIX . "stock_reserved.added_by as user_id,
		" . DB_PREFIX . "stock_reserved_product.location,
		" . DB_PREFIX . "stock_reserved_product.date_added,
		" . DB_PREFIX . "stock_reserved_product.date_modified,
		" . DB_PREFIX . "stock_reserved_product.product_id,
		" . DB_PREFIX . "stock_reserved_product.location_id,
		" . DB_PREFIX . "stock_reserved_product.qty,
		pd_en.name as product_name,
		pd_cn.name as product_name2,
		" . DB_PREFIX . "product.code as product_code,
		" . DB_PREFIX . "stock_reserved.stock_reserved_id,
		" . DB_PREFIX . "stock_reserved.doc_no,
		" . DB_PREFIX . "stock_reserved.doc_date,
		" . DB_PREFIX . "stock_reserved.status,
		" . DB_PREFIX . "stock_reserved.description,
		" . DB_PREFIX . "stock_reserved.store_id,
		" . DB_PREFIX . "stock_reserved_product.stock_onhand,
		" . DB_PREFIX . "stock_reserved_product.stock_balance,
		" . DB_PREFIX . "stock_reserved_product.batch_date,

		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

		CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

		wcd.unit,

		GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

		(CASE WHEN " . DB_PREFIX . "stock_reserved_product.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

		" . DB_PREFIX . "stock_reserved_product.remark,

		os.name as status_name
		
	FROM

		" . DB_PREFIX . "stock_reserved_product 

		LEFT JOIN " . DB_PREFIX . "stock_reserved 
		ON (" . DB_PREFIX . "stock_reserved.stock_reserved_id=" . DB_PREFIX . "stock_reserved_product.stock_reserved_id)

		LEFT JOIN " . DB_PREFIX . "product
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product.product_id )

		LEFT JOIN " . DB_PREFIX . "product_description
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

		LEFT JOIN " . DB_PREFIX . "user
		ON(" . DB_PREFIX . "stock_reserved_product.added_by = " . DB_PREFIX . "user.user_id)

		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_en.product_id AND pd_en.language_id='1')
		
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')

		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON(wcd.weight_class_id = " . DB_PREFIX . "stock_reserved_product.weight_class_id
		AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
		)

		LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
		ON(ptc.product_id = " . DB_PREFIX . "stock_reserved_product.product_id)

		LEFT JOIN "  . DB_PREFIX . "category_description cd
		ON(cd.category_id = ptc.category_id
		AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
		)

		LEFT JOIN " . DB_PREFIX . "store s
		ON(s.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)

		LEFT JOIN " . DB_PREFIX . "setting sett
		ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)
		
		LEFT JOIN " . DB_PREFIX . "order_status os
				ON(" . DB_PREFIX . "stock_reserved.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

		GROUP BY " . DB_PREFIX . "stock_reserved_product.stock_reserved_product_id
	UNION

	SELECT
	
		" . DB_PREFIX . "stock_reserved.added_by as user_id,
		'None' as location,
		" . DB_PREFIX . "stock_reserved.date_added,
		" . DB_PREFIX . "stock_reserved.date_modified,
		'0' as product_id,
		'None' as location_id,
		'None' as qty,
		'None' as product_name,
		'None' as product_name2,
		'None' as product_code,
		" . DB_PREFIX . "stock_reserved.stock_reserved_id,
		" . DB_PREFIX . "stock_reserved.doc_no,
		" . DB_PREFIX . "stock_reserved.doc_date,
		" . DB_PREFIX . "stock_reserved.status,
		" . DB_PREFIX . "stock_reserved.description,
		" . DB_PREFIX . "stock_reserved.store_id,
		'0.0000' AS stock_onhand,
		'0.0000' AS stock_balance,
		'None' as batch_date,


		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

		'' as en_cn_product_name,

		'' as unit,

		'' as category,

		'' as sname,

		'' as remark,

		'' as status_name

	FROM

		" . DB_PREFIX . "stock_reserved

		LEFT JOIN " . DB_PREFIX . "user
		ON(" . DB_PREFIX . "stock_reserved.added_by = " . DB_PREFIX . "user.user_id)

	WHERE 

	" . DB_PREFIX . "stock_reserved.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)";

	$query = $this->db->query($sql);

	return $query->rows;
	}

	public function getStockReservedItemSearched($data)
	{

		$filter_doc_no = isset($data['filter_doc_no']) ? explode(',', $data['filter_doc_no']) : array();
		$filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
		$filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
		$filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
		$filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

		$filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
		$filter_date_from_str = trim($filter_date_from);
		$filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

		$filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
		$filter_date_to_str = trim($filter_date_to);
		$filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

		$filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
		$filter_batch_date_from_str = trim($filter_batch_date_from);
		$filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) . " 00:00:00" : false;

		$filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
		$filter_batch_date_to_str = trim($filter_batch_date_to);
		$filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) . " 23:59:59" : false;


		$filter_doc_no_statement = "";

        foreach ($filter_doc_no as $invoice_prefix) {
            $filter_doc_no_statement .= empty($filter_doc_no_statement)? "a.doc_no LIKE '%" .$invoice_prefix . "%'" : " OR a.doc_no LIKE '%" .$invoice_prefix . "%'";
        }

        $filter_doc_no_statement = !empty($filter_doc_no_statement) ? "AND ($filter_doc_no_statement)" : "";

		$filter_product_id_statement = $filter_product_id ? "AND a.product_id = '" . (int)$filter_product_id . "'" : "";

		$filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)? "a.product_code LIKE '%" .$product_code . "%'" : " OR a.product_code LIKE '%" .$product_code . "%'";
        }

        $filter_product_code_statement = !empty($filter_product_code_statement) ? "AND ($filter_product_code_statement)" : "";

		$filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" a.en_cn_product_name LIKE '%" . $product_name . "%'":" OR a.en_cn_product_name LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

		$filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";

		$filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";

		$filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

		$filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";

		$filter_store_id_statement = !empty($data['filter_store_id']) ?
			"AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
			"";

		$filter_location_id_statement = !empty($data['filter_location']) ?
			"AND a.location_id in (" . implode(',', $data['filter_location']) . ")" :
			"";

		$filter_add_by_statement = !empty($data['filter_add_by']) ?
			"AND a.user_id in (" . implode(',', $data['filter_add_by']) . ")" :
			"";

			$sql = "

			SELECT *
	
			FROM(
	
				SELECT
					" . DB_PREFIX . "stock_reserved.added_by as user_id,
					" . DB_PREFIX . "stock_reserved_product.location,
					" . DB_PREFIX . "stock_reserved_product.date_added,
					" . DB_PREFIX . "stock_reserved_product.date_modified,
					" . DB_PREFIX . "stock_reserved_product.product_id,
					" . DB_PREFIX . "stock_reserved_product.location_id,
					" . DB_PREFIX . "stock_reserved_product.qty,
					pd_en.name as product_name,
					pd_cn.name as product_name2,
					" . DB_PREFIX . "product.code as product_code,
					" . DB_PREFIX . "stock_reserved.stock_reserved_id,
					" . DB_PREFIX . "stock_reserved.doc_no,
					" . DB_PREFIX . "stock_reserved.doc_date,
					" . DB_PREFIX . "stock_reserved.status,
					" . DB_PREFIX . "stock_reserved.description,
					" . DB_PREFIX . "stock_reserved.store_id,
					" . DB_PREFIX . "stock_reserved_product.stock_onhand,
					" . DB_PREFIX . "stock_reserved_product.stock_balance,
					" . DB_PREFIX . "stock_reserved_product.batch_date,
	
					CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
					CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',
	
					CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',
	
					wcd.unit,
	
					GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
	
					(CASE WHEN " . DB_PREFIX . "stock_reserved_product.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
	
					" . DB_PREFIX . "stock_reserved_product.remark,

					os.name as status_name
					
				FROM
	
					" . DB_PREFIX . "stock_reserved_product 
	
					LEFT JOIN " . DB_PREFIX . "stock_reserved 
					ON (" . DB_PREFIX . "stock_reserved.stock_reserved_id=" . DB_PREFIX . "stock_reserved_product.stock_reserved_id)
	
					LEFT JOIN " . DB_PREFIX . "product
					ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product.product_id )
	
					LEFT JOIN " . DB_PREFIX . "product_description
					ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')
	
					LEFT JOIN " . DB_PREFIX . "user
					ON(" . DB_PREFIX . "stock_reserved_product.added_by = " . DB_PREFIX . "user.user_id)
	
					LEFT JOIN " . DB_PREFIX . "product_description pd_en
					ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_en.product_id AND pd_en.language_id='1')
					
					LEFT JOIN " . DB_PREFIX . "product_description pd_cn
					ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')
	
					LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
					ON(wcd.weight_class_id = " . DB_PREFIX . "stock_reserved_product.weight_class_id
					AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
					)
	
					LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
					ON(ptc.product_id = " . DB_PREFIX . "stock_reserved_product.product_id)
	
					LEFT JOIN "  . DB_PREFIX . "category_description cd
					ON(cd.category_id = ptc.category_id
					AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
					)
	
					LEFT JOIN " . DB_PREFIX . "store s
					ON(s.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)
	
					LEFT JOIN " . DB_PREFIX . "setting sett
					ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)

					LEFT JOIN " . DB_PREFIX . "order_status os
				ON(" . DB_PREFIX . "stock_reserved.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

	
					GROUP BY " . DB_PREFIX . "stock_reserved_product.stock_reserved_product_id
				UNION
	
				SELECT
				
					" . DB_PREFIX . "stock_reserved.added_by as user_id,
					'None' as location,
					" . DB_PREFIX . "stock_reserved.date_added,
					" . DB_PREFIX . "stock_reserved.date_modified,
					'0' as product_id,
					'None' as location_id,
					'None' as qty,
					'None' as product_name,
					'None' as product_name2,
					'None' as product_code,
					" . DB_PREFIX . "stock_reserved.stock_reserved_id,
					" . DB_PREFIX . "stock_reserved.doc_no,
					" . DB_PREFIX . "stock_reserved.doc_date,
					" . DB_PREFIX . "stock_reserved.status,
					" . DB_PREFIX . "stock_reserved.description,
					" . DB_PREFIX . "stock_reserved.store_id,
					'0.0000' AS stock_onhand,
					'0.0000' AS stock_balance,
					'None' as batch_date,
	
	
					CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
					CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',
	
					'' as en_cn_product_name,
	
					'' as unit,
	
					'' as category,
	
					'' as sname,
	
					'' as remark,
					'' as status_name
	
				FROM
	
					" . DB_PREFIX . "stock_reserved
	
					LEFT JOIN " . DB_PREFIX . "user
					ON(" . DB_PREFIX . "stock_reserved.added_by = " . DB_PREFIX . "user.user_id)
	
				WHERE 
	
				" . DB_PREFIX . "stock_reserved.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)
	
			)a
	
			WHERE 1
	
			$filter_doc_no_statement
			$filter_add_by_statement
			$filter_date_from_statement
			$filter_date_to_statement
			$filter_store_id_statement
			$filter_location_id_statement
			$filter_product_code_statement
			$filter_product_name_statement
			$filter_product_id_statement
			$filter_batch_date_from_statement
			$filter_batch_date_to_statement
	";
		//print_r($sql);

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getStockReservedItemSelected($reserved_id) 
	{
		$sql ="SELECT
		" . DB_PREFIX . "stock_reserved.added_by as user_id,
		" . DB_PREFIX . "stock_reserved_product.location,
		" . DB_PREFIX . "stock_reserved_product.date_added,
		" . DB_PREFIX . "stock_reserved_product.date_modified,
		" . DB_PREFIX . "stock_reserved_product.product_id,
		" . DB_PREFIX . "stock_reserved_product.location_id,
		" . DB_PREFIX . "stock_reserved_product.qty,
		pd_en.name as product_name,
		pd_cn.name as product_name2,
		" . DB_PREFIX . "product.code as product_code,
		" . DB_PREFIX . "stock_reserved.stock_reserved_id,
		" . DB_PREFIX . "stock_reserved.doc_no,
		" . DB_PREFIX . "stock_reserved.doc_date,
		" . DB_PREFIX . "stock_reserved.status,
		" . DB_PREFIX . "stock_reserved.description,
		" . DB_PREFIX . "stock_reserved.store_id,
		" . DB_PREFIX . "stock_reserved_product.stock_onhand,
		" . DB_PREFIX . "stock_reserved_product.stock_balance,
		" . DB_PREFIX . "stock_reserved_product.batch_date,

		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

		CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

		wcd.unit,

		GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,

		(CASE WHEN " . DB_PREFIX . "stock_reserved_product.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,

		" . DB_PREFIX . "stock_reserved_product.remark,

		os.name as status_name
		
	FROM

		" . DB_PREFIX . "stock_reserved_product 

		LEFT JOIN " . DB_PREFIX . "stock_reserved 
		ON (" . DB_PREFIX . "stock_reserved.stock_reserved_id=" . DB_PREFIX . "stock_reserved_product.stock_reserved_id)

		LEFT JOIN " . DB_PREFIX . "product
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product.product_id )

		LEFT JOIN " . DB_PREFIX . "product_description
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')

		LEFT JOIN " . DB_PREFIX . "user
		ON(" . DB_PREFIX . "stock_reserved_product.added_by = " . DB_PREFIX . "user.user_id)

		LEFT JOIN " . DB_PREFIX . "product_description pd_en
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_en.product_id AND pd_en.language_id='1')
		
		LEFT JOIN " . DB_PREFIX . "product_description pd_cn
		ON(" . DB_PREFIX . "stock_reserved_product.product_id = pd_cn.product_id AND pd_cn.language_id='2')

		LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
		ON(wcd.weight_class_id = " . DB_PREFIX . "stock_reserved_product.weight_class_id
		AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
		)

		LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
		ON(ptc.product_id = " . DB_PREFIX . "stock_reserved_product.product_id)

		LEFT JOIN "  . DB_PREFIX . "category_description cd
		ON(cd.category_id = ptc.category_id
		AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
		)

		LEFT JOIN " . DB_PREFIX . "store s
		ON(s.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)

		LEFT JOIN " . DB_PREFIX . "setting sett
		ON(sett.key = 'config_name' AND sett.store_id = " . DB_PREFIX . "stock_reserved_product.store_id)
		
		LEFT JOIN " . DB_PREFIX . "order_status os
				ON(" . DB_PREFIX . "stock_reserved.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

		WHERE " . DB_PREFIX . "stock_reserved_product.stock_reserved_id = " . (int)$reserved_id . "
	UNION

	SELECT
	
		" . DB_PREFIX . "stock_reserved.added_by as user_id,
		'None' as location,
		" . DB_PREFIX . "stock_reserved.date_added,
		" . DB_PREFIX . "stock_reserved.date_modified,
		'0' as product_id,
		'None' as location_id,
		'None' as qty,
		'None' as product_name,
		'None' as product_name2,
		'None' as product_code,
		" . DB_PREFIX . "stock_reserved.stock_reserved_id,
		" . DB_PREFIX . "stock_reserved.doc_no,
		" . DB_PREFIX . "stock_reserved.doc_date,
		" . DB_PREFIX . "stock_reserved.status,
		" . DB_PREFIX . "stock_reserved.description,
		" . DB_PREFIX . "stock_reserved.store_id,
		'0.0000' AS stock_onhand,
		'0.0000' AS stock_balance,
		'None' as batch_date,


		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
		CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by',

		'' as en_cn_product_name,

		'' as unit,

		'' as category,

		'' as sname,

		'' as remark,

		'' as status_name

	FROM

		" . DB_PREFIX . "stock_reserved

		LEFT JOIN " . DB_PREFIX . "user
		ON(" . DB_PREFIX . "stock_reserved.added_by = " . DB_PREFIX . "user.user_id)

	WHERE 

	" . DB_PREFIX . "stock_reserved.stock_reserved_id NOT IN (SELECT DISTINCT(stock_reserved_id) FROM " . DB_PREFIX . "stock_reserved_product)";

	$query = $this->db->query($sql);

	return $query->rows;
	}

	public function getLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	//get all location if user can view other store data
	public function getAllLocations()
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

		return $query->rows;
	}

	public function getDefaultLocation($product_id)
	{
		$query = $this->db->query("SELECT location_id FROM " . DB_PREFIX . "product_to_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' AND product_id='" . (int)$product_id . "'");

		$location_id = isset($query->row['location_id']) ? $query->row['location_id'] : 0;
		return $location_id;
	}


	public function getLocationText($location_id)
	{
		$query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
		$loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
		return $loc_text;
	}

	public function getWeightClasses()
	{
		$sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getweightClassProduct($product_id)
	{
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
		$query = $this->db->query($sql);

		$weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
		return $weight_class_id;
	}



	public function getProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		//$batch_date='NULL';
		if ($batch_date == 'NULL') {
			$batch_condition = " AND batch_date ='0000-00-00'";
		} else {
			$batch_condition = " AND batch_date=$batch_date";
		}

		$sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
		WHERE store_id='" . (int)$store_id . "' 
		AND product_id='" . (int)$product_id . "' 
		AND location_id='" . (int)$location_id . "'
		$batch_condition";
		$query = $this->db->query($sql);

		if (!empty($query->row['onhand_quantity'])) {
			return $query->row['onhand_quantity'];
		} else {
			$this->addProductStock($store_id, $product_id, $location_id, $batch_date);
			return 0;
		}
	}

	public function getProductReservedStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_condition = " AND batch_date ='0000-00-00'";
		} else {
			$batch_condition = " AND batch_date=$batch_date";
		}

		$sql = "SELECT onhand_reserve FROM " . DB_PREFIX . "product_to_store 
		WHERE store_id='" . (int)$store_id . "' 
		AND product_id='" . (int)$product_id . "' 
		AND location_id='" . (int)$location_id . "'
		$batch_condition";
		$query = $this->db->query($sql);

			return $query->row['onhand_reserve'];
	}

	public function addProductStock($store_id, $product_id, $location_id, $batch_date)
	{
		if ($batch_date == 'NULL') {
			$batch_update = "batch_date='0000-00-00',";
		} else {
			$batch_update = "batch_date=$batch_date,";
		}
		$user_id = (int)$this->session->data['user_id'];
		$sql = "INSERT INTO " . DB_PREFIX . "product_to_store SET
		store_id = " . (int)$store_id . ",
		product_id = " . (int)$product_id . ",
		location_id = " . (int)$location_id . ",
		$batch_update
		product_lastmodifiedby = " . (int)$user_id . ",
		product_lastmodifieddate = NOW()
		";
		$this->db->query($sql);
	}

	public function getLocationList($product_id)
	{
		$def_location = array();
		$sql = "SELECT DISTINCT(pts.location_id), CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) AS location_text FROM " . DB_PREFIX . "product_to_store pts
		LEFT JOIN " . DB_PREFIX . "wms_location wms on (pts.location_id = wms.location_id)
		 WHERE pts.store_id = '" . (int)$this->session->data['store_id'] . "' 
		 AND pts.product_id='" . (int)$product_id . "'
		 ORDER BY location_text asc";

		$query = $this->db->query($sql);
		$location = $query->rows;
		if (!empty($location)) {
			foreach ($location as $loc) {
				if ($loc['location_id'] == 0) {
					$def_location[$loc['location_id']] = 'Default Location';
				} else {
					$def_location[$loc['location_id']] = $loc['location_text'];
				}
			}
		}
		return $def_location;
	}

	public function getBatchDateList($product_id, $location_id)
	{
		$batchDateList = array();
		$sql = "SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'
		ORDER BY FIELD('0000-00-00', batch_date) DESC, batch_date DESC";
		$query = $this->db->query($sql);
		$list = $query->rows;
		if (!empty($list)) {
			foreach ($list as $date) {
				$batchDateList[] = $date['batch_date'];
			}
		}
		return $batchDateList;
	}

	public function getStockOnhand($product_id,$location_id,$batch_date) 
	{
		
		$sql = "SELECT onhand_quantity FROM ". DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "' AND store_id = '". (int)$this->session->data['store_id'] ."'  AND location_id = '" . (int)$location_id . "' AND batch_date = '$batch_date'";

		$query = $this->db->query($sql);

		$def_stock_onhand = $query->row['onhand_quantity'];

		return $def_stock_onhand;
	}

	public function getReserveStock($product_id,$location_id,$batch_date) 
	{
		
		$sql = "SELECT onhand_reserve FROM ". DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "' AND store_id = '". (int)$this->session->data['store_id'] ."' AND location_id = '" . (int)$location_id . "' AND batch_date = '$batch_date'";

		$query = $this->db->query($sql);

		$def_stock_onhand = $query->row['onhand_reserve'];

		return $def_stock_onhand;
	}

	public function getStockReservedOnhand($product_id) 
	{
		
		$sql = "SELECT onhand_reserve FROM ". DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "' AND store_id = '" . (int)$this->session->data['store_id'] . "'AND batch_date = '0000-00-00'";

		$query = $this->db->query($sql);

		$def_stock_reserved = $query->row['onhand_reserve'];

		return $def_stock_reserved;
	}
	

	public function editStockReservedInfo($stock_reserved_id, $data)
	{
		$user_id = (int)$this->session->data['user_id'];

		if (!empty($stock_reserved_id)) {
			$sql = "
                UPDATE " . DB_PREFIX . "stock_reserved
                    SET
                        description = '" . $this->db->escape($data['description'])  . "',
                        modified_by = " . $user_id . ",
                        date_modified = NOW()
                        WHERE stock_reserved_id = '" . (int)$stock_reserved_id . "'
                
            ";
			$this->db->query($sql);
		}
	}

	public function getAllStockReceivedBatchDates()
	{
		$query = $this->db->query("SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "stock_reserved_product WHERE 1 ");

		return $query->rows;
	}

	public function getStaffs()
	{
		$query = $this->db->query("SELECT DISTINCT(st.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_reserved st
		LEFT JOIN " . DB_PREFIX . "user u on (st.added_by = u.user_id)
		ORDER BY staff_name asc");

		return $query->rows;
	}

	public function Totalopenperoducts($data = array())
	{
		$sql = "SELECT COUNT(DISTINCT p.product_id) AS total FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.internal_status =1";

		if (!empty($data['name'])) {
			$sql .= " AND pd.name LIKE '" . $this->db->escape($data['name']) . "%'";
		}

		if (!empty($data['code'])) {
			$sql .= " AND p.code LIKE '" . $this->db->escape($data['code']) . "%'";
		}

		if (isset($data['product_type']) && !is_null($data['product_type'])) {
			$sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
		}

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function getopenperoducts_with_stock($data = array())
	{
		$language_id = $this->config->get('config_language_id');

		$sql = "
		SELECT 

		o.invoice_prefix,
		op.product_id,
		op.order_id,
		pd.name AS product_name,
		p.code
		
		FROM
		" . DB_PREFIX . "order_product op
		LEFT JOIN " . DB_PREFIX . "order o
		ON (op.order_id = o.order_id) 
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON (pd.product_id = op.product_id AND pd.language_id = $language_id)
		LEFT JOIN " . DB_PREFIX . "product p
		ON (p.product_id = op.product_id)

		WHERE 1";

		if (!empty($data['customer_id'])) {
			$sql .= " AND o.customer_id = '" . (int)$data['customer_id'] . "'";
		}

		if (!empty($data['name'])) {
			$sql .= " AND pd.name LIKE '%" . $this->db->escape($data['name']) . "%'";
		}

		if (!empty($data['code'])) {
			$sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
		}

		if (isset($data['product_type']) && !is_null($data['product_type'])) {
			$sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}
			$sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getCategories()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

		return $query->rows;
	}

	public function getStatus()
	{
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from " . DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

		return $query->rows;
	}
}
