<?php
class ModelCatalogStockReceived extends Model
{
    public function getStockReceivedList($data)
    {
        $sort   = isset($data['sort']) ? $data['sort'] : "doc_no";
        $order  = isset($data['order']) ? $data['order'] : "DESC";

        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? explode(',', $data['filter_invoice_prefix']) : array();
        $filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        // $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        // $filter_date_from_str = trim($filter_date_from);
        // $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        // $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        // $filter_date_to_str = trim($filter_date_to);
        // $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;

        $filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
        $filter_batch_date_str = trim($filter_batch_date);
        $filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_invoice_prefix_statement = "";

        foreach ($filter_invoice_prefix as $invoice_prefix) {
            $filter_invoice_prefix_statement .= empty($filter_invoice_prefix_statement) ? "a.doc_no LIKE '%" . $invoice_prefix . "%'" : " OR a.doc_no LIKE '%" . $invoice_prefix . "%'";
        }

        $filter_invoice_prefix_statement = !empty($filter_invoice_prefix_statement) ? "AND ($filter_invoice_prefix_statement)" : "";


        $filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";

        $filter_product_id_statement = $filter_product_id ? "AND a.product_id LIKE '%" . $filter_product_id . "%'" : "";

        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement) ? " a.product_name LIKE '%" . $product_name . "%'" : " OR a.product_name LIKE '%" . $product_name . "%'";
        }
        $filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement) ? "a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";
        $filter_batch_date_statement = $filter_batch_date ? "AND DATE(a.batch_date) = DATE('" . $filter_batch_date . "')" : "";


        $filter_add_by = (!empty($data['filter_add_by']))?
		" AND a.added_by = '" . (int)$data['filter_add_by'] . "'" :
		"";

        $filter_store_id_statement = !empty($data['filter_store_id']) ?
            "AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
            "";

            // $filter_location_id = (!empty($data['filter_location_id'])) ?
            // " AND a.location_id = '" . (int)$data['filter_location_id'] . "'" :
            // "";

            $filter_location_id = !empty($data['filter_location_id']) ?
            "AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :
            "";

        $filter_status_statement = !empty($data['filter_status']) ?

            "AND a.status in (" . implode(',', $data['filter_status']) . ")" :

            "";

        $filter_category_statement = !empty($data['filter_category']) ?

            "AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

            "";

        $sql = "
		SELECT *
		FROM(
			SELECT
                    srp.stock_received_product_id,
                    srp.product_id,
                    srp.name AS product_name,
                    srp.description AS product_description,
                    srp.code AS product_code,
                    srp.quantity,
                    srp.weight_class_id,
                    srp.uom,
                    srp.batch_date,
                    srp.stock_onhand,
                    srp.stock_balance,
                    srp.location_id,
                    srp.location,
                    srp.reason AS product_reason,
                    srp.stock_adjustment_id,
				    sr.stock_received_id,
                    sr.doc_no,
                    sr.description,
                    sr.remark,
                    sr.reason,
                    sr.authorized_by,
                    sr.status,
                    sr.added_by,
                    os.name AS status_name,
                    sr.store_id,
                    sr.cancelled, 
                    sr.date_added,
                    (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,
                    s.name AS store_name,
				    GROUP_CONCAT(DISTINCT cd.name SEPARATOR ', ') AS category,
                    pd_cn.name as product_name2,
                    CONCAT(srp.name, ' ', pd_cn.name) AS 'en_cn_product_name',
                    CONCAT(ua.firstname,' ',ua.lastname) AS add_by,
                    srp.date_modified,
                    CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                    sr.date_cancelled,
                    CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
			FROM
				" . DB_PREFIX . "stock_received_product srp

                LEFT JOIN " . DB_PREFIX . "stock_received sr
                    ON srp.stock_received_id = sr.stock_received_id

                LEFT JOIN " . DB_PREFIX . "store s
                    ON srp.store_id = s.store_id

				LEFT JOIN " . DB_PREFIX . "order_status os
                    ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "

				LEFT JOIN " . DB_PREFIX . "user ua 
                    ON  sr.added_by = ua.user_id

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "user uc 
                    ON   sr.modified_by = uc.user_id

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
                ON(ptc.product_id = srp.product_id)

                LEFT JOIN "  . DB_PREFIX . "category_description cd
                ON(cd.category_id = ptc.category_id
                AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

                WHERE 1 GROUP BY srp.stock_received_product_id
		) a
		WHERE 1
            $filter_invoice_prefix_statement
            $filter_add_by
            $filter_status_statement
            $filter_date_from
            $filter_date_to
            $filter_store_id_statement
            $filter_product_id_statement
            $filter_product_name_statement
            $filter_product_code_statement
            $filter_location_id
            $filter_batch_date_statement
            $filter_status_statement
            $filter_category_statement

		ORDER BY doc_no DESC , stock_received_product_id DESC
		LIMIT $start, $limit";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function totalStockReceived($data)
    {

        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? explode(',', $data['filter_invoice_prefix']) : array();
        $filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        // $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        // $filter_date_from_str = trim($filter_date_from);
        // $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        // $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        // $filter_date_to_str = trim($filter_date_to);
        // $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;

        $filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
        $filter_batch_date_str = trim($filter_batch_date);
        $filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_invoice_prefix_statement = "";

        foreach ($filter_invoice_prefix as $invoice_prefix) {
            $filter_invoice_prefix_statement .= empty($filter_invoice_prefix_statement) ? "a.doc_no LIKE '%" . $invoice_prefix . "%'" : " OR a.doc_no LIKE '%" . $invoice_prefix . "%'";
        }

        $filter_invoice_prefix_statement = !empty($filter_invoice_prefix_statement) ? "AND ($filter_invoice_prefix_statement)" : "";


        $filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(a.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(a.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";

        $filter_product_id_statement = $filter_product_id ? "AND a.product_id LIKE '%" . $filter_product_id . "%'" : "";

        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement) ? " a.product_name LIKE '%" . $product_name . "%'" : " OR a.product_name LIKE '%" . $product_name . "%'";
        }
        $filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement) ? "a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";
        $filter_batch_date_statement = $filter_batch_date ? "AND DATE(a.batch_date) = DATE('" . $filter_batch_date . "')" : "";


        $filter_add_by = (!empty($data['filter_add_by']))?
		" AND a.added_by = '" . (int)$data['filter_add_by'] . "'" :
		"";

        $filter_store_id_statement = !empty($data['filter_store_id']) ?
            "AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
            "";

            // $filter_location_id = (!empty($data['filter_location_id'])) ?
            // " AND a.location_id = '" . (int)$data['filter_location_id'] . "'" :
            // "";

            $filter_location_id = !empty($data['filter_location_id']) ?
            "AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :
            "";

        $filter_status_statement = !empty($data['filter_status']) ?

            "AND a.status in (" . implode(',', $data['filter_status']) . ")" :

            "";

        $filter_category_statement = !empty($data['filter_category']) ?

            "AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

            "";

        $sql = "
		SELECT COUNT(DISTINCT a.stock_received_product_id) AS total
		FROM(
			SELECT
                    srp.stock_received_product_id,
                    srp.product_id,
                    srp.name AS product_name,
                    srp.description AS product_description,
                    srp.code AS product_code,
                    srp.quantity,
                    srp.weight_class_id,
                    srp.uom,
                    srp.batch_date,
                    srp.stock_onhand,
                    srp.stock_balance,
                    srp.location_id,
                    srp.location,
                    srp.reason AS product_reason,
                    srp.stock_adjustment_id,
				    sr.stock_received_id,
                    sr.doc_no,
                    sr.description,
                    sr.remark,
                    sr.reason,
                    sr.authorized_by,
                    sr.status,
                    sr.added_by,
                    os.name AS status_name,
                    sr.store_id,
                    sr.cancelled, 
                    sr.date_added,
                    (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) as category_id,
                    s.name AS store_name,
				    GROUP_CONCAT(DISTINCT cd.name SEPARATOR ', ') AS category,
                    pd_cn.name as product_name2,
                    CONCAT(srp.name, ' ', pd_cn.name) AS 'en_cn_product_name',
                    CONCAT(ua.firstname,' ',ua.lastname) AS add_by,
                    srp.date_modified,
                    CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                    sr.date_cancelled,
                    CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
			FROM
				" . DB_PREFIX . "stock_received_product srp

                LEFT JOIN " . DB_PREFIX . "stock_received sr
                    ON srp.stock_received_id = sr.stock_received_id

                LEFT JOIN " . DB_PREFIX . "store s
                    ON srp.store_id = s.store_id

				LEFT JOIN " . DB_PREFIX . "order_status os
                    ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "

				LEFT JOIN " . DB_PREFIX . "user ua 
                    ON  sr.added_by = ua.user_id

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "user uc 
                    ON   sr.modified_by = uc.user_id

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
                ON(ptc.product_id = srp.product_id)

                LEFT JOIN "  . DB_PREFIX . "category_description cd
                ON(cd.category_id = ptc.category_id
                AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

                WHERE 1 GROUP BY srp.stock_received_product_id
		) a
		WHERE 1
            $filter_invoice_prefix_statement
            $filter_add_by
            $filter_status_statement
            $filter_date_from
            $filter_date_to
            $filter_store_id_statement
            $filter_product_id_statement
            $filter_product_name_statement
            $filter_product_code_statement
            $filter_location_id
            $filter_batch_date_statement
            $filter_status_statement
            $filter_category_statement
		";

        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function getStockReceived($stock_received_id)
    {
        $stock_adjustment_info = array();

        $store_id = $this->session->data['store_id'];
        $user_id = $this->session->data['user_id'];
        $language_id = $this->config->get('config_language_id');

        $sql = "
		SELECT
                    srp.batch_date AS batch_date,
                    sr.stock_received_id,
                    sr.doc_date,
                    sr.doc_no,
                    sr.description,
                    sr.remark,
                    sr.reason,
                    sr.authorized_by,
                    sr.status,
                    sr.store_id,
                    sr.cancelled, 
                    sr.date_added,
                    s.name AS store_name,
                    CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
                    sr.date_modified,
                    CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                    sr.date_cancelled,
                    CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
                FROM " . DB_PREFIX . "stock_received sr
                    LEFT JOIN " . DB_PREFIX . "store s
                        ON sr.store_id = s.store_id
                    LEFT JOIN " . DB_PREFIX . "stock_received_product srp
                        ON sr.stock_received_id = srp.stock_received_id
                    LEFT JOIN " . DB_PREFIX . "order_status os
                        ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "
                    LEFT JOIN " . DB_PREFIX . "user ua 
                        ON sr.added_by = ua.user_id
                    LEFT JOIN " . DB_PREFIX . "user um 
                        ON sr.modified_by = um.user_id
                    LEFT JOIN " . DB_PREFIX . "user uc 
                        ON sr.modified_by = uc.user_id
		        WHERE 1 
                    AND sr.stock_received_id = $stock_received_id
		";

        $query = $this->db->query($sql);

        $stock_received_info = $query->row;

        $sql = "
		SELECT
                srp.stock_received_product_id,
                srp.stock_received_id, 
                srp.product_id,
                srp.name,
                srp.code,
                srp.batch_date,
                srp.description AS remark,
                srp.reason,
                srp.quantity AS qty,
                srp.weight_class_id,
                srp.uom,
                srp.weight_quantity,
                srp.stock_onhand, 
                srp.stock_balance,
                srp.costprice AS price,
                srp.location_id,
                srp.location,
                srp.stock_adjustment_id,
                srp.date_added,
                CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
                srp.date_modified,
                CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                DATE_FORMAT(srp.date_modified, '%d/%m/%Y %h:%i%p') AS 'date_modified',
                pd_cn.name as product_name2,
                srp.modified_by,
                sr.status
		    FROM " . DB_PREFIX . "stock_received_product srp            
                LEFT JOIN " . DB_PREFIX . "product p
                    ON srp.product_id = p.product_id                
                LEFT JOIN " . DB_PREFIX . "product_description pd
                    ON p.product_id = pd.product_id AND pd.language_id = $language_id
                LEFT JOIN
                " . DB_PREFIX . "stock_received sr ON srp.stock_received_id = sr.stock_received_id
                LEFT JOIN " . DB_PREFIX . "user ua 
                    ON sr.added_by = ua.user_id

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
                    ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

		    WHERE 1 
		        AND srp.stock_received_id = $stock_received_id
		";
        $query = $this->db->query($sql);

        $stock_received_item = $query->rows;
        $stock_received_info['stock_received_item'] = $stock_received_item;

        return $stock_received_info;
    }
    public function getStockReceivedProducts($stock_received_id)
    {

        $sql = "
		SELECT
                srp.stock_received_product_id,
                srp.stock_received_id, 
                srp.product_id,
                srp.name,
                pd_cn.name as product_name2,
                srp.code,
                srp.batch_date,
                srp.description AS remark,
                srp.reason,
                srp.quantity AS qty,
                srp.weight_class_id,
                srp.uom as unit,
                srp.weight_quantity,
                srp.stock_onhand, 
                srp.stock_balance,
                srp.costprice AS price,
                srp.location_id,
                srp.location,
                srp.stock_adjustment_id,
                srp.date_added,
                CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
                srp.date_modified,
                CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                DATE_FORMAT(srp.date_modified, '%d/%m/%Y %h:%i%p') AS 'date_modified',
                srp.modified_by,
                sr.status,
                sr.description,
                cd.category_id,
				cd.name AS category
		    FROM " . DB_PREFIX . "stock_received_product srp            
                LEFT JOIN " . DB_PREFIX . "product p
                    ON srp.product_id = p.product_id                
                LEFT JOIN " . DB_PREFIX . "product_description pd
                    ON p.product_id = pd.product_id AND pd.language_id =" . (int) $this->config->get('config_language_id') . "
                LEFT JOIN
                " . DB_PREFIX . "stock_received sr ON srp.stock_received_id = sr.stock_received_id
                LEFT JOIN " . DB_PREFIX . "user ua 
                    ON sr.added_by = ua.user_id
                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
                ON(ptc.product_id = srp.product_id)

                LEFT JOIN "  . DB_PREFIX . "category_description cd
                ON(cd.category_id = ptc.category_id
                AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
                    ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

		    WHERE  srp.stock_received_id = '" . (int)$stock_received_id . "'		";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getStockReceivedItemAll()
    {
        $sql = "
            SELECT
                    srp.stock_received_product_id,
                    srp.product_id,
                    srp.name AS product_name,
                    srp.description AS product_description,
                    srp.code AS product_code,
                    srp.quantity,
                    srp.weight_class_id,
                    srp.uom,
                    srp.batch_date,
                    srp.stock_onhand,
                    srp.stock_balance,
                    srp.location_id,
                    srp.location,
                    srp.reason AS product_reason,
                    srp.stock_adjustment_id,
				    sr.stock_received_id,
                    sr.doc_date,
                    sr.doc_no,
                    sr.description,
                    sr.remark,
                    sr.reason,
                    sr.authorized_by,
                    sr.status,
                    os.name AS status_name,
                    sr.store_id,
                    sr.cancelled, 
                    sr.date_added,
                    cd.category_id,
				    cd.name AS category,
                    pd_cn.name as product_name2,
                    CONCAT(srp.name, ' ', pd_cn.name) AS 'en_cn_product_name',
                    CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
                    srp.date_modified,
                    CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                    sr.date_cancelled,
                    CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
			FROM
				" . DB_PREFIX . "stock_received_product srp

                LEFT JOIN " . DB_PREFIX . "stock_received sr
                    ON srp.stock_received_id = sr.stock_received_id

				LEFT JOIN " . DB_PREFIX . "order_status os
                    ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "

				LEFT JOIN " . DB_PREFIX . "user ua 
                    ON  sr.added_by = ua.user_id

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "user uc 
                    ON   sr.modified_by = uc.user_id

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
                ON(ptc.product_id = srp.product_id)

                LEFT JOIN "  . DB_PREFIX . "category_description cd
                ON(cd.category_id = ptc.category_id
                AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')

                GROUP BY srp.stock_received_product_id
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStockReceivedItemSearched($data)
    {
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? explode(',', $data['filter_invoice_prefix']) : array();
        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
        $filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();
        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;

        $filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
        $filter_batch_date_str = trim($filter_batch_date);
        $filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $filter_invoice_prefix_statement = "";

        foreach ($filter_invoice_prefix as $invoice_prefix) {
            $filter_invoice_prefix_statement .= empty($filter_invoice_prefix_statement) ? "a.doc_no LIKE '%" . $invoice_prefix . "%'" : " OR a.doc_no LIKE '%" . $invoice_prefix . "%'";
        }

        $filter_invoice_prefix_statement = !empty($filter_invoice_prefix_statement) ? "AND ($filter_invoice_prefix_statement)" : "";

        $filter_add_by_statement = $filter_add_by ? "AND a.added_by LIKE '%" . $filter_add_by . "%'" : "";
        $filter_date_from_statement = $filter_date_from ? "AND DATE(a.doc_date) >= DATE('" . $filter_date_from . "')" : "";
        $filter_date_to_statement = $filter_date_to ? "AND DATE(a.doc_date) <= DATE('" . $filter_date_to . "')" : "";
        $filter_product_id_statement = $filter_product_id ? "AND a.product_id LIKE '%" . $filter_product_id . "%'" : "";

        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement .= empty($filter_product_name_statement) ? " a.product_name LIKE '%" . $product_name . "%'" : " OR a.product_name LIKE '%" . $product_name . "%'";
        }
        $filter_product_name_statement = !empty($filter_product_name_statement) ? " AND ($filter_product_name_statement)" : "";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement) ? "a.product_code LIKE '%" . $product_code . "%'" : " OR a.product_code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement) ? " AND ($filter_product_code_statement)" : "";
        $filter_batch_date_statement = $filter_batch_date ? "AND DATE(a.batch_date) = DATE('" . $filter_batch_date . "')" : "";

        $filter_store_id_statement = !empty($data['filter_store_id']) ?
            "AND a.store_id in (" . implode(',', $data['filter_store_id']) . ")" :
            "";

        $filter_location_id_statement = !empty($data['filter_location_id']) ?
            "AND a.location_id in (" . implode(',', $data['filter_location_id']) . ")" :
            "";

        $filter_status_statement = !empty($data['filter_status']) ?

            "AND a.status in (" . implode(',', $data['filter_status']) . ")" :

            "";

        $filter_category_statement = !empty($data['filter_category']) ?

            "AND a.category_id in (" . implode(',', $data['filter_category']) . ")" :

            "";

        $sql = "
		SELECT *
		FROM(
			SELECT
                    srp.stock_received_product_id,
                    srp.product_id,
                    srp.name AS product_name,
                    srp.description AS product_description,
                    srp.code AS product_code,
                    srp.quantity,
                    srp.weight_class_id,
                    srp.uom,
                    srp.batch_date,
                    srp.stock_onhand,
                    srp.stock_balance,
                    srp.location_id,
                    srp.location,
                    srp.reason AS product_reason,
                    srp.stock_adjustment_id,
				    sr.stock_received_id,
                    sr.doc_date,
                    sr.doc_no,
                    sr.description,
                    sr.remark,
                    sr.reason,
                    sr.authorized_by,
                    sr.status,
                    os.name AS status_name,
                    sr.store_id,
                    sr.cancelled, 
                    sr.date_added,
                    cd.category_id,
				    cd.name AS category,
                    pd_cn.name as product_name2,
                    CONCAT(srp.name, ' ', pd_cn.name) AS 'en_cn_product_name',
                    CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
                    srp.date_modified,
                    CONCAT(um.firstname,' ',um.lastname) AS modified_by,
                    sr.date_cancelled,
                    CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
			FROM
				" . DB_PREFIX . "stock_received_product srp

                LEFT JOIN " . DB_PREFIX . "stock_received sr
                    ON srp.stock_received_id = sr.stock_received_id

				LEFT JOIN " . DB_PREFIX . "order_status os
                    ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "

				LEFT JOIN " . DB_PREFIX . "user ua 
                    ON  sr.added_by = ua.user_id

                LEFT JOIN " . DB_PREFIX . "user um 
                    ON  srp.modified_by = um.user_id

                LEFT JOIN " . DB_PREFIX . "user uc 
                    ON   sr.modified_by = uc.user_id

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
                ON(ptc.product_id = srp.product_id)

                LEFT JOIN "  . DB_PREFIX . "category_description cd
                ON(cd.category_id = ptc.category_id
                AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')
		) a
		WHERE 1
            $filter_invoice_prefix_statement
            $filter_add_by_statement
            $filter_status_statement
            $filter_date_from_statement
            $filter_date_to_statement
            $filter_store_id_statement
            $filter_product_id_statement
            $filter_product_name_statement
            $filter_product_code_statement
            $filter_location_id_statement
            $filter_batch_date_statement
            $filter_status_statement
            $filter_category_statement
";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStockReceivedItemSelected($receive_id)
    {
        $sql = "SELECT
            srp.stock_received_product_id,
            srp.product_id,
            srp.name AS product_name,
            srp.description AS product_description,
            srp.code AS product_code,
            srp.quantity,
            srp.weight_class_id,
            srp.uom,
            srp.batch_date,
            srp.stock_onhand,
            srp.stock_balance,
            srp.location_id,
            srp.location,
            srp.reason AS product_reason,
            srp.stock_adjustment_id,
            sr.stock_received_id,
            sr.doc_date,
            sr.doc_no,
            sr.description,
            sr.remark,
            sr.reason,
            sr.authorized_by,
            sr.status,
            os.name AS status_name,
            sr.store_id,
            sr.cancelled, 
            sr.date_added,
            cd.category_id,
            cd.name AS category,
            pd_cn.name as product_name2,
            CONCAT(srp.name, ' ', pd_cn.name) AS 'en_cn_product_name',
            CONCAT(ua.firstname,' ',ua.lastname) AS added_by,
            srp.date_modified,
            CONCAT(um.firstname,' ',um.lastname) AS modified_by,
            sr.date_cancelled,
            CONCAT(uc.firstname,' ',uc.lastname) AS cancelled_by
    FROM
        " . DB_PREFIX . "stock_received_product srp

        LEFT JOIN " . DB_PREFIX . "stock_received sr
            ON srp.stock_received_id = sr.stock_received_id

        LEFT JOIN " . DB_PREFIX . "order_status os
            ON sr.status = os.order_status_id AND os.language_id = " . (int)$this->config->get('config_language_id') . "

        LEFT JOIN " . DB_PREFIX . "user ua 
            ON  sr.added_by = ua.user_id

        LEFT JOIN " . DB_PREFIX . "user um 
            ON  srp.modified_by = um.user_id

        LEFT JOIN " . DB_PREFIX . "user uc 
            ON   sr.modified_by = uc.user_id

        LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
        ON(ptc.product_id = srp.product_id)

        LEFT JOIN "  . DB_PREFIX . "category_description cd
        ON(cd.category_id = ptc.category_id
        AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
        )

        LEFT JOIN " . DB_PREFIX . "product_description pd_en
        ON(srp.product_id = pd_en.product_id AND pd_en.language_id='1')
        
        LEFT JOIN " . DB_PREFIX . "product_description pd_cn
        ON(srp.product_id = pd_cn.product_id AND pd_cn.language_id='2')
        
        WHERE srp.stock_received_id = '" . (int)$receive_id . "'";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function addStockReceived($data)
    {
        $stock_received_id = 0;
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        if (!empty($data['doc_no']) && $invoice_prefix == $data['doc_no']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        }
        $store_id = (int)$this->session->data['store_id'];
        $user_id = (int)$this->session->data['user_id'];
        $stock_received_item = !empty($data['stock_received_item']) ? $data['stock_received_item'] : [];
        $cancelled = !empty($data['cancelled']) ? 1 : 0;
        $cancelled_sql = !empty($data['cancelled']) ? ' , cancelled_by = ' . $this->session->data['user_id'] . ' , date_cancelled  = NOW() ' : '';
        $status = !empty($data['status']) ? $data['status'] : 1;
        $doc_date = !empty($data['doc_date']) ? date('Y-m-d', strtotime($data['doc_date'])) : date('Y-m-d');

        $sql = "
            INSERT INTO " . DB_PREFIX . "stock_received 
                SET
                    doc_no = '" .  $this->db->escape($data['doc_no']) . "',
                    doc_date = '" .  $this->db->escape($doc_date) . "',
                    store_id = " . (int)$store_id . ",
                    status = " . (int)$data['status'] . ",
                    description = '" . $this->db->escape($data['description'])  . "',
                    reason = '" . $this->db->escape($data['reason'])  . "',
                    remark = '" . $this->db->escape($data['remark'])  . "',
                    authorized_by = '" . $this->db->escape($data['authorized_by'])  . "',
                    added_by = " . (int)$user_id . ",
                    date_added = '" .  $this->db->escape($doc_date) . "',
                    cancelled = '" . (int)$cancelled  . "'
                    $cancelled_sql
               
		";
        $this->db->query($sql);
        $stock_received_id =  $this->db->getLastId();

        if (!empty($stock_received_id)) {
            $item_sql = "
            INSERT INTO " . DB_PREFIX . "stock_received_product 
                SET
                    stock_received_id = " . $stock_received_id . ",
                    store_id = '" . (int)$store_id . "',
                    added_by = " . (int)$user_id . ",
                    date_added = '" .  $this->db->escape($doc_date) . "',
                    modified_by = '" . (int)$user_id . "',
                    date_modified = NOW()
            ";
            $this->db->query($item_sql);
        }

        return $stock_received_id;
    }

    public function editStockReceived($stock_received_id, $data)
    {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        if (!empty($data['doc_no']) && $invoice_prefix == $data['doc_no']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        }

        $store_id = (int)$this->session->data['store_id'];
        $user_id = (int)$this->session->data['user_id'];
        $stock_received_item = !empty($data['stock_received_item']) ? $data['stock_received_item'] : [];
        $cancelled = !empty($data['cancelled']) ? 1 : 0;
        $cancelled_sql = !empty($data['cancelled']) ? ' , cancelled_by = ' . $this->session->data['user_id'] . ' , date_cancelled  = NOW() ' : '';
        $status = !empty($data['status']) ? $data['status'] : 1;
        $current_status = !empty($data['current_status']) ? $data['current_status'] : 1;
        $doc_date = !empty($data['doc_date']) ? date('Y-m-d H:i:s', strtotime($data['doc_date'])) : date('Y-m-d H:i:s');

        if (!empty($stock_received_id)) {
            $sql = "
                UPDATE " . DB_PREFIX . "stock_received 
                    SET
                        doc_no = '" .  $this->db->escape($data['doc_no']) . "',
                        doc_date = '" .  $this->db->escape($doc_date) . "',
                        store_id = " . (int)$store_id . ",
                        status = " . (int)$data['status'] . ",
                        description = '" . $this->db->escape($data['description'])  . "',
                        reason = '" . $this->db->escape($data['reason'])  . "',
                        remark = '" . $this->db->escape($data['remark'])  . "',
                        authorized_by = '" . $this->db->escape($data['authorized_by'])  . "',
                        modified_by = " . $user_id . ",
                        date_modified = NOW(),
                        cancelled = '" . (int)$cancelled  . "'
                        $cancelled_sql
                    WHERE 1 
                        AND stock_received_id = '" . (int)$stock_received_id . "'
                
            ";
            $this->db->query($sql);

            $this->load->model('localisation/weight_class');
            $this->load->model('catalog/product');
            $this->load->library('weight');
            $this->weight = new Weight($this->registry);

		    $old_user_id = $this->db->query("SELECT added_by FROM " . DB_PREFIX . "stock_received WHERE stock_received_id = '" . (int)$stock_received_id . "'")->row['added_by'];


            $this->db->query("DELETE FROM `oc_stock_received_product` WHERE 1 AND stock_received_id = '"  . (int)$stock_received_id . "'");
            if (!empty($stock_received_item) && $current_status == 1) {
                foreach ($stock_received_item as $row_id => $item) {
                    $product_id = !empty($item['product_id']) ? $item['product_id'] : 0;
                    $weight_class_id = !empty($item['weight_class_id']) ? $item['weight_class_id'] : $this->config->get('config_weight_class_id');
                    $weight_info = $this->model_localisation_weight_class->getWeightClass($weight_class_id);
                    $weight_unit = !empty($weight_info['unit']) ? $weight_info['unit'] : '';
                    $location_id = $item['location_id'];

                    if (!empty($product_id)) {
                        $batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';
                        $quantity = !empty($item['qty']) ? $item['qty'] : 1;
                        $product_info = $this->model_catalog_product->getProduct($product_id);
                        $default_weight_class = (int)$this->config->get('config_weight_class_id');
                        $product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;
                        $total_product_weight = $quantity * $product_weight;
                        $weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $default_weight_class);
                        $stock_onhand = !empty($this->getProductStock($store_id, $product_id, $item['location_id'], $batch_date)) ? $this->getProductStock($store_id, $product_id, $item['location_id'], $batch_date) : 0;
                        $stock_balance = $stock_onhand + $quantity; 
                        
                        $item_sql = "
                        INSERT INTO " . DB_PREFIX . "stock_received_product 
                            SET
                                stock_received_id = " . (int)$stock_received_id . ",
                                store_id = '" . (int)$store_id . "',
                                product_id = " . (int)$item['product_id'] . ",
                                code = '" . $this->db->escape($item['code']) . "',
                                name = '" . $this->db->escape($item['name']) . "',
                                description = '" . $this->db->escape($item['remark']) . "',
                                batch_date = '".$this->db->escape($batch_date)."',
                                quantity = '" . (float)$item['qty'] . "',
                                location_id = '" . (int)$item['location_id'] . "',
                                location = '" . $this->db->escape($item['location']) . "',
                                weight_class_id = '" . (int)$item['weight_class_id'] . "',
                                uom = '" . $this->db->escape($weight_unit) . "',
                                weight_quantity = '" . (float)$weight_quantity . "',
                                stock_onhand = '" . (float)$stock_onhand . "',
                                stock_balance = '" . (float)$stock_balance . "',
                                added_by = " . (int)$old_user_id . ",
                                date_added = '" .  $this->db->escape($doc_date) . "',
                                modified_by = '" . (int)$user_id . "',
                                date_modified = NOW()
                        ";
                        $this->db->query($item_sql);

                        if ($status == 5) {
                            $query_pts = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id  . "' AND store_id = '" . (int)$store_id  . "' AND location_id = '" . (int)$location_id  . "' AND batch_date = '" . $this->db->escape($batch_date) . "'");
                            if ($query_pts->num_rows) {
                                $calculation_sql = "
                                UPDATE " . DB_PREFIX . "product_to_store 
                                    SET
                                        onhand_quantity = (onhand_quantity + '" . (float)$quantity . "')
                                WHERE 1 
                                    AND batch_date =  '".$this->db->escape($batch_date)."'
                                    AND location_id = '" . (int)$location_id . "'
                                    AND product_id = '" . (int)$product_id . "'
                                    AND store_id = '" . (int)$store_id . "'
                                ";
                            } else {

                                $calculation_sql = " INSERT INTO  " . DB_PREFIX . "product_to_store SET onhand_quantity = onhand_quantity + $quantity, product_id = '" . (int)$product_id  . "', store_id = '" . (int)$store_id  . "',
                                location_id = '" . (int)$location_id  . "', batch_date = '" . $this->db->escape($batch_date) . "', product_lastmodifiedby = '" . (int)$this->session->data['user_id'] . "', product_lastmodifieddate = NOW()
                                ";
                            }
                            $this->db->query($calculation_sql);
                        }
                    }
                }
            } else {
                if ($current_status == 1) {
                    $item_sql = "
                    INSERT INTO " . DB_PREFIX . "stock_received_product 
                        SET
                            stock_received_id = " . (int)$stock_received_id . ",
                            store_id = '" . (int)$store_id . "',
                            added_by = " . (int)$user_id . ",
                            date_added ='" .  $this->db->escape($doc_date) . "',
                            modified_by = '" . (int)$user_id . "',
                            date_modified = NOW()
                    ";
                    $this->db->query($item_sql);
                }
            }
        }
    }

    public function editStockReceivedDetail($stock_received_id, $data)
    {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        if (!empty($data['doc_no']) && $invoice_prefix == $data['doc_no']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_received', 'store' => $this->session->data['store_id']));
        }

        $store_id = (int)$this->session->data['store_id'];
        $user_id = (int)$this->session->data['user_id'];
        $stock_received_item = !empty($data['stock_received_item']) ? $data['stock_received_item'] : [];
        $cancelled = !empty($data['cancelled']) ? 1 : 0;
        $cancelled_sql = !empty($data['cancelled']) ? ' , cancelled_by = ' . $this->session->data['user_id'] . ' , date_cancelled  = NOW() ' : '';
        $status = !empty($data['status']) ? $data['status'] : 1;
        $current_status = !empty($data['current_status']) ? $data['current_status'] : 1;

        if (!empty($stock_received_id)) {
            $sql = "
                UPDATE " . DB_PREFIX . "stock_received 
                    SET
                        doc_no = '" .  $this->db->escape($data['doc_no']) . "',
                        doc_date = '" .  $this->db->escape($data['doc_date']) . "',
                        store_id = " . (int)$store_id . ",
                        status = " . (int)$data['status'] . ",
                        description = '" . $this->db->escape($data['description'])  . "',
                        reason = '" . $this->db->escape($data['reason'])  . "',
                        remark = '" . $this->db->escape($data['remark'])  . "',
                        authorized_by = '" . $this->db->escape($data['authorized_by'])  . "',
                        modified_by = " . (int)$user_id . ",
                        date_modified = NOW(),
                        cancelled = '" . (int)$cancelled  . "'
                        $cancelled_sql
                    WHERE 1 
                        AND stock_received_id = '" . (int)$stock_received_id . "'
                
            ";
            $this->db->query($sql);
        }
    }

    public function deductItem($stock_received_product_id, $remark)
    {


        $sql = "SELECT * FROM " . DB_PREFIX . "stock_received_product WHERE stock_received_product_id ='$stock_received_product_id'";
        $query = $this->db->query($sql);
        $item = $query->row;

        if (empty($item)) {
            return false;
        } else {

            $data2 = array();
            $data2['description'] = $remark;
            //action=1 (plus) 0 (minus)
            $product_id = $item['product_id'];
            $action = 0;

            $product_id = $item['product_id'];
            $wcid = $item['weight_class_id'];
            $location_id = $item['location_id'];
            $batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

            //adjust quantity
            $qty = $item['quantity'];
            $converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));
            $data2['stock_adjustment_item'][] = array(
                'product_id' => $product_id,
                'action' => $action,
                'qty' => $converted_qty,
                'unit' => $wcid,
                'remark' => 'stock received cancel item',
                'batch_date' => $batch_date,
                'location' => $location_id,
            );
            $this->load->model('catalog/stock_adjustment');
            $stock_adj_id = $this->model_catalog_stock_adjustment->addStockAdjustment($data2);
            $this->db->query("UPDATE " . DB_PREFIX . "stock_received_product SET
                            reason = '" . $this->db->escape($remark) . "',
                            stock_adjustment_id = '" . (int)$stock_adj_id . "'
                            WHERE stock_received_product_id = '" . (int)$stock_received_product_id . "'");
        }
    }

    public function addStockReceivedProduct($data)
    {
        $stock_received_id = !empty($data['stock_received_id']) ? $data['stock_received_id'] : 0;
        $stock_received_product_id = 0;
        if (!empty($stock_received_id)) {
            $this->load->model('localisation/weight_class');
            $this->load->model('catalog/product');
            $this->load->library('weight');
            $this->weight = new Weight($this->registry);

            $product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
            $store_id = (int)$this->session->data['store_id'];
            $user_id = (int)$this->session->data['user_id'];
            if (!empty($product_id)) {
                $weight_class_id = !empty($item['weight_class_id']) ? $item['weight_class_id'] : $this->config->get('config_weight_class_id');
                $weight_info = $this->model_localisation_weight_class->getWeightClass($weight_class_id);
                $weight_unit = !empty($weight_info['unit']) ? $weight_info['unit'] : '';
                $quantity = !empty($item['qty']) ? $item['qty'] : 1;
                $product_info = $this->model_catalog_product->getProduct($product_id);
                $default_weight_class = !empty($product_info['weight_class_id']) ? $product_info['weight_class_id'] : 0;
                $product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;
                $total_product_weight = $quantity * $product_weight;
                $weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $default_weight_class);
                $batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

                $product_location = !empty($data['location_id']) ? $data['location_id'] : 0;
                $product_location_text = !empty($data['location']) ? $data['location'] : '';
                $stock_onhand = !empty($this->getProductStock($store_id, $product_id, $product_location, $batch_date)) ? $this->getProductStock($store_id, $product_id, $product_location, $batch_date) : 0;
                $stock_balance = $stock_onhand + $quantity;

                $item_sql = "
                    INSERT INTO " . DB_PREFIX . "stock_received_product 
                        SET
                            stock_received_id = " . (int)$stock_received_id . ",
                            store_id = '" . (int)$store_id . "',
                            product_id = " . (int)$data['product_id'] . ",
                            code = '" . $this->db->escape($data['code']) . "',
                            name = '" . $this->db->escape($data['name']) . "',
                            description = '" . $this->db->escape($data['remark']) . "',
                            quantity = '" . (float)$data['qty'] . "',
                            location_id = '" . (int)$product_location . "',
                            location = '" . $this->db->escape($product_location_text) . "',
                            weight_class_id = '" . (int)$data['weight_class_id'] . "',
                            uom = '" . $this->db->escape($weight_unit) . "',
                            weight_quantity = '" . (float)$weight_quantity . "',
                            stock_onhand = '" . (float)$stock_onhand . "',
                            stock_balance = '" . (float)$stock_balance . "',
                            added_by = " . (int)$user_id . ",
                            date_added = NOW(),
                            modified_by = '" . (int)$user_id . "',
                            date_modified = NOW()
                    ";
                $this->db->query($item_sql);
                $stock_received_product_id =  $this->db->getLastId();
            }
        }

        return $stock_received_product_id;
    }

    public function editStockReceivedProduct($data)
    {
        $stock_received_product_id = !empty($data['stock_received_product_id']) ? $data['stock_received_product_id'] : 0;
        if (!empty($stock_received_product_id)) {
            $this->load->model('localisation/weight_class');
            $this->load->model('catalog/product');
            $this->load->library('weight');
            $this->weight = new Weight($this->registry);

            $product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
            $store_id = (int)$this->session->data['store_id'];
            $user_id = (int)$this->session->data['user_id'];
            if (!empty($product_id)) {
                $weight_class_id = !empty($item['weight_class_id']) ? $item['weight_class_id'] : $this->config->get('config_weight_class_id');
                $weight_info = $this->model_localisation_weight_class->getWeightClass($weight_class_id);
                $weight_unit = !empty($weight_info['unit']) ? $weight_info['unit'] : '';
                $quantity = !empty($item['qty']) ? $item['qty'] : 1;
                $product_info = $this->model_catalog_product->getProduct($product_id);
                $default_weight_class = !empty($product_info['weight_class_id']) ? $product_info['weight_class_id'] : 0;
                $product_weight = !empty($product_info['weight']) ? $product_info['weight'] : 1;
                $total_product_weight = $quantity * $product_weight;
                $weight_quantity = $this->weight->convert($total_product_weight, $weight_class_id, $default_weight_class);
                $batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

                $product_location = !empty($data['location_id']) ? $data['location_id'] : 0;
                $product_location_text = !empty($data['location_text']) ? $data['location_text'] : '';
                $stock_onhand = !empty($this->getProductStock($store_id, $product_id, $product_location, $batch_date)) ? $this->getProductStock($store_id, $product_id, $product_location, $batch_date) : 0;
                $stock_balance = $stock_onhand + $quantity;

                $item_sql = "
                   UPDATE " . DB_PREFIX . "stock_received_product 
                        SET
                            store_id = '" . $store_id . "',
                            product_id = " . (int)$data['product_id'] . ",
                            code = '" . $this->db->escape($data['code']) . "',
                            name = '" . $this->db->escape($data['name']) . "',
                            description = '" . $this->db->escape($data['remark']) . "',
                            quantity = '" . (float)$data['qty'] . "',
                            location_id = '" . (int)$product_location . "',
                            location = '" . $this->db->escape($product_location_text) . "',
                            weight_class_id = '" . (int)$data['weight_class_id'] . "',
                            uom = '" . $this->db->escape($weight_unit) . "',
                            weight_quantity = '" . (float)$weight_quantity . "',
                            stock_onhand = '" . (float)$stock_onhand . "',
                            stock_balance = '" . (float)$stock_balance . "',
                            added_by = " . (int)$user_id . ",
                            date_added = NOW(),
                            modified_by = '" . (int)$user_id . "',
                            date_modified = NOW()
                        WHERE 1
                            AND stock_received_product_id = '" . (int)$stock_received_product_id . "'
                    ";
                $this->db->query($item_sql);
            }
        }
    }

    /** Will move model/catalog/product after done this module */
    public function getProductStock($store_id, $product_id, $location_id, $batch_date)
    {
        if ($batch_date == 'NULL') {
            $batch_condition = " AND batch_date ='0000-00-00'";
        } else {
            $batch_condition = " AND batch_date= '".$this->db->escape($batch_date)."'";
        }

        $sql = "
            SELECT
                    pts.onhand_quantity AS stock
                FROM 
                    `" . DB_PREFIX . "product_to_store` pts
                WHERE 1
                    AND pts.store_id = '" . (int)$store_id . "'
                    AND pts.product_id = '" . (int)$product_id . "'
                    AND pts.location_id = '" . (int)$location_id . "'
                    $batch_condition       
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            return !empty($query->row['stock']) ? $query->row['stock'] : 0;
        } else {
            //$this->addProductStock($store_id, $product_id, $location_id, $batch_date);
            return 0;
        }
    }

    public function addProductStock($store_id, $product_id, $location_id, $batch_date)
    {
        if ($batch_date == 'NULL') {
            $batch_update = "batch_date='0000-00-00',";
        } else {
            $batch_update = "batch_date=$batch_date,";
        }
        $user_id = (int)$this->session->data['user_id'];
        $sql = "INSERT INTO " . DB_PREFIX . "product_to_store SET
		store_id = " . (int)$store_id . ",
		product_id = " . (int)$product_id . ",
		location_id = " . (int)$location_id . ",
		$batch_update
		product_lastmodifiedby = " . (int)$user_id . ",
		product_lastmodifieddate = NOW()
		";
        $this->db->query($sql);
    }

    public function getDefaultLocation($product_id)
    {
        $query = $this->db->query("SELECT location_id FROM " . DB_PREFIX . "product_to_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' AND product_id='" . (int)$product_id . "'");

        $location_id = isset($query->row['location_id']) ? $query->row['location_id'] : 0;
        return $location_id;
    }

    public function getAllLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    public function getLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    public function getWeightClasses()
    {
        $sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getweightClassProduct($product_id)
    {
        $sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
        $query = $this->db->query($sql);

        $weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
        return $weight_class_id;
    }

    public function getAllStockReceivedBatchDates()
    {
        $query = $this->db->query("SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "stock_received_product WHERE 1 ");

        return $query->rows;
    }

    public function getStaffs()
    {
        $query = $this->db->query("SELECT DISTINCT(sr.added_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_received sr
		LEFT JOIN " . DB_PREFIX . "user u on (sr.added_by = u.user_id)
		ORDER BY staff_name asc");

        return $query->rows;
    }

    public function getStatus()
    {
        $query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from " . DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

        return $query->rows;
    }

    public function getCategories()
    {
        $query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

        return $query->rows;
    }


    public function getProductForStockReceived($data = array())
    {

        $sql = "
            SELECT 
                    p.product_id,
                    p.code,
                    p.model,
                    p.price,
                    p.costprice,
                    pd.name AS name,
                    CONCAT(pd_cn.name, ' ', pd_en.name) AS product_name,
                    w.weight_class_id,
                    w.title,
                    w.unit,
                    ptl.location_id,
                    ptl.location AS location_text,
                    pts.onhand_quantity
                    
                FROM " . DB_PREFIX . "product p 
                    LEFT JOIN " . DB_PREFIX . "product_description pd 
                        ON p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_en 
                        ON p.product_id = pd_en.product_id AND pd_en.language_id = '1'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
                        ON p.product_id = pd_cn.product_id AND pd_cn.language_id = '2'
                    LEFT JOIN " . DB_PREFIX . "weight_class_description w 
                        ON p.weight_class_id = w.weight_class_id AND w.language_id = " . (int) $this->config->get('config_language_id') . "
                    LEFT JOIN " . DB_PREFIX . "product_to_location ptl
                        ON p.product_id = ptl.product_id AND ptl.store_id = " . (int) $this->session->data['store_id'] . "
                    LEFT JOIN " . DB_PREFIX . "product_to_store pts
                        ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
                WHERE 1 
                    AND p.internal_status = 1 ";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $sql .= " GROUP BY p.product_id";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        /*
           echo "<pre>";
           print_r($sql);
           echo "</pre>";
          */

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProductForStockReceived($data = array())
    {
        $sql = "
            SELECT 
                    COUNT(DISTINCT p.product_id) AS total
                FROM " . DB_PREFIX . "product p 
                    LEFT JOIN " . DB_PREFIX . "product_description pd 
                        ON p.product_id = pd.product_id AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_en 
                        ON p.product_id = pd_en.product_id AND pd_en.language_id = '1'
                    LEFT JOIN " . DB_PREFIX . "product_description pd_cn 
                        ON p.product_id = pd_cn.product_id AND pd_cn.language_id = '2'
                    LEFT JOIN " . DB_PREFIX . "weight_class_description w 
                        ON p.weight_class_id = w.weight_class_id AND w.language_id = " . (int) $this->config->get('config_language_id') . "
                    LEFT JOIN " . DB_PREFIX . "product_to_location ptl
                        ON p.product_id = ptl.product_id AND ptl.store_id = " . (int) $this->session->data['store_id'] . "
                    LEFT JOIN " . DB_PREFIX . "product_to_store pts
                        ON p.product_id = pts.product_id AND pts.store_id = " . (int) $this->session->data['store_id'] . "
                WHERE 1 
                    AND p.internal_status = 1 GROUP BY p.product_id ";

        if (!empty($data['name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['name']) . "%'";
        }

        if (!empty($data['code'])) {
            $sql .= " AND p.code LIKE '%" . $this->db->escape($data['code']) . "%'";
        }

        if (isset($data['product_type']) && !is_null($data['product_type'])) {
            $sql .= " AND p.product_type = '" . (int) $data['product_type'] . "'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }
}
