<?php
class ModelCatalogStockIssue extends Model
{
    public function getStockIssue($stock_issue_id)
    {
        $stock_issue_info = array();



        $store_id = $this->session->data['store_id'];

        $user_id = $this->session->data['user_id'];

        $language_id = $this->config->get('config_language_id');



        $sql = "

		SELECT

				" . DB_PREFIX . "stock_issue.*,

				CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'staff',

				" . DB_PREFIX . "stock_issue.store_id,

                CONCAT(" . DB_PREFIX . "customer.firstname, ' ', " . DB_PREFIX . "customer.lastname) AS fname,

                " . DB_PREFIX . "customer.customer_id
                
			FROM
                " . DB_PREFIX . "stock_issue

                LEFT JOIN " . DB_PREFIX . "customer ON
                (" . DB_PREFIX . "customer.customer_id = " . DB_PREFIX . "stock_issue.customer_id),

				" . DB_PREFIX . "user

			WHERE " . DB_PREFIX . "stock_issue.add_by = " . DB_PREFIX . "user.user_id

			AND " . DB_PREFIX . "stock_issue.stock_issue_id = $stock_issue_id


		";



        $query = $this->db->query($sql);



        $stock_issue_info = $query->row;



        $sql = "

		SELECT

			" . DB_PREFIX . "product.product_id,

			" . DB_PREFIX . "product_description.name AS product_name,

			" . DB_PREFIX . "product.code AS product_code,

			" . DB_PREFIX . "product_to_store.onhand_quantity,

            " . DB_PREFIX . "category_description.name AS category,

            " . DB_PREFIX . "stock_issue_item.*            

		FROM

			" . DB_PREFIX . "stock_issue_item,

			" . DB_PREFIX . "product,

			" . DB_PREFIX . "product_to_store,

			" . DB_PREFIX . "product_description,

            " . DB_PREFIX . "category_description,

            " . DB_PREFIX . "product_to_category

		WHERE " . DB_PREFIX . "stock_issue_item.product_id = " . DB_PREFIX . "product.product_id

		AND " . DB_PREFIX . "product.product_id = " . DB_PREFIX . "product_description.product_id

		AND " . DB_PREFIX . "product_description.language_id = $language_id

		AND " . DB_PREFIX . "stock_issue_item.stock_issue_id = $stock_issue_id

		AND " . DB_PREFIX . "product_to_store.product_id = " . DB_PREFIX . "stock_issue_item.product_id

		AND " . DB_PREFIX . "product_to_store.location_id = " . DB_PREFIX . "stock_issue_item.location_id

        AND " . DB_PREFIX . "product_to_store.batch_date = " . DB_PREFIX . "stock_issue_item.batch_date

		AND " . DB_PREFIX . "product_to_store.store_id = $store_id
        
        AND " . DB_PREFIX . "category_description.category_id = " . DB_PREFIX . "product_to_category.category_id";



        $query = $this->db->query($sql);



        $stock_issue_items = $query->rows;



        foreach ($stock_issue_items as $product) {

            $stock_issue_info['stock_issue_item'][$product['stock_issue_item_id']] = array(
                'stock_issue_item_id' => $product['stock_issue_item_id'],
                'product_name' => $product['product_name'],
                'product_id' => $product['product_id'],
                'product_code' => $product['product_code'],
                'batch_date' => $product['batch_date'],
                'onhand_quantity' => $product['onhand_quantity'],
                'quantity' => $product['quantity'],
                'weight_class_id' => $product['weight_class_id'],
                'location_id' => $product['location_id'],
                'remark' => $product['remark'],
                'category' => $product['category']
            );
        }



        return $stock_issue_info;
    }

    public function getProduct($product_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' WHERE p.product_id = '" . (int)$product_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }


    public function getProductStock($product_id)
    {
        $sql = "
		SELECT 
        *
        
        FROM 
        " . DB_PREFIX . "product

		  
       WHERE
       product_id = '" . (int)$product_id . "'
       ";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getHerbalRemediesItem($data = array())
    {
        $store_id = $this->session->data['store_id'];

        $date_ranges = isset($data['date']) ? $data['date'] : array();

        $transaction_ranges = isset($data['transaction']) ? $data['transaction'] : array();

        $range_statement = '';

        if ($date_ranges || $transaction_ranges) {
            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(cs.date_added) >= '" . $range['from'] . "' AND DATE(cs.date_added) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (cs.invoice_prefix >= '" . $range['from'] . "' AND cs.invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $range_statement = $range_statement ? '(' . $range_statement .  ')' : '';

            $sql = "
			SELECT
				csp.product_id,
				p.code,
				SUM(csp.t_weight) as quantity
			FROM " . DB_PREFIX . "clinicalsale_product csp
			LEFT JOIN " . DB_PREFIX . "clinical_sale cs
			ON csp.clinical_sale_id = cs.clinical_sale_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON csp.product_id = p.product_id
			WHERE $range_statement
			AND cs.store_id = '" . (int)$store_id . "'
			AND cs.clinicalsale_action = '5'
            AND cs.order_invoice_prefix = ''
			GROUP BY csp.product_id";

            $query = $this->db->query($sql);

            return $query->rows;
        } else {
            return false;
        }
    }

    public function getStockIssueProducts($stock_issue_id)
    {
        $sql = "SELECT 
                sii.stock_adjustment_id,
                sii.stock_issue_item_id,
                sii.stock_issue_id,
                sii.product_id,
                sii.quantity, 
                si.invoice_prefix,
                si.description,
                sii.product_id, 
                sii.remark,
                p.code, 
                pd_en.name AS product_name, 
                pd_cn.name AS product_name2,
                GROUP_CONCAT(cd.name separator ', ') AS category,
                sii.batch_date,
                sii.location,
                wcd.unit,
                (CASE WHEN si.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
                CONCAT(c.firstname, ' ', c.lastname) AS fname,
                sii.stock_onhand,
				sii.stock_balance,
                DATE_FORMAT(sii.date_modified, '%d-%m-%Y %H:%i %a') AS 'date_modified',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'
                FROM 
                " . DB_PREFIX . "stock_issue_item sii LEFT JOIN 
                " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id) LEFT JOIN
                " . DB_PREFIX . "product p ON p.product_id = sii.product_id LEFT JOIN 
                " . DB_PREFIX . "product_description pd ON pd.product_id = p.product_id AND pd.language_id = '" . $this->config->get('config_language_id') . "'LEFT JOIN 
                " . DB_PREFIX . "weight_class_description wcd ON(wcd.weight_class_id = sii.weight_class_id AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN
                "  . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = sii.product_id) LEFT JOIN 
                " . DB_PREFIX . "product_description pd_en ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1') LEFT JOIN  
                " . DB_PREFIX . "product_description pd_cn ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2') LEFT JOIN
                " . DB_PREFIX . "customer c ON(c.customer_id = sii.customer_id) LEFT JOIN
                " . DB_PREFIX . "user u2 ON(sii.modify_by = u2.user_id) LEFT JOIN 
                "  . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int) $this->config->get('config_language_id') . "') LEFT JOIN 
                " . DB_PREFIX . "setting sett ON(sett.key = 'config_name' AND sett.store_id = si.store_id) LEFT JOIN 
                " . DB_PREFIX . "store s ON(s.store_id = si.store_id)
                WHERE 
                sii.stock_issue_id = '" . (int)$stock_issue_id . "'
                
                GROUP BY sii.stock_issue_item_id";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getStockIssues($data)
    {

        $filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();

        $filter_location_id = $data['filter_location_id'] != '' ?
		"AND sii.location_id in (" . $data['filter_location_id'] . ")" : '';
		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(sii.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(sii.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND sii.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND sii.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_invoice_prefix = (!empty($data['filter_invoice_prefix']))?
		" AND si.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'" :
		"";
		

		$filter_remark_statement = "";

        foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "si.description LIKE '%" . $filter_remarks . "%'" : " OR si.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";
		
        $filter_status = $data['filter_status'] != '' ?
		"AND si.status in (" . $data['filter_status'] . ")" : '';

        $filter_category = $data['filter_category'] != '' ?
		"AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in (" . $data['filter_category'] . ")" : '';

		$filter_add_by = $data['filter_add_by'] != '' ?
		"AND sii.add_by in (" . $data['filter_add_by'] . ")" : '';

        $filter_customer_id = $data['filter_customer_id'] != '' ?
		"AND c.customer_id in (" . $data['filter_customer_id'] . ")" : '';

        $filter_store_id = $data['filter_store_id'] != '' ?
		"AND si.store_id in (" . $data['filter_store_id'] . ")" : '';

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        
        $sql = "
                SELECT 
                sii.stock_issue_item_id AS stock_issue_item_id,
                sii.product_id AS product_id,
                sii.batch_date AS batch_date,
                sii.stock_onhand AS onhand,
                sii.stock_balance AS balance,
                wcd.unit AS unit,
                sii.date_added  AS date_added,
                sii.date_modified AS date_modified,
                sii.location_id AS location_id,
                sii.quantity AS quantity,
                sii.location AS location,
                sii.add_by AS add_by,
                sii.remark AS remark,
                sii.stock_adjustment_id AS stock_adjustment_id,
                p.model AS product_name,
                p.code AS product_code,
                os.name as status_name,
                CONCAT(u.firstname,'',u.lastname) AS added_by,
                CONCAT(u.firstname,'',u.lastname) AS modified_by,
                si.invoice_prefix AS invoice_prefix,
                si.status AS status,
                si.date_added AS doc_date,
                si.description AS description,
                si.stock_issue_id AS stock_issue_id,
                si.store_id AS store_id,
                cd.name AS category,
                cd.category_id AS category_id,
                c.customer_id AS customer_id,
                CONCAT(c.firstname, ' ', c.lastname) AS fname,
                s.name AS store_name


                FROM " . DB_PREFIX . "stock_issue_item sii
                LEFT JOIN " . DB_PREFIX . "stock_issue si
                ON sii.stock_issue_id = si.stock_issue_id
                LEFT JOIN " . DB_PREFIX . "product p
				ON sii.product_id = p.product_id
				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
				ON sii.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN " . DB_PREFIX . "user u
				ON sii.add_by = u.user_id 
				LEFT JOIN " . DB_PREFIX . "product_to_category ptc
				ON sii.product_id = ptc.product_id
                LEFT JOIN " . DB_PREFIX . "customer c
                ON(c.customer_id = si.customer_id)
				LEFT JOIN " . DB_PREFIX . "category_description cd
				ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "store s
				ON si.store_id = s.store_id
                WHERE 1
                $filter_location_id
				$filter_date_from
				$filter_date_to
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_invoice_prefix
				$filter_remark_statement
				$filter_product_name
				$filter_product_code
                $filter_category
				$filter_add_by
                $filter_customer_id
                $filter_status
				$filter_store_id
				GROUP BY sii.stock_issue_item_id
				ORDER BY  si.date_added DESC , si.stock_issue_id DESC , sii.stock_issue_item_id DESC
				LIMIT $start, $limit 

        ";
            



        $query = $this->db->query($sql);



        return $query->rows;
    }

    public function getStockIssues_backup($data)
    {


        $sort   = isset($data['sort']) ? $data['sort'] : "name";
        $order  = isset($data['order']) ? $data['order'] : "ASC";

        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;

        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

        $filter_product_name = isset($data['filter_product_name']) ? $data['filter_product_name'] : false;
        
        $filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;


        $filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
        $filter_batch_date_from_str = trim($filter_batch_date_from);
        $filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)): false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
        $filter_batch_date_to_str = trim($filter_batch_date_to);
        $filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) : false;
        
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND si.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";

        $filter_add_by_statement = $filter_add_by ? "AND si.add_by in (" . $filter_add_by . ")" : "";

        $filter_date_from_statement = $filter_date_from ? "AND DATE(si.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(si.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_status_statement = $filter_status ? "AND si.status = " . $filter_status . "" : "";

        $filter_product_name_statement = $filter_product_name ? "AND si.product_name LIKE '%" . $filter_product_name . "%'" : "";
        $filter_product_code_statement = $filter_product_code ? "AND si.product_code LIKE '%" . $filter_product_code . "%'" : "";

        $filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(si.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";
        $filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(si.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";


        $filter_store_id_statement = $data['filter_store_id'] != '' ?

            "AND si.store_id = '" . (int)$data['filter_store_id'] . "'" :

            "";
        $filter_location_id_statement = $data['filter_location_id'] != '' ?

            "AND si.location_id = '" . (int)$data['filter_location_id'] . "'" :

            "";

        $sql = "
            SELECT *
            FROM(
                SELECT

                
				" . DB_PREFIX . "stock_issue.stock_issue_id,
                " . DB_PREFIX . "stock_issue_item.date_added,
                " . DB_PREFIX . "stock_issue.invoice_prefix,
                " . DB_PREFIX . "product_description.name as product_name,
                " . DB_PREFIX . "product.code as product_code,
                " . DB_PREFIX . "stock_issue.description,
                " . DB_PREFIX . "stock_issue.store_id,
                " . DB_PREFIX . "order_status.name as status_name,
                " . DB_PREFIX . "stock_issue_item.location,
				" . DB_PREFIX . "stock_issue_item.location_id,
                " . DB_PREFIX . "stock_issue.status,
                " . DB_PREFIX . "stock_issue_item.quantity,
                " . DB_PREFIX . "stock_issue_item.remark,
                " . DB_PREFIX . "stock_issue_item.stock_onhand,
				" . DB_PREFIX . "stock_issue_item.stock_balance,
                " . DB_PREFIX . "stock_issue_item.batch_date,
                " . DB_PREFIX . "stock_issue_item.date_modified,


              

                CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by',
                CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'modified_by'


                FROM

				" . DB_PREFIX . "stock_issue_item
       
                LEFT JOIN " . DB_PREFIX . "stock_issue ON (" . DB_PREFIX . "stock_issue.stock_issue_id = " . DB_PREFIX . "stock_issue_item.stock_issue_id)


				LEFT JOIN " . DB_PREFIX . "order_status
				ON(" . DB_PREFIX . "stock_issue.status = " . DB_PREFIX . "order_status.order_status_id AND " . DB_PREFIX . "order_status.language_id='" . (int) $this->config->get('config_language_id') . "')

                LEFT JOIN " . DB_PREFIX . "product
				ON(" . DB_PREFIX . "stock_issue_item.product_id = " . DB_PREFIX . "product.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description
				ON(" . DB_PREFIX . "stock_issue_item.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')


				LEFT JOIN " . DB_PREFIX . "user
				ON(" . DB_PREFIX . "stock_issue_item.add_by = " . DB_PREFIX . "user.user_id)


            
			WHERE 1

			ORDER BY " . DB_PREFIX . "stock_issue.invoice_prefix ASC
			
		)si

		WHERE 1

		$filter_invoice_prefix_statement

		$filter_add_by_statement

		$filter_status_statement

		$filter_date_from_statement

		$filter_date_to_statement

		$filter_store_id_statement

        $filter_location_id_statement
        
        $filter_product_name_statement

        $filter_product_code_statement
        
        $filter_batch_date_from_statement

        $filter_batch_date_to_statement

        

		ORDER BY si.$sort $order

		LIMIT $start, $limit";



        $query = $this->db->query($sql);



        return $query->rows;
    }

    public function getTotalStockIssues($data)
    {

        $filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();

        $filter_location_id = $data['filter_location_id'] != '' ?
		"AND sii.location_id in (" . $data['filter_location_id'] . ")" : '';
		
		$filter_date_from = (!empty($data['filter_date_from']))?
		" AND DATE(sii.date_added) >= '" . $this->db->escape($data['filter_date_from']) . "'" :
		"";
		

		$filter_date_to = (!empty($data['filter_date_to']))?
		" AND DATE(sii.date_added) <= '" . $this->db->escape($data['filter_date_to']) . "'" : 
		"";
		

		$filter_batch_date_from = (!empty($data['filter_batch_date_from']))?
		" AND sii.batch_date >= '" . $this->db->escape($data['filter_batch_date_from']) . "'" :
		"";
		

		$filter_batch_date_to = (!empty($data['filter_batch_date_to']))?
		" AND sii.batch_date <= '" . $this->db->escape($data['filter_batch_date_to']) . "'" : 
		"";
		

		$filter_invoice_prefix = (!empty($data['filter_invoice_prefix']))?
		" AND si.invoice_prefix LIKE '%" . $this->db->escape($data['filter_invoice_prefix']) . "%'" :
		"";
		

		$filter_remark_statement = "";

        foreach ($filter_remark as $filter_remarks) {
            $filter_remark_statement .= empty($filter_remark_statement) ? "si.description LIKE '%" . $filter_remarks . "%'" : " OR si.description LIKE '%" . $filter_remarks . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";
		

		$filter_product_name = (!empty($data['filter_product_name']))?
		" AND p.model LIKE '%" . $this->db->escape($data['filter_product_name']) . "%'" :
		"";
		

		$filter_product_code = (!empty($data['filter_product_code']))?
		" AND p.code LIKE '%" . $this->db->escape($data['filter_product_code']) . "%'":
		"";
		
        $filter_status = $data['filter_status'] != '' ?
		"AND si.status in (" . $data['filter_status'] . ")" : '';

        $filter_category = $data['filter_category'] != '' ?
		"AND (CASE WHEN cd.category_id is NULL THEN 0 ELSE cd.category_id END) in (" . $data['filter_category'] . ")" : '';

		$filter_add_by = $data['filter_add_by'] != '' ?
		"AND sii.add_by in (" . $data['filter_add_by'] . ")" : '';

        $filter_customer_id = $data['filter_customer_id'] != '' ?
		"AND c.customer_id in (" . $data['filter_customer_id'] . ")" : '';

        $filter_store_id = $data['filter_store_id'] != '' ?
		"AND si.store_id in (" . $data['filter_store_id'] . ")" : '';
		"";

		$start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;
        
        $sql = "
                SELECT COUNT(DISTINCT sii.stock_issue_item_id) AS total


                FROM " . DB_PREFIX . "stock_issue_item sii
                LEFT JOIN " . DB_PREFIX . "stock_issue si
                ON sii.stock_issue_id = si.stock_issue_id
                LEFT JOIN " . DB_PREFIX . "product p
				ON sii.product_id = p.product_id
				LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
				ON sii.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')
				LEFT JOIN " . DB_PREFIX . "user u
				ON sii.add_by = u.user_id 
				LEFT JOIN " . DB_PREFIX . "product_to_category ptc
				ON sii.product_id = ptc.product_id
                LEFT JOIN " . DB_PREFIX . "customer c
                ON(c.customer_id = si.customer_id)
				LEFT JOIN " . DB_PREFIX . "category_description cd
				ON ptc.category_id = cd.category_id AND cd.language_id = '" . (int) $this->config->get('config_language_id') . "'
				LEFT JOIN " . DB_PREFIX . "store s
				ON si.store_id = s.store_id
                WHERE 1
                $filter_location_id
				$filter_date_from
				$filter_date_to
				$filter_batch_date_from
				$filter_batch_date_to
				$filter_invoice_prefix
				$filter_remark_statement
				$filter_product_name
				$filter_product_code
                $filter_category
				$filter_add_by
                $filter_customer_id
                $filter_status
				$filter_store_id
				
        ";
            


        $query = $this->db->query($sql);



        return $query->row['total'];
    }

    public function getTotalStockIssues_backup($data)
    {
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;
        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;
        $filter_product_id = isset($data['filter_product_id']) ? $data['filter_product_id'] : false;
        $filter_product_name = isset($data['filter_product_name']) ? $data['filter_product_name'] : false;
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;
        $filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;


        $filter_batch_date = isset($data['filter_batch_date']) ? $data['filter_batch_date'] : false;
        $filter_batch_date_str = trim($filter_batch_date);
        $filter_batch_date = (!empty($filter_batch_date_str)) ? date("Y-m-d", strtotime($filter_batch_date)) . " 00:00:00" : false;


        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND si.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";

        $filter_add_by_statement = $filter_add_by ? "AND si.add_by LIKE '%" . $filter_add_by . "%'" : "";

        $filter_date_from_statement = $filter_date_from ? "AND DATE(si.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(si.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_status_statement = $filter_status ? "AND si.status = " . $filter_status : "";

        $filter_product_id_statement = $filter_product_id ? "AND si.product_id LIKE '%" . $filter_product_id . "%'" : "";
        $filter_product_name_statement = $filter_product_name ? "AND si.product_name LIKE '%" . $filter_product_name . "%'" : "";
        $filter_product_code_statement = $filter_product_code ? "AND si.product_code LIKE '%" . $filter_product_code . "%'" : "";
        $filter_batch_date_statement = $filter_batch_date ? "AND DATE(si.batch_date) = DATE('" . $filter_batch_date . "')" : "";

        $filter_store_id_statement = $data['filter_store_id'] != '' ?

            "AND si.store_id = '" . (int)$data['filter_store_id'] . "'" :

            "";
        $filter_location_id_statement = $data['filter_location_id'] != '' ?

            "AND si.location_id = '" . (int)$data['filter_location_id'] . "'" :

            "";




        $sql = "
        
        SELECT COUNT(*) AS total 
        
        FROM(

            SELECT 

            " . DB_PREFIX . "stock_issue_item.location,
            " . DB_PREFIX . "stock_issue_item.location_id,
            " . DB_PREFIX . "stock_issue_item.product_id,
            " . DB_PREFIX . "stock_issue_item.date_added,

            " . DB_PREFIX . "product_description.name as product_name,
            " . DB_PREFIX . "product.code as product_code,

            " . DB_PREFIX . "stock_issue.stock_issue_id,
            " . DB_PREFIX . "stock_issue.invoice_prefix,
            " . DB_PREFIX . "stock_issue.status,
            " . DB_PREFIX . "stock_issue.description,
            " . DB_PREFIX . "stock_issue.store_id,
            " . DB_PREFIX . "stock_issue_item.batch_date,
            " . DB_PREFIX . "stock_issue.date_modified,



            CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by'


			FROM

            " . DB_PREFIX . "stock_issue_item 
            LEFT JOIN " . DB_PREFIX . "stock_issue
            ON (" . DB_PREFIX . "stock_issue.stock_issue_id=" . DB_PREFIX . "stock_issue_item.stock_issue_id)

            LEFT JOIN " . DB_PREFIX . "product
            ON(" . DB_PREFIX . "stock_issue_item.product_id = " . DB_PREFIX . "product.product_id )

            LEFT JOIN " . DB_PREFIX . "product_description
            ON(" . DB_PREFIX . "stock_issue_item.product_id = " . DB_PREFIX . "product_description.product_id AND " . DB_PREFIX . "product_description.language_id='" . (int) $this->config->get('config_language_id') . "')


            LEFT JOIN " . DB_PREFIX . "user
            ON(" . DB_PREFIX . "stock_issue_item.add_by = " . DB_PREFIX . "user.user_id)


        UNION

        SELECT

            'None' as location,
            " . DB_PREFIX . "stock_issue.date_added,
            '0' as product_id,
            '0' as location_id,
            'None' as batch_date,
            'None' as product_name,
            'None' as product_code,

            " . DB_PREFIX . "stock_issue.stock_issue_id,
            " . DB_PREFIX . "stock_issue.invoice_prefix,
            " . DB_PREFIX . "stock_issue.status,
            " . DB_PREFIX . "stock_issue.description,
            " . DB_PREFIX . "stock_issue.store_id,
            " . DB_PREFIX . "stock_issue.date_modified,

            CONCAT(" . DB_PREFIX . "user.firstname , ' ', " . DB_PREFIX . "user.lastname) AS 'add_by'


        FROM

            " . DB_PREFIX . "stock_issue

            LEFT JOIN " . DB_PREFIX . "user
            ON(" . DB_PREFIX . "stock_issue.add_by = " . DB_PREFIX . "user.user_id)

        WHERE 

        " . DB_PREFIX . "stock_issue.stock_issue_id NOT IN (SELECT DISTINCT(stock_issue_id) FROM " . DB_PREFIX . "stock_issue_item)

        )si

        WHERE 1

        $filter_invoice_prefix_statement

        $filter_add_by_statement

        $filter_date_from_statement

        $filter_date_to_statement

        $filter_store_id_statement
        
        $filter_location_id_statement
        
        $filter_product_id_statement

        $filter_product_name_statement

        $filter_product_code_statement
        $filter_batch_date_statement
        ";

        $query = $this->db->query($sql);



        return $query->row['total'];
    }

    public function getStockIssueItemAll() 
    {
        $sql = "
        
        SELECT
                
                sii.product_id,
				si.stock_issue_id,
                sii.date_added,
                si.invoice_prefix,
                pd_en.name as product_name,
                p.code as product_code,
                pd_cn.name as product_name2,
                si.description,
                si.store_id,
                (CASE WHEN si.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
                os.name as status_name,
                sii.location,
				sii.location_id,
                si.status,
                sii.quantity,
                sii.remark,
                sii.stock_onhand,
				sii.stock_balance,
                sii.batch_date,
                sii.date_modified,
                sii.add_by as add_by_id,
                cd.category_id,
				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
                c.customer_id,
                CONCAT(c.firstname, ' ', c.lastname) AS fname,
                wcd.unit,
                sii.stock_adjustment_id,
                
                CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

                CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'


                FROM

                " . DB_PREFIX . "stock_issue_item sii
       
                LEFT JOIN " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id)


				LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

                LEFT JOIN " . DB_PREFIX . "product p
				ON(sii.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(sii.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2')


				LEFT JOIN " . DB_PREFIX . "user u1
				ON(sii.add_by = u1.user_id)

                LEFT JOIN " . DB_PREFIX . "user u2
				ON(sii.modify_by = u2.user_id)

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = sii.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

                LEFT JOIN " . DB_PREFIX . "customer c
                ON(c.customer_id = si.customer_id)

                LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = si.store_id)

                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = sii.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = si.store_id)
            
                
			 GROUP BY sii.stock_issue_item_id";

            $query = $this->db->query($sql);



        return $query->rows;
    }

    public function getStockIssueItemSearched($data) 
    {
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? explode(',', $data['filter_invoice_prefix']) : array();

        $filter_remark = isset($data['filter_remark']) ? explode(',', $data['filter_remark']) : array();

        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

        $filter_product_name = isset($data['filter_product_name']) ? explode(',', $data['filter_product_name']) : array();

        
        $filter_product_code = isset($data['filter_product_code']) ? explode(',', $data['filter_product_code']) : array();

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;


        $filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
        $filter_batch_date_from_str = trim($filter_batch_date_from);
        $filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)): false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
        $filter_batch_date_to_str = trim($filter_batch_date_to);
        $filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) : false;
        
        $filter_customer_id = isset($data['filter_customer_id']) ? $data['filter_customer_id'] : false;
        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_category = isset($data['filter_category']) ? $data['filter_category'] : false;
        $filter_store_id = isset($data['filter_store_id']) ? $data['filter_store_id'] : false;
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        //prepare where clause statement
        $filter_remark_statement = "";

        foreach ($filter_remark as $remark) {
            $filter_remark_statement .= empty($filter_remark_statement)? "a.description LIKE '%" .$remark . "%'" : " OR a.description LIKE '%" .$remark . "%'";
        }

        $filter_remark_statement = !empty($filter_remark_statement) ? "AND ($filter_remark_statement)" : "";

        $filter_invoice_prefix_statement = "";

        foreach ($filter_invoice_prefix as $invoice_prefix) {
            $filter_invoice_prefix_statement .= empty($filter_invoice_prefix_statement)? "a.invoice_prefix LIKE '%" .$invoice_prefix . "%'" : " OR a.invoice_prefix LIKE '%" .$invoice_prefix . "%'";
        }

        $filter_invoice_prefix_statement = !empty($filter_invoice_prefix_statement) ? "AND ($filter_invoice_prefix_statement)" : "";

        $filter_add_by_statement = $filter_add_by ? "AND a.add_by_id in (" . $filter_add_by . ")" : "";

        //todo bi-language
        $filter_product_name_statement = "";

        foreach ($filter_product_name as $product_name) {
            $filter_product_name_statement.= empty($filter_product_name_statement)?" a.en_cn_product_name LIKE '%" . $product_name . "%'":" OR a.en_cn_product_name LIKE '%" . $product_name . "%'";

        }
        $filter_product_name_statement = !empty($filter_product_name_statement)?" AND ($filter_product_name_statement)":"";

        $filter_product_code_statement = "";

        foreach ($filter_product_code as $product_code) {
            $filter_product_code_statement .= empty($filter_product_code_statement)?"a.product_code LIKE '%" . $product_code . "%'":" OR a.product_code LIKE '%" . $product_code . "%'";
        }
        $filter_product_code_statement = !empty($filter_product_code_statement)?" AND ($filter_product_code_statement)":"";

        $filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

        $filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";

        $filter_status_statement = $filter_status!==false ? "AND a.status in (" . $filter_status . ")" : "";
        
        $filter_customer_id_statement = $filter_customer_id!==false ? "AND a.customer_id in (" . $filter_customer_id . ")" : "";

        $filter_category_statement = $filter_category!==false ? "AND a.category_id in (" . $filter_category . ")" : "";
        
        $filter_store_id_statement = $filter_store_id!==false ? "AND a.store_id in (" . $filter_store_id . ")" : "";
        
        $filter_location_id_statement = $filter_location_id!==false ? "AND a.location_id in (" . $filter_location_id . ")" : "";
        
        // $filter_status_statement = $filter_status ? "AND a.status = " . $filter_status : "";
        
        $sql = "
            SELECT *
            FROM(
        
        SELECT
                
                sii.product_id,
				si.stock_issue_id,
                sii.date_added,
                si.invoice_prefix,
                pd_en.name as product_name,
                p.code as product_code,
                pd_cn.name as product_name2,
                si.description,
                si.store_id,
                (CASE WHEN si.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
                os.name as status_name,
                sii.location,
				sii.location_id,
                si.status,
                sii.quantity,
                sii.remark,
                sii.stock_onhand,
				sii.stock_balance,
                sii.batch_date,
                sii.date_modified,
                sii.add_by as add_by_id,
                cd.category_id,
				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
                c.customer_id,
                CONCAT(c.firstname, ' ', c.lastname) AS fname,
                wcd.unit,
                sii.stock_adjustment_id,
                
                CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

                CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'


                FROM

                " . DB_PREFIX . "stock_issue_item sii
       
                LEFT JOIN " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id)


				LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

                LEFT JOIN " . DB_PREFIX . "product p
				ON(sii.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(sii.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2')


				LEFT JOIN " . DB_PREFIX . "user u1
				ON(sii.add_by = u1.user_id)

                LEFT JOIN " . DB_PREFIX . "user u2
				ON(sii.modify_by = u2.user_id)

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = sii.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

                LEFT JOIN " . DB_PREFIX . "customer c
                ON(c.customer_id = si.customer_id)

                LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = si.store_id)

                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = sii.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = si.store_id)
            
                
			 GROUP BY sii.stock_issue_item_id
             
             )a

		WHERE 1

		$filter_invoice_prefix_statement

		$filter_add_by_statement

        $filter_product_name_statement
        
        $filter_product_code_statement
		
        $filter_date_from_statement

		$filter_date_to_statement

        $filter_batch_date_from_statement
        
        $filter_batch_date_to_statement

        $filter_category_statement

        $filter_status_statement

        $filter_customer_id_statement
        
		$filter_store_id_statement
        
        $filter_location_id_statement

        $filter_remark_statement";

            $query = $this->db->query($sql);



        return $query->rows;
    }

    public function getStockIssueItemSelected($issue_id)
    {
        $sql = "
        
        SELECT
                
                sii.product_id,
				si.stock_issue_id,
                sii.date_added,
                si.invoice_prefix,
                pd_en.name as product_name,
                p.code as product_code,
                pd_cn.name as product_name2,
                si.description,
                si.store_id,
                (CASE WHEN si.store_id = 0 THEN CONCAT(sett.value, ' (Default)') ELSE  s.name END) AS sname,
                os.name as status_name,
                sii.location,
				sii.location_id,
                si.status,
                sii.quantity,
                sii.remark,
                sii.stock_onhand,
				sii.stock_balance,
                sii.batch_date,
                sii.date_modified,
                sii.add_by as add_by_id,
                cd.category_id,
				GROUP_CONCAT(DISTINCT cd.name separator ', ')AS category,
                c.customer_id,
                CONCAT(c.firstname, ' ', c.lastname) AS fname,
                wcd.unit,
                sii.stock_adjustment_id,
                
                CONCAT(pd_en.name, ' ', pd_cn.name) AS 'en_cn_product_name',

                CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'


                FROM

                " . DB_PREFIX . "stock_issue_item sii
       
                LEFT JOIN " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id)


				LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

                LEFT JOIN " . DB_PREFIX . "product p
				ON(sii.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(sii.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2')


				LEFT JOIN " . DB_PREFIX . "user u1
				ON(sii.add_by = u1.user_id)

                LEFT JOIN " . DB_PREFIX . "user u2
				ON(sii.modify_by = u2.user_id)

                LEFT JOIN "  . DB_PREFIX . "product_to_category ptc
				ON(ptc.product_id = sii.product_id)

				LEFT JOIN "  . DB_PREFIX . "category_description cd
				ON(cd.category_id = ptc.category_id
				AND cd.language_id='" . (int) $this->config->get('config_language_id') . "'
				)

                LEFT JOIN " . DB_PREFIX . "customer c
                ON(c.customer_id = si.customer_id)

                LEFT JOIN " . DB_PREFIX . "store s
                ON(s.store_id = si.store_id)

                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON(wcd.weight_class_id = sii.weight_class_id
                AND wcd.language_id='" . (int) $this->config->get('config_language_id') . "'
                )

                LEFT JOIN " . DB_PREFIX . "setting sett
                ON(sett.key = 'config_name' AND sett.store_id = si.store_id)
            
                
                WHERE sii.stock_issue_id = '" . (int)$issue_id . "'";

            $query = $this->db->query($sql);



        return $query->rows;
    }

    public function addStockIssue($data)
    {
        $submit = isset($this->request->post['submit']) ? true : false;
        $draft = isset($this->request->post['draft']) ? true : false;
        // $save_header = isset($this->request->post['add_product']) ? true : false;


        if ($submit) {
            $status = '5';
        }
        if ($draft) {
            $status = '1';
        }

        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];
        $customer_id = $this->db->escape($data['customer_id']) ? $this->db->escape($data['customer_id']) : '';
        $user_id = $this->session->data['user_id'];
        $stock_issue_item = isset($data['stock_issue_item']) ? $data['stock_issue_item'] : array();


        $sql = "INSERT INTO " . DB_PREFIX . "stock_issue
                SET invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
		            store_id = " . (int)$store_id . ",
                    customer_id = '". (int)$customer_id ."',
                    status = '".(int)$status."',
		            description = '" . $this->db->escape($data['description'])  . "',
		            add_by = " . (int)$user_id . ",
                    modify_by = " . (int)$user_id . ",
                    date_added = '".$this->db->escape($data['input-current-date'])."',
                    date_modified = NOW()";

        $query = $this->db->query($sql);

        $stock_issue_id =  $this->db->getLastId();

        if ($stock_issue_id > 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

            foreach ($stock_issue_item as $row_id => $item) {
                $product_id = (int)$item['product_id'];
                $quantity = (float)$item['quantity'];
                $weight_class = (int)$item['weight_class_id'];
                $batch_date = !empty($this->db->escape($item['stock_issue_batch_date'])) ? $this->db->escape($item['stock_issue_batch_date']) : null;
                $remark = $this->db->escape($item['remark']);
                $location = $this->db->escape($this->getLocationText($item['location_id']));
                $location_id = (int)$item['location_id'];
                $stock_onhand = (float)$this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
                $stock_balance = (float)$stock_onhand - (float)$quantity;



                if (!empty($batch_date)) {
                    $batch_date = $this->db->escape($batch_date);
                } else {
                    $batch_date = '0000-00-00';
                }



                $product_location = !empty($data['location_id']) ? $data['location_id'] : 0;
                $product_location_text = !empty($data['location']) ? $data['location'] : '';

                $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                             SET stock_issue_id = " . (int)$stock_issue_id . ",
				                 product_id = " . (int)$product_id . ",
                                 customer_id = '". (int)$customer_id ."',
				                 quantity = " . (float)$quantity . ",
                                 weight_class_id = " . (int)$weight_class . ",
                                 batch_date = '" . $this->db->escape($batch_date)  . "',
                                 location_id = '" . (int)$item['location_id'] . "',
                                 location = '" . $this->db->escape($location) . "',
                                 remark = '" . $this->db->escape($remark) . "',
                                 stock_onhand = '" . (float)$stock_onhand . "',
				                 stock_balance = '" . (float)$stock_balance . "',
				                 add_by = " . (int)$user_id . ",
                                 modify_by = " . (int)$user_id . ",
				                 date_added = '".$this->db->escape($data['input-current-date'])."',
                                 date_modified = NOW()";

                $item_query = $this->db->query($item_sql);


                if ($submit) {
                    $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                     SET onhand_quantity = onhand_quantity - $quantity
				                     WHERE product_id = '".(int)$product_id."'
				                     AND store_id = '".(int)$store_id."'
                                     AND location_id = '".(int)$location_id."'
					                 AND batch_date = '".$this->db->escape($batch_date)."'";

                    $deduct_stock_query = $this->db->query($deduct_stock_sql);
                }
            }
        }
    }

    public function editStockIssue($stock_issue_id, $data)
    {
        $submit = isset($this->request->post['submit']) ? true : false;
        $draft = isset($this->request->post['draft']) ? true : false;


        if ($submit) {
            $status = '5';
        }
        if ($draft) {
            $status = '1';
        }

        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

        $store_id = $this->session->data['store_id'];
        $customer_id = $this->db->escape($data['customer_id']);
        $user_id = $this->session->data['user_id'];
        $stock_issue_item = isset($data['stock_issue_item']) ? $data['stock_issue_item'] : array();


        $sql = "
        UPDATE " . DB_PREFIX . "stock_issue
                SET status = '".(int)$status."',
		            description = '" . $this->db->escape($data['description'])  . "',
                    modify_by = " . (int)$user_id . ",
                    customer_id = '" . $this->db->escape($data['customer_id'])  . "',
                    date_added = '".$this->db->escape($data['input-current-date'])."',
                    date_modified = NOW()
                    WHERE stock_issue_id = '" . (int)$stock_issue_id . "'
                    ";


        $query = $this->db->query($sql);

		$old_user_id = $this->db->query("SELECT add_by FROM " . DB_PREFIX . "stock_issue WHERE stock_issue_id = '" . (int)$stock_issue_id . "'")->row['add_by'];

        $sql_delete = "DELETE FROM " . DB_PREFIX . "stock_issue_item WHERE stock_issue_id='" . (int)$stock_issue_id . "'";
        $this->db->query($sql_delete);



        // $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

        foreach ($stock_issue_item as $row_id => $item) {
            $product_id = (int)$item['product_id'];
            $quantity = (float)$item['quantity'];
            $weight_class = (int)$item['weight_class_id'];
            $batch_date = !empty($item['stock_issue_batch_date']) ? $item['stock_issue_batch_date'] : NULL;
            $remark = $this->db->escape($item['remark']);
            $location = $this->getLocationText($item['location_id']);
            $location_id = (int)$item['location_id'];
            $stock_onhand = $this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
            $stock_balance = (float)$stock_onhand - (float)$quantity;



            if (!empty($batch_date)) {
                $batch_date = $this->db->escape($batch_date);
            } else {
                $batch_date = '0000-00-00';
            }



            $product_location = !empty($data['location_id']) ? $data['location_id'] : 0;
            $product_location_text = !empty($data['location']) ? $data['location'] : '';

            $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                             SET stock_issue_id = " . (int)$stock_issue_id . ",
				                 product_id = " . (int)$product_id . ",
                                 customer_id = '". (int)$customer_id ."',
				                 quantity = " . (float)$quantity . ",
                                 weight_class_id = " . (int)$weight_class . ",
                                 batch_date = '" . $this->db->escape($batch_date)  . "',
                                 location_id = '" . (int)$item['location_id'] . "',
                                 location = '" . $this->db->escape($location) . "',
                                 remark = '" . $this->db->escape($remark) . "',
                                 stock_onhand = '" . (float)$stock_onhand . "',
				                 stock_balance = '" . (float)$stock_balance . "',
				                 add_by = " . (int)$old_user_id . ",
                                 modify_by = " . (int)$user_id . ",
				                 date_added = '".$this->db->escape($data['input-current-date'])."',
                                 date_modified = NOW()";

            $item_query = $this->db->query($item_sql);


            if ($submit) {
                $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                     SET onhand_quantity = onhand_quantity - $quantity
				                     WHERE product_id = '".(int)$product_id."'
				                     AND store_id = '".(int)$store_id."'
                                     AND location_id = '".(int)$location_id."'
					                 AND batch_date = '".$this->db->escape($batch_date)."'";

                $deduct_stock_query = $this->db->query($deduct_stock_sql);
            }
        }
    }
    //     $this->db->query("UPDATE " . DB_PREFIX . "stock_issue SET
    // 						description = '" . $this->db->escape($data['description']) . "'
    // 						WHERE stock_issue_id = '" . (int)$stock_issue_id . "'");
    // }

    public function deductItem($stock_issue_item_id, $remark)
	{


		$sql = "SELECT * FROM " . DB_PREFIX . "stock_issue_item WHERE stock_issue_item_id ='$stock_issue_item_id'";
		$query = $this->db->query($sql);
		$item = $query->row;


		$data2 = array();
		$data2['description'] = $remark;
		//action=1 (plus) 0 (minus)
		$product_id = $item['product_id'];
		$action = 1;

		$product_id = $item['product_id'];
		$wcid = $item['weight_class_id'];
		$location_id = $item['location_id'];
		$batch_date = !empty($item['batch_date']) ? $item['batch_date'] : '0000-00-00';

		//adjust quantity
		$qty = $item['quantity'];
		$converted_qty = $this->weight->convert($qty, $wcid, $this->getweightClassProduct($product_id));
		$data2['stock_adjustment_item'][] = array(
			'product_id' => (int)$product_id,
			'action' => (int)$action,
			'qty' => (float)$converted_qty,
			'unit' => (int)$wcid,
			'remark' => 'stock issue cancel item',
			'batch_date' => $this->db->escape($batch_date),
			'location' => (int)$location_id,
		);
		$this->load->model('catalog/stock_adjustment');
		$stock_adj_id = $this->model_catalog_stock_adjustment->addStockAdjustment($data2);
		$this->db->query("UPDATE " . DB_PREFIX . "stock_issue_item SET
						remark = '" . $this->db->escape($remark) . "',
						stock_adjustment_id = '" . (int)$stock_adj_id . "'
						WHERE stock_issue_item_id = '" . (int)$stock_issue_item_id . "'");
	}

    public function getweightClassProduct($product_id)
	{
		$sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
		$query = $this->db->query($sql);

		$weight_class_id = isset($query->row['weight_class_id']) ? $query->row['weight_class_id'] : 2;
		return $weight_class_id;
	}

    public function getLocationText($location_id)
    {

        if ($location_id == 0) {
            return "Default Location";
        } else {
            $query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
            $loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
            return $loc_text;
        }
    }

    public function getBatchDateList($product_id, $location_id, $available = true)
    {
        $batchDateList = array();
        $sql = "SELECT DISTINCT(batch_date) FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$this->session->data['store_id'] . "'
		AND location_id = '" . (int)$location_id . "'";
        // if ($available) {
        //     $sql .= " AND onhand_quantity > 0 ";
        // }
        $sql .= "ORDER BY FIELD('0000-00-00', batch_date) DESC, batch_date DESC";
        $query = $this->db->query($sql);
        $list = $query->rows;
        if (!empty($list)) {
            foreach ($list as $date) {
                $batchDateList[] = $date['batch_date'];
            }
        }
        return $batchDateList;
    }

    public function getLocationList($product_id, $available = true)
    {
        $def_location = array();
        $sql = "SELECT DISTINCT(pts.location_id), CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) AS location_text FROM " . DB_PREFIX . "product_to_store pts 
		LEFT JOIN " . DB_PREFIX . "wms_location wms on (pts.location_id = wms.location_id) 
		WHERE pts.store_id = '" . (int)$this->session->data['store_id'] . "' 
		AND pts.product_id='" . (int)$product_id . "'";
        // if ($available) {
        //     $sql .= " AND pts.onhand_quantity > 0 ";
        // }
        $sql .= "ORDER BY location_text asc";

        $query = $this->db->query($sql);
        $location = $query->rows;
        if (!empty($location)) {
            foreach ($location as $loc) {
                if ($loc['location_id'] == 0) {
                    $def_location[$loc['location_id']] = 'Default Location';
                } else {
                    $def_location[$loc['location_id']] = $loc['location_text'];
                }
            }
        }
        return $def_location;
    }

    public function getStockOnhand($product_id, $location_id, $batch_date, $store_id)
    {

          
        $sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$store_id . "'
		AND location_id = '" . (int)$location_id . "'
		AND batch_date='$batch_date'";
        
        $query = $this->db->query($sql);
        $qty = !empty($query->row['onhand_quantity']) ? $query->row['onhand_quantity'] : 0;
        return $qty;
    }

    public function getWeightClasses($product_id)
    {
        $sql = "SELECT wc.weight_class_id,wcd.unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }
    public function getLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location WHERE store_id = '" . (int)$this->session->data['store_id'] . "' ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    //get all location if user can view other store data
    public function getAllLocations()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "wms_location ORDER BY warehouse,zone,lot");

        return $query->rows;
    }

    public function editStockIssueDetail($stock_issue_id, $data)
    {
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));
        if (!empty($data['invoice_prefix']) && $invoice_prefix == $data['invoice_prefix']) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));
        }

        $store_id = (int)$this->session->data['store_id'];
        $user_id = (int)$this->session->data['user_id'];


        if (!empty($stock_issue_id)) {
            $sql = "
                UPDATE " . DB_PREFIX . "stock_issue
                    SET
                        description = '" . $this->db->escape($data['description'])  . "',
                        modify_by = " . $user_id . ",
                        date_modified = NOW()
                        WHERE stock_issue_id = '" . (int)$stock_issue_id . "'
                
            ";
            $this->db->query($sql);
        }
    }

    public function getStaffs()
    {
        $query = $this->db->query("SELECT DISTINCT(si.add_by), CONCAT(u.firstname,' ',u.lastname) AS staff_name FROM " . DB_PREFIX . "stock_issue_item si
		LEFT JOIN " . DB_PREFIX . "user u on (si.add_by = u.user_id)
		ORDER BY staff_name asc");

        return $query->rows;
    }

    public function getStatus() {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND order_status_id IN (SELECT DISTINCT (status) from ". DB_PREFIX . "stock_adjustment) ORDER BY order_status_id asc");

		return $query->rows;
	}

    public function getCustomers() {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "customer WHERE customer_id IN (SELECT DISTINCT (customer_id) from ". DB_PREFIX . "stock_issue) ORDER BY firstname asc");

		return $query->rows;
	}

    public function getCategories() {
		$query = $this->db->query("SELECT  * FROM " . DB_PREFIX . "category_description WHERE language_id='" . (int) $this->config->get('config_language_id') . "' AND category_id ORDER BY category_id asc");

		return $query->rows;
	}
    public function getTotalCustomers($data = array())
    {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "customer WHERE customer_group_id = '1' AND status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getCustomerslist($data = array())
    {
        $sql = "SELECT customer_id,
					   CONCAT(firstname, ' ', lastname) AS customer_name,
					   customer_ic,
					   customer_card
				FROM " . DB_PREFIX . "customer
				WHERE status = '1'";

        if (!empty($data['customer_name'])) {
            $sql .= " AND CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        if (!empty($data['customer_ic'])) {
            $sql .= " AND customer_ic LIKE '%" . $this->db->escape($data['customer_ic']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }
}
