<?php
class ModelCatalogProductionPackaging extends Model {
    public function getProductionPackaging($packaging_id) {
        $return_results = [];

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "packaging WHERE packaging_id = '" . (int)$packaging_id . "'");

        $return_results = $query->row;

        $packaging_material_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "packaging_material WHERE packaging_id = '" . (int)$packaging_id . "'");

        $return_results['materials'] = $packaging_material_query->rows;
    
        return $return_results;
    }

    public function getPackagingMaterial($packaging_material_id) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "packaging_material WHERE packaging_material_id = '" . (int)$packaging_material_id . "'");

        return $query->row;
    }

    public function getProductionPackagings($data) {
        $sql = "SELECT * FROM " . DB_PREFIX . "packaging WHERE 1";

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_description'])) {
            $sql .= " AND description LIKE '%" . $this->db->escape($data['filter_description']) . "%'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND status = '" . (int)$data['filter_status'] . "'";
		}
        
        $sort_data = array(
            'packaging_id',
            'description',
            'status',
			'date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
        }
        
        if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalProductionPackagings($data) {
        $sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "packaging WHERE 1";

        if (!empty($data['filter_date_added_from'])) {
            $sql .= " AND DATE(date_added) >= DATE('" . $this->db->escape($data['filter_date_added_from']) . "')";
        }

        if (!empty($data['filter_date_added_to'])) {
            $sql .= " AND DATE(date_added) <= DATE('" . $this->db->escape($data['filter_date_added_to']) . "')";
        }

        if (!empty($data['filter_description'])) {
            $sql .= " AND description LIKE '%" . $this->db->escape($data['filter_description']) . "%'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
			$sql .= " AND status = '" . (int)$data['filter_status'] . "'";
        }
        
        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function addProductionPackaging($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "packaging SET description = '" . $this->db->escape($data['description']) . "', status = '" . (int)$data['status'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        $packaging_id = $this->db->getLastId();

        if ($packaging_id > 0) {
            if (isset($data['materials'])) {
                foreach ($data['materials'] as $material) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "packaging_material SET packaging_id = '" . (int)$packaging_id . "', production_id = '" . (int)$material['production_id'] . "', serial_num = '" . $this->db->escape($material['serial_num']) . "', quantity = '" . (int)$material['quantity'] . "'");
                }
            }
        }

        return $packaging_id;
    }

    public function editProductionPackaging($data, $packaging_id) {
        $sql = "UPDATE " . DB_PREFIX . "packaging SET description = '" . $this->db->escape($data['description']) . "', status = '" . (int)$data['status'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE packaging_id = '" . (int)$packaging_id . "'";

        $query = $this->db->query($sql);

        $this->db->query("DELETE FROM " . DB_PREFIX . "packaging_material WHERE packaging_id = '" . (int)$packaging_id . "'");

        if (isset($data['materials'])) {
            foreach ($data['materials'] as $material) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "packaging_material SET packaging_id = '" . (int)$packaging_id . "', production_id = '" . (int)$material['production_id'] . "', serial_num = '" . $this->db->escape($material['serial_num']) . "', quantity = '" . (int)$material['quantity'] . "'");
            }
        }
    }

    public function deleteProductionPackaging($packaging_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "packaging WHERE packaging_id = '" . (int)$packaging_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "packaging_material WHERE packaging_id = '" . (int)$packaging_id . "'");
    }
}
?>