<?php
class ModelCatalogProductionMachine extends Model {
    public function getProductionMachine($production_machine_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_machine WHERE production_machine_id = '" . (int)$production_machine_id . "'";
        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getProductionMachineMaintenances($production_machine_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "production_machine_maintenance WHERE production_machine_id = '" . (int)$production_machine_id . "' ORDER BY maintenance_date DESC";
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getProductionMachines($data) {
        $sql = "SELECT pm.*, a.last_maintenance_date FROM " . DB_PREFIX . "production_machine pm LEFT JOIN (SELECT MAX(maintenance_date) AS last_maintenance_date, production_machine_id FROM " . DB_PREFIX . "production_machine_maintenance GROUP BY production_machine_id)a ON a.production_machine_id = pm.production_machine_id WHERE 1";
    
        if (!empty($data['filter_start_last_maintenance_date'])) {
            $sql .= " AND DATE(a.last_maintenance_date) >= DATE('" . $this->db->escape($data['filter_start_last_maintenance_date']) . "')";
        }

        if (!empty($data['filter_end_last_maintenance_date'])) {
            $sql .= " AND DATE(a.last_maintenance_date) <= DATE('" . $this->db->escape($data['filter_end_last_maintenance_date']) . "')";
        }
                  
        if (!empty($data['filter_machine_name'])) {
            $sql .= " AND pm.machine_name LIKE '%" . $this->db->escape($data['filter_machine_name']) . "%'";
        }

        if (!empty($data['filter_machine_serial_num'])) {
            $sql .= " AND pm.machine_serial_num LIKE '%" . $this->db->escape($data['filter_machine_serial_num']) . "%'";
        }

        if ($data['filter_status'] != '') {
            $sql .= " AND pm.status = '" . (int)$data['filter_status'] . "'";
        }

        $sort_data = array(
            'production_machine_id',
            'machine_name',
            'machine_serial_num',
            'status',
            'last_maintenance_date',
			'date_added'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY date_added";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function addProductionMachine($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "production_machine SET machine_name = '" . $this->db->escape($data['machine_name']) . "', machine_serial_num = '" . $this->db->escape($data['machine_serial_num']) . "', status = '" . (int)$data['status'] . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function editProductionMachine($data, $production_machine_id) {
        $sql = "UPDATE " . DB_PREFIX . "production_machine SET machine_name = '" . $this->db->escape($data['machine_name']) . "', machine_serial_num = '" . $this->db->escape($data['machine_serial_num']) . "', status = '" . (int)$data['status'] . "', date_modified = NOW(), modify_by = '" . (int)$this->session->data['user_id'] . "' WHERE production_machine_id = '" . (int)$production_machine_id . "'";

        $query = $this->db->query($sql);
    }

    public function deleteProductionMachine($production_machine_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "production_machine WHERE production_machine_id = '" . (int)$production_machine_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "production_machine_maintenance WHERE production_machine_id = '" . (int)$production_machine_id . "'");
    }

    public function addProductionMachineMaintenance($data) {
        $sql = "INSERT INTO " . DB_PREFIX . "production_machine_maintenance SET production_machine_id = '" . (int)$data['production_machine_id'] . "', maintenance_date = '" . $this->db->escape($data['maintenance_date']) . "', remark = '" . $this->db->escape($data['remark']) . "', date_added = NOW(), add_by = '" . (int)$this->session->data['user_id'] . "'";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }
}
?>