<?php
class ModelCatalogPrescription extends Model {
	public function getPrescriptionList($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
		$filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
		$filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
		$filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

		$start 	= isset($data['start']) ? $data['start'] : 0;
		$limit 	= isset($data['limit']) ? $data['limit'] : 20;

		$filter_name_statement = $filter_name ? "AND " . DB_PREFIX . "prescription_name.name LIKE '%" . $filter_name . "%'" : "";
		$filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "prescription.code LIKE '%" . $filter_code . "%'" : "";
		$filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "prescription.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
		$filter_status_statement = $filter_status !== false && $filter_status != '' ? "AND " . DB_PREFIX . "prescription.status =" . $filter_status : "";

		$sql = "
		SELECT *
		FROM
			" . DB_PREFIX . "prescription,
			" . DB_PREFIX . "prescription_name
		WHERE " . DB_PREFIX . "prescription.prescription_id = " . DB_PREFIX . "prescription_name.prescription_id
		AND " . DB_PREFIX . "prescription_name.language_id = " . (int)$this->config->get('config_language_id') . "
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
		$filter_name_statement
		$filter_status_statement
		ORDER BY $sort $order
		LIMIT $start, $limit";

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getPrescriptionColumn($prescription_id, $column_name, $multirow = false, $language_id = NULL){
		$language_id = $language_id ? $language_id : (int)$this->config->get('config_language_id');

		$sql = "
		SELECT a." . $column_name . "
		FROM
		(
			SELECT
				" . DB_PREFIX . "prescription.prescription_id,
				" . DB_PREFIX . "prescription.code,
				" . DB_PREFIX . "prescription.pinyin,
				" . DB_PREFIX . "prescription.status,
				" . DB_PREFIX . "prescription.sort_order,
				" . DB_PREFIX . "prescription_name.name
			FROM
				" . DB_PREFIX . "prescription,
				" . DB_PREFIX . "prescription_name
			WHERE " . DB_PREFIX . "prescription.prescription_id = " . DB_PREFIX . "prescription_name.prescription_id
			AND " . DB_PREFIX . "prescription_name.language_id = " . $language_id . "
			AND " . DB_PREFIX . "prescription.prescription_id = $prescription_id
		)a";
		$query = $this->db->query($sql);
		return $multirow ? $query->rows[$column_name] : $query->row[$column_name];
	}

	public function getPerscriptionItems($prescription_id){
		$language_id = $this->config->get('config_language_id');

		$items = array();

		$sql = "
		SELECT
			pi.product_id,
			pd.name,
			p.code,
			pi.used_qty,
			pi.display_order,
			pi.remark
		FROM " . DB_PREFIX . "prescription_item pi
		LEFT JOIN " . DB_PREFIX . "product p
		ON pi.product_id = p.product_id
		LEFT JOIN " . DB_PREFIX . "product_description pd
		ON p.product_id = pd.product_id
		WHERE 1
		AND pi.prescription_id = " . (int)$prescription_id . "
		AND pd.language_id = " . (int)$language_id . "
		ORDER BY pi.display_order";
		$query = $this->db->query($sql);
		$item_result = $query->rows;

		foreach($item_result as $item){
			$items[] = array(
				'product_id' => $item['product_id'],
				'name'	=> $item['name'],
				'code' => $item['code'],
				'used_qty' => $item['used_qty'],
				'display_order' => $item['display_order'],
				'remark' => $item['remark']
			);
		}

		return $items;
	}

	public function getPerscriptionItemsJson($prescription_id){

		$query = $this->db->query("SELECT *,pi.display_order FROM " . DB_PREFIX . "prescription_item pi LEFT JOIN " . DB_PREFIX . "product_description pd ON (pi.product_id = pd.product_id) LEFT JOIN " . DB_PREFIX . "product p ON (pi.product_id = p.product_id) WHERE pi.prescription_id = '". $prescription_id."' AND pd.language_id = '" . (int)$this->config->get('config_language_id'). "' ORDER BY pi.display_order ASC" );
		return $query->rows;
	}

	public function addPrescription($data){
		$names = $data['prescription_name'];
		$code = $data['code'];
		$pinyin = $data['pinyin'];
		$sort_order = $data['sort_order'];
		$status = $data['status'];
		$prescription_item = $data['prescription_item'];

		$sql = "
		INSERT INTO " . DB_PREFIX . "prescription SET
		code = '" . $code . "',
		pinyin = '" . $pinyin . "',
		status = " . $status . ",
		sort_order = " . $sort_order . ",
		add_by = " . $this->session->data['user_id'] . ",
		date_added = NOW()
		";
		$query = $this->db->query($sql);

		$lastid =  $this->db->getLastId();

		foreach($names as $language_id => $name){
			$sql = "
			INSERT INTO " . DB_PREFIX . "prescription_name SET
			prescription_id = " . $lastid . ",
			name = '" . $name['name'] . "',
			language_id = " . $language_id . "
			";
			$query = $this->db->query($sql);
		}

		foreach($prescription_item as $row => $item){
			$sql = "
			INSERT INTO " . DB_PREFIX . "prescription_item SET
			prescription_id = " . $lastid . ",
			product_id = " . $item['product_id'] . ",
			used_qty = " . $item['used_qty'] . ",
			display_order = " . $item['display_order'] . ",
			remark = '" . $item['remark'] . "',
			add_by = " . $this->session->data['user_id'] . ",
			date_added = NOW()
			";

			$query = $this->db->query($sql);
		}
	}

	public function editPrescription($id, $data){
		// post data
		$names = $data['prescription_name'];
		$code = $data['code'];
		$pinyin = $data['pinyin'];
		$sort_order = $data['sort_order'];
		$status = $data['status'];
		$prescriptionitems = $data['prescription_item'];

		//general update
		$sql = "
		UPDATE " . DB_PREFIX . "prescription SET
		code = '$code',
		pinyin = '$pinyin',
		status = '$status',
		sort_order = '$sort_order',
		modify_by = '" . $this->session->data['user_id'] . "',
		date_modified = NOW()
		WHERE prescription_id = '$id'
		";
		$query = $this->db->query($sql);

		//name update
		foreach($names as $language_id => $value){
			$newname = $value['name'];
			$sql = "
			UPDATE " . DB_PREFIX . "prescription_name SET
			name = '$newname'
			WHERE prescription_id = '$id'
			AND language_id = $language_id
			";
			$query = $this->db->query($sql);
		}

		$survive_product_id = array();

		if($prescriptionitems){
			foreach($prescriptionitems as $row => $item){
				$survive_product_id[] = $item['product_id'];

				if($this->prescriptionItemExists($id, $item['product_id'])){
					$sql = "
					UPDATE " . DB_PREFIX . "prescription_item SET
					used_qty				= " . $item['used_qty'] . ",
					display_order 			= " . $item['display_order'] . ",
					remark 					= '" . $item['remark'] . "',
					modify_by 				= '" . $this->session->data['user_id'] . "',
					date_modified 			= NOW()
					WHERE prescription_id 	= $id
					AND product_id 	= '" . (int)$item['product_id'] . "'";

					/*
					echo "<pre>";
					print_r($sql);
					echo "</pre>";
					*/

					$query = $this->db->query($sql);
				} else {
					$sql = "
					INSERT INTO " . DB_PREFIX . "prescription_item SET
					prescription_id 	= $id,
					product_id 			= '" . (int)$item['product_id'] . "',
					used_qty 			= " . (int)$item['used_qty'] . ",
					display_order 		= " . (int)$item['display_order'] . ",
					remark 				= '" . $this->db->escape($item['remark']) . "',
					modify_by 			= '" . (int)$this->session->data['user_id'] . "',
					date_modified 		= NOW()
					";

					$query = $this->db->query($sql);
				}
			}
		}

		if(!empty($survive_product_id)){
			$sql = "
			DELETE FROM " . DB_PREFIX . "prescription_item
			WHERE prescription_id = $id
			AND product_id NOT IN(" . implode($survive_product_id, ", ") . ")
			";

			$query = $this->db->query($sql);
		} else {
			$sql = "
			DELETE FROM " . DB_PREFIX . "prescription_item
			WHERE prescription_id = $id
			";

			$query = $this->db->query($sql);
		}

	}

	public function deletePrescription($prescription_id){
		$sql = "DELETE FROM " . DB_PREFIX . "prescription WHERE prescription_id = " . $prescription_id;
		$query = $this->db->query($sql);

		$sql = "DELETE FROM " . DB_PREFIX . "prescription_name WHERE prescription_id = " . $prescription_id;
		$query = $this->db->query($sql);

		$sql = "DELETE FROM " . DB_PREFIX . "prescription_item WHERE prescription_id = " . $prescription_id;
		$query = $this->db->query($sql);
	}

	public function totalPrescription($data){
		$sort 	= isset($data['sort']) ? $data['sort'] : "name";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";

		$filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
		$filter_code = isset($data['filter_code']) ? $data['filter_code'] : false;
		$filter_pinyin = isset($data['filter_pinyin']) ? $data['filter_pinyin'] : false;
		$filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

		$filter_name_statement = $filter_name ? "AND " . DB_PREFIX . "prescription_name.name LIKE '%" . $filter_name . "%'" : "";
		$filter_code_statement = $filter_code ? "AND " . DB_PREFIX . "prescription.code LIKE '%" . $filter_code . "%'" : "";
		$filter_pinyin_statement = $filter_pinyin ? "AND " . DB_PREFIX . "prescription.pinyin LIKE '%" . $filter_pinyin . "%'" : "";
		$filter_status_statement = $filter_status ? "AND " . DB_PREFIX . "prescription.status =" . $filter_status : "";

		$sql = "
		SELECT COUNT(*) AS total
		FROM
			" . DB_PREFIX . "prescription,
			" . DB_PREFIX . "prescription_name
		WHERE " . DB_PREFIX . "prescription.prescription_id = " . DB_PREFIX . "prescription_name.prescription_id
		AND " . DB_PREFIX . "prescription_name.language_id = " . (int)$this->config->get('config_language_id') . "
		$filter_name_statement
		$filter_code_statement
		$filter_pinyin_statement
		$filter_name_statement
		$filter_status_statement
		ORDER BY $sort $order";

		$query = $this->db->query($sql);

		return $query->row['total'];
	}

	public function prescriptionItemExists($prescription_id, $product_id){
		$sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "prescription_item WHERE prescription_id = $prescription_id AND product_id = $product_id";
		$query = $this->db->query($sql);

		return $query->row['num'] > 0;
	}
}
?>