<?php
class ModelCatalogManufacturer extends Model {
	public function addManufacturer($data) {
		// add user
		$sql = "INSERT INTO " . DB_PREFIX . "user SET 
			username = '" . $this->db->escape($data['username']) . "',
			user_group_id = '13', 
			salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', 
			password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "', 
			firstname = '" . $this->db->escape($data['firstname']) . "', 
			email = '" . $this->db->escape($data['email']) . "', 
			image = '" . $this->db->escape($data['image']) ."', 
			gender ='".$this->db->escape($data['gender'])."',
			ic ='".$this->db->escape($data['ic'])."', 
			contactno ='".$this->db->escape($data['telephone1'])."',
			periodfrom ='".$this->db->escape($data['periodfrom'])."', 
			periodto ='".$this->db->escape($data['periodto'])."', 
			remark ='".$this->db->escape($data['remark'])."', 
			position ='1', 
			status = '1', 
			add_by = '".(int)$this->session->data['user_id']."', 
			modify_by = '".(int)$this->session->data['user_id']."', 
			date_added = NOW(), 
			date_modify = NOW()";
			
		$this->db->query($sql);
		$user_id = $this->db->getLastId();
		
		if($user_id){
			
			$sql = "
			INSERT INTO " . DB_PREFIX . "user_permission SET
				user_id = '" . (int)$user_id . "'
			";
			$this->db->query($sql);
			
			if(isset($data['manufacturer_store'])){
				foreach ($data['manufacturer_store'] as $store_id) {
					
					$sql = "
					INSERT INTO " . DB_PREFIX . "user_to_store 
					SET 
						user_id = '" . (int)$user_id . "', 
						store_id = '" . (int)$store_id . "'
					";
					
					$this->db->query($sql);
				}
			}
			
			$sql = "
			INSERT INTO " . DB_PREFIX . "manufacturer SET
				user_id = '" . (int)$user_id . "',
				name = '" . $this->db->escape($data['name']) . "',
				code = '" . $this->db->escape($data['code']) . "',
				gst_reg_no = '" . $this->db->escape($data['gst_reg_no']) . "',
				company_reg_no = '" . $this->db->escape($data['company_reg_no']) . "',
				description = '" . $this->db->escape($data['description']) . "',
				address_1 = '" . $this->db->escape($data['address_1']) . "',
				address_2 = '" . $this->db->escape($data['address_2']) . "',
				address_3 = '" . $this->db->escape($data['address_3']) . "',
				city = '" . $this->db->escape($data['city']) . "',
				postcode = '" . $this->db->escape($data['postcode']) . "',
				country_id = '" . (int)$data['country_id'] . "',
				telephone1 = '" . $this->db->escape($data['telephone1']) . "',
				telephone2 = '" . $this->db->escape($data['telephone2']) . "',
				fax = '" . $this->db->escape($data['fax']) . "',
				email = '" . $this->db->escape($data['email']) . "',
				status = '" . (int)$data['status'] . "',
				remark = '" . $this->db->escape($data['remark']) . "',
				sort_order = '" . (int)$data['sort_order'] . "',
				add_by = '".(int)$this->session->data['user_id']."', 
				modify_by = '".(int)$this->session->data['user_id']."', 
				date_added = NOW(), 
				date_modified = NOW()
			";
			
			$this->db->query($sql);

			$manufacturer_id = $this->db->getLastId();
		}

		return $manufacturer_id;
	}

	public function editManufacturer($manufacturer_id, $data) {
		$this->event->trigger('pre.admin.manufacturer.edit', $data);
		
		$user_id = $this->getUserId($manufacturer_id);
		
		$sql = "
		UPDATE  " . DB_PREFIX . "user SET
			username = '" . $this->db->escape($data['username']) . "',
			firstname = '" . $this->db->escape($data['firstname']) . "',
			email = '" . $this->db->escape($data['email']) . "', 
			image = '" . $this->db->escape($data['image']) ."', 
			gender ='".$this->db->escape($data['gender'])."',
			ic ='".$this->db->escape($data['ic'])."', 
			contactno ='".$this->db->escape($data['telephone1'])."',
			periodfrom ='".$this->db->escape($data['periodfrom'])."', 
			periodto ='".$this->db->escape($data['periodto'])."', 
			remark ='".$this->db->escape($data['remark'])."',
			modify_by = '".(int)$this->session->data['user_id']."', 
			date_modify = NOW()
		WHERE user_id = '" . (int)$user_id . "'
		";
		
		$this->db->query($sql);
		
		if(!empty($data['password'])){
			$sql = "
			UPDATE  " . DB_PREFIX . "user SET
				salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "', 
				password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "'
			WHERE user_id = '" . (int)$user_id . "'";
				
			$this->db->query($sql);
		}
		
		$sql = "
		UPDATE " . DB_PREFIX . "manufacturer SET
			name = '" . $this->db->escape($data['name']) . "',
			code = '" . $this->db->escape($data['code']) . "',
			gst_reg_no = '" . $this->db->escape($data['gst_reg_no']) . "',
			company_reg_no = '" . $this->db->escape($data['company_reg_no']) . "',
			description = '" . $this->db->escape($data['description']) . "',
			address_1 = '" . $this->db->escape($data['address_1']) . "',
			address_2 = '" . $this->db->escape($data['address_2']) . "',
			address_3 = '" . $this->db->escape($data['address_3']) . "',
			city = '" . $this->db->escape($data['city']) . "',
			postcode = '" . $this->db->escape($data['postcode']) . "',
			country_id = '" . (int)$data['country_id'] . "',
			telephone1 = '" . $this->db->escape($data['telephone1']) . "',
			telephone2 = '" . $this->db->escape($data['telephone2']) . "',
			fax = '" . $this->db->escape($data['fax']) . "',
			email = '" . $this->db->escape($data['email']) . "',
			status = '" . (int)$data['status'] . "',
			remark = '" . $this->db->escape($data['remark']) . "',
			sort_order = '" . (int)$data['sort_order'] . "',
			modify_by = '".(int)$this->session->data['user_id']."', 
			date_modified = NOW()
		WHERE manufacturer_id = '" . $manufacturer_id . "'
		";
		
		$this->db->query($sql);
		
		if(isset($data['manufacturer_store']) && $user_id){
			$sql = "DELETE FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int)$user_id . "'";
			$this->db->query($sql);
			
			foreach ($data['manufacturer_store'] as $store_id) {
				$sql = "
				INSERT INTO " . DB_PREFIX . "user_to_store 
				SET 
					user_id = '" . (int)$user_id . "', 
					store_id = '" . (int)$store_id . "'
				";
				
				$this->db->query($sql);
			}
		}

		$this->cache->delete('manufacturer');

		$this->event->trigger('post.admin.manufacturer.edit');
	}

	public function deleteManufacturer($manufacturer_id) {

		$this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer WHERE manufacturer_id = '" . (int)$manufacturer_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer_description WHERE manufacturer_id = '" . (int)$manufacturer_id . "'");
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "manufacturer_to_store WHERE manufacturer_id = '" . (int)$manufacturer_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "url_alias WHERE query = 'manufacturer_id=" . (int)$manufacturer_id . "'");
		
		$user_id = $this->getUserId($manufacturer_id);
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int)$user_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "user_permission WHERE user_id = '" . (int)$user_id . "'");
		
		$this->cache->delete('manufacturer');

	}

	public function getManufacturer($manufacturer_id) {
		$sql = "
		SELECT
			u.user_id,
			u.username,
			CONCAT(u.firstname, ' ', u.lastname) AS personincharge,
			u.firstname,
			u.lastname,
			u.gender,
			u.ic,
			u.periodfrom,
			u.periodto,
			u.image,
			m.gst_reg_no,
			m.company_reg_no,
			m.manufacturer_id,
			m.name,
			m.description,
			m.code,
			m.address_1,
			m.address_2,
			m.address_3,
			m.city,
			m.postcode,
			m.country_id,
			c.name AS country,
			m.zone_id,
			z.name AS zone,
			m.telephone1,
			m.telephone2,
			m.fax,
			m.email,
			m.status,
			m.remark,
			m.sort_order,
			m.date_added,
			m.add_by,
			m.date_modified,
			m.modify_by
		FROM " . DB_PREFIX . "manufacturer m
		LEFT JOIN " . DB_PREFIX . "user u
		ON m.user_id = u.user_id
		LEFT JOIN " . DB_PREFIX . "country c
		ON m.country_id = c.country_id
		LEFT JOIN " . DB_PREFIX . "zone z
		ON m.zone_id = z.zone_id
		WHERE m.manufacturer_id = '" . (int)$manufacturer_id . "'
		";
		
		/*
		$sql = "
		SELECT 
			DISTINCT *, 
			(SELECT keyword FROM " . DB_PREFIX . "url_alias WHERE query = 'manufacturer_id=" . (int)$manufacturer_id . "') AS keyword,
			(SELECT name FROM " . DB_PREFIX . "country WHERE country_id = " . DB_PREFIX . "manufacturer.country_id) AS country,
			(SELECT name FROM " . DB_PREFIX . "zone WHERE zone_id = " . DB_PREFIX . "manufacturer.zone_id) AS zone
		FROM " . DB_PREFIX . "manufacturer
		WHERE manufacturer_id = '" . (int)$manufacturer_id . "'";
		*/
		$query = $this->db->query($sql);

		return $query->row;
	}
	
	public function getUserId($manufacturer_id){
		$sql = "
		SELECT user_id 
		FROM " . DB_PREFIX . "manufacturer
		WHERE manufacturer_id = '" . (int)$manufacturer_id . "'
		";
		
		$query = $this->db->query($sql);
		
		return $query->row;
	}
	
	public function getManufacturerDescription($manufacturer_id){
		$descriptions = array();
		
		$sql = "
		SELECT * 
		FROM " . DB_PREFIX . "manufacturer_description
		WHERE manufacturer_id = '" . (int)$manufacturer_id . "'";
		
		$query = $this->db->query($sql);
		
		foreach($query->rows as $row) {
			$descriptions[$row['language_id']]['name'] = $row['name'];
			$descriptions[$row['language_id']]['description'] = $row['description'];
		}
		
		return $descriptions;
	}

	public function getManufacturers($data = array()) {
		
		//$language_id = $this->config->get('config_language_id');
		
		$sort 	= isset($data['sort']) ? $data['sort'] : "sort_order";
		$order 	= isset($data['order']) ? $data['order'] : "ASC";
		
		$filter_name_statement = !empty($data['filter_supplier_name']) ? "AND m.name LIKE '%" . $this->db->escape($data['filter_supplier_name']) . "%'" : "";
                
                $filter_name2_statement = !empty($data['filter_name']) ? "AND m.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'" : "";
		
		/*
		$filter_store_id_statement = isset($data['filter_store_id']) ?
		"AND mts.store_id = '" . (int)$data['filter_store_id'] . "'" :
		"";
		*/
		
		$limit_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT
			u.user_id,
			u.username,
			CONCAT(u.firstname, ' ', u.lastname) AS personincharge,
			u.firstname,
			u.lastname,
			u.gender,
			u.ic,
			u.periodfrom,
			u.periodto,
			u.image,
			m.manufacturer_id,
			m.name,
			m.description,
			m.code,
			m.address_1,
			m.address_2,
			m.address_3,
			m.city,
			m.postcode,
			m.country_id,
			m.zone_id,
			m.telephone1,
			m.telephone2,
			m.fax,
			m.email,
			m.status,
			m.remark,
			m.sort_order,
			m.date_added,
			m.add_by,
			m.date_modified,
			m.modify_by,
                        m.date_added AS opendate
		FROM " . DB_PREFIX . "manufacturer m
		LEFT JOIN " . DB_PREFIX . "user u
		ON m.user_id = u.user_id
		WHERE 1
		$filter_name_statement
                $filter_name2_statement
		ORDER BY $sort $order
		$limit_statement";
		
		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getManufacturerStores($manufacturer_id) {
		$user_id = $this->getUserId($manufacturer_id);
		
		$manufacturer_store_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int)$user_id . "'");

		foreach ($query->rows as $result) {
			$manufacturer_store_data[] = $result['store_id'];
		}

		return $manufacturer_store_data;
	}

	public function getTotalManufacturers($data = array()) {
		$sql = "SELECT COUNT(*) AS total FROM " . DB_PREFIX . "manufacturer";
		
		$implode = array();
		
		if (!empty($data['filter_supplier_name'])) {
			$implode[] = "name LIKE '%" . $this->db->escape($data['filter_supplier_name']) . "%'";
		}
		
		if ($implode) {
			$sql .= " WHERE " . implode(" AND ", $implode);
		}

		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function manufacturerUsernameExists($username){
		$sql = "
		SELECT COUNT(*) AS total_row 
		FROM " . DB_PREFIX . "user
		WHERE username = '" . $this->db->escape($username) . "'
		";
		
		$query = $this->db->query($sql);
		
		return $query->row['total_row'] > 0;
	}
	
	public function manufacturerEmailExists($email){
		$sql = "
		SELECT COUNT(*) AS total_row 
		FROM " . DB_PREFIX . "manufacturer
		WHERE email = '" . $this->db->escape($email) . "'
		";
		$query = $this->db->query($sql);
		
		return $query->row['total_row'] > 0;
	}
	
	public function manufacturerNameExists($name){
		$sql = "
		SELECT COUNT(*) AS total_row 
		FROM " . DB_PREFIX . "manufacturer
		WHERE name = '" . $this->db->escape($name) . "'
		";
		$query = $this->db->query($sql);
		
		return $query->row['total_row'] > 0;}
	
	public function manufacturerCodeExists($code){
		$sql = "
		SELECT COUNT(*) AS total_row 
		FROM " . DB_PREFIX . "manufacturer
		WHERE code = '" . $this->db->escape($code) . "'
		";
		$query = $this->db->query($sql);
		
		return $query->row['total_row'] > 0;
	}
	
	public function searchManufacturer($data){
		$result = array();
		
		$name = isset($data['name']) ? $data['name'] : false;
		$code = isset($data['code']) ? $data['code'] : false;
		
		if($name || $code){
			$name_statement = ($name) ? "AND m.name = '" . $this->db->escape($name) . "'" : "";
			$code_statement = ($code) ? "AND m.code = '" . $this->db->escape($code) . "'" : "";
			
			$sql = "
			SELECT
				u.user_id,
				u.username,
				CONCAT(u.firstname, ' ', u.lastname) AS personincharge,
				u.firstname,
				u.lastname,
				u.gender,
				u.ic,
				u.periodfrom,
				u.periodto,
				u.image,
				m.manufacturer_id,
				m.name,
				m.description,
				m.code,
				m.address_1,
				m.address_2,
				m.address_3,
				m.city,
				m.postcode,
				m.country_id,
				m.zone_id,
				m.telephone1,
				m.telephone2,
				m.fax,
				m.email,
				m.status,
				m.remark,
				m.sort_order,
				m.date_added,
				m.add_by,
				m.date_modified,
				m.modify_by
			FROM " . DB_PREFIX . "manufacturer m
			LEFT JOIN " . DB_PREFIX . "user u
			ON m.user_id = u.user_id 
			WHERE 1
			$name_statement
			$code_statement";
			
			$query = $this->db->query($sql);
			$result = $query->row;
		}
		
		return $result;
	}
}