<?php

class ModelAppointmentAppointment extends Model
{
    public function addCustomer($data)
    {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '" . (int) $data['customer_group_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						lastname = '" . $this->db->escape($data['lastname']) . "',
						gender = '" . $this->db->escape($data['gender']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape(isset($data['customer_card']) ? $data['customer_card'] : '') . "',
						dob = '" . $this->db->escape($data['dob']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['telephone']) . "',
						telephone2 = '" . $this->db->escape($data['telephone2']) . "',
						home = '" . $this->db->escape($data['home']) . "',
						fax = '" . $this->db->escape($data['fax']) . "',
						custom_field = '" . $this->db->escape(isset($data['custom_field']) ? serialize($data['custom_field']) : '') . "',
						newsletter = '" . (int) $data['newsletter'] . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
							password = '" . $this->db->escape(sha1($salt . sha1($salt . sha1($data['password'])))) . "',
						status = '" . (int) $data['status'] . "',
						approved = '" . (int) $data['approved'] . "',
						safe = '" . (int) $data['safe'] . "',
                        add_by = '" . (int) $this->session->data['user_id'] . "',
                        modify_by = '" . (int) $this->session->data['user_id'] . "',
						date_added = NOW(),
                        date_modified = NOW()
				");
            }
        } while ($insert_customer == false);

        $customer_id = $this->db->getLastId();

        if (isset($data['address'])) {
            foreach ($data['address'] as $address) {
                $this->db->query("
				INSERT INTO " . DB_PREFIX . "address SET
				customer_id = '" . (int) $customer_id . "',
				firstname = '" . $this->db->escape($address['firstname']) . "',
				lastname = '" . $this->db->escape($address['lastname']) . "',
				company = '" . $this->db->escape($address['company']) . "',
				address_1 = '" . $this->db->escape($address['address_1']) . "',
				address_2 = '" . $this->db->escape($address['address_2']) . "',
				address_3 = '" . $this->db->escape($address['address_3']) . "',
				city = '" . $this->db->escape($address['city']) . "',
				postcode = '" . $this->db->escape($address['postcode']) . "',
				country_id = '" . (int) $address['country_id'] . "',
				zone_id = '" . (int) $address['zone_id'] . "',
				custom_field = '" . $this->db->escape(isset($address['custom_field']) ? serialize($address['custom_field']) : '') . "'");

                if (isset($address['default'])) {
                    $address_id = $this->db->getLastId();

                    $this->db->query("UPDATE " . DB_PREFIX . "customer SET address_id = '" . (int) $address_id . "' WHERE customer_id = '" . (int) $customer_id . "'");
                }
            }
        }

        return $customer_id;
    }

    public function check_unique_id($unique_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }
    //woo modified
    public function getCustomerbyid($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer  WHERE 1 AND customer_id = '" . (int) $customer_id . "' ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getCustomerInfo($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE 1 AND customer_id = '" . (int) $customer_id . "' ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function addHerbal($data, $transaction_no)
    {
        $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale SET customer_id = '" . (int) $data['customer_id'] . "', doctor_id = '" . (int) $data['doctor'] . "', invoice_prefix = '" . $this->db->escape($transaction_no) . "', sales_date = NOW(), store_id = '" . (int) $this->session->data['store_id'] . "', clinicalsale_action = '" . (int) 1 . "', order_action = '" . (int) 17 . "', add_by = '" . (int) $this->session->data['user_id'] . "', date_added = NOW(), modifi_by = '" . $this->session->data['user_id'] . "', date_modified = NOW()");

        $herbal_id = $this->db->getLastId();

        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = (lastrunningno + 1) WHERE module = 'herbal/herbal' AND store_id = '" . $this->session->data['store_id'] . "'");

        return $herbal_id;
    }

    public function addService($data, $transaction_no)
    {
        $this->db->query("INSERT INTO " . DB_PREFIX . "service_form SET invoice_prefix = '" . $this->db->escape($transaction_no) . "', customer_id = '" . (int) $data['customer_id'] . "', store_id = '" . (int) $this->session->data['store_id'] . "', serviceform_action = 1, order_action = 17, add_by = '" . $this->user->getId() . "', date_added = NOW(), modifi_by = '" . $this->user->getId() . "', date_modified = NOW()");

        $service_id = $this->db->getLastId();

        $start_time = date('Y-m-d') . ' ' . $data['start'];
        $end_time = date('Y-m-d') . ' ' . $data['end'];

        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item SET service_form_id = '" . $service_id . "', clinicalservice_id = '" . (int) $data['service'] . "', user_id = '" . (int) $data['doctor'] . "', start_time = '" . $start_time . "', end_time = '" . $end_time . "', price = '" . $data['price'] . "', modifi_by = '" . $this->session->data['user_id'] . "', date_modified = NOW()");

        $this->db->query("UPDATE " . DB_PREFIX . "transaction_no SET lastrunningno = (lastrunningno + 1) WHERE module = 'service/service_form' AND store_id = '" . $this->session->data['store_id'] . "'");
    }

    public function addAppointment($data)
    {
        date_default_timezone_set('Asia/Kuala_Lumpur');

        $appointment_time = date('h:i A');
        $appointment_date = date('Y-m-d');

        date_default_timezone_set('UTC');

        $this->db->query("
		INSERT INTO " . DB_PREFIX . "appointment
		SET
			store_id = '" . (int) $this->session->data['store_id'] . "',
			customer_id = '" . (int) $data['customer_id'] . "',
            customer_name = '" . $this->db->escape($data['customer_name']) . "',
            customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
			email = '" . $this->db->escape($data['email']) . "',
			telephone = '" . $this->db->escape($data['telephone']) . "',
			clinicalservice_id = '" . $data['clinicalservice_id'] . "',
			status = 0,
            from_etcm = 0,
			new_customer = '" . (int) $data['new'] . "',
			created_by = '" . $this->user->getId() . "',
			created_date = NOW(),
			appointment_time = '" . $appointment_time . "',
            appointment_date = '" . $appointment_date . "',
			lastmodified_by = '" . $this->user->getId() . "',
			lastmodified_date = NOW()");

        $appointment_id = $this->db->getLastId();
        // if(!empty($appointment_id)){
        //     $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));

        // }

        if ($data['got_appointment_date']) {
            $this->db->query("UPDATE " . DB_PREFIX . "appointment SET appointment_date = '" . $this->db->escape($data['appointment_date']) . "' WHERE appointment_id = '" . (int) $appointment_id . "'");
        }

        if ($data['got_appointment_time']) {
            $this->db->query("UPDATE " . DB_PREFIX . "appointment SET appointment_time = '" . $this->db->escape($data['appointment_time']) . "' WHERE appointment_id = '" . (int) $appointment_id . "'");
        }

        if ($data['got_doctor_id']) {
            $this->db->query("UPDATE " . DB_PREFIX . "appointment SET doctor_id = '" . (int) $data['doctor_id'] . "' WHERE appointment_id = '" . (int) $appointment_id . "'");
        }

        return $appointment_id;
    }



    public function addAppointmentCustomer($data)
    {

        date_default_timezone_set('Asia/Kuala_Lumpur');


        $store_id = (int) $this->session->data['store_id'];
        $customer_id = (int) $data['customer_id'];
        $customer_name = $this->db->escape($data['customer_name']);
        $customer_phone = $this->db->escape($data['customer_phone']);
        $email = $this->db->escape($data['email']);
        $remark = $this->db->escape($data['remark']);
        $appointment_time = date('h:i A');
        $appointment_date = date('Y-m-d');

        date_default_timezone_set('UTC');

        $this->db->query("
            INSERT INTO " . DB_PREFIX . "appointment
            SET
                store_id = '" . $store_id . "',
                customer_id = '" . $customer_id . "',
                customer_name = '" . $customer_name . "',
                customer_ic = '',
                email = '" . $email . "',
                telephone = '" . $customer_phone . "',
                remark = '" . $remark . "',
                clinicalservice_id = '',
                status = 0,
                from_etcm = 0,
                new_customer = 0,
                created_by = '" . $this->user->getId() . "',
                created_date = NOW(),
                lastmodified_by = '" . $this->user->getId() . "',
                lastmodified_date = NOW(),
                appointment_time = '" . $appointment_time . "',
                appointment_date = '" . $appointment_date . "'
        ");

        $appointment_id = $this->db->getLastId();

        return $appointment_id;
    }


    public function editAppointment($appointment_id, $data)
    {
        $doctor = ($data['doctor'] ? (int) $data['doctor'] : 0);
        $service = ($data['service'] ? (int) $data['service'] : 0);

        if ($data['status'] == 5) {
            $data['status'] = 0;
        }

        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET appointment_date = '" . $this->db->escape($data['appointment_date']) . "', appointment_time = '" . $this->db->escape(date("h:i A", strtotime($data['time']))) . "', store_id = '" . (int) $this->session->data['store_id'] . "', customer_id = '" . (int) $data['customer_id'] . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', doctor_id = " . $doctor . ", clinicalservice_id = " . $service . ", remark = '" . $this->db->escape($data['remark']) . "', status = '" . (int) $data['status'] . "', lastmodified_by = '" . $this->user->getId() . "', lastmodified_date = NOW() WHERE appointment_id = '" . $appointment_id . "'");

        $this->db->query("UPDATE " . DB_PREFIX . "appointment_emergency SET appointment_newdate = '" . $this->db->escape($data['date']) . "', appointment_newtime = '" . $this->db->escape($data['time']) . "', doctor_id = " . $doctor . ", emergency_status = 1 WHERE appointment_id = '" . $appointment_id . "' AND emergency_status != 1");

        return $this->db->countAffected();
    }

    public function require_reconfirm($appointment_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET reconfirm_appointment = '1' WHERE appointment_id = '" . (int) $appointment_id . "'");
    }

    public function deleteAppointment($appointment_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET status = 2, lastmodified_by = '" . (int)$this->user->getId() . "', lastmodified_date = NOW() WHERE appointment_id = '" . (int) $appointment_id . "'");
    }

    public function getAppsAppointments($data = array())
    {
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        if ($store_id != 0) {
            $sql = "SELECT a.appointment_id, a.appointment_date, a.appointment_time, a.customer_id, a.from_etcm, a.store_id, a.doctor_id, a.status, a.created_date, a.customer_name, a.telephone, c.name store_name FROM " . DB_PREFIX . "appointment a";
        } else {
            $sql = "SELECT a.appointment_id, a.appointment_date, a.appointment_time, a.customer_id, a.from_etcm, a.store_id, a.doctor_id, a.status, a.created_date, a.customer_name, a.telephone FROM " . DB_PREFIX . "appointment a";
        }

        if ($store_id != 0) {
            $sql .= " INNER JOIN " . DB_PREFIX . "store c ON a.store_id = c.store_id";
        }

        $sql .= ' WHERE a.store_id = "' . $store_id . '" AND a.customer_id = "0"';

        if (!empty($data['filter_status'])) {
            $filter_status_str = implode(', ', $data['filter_status']);

            $sql .= " AND a.status IN(" . $this->db->escape($filter_status_str) . ")";
        }

        if (!empty($data['filter_date'])) {
            $sql .= " AND DATE(a.appointment_date) = DATE('" . $this->db->escape($data['filter_date']) . "')";
        }

        if (!empty($data['filter_doctor'])) {
            $sql .= " AND doctor_id = '" . $this->db->escape($data['filter_doctor']) . "'";
        }

        if (!empty($data['filter_remark'])) {
            $sql .= " AND remark LIKE '%" . $this->db->escape($data['filter_remark']) . "%'";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND a.customer_name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (isset($data['filter_from_etcm'])) {
            if ($data['filter_from_etcm'] == '1') {
                $sql .= " AND a.from_etcm > 0";
            } else {
                $sql .= " AND a.from_etcm = 0";
            }
        }

        if (!empty($data['filter_created_date'])) {
            $sql .= " AND DATE(a.created_date) = DATE('" . $this->db->escape($data['filter_created_date']) . "')";
        }

        $sort_data = array(
            'appointment_date',
            'appointment_time',
            'store_id',
            'customer_name',
            'status',
            'from_etcm',
            'doctor_id',
            'created_date'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];

            if (isset($data['order']) && ($data['order'] == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAppointments($data = array())
    {
        $default_store_name = $this->config->get('config_name');

        $sql = "SELECT a.*, a.customer_name AS appointment_customer, CONCAT(c.firstname, ' ', c.lastname) AS customer_name, c.customer_ic, c.customer_card, c.gender, TIMESTAMPDIFF(YEAR, c.dob, CURDATE()) AS age,
        (CASE WHEN a.store_id = 0 THEN '$default_store_name' ELSE s.name END) AS store_name, csd.name AS service_name, CONCAT(u.firstname, ' ',u.lastname) AS doctor_name FROM " . DB_PREFIX . "appointment a  LEFT JOIN " . DB_PREFIX . "customer c ON a.customer_id = c.customer_id LEFT JOIN " . DB_PREFIX . "store s ON (a.store_id = s.store_id) LEFT JOIN `" . DB_PREFIX . "user` u ON a.doctor_id = u.user_id LEFT JOIN `" . DB_PREFIX . "clinical_service_description` csd ON (a.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "') WHERE 1 AND a.hide = 0 ";

        $user_position = $this->user->user_position;
        $user_view = $this->user->user_view;

        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND '" . $this->db->escape($data['filter_date_end']) . "'";
        } elseif (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } elseif (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (empty($user_view) && $user_position == 2) {
            $sql .= " AND a.doctor_id = '" . (int)$this->session->data['user_id'] . "'";
        } else {
            if (!empty($data['filter_doctor'])) {
                $sql .= " AND a.doctor_id IN(" . $this->db->escape($data['filter_doctor']) . ")";
            }
        }

        if (!empty($data['filter_email'])) {
            $sql .= " AND a.email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_remark'])) {
            $sql .= " AND a.remark LIKE '%" . $this->db->escape($data['filter_remark']) . "%'";
        }

        if (isset($data['filter_status'])) {
            $sql .= " AND a.status IN(" . $this->db->escape($data['filter_status']) . ")";
        }

        if (!empty($user_view)) {
            if (isset($data['filter_store'])) {
                $sql .= " AND a.store_id IN(" . $this->db->escape($data['filter_store']) . ")";
            }
        } else {
            $sql .= " AND a.store_id = '" . (int)$this->session->data['store_id'] . "'";
        }

        if (!empty($data['filter_telephone'])) {
            $sql .= " AND a.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (isset($data['filter_from_etcm'])) {
            $sql .= " AND a.from_etcm IN(" . $this->db->escape($data['filter_from_etcm']) . ")";
        }

        if (!empty($data['filter_created_date'])) {
            $sql .= " AND DATE(a.created_date) = DATE('" . $this->db->escape($data['filter_created_date']) . "')";
        }

        if (!empty($data['filter_date_type'])) {
            if ($data['filter_date_type'] == 'upcoming') {
                $sql .= " ORDER BY STR_TO_DATE(CONCAT(a.appointment_date, ' ', a.appointment_time), '%Y-%m-%d %h:%i %p') ASC ";
            } else {
                $sql .= " ORDER BY STR_TO_DATE(CONCAT(a.appointment_date, ' ', a.appointment_time), '%Y-%m-%d %h:%i %p') DESC ";
            }
        } else {
            if (!empty($data['sort_type'])) {
                if ($data['sort_type'] == 'by_doctor_by_date') {
                    $sql .= " ORDER BY a.doctor_id ASC, STR_TO_DATE(CONCAT(a.appointment_date, ' ', a.appointment_time), '%Y-%m-%d %h:%i %p') ASC ";
                }
            } else {
                $sql .= " ORDER BY STR_TO_DATE(CONCAT(a.appointment_date, ' ', a.appointment_time), '%Y-%m-%d %h:%i %p') DESC ";
            }
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalAppointments($data)
    {
        $sql = "SELECT COUNT(DISTINCT a.appointment_id) AS total FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "customer c ON a.customer_id = c.customer_id LEFT JOIN " . DB_PREFIX . "store s ON a.store_id = s.store_id WHERE 1 AND a.hide = 0 ";

        $user_position = $this->user->user_position;
        $user_view = $this->user->user_view;

        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND '" . $this->db->escape($data['filter_date_end']) . "'";
        } elseif (!empty($data['filter_date_start']) && empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        } elseif (empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(a.appointment_date) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (empty($user_view) && $user_position == 2) {
            $sql .= " AND a.doctor_id = '" . (int)$this->session->data['user_id'] . "'";
        } else {
            if (!empty($data['filter_doctor'])) {
                $sql .= " AND a.doctor_id IN(" . $this->db->escape($data['filter_doctor']) . ")";
            }
        }

        if (!empty($data['filter_email'])) {
            $sql .= " AND a.email LIKE '%" . $this->db->escape($data['filter_email']) . "%'";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_remark'])) {
            $sql .= " AND a.remark LIKE '%" . $this->db->escape($data['filter_remark']) . "%'";
        }

        if (isset($data['filter_status'])) {
            $sql .= " AND a.status IN(" . $this->db->escape($data['filter_status']) . ")";
        }

        if (!empty($user_view)) {
            if (isset($data['filter_store'])) {
                $sql .= " AND a.store_id IN(" . $this->db->escape($data['filter_store']) . ")";
            }
        } else {
            $sql .= " AND a.store_id = '" . (int)$this->session->data['store_id'] . "'";
        }

        if (!empty($data['filter_telephone'])) {
            $sql .= " AND a.telephone LIKE '%" . $this->db->escape($data['filter_telephone']) . "%'";
        }

        if (isset($data['filter_from_etcm'])) {
            $sql .= " AND a.from_etcm IN(" . $this->db->escape($data['filter_from_etcm']) . ")";
        }


        if (!empty($data['filter_created_date'])) {
            $sql .= " AND DATE(a.created_date) = DATE('" . $this->db->escape($data['filter_created_date']) . "')";
        }

        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function getCustomer($appointment_id)
    {
        $sql = "SELECT a.*, ad.country_id
                FROM " . DB_PREFIX . "customer a
                INNER JOIN " . DB_PREFIX . "appointment b
                ON a.customer_id = b.customer_id
                LEFT JOIN " . DB_PREFIX . "address ad
                ON ad.customer_id = a.customer_id
                WHERE b.appointment_id = '" . $appointment_id . "'";
        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getServices()
    {
        $query = $this->db->query("SELECT *
			FROM " . DB_PREFIX . "clinical_service a
			LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
			WHERE b.language_id = '" . (int) $this->config->get('config_language_id') . "' ORDER BY b.name ASC");

        return $query->rows;
    }

    public function getServicesByDoctorId($doctor_id)
    {
        $query = $this->db->query("SELECT *
            FROM " . DB_PREFIX . "clinical_service a
            LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
            WHERE b.language_id = '" . (int) $this->config->get('config_language_id') . "' AND a.doctor_id = '" . (int) $doctor_id . "' ORDER BY b.name ASC");

        return $query->rows;
    }


    // public function getService($service_id) {
    //     $query = $this->db->query("SELECT *
    // 		FROM " . DB_PREFIX . "clinical_service a
    // 		LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
    // 		WHERE b.language_id = '" . (int) $this->config->get('config_language_id') . "' AND a.clinicalservice_id = '" . (int) $service_id . "'");

    //     return $query->row;
    // }

    public function getService($doctor_id)
    {
        $query = $this->db->query("SELECT *
        FROM " . DB_PREFIX . "clinical_service a
        LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
        WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' AND a.doctor_id = '" . (int)$doctor_id . "'");

        return $query->rows;
    }


    public function getServices2($doctor_id)
    {

        $filter_statement = '';
        if (!empty($doctor_id)) {
            $doctor_str = 's:' . strlen($doctor_id) . ':"' . $doctor_id . '";';
            $filter_statement .= "AND doctor_id LIKE '%$doctor_str%'";
        }
        $sql = "SELECT cs.clinicalservice_id , csd.name AS name, cs.cs_minute AS minute
    FROM " . DB_PREFIX . "clinical_service cs 
    LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON(cs.clinicalservice_id = csd.clinicalservice_id AND csd.language_id = '" . (int)$this->config->get('config_language_id') . "') 
    WHERE doctor_id <> 'a:0:{}' 
    AND cs.clinicalservice_id IN (SELECT DISTINCT(service_id) as service_id FROM " . DB_PREFIX . "availability_to_service)
    $filter_statement
    ORDER BY csd.name
    ";

        $query = $this->db->query($sql);
        return $query->rows;
    }



    public function getDoctors()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE `position` = 2 AND `status` = 1 ORDER BY `doctor_sort_order` ");

        return $query->rows;
    }

    public function getDoctor($doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE position = '" . (int) 2 . "' AND user_id = '" . (int) $doctor_id . "'");

        return $query->row;
    }

    public function getDoctorAvailabilityTime($doctor_id, $day, $service_id)
    {
        $sql = "
		SELECT
			aa.doctor_id,
			aa.day,
			aa.minutes,
			aat.start_time,
			aat.end_time
		FROM " . DB_PREFIX . "appointment_availability aa
		LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat
		ON aat.availability_id = aa.availability_id
        LEFT JOIN " . DB_PREFIX . "availability_to_service ats
		ON ats.availability_id = aa.availability_id
		WHERE 1
		AND aa.doctor_id = '" . (int) $doctor_id . "'
		AND aa.day = '" . $this->db->escape($day) . "'
        AND ats.service_id = '" . (int) $service_id . "'
		ORDER BY aat.availability_time_id ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTimes($store_id, $date, $doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id WHERE aa.store_id = '" . (int) $store_id . "' AND aa.day = '" . $this->db->escape($date) . "' AND aa.doctor_id = '" . (int) $doctor_id . "' ORDER BY aat.availability_time_id ASC");

        return $query->rows;
    }

    public function getServiceTimes($store_id, $date, $service_id)
    {
        $doctor_availability = array();

        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int) $service_id . "'";

        $query_service = $this->db->query($sql);

        $service = $query_service->row;

        if (!empty($service)) {
            $doctor_ids = unserialize($service['doctor_id']);

            foreach ($doctor_ids as $key => $doctor) {
                $sql_availability = "SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id WHERE aa.store_id = '" . (int) $store_id . "' AND aa.day = '" . $this->db->escape($date) . "' AND aa.doctor_id = '" . (int) $doctor . "' ORDER BY aat.availability_time_id ASC";

                $query_availiability = $this->db->query($sql_availability);

                if ($query_availiability->num_rows > 0) {
                    $doctor_availability[] = $query_availiability->rows;
                }
            }
        }

        return $doctor_availability;
    }

    public function getGeneralAppointment($appointment_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    public function getAppointment($appointment_id)
    {
        $query = $this->db->query("
		SELECT b.*
		FROM " . DB_PREFIX . "customer a
		INNER JOIN " . DB_PREFIX . "appointment b
		ON a.customer_id = b.customer_id
		WHERE b.appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    public function checkTimeSlot($doctor_id, $appointment_date, $appointment_time)
    {
        $query = $this->db->query("SELECT *
								   FROM " . DB_PREFIX . "appointment
								   WHERE appointment_date = '" . $this->db->escape($appointment_date) . "'
								   AND appointment_time = '" . $this->db->escape($appointment_time) . "'
								   AND doctor_id = '" . (int) $doctor_id . "'
								   AND status != '2'");

        return $query->row;
    }

    public function checkUserHoliday($doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE store_id = '" . $this->session->data['store_id'] . "' AND user_id = '" . (int) $doctor_id . "'");

        return $query->rows;
    }

    public function checkStoreHoliday($store_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'");

        return $query->rows;
    }

    public function getStore($appointment_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment a
			INNER JOIN " . DB_PREFIX . "store b ON a.store_id = b.store_id
			WHERE a.appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    //dashbord
    public function getDashboardAppointments($data = array())
    {
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        $sql = "SELECT CONCAT(b.firstname,' ',b.lastname) AS customer_name, b.customer_ic, a.appointment_id, a.appointment_date, a.appointment_time, a.status, a.customer_id, a.from_etcm, CONCAT(u.firstname,' ', u.lastname) AS doctor_name FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "customer b ON (b.customer_id = a.customer_id) LEFT JOIN " . DB_PREFIX . "user u ON u.user_id = a.doctor_id";

        $sql .= ' WHERE a.status != 3 AND a.store_id = ' . $store_id . " AND a.doctor_id > 0 AND a.customer_id > 0";


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_date) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_date) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }

        if (isset($data['sort']) && $data['sort']) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDashboardEtcmAppointments($data = array())
    {
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        $sql = "SELECT a.customer_name, a.appointment_id, a.appointment_date, a.appointment_time, a.status, a.customer_id, a.from_etcm, CONCAT(u.firstname,' ', u.lastname) AS doctor_name FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "user u ON u.user_id = a.doctor_id";

        $sql .= ' WHERE a.status != 3 AND a.store_id = ' . $store_id . " AND a.doctor_id > 0 AND a.customer_id = '0'";


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_date) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_date) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }

        if (isset($data['sort']) && $data['sort']) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDashboardAppointmentServices($data = array())
    {
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        $sql = "SELECT CONCAT(b.firstname,' ',b.lastname) AS customer_name, b.customer_ic, a.appointment_id, a.appointment_date, a.appointment_time, a.status, csd.name AS service_name FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "customer b ON (b.customer_id = a.customer_id) LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = a.clinicalservice_id AND csd.language_id = '" . (int) $this->config->get('config_language_id') . "'";

        $sql .= ' WHERE a.status != 3 AND a.store_id = ' . $store_id . " AND a.clinicalservice_id > 0 AND a.clinicalservice_id != 26";


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_date) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_date) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }

        if (isset($data['sort']) && $data['sort']) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ASC";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalDashboardAppointmentServices($data)
    {
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }

        $sql = "SELECT  COUNT(*) AS total FROM " . DB_PREFIX . "appointment a LEFT JOIN " . DB_PREFIX . "customer b ON (b.customer_id = a.customer_id)";

        $sql .= ' WHERE a.status !=3 AND a.store_id = ' . $store_id . " AND a.clinicalservice_id > 0 AND a.clinicalservice_id != 26";


        if (!empty($data['filter_date_from'])) {
            $sql .= " AND DATE(a.appointment_date) >='" . $this->db->escape($data['filter_date_from']) . "'";
        }

        if (!empty($data['filter_date_to'])) {
            $sql .= " AND DATE(a.appointment_date) <='" . $this->db->escape($data['filter_date_to']) . "'";
        }


        $query = $this->db->query($sql);

        return $query->row['total'];
    }

    public function updateDashboardAppointment($appointment_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET status = '3' WHERE appointment_id = '" . $appointment_id . "'");
    }

    public function getAutocompleteFormCustomers($data)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE status = '1' AND approved = '1'";

        if (!empty($data['filter_firstname'])) {
            $sql .= " AND firstname LIKE '%" . $this->db->escape($data['filter_firstname']) . "%'";
        }

        if (!empty($data['filter_lastname'])) {
            $sql .= " AND lastname LIKE '%" . $this->db->escape($data['filter_lastname']) . "%'";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCalendarTime($indicator)
    {
        if ($indicator == 'min') {
            $sql = "SELECT DISTINCT(start_time) AS distinct_time FROM " . DB_PREFIX . "appointment_availability_time";
        } else {
            $sql = "SELECT DISTINCT(end_time) AS distinct_time FROM " . DB_PREFIX . "appointment_availability_time";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomerDetail($customer_ic)
    {

        $sql = "SELECT * FROM oc_customer WHERE customer_ic = '" . $customer_ic . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function editcustomerdata($data)
    {
        $sql = "UPDATE oc_appointment SET 
        customer_id = '" . $data['customer_id'] . "'
        WHERE customer_ic = '" . $data['customer_ic'] . "'
        ";
        $this->db->query($sql);
    }

    public function addcustomerdata($data)
    {

        $insert_customer = false;
        $unique_id = md5(rand() . $data['customer_ic'] . time());
        $customer_row = $this->check_unique_id($unique_id);

        $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));

        // if (empty($data['customer_card'])) {
        $customer_card = $customer_card_no;
        $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'customer/customer', 'store' => $this->session->data['store_id']));
        // } else {
        //     $customer_card = $data['customer_card'];
        // }

        if (empty($customer_row)) {
            $insert_customer = true;
            $this->db->query("
                INSERT INTO " . DB_PREFIX . "customer SET
                    unique_customer_id = '" . $this->db->escape($unique_id) . "',
                    customer_group_id = '" . $this->db->escape($this->config->get('config_customer_group_id')) . "',
                    firstname = '" . $this->db->escape($data['customer_name']) . "',
                    lastname = '',
                    gender = '',
                    customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
                    customer_card = '" . $this->db->escape($customer_card) . "',
                    dob = '',
                    nationality = '',
                    marital_status = '',
                    religion = '',
                    race = '',
                    allergic = '',
                    diagnostic_history = '',
                    occupation = '',
                    email = '" . $this->db->escape($data['email']) . "',
                    telephone = '" . $this->db->escape($data['telephone']) . "',
                    telephone2 = '',
                    home = '',
                    fax = '',
                    custom_field = '',
                    newsletter = '',
                    salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
                        password = '',
                    status = '" . (int) $data['status'] . "',
                    approved = '" . (int) $data['approved'] . "',
                    safe = '" . (int) $data['safe'] . "',
                    add_by = '" . (int) $this->session->data['user_id'] . "',
                    date_added = NOW(),
                    date_modified = NOW()
            ");

            $customer_id = $this->db->getLastId();

            $this->db->query("UPDATE oc_appointment SET 
        customer_id = '" . $customer_id . "'
        WHERE customer_ic = '" . $data['customer_ic'] . "'
        ");
        }
    }

    public function updateAppointmentCustomerId($appointment_id, $new_customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . $new_customer_id . "'";

        $query = $this->db->query($sql);
        $customer_info = $query->row;
        $name = trim($customer_info['firstname'] . " " . $customer_info['lastname']);
        $customer_ic = $customer_info['customer_ic'];
        $email = $customer_info['email'];
        $telephone = $customer_info['telephone'];


        $sql = "
			UPDATE `oc_appointment`
			SET customer_id = '" . (int) $new_customer_id . "',
            customer_name = '" . $this->db->escape($name) . "',
            customer_ic = '" . $this->db->escape($customer_ic) . "',
            email = '" . $this->db->escape($email) . "',
            telephone = '" . $this->db->escape($telephone) . "'
			WHERE appointment_id = '" . (int) $appointment_id . "'";
        $query = $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function insertOrUpdateCustomer($appointment_id)
    {
        $app_info = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . (int)$appointment_id . "'")->row;

        if ($app_info['customer_id'] == '0') {
            //match using ic
            if (!empty($app_info['customer_ic'])) {
                $ic = str_replace(['-', ' '], '', $app_info['customer_ic']);
                $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(REPLACE(customer_ic, ' ', ''), '-', '') = '" . $this->db->escape($ic) . "' AND status = '1' ORDER BY customer_id DESC")->row;
                if (!empty($match_active_customer)) {
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$match_active_customer['customer_id'] . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                } else {
                    //check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(REPLACE(customer_ic, ' ', ''), '-', '') = '" . $this->db->escape($ic) . "' AND status = '0' ORDER BY customer_id DESC")->row;

                    if (!empty($match_inactive_customer)) {
                        //switch customer to status
                        $this->db->query("UPDATE " . DB_PREFIX . "customer SET status = '1' WHERE customer_id = '" . (int)$match_inactive_customer['customer_id'] . "'");

                        //update app's customer_id
                        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$match_inactive_customer['customer_id'] . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    } else {
                        //create as new customer
                        $data = [
                            'store_id'      => $app_info['store_id'],
                            'customer_ic'   => $app_info['customer_ic'],
                            'customer_name'     => $app_info['customer_name'],
                            'telephone'    => $app_info['telephone'],
                            'email'         => $app_info['email']
                        ];
                        $customer_id = $this->addcustomerdata($data);
                        //update app's customer_id
                        $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    }
                }
            }
            //match using phone number
            elseif (!empty($app_info['telephone'])) {
                $phone = str_replace('+', '', $app_info['telephone']);
                $customer_id = 0;
                $active_customer = true;

                // 1.check for phone number without '+'
                /// 1.1check for active customer
                $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, '+', '') = '" . $this->db->escape($phone) . "' AND status = '1' ORDER BY customer_id DESC")->row;

                if (!empty($match_active_customer)) {
                    $customer_id = $match_active_customer['customer_id'];
                }

                if (empty($customer_id)) {
                    /// 1.2check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, '+', '') = '" . $this->db->escape($phone) . "' AND status = '0' ORDER BY customer_id DESC")->row;
                    if (!empty($match_inactive_customer)) {
                        $customer_id = $match_inactive_customer['customer_id'];
                        $active_customer = false;
                    }
                }

                //2.check for phone number start with zero(malaysia case) (017401XXXXX)
                if (substr($phone, 0, 2) == '60') {
                    $phone = ltrim($phone, '60');
                    $phone = "0" . $phone;
                }

                if (empty($customer_id)) {
                    /// 2.1check for active customer
                    $match_active_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($phone) . "' AND status = '1' ORDER BY customer_id DESC")->row;
                    if (!empty($match_active_customer)) {
                        $customer_id = $match_active_customer['customer_id'];
                    }
                }
                if (empty($customer_id)) {
                    /// 2.2check for inactive customer
                    $match_inactive_customer = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($phone) . "' AND status = '0' ORDER BY customer_id DESC")->row;
                    if (!empty($match_inactive_customer)) {
                        $customer_id = $match_inactive_customer['customer_id'];
                        $active_customer = false;
                    }
                }

                //end matching
                if (!empty($customer_id)) {
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                    if (!$active_customer) {
                        //switch customer to status
                        $this->db->query("UPDATE " . DB_PREFIX . "customer SET status = '1' WHERE customer_id = '" . (int)$customer_id . "'");
                    }
                } else {
                    $data = [
                        'store_id'      => $app_info['store_id'],
                        'customer_ic'   => $app_info['customer_ic'],
                        'customer_name'     => $app_info['customer_name'],
                        'telephone'    => $app_info['telephone'],
                        'email'         => $app_info['email']
                    ];
                    $customer_id = $this->addcustomerdata($data);
                    //update app's customer_id
                    $this->db->query("UPDATE " . DB_PREFIX . "appointment SET customer_id = '" . (int)$customer_id . "' WHERE appointment_id = '" . (int)$appointment_id . "'");
                }
            }
        }
    }

    public function getDoctorAvailabilityTimes($doctor_id, $store_id, $day)
    {
        $sql = "
		SELECT
            aat.availability_time_id,
            aat.availability_id,
            aa.doctor_id,
            aa.store_id,
            aa.day,
			aat.start_time AS start,
			aat.end_time AS end
		FROM " . DB_PREFIX . "appointment_availability aa
		LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat
		ON (aa.availability_id = aat.availability_id)
		WHERE 1
		AND aa.doctor_id = '" . (int) $doctor_id . "'
        AND aa.store_id = '" . (int) $store_id . "'
		AND aa.day = '" . $this->db->escape($day) . "'
		ORDER BY aat.availability_time_id ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceFacilities($store_id, $service_id, $day)
    {
        $facilities = [];
        $sql24hours = "SELECT sf.*,
         sfa.id AS facility_time_id,
         sfa.day,
         sfa.start_time,
         sfa.end_time,
         sstf.service_id
        FROM `oc_facility` sf 
        LEFT JOIN `oc_facility_availability` sfa ON (sf.facility_id = sfa.facility_id) 
        LEFT JOIN `oc_service_to_facility` sstf ON (sf.facility_id = sstf.facility_id) 
        WHERE 1  AND sf.store_id = '" . (int)$store_id . "' AND sstf.service_id = '" . (int)$service_id . "' AND sf.status = 1 AND sf.available = 1 ORDER BY `sf`.`facility_id` ASC";
        $query24hours = $this->db->query($sql24hours);

        $sqlbyday = "SELECT sf.*,
         sfa.id AS facility_time_id,
         sfa.day,
         sfa.start_time,
         sfa.end_time,
         sstf.service_id
        FROM `oc_facility` sf 
        LEFT JOIN `oc_facility_availability` sfa ON (sf.facility_id = sfa.facility_id) 
        LEFT JOIN `oc_service_to_facility` sstf ON (sf.facility_id = sstf.facility_id) 
        WHERE 1  AND sf.store_id = '" . (int)$store_id . "' AND sstf.service_id = '" . (int)$service_id . "' AND sfa.day = '" . $this->db->escape($day) . "' AND sf.status = 1 AND sf.available = 0 ORDER BY `sf`.`facility_id` ASC";
        $querybyday = $this->db->query($sqlbyday);

        $facilities = array_merge($query24hours->rows, $querybyday->rows);
        return $facilities;
    }

    public function get_service_duration($service_id)
    {
        $sql = "SELECT cs_minute FROM " . DB_PREFIX . "clinical_service  WHERE clinicalservice_id = '" . (int)$service_id . "'";

        $query = $this->db->query($sql);

        return $query->row['cs_minute'];
    }

    public function get_service_type($service_id)
    {
        $sql = "SELECT type FROM " . DB_PREFIX . "clinical_service  WHERE clinicalservice_id = '" . (int)$service_id . "'";

        $query = $this->db->query($sql);

        return $query->row['type'];
    }
}
