<?php

class ControllerUserUser extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');

        $this->getList();

        $this->releaseUpdates();

    }

    protected function releaseUpdates()
    {

        $sql=" CREATE TABLE IF NOT EXISTS `oc_user_to_services` (
            `user_id` varchar(255) NOT NULL,
            `service_id` varchar(255) NOT NULL
          ) ENGINE=InnoDB DEFAULT CHARSET=utf8
          ";

        $this->db->query($sql);
    }

    public function add()
    {
        $this->load->language('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');
        $this->load->model('user/user_description');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $user_id = $this->model_user_user_description->addUser($this->request->post);

            // if (isset($this->request->post['update_etcm'])) {
            //     $api_data = [
            //         'hosting' => HTTP_CATALOG,
            //         'user_id' => $user_id,
            //         'position' => $this->request->post['position'],
            //         'firstname' => $this->request->post['firstname'],
            //         'lastname' => $this->request->post['lastname'],
            //         'chinesename' => $this->request->post['chinesename'],
            //         'telephone' => $this->request->post['contactno'],
            //         'gender' => $this->request->post['gender'],
            //         'enable_appointment' => $this->request->post['enable_appointment']
            //     ];

            //     $user_info = $this->model_user_user->getUser($user_id);

            //     if (!empty($user_info)) {
            //         $image = $user_info['image'];

            //         if (!empty($image)) {
            //             $doctor_image_json = file_get_contents(HTTP_CATALOG . 'index.php?route=etcm/image/doctor_image&user_id=' . $user_id);

            //             $doctor_image_arr = json_decode($doctor_image_json, true);
            //             $api_data['image'] = $doctor_image_arr['image'];
            //         } else {
            //             $api_data['image'] = '';
            //         }

            //         $api_response = json_decode($this->etcm_save_user($api_data), true);

            //         if ($api_response['error'] == 0) {
            //             $this->session->data['success'] = $this->language->get('text_success');
            //         } else {
            //             $this->session->data['fail_save'] = $this->language->get('text_fail_save');
            //         }
            //     }
            // } else {
            //     $this->session->data['success'] = $this->language->get('text_success');
            // }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');
        $this->load->model('user/user_holiday');
        $this->load->model('user/user_description');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_user_user->editUser($this->request->get['user_id'], $this->request->post);
            $this->model_user_user_holiday->addHolidays($this->request->get['user_id'], $this->request->post);
            $this->model_user_user_description->addDoctorDescription($this->request->get['user_id'], $this->request->post);
            $this->model_user_user_description->addDoctorTreatments($this->request->get['user_id'], $this->request->post);
            $this->model_user_user->UpdateDoctorService($this->request->get['user_id'], $this->request->post);

            // if (isset($this->request->post['update_etcm'])) {
            //     $api_data = [
            //         'hosting' => HTTP_CATALOG,
            //         'user_id' => $this->request->get['user_id'],
            //         'position' => $this->request->post['position'],
            //         'firstname' => $this->request->post['firstname'],
            //         'lastname' => $this->request->post['lastname'],
            //         'chinesename' => $this->request->post['chinesename'],
            //         'telephone' => $this->request->post['contactno'],
            //         'gender' => $this->request->post['gender'],
            //         'enable_appointment' => $this->request->post['enable_appointment']
            //     ];

            //     $user_info = $this->model_user_user->getUser($this->request->get['user_id']);

            //     if (!empty($user_info)) {
            //         $image = $user_info['image'];

            //         if (!empty($image)) {
            //             $doctor_image_json = file_get_contents(HTTP_CATALOG . 'index.php?route=etcm/image/doctor_image&user_id=' . $this->request->get['user_id']);

            //             $doctor_image_arr = json_decode($doctor_image_json, true);
            //             $api_data['image'] = $doctor_image_arr['image'];
            //         } else {
            //             $api_data['image'] = '';
            //         }

            //         $api_response = json_decode($this->etcm_save_user($api_data), true);

            //         if ($api_response['error'] == 0) {
            //             $this->session->data['success'] = $this->language->get('text_success');
            //         } else {
            //             $this->session->data['fail_save'] = $this->language->get('text_fail_save');
            //         }
            //     }
            //     $this->session->data['success'] = $this->language->get('text_success');
            // } else {
            //     $this->session->data['success'] = $this->language->get('text_success');
            // }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');


            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');
        $this->load->model('user/user_holiday');
        $this->load->model('user/user_description');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $user_id) {
                $user_info = $this->model_user_user->getUser($user_id);

                if (!empty($user_info)) {
                    // if ($user_info['position'] == '2') {
                    //     $api_data = [
                    //         'hosting' => HTTP_CATALOG,
                    //         'user_id' => $user_id
                    //     ];

                    //     $api_response = json_decode($this->etcm_delete_user($api_data), true);

                    //     if ($api_response['error'] == 0) {
                    //         $this->model_user_user->deleteUser($user_id);
                    //         $this->model_user_user_holiday->deleteHolidays($user_id);
                    //         $this->model_user_user_description->deleteDoctorDescription($user_id);
                    //         $this->model_user_user_description->deleteDoctorTreatments($user_id);

                    //         $this->session->data['success'] = $this->language->get('text_success');
                    //     } else {
                    //         $this->session->data['fail_save'] = $this->language->get('text_fail_save');
                    //     }
                    // } else {
                    $this->model_user_user->deleteUser($user_id);
                    $this->model_user_user_holiday->deleteHolidays($user_id);
                    $this->model_user_user_description->deleteDoctorDescription($user_id);
                    $this->model_user_user_description->deleteDoctorTreatments($user_id);

                    $this->session->data['success'] = $this->language->get('text_success');
                    // }
                }
            }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function userList()
    {
        $this->load->language('openwindow/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user_description');

        if (isset($this->request->get['clinicalservice_id'])) {
            $clinicalservice_id = $this->request->get['clinicalservice_id'];
        } else {
            $clinicalservice_id = 'username';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'username';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['clinicalservice_id'])) {
            $url .= '&clinicalservice_id=' . $this->request->get['clinicalservice_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['users'] = array();

        $filter_data = array(
            'clinicalservice_id' => $clinicalservice_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $user_total = $this->model_user_user_description->getTotalServiceDoctor($filter_data);

        $results = $this->model_user_user_description->getServiceDoctor($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['users'][] = array(
                    'user_id' => $result['user_id'],
                    'username' => $result['username'],
                    'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'edit' => $this->url->link('user/user/edit', 'user_token=' . $this->session->data['user_token'] . '&user_id=' . $result['user_id'] . $url, true)
                );
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $pagination = new Pagination();
        $pagination->total = $user_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($user_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($user_total - $this->config->get('config_limit_admin'))) ? $user_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $user_total, ceil($user_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/user_list', $data));
    }

    public function userListforPurchase()
    {
        $this->load->language('openwindow/user');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('user/user');

        if (isset($this->request->get['user_id'])) {
            $user_id = $this->request->get['user_id'];
        } else {
            $user_id = 'user_name';
        }

        if (isset($this->request->get['filter_user_name'])) {
            $filter_user_name = $this->request->get['filter_user_name'];
        } else {
            $filter_user_name = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'user_name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['user_id'])) {
            $url .= '&user_id=' . $this->request->get['user_id'];
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['users'] = array();

        $filter_data = array(
            'filter_user_name' => $filter_user_name,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $user_total = $this->model_user_user->getTotalUsers();

        $results = $this->model_user_user->getUserforPurchase($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $data['users'][] = array(
                    'user_id' => $result['user_id'],
                    'username' => $result['user_name'],
                    'status' => ($result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled')),
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'edit' => $this->url->link('user/user/edit', 'user_token=' . $this->session->data['user_token'] . '&user_id=' . $result['user_id'] . $url, true)
                );
            }
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_user_name'])) {
            $url .= '&filter_user_name=' . urlencode(html_entity_decode($this->request->get['filter_user_name'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $pagination = new Pagination();
        $pagination->total = $user_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $url = '';

        if (isset($this->request->get['filter_user_name'])) {
            $url .= '&filter_user_name=' . $this->request->get['filter_user_name'];
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($user_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($user_total - $this->config->get('config_limit_admin'))) ? $user_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $user_total, ceil($user_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/user_list_purchase', $data));
    }

    protected function getList()
    {
        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'username';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('user/user/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('user/user/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['users'] = array();

        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $user_total = $this->model_user_user->getTotalUsers();
        $results = $this->model_user_user->getUsers($filter_data);


        foreach ($results as $result) {
                $position = ($result['position'] == 1) ? $this->language->get('filed_staff') : $this->language->get('filed_doctor');

            $data['users'][] = array(
                'user_id' => $result['user_id'],
                'username' => $result['username'],
                'user_groupname' => $result['name'],
                'status' => $result['status'],
                'position' => $position,
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'periodfrom' => date($this->language->get('date_format_short'), strtotime($result['periodfrom'])),
                'periodto' => date($this->language->get('date_format_short'), strtotime($result['periodto'])),
                'edit' => $this->url->link('user/user/edit', 'user_token=' . $this->session->data['user_token'] . '&user_id=' . $result['user_id'] . $url, true)
            );
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->session->data['fail_save'])) {
            $data['fail_save'] = $this->session->data['fail_save'];
            unset($this->session->data['fail_save']);
        } else {
            $data['fail_save'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_username'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . '&sort=username' . $url, true);
        $data['sort_status'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_date_added'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
        $data['sort_periodfrom'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . '&sort=periodfrom' . $url, true);
        $data['sort_periodto'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . '&sort=periodto' . $url, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $user_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($user_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($user_total - $this->config->get('config_limit_admin'))) ? $user_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $user_total, ceil($user_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('user/user_list', $data));
    }

    protected function getForm()
    {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['user_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['username'])) {
            $data['error_username'] = $this->error['username'];
        } else {
            $data['error_username'] = '';
        }

        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['lastname'])) {
            $data['error_lastname'] = $this->error['lastname'];
        } else {
            $data['error_lastname'] = '';
        }

        if (isset($this->error['dob'])) {
            $data['error_dob'] = $this->error['dob'];
        } else {
            $data['error_dob'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        if (isset($this->error['ic'])) {
            $data['error_ic'] = $this->error['ic'];
        } else {
            $data['error_ic'] = '';
        }

        if (isset($this->error['contactno'])) {
            $data['error_contactno'] = $this->error['contactno'];
        } else {
            $data['error_contactno'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['salary'])) {
            $data['error_salary'] = $this->error['salary'];
        } else {
            $data['error_salary'] = '';
        }

        if (isset($this->error['consultationprice'])) {
            $data['error_consultationprice'] = $this->error['consultationprice'];
        } else {
            $data['error_consultationprice'] = '';
        }

        if (isset($this->error['periodfrom'])) {
            $data['error_periodfrom'] = $this->error['periodfrom'];
        } else {
            $data['error_periodfrom'] = '';
        }

        if (isset($this->error['periodto'])) {
            $data['error_periodto'] = $this->error['periodto'];
        } else {
            $data['error_periodto'] = '';
        }

        if (isset($this->error['doctor_sort_order'])) {
            $data['error_doctor_sort_order'] = $this->error['doctor_sort_order'];
        } else {
            $data['error_doctor_sort_order'] = '';
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['user_id'])) {
            $data['action'] = $this->url->link('user/user/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
            $data['user_type'] = 'add';
        } else {
            $data['action'] = $this->url->link('user/user/edit', 'user_token=' . $this->session->data['user_token'] . '&user_id=' . $this->request->get['user_id'] . $url, true);
            $data['user_type'] = 'edit';
        }

        $data['cancel'] = $this->url->link('user/user', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['enable_doctor_description'] = false;

        if (isset($this->request->get['user_id'])) {
            $user_id = $this->request->get['user_id'];
            $doctor_id = $this->model_user_user->getDoctor($user_id);

            if (isset($doctor_id['user_id'])) {
                $data['all_services'] = $this->model_user_user->getAllService();
                $data['services'] = $this->model_user_user->getService();
                $data['doctor_services'] = [];

                // Only get the services list related to the doctor.
                foreach ($data['services'] as $service) {
                    $doctor_ids = unserialize($service['doctor_id']);

                    if (in_array($doctor_id['user_id'], $doctor_ids)) {
                        $data['doctor_services'][] = $service['clinicalservice_id'];
                    }
                }
            } else {
                $doctor_id['user_id'] = '';
            }
        } else {
            $user_id = '';


        }


        if(!empty($user_id)) {
            $data['user_id']= $this->request->get['user_id'];
        } else {
            $data['user_id']= '';
        }

        // $doctor_id = $this->model_user_user->getDoctor($this->request->get['user_id']);

        // $data['all_services'] = $this->model_user_user->getAllService();

        // $data['services'] = $this->model_user_user->getService();

        // $data['doctor_services'] = [];
        // // Only get the services list related to the doctor.
        //         foreach ($data['services'] as $service) {
        //             $doctor_ids = unserialize($service['doctor_id']);


        //             if (in_array($doctor_id['user_id'], $doctor_ids)) {
        //                 $data['doctor_services'][].= $service['clinicalservice_id'];
        //             }
        //         }

        $this->load->model('appointment/appointment_availability');

        $data['days'] = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];

        if($user_id) {
            $data['services'] = $this->model_appointment_appointment_availability->get_clinical_service($user_id);

        }

        foreach ($data['days'] as $day) {
            $availability_infos = $this->model_appointment_appointment_availability->getAvailability($user_id, $day);

            if(!empty($availability_infos['availability_id'])) {
                $availability_id = $availability_infos['availability_id'];
            } else {
                $availability_id = '';

            }

            $availability_times = $this->model_appointment_appointment_availability->getAvailabilityTimes($availability_id);
            $time=[];
            $product_count = 0 ;

            foreach ($availability_times as $availability_time) {
                $time[]=[
                    'start_time' => $availability_time['start_time'],
                    'end_time' => $availability_time['end_time'],
                    'num_app' => $availability_time['num_app'],
                    'enable_num_app' => $availability_time['enable_num_app']
                ];
                $product_count++ ;
                $data['product_count']  = $product_count ;

            }
            // echo"<pre>";
            // print_r($availability_times);
            // echo"</pre>";
            $availability_services = $this->model_appointment_appointment_availability->getAvailabilityService($availability_id);
            $service='';
            foreach ($availability_services as $availability_service) {
                $service[]=
                   $availability_service['service_id']
                ;
            }

            $a[] = [
                'clinical_day' => $day,
                'service' => $service,
                'times' => $time,
            ];


        }

        if (isset($this->request->post['availability_times'])) {
            $data['availability_times'] = $this->request->post['availability_times'];
        } elseif (!empty($a)) {
            $data['availability_times'] = $a;
        } else {
            $data['availability_times'] = array();
        }


        if (isset($this->request->get['user_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $user_info = $this->model_user_user->getUser($this->request->get['user_id']);

            if ($user_info['position'] == '2') {
                $doctor_description_info = $this->model_user_user_description->getDoctorDescription($this->request->get['user_id']);
                $doctor_treatment_info = $this->model_user_user_description->getDoctorTreatments($this->request->get['user_id']);

                $data['enable_doctor_description'] = true;
            } else {
                $data['treatment_row'] = 0;
            }
        } else {
            $data['holiday_row'] = 0;
            $data['treatment_row'] = 0;
        }

        if (isset($this->request->post['username'])) {
            $data['username'] = $this->request->post['username'];
        } elseif (!empty($user_info)) {
            $data['username'] = $user_info['username'];
        } else {
            $data['username'] = '';
        }

        if (isset($this->request->post['user_group_id'])) {
            $data['user_group_id'] = $this->request->post['user_group_id'];
        } elseif (!empty($user_info)) {
            $data['user_group_id'] = $user_info['user_group_id'];
        } else {
            $data['user_group_id'] = '';
        }

        $this->load->model('user/user_group');
        $data['user_groups'] = $this->model_user_user_group->getUserGroups();

        $this->load->model('setting/store');
        $data['stores'] = $this->model_setting_store->getAllStores();

        if (isset($this->request->post['user_store'])) {
            $data['user_store'] = $this->request->post['user_store'];
        } elseif (isset($this->request->get['user_id'])) {
            $data['user_store'] = $this->model_user_user->getUserStores($this->request->get['user_id']);
        } else {
            $data['user_store'] = array();
        }

        $sessionStoreId = $this->session->data['store_id'];
        $data['session_store_id'] = $sessionStoreId;
        if (!in_array($sessionStoreId, $data['user_store'])) {
            $data['user_store'][] = $sessionStoreId;
        }

        $ignore = array(
            'common/dashboard',
            'common/startup',
            'common/login',
            'common/logout',
            'common/forgotten',
            'common/reset',
            'common/language',
            'error/not_found',
            'error/permission',
            'common/footer',
            'common/header'
        );

        $data['permissions'] = array();

        $files = glob(DIR_APPLICATION . 'controller/*/*.php');

        foreach ($files as $file) {
            $part = explode('/', dirname($file));

            $permission = end($part) . '/' . basename($file, '.php');

            if (!in_array($permission, $ignore)) {
                $data['permissions'][] = $permission;
            }
        }

        if (isset($this->request->get['user_id'])) {
            $user_group_info['permission'] = $this->model_user_user->getUserPermission($this->request->get['user_id']);
        } else {
            $user_group_info['permission'] = '';
        }

        if (isset($this->request->post['permission']['access'])) {
            $data['access'] = $this->request->post['permission']['access'];
        } elseif (isset($user_group_info['permission']['access'])) {
            $data['access'] = $user_group_info['permission']['access'];
        } else {
            $data['access'] = array();
        }

        if (isset($this->request->post['permission']['modify'])) {
            $data['modify'] = $this->request->post['permission']['modify'];
        } elseif (isset($user_group_info['permission']['modify'])) {
            $data['modify'] = $user_group_info['permission']['modify'];
        } else {
            $data['modify'] = array();
        }

        if (isset($this->request->post['permission']['delete'])) {
            $data['delete'] = $this->request->post['permission']['delete'];
        } elseif (isset($user_group_info['permission']['delete'])) {
            $data['delete'] = $user_group_info['permission']['delete'];
        } else {
            $data['delete'] = array();
        }

        if (isset($this->request->post['permission']['print'])) {
            $data['print'] = $this->request->post['permission']['print'];
        } elseif (isset($user_group_info['permission']['print'])) {
            $data['print'] = $user_group_info['permission']['print'];
        } else {
            $data['print'] = array();
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } elseif (!empty($user_info)) {
            $data['firstname'] = $user_info['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } elseif (!empty($user_info)) {
            $data['lastname'] = $user_info['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['chinesename'])) {
            $data['chinesename'] = $this->request->post['chinesename'];
        } elseif (!empty($user_info)) {
            $data['chinesename'] = $user_info['chinesename'];
        } else {
            $data['chinesename'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } elseif (!empty($user_info)) {
            $data['gender'] = $user_info['gender'];
        } else {
            $data['gender'] = '';
        }

        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } elseif (!empty($user_info)) {
            $data['dob'] = $user_info['dob'];
        } else {
            $data['dob'] = '';
        }

        if (isset($this->request->post['maritalstatus'])) {
            $data['maritalstatus'] = $this->request->post['maritalstatus'];
        } elseif (!empty($user_info)) {
            $data['maritalstatus'] = $user_info['maritalstatus'];
        } else {
            $data['maritalstatus'] = '';
        }

        if (isset($this->request->post['race'])) {
            $data['race'] = $this->request->post['race'];
        } elseif (!empty($user_info)) {
            $data['race'] = $user_info['race'];
        } else {
            $data['race'] = '';
        }

        if (isset($this->request->post['address'])) {
            $data['address'] = $this->request->post['address'];
        } elseif (!empty($user_info)) {

            $data['address'] = $user_info['address'];
        } else {
            $data['address'] = '';
        }

        if (isset($this->request->post['ic'])) {
            $data['ic'] = $this->request->post['ic'];
        } elseif (!empty($user_info)) {
            $data['ic'] = $user_info['ic'];
        } else {
            $data['ic'] = '';
        }

        if (isset($this->request->post['contactno'])) {
            $data['contactno'] = $this->request->post['contactno'];
        } elseif (!empty($user_info)) {
            $data['contactno'] = $user_info['contactno'];
        } else {
            $data['contactno'] = '';
        }

        if (isset($this->request->post['salary'])) {
            $data['salary'] = $this->request->post['salary'];
        } elseif (!empty($user_info)) {
            $data['salary'] = $user_info['salary'];
        } else {
            $data['salary'] = '';
        }

        if (isset($this->request->post['position'])) {
            $data['position'] = $this->request->post['position'];
        } elseif (!empty($user_info)) {
            $data['position'] = $user_info['position'];
        } else {
            $data['position'] = 1;
        }

        if (isset($this->request->post['enable_appointment'])) {
            $data['enable_appointment'] = $this->request->post['enable_appointment'];
        } elseif (!empty($user_info)) {
            $data['enable_appointment'] = $user_info['enable_appointment'];
        } else {
            $data['enable_appointment'] = 0;
        }

        if (isset($this->request->post['show_for_appointment'])) {
            $data['show_for_appointment'] = $this->request->post['show_for_appointment'];
        } elseif (!empty($user_info)) {
            $data['show_for_appointment'] = $user_info['show_for_appointment'];
        } else {
            $data['show_for_appointment'] = 0;
        }

        if (isset($this->request->post['enable_consultation_price'])) {
            $data['enable_consultation_price'] = $this->request->post['enable_consultation_price'];
        } elseif (!empty($user_info)) {
            $data['enable_consultation_price'] = $user_info['enable_consultation_price'];
        } else {
            $data['enable_consultation_price'] = 0;
        }

        if (isset($this->request->post['consultationprice'])) {
            $data['consultationprice'] = $this->request->post['consultationprice'];
        } elseif (!empty($user_info)) {
            $data['consultationprice'] = $user_info['consultationprice'];
        } else {
            $data['consultationprice'] = '';
        }

        if (isset($this->request->post['doctor_sort_order'])) {
            $data['doctor_sort_order'] = $this->request->post['doctor_sort_order'];
        } elseif (!empty($user_info)) {
            $data['doctor_sort_order'] = $user_info['doctor_sort_order'];
        } else {
            $data['doctor_sort_order'] = '';
        }

        $this->load->model('localisation/tax_class');

        $data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

        if (isset($this->request->post['tax_class_id'])) {
            $data['tax_class_id'] = $this->request->post['tax_class_id'];
        } elseif (!empty($user_info)) {
            $data['tax_class_id'] = $user_info['tax_class_id'];
        } else {
            $data['tax_class_id'] = 0;
        }

        if (isset($this->request->post['qualification'])) {
            $data['qualification'] = $this->request->post['qualification'];
        } elseif (!empty($user_info)) {
            $data['qualification'] = $user_info['qualification'];
        } else {
            $data['qualification'] = '';
        }

        if (isset($this->request->post['periodfrom'])) {
            $data['periodfrom'] = $this->request->post['periodfrom'];
        } elseif (!empty($user_info)) {
            $data['periodfrom'] = $user_info['periodfrom'];
        } else {
            $data['periodfrom'] = '2000-01-01';
        }

        if (isset($this->request->post['periodto'])) {
            $data['periodto'] = $this->request->post['periodto'];
        } elseif (!empty($user_info)) {
            $data['periodto'] = $user_info['periodto'];
        } else {
            $data['periodto'] = '2999-12-31';
        }

        if (isset($this->request->post['viewalldata'])) {
            $data['viewalldata'] = $this->request->post['viewalldata'];
        } elseif (!empty($user_info)) {
            $data['viewalldata'] = $user_info['viewalldata'];
        } else {
            $data['viewalldata'] = '';
        }

        if (isset($this->request->post['remark'])) {
            $data['remark'] = $this->request->post['remark'];
        } elseif (!empty($user_info)) {
            $data['remark'] = $user_info['remark'];
        } else {
            $data['remark'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } elseif (!empty($user_info)) {
            $data['email'] = $user_info['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['image'])) {
            $data['image'] = $this->request->post['image'];
        } elseif (!empty($user_info)) {
            $data['image'] = $user_info['image'];
        } else {
            $data['image'] = '';
        }

        $this->load->model('tool/image');

        if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 100, 100);
        } elseif (!empty($user_info) && $user_info['image'] && is_file(DIR_IMAGE . $user_info['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($user_info['image'], 100, 100);
        } else {
            $data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($user_info)) {
            $data['status'] = $user_info['status'];
        } else {
            $data['status'] = 1;
        }

        if (isset($this->request->post['holidays'])) {
            $data['holidays'] = $this->request->post['holidays'];
        } elseif (!empty($user_info)) {
            $data['holidays'] = $this->model_user_user_holiday->getUserHolidays($this->request->get['user_id']);
        } else {
            $data['holidays'] = array();
        }

        if (isset($this->request->post['doctor_position'])) {
            $data['doctor_position'] = $this->request->post['doctor_position'];
        } elseif (!empty($doctor_description_info)) {
            $data['doctor_position'] = $doctor_description_info['position'];
        } else {
            $data['doctor_position'] = '';
        }

        if (isset($this->request->post['doctor_profession'])) {
            $data['doctor_profession'] = $this->request->post['doctor_profession'];
        } elseif (!empty($doctor_description_info)) {
            $data['doctor_profession'] = unserialize($doctor_description_info['professions']);
        } else {
            $data['doctor_profession'] = [];
        }

        if (isset($this->request->post['doctor_service'])) {
            $data['doctor_service'] = $this->request->post['doctor_service'];
        } elseif (!empty($doctor_description_info)) {
            $data['doctor_service'] = unserialize($doctor_description_info['professions']);
        } else {
            $data['doctor_service'] = [];
        }

        if (isset($this->request->post['other_professions'])) {
            $data['other_professions'] = $this->request->post['other_professions'];
        } elseif (!empty($doctor_description_info)) {
            $data['other_professions'] = $doctor_description_info['other_professions'];
        } else {
            $data['other_professions'] = '';
        }

        if (isset($this->request->post['doctor_description'])) {
            $data['doctor_description'] = $this->request->post['doctor_description'];
        } elseif (!empty($doctor_description_info)) {
            $data['doctor_description'] = $doctor_description_info['description'];
        } else {
            $data['doctor_description'] = '';
        }

        if (isset($this->request->post['treatments'])) {
            $data['treatments'] = $this->request->post['holidays'];
        } elseif (!empty($doctor_treatment_info)) {
            $data['treatments'] = $doctor_treatment_info;
        } else {
            $data['treatments'] = array();
        }

        $data['etcm_professions'] = $this->getEtcmProfessionCategory();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        // var_dump($data['user_id']);


        $this->response->setOutput($this->load->view('user/user_form', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'user/user') && !$this->user->userPermissions('modify', 'user/user')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ((utf8_strlen($this->request->post['username']) < 3) || (utf8_strlen($this->request->post['username']) > 20)) {
            $this->error['username'] = $this->language->get('error_username');
        }

        $user_info = $this->model_user_user->getUserByUsername($this->request->post['username']);

        if (!isset($this->request->get['user_id'])) {
            if ($user_info) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        } else {
            if ($user_info && ($this->request->get['user_id'] != $user_info['user_id'])) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        }

        if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
            $this->error['firstname'] = $this->language->get('error_firstname');
        }

        // if (empty($this->request->post['dob'])) {
        //     $this->error['dob'] = $this->language->get('error_dob');
        // }

        if (empty($this->request->post['email']) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
            $this->error['email'] = $this->language->get('error_email');
        }

        // if (empty($this->request->post['ic'])) {
        //     $this->error['ic'] = $this->language->get('error_ic');
        // }

        $user_info = $this->model_user_user->getUserByIc($this->request->post['ic']);

        // if (!isset($this->request->get['user_id'])) {
        //     if ($user_info) {
        //         $this->error['warning'] = $this->language->get('error_ic_exists');
        //     }
        // } else {
        //     if ($user_info && ($this->request->get['user_id'] != $user_info['user_id'])) {
        //         $this->error['warning'] = $this->language->get('error_ic_exists');
        //     }
        // }

        if (empty($this->request->post['contactno'])) {
            $this->error['contactno'] = $this->language->get('error_contactno');
        } else {
            $user_info = $this->model_user_user->getUserByContactno($this->request->post['contactno']);
            if (!isset($this->request->get['user_id'])) {
                if ($user_info) {
                    $this->error['warning'] = $this->language->get('error_contactno_exists');
                }
            } else {
                if ($user_info && ($this->request->get['user_id'] != $user_info['user_id'])) {
                    $this->error['warning'] = $this->language->get('error_contactno_exists');
                }
            }
        }



        if (empty($this->request->post['periodfrom'])) {
            $this->error['periodfrom'] = $this->language->get('error_periodfrom');
        }

        if (empty($this->request->post['periodto'])) {
            $this->error['periodto'] = $this->language->get('error_periodto');
        }

        // if ($this->request->post['position'] == 2 && empty($this->request->post['consultationprice'])) {
        //     $this->error['consultationprice'] = $this->language->get('error_consultationprice');
        // }

        // if ($this->request->post['position'] == 2 && strlen($this->request->post['doctor_sort_order']) < 1) {
        //     $this->error['doctor_sort_order'] = $this->language->get('error_doctor_sort_order');
        // }

        if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
            $this->error['lastname'] = $this->language->get('error_lastname');
        }

        if ($this->request->post['password'] || (!isset($this->request->get['user_id']))) {
            if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
                $this->error['password'] = $this->language->get('error_password');
            }

            if ($this->request->post['password'] != $this->request->post['confirm']) {
                $this->error['confirm'] = $this->language->get('error_confirm');
            }
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('delete', 'user/user') && !$this->user->userPermissions('delete', 'user/user')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['selected'] as $user_id) {
            if ($this->user->getId() == $user_id) {
                $this->error['warning'] = $this->language->get('error_account');
            }
        }

        return !$this->error;
    }

    private function getEtcmProfessionCategory()
    {
        $etcm_profession_category_final_arr = [];

        $etcm_url = HTTP_API . 'index.php?route=etcm/store_doctor/get_profession_categories&language=' . $this->session->data['language'];

        $etcm_profession_category_json = file_get_contents($etcm_url);
        $etcm_profession_category_arr = json_decode($etcm_profession_category_json, true);

        if (!empty($etcm_profession_category_arr['data'])) {
            $etcm_profession_category_final_arr = $etcm_profession_category_arr['data'];
        }

        return $etcm_profession_category_final_arr;
    }

    private function etcm_save_user($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'rest/api/shop/doctorapp/save_user';

        $post_data['push_data'] = [
            'hosting' => $data['hosting'],
            'user_id' => $data['user_id'],
            'position' => $data['position'],
            'image' => $data['image'],
            'firstname' => $data['firstname'],
            'lastname' => $data['lastname'],
            'chinesename' => $data['chinesename'],
            'telephone' => $data['telephone'],
            'gender' => $data['gender'],
            'enable_appointment' => $data['enable_appointment']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    private function etcm_delete_user($data)
    {
        $post_data = [];

        $api_url = HTTP_API . 'rest/api/shop/doctorapp/delete_user';

        $post_data['push_data'] = [
            'hosting' => $data['hosting'],
            'user_id' => $data['user_id']
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $api_url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data['push_data']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    protected function syncToEtcm()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        $db_users = $this->db->query("SELECT * FROM " . DB_PREFIX . "user")->rows;
        $users = [];
        foreach ($db_users as $user) {
            $user_desc = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user['user_id'] . "'")->row;
            $treatments = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user['user_id'] . "'")->rows;

            $image = !empty($user['image']) ? HTTPS_IMAGE . $user['image'] : '';
            $users[] = [
                'user_id'               => $user['user_id'],
                'firstname'             => $user['firstname'],
                'lastname'              => $user['lastname'],
                'chinesename'           => $user['chinesename'],
                'image'                 => $image,
                'telephone'             => $user['contactno'],
                'gender'                => $user['gender'],
                'user_position'         => $user['position'],
                'position'              => !empty($user_desc['position']) ? $user_desc['position'] : '',
                'professions'           => !empty($user_desc['professions']) ? $user_desc['professions'] : '',
                'description'           => !empty($user_desc['description']) ? $user_desc['description'] : '',
                'sort_order'            => $user['doctor_sort_order'],
                'enable_appointment'    => $user['enable_appointment'],
                'show_for_appointment'  => $user['show_for_appointment'],
                'status'                => $user['status'],
                'treatments'            => $treatments
            ];
        }
        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'doctor_holidays'  => $db_holidays,
            'users'     => $users
        ];

        $path = 'etcm/syncing/syncing/update_user';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }
}
