<?php

class ControllerSettingTransactionNo extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('setting/transaction_no');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/transaction_no');

        $this->getList();
    }

    public function add() {
        $this->load->language('setting/transaction_no');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/transaction_no');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_setting_transaction_no->addTransaction($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['module'])) {
                $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['prefix'])) {
                $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['store_id'])) {
                $url .= '&store_id=' . $this->request->get['store_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('setting/transaction_no');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/transaction_no');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_setting_transaction_no->editTransaction($this->request->get['transaction_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['module'])) {
                $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['prefix'])) {
                $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['store_id'])) {
                $url .= '&store_id=' . $this->request->get['store_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    protected function getList() {
        if (isset($this->request->get['module'])) {
            $module = $this->request->get['module'];
        } else {
            $module = null;
        }

        if (isset($this->request->get['prefix'])) {
            $prefix = $this->request->get['prefix'];
        } else {
            $prefix = null;
        }

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = (int) $store_id;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'module';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['module'])) {
            $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['prefix'])) {
            $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['store_id'])) {
            $url .= '&store_id=' . $this->request->get['store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('setting/transaction_no/add', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['products'] = array();

        $filter_data = array(
            'module' => $module,
            'prefix' => $prefix,
            'store_id' => $store_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['transaction'] = array();

        $product_total = $this->model_setting_transaction_no->getTotalTransactionNo($filter_data);
        $results = $this->model_setting_transaction_no->getTransactionNos($filter_data);

        foreach ($results as $result) {
            $data['transaction'][] = array(
                'transaction_no_id' => $result['transaction_no_id'],
                'module' => $result['module'],
                'prefix' => $result['prefix'],
                'running' => $result['prefix'] . str_pad($result['lastrunningno'], $result['length'], '0', STR_PAD_LEFT),
                'edit' => $this->url->link('setting/transaction_no/edit', 'user_token=' . $this->session->data['user_token'] . '&transaction_id=' . $result['transaction_no_id'] . $url, true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        $ignore = array(
            'common/dashboard',
            'common/startup',
            'common/login',
            'common/logout',
            'common/forgotten',
            'common/reset',
            'common/language',
            'error/not_found',
            'error/permission',
            'common/footer',
            'common/header'
        );

        $data['permissions'] = array();

        $files = glob(DIR_APPLICATION . 'controller/*/*.php');

        foreach ($files as $file) {
            $part = explode('/', dirname($file));
            $permission = end($part) . '/' . basename($file, '.php');    

            if (!in_array($permission, $ignore)) {
                $data['permissions'][] = $permission;
            }
        }

        $this->load->model('setting/store');

        $data['stores'] = $this->model_setting_store->getAllStores();

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['module'])) {
            $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['prefix'])) {
            $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['store_id'])) {
            $url .= '&store_id=' . $this->request->get['store_id'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_module'] = $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . '&sort=module' . $url, true);
        $data['sort_prefix'] = $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . '&sort=prefix' . $url, true);

        $url = '';

        if (isset($this->request->get['module'])) {
            $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['prefix'])) {
            $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['store_id'])) {
            $url .= '&store_id=' . $this->request->get['store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $product_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['module'] = $module;
        $data['prefix'] = $prefix;
        $data['store_id'] = $store_id;
        $data['sort'] = $sort;

        $data['user_view'] = $this->user->user_view;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/transaction_no_list', $data));
    }

    protected function getForm() {
        $data['text_form'] = !isset($this->request->get['transaction_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        if (isset($this->error['prefix'])) {
            $data['error_prefix'] = $this->error['prefix'];
        } else {
            $data['error_prefix'] = '';
        }

        if (isset($this->error['lastrunningno'])) {
            $data['error_lastrunningno'] = $this->error['lastrunningno'];
        } else {
            $data['error_lastrunningno'] = '';
        }

        if (isset($this->error['length'])) {
            $data['error_length'] = $this->error['length'];
        } else {
            $data['error_length'] = '';
        }

        $url = '';

        if (isset($this->request->get['module'])) {
            $url .= '&module=' . urlencode(html_entity_decode($this->request->get['module'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['prefix'])) {
            $url .= '&prefix=' . urlencode(html_entity_decode($this->request->get['prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_price'])) {
            $url .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['store_id'])) {
            $url .= '&store_id=' . $this->request->get['store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['transaction_id'])) {
            $data['action'] = $this->url->link('setting/transaction_no/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('setting/transaction_no/edit', 'user_token=' . $this->session->data['user_token'] . '&transaction_id=' . $this->request->get['transaction_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('setting/transaction_no', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['transaction_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $transaction_info = $this->model_setting_transaction_no->getTransactionNo($this->request->get['transaction_id']);
        }

        $data['user_token'] = $this->session->data['user_token'];

        $ignore = array(
            'common/dashboard',
            'common/startup',
            'common/login',
            'common/logout',
            'common/forgotten',
            'common/reset',
            'common/language',
            'error/not_found',
            'error/permission',
            'common/footer',
            'common/header'
        );

        $data['permissions'] = array();

        $files = glob(DIR_APPLICATION . 'controller/*/*.php');

        foreach ($files as $file) {
            $part = explode('/', dirname($file));

            $permission = end($part) . '/' . basename($file, '.php');

            if (!in_array($permission, $ignore)) {
                $data['permissions'][] = $permission;
            }
        }

        $this->load->model('setting/store');
        $data['stores'] = $this->model_setting_store->getAllStores();

        if (isset($this->request->post['module'])) {
            $data['module'] = $this->request->post['module'];
        } elseif (!empty($transaction_info)) {
            $data['module'] = $transaction_info['module'];
        } else {
            $data['module'] = '';
        }

        if (isset($this->request->post['store_id'])) {
            $data['store_id'] = $this->request->post['store_id'];
        } elseif (!empty($transaction_info)) {
            $data['store_id'] = $transaction_info['store_id'];
        } else {
            $data['store_id'] = '';
        }

        if (isset($this->request->post['prefix'])) {
            $data['prefix'] = $this->request->post['prefix'];
        } elseif (!empty($transaction_info)) {
            $data['prefix'] = $transaction_info['prefix'];
        } else {
            $data['prefix'] = '';
        }

        if (isset($this->request->post['lastrunningno'])) {
            $data['lastrunningno'] = $this->request->post['lastrunningno'];
        } elseif (!empty($transaction_info)) {
            $data['lastrunningno'] = $transaction_info['lastrunningno'];
        } else {
            $data['lastrunningno'] = '';
        }

        if (isset($this->request->post['length'])) {
            $data['length'] = $this->request->post['length'];
        } elseif (!empty($transaction_info)) {
            $data['length'] = $transaction_info['length'];
        } else {
            $data['length'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/transaction_no_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'setting/transaction_no') && !$this->user->userpermissions('setting', 'catalog/transaction_no')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ((utf8_strlen($this->request->post['prefix']) < 1) || (utf8_strlen($this->request->post['prefix']) > 7)) {
            $this->error['prefix'] = $this->language->get('error_prefix');
        }

        if (!is_numeric($this->request->post['lastrunningno']) || utf8_strlen($this->request->post['lastrunningno']) < 1) {
            $this->error['lastrunningno'] = $this->language->get('error_lastrunningno');
        }

        if (!is_numeric($this->request->post['length']) || utf8_strlen($this->request->post['length']) < 1) {
            $this->error['length'] = $this->language->get('error_length');
        }

        $transaction_info = $this->model_setting_transaction_no->getTransactionByModel($this->request->post['module'], $this->request->post['store_id']);

        if (!isset($this->request->get['transaction_id'])) {
            if ($transaction_info) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        } else {
            if ($transaction_info && ($this->request->get['transaction_id'] != $transaction_info['transaction_no_id'])) {
                $this->error['warning'] = $this->language->get('error_exists');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function getTransactionNo($args) {
        $this->load->model('setting/transaction_no');

        $TransactionNo = $this->model_setting_transaction_no->getTransactionByModel($args['module'], $args['store']);

        if ($TransactionNo)
            return $TransactionNo['prefix'] . str_pad($TransactionNo['lastrunningno'] + 1, $TransactionNo['length'], '0', STR_PAD_LEFT);
        else
            return false;
    }

    public function setTransactionNo($args) {
        $data['module'] = $args['module'];

        $data['store_id'] = $args['store'];

        $this->load->model('setting/transaction_no');

        $TransactionNo = $this->model_setting_transaction_no->setTransaction($data);
    }
}
