<?php

class ControllerSettingSetting extends Controller
{

    private $error = array();

    public function index()
    {
        $this->load->language('setting/setting');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('config', $this->request->post);

            //OC2.0
            $this->model_setting_setting->editSetting('sql_accounting', $this->request->post);
            $this->model_setting_setting->editSetting('andassist', $this->request->post);

            if ($this->config->get('config_currency_auto')) {
                $this->load->model('localisation/currency');

                $this->model_localisation_currency->refresh();
            }

            $this->syncToEtcm();
            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true));
        }

        //OC2.0
        $data['session_language_id'] = $this->config->get('config_language_id');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = '';
        }

        //OC2.0
        if (isset($this->error['attention'])) {
            $data['error_attention'] = $this->error['attention'];
        } else {
            $data['error_attention'] = '';
        }

        if (isset($this->error['code'])) {
            $data['error_code'] = $this->error['code'];
        } else {
            $data['error_code'] = '';
        }

        if (isset($this->error['number'])) {
            $data['error_number'] = $this->error['number'];
        } else {
            $data['error_number'] = '';
        }

        if (isset($this->error['owner'])) {
            $data['error_owner'] = $this->error['owner'];
        } else {
            $data['error_owner'] = '';
        }

        //OC2.0
        if (isset($this->error['gstno'])) {
            $data['error_gstno'] = $this->error['gstno'];
        } else {
            $data['error_gstno'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['telephone'])) {
            $data['error_telephone'] = $this->error['telephone'];
        } else {
            $data['error_telephone'] = '';
        }

        if (isset($this->error['meta_title'])) {
            $data['error_meta_title'] = $this->error['meta_title'];
        } else {
            $data['error_meta_title'] = '';
        }

        if (isset($this->error['country'])) {
            $data['error_country'] = $this->error['country'];
        } else {
            $data['error_country'] = '';
        }

        if (isset($this->error['zone'])) {
            $data['error_zone'] = $this->error['zone'];
        } else {
            $data['error_zone'] = '';
        }

        //OC2.0
        if (isset($this->error['herbal_weight'])) {
            $data['error_herbal_weight'] = $this->error['herbal_weight'];
        } else {
            $data['error_herbal_weight'] = '';
        }

        if (isset($this->error['customer_group_display'])) {
            $data['error_customer_group_display'] = $this->error['customer_group_display'];
        } else {
            $data['error_customer_group_display'] = '';
        }

        if (isset($this->error['login_attempts'])) {
            $data['error_login_attempts'] = $this->error['login_attempts'];
        } else {
            $data['error_login_attempts'] = '';
        }

        if (isset($this->error['voucher_min'])) {
            $data['error_voucher_min'] = $this->error['voucher_min'];
        } else {
            $data['error_voucher_min'] = '';
        }

        if (isset($this->error['voucher_max'])) {
            $data['error_voucher_max'] = $this->error['voucher_max'];
        } else {
            $data['error_voucher_max'] = '';
        }

        if (isset($this->error['processing_status'])) {
            $data['error_processing_status'] = $this->error['processing_status'];
        } else {
            $data['error_processing_status'] = '';
        }

        if (isset($this->error['complete_status'])) {
            $data['error_complete_status'] = $this->error['complete_status'];
        } else {
            $data['error_complete_status'] = '';
        }

        //OC2.0
        if (isset($this->error['ftp_hostname'])) {
            $data['error_ftp_hostname'] = $this->error['ftp_hostname'];
        } else {
            $data['error_ftp_hostname'] = '';
        }

        if (isset($this->error['ftp_port'])) {
            $data['error_ftp_port'] = $this->error['ftp_port'];
        } else {
            $data['error_ftp_port'] = '';
        }

        if (isset($this->error['ftp_username'])) {
            $data['error_ftp_username'] = $this->error['ftp_username'];
        } else {
            $data['error_ftp_username'] = '';
        }

        if (isset($this->error['ftp_password'])) {
            $data['error_ftp_password'] = $this->error['ftp_password'];
        } else {
            $data['error_ftp_password'] = '';
        }

        if (isset($this->error['image_category'])) {
            $data['error_image_category'] = $this->error['image_category'];
        } else {
            $data['error_image_category'] = '';
        }

        if (isset($this->error['image_thumb'])) {
            $data['error_image_thumb'] = $this->error['image_thumb'];
        } else {
            $data['error_image_thumb'] = '';
        }

        if (isset($this->error['image_popup'])) {
            $data['error_image_popup'] = $this->error['image_popup'];
        } else {
            $data['error_image_popup'] = '';
        }

        if (isset($this->error['image_product'])) {
            $data['error_image_product'] = $this->error['image_product'];
        } else {
            $data['error_image_product'] = '';
        }

        if (isset($this->error['image_additional'])) {
            $data['error_image_additional'] = $this->error['image_additional'];
        } else {
            $data['error_image_additional'] = '';
        }

        if (isset($this->error['image_related'])) {
            $data['error_image_related'] = $this->error['image_related'];
        } else {
            $data['error_image_related'] = '';
        }

        if (isset($this->error['image_compare'])) {
            $data['error_image_compare'] = $this->error['image_compare'];
        } else {
            $data['error_image_compare'] = '';
        }

        if (isset($this->error['image_wishlist'])) {
            $data['error_image_wishlist'] = $this->error['image_wishlist'];
        } else {
            $data['error_image_wishlist'] = '';
        }

        if (isset($this->error['image_cart'])) {
            $data['error_image_cart'] = $this->error['image_cart'];
        } else {
            $data['error_image_cart'] = '';
        }

        if (isset($this->error['image_location'])) {
            $data['error_image_location'] = $this->error['image_location'];
        } else {
            $data['error_image_location'] = '';
        }

        if (isset($this->error['error_filename'])) {
            $data['error_error_filename'] = $this->error['error_filename'];
        } else {
            $data['error_error_filename'] = '';
        }

        if (isset($this->error['product_limit'])) {
            $data['error_product_limit'] = $this->error['product_limit'];
        } else {
            $data['error_product_limit'] = '';
        }

        if (isset($this->error['product_description_length'])) {
            $data['error_product_description_length'] = $this->error['product_description_length'];
        } else {
            $data['error_product_description_length'] = '';
        }

        if (isset($this->error['log'])) {
            $data['error_log'] = $this->error['log'];
        } else {
            $data['error_log'] = '';
        }

        if (isset($this->error['limit_admin'])) {
            $data['error_limit_admin'] = $this->error['limit_admin'];
        } else {
            $data['error_limit_admin'] = '';
        }

        if (isset($this->error['encryption'])) {
            $data['error_encryption'] = $this->error['encryption'];
        } else {
            $data['error_encryption'] = '';
        }

        if (isset($this->error['from_order_status'])) {
            $data['error_from_order_status'] = $this->error['from_order_status'];
        } else {
            $data['error_from_order_status'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_stores'),
            'href' => $this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('setting/setting', 'user_token=' . $this->session->data['user_token'], true)
        );

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['action'] = $this->url->link('setting/setting', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('setting/store', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        //OC2.0
        if (isset($this->request->post['config_attention'])) {
            $data['config_attention'] = $this->request->post['config_attention'];
        } else {
            $data['config_attention'] = $this->config->get('config_attention');
        }

        if (isset($this->request->post['config_code'])) {
            $data['config_code'] = $this->request->post['config_code'];
        } else {
            $data['config_code'] = $this->config->get('config_code');
        }

        if (isset($this->request->post['config_number'])) {
            $data['config_number'] = $this->request->post['config_number'];
        } else {
            $data['config_number'] = $this->config->get('config_number');
        }

        if (isset($this->request->post['config_gstno'])) {
            $data['config_gstno'] = $this->request->post['config_gstno'];
        } else {
            $data['config_gstno'] = $this->config->get('config_gstno');
        }

        if (isset($this->request->post['config_meta_title'])) {
            $data['config_meta_title'] = $this->request->post['config_meta_title'];
        } else {
            $data['config_meta_title'] = $this->config->get('config_meta_title');
        }

        if (isset($this->request->post['config_meta_description'])) {
            $data['config_meta_description'] = $this->request->post['config_meta_description'];
        } else {
            $data['config_meta_description'] = $this->config->get('config_meta_description');
        }

        if (isset($this->request->post['config_meta_keyword'])) {
            $data['config_meta_keyword'] = $this->request->post['config_meta_keyword'];
        } else {
            $data['config_meta_keyword'] = $this->config->get('config_meta_keyword');
        }

        if (isset($this->request->post['config_theme'])) {
            $data['config_theme'] = $this->request->post['config_theme'];
        } else {
            $data['config_theme'] = $this->config->get('config_theme');
        }

        if ($this->request->server['HTTPS']) {
            $data['store_url'] = HTTPS_CATALOG;
        } else {
            $data['store_url'] = HTTP_CATALOG;
        }

        $data['themes'] = array();

        $this->load->model('setting/extension');

        $extensions = $this->model_setting_extension->getInstalled('theme');

        foreach ($extensions as $code) {
            $this->load->language('extension/theme/' . $code, 'extension');

            $data['themes'][] = array(
                'text' => $this->language->get('extension')->get('heading_title'),
                'value' => $code
            );
        }

        if (isset($this->request->post['config_layout_id'])) {
            $data['config_layout_id'] = $this->request->post['config_layout_id'];
        } else {
            $data['config_layout_id'] = $this->config->get('config_layout_id');
        }

        if (isset($this->request->post['config_customer_register'])) {
            $data['config_customer_register'] = $this->request->post['config_customer_register'];
        } else {
            $data['config_customer_register'] = $this->config->get('config_customer_register');
        }

        $this->load->model('design/layout');

        $data['layouts'] = $this->model_design_layout->getLayouts();

        if (isset($this->request->post['config_template'])) {
            $data['config_template'] = $this->request->post['config_template'];
        } else {
            $data['config_template'] = $this->config->get('config_template');
        }

        $data['templates'] = array();

        $directories = glob(DIR_CATALOG . 'view/theme/*', GLOB_ONLYDIR);

        foreach ($directories as $directory) {
            $data['templates'][] = basename($directory);
        }

        if (isset($this->request->post['config_name'])) {
            $data['config_name'] = $this->request->post['config_name'];
        } else {
            $data['config_name'] = $this->config->get('config_name');
        }

        if (isset($this->request->post['config_owner'])) {
            $data['config_owner'] = $this->request->post['config_owner'];
        } else {
            $data['config_owner'] = $this->config->get('config_owner');
        }

        if (isset($this->request->post['config_store_description'])) {
            $data['config_store_description'] = $this->request->post['config_store_description'];
        } else {
            $data['config_store_description'] = $this->config->get('config_store_description');
        }

        if (isset($this->request->post['config_store_city'])) {
            $data['config_store_city'] = $this->request->post['config_store_city'];
        } else {
            $data['config_store_city'] = $this->config->get('config_store_city');
        }

        if (isset($this->request->post['config_store_postcode'])) {
            $data['config_store_postcode'] = $this->request->post['config_store_postcode'];
        } else {
            $data['config_store_postcode'] = $this->config->get('config_store_postcode');
        }

        if (isset($this->request->post['config_store_zone_id'])) {
            $data['config_store_zone_id'] = $this->request->post['config_store_zone_id'];
        } else {
            $data['config_store_zone_id'] = $this->config->get('config_store_zone_id');
        }

        if (isset($this->request->post['config_store_country_id'])) {
            $data['config_store_country_id'] = $this->request->post['config_store_country_id'];
        } else {
            $data['config_store_country_id'] = $this->config->get('config_store_country_id');
        }

        if (isset($this->request->post['config_store_latitude'])) {
            $data['config_store_latitude'] = $this->request->post['config_store_latitude'];
        } else {
            $data['config_store_latitude'] = $this->config->get('config_store_latitude');
        }

        if (isset($this->request->post['config_store_longitude'])) {
            $data['config_store_longitude'] = $this->request->post['config_store_longitude'];
        } else {
            $data['config_store_longitude'] = $this->config->get('config_store_longitude');
        }

        if (isset($this->request->post['config_address'])) {
            $data['config_address'] = $this->request->post['config_address'];
        } else {
            $data['config_address'] = $this->config->get('config_address');
        }

        if (isset($this->request->post['config_geocode'])) {
            $data['config_geocode'] = $this->request->post['config_geocode'];
        } else {
            $data['config_geocode'] = $this->config->get('config_geocode');
        }

        if (isset($this->request->post['config_email'])) {
            $data['config_email'] = $this->request->post['config_email'];
        } else {
            $data['config_email'] = $this->config->get('config_email');
        }

        if (isset($this->request->post['config_telephone'])) {
            $data['config_telephone'] = $this->request->post['config_telephone'];
        } else {
            $data['config_telephone'] = $this->config->get('config_telephone');
        }

        if (isset($this->request->post['config_telephone1'])) {
            $data['config_telephone1'] = $this->request->post['config_telephone1'];
        } else {
            $data['config_telephone1'] = $this->config->get('config_telephone1');
        }

        if (isset($this->request->post['config_fax'])) {
            $data['config_fax'] = $this->request->post['config_fax'];
        } else {
            $data['config_fax'] = $this->config->get('config_fax');
        }

        if (isset($this->request->post['config_image'])) {
            $data['config_image'] = $this->request->post['config_image'];
        } else {
            $data['config_image'] = $this->config->get('config_image');
        }

        $this->load->model('tool/image');

        if (isset($this->request->post['config_image']) && is_file(DIR_IMAGE . $this->request->post['config_image'])) {
            $data['thumb'] = $this->model_tool_image->resize($this->request->post['config_image'], 100, 100);
        } elseif ($this->config->get('config_image') && is_file(DIR_IMAGE . $this->config->get('config_image'))) {
            $data['thumb'] = $this->model_tool_image->resize($this->config->get('config_image'), 100, 100);
        } else {
            $data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        if (isset($this->request->post['config_open'])) {
            $data['config_open'] = $this->request->post['config_open'];
        } elseif ($this->config->get('config_open')) {
            $data['config_open'] = $this->config->get('config_open');
        } else {
            $data['config_open'] = array();
        }

        if (isset($this->request->post['config_comment'])) {
            $data['config_comment'] = $this->request->post['config_comment'];
        } else {
            $data['config_comment'] = $this->config->get('config_comment');
        }

        $this->load->model('localisation/location');

        $data['locations'] = $this->model_localisation_location->getLocations();

        if (isset($this->request->post['config_location'])) {
            $data['config_location'] = $this->request->post['config_location'];
        } elseif ($this->config->get('config_location')) {
            $data['config_location'] = $this->config->get('config_location');
        } else {
            $data['config_location'] = array();
        }

        if (isset($this->request->post['config_country_id'])) {
            $data['config_country_id'] = $this->request->post['config_country_id'];
        } else {
            $data['config_country_id'] = $this->config->get('config_country_id');
        }

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        if (isset($this->request->post['config_zone_id'])) {
            $data['config_zone_id'] = $this->request->post['config_zone_id'];
        } else {
            $data['config_zone_id'] = $this->config->get('config_zone_id');
        }

        if (isset($this->request->post['config_time_zone'])) {
            $data['config_time_zone'] = $this->request->post['config_time_zone'];
        } else {
            $data['config_time_zone'] = $this->config->get('config_time_zone');
        }

        if (isset($this->request->post['config_time_zone'])) {
            $data['config_time_zone'] = $this->request->post['config_time_zone'];
        } else {
            $data['config_time_zone'] = $this->config->get('config_time_zone');
        }

        if (isset($this->request->post['andassist_status'])) {
            $data['andassist_status'] = $this->request->post['andassist_status'];
        } else {
            $data['andassist_status'] = $this->config->get('andassist_status');
        }

        if (isset($this->request->post['andassist_login'])) {
            $data['andassist_login'] = $this->request->post['andassist_login'];
        } else {
            $data['andassist_login'] = $this->config->get('andassist_login');
        }

        if (isset($this->request->post['andassist_module_code'])) {
            $data['andassist_module_code'] = $this->request->post['andassist_module_code'];
        } else {
            $data['andassist_module_code'] = $this->config->get('andassist_module_code');
        }

        if (isset($this->request->post['andassist_module_version'])) {
            $data['andassist_module_version'] = $this->request->post['andassist_module_version'];
        } else {
            $data['andassist_module_version'] = $this->config->get('andassist_module_version');
        }

        if (isset($this->request->post['andassist_pass'])) {
            $data['andassist_pass'] = $this->request->post['andassist_pass'];
        } else {
            $data['andassist_pass'] = $this->config->get('andassist_pass');
        }

        if (isset($this->request->post['config_language'])) {
            $data['config_language'] = $this->request->post['config_language'];
        } else {
            $data['config_language'] = $this->config->get('config_language');
        }

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        if (isset($this->request->post['config_admin_language'])) {
            $data['config_admin_language'] = $this->request->post['config_admin_language'];
        } else {
            $data['config_admin_language'] = $this->config->get('config_admin_language');
        }

        if (isset($this->request->post['config_currency'])) {
            $data['config_currency'] = $this->request->post['config_currency'];
        } else {
            $data['config_currency'] = $this->config->get('config_currency');
        }

        if (isset($this->request->post['config_currency_auto'])) {
            $data['config_currency_auto'] = $this->request->post['config_currency_auto'];
        } else {
            $data['config_currency_auto'] = $this->config->get('config_currency_auto');
        }

        $this->load->model('localisation/currency');

        $data['currencies'] = $this->model_localisation_currency->getCurrencies();

        if (isset($this->request->post['config_length_class_id'])) {
            $data['config_length_class_id'] = $this->request->post['config_length_class_id'];
        } else {
            $data['config_length_class_id'] = $this->config->get('config_length_class_id');
        }

        $this->load->model('localisation/length_class');

        $data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

        if (isset($this->request->post['config_weight_class_id'])) {
            $data['config_weight_class_id'] = $this->request->post['config_weight_class_id'];
        } else {
            $data['config_weight_class_id'] = $this->config->get('config_weight_class_id');
        }

        if (isset($this->request->post['config_herbal_weight'])) {
            $data['config_herbal_weight'] = $this->request->post['config_herbal_weight'];
        } else {
            $data['config_herbal_weight'] = $this->config->get('config_herbal_weight');
        }

        if (isset($this->request->post['config_herbal_weight_class_id'])) {
            $data['config_herbal_weight_class_id'] = $this->request->post['config_herbal_weight_class_id'];
        } else {
            $data['config_herbal_weight_class_id'] = $this->config->get('config_herbal_weight_class_id');
        }

        $this->load->model('localisation/weight_class');

        $data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

        if (isset($this->request->post['config_product_limit'])) {
            $data['config_product_limit'] = $this->request->post['config_product_limit'];
        } else {
            $data['config_product_limit'] = $this->config->get('config_product_limit');
        }

        if (isset($this->request->post['config_product_description_length'])) {
            $data['config_product_description_length'] = $this->request->post['config_product_description_length'];
        } else {
            $data['config_product_description_length'] = $this->config->get('config_product_description_length');
        }

        if (isset($this->request->post['config_limit_admin'])) {
            $data['config_limit_admin'] = $this->request->post['config_limit_admin'];
        } else {
            $data['config_limit_admin'] = $this->config->get('config_limit_admin');
        }

        if (isset($this->request->post['config_product_count'])) {
            $data['config_product_count'] = $this->request->post['config_product_count'];
        } else {
            $data['config_product_count'] = $this->config->get('config_product_count');
        }

        if (isset($this->request->post['config_review_status'])) {
            $data['config_review_status'] = $this->request->post['config_review_status'];
        } else {
            $data['config_review_status'] = $this->config->get('config_review_status');
        }

        if (isset($this->request->post['config_review_guest'])) {
            $data['config_review_guest'] = $this->request->post['config_review_guest'];
        } else {
            $data['config_review_guest'] = $this->config->get('config_review_guest');
        }

        if (isset($this->request->post['config_review_mail'])) {
            $data['config_review_mail'] = $this->request->post['config_review_mail'];
        } else {
            $data['config_review_mail'] = $this->config->get('config_review_mail');
        }

        if (isset($this->request->post['config_voucher_min'])) {
            $data['config_voucher_min'] = $this->request->post['config_voucher_min'];
        } else {
            $data['config_voucher_min'] = $this->config->get('config_voucher_min');
        }

        if (isset($this->request->post['config_voucher_max'])) {
            $data['config_voucher_max'] = $this->request->post['config_voucher_max'];
        } else {
            $data['config_voucher_max'] = $this->config->get('config_voucher_max');
        }

        if (isset($this->request->post['config_tax'])) {
            $data['config_tax'] = $this->request->post['config_tax'];
        } else {
            $data['config_tax'] = $this->config->get('config_tax');
        }

        if (isset($this->request->post['config_tax_default'])) {
            $data['config_tax_default'] = $this->request->post['config_tax_default'];
        } else {
            $data['config_tax_default'] = $this->config->get('config_tax_default');
        }

        if (isset($this->request->post['config_tax_customer'])) {
            $data['config_tax_customer'] = $this->request->post['config_tax_customer'];
        } else {
            $data['config_tax_customer'] = $this->config->get('config_tax_customer');
        }

        if (isset($this->request->post['config_customer_online'])) {
            $data['config_customer_online'] = $this->request->post['config_customer_online'];
        } else {
            $data['config_customer_online'] = $this->config->get('config_customer_online');
        }

        if (isset($this->request->post['config_customer_activity'])) {
            $data['config_customer_activity'] = $this->request->post['config_customer_activity'];
        } else {
            $data['config_customer_activity'] = $this->config->get('config_customer_activity');
        }

        if (isset($this->request->post['config_customer_search'])) {
            $data['config_customer_search'] = $this->request->post['config_customer_search'];
        } else {
            $data['config_customer_search'] = $this->config->get('config_customer_search');
        }

        if (isset($this->request->post['config_customer_group_id'])) {
            $data['config_customer_group_id'] = $this->request->post['config_customer_group_id'];
        } else {
            $data['config_customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        if (isset($this->request->post['config_customer_group_display'])) {
            $data['config_customer_group_display'] = $this->request->post['config_customer_group_display'];
        } elseif ($this->config->get('config_customer_group_display')) {
            $data['config_customer_group_display'] = $this->config->get('config_customer_group_display');
        } else {
            $data['config_customer_group_display'] = array();
        }

        if (isset($this->request->post['config_customer_price'])) {
            $data['config_customer_price'] = $this->request->post['config_customer_price'];
        } else {
            $data['config_customer_price'] = $this->config->get('config_customer_price');
        }

        if (isset($this->request->post['config_login_attempts'])) {
            $data['config_login_attempts'] = $this->request->post['config_login_attempts'];
        } elseif ($this->config->has('config_login_attempts')) {
            $data['config_login_attempts'] = $this->config->get('config_login_attempts');
        } else {
            $data['config_login_attempts'] = 5;
        }

        if (isset($this->request->post['config_account_id'])) {
            $data['config_account_id'] = $this->request->post['config_account_id'];
        } else {
            $data['config_account_id'] = $this->config->get('config_account_id');
        }

        $this->load->model('catalog/information');

        $data['informations'] = $this->model_catalog_information->getInformations();

        //OC2.0
        if (isset($this->request->post['config_account_mail'])) {
            $data['config_account_mail'] = $this->request->post['config_account_mail'];
        } else {
            $data['config_account_mail'] = $this->config->get('config_account_mail');
        }

        if (isset($this->request->post['config_cart_weight'])) {
            $data['config_cart_weight'] = $this->request->post['config_cart_weight'];
        } else {
            $data['config_cart_weight'] = $this->config->get('config_cart_weight');
        }

        if (isset($this->request->post['config_checkout_guest'])) {
            $data['config_checkout_guest'] = $this->request->post['config_checkout_guest'];
        } else {
            $data['config_checkout_guest'] = $this->config->get('config_checkout_guest');
        }

        if (isset($this->request->post['config_checkout_id'])) {
            $data['config_checkout_id'] = $this->request->post['config_checkout_id'];
        } else {
            $data['config_checkout_id'] = $this->config->get('config_checkout_id');
        }

        if (isset($this->request->post['config_invoice_prefix'])) {
            $data['config_invoice_prefix'] = $this->request->post['config_invoice_prefix'];
        } elseif ($this->config->get('config_invoice_prefix')) {
            $data['config_invoice_prefix'] = $this->config->get('config_invoice_prefix');
        } else {
            $data['config_invoice_prefix'] = 'INV-' . date('Y') . '-00';
        }

        if (isset($this->request->post['config_order_status_id'])) {
            $data['config_order_status_id'] = $this->request->post['config_order_status_id'];
        } else {
            $data['config_order_status_id'] = $this->config->get('config_order_status_id');
        }

        if (isset($this->request->post['config_processing_status'])) {
            $data['config_processing_status'] = $this->request->post['config_processing_status'];
        } elseif ($this->config->get('config_processing_status')) {
            $data['config_processing_status'] = $this->config->get('config_processing_status');
        } else {
            $data['config_processing_status'] = array();
        }

        if (isset($this->request->post['config_complete_status'])) {
            $data['config_complete_status'] = $this->request->post['config_complete_status'];
        } elseif ($this->config->get('config_complete_status')) {
            $data['config_complete_status'] = $this->config->get('config_complete_status');
        } else {
            $data['config_complete_status'] = array();
        }

        if (isset($this->request->post['config_fraud_status_id'])) {
            $data['config_fraud_status_id'] = $this->request->post['config_fraud_status_id'];
        } else {
            $data['config_fraud_status_id'] = $this->config->get('config_fraud_status_id');
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['config_api_id'])) {
            $data['config_api_id'] = $this->request->post['config_api_id'];
        } else {
            $data['config_api_id'] = $this->config->get('config_api_id');
        }

        if (isset($this->request->post['config_order_mail'])) {
            $data['config_order_mail'] = $this->request->post['config_order_mail'];
        } else {
            $data['config_order_mail'] = $this->config->get('config_order_mail');
        }

        $this->load->model('user/api');

        $data['apis'] = $this->model_user_api->getApis();

        if (isset($this->request->post['config_stock_display'])) {
            $data['config_stock_display'] = $this->request->post['config_stock_display'];
        } else {
            $data['config_stock_display'] = $this->config->get('config_stock_display');
        }

        if (isset($this->request->post['config_stock_warning'])) {
            $data['config_stock_warning'] = $this->request->post['config_stock_warning'];
        } else {
            $data['config_stock_warning'] = $this->config->get('config_stock_warning');
        }

        if (isset($this->request->post['config_stock_checkout'])) {
            $data['config_stock_checkout'] = $this->request->post['config_stock_checkout'];
        } else {
            $data['config_stock_checkout'] = $this->config->get('config_stock_checkout');
        }

        if (isset($this->request->post['config_affiliate_group_id'])) {
            $data['config_affiliate_group_id'] = $this->request->post['config_affiliate_group_id'];
        } else {
            $data['config_affiliate_group_id'] = $this->config->get('config_affiliate_group_id');
        }

        if (isset($this->request->post['config_affiliate_approval'])) {
            $data['config_affiliate_approval'] = $this->request->post['config_affiliate_approval'];
        } elseif ($this->config->has('config_affiliate_approval')) {
            $data['config_affiliate_approval'] = $this->config->get('config_affiliate_approval');
        } else {
            $data['config_affiliate_approval'] = '';
        }

        if (isset($this->request->post['config_affiliate_auto'])) {
            $data['config_affiliate_auto'] = $this->request->post['config_affiliate_auto'];
        } elseif ($this->config->has('config_affiliate_auto')) {
            $data['config_affiliate_auto'] = $this->config->get('config_affiliate_auto');
        } else {
            $data['config_affiliate_auto'] = '';
        }

        if (isset($this->request->post['config_affiliate_commission'])) {
            $data['config_affiliate_commission'] = $this->request->post['config_affiliate_commission'];
        } elseif ($this->config->has('config_affiliate_commission')) {
            $data['config_affiliate_commission'] = $this->config->get('config_affiliate_commission');
        } else {
            $data['config_affiliate_commission'] = '5.00';
        }

        if (isset($this->request->post['config_affiliate_mail'])) {
            $data['config_affiliate_mail'] = $this->request->post['config_affiliate_mail'];
        } elseif ($this->config->has('config_affiliate_mail')) {
            $data['config_affiliate_mail'] = $this->config->get('config_affiliate_mail');
        } else {
            $data['config_affiliate_mail'] = '';
        }

        if (isset($this->request->post['config_affiliate_id'])) {
            $data['config_affiliate_id'] = $this->request->post['config_affiliate_id'];
        } else {
            $data['config_affiliate_id'] = $this->config->get('config_affiliate_id');
        }

        if (isset($this->request->post['config_return_id'])) {
            $data['config_return_id'] = $this->request->post['config_return_id'];
        } else {
            $data['config_return_id'] = $this->config->get('config_return_id');
        }

        if (isset($this->request->post['config_return_status_id'])) {
            $data['config_return_status_id'] = $this->request->post['config_return_status_id'];
        } else {
            $data['config_return_status_id'] = $this->config->get('config_return_status_id');
        }

        $this->load->model('localisation/return_status');

        $data['return_statuses'] = $this->model_localisation_return_status->getReturnStatuses();

        if (isset($this->request->post['config_captcha'])) {
            $data['config_captcha'] = $this->request->post['config_captcha'];
        } else {
            $data['config_captcha'] = $this->config->get('config_captcha');
        }

        $this->load->model('setting/extension');

        $data['captchas'] = array();

        // Get a list of installed captchas
        $extensions = $this->model_setting_extension->getInstalled('captcha');

        foreach ($extensions as $code) {
            $this->load->language('extension/captcha/' . $code, 'extension');

            if ($this->config->get('captcha_' . $code . '_status')) {
                $data['captchas'][] = array(
                    'text' => $this->language->get('extension')->get('heading_title'),
                    'value' => $code
                );
            }
        }

        if (isset($this->request->post['config_captcha_page'])) {
            $data['config_captcha_page'] = $this->request->post['config_captcha_page'];
        } elseif ($this->config->has('config_captcha_page')) {
            $data['config_captcha_page'] = $this->config->get('config_captcha_page');
        } else {
            $data['config_captcha_page'] = array();
        }

        $data['captcha_pages'] = array();

        $data['captcha_pages'][] = array(
            'text' => $this->language->get('text_register'),
            'value' => 'register'
        );

        $data['captcha_pages'][] = array(
            'text' => $this->language->get('text_guest'),
            'value' => 'guest'
        );

        $data['captcha_pages'][] = array(
            'text' => $this->language->get('text_review'),
            'value' => 'review'
        );

        $data['captcha_pages'][] = array(
            'text' => $this->language->get('text_return'),
            'value' => 'return'
        );

        $data['captcha_pages'][] = array(
            'text' => $this->language->get('text_contact'),
            'value' => 'contact'
        );

        if (isset($this->request->post['config_logo'])) {
            $data['config_logo'] = $this->request->post['config_logo'];
        } else {
            $data['config_logo'] = $this->config->get('config_logo');
        }

        if (isset($this->request->post['config_logo']) && is_file(DIR_IMAGE . $this->request->post['config_logo'])) {
            $data['logo'] = $this->model_tool_image->resize($this->request->post['config_logo'], 100, 100);
        } elseif ($this->config->get('config_logo') && is_file(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['logo'] = $this->model_tool_image->resize($this->config->get('config_logo'), 100, 100);
        } else {
            $data['logo'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        if (isset($this->request->post['config_icon'])) {
            $data['config_icon'] = $this->request->post['config_icon'];
        } else {
            $data['config_icon'] = $this->config->get('config_icon');
        }

        if (isset($this->request->post['config_icon']) && is_file(DIR_IMAGE . $this->request->post['config_icon'])) {
            $data['icon'] = $this->model_tool_image->resize($this->request->post['config_icon'], 100, 100);
        } elseif ($this->config->get('config_icon') && is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
            $data['icon'] = $this->model_tool_image->resize($this->config->get('config_icon'), 100, 100);
        } else {
            $data['icon'] = $this->model_tool_image->resize('no_image.png', 100, 100);
        }

        if (isset($this->request->post['config_image_category_width'])) {
            $data['config_image_category_width'] = $this->request->post['config_image_category_width'];
        } else {
            $data['config_image_category_width'] = $this->config->get('config_image_category_width');
        }

        if (isset($this->request->post['config_image_category_height'])) {
            $data['config_image_category_height'] = $this->request->post['config_image_category_height'];
        } else {
            $data['config_image_category_height'] = $this->config->get('config_image_category_height');
        }

        if (isset($this->request->post['config_image_thumb_width'])) {
            $data['config_image_thumb_width'] = $this->request->post['config_image_thumb_width'];
        } else {
            $data['config_image_thumb_width'] = $this->config->get('config_image_thumb_width');
        }

        if (isset($this->request->post['config_image_thumb_height'])) {
            $data['config_image_thumb_height'] = $this->request->post['config_image_thumb_height'];
        } else {
            $data['config_image_thumb_height'] = $this->config->get('config_image_thumb_height');
        }

        if (isset($this->request->post['config_image_popup_width'])) {
            $data['config_image_popup_width'] = $this->request->post['config_image_popup_width'];
        } else {
            $data['config_image_popup_width'] = $this->config->get('config_image_popup_width');
        }

        if (isset($this->request->post['config_image_popup_height'])) {
            $data['config_image_popup_height'] = $this->request->post['config_image_popup_height'];
        } else {
            $data['config_image_popup_height'] = $this->config->get('config_image_popup_height');
        }

        if (isset($this->request->post['config_image_product_width'])) {
            $data['config_image_product_width'] = $this->request->post['config_image_product_width'];
        } else {
            $data['config_image_product_width'] = $this->config->get('config_image_product_width');
        }

        if (isset($this->request->post['config_image_product_height'])) {
            $data['config_image_product_height'] = $this->request->post['config_image_product_height'];
        } else {
            $data['config_image_product_height'] = $this->config->get('config_image_product_height');
        }

        if (isset($this->request->post['config_image_additional_width'])) {
            $data['config_image_additional_width'] = $this->request->post['config_image_additional_width'];
        } else {
            $data['config_image_additional_width'] = $this->config->get('config_image_additional_width');
        }

        if (isset($this->request->post['config_image_additional_height'])) {
            $data['config_image_additional_height'] = $this->request->post['config_image_additional_height'];
        } else {
            $data['config_image_additional_height'] = $this->config->get('config_image_additional_height');
        }

        if (isset($this->request->post['config_image_related_width'])) {
            $data['config_image_related_width'] = $this->request->post['config_image_related_width'];
        } else {
            $data['config_image_related_width'] = $this->config->get('config_image_related_width');
        }

        if (isset($this->request->post['config_image_related_height'])) {
            $data['config_image_related_height'] = $this->request->post['config_image_related_height'];
        } else {
            $data['config_image_related_height'] = $this->config->get('config_image_related_height');
        }

        if (isset($this->request->post['config_image_compare_width'])) {
            $data['config_image_compare_width'] = $this->request->post['config_image_compare_width'];
        } else {
            $data['config_image_compare_width'] = $this->config->get('config_image_compare_width');
        }

        if (isset($this->request->post['config_image_compare_height'])) {
            $data['config_image_compare_height'] = $this->request->post['config_image_compare_height'];
        } else {
            $data['config_image_compare_height'] = $this->config->get('config_image_compare_height');
        }

        if (isset($this->request->post['config_mail_engine'])) {
            $data['config_mail_engine'] = $this->request->post['config_mail_engine'];
        } else {
            $data['config_mail_engine'] = $this->config->get('config_mail_engine');
        }

        if (isset($this->request->post['config_image_wishlist_width'])) {
            $data['config_image_wishlist_width'] = $this->request->post['config_image_wishlist_width'];
        } else {
            $data['config_image_wishlist_width'] = $this->config->get('config_image_wishlist_width');
        }

        if (isset($this->request->post['config_image_wishlist_height'])) {
            $data['config_image_wishlist_height'] = $this->request->post['config_image_wishlist_height'];
        } else {
            $data['config_image_wishlist_height'] = $this->config->get('config_image_wishlist_height');
        }

        if (isset($this->request->post['config_image_cart_width'])) {
            $data['config_image_cart_width'] = $this->request->post['config_image_cart_width'];
        } else {
            $data['config_image_cart_width'] = $this->config->get('config_image_cart_width');
        }

        if (isset($this->request->post['config_image_cart_height'])) {
            $data['config_image_cart_height'] = $this->request->post['config_image_cart_height'];
        } else {
            $data['config_image_cart_height'] = $this->config->get('config_image_cart_height');
        }

        if (isset($this->request->post['config_image_location_width'])) {
            $data['config_image_location_width'] = $this->request->post['config_image_location_width'];
        } else {
            $data['config_image_location_width'] = $this->config->get('config_image_location_width');
        }

        if (isset($this->request->post['config_image_location_height'])) {
            $data['config_image_location_height'] = $this->request->post['config_image_location_height'];
        } else {
            $data['config_image_location_height'] = $this->config->get('config_image_location_height');
        }

        if (isset($this->request->post['config_ftp_hostname'])) {
            $data['config_ftp_hostname'] = $this->request->post['config_ftp_hostname'];
        } elseif ($this->config->get('config_ftp_hostname')) {
            $data['config_ftp_hostname'] = $this->config->get('config_ftp_hostname');
        } else {
            $data['config_ftp_hostname'] = str_replace('www.', '', $this->request->server['HTTP_HOST']);
        }

        if (isset($this->request->post['config_ftp_port'])) {
            $data['config_ftp_port'] = $this->request->post['config_ftp_port'];
        } elseif ($this->config->get('config_ftp_port')) {
            $data['config_ftp_port'] = $this->config->get('config_ftp_port');
        } else {
            $data['config_ftp_port'] = 21;
        }

        if (isset($this->request->post['config_ftp_username'])) {
            $data['config_ftp_username'] = $this->request->post['config_ftp_username'];
        } else {
            $data['config_ftp_username'] = $this->config->get('config_ftp_username');
        }

        if (isset($this->request->post['config_ftp_password'])) {
            $data['config_ftp_password'] = $this->request->post['config_ftp_password'];
        } else {
            $data['config_ftp_password'] = $this->config->get('config_ftp_password');
        }

        if (isset($this->request->post['config_ftp_root'])) {
            $data['config_ftp_root'] = $this->request->post['config_ftp_root'];
        } else {
            $data['config_ftp_root'] = $this->config->get('config_ftp_root');
        }

        if (!empty($data['config_ftp_root'])) {
            foreach ($data['config_ftp_root'] as $index => $config_ftp_root) {
                $data['config_ftp_root'][$index]['select_data'] = htmlspecialchars(json_encode($config_ftp_root));
            }
        }

        if (isset($this->request->post['config_ftp_status'])) {
            $data['config_ftp_status'] = $this->request->post['config_ftp_status'];
        } else {
            $data['config_ftp_status'] = $this->config->get('config_ftp_status');
        }

        if (isset($this->request->post['config_mail_service'])) {
            $data['config_mail_service'] = $this->request->post['config_mail_service'];
        } else {
            $data['config_mail_service'] = $this->config->get('config_mail_service');
        }

        if (isset($this->request->post['config_mail_parameter'])) {
            $data['config_mail_parameter'] = $this->request->post['config_mail_parameter'];
        } else {
            $data['config_mail_parameter'] = $this->config->get('config_mail_parameter');
        }

        if (isset($this->request->post['config_mail'])) {
            $config_mail = $this->request->post['config_mail'];

            $data['config_mail_protocol'] = $config_mail['protocol'];
            $data['config_mail_parameter'] = $config_mail['parameter'];
            $data['config_smtp_hostname'] = $config_mail['smtp_hostname'];
            $data['config_smtp_username'] = $config_mail['smtp_username'];
            $data['config_smtp_password'] = $config_mail['smtp_password'];
            $data['config_smtp_port'] = $config_mail['smtp_port'];
            $data['config_smtp_timeout'] = $config_mail['smtp_timeout'];
        } elseif ($this->config->get('config_mail')) {
            $config_mail = $this->config->get('config_mail');

            $data['config_mail_protocol'] = $config_mail['protocol'];
            $data['config_mail_parameter'] = $config_mail['parameter'];
            $data['config_smtp_hostname'] = $config_mail['smtp_hostname'];
            $data['config_smtp_username'] = $config_mail['smtp_username'];
            $data['config_smtp_password'] = $config_mail['smtp_password'];
            $data['config_smtp_port'] = $config_mail['smtp_port'];
            $data['config_smtp_timeout'] = $config_mail['smtp_timeout'];
        } else {
            $data['config_mail_protocol'] = '';
            $data['config_mail_parameter'] = '';
            $data['config_smtp_hostname'] = '';
            $data['config_smtp_username'] = '';
            $data['config_smtp_password'] = '';
            $data['config_smtp_port'] = 25;
            $data['config_smtp_timeout'] = 5;
        }

        if (isset($this->request->post['config_mail_template_appointment'])) {
            $data['config_mail_template_appointment'] = $this->request->post['config_mail_template_appointment'];
        } elseif ($this->config->get('config_mail_template_appointment')) {
            $data['config_mail_template_appointment'] = $this->config->get('config_mail_template_appointment');
        } else {
            $data['config_mail_template_appointment'] = array(
                'subject' => '',
                'confirm_message' => '',
                'change_message' => ''
            );
        }

        if (isset($this->request->post['config_mail_template_brewing'])) {
            $data['config_mail_template_brewing'] = $this->request->post['config_mail_template_brewing'];
        } elseif ($this->config->get('config_mail_template_brewing')) {
            $data['config_mail_template_brewing'] = $this->config->get('config_mail_template_brewing');
        } else {
            $data['config_mail_template_brewing'] = array(
                'subject' => '',
                'message' => ''
            );
        }

        if (isset($this->request->post['config_sms_server'])) {
            $data['config_sms_server'] = $this->request->post['config_sms_server'];
        } elseif ($this->config->get('config_sms_server')) {
            $data['config_sms_server'] = $this->config->get('config_sms_server');
        } else {
            $data['config_sms_server'] = '';
        }

        if (isset($this->request->post['config_sms'])) {
            $data['config_sms'] = $this->request->post['config_sms'];
        } elseif ($this->config->get('config_sms')) {
            $data['config_sms'] = $this->config->get('config_sms');
        } else {
            $data['config_sms'] = array(
                'host' => '',
                'host_unicode' => '',
                'username' => '',
                'password' => '',
                'content_type' => ''
            );
        }

        if (isset($this->request->post['config_sms_credit'])) {
            $data['config_sms_credit'] = $this->request->post['config_sms_credit'];
        } elseif ($this->config->get('config_sms_credit')) {
            $data['config_sms_credit'] = $this->config->get('config_sms_credit');
        } else {
            $data['config_sms_credit'] = array(
                'host' => '',
                'username' => '',
                'password' => '',
                'alert' => ''
            );
        }

        if (isset($this->request->post['config_sms_template_appointment'])) {
            $data['config_sms_template_appointment'] = $this->request->post['config_sms_template_appointment'];
        } elseif ($this->config->get('config_sms_template_appointment')) {
            $data['config_sms_template_appointment'] = $this->config->get('config_sms_template_appointment');
        } else {
            $data['config_sms_template_appointment'] = '';
        }

        if (isset($this->request->post['config_sms_template_brewing'])) {
            $data['config_sms_template_brewing'] = $this->request->post['config_sms_template_brewing'];
        } elseif ($this->config->get('config_sms_template_brewing')) {
            $data['config_sms_template_brewing'] = $this->config->get('config_sms_template_brewing');
        } else {
            $data['config_sms_template_brewing'] = '';
        }

        if (isset($this->request->post['config_mail_smtp_hostname'])) {
            $data['config_mail_smtp_hostname'] = $this->request->post['config_mail_smtp_hostname'];
        } else {
            $data['config_mail_smtp_hostname'] = $this->config->get('config_mail_smtp_hostname');
        }

        if (isset($this->request->post['config_mail_smtp_username'])) {
            $data['config_mail_smtp_username'] = $this->request->post['config_mail_smtp_username'];
        } else {
            $data['config_mail_smtp_username'] = $this->config->get('config_mail_smtp_username');
        }

        if (isset($this->request->post['config_mail_smtp_password'])) {
            $data['config_mail_smtp_password'] = $this->request->post['config_mail_smtp_password'];
        } else {
            $data['config_mail_smtp_password'] = $this->config->get('config_mail_smtp_password');
        }

        if (isset($this->request->post['config_mail_smtp_port'])) {
            $data['config_mail_smtp_port'] = $this->request->post['config_mail_smtp_port'];
        } elseif ($this->config->has('config_mail_smtp_port')) {
            $data['config_mail_smtp_port'] = $this->config->get('config_mail_smtp_port');
        } else {
            $data['config_mail_smtp_port'] = 25;
        }

        if (isset($this->request->post['config_mail_smtp_timeout'])) {
            $data['config_mail_smtp_timeout'] = $this->request->post['config_mail_smtp_timeout'];
        } elseif ($this->config->has('config_mail_smtp_timeout')) {
            $data['config_mail_smtp_timeout'] = $this->config->get('config_mail_smtp_timeout');
        } else {
            $data['config_mail_smtp_timeout'] = 5;
        }

        if (isset($this->request->post['config_mail_alert'])) {
            $data['config_mail_alert'] = $this->request->post['config_mail_alert'];
        } elseif ($this->config->has('config_mail_alert')) {
            $data['config_mail_alert'] = $this->config->get('config_mail_alert');
        } else {
            $data['config_mail_alert'] = array();
        }

        $data['mail_alerts'] = array();

        $data['mail_alerts'][] = array(
            'text' => $this->language->get('text_mail_account'),
            'value' => 'account'
        );

        $data['mail_alerts'][] = array(
            'text' => $this->language->get('text_mail_affiliate'),
            'value' => 'affiliate'
        );

        $data['mail_alerts'][] = array(
            'text' => $this->language->get('text_mail_order'),
            'value' => 'order'
        );

        $data['mail_alerts'][] = array(
            'text' => $this->language->get('text_mail_review'),
            'value' => 'review'
        );

        if (isset($this->request->post['config_mail_alert_email'])) {
            $data['config_mail_alert_email'] = $this->request->post['config_mail_alert_email'];
        } else {
            $data['config_mail_alert_email'] = $this->config->get('config_mail_alert_email');
        }

        if (isset($this->request->post['config_secure'])) {
            $data['config_secure'] = $this->request->post['config_secure'];
        } else {
            $data['config_secure'] = $this->config->get('config_secure');
        }

        if (isset($this->request->post['config_shared'])) {
            $data['config_shared'] = $this->request->post['config_shared'];
        } else {
            $data['config_shared'] = $this->config->get('config_shared');
        }

        if (isset($this->request->post['config_robots'])) {
            $data['config_robots'] = $this->request->post['config_robots'];
        } else {
            $data['config_robots'] = $this->config->get('config_robots');
        }

        if (isset($this->request->post['config_seo_url'])) {
            $data['config_seo_url'] = $this->request->post['config_seo_url'];
        } else {
            $data['config_seo_url'] = $this->config->get('config_seo_url');
        }

        if (isset($this->request->post['config_file_max_size'])) {
            $data['config_file_max_size'] = $this->request->post['config_file_max_size'];
        } elseif ($this->config->get('config_file_max_size')) {
            $data['config_file_max_size'] = $this->config->get('config_file_max_size');
        } else {
            $data['config_file_max_size'] = 300000;
        }

        if (isset($this->request->post['config_file_ext_allowed'])) {
            $data['config_file_ext_allowed'] = $this->request->post['config_file_ext_allowed'];
        } else {
            $data['config_file_ext_allowed'] = $this->config->get('config_file_ext_allowed');
        }

        if (isset($this->request->post['config_file_mime_allowed'])) {
            $data['config_file_mime_allowed'] = $this->request->post['config_file_mime_allowed'];
        } else {
            $data['config_file_mime_allowed'] = $this->config->get('config_file_mime_allowed');
        }

        if (isset($this->request->post['config_maintenance'])) {
            $data['config_maintenance'] = $this->request->post['config_maintenance'];
        } else {
            $data['config_maintenance'] = $this->config->get('config_maintenance');
        }

        if (isset($this->request->post['config_password'])) {
            $data['config_password'] = $this->request->post['config_password'];
        } else {
            $data['config_password'] = $this->config->get('config_password');
        }

        if (isset($this->request->post['config_encryption'])) {
            $data['config_encryption'] = $this->request->post['config_encryption'];
        } else {
            $data['config_encryption'] = $this->config->get('config_encryption');
        }

        if (isset($this->request->post['config_compression'])) {
            $data['config_compression'] = $this->request->post['config_compression'];
        } else {
            $data['config_compression'] = $this->config->get('config_compression');
        }

        if (isset($this->request->post['config_error_display'])) {
            $data['config_error_display'] = $this->request->post['config_error_display'];
        } else {
            $data['config_error_display'] = $this->config->get('config_error_display');
        }

        if (isset($this->request->post['config_error_log'])) {
            $data['config_error_log'] = $this->request->post['config_error_log'];
        } else {
            $data['config_error_log'] = $this->config->get('config_error_log');
        }

        if (isset($this->request->post['config_error_filename'])) {
            $data['config_error_filename'] = $this->request->post['config_error_filename'];
        } else {
            $data['config_error_filename'] = $this->config->get('config_error_filename');
        }

        if (isset($this->request->post['config_google_analytics'])) {
            $data['config_google_analytics'] = $this->request->post['config_google_analytics'];
        } else {
            $data['config_google_analytics'] = $this->config->get('config_google_analytics');
        }

        if (isset($this->request->post['sql_accounting_customer_control_account'])) {
            $data['sql_accounting_customer_control_account'] = $this->request->post['sql_accounting_customer_control_account'];
        } else {
            $data['sql_accounting_customer_control_account'] = $this->config->get('sql_accounting_customer_control_account');
        }

        if (isset($this->request->post['sql_accounting_payment_method'])) {
            $data['sql_accounting_payment_method'] = $this->request->post['sql_accounting_payment_method'];
        } elseif ($this->config->get('sql_accounting_payment_method')) {
            $data['sql_accounting_payment_method'] = $this->config->get('sql_accounting_payment_method');
        } else {
            $data['sql_accounting_payment_method'] = array(
                'Cash' => '',
                'Bank Transfer' => ''
            );
        }

        if (isset($this->request->post['config_from_order_status'])) {
            $data['config_from_order_status'] = $this->request->post['config_from_order_status'];
        } elseif ($this->config->get('config_from_order_status')) {
            $data['config_from_order_status'] = $this->config->get('config_from_order_status');
        } else {
            $data['config_from_order_status'] = array();
        }

        if (isset($this->request->post['config_to_order_status'])) {
            $data['config_to_order_status'] = $this->request->post['config_to_order_status'];
        } else {
            $data['config_to_order_status'] = $this->config->get('config_to_order_status');
        }

        if (isset($this->request->post['config_day_to_cancel'])) {
            $data['config_day_to_cancel'] = $this->request->post['config_day_to_cancel'];
        } else {
            $data['config_day_to_cancel'] = $this->config->get('config_day_to_cancel');
        }

        if (isset($this->request->post['config_day_to_remind'])) {
            $data['config_day_to_remind'] = $this->request->post['config_day_to_remind'];
        } else {
            $data['config_day_to_remind'] = $this->config->get('config_day_to_remind');
        }

        if (isset($this->request->post['config_sms_cancel_order'])) {
            $data['config_sms_cancel_order'] = $this->request->post['config_sms_cancel_order'];
        } else {
            $data['config_sms_cancel_order'] = $this->config->get('config_sms_cancel_order');
        }

        if (isset($this->request->post['config_sms_order_reminder'])) {
            $data['config_sms_order_reminder'] = $this->request->post['config_sms_order_reminder'];
        } else {
            $data['config_sms_order_reminder'] = $this->config->get('config_sms_order_reminder');
        }

        // add sms
        if (isset($this->request->post['config_sms_credit'])) {
            $data['config_sms_credit'] = $this->request->post['config_sms_credit'];
        } else {
            $data['config_sms_credit'] = $this->config->get('config_sms_credit');
        }

        if (isset($this->request->post['config_sms'])) {
            $data['config_sms'] = $this->request->post['config_sms'];
        } else {
            $data['config_sms'] = $this->config->get('config_sms');
        }

        if (isset($this->request->post['config_sms_appointment'])) {
            $data['config_sms_appointment'] = $this->request->post['config_sms_appointment'];
        } else {
            $data['config_sms_appointment'] = $this->config->get('config_sms_appointment');
        }

        if (isset($this->request->post['config_sms_brewing'])) {
            $data['config_sms_brewing'] = $this->request->post['config_sms_brewing'];
        } else {
            $data['config_sms_brewing'] = $this->config->get('config_sms_brewing');
        }

        if (isset($this->request->post['config_sms_admin_new_order'])) {
            $data['config_sms_admin_new_order'] = $this->request->post['config_sms_admin_new_order'];
        } else {
            $data['config_sms_admin_new_order'] = $this->config->get('config_sms_admin_new_order');
        }

        if (isset($this->request->post['config_sms_customer_new_order'])) {
            $data['config_sms_customer_new_order'] = $this->request->post['config_sms_customer_new_order'];
        } else {
            $data['config_sms_customer_new_order'] = $this->config->get('config_sms_customer_new_order');
        }

        if (isset($this->request->post['config_sms_customer_order_tracking_number'])) {
            $data['config_sms_customer_order_tracking_number'] = $this->request->post['config_sms_customer_order_tracking_number'];
        } else {
            $data['config_sms_customer_order_tracking_number'] = $this->config->get('config_sms_customer_order_tracking_number');
        }

        /* notification start */
        if (isset($this->request->post['config_notification'])) {
            $data['config_notification'] = $this->request->post['config_notification'];
        } elseif ($this->config->get('config_notification')) {
            $data['config_notification'] = $this->config->get('config_notification');
        } else {
            $data['config_notification'] = array(
                'api_url' => '',
                'api_key' => ''
            );
        }

        if (isset($this->request->post['config_gcm_appointment'])) {
            $data['config_gcm_appointment'] = $this->request->post['config_gcm_appointment'];
        } else {
            $data['config_gcm_appointment'] = $this->config->get('config_gcm_appointment');
        }

        if (isset($this->request->post['config_gcm_customer_cancel_appointment'])) {
            $data['config_gcm_customer_cancel_appointment'] = $this->request->post['config_gcm_customer_cancel_appointment'];
        } else {
            $data['config_gcm_customer_cancel_appointment'] = $this->config->get('config_gcm_customer_cancel_appointment');
        }

        if (isset($this->request->post['config_gcm_customer_reconfirm_appointment'])) {
            $data['config_gcm_customer_reconfirm_appointment'] = $this->request->post['config_gcm_customer_reconfirm_appointment'];
        } else {
            $data['config_gcm_customer_reconfirm_appointment'] = $this->config->get('config_gcm_customer_reconfirm_appointment');
        }

        if (isset($this->request->post['config_gcm_new_herbal'])) {
            $data['config_gcm_new_herbal'] = $this->request->post['config_gcm_new_herbal'];
        } else {
            $data['config_gcm_new_herbal'] = $this->config->get('config_gcm_new_herbal');
        }
        /* notification end */

        if (isset($this->request->post['config_fraud_detection'])) {
            $data['config_fraud_detection'] = $this->request->post['config_fraud_detection'];
        } else {
            $data['config_fraud_detection'] = $this->config->get('config_fraud_detection');
        }

        if (!empty($data['config_fraud_detection'])) {
            foreach ($data['config_fraud_detection'] as $index => $config_fraud_detection) {
                $data['config_fraud_detection'][$index]['select_data'] = htmlspecialchars(json_encode($config_fraud_detection));
            }
        }

        if (isset($this->request->post['config_fraud_key'])) {
            $data['config_fraud_key'] = $this->request->post['config_fraud_key'];
        } else {
            $data['config_fraud_key'] = $this->config->get('config_fraud_key');
        }

        if (isset($this->request->post['config_fraud_score'])) {
            $data['config_fraud_score'] = $this->request->post['config_fraud_score'];
        } else {
            $data['config_fraud_score'] = $this->config->get('config_fraud_score');
        }

        $time_zones = $this->get_all_time_zones();

        foreach ($time_zones as $time_zone) {
            $data['time_zones'][] = array(
                'time_zone' => $time_zone
            );
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('setting/setting', $data));
    }

    protected function validate()
    {

        // validation function
        function validStrLen($str, $min, $max)
        {
            return (utf8_strlen($str) > $min && utf8_strlen($str) < $max);
        }

        if (!$this->user->hasPermission('modify', 'setting/setting')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['config_meta_title']) {
            $this->error['meta_title'] = $this->language->get('error_meta_title');
        }

        // if (!$this->request->post['config_name']) {
        //      $this->error['name'] = $this->language->get('error_name');
        // }

        if (!validStrLen($this->request->post['config_name'], 2, 64)) {
            $this->error['name'] = $this->language->get('error_name');
        }

        if (!validStrLen($this->request->post['config_attention'], 2, 32)) {
            $this->error['attention'] = $this->language->get('error_attention');
        }

        if (!$this->request->post['config_code']) {
            $this->error['code'] = $this->language->get('error_code');
        }

        if (!$this->request->post['config_number']) {
            $this->error['number'] = $this->language->get('error_number');
        }

        if ((utf8_strlen($this->request->post['config_owner']) < 3) || (utf8_strlen($this->request->post['config_owner']) > 64)) {
            $this->error['owner'] = $this->language->get('error_owner');
        }

        if (!$this->request->post['config_gstno']) {
            $this->error['gstno'] = $this->language->get('error_gstno');
        }

        if (!is_numeric($this->request->post['config_herbal_weight']) || $this->request->post['config_herbal_weight'] < 0) {
            $this->error['herbal_weight'] = $this->language->get('error_herbal_weight');
        }

        if ((utf8_strlen($this->request->post['config_address']) < 3) || (utf8_strlen($this->request->post['config_address']) > 256)) {
            $this->error['address'] = $this->language->get('error_address');
        }

        //        if ((utf8_strlen($this->request->post['config_email']) > 96) || !filter_var($this->request->post['config_email'], FILTER_VALIDATE_EMAIL)) {
        //            $this->error['email'] = $this->language->get('error_email');
        //        }

        if ((utf8_strlen($this->request->post['config_email']) > 96) || !preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $this->request->post['config_email'])) {
            $this->error['email'] = $this->language->get('error_email');
        }

        if ((utf8_strlen($this->request->post['config_telephone']) < 3) || (utf8_strlen($this->request->post['config_telephone']) > 32)) {
            $this->error['telephone'] = $this->language->get('error_telephone');
        }

        if (!empty($this->request->post['config_customer_group_display']) && !in_array($this->request->post['config_customer_group_id'], $this->request->post['config_customer_group_display'])) {
            $this->error['customer_group_display'] = $this->language->get('error_customer_group_display');
        }

        if (!$this->request->post['config_limit_admin']) {
            $this->error['limit_admin'] = $this->language->get('error_limit');
        }

        if ($this->request->post['config_login_attempts'] < 1) {
            $this->error['login_attempts'] = $this->language->get('error_login_attempts');
        }

        if (!$this->request->post['config_voucher_min']) {
            $this->error['voucher_min'] = $this->language->get('error_voucher_min');
        }

        if (!$this->request->post['config_voucher_max']) {
            $this->error['voucher_max'] = $this->language->get('error_voucher_max');
        }

        if (!isset($this->request->post['config_processing_status'])) {
            $this->error['processing_status'] = $this->language->get('error_processing_status');
        }

        if (!isset($this->request->post['config_complete_status'])) {
            $this->error['complete_status'] = $this->language->get('error_complete_status');
        }

        if (!$this->request->post['config_image_category_width'] || !$this->request->post['config_image_category_height']) {
            $this->error['image_category'] = $this->language->get('error_image_category');
        }

        if (!$this->request->post['config_image_thumb_width'] || !$this->request->post['config_image_thumb_height']) {
            $this->error['image_thumb'] = $this->language->get('error_image_thumb');
        }

        if (!$this->request->post['config_image_popup_width'] || !$this->request->post['config_image_popup_height']) {
            $this->error['image_popup'] = $this->language->get('error_image_popup');
        }

        if (!$this->request->post['config_image_product_width'] || !$this->request->post['config_image_product_height']) {
            $this->error['image_product'] = $this->language->get('error_image_product');
        }

        if (!$this->request->post['config_image_additional_width'] || !$this->request->post['config_image_additional_height']) {
            $this->error['image_additional'] = $this->language->get('error_image_additional');
        }

        if (!$this->request->post['config_image_related_width'] || !$this->request->post['config_image_related_height']) {
            $this->error['image_related'] = $this->language->get('error_image_related');
        }

        if (!$this->request->post['config_image_compare_width'] || !$this->request->post['config_image_compare_height']) {
            $this->error['image_compare'] = $this->language->get('error_image_compare');
        }

        if (!$this->request->post['config_image_wishlist_width'] || !$this->request->post['config_image_wishlist_height']) {
            $this->error['image_wishlist'] = $this->language->get('error_image_wishlist');
        }

        if (!$this->request->post['config_image_cart_width'] || !$this->request->post['config_image_cart_height']) {
            $this->error['image_cart'] = $this->language->get('error_image_cart');
        }

        if (!$this->request->post['config_image_location_width'] || !$this->request->post['config_image_location_height']) {
            $this->error['image_location'] = $this->language->get('error_image_location');
        }

        if ($this->request->post['config_ftp_status']) {
            if (!$this->request->post['config_ftp_hostname']) {
                $this->error['ftp_hostname'] = $this->language->get('error_ftp_hostname');
            }

            if (!$this->request->post['config_ftp_port']) {
                $this->error['ftp_port'] = $this->language->get('error_ftp_port');
            }

            if (!$this->request->post['config_ftp_username']) {
                $this->error['ftp_username'] = $this->language->get('error_ftp_username');
            }

            if (!$this->request->post['config_ftp_password']) {
                $this->error['ftp_password'] = $this->language->get('error_ftp_password');
            }
        }

        if (!$this->request->post['config_error_filename']) {
            $this->error['log'] = $this->language->get('error_log_required');
        } elseif (preg_match('/\.\.[\/\\\]?/', $this->request->post['config_error_filename'])) {
            $this->error['log'] = $this->language->get('error_log_invalid');
        } elseif (substr($this->request->post['config_error_filename'], strrpos($this->request->post['config_error_filename'], '.')) != '.log') {
            $this->error['log'] = $this->language->get('error_log_extension');
        }

        if (!$this->request->post['config_product_limit']) {
            $this->error['product_limit'] = $this->language->get('error_limit');
        }

        if (!$this->request->post['config_product_description_length']) {
            $this->error['product_description_length'] = $this->language->get('error_limit');
        }

        if ((utf8_strlen($this->request->post['config_encryption']) < 32) || (utf8_strlen($this->request->post['config_encryption']) > 1024)) {
            $this->error['encryption'] = $this->language->get('error_encryption');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function theme()
    {
        if ($this->request->server['HTTPS']) {
            $server = HTTPS_CATALOG;
        } else {
            $server = HTTP_CATALOG;
        }

        // This is only here for compatibility with old themes.
        if ($this->request->get['theme'] == 'theme_default') {
            $theme = $this->config->get('theme_default_directory');
        } else {
            $theme = basename($this->request->get['theme']);
        }

        if (is_file(DIR_CATALOG . 'view/theme/' . $theme . '/image/' . $theme . '.png')) {
            $this->response->setOutput($server . 'catalog/view/theme/' . $theme . '/image/' . $theme . '.png');
        } else {
            $this->response->setOutput($server . 'image/no_image.png');
        }
    }

    public function country()
    {
        $json = array();

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);

        if ($country_info) {
            $this->load->model('localisation/zone');

            $json = array(
                'country_id' => $country_info['country_id'],
                'name' => $country_info['name'],
                'iso_code_2' => $country_info['iso_code_2'],
                'iso_code_3' => $country_info['iso_code_3'],
                'address_format' => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone' => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status' => $country_info['status']
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    private function get_all_time_zones()
    {
        $api_url = HTTP_API . 'index.php?route=appointment/appointment/get_store_time_zones';

        $time_zones = file_get_contents($api_url);

        $time_zones_arr = json_decode($time_zones);

        return $time_zones_arr;
    }

    
    //send all data to etcm
    public function sync()
    {
        $post_data = [
            'store_url'             => HTTPS_CATALOG,
            'store_info'            => $this->getStoreData(),
            'openings'              => $this->getOpeningData(),
            'holidays'              => $this->getHolidayData(),
            'doctor_holidays'       => $this->getDoctorHolidayData(),
            'users'                 => $this->getUserData(),
            'services'              => $this->getServicesData(),
            'facilities'            => $this->getFacilitiesData(),
            'doctor_availabilities' => $this->getDoctorAvailabilitiesData()
        ];

        $path = 'etcm/syncing/syncing/update_all';
        $result = $this->connectCurl($path, $post_data, false);
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($result));
    }

    protected function syncToEtcm()
    {
        $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "store")->rows;
        $store_ids = array_column($db_stores, 'store_id');
        array_unshift($store_ids, "0");

        $stores = [];

        foreach ($store_ids as $store_id) {

            $configs = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND code = 'config'")->rows;

            $info = [];
            foreach ($configs as $cnf) {
                $info[$cnf['key']] = $cnf['serialized'] == '1' ? json_decode($cnf['value'], true) : $cnf['value'];
            }

            if (empty($info)) {
                continue;
            }

            if ($store_id == '0') {
                $info['config_url'] = HTTPS_CATALOG;
            }

            $stores[] = [
                'store_id'                    => $store_id,
                'config_owner'                => !empty($info['config_owner']) ? $info['config_owner'] : '',
                'config_telephone'            => !empty($info['config_telephone']) ? $info['config_telephone'] : '',
                'config_name'                => !empty($info['config_name']) ? $info['config_name'] : '',
                'config_url'                => !empty($info['config_url']) ? $info['config_url'] : '',
                'config_address'            => !empty($info['config_address']) ? $info['config_address'] : '',
                'config_store_city'            => !empty($info['config_store_city']) ? $info['config_store_city'] : '',
                'config_store_postcode'        => !empty($info['config_store_postcode']) ? $info['config_store_postcode'] : '',
                'config_store_country_id'    => !empty($info['config_store_country_id']) ? $info['config_store_country_id'] : '',
                'config_store_zone_id'        => !empty($info['config_store_zone_id']) ? $info['config_store_zone_id'] : '',
                'config_store_latitude'        => !empty($info['config_store_latitude']) ? $info['config_store_latitude'] : '',
                'config_store_longitude'    => !empty($info['config_store_longitude']) ? $info['config_store_longitude'] : '',
                'config_store_description'    => !empty($info['config_store_description']) ? $info['config_store_description'] : '',
            ];
        }

        $post_data = [
            'store_url' => HTTPS_CATALOG,
            'store_info' => $stores
        ];

        $path = 'etcm/syncing/syncing/update_stores';
        $result = $this->connectCurl($path, $post_data);
        return $result;
    }

    private function connectCurl($path, $data, $debug = false)
    {
        $language = !empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'cn';
        if ($language == 'zh') {
            $language = 'cn';
        }

        $device_id = !empty($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : '';

        $url = 'https://www.etcm.me/index.php?route=' . $path;
        $curl = curl_init();

        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, htmlspecialchars_decode(json_encode($data)));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Accept-Language: ' . $language, 'Device-Id: ' . $device_id, 'Content-Type: application/json'));
        curl_setopt($curl, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($curl);

        if ($debug) {
            return $response;
        }

        $result = json_decode(htmlspecialchars_decode($response), true);

        curl_close($curl);

        return $result;
    }

    private function getStoreData()
    {
        $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "store")->rows;
        $store_ids = array_column($db_stores, 'store_id');
        array_unshift($store_ids, "0");

        $stores = [];
        foreach ($store_ids as $store_id) {

            $configs = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND code = 'config'")->rows;

            $info = [];
            foreach ($configs as $cnf) {
                $info[$cnf['key']] = $cnf['serialized'] == '1' ? json_decode($cnf['value'], true) : $cnf['value'];
            }

            if (empty($info)) {
                continue;
            }

            if ($store_id == '0') {
                $info['config_url'] = HTTPS_CATALOG;
            }

            $stores[] = [
                'store_id'                    => $store_id,
                'config_owner'                => !empty($info['config_owner']) ? $info['config_owner'] : '',
                'config_telephone'            => !empty($info['config_telephone']) ? $info['config_telephone'] : '',
                'config_name'                => !empty($info['config_name']) ? $info['config_name'] : '',
                'config_url'                => !empty($info['config_url']) ? $info['config_url'] : '',
                'config_address'            => !empty($info['config_address']) ? $info['config_address'] : '',
                'config_store_city'            => !empty($info['config_store_city']) ? $info['config_store_city'] : '',
                'config_store_postcode'        => !empty($info['config_store_postcode']) ? $info['config_store_postcode'] : '',
                'config_store_country_id'    => !empty($info['config_store_country_id']) ? $info['config_store_country_id'] : '',
                'config_store_zone_id'        => !empty($info['config_store_zone_id']) ? $info['config_store_zone_id'] : '',
                'config_store_latitude'        => !empty($info['config_store_latitude']) ? $info['config_store_latitude'] : '',
                'config_store_longitude'    => !empty($info['config_store_longitude']) ? $info['config_store_longitude'] : '',
                'config_store_description'    => !empty($info['config_store_description']) ? $info['config_store_description'] : '',
            ];
        }

        return $stores;
    }

    private function getOpeningData()
    {
        $db_openings = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening")->rows;
        $openings = [];

        foreach ($db_openings as $opening) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$opening['store_opening_id'] . "'")->rows;
            $openings[] = [
                "store_id"  => $opening['store_id'],
                'day'       => $opening['day'],
                'times'     => $db_times
            ];
        }
        return $openings;
    }

    private function getHolidayData()
    {
        $db_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        return $db_holidays;
    }

    private function getDoctorHolidayData()
    {
        $db_doctor_holidays = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE end >= '" . $this->db->escape(date('Y-m-d')) . "'")->rows;

        return $db_doctor_holidays;
    }

    private function getUserData()
    {
        $db_users = $this->db->query("SELECT * FROM " . DB_PREFIX . "user")->rows;
        $users = [];
        foreach ($db_users as $user) {
            $user_desc = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$user['user_id'] . "'")->row;
            $treatments = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_treatment WHERE user_id = '" . (int)$user['user_id'] . "'")->rows;

            $image = !empty($user['image']) ? HTTPS_IMAGE . $user['image'] : '';
            $users[] = [
                'user_id'               => $user['user_id'],
                'firstname'             => $user['firstname'],
                'lastname'              => $user['lastname'],
                'chinesename'           => $user['chinesename'],
                'image'                 => $image,
                'telephone'             => $user['contactno'],
                'gender'                => $user['gender'],
                'user_position'         => $user['position'],
                'position'              => !empty($user_desc['position']) ? $user_desc['position'] : '',
                'professions'           => !empty($user_desc['professions']) ? $user_desc['professions'] : '',
                'description'           => !empty($user_desc['description']) ? $user_desc['description'] : '',
                'sort_order'            => $user['doctor_sort_order'],
                'enable_appointment'    => $user['enable_appointment'],
                'show_for_appointment'  => $user['show_for_appointment'],
                'status'                => $user['status'],
                'treatments'            => $treatments
            ];
        }

        return $users;
    }

    private function getServicesData()
    {
        $service_facility_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_facility'")->num_rows;
        if (!$service_facility_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_facility` (
                `service_id` int(11) NOT NULL,
                `facility_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, facility_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $service_doctor_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_doctor'")->num_rows;
        if (!$service_doctor_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_doctor` (
                `service_id` int(11) NOT NULL,
                `doctor_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, doctor_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $service_store_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "service_to_store'")->num_rows;
        if (!$service_store_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "service_to_store` (
                `service_id` int(11) NOT NULL,
                `store_id` int(11) NOT NULL,
                PRIMARY KEY (service_id, store_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $column_exist = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service status")->num_rows;

        if (!$column_exist) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `status` INT(1) NOT NULL AFTER `cs_minute`");
        }

        $column_exist2 = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service enable_appointment")->num_rows;

        if (!$column_exist2) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `enable_appointment` INT(1) NOT NULL AFTER `status`");
        }

        $column_exist3 = $this->db->query("DESCRIBE " . DB_PREFIX . "clinical_service enable_etcm")->num_rows;

        if (!$column_exist3) {
            $this->db->query("ALTER TABLE " . DB_PREFIX . "clinical_service ADD `enable_etcm` INT(1) NOT NULL AFTER `enable_appointment`");
        }

        $db_services = $this->db->query("SELECT cs.*, en.name AS en_name, cn.name AS cn_name FROM " . DB_PREFIX . "clinical_service cs 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description en ON(en.clinicalservice_id = cs.clinicalservice_id AND en.language_id = '1') 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cn ON(cn.clinicalservice_id = cs.clinicalservice_id AND cn.language_id = '2')
        WHERE cs.enable_etcm = '1'")->rows;
        $services = [];
        foreach ($db_services as $service) {

            $service_id = $service['clinicalservice_id'];

            $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$service_id . "'")->rows;
            $stores = [];
            if (!empty($db_stores)) {
                foreach ($db_stores as $store) {
                    $stores[] = [
                        'service_id'    => $service_id,
                        'store_id'   => $store['store_id']
                    ];
                }
            } else {
                foreach (unserialize($service['store_id']) as $id) {
                    $stores[] = [
                        'service_id'   => $service_id,
                        'store_id'     => $id
                    ];
                }
            }

            $db_doctors = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$service_id . "'")->rows;
            $doctors = [];
            if (!empty($db_doctors)) {
                foreach ($db_doctors as $doctor) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'   => $doctor['doctor_id']
                    ];
                }
            } else {
                foreach (unserialize($service['doctor_id']) as $id) {
                    $doctors[] = [
                        'service_id'    => $service_id,
                        'doctor_id'     => $id
                    ];
                }
            }

            $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'")->rows;
            $facilities = [];
            foreach ($db_facilities as $facility) {
                $facilities[] = [
                    'service_id'    => $service_id,
                    'facility_id'   => $facility['facility_id']
                ];
            }

            $services[] = [
                'service_id'    => $service_id,
                'en_name'       => $service['en_name'],
                'cn_name'       => $service['cn_name'],
                'minute'        => $service['cs_minute'],
                'type'          => $service['type'],
                'stores'        => $stores,
                'doctors'       => $doctors,
                'facilities'    => $facilities,
            ];
        }

        return $services;
    }

    private function getFacilitiesData()
    {
        $facility_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "facility'")->num_rows;
        if (!$facility_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "facility` (
                `facility_id` int(11) NOT NULL  AUTO_INCREMENT , PRIMARY KEY (`facility_id`),
                `store_id` int(11) NOT NULL,
                `name` varchar(255) NOT NULL,
                `available` int(1) NOT NULL,
                `status` int(1) NOT NULL,
                `added_by` int(11) NOT NULL,
                `date_added` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                `modified_by` int(11) NOT NULL,
                `date_modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $facility_availability_exist = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "facility_availability'")->num_rows;
        if (!$facility_availability_exist) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "facility_availability` (
                `id` int(11) NOT NULL  AUTO_INCREMENT , PRIMARY KEY (`id`),
                `facility_id` int(11) NOT NULL,
                `day` varchar(255) NOT NULL,
                `start_time` varchar(255) NOT NULL,
                `end_time` varchar(255) NOT NULL
              ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility")->rows;
        $facilities = [];
        foreach ($db_facilities as $facility) {
            $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility['facility_id'] . "'")->rows;
            $facilities[] = [
                'facility_id'       => $facility['facility_id'],
                'store_id'          => $facility['store_id'],
                'name'              => $facility['name'],
                'available'         => $facility['available'],
                'status'            => $facility['status'],
                'availabilities'    => $db_availabilities,
            ];
        }

        return $facilities;
    }

    private function getDoctorAvailabilitiesData()
    {
        $availability_service = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "availability_to_service'")->num_rows;
        if (!$availability_service) {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "availability_to_service` (
                `availability_id` int(11) NOT NULL,
                `service_id` int(11) NOT NULL,
                PRIMARY KEY (availability_id, service_id)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
        }

        $db_availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability")->rows;
        $doctor_availabilities = [];
        foreach ($db_availabilities as $availability) {
            $db_times = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability_time WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $db_services = $this->db->query("SELECT * FROM " . DB_PREFIX . "availability_to_service WHERE availability_id = '" . (int)$availability['availability_id'] . "'")->rows;
            $doctor_availabilities[] = [
                'availability_id'   => $availability['availability_id'],
                'doctor_id'         => $availability['doctor_id'],
                'store_id'          => $availability['store_id'],
                'minutes'           => $availability['minutes'],
                'day'               => $availability['day'],
                'times'             => $db_times,
                'services'          => $db_services,
            ];
        }

        return $doctor_availabilities;
    }
}
