<?php

class ControllerServiceServiceForm extends Controller
{

    private $error = [];

    public function index()
    {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/service_form');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->getList();
    }

    public function addCustomer()
    {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('customer/customer');
        $this->load->model('service/service_form');



        $customer_id = isset($this->request->get['customer_id']) ? $this->request->get['customer_id'] : false;

        $data['customer_id'] = $customer_id ? $this->request->get['customer_id'] : 0;

        if (isset($this->request->get['customer_id'])) {
            $customer = $this->model_service_service_form->getCustomerbyid($this->request->get['customer_id']);
            if (!empty($customer)) {
                $data['customer_id'] = $customer['customer_id'];
                $data['email'] = $customer['email'];
                $data['telephone'] = $customer['telephone'];

                // echo'<pre>';
                // print_r($customer);
                // echo'</pre>';

                $serviceform_id = $this->model_service_service_form->addServiceForm($data);

                $this->session->data['success'] = $this->language->get('text_success');

                if ($serviceform_id > 0) {
                    $this->response->redirect($this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id . '&admin_add=1', true));
                } else {
                    $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true));
                }
            }
        }


        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateCustomerForm()) {
            $customer_info = $this->model_service_service_form->customerExistsByIc($this->request->post['customer_ic']);

            if (count($customer_info) == 0) {
                $customer_info['customer_id'] = $this->model_service_service_form->addCustomer($this->request->post);
            }

            $data['customer_id'] = $customer_info['customer_id'];

            $serviceform_id = $this->model_service_service_form->addServiceForm($data);

            $customer_row = $this->model_service_service_form->getCustomer($data['customer_id']);
            $customer_name = !empty($customer_row) ? $customer_row['firstname'] . ' ' . $customer_row['lastname'] : '';

            $serviceform_row = $this->model_service_service_form->getServiceForm($serviceform_id);
            $invoice_prefix = !empty($serviceform_row) ? $serviceform_row['info']['invoice_prefix'] : '';

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';
            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }

            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }

            if (isset($this->request->get['filter_transaction_from'])) {
                $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
            }

            if (isset($this->request->get['filter_transaction_to'])) {
                $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_firstname'])) {
                $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_payment_status'])) {
                $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
            }

            if (isset($this->request->get['filter_status_id'])) {
                $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            if (isset($serviceform_id) && $serviceform_id != 0) {
                $url .= '&serviceform_id=' . $serviceform_id;
            }

            $this->response->redirect($this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->customer();
    }

    public function searchCustomer()
    {
        $this->load->language('customer/customer');
        $this->load->model('customer/customer');

        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json['shipping'][] = array();

        $json = $this->model_service_service_form->selectCustomers($data);

        $this->cart->clearService();
        $this->cart->clearHerbal();

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Member Details";
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function edit()
    {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/service_form');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('clinicalservices');
        $this->cart = new Clinicalservices($this->registry);

        if (!$this->user->hasPermission('modify', 'service/service_form')) {
            $this->error['warning'] = $this->language->get('error_permission');
            $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true));
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && (isset($this->request->get['serviceform_id']) || isset($this->session->data['serviceform_id'])) && $this->validateForm()) {

            if (isset($this->request->get['serviceform_id'])) {
                $serviceform_id = $this->request->get['serviceform_id'];
            } else {
                $serviceform_id = $this->session->data['serviceform_id'];
            }

            $this->load->library('customer');
            $this->customer = new Customer($this->registry);

            $total_data = array();
            $sort_order = array();

            $totals = array();
            $taxes = $this->cart->getTaxes();
            $total = 0;

            $this->load->model('pos/extension');

            $total_data = array(
                'totals' => &$totals,
                'taxes' => &$taxes,
                'total' => &$total
            );

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get('total_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }

            $this->model_service_service_form->editServiceForm($serviceform_id, $this->request->post, $this->cart->getServices(), $totals);

            $this->load->language('service/service_form');

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . $this->request->get['filter_name'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
            }

            if (isset($this->request->get['filter_start_date'])) {
                $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
            }

            if (isset($this->request->get['filter_end_date'])) {
                $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
            }

            if (isset($this->request->get['filter_status_id'])) {
                $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete()
    {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('service/service_form');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];

            foreach ($selected as $serviceform_id) {
                $this->model_service_service_form->deleteServiceForm($serviceform_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_invoice_prefix'])) {
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
            }

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name=' . $this->request->get['filter_name'];
            }

            if (isset($this->request->get['filter_customer_ic'])) {
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
            }

            if (isset($this->request->get['filter_customer_card'])) {
                $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
            }

            if (isset($this->request->get['filter_start_date'])) {
                $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
            }

            if (isset($this->request->get['filter_end_date'])) {
                $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
            }

            if (isset($this->request->get['filter_status_id'])) {
                $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function customer()
    {
        $data['text_form'] = !isset($this->request->get['clinical_sale_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['filed_male'] = $this->language->get('text_male');
        $data['filed_female'] = $this->language->get('text_female');

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['customer_ic'])) {
            $data['error_customer_ic'] = $this->error['customer_ic'];
        } else {
            $data['error_customer_ic'] = '';
        }

        if (isset($this->error['dob'])) {
            $data['error_dob'] = $this->error['dob'];
        } else {
            $data['error_dob'] = '';
        }

        if (isset($this->error['email'])) {
            $data['error_email'] = $this->error['email'];
        } else {
            $data['error_email'] = '';
        }

        if (isset($this->error['firstname'])) {
            $data['error_firstname'] = $this->error['firstname'];
        } else {
            $data['error_firstname'] = '';
        }

        if (isset($this->error['lastname'])) {
            $data['error_lastname'] = $this->error['lastname'];
        } else {
            $data['error_lastname'] = '';
        }

        if (isset($this->error['telephone'])) {
            $data['error_telephone'] = $this->error['telephone'];
        } else {
            $data['error_telephone'] = '';
        }

        if (isset($this->error['password'])) {
            $data['error_password'] = $this->error['password'];
        } else {
            $data['error_password'] = '';
        }

        if (isset($this->error['confirm'])) {
            $data['error_confirm'] = $this->error['confirm'];
        } else {
            $data['error_confirm'] = '';
        }

        if (isset($this->error['address'])) {
            $data['error_address'] = $this->error['address'];
        } else {
            $data['error_address'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_transaction_from'])) {
            $url .= '&filter_transaction_from=' . $this->request->get['filter_transaction_from'];
        }

        if (isset($this->request->get['filter_transaction_to'])) {
            $url .= '&filter_transaction_to=' . $this->request->get['filter_transaction_to'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . urlencode(html_entity_decode($this->request->get['filter_customer_card'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_firstname'])) {
            $url .= '&filter_customer_firstname=' . urlencode(html_entity_decode($this->request->get['filter_customer_firstname'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status_id'])) {
            $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('service/service_form/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['cancel'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true);


        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } else {
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
        }

        if (isset($this->request->post['firstname'])) {
            $data['firstname'] = $this->request->post['firstname'];
        } else {
            $data['firstname'] = '';
        }

        if (isset($this->request->post['lastname'])) {
            $data['lastname'] = $this->request->post['lastname'];
        } else {
            $data['lastname'] = '';
        }

        if (isset($this->request->post['home'])) {
            $data['home'] = $this->request->post['home'];
        } else {
            $data['home'] = '';
        }

        if (isset($this->request->post['gender'])) {
            $data['gender'] = $this->request->post['gender'];
        } else {
            $data['gender'] = 1;
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = 0;
        }

        if (isset($this->request->post['dob'])) {
            $data['dob'] = $this->request->post['dob'];
        } else {
            $data['dob'] = '';
        }

        if (isset($this->request->post['email'])) {
            $data['email'] = $this->request->post['email'];
        } else {
            $data['email'] = '';
        }

        if (isset($this->request->post['telephone'])) {
            $data['telephone'] = $this->request->post['telephone'];
        } else {
            $data['telephone'] = '';
        }

        if (isset($this->request->post['telephone2'])) {
            $data['telephone2'] = $this->request->post['telephone2'];
        } else {
            $data['telephone2'] = '';
        }

        if (isset($this->request->post['fax'])) {
            $data['fax'] = $this->request->post['fax'];
        } else {
            $data['fax'] = '';
        }

        // Custom Fields
        $this->load->model('customer/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_customer_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        if (isset($this->request->post['custom_field'])) {
            $data['account_custom_field'] = $this->request->post['custom_field'];
        } else {
            $data['account_custom_field'] = array();
        }

        if (isset($this->request->post['newsletter'])) {
            $data['newsletter'] = $this->request->post['newsletter'];
        } else {
            $data['newsletter'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['approved'])) {
            $data['approved'] = $this->request->post['approved'];
        } else {
            $data['approved'] = true;
        }

        if (isset($this->request->post['safe'])) {
            $data['safe'] = $this->request->post['safe'];
        } else {
            $data['safe'] = 0;
        }

        if (isset($this->request->post['password'])) {
            $data['password'] = $this->request->post['password'];
        } else {
            $data['password'] = '';
        }

        if (isset($this->request->post['confirm'])) {
            $data['confirm'] = $this->request->post['confirm'];
        } else {
            $data['confirm'] = '';
        }

        if (isset($this->request->post['address'])) {
            $data['addresses'] = $this->request->post['address'];
        } else {
            $data['addresses'] = array();
        }

        if (isset($this->request->post['address_id'])) {
            $data['address_id'] = $this->request->post['address_id'];
        } else {
            $data['address_id'] = '';
        }

        $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

        $this->load->model('localisation/country');
        $data['countries'] = $this->model_localisation_country->getCountries();

        $this->load->model('customer/customer_group');
        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/customer_form', $data));
    }

    public function sfuSessionUpdateStartTime()
    {
        $json = array('success' => false);

        if (isset($this->request->get['clinicalservice_id'])) {

            $clinicalservice_id = isset($this->request->get['clinicalservice_id']) ? $this->request->get['clinicalservice_id'] : false;
            $startTimeValue = isset($this->request->get['starttime']) ? $this->request->get['starttime'] : false;

            if ($clinicalservice_id && $startTimeValue) {
                $this->load->library('tax');
                $this->tax = new Tax($this->registry);

                $this->load->library('clinicalservices');
                $this->cart = new Clinicalservices($this->registry);

                $json = $this->cart->setStartTime($clinicalservice_id, $startTimeValue);
                $json['success'] = true;
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function sfuSessionUpdateEndTime()
    {
        $json = array('success' => false);

        if (isset($this->request->get['clinicalservice_id'])) {

            $clinicalservice_id = isset($this->request->get['clinicalservice_id']) ? $this->request->get['clinicalservice_id'] : false;
            $endTimeValue = isset($this->request->get['endtime']) ? $this->request->get['endtime'] : false;

            if ($clinicalservice_id && $endTimeValue) {
                $this->load->library('tax');
                $this->tax = new Tax($this->registry);

                $this->load->library('clinicalservices');
                $this->cart = new Clinicalservices($this->registry);

                $json = $this->cart->setEndTime($clinicalservice_id, $endTimeValue);
                $json['success'] = true;
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function sfSessionAddService()
    {
        $json = array('success' => false);

        if (isset($this->request->get['clinicalservice_id'])) {

            $clinicalservice_id = isset($this->request->get['clinicalservice_id']) ? $this->request->get['clinicalservice_id'] : false;

            if ($clinicalservice_id) {
                $staff_id = isset($this->request->get['staff_id']) ? $this->request->get['staff_id'] : NULL;
                $price = isset($this->request->get['price']) ? $this->request->get['price'] : NULL;
                $starttime = isset($this->request->get['starttime']) ? $this->request->get['starttime'] : NULL;
                $endtime = isset($this->request->get['endtime']) ? $this->request->get['endtime'] : NULL;

                $this->load->library('tax');
                $this->tax = new Tax($this->registry);

                $this->load->library('clinicalservices');
                $this->cart = new Clinicalservices($this->registry);

                if (!$this->cart->has($clinicalservice_id)) {
                    $json = $this->cart->set($clinicalservice_id, $staff_id, $price, $starttime, $endtime);

                    foreach ($json as $id => $service) {
                        $json[$id]['price'] = $this->currency->format($service['price'], $this->config->get('config_currency'));
                        $json[$id]['tax'] = $this->currency->format($service['tax'], $this->config->get('config_currency'));
                    }

                    $json['success'] = true;
                } else {
                    $json['success'] = 'exists';
                }
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function sfSessionDeleteService()
    {
        $json = array("success" => false);

        if (isset($this->request->get['clinicalservice_id'])) {

            $clinicalservice_id = isset($this->request->get['clinicalservice_id']) ? $this->request->get['clinicalservice_id'] : false;

            if ($clinicalservice_id) {
                $this->load->library('tax');
                $this->tax = new Tax($this->registry);

                $this->load->library('clinicalservices');
                $this->cart = new Clinicalservices($this->registry);

                $json = array(
                    "id" => $this->cart->remove($clinicalservice_id),
                    "success" => true
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function info()
    {
        $this->load->model('service/service_form');

        $serviceform_id = isset($this->request->get['serviceform_id']) ? $this->request->get['serviceform_id'] : 0;

        $serviceform_info = $this->model_service_service_form->getServiceForm($serviceform_id);

        if ($serviceform_info) {
            $this->load->language('service/service_form');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['serviceno'] = $serviceform_info['info']['invoice_prefix'];
            $data['remark'] = $serviceform_info['info']['remark'];
            $data['service_date'] = DATE('Y-m-d', strtotime($serviceform_info['info']['date_added']));
            $data['customer_ic'] = $serviceform_info['info']['customer_ic'];
            $data['customer_card'] = $serviceform_info['info']['customer_card'];
            $data['customer_name'] = $serviceform_info['info']['name'];
            $data['gender'] = $serviceform_info['info']['gender'];
            $data['dob'] = $serviceform_info['info']['dob'];
            $data['age'] = $this->calculateAge($data['dob']) . ' ' . $this->language->get('text_age');
            $data['address_1'] = $serviceform_info['info']['address_1'];
            $data['address_2'] = $serviceform_info['info']['address_2'];
            $data['address_3'] = $serviceform_info['info']['address_3'];
            $data['city'] = $serviceform_info['info']['city'];
            $data['postcode'] = $serviceform_info['info']['postcode'];
            $data['country'] = $serviceform_info['info']['country'];
            $data['state'] = $serviceform_info['info']['state'];
            $data['phone'] = $serviceform_info['info']['telephone'];
            $data['aphone'] = $serviceform_info['info']['telephone2'];
            $data['home'] = $serviceform_info['info']['home'];
            $data['fax'] = $serviceform_info['info']['fax'];

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('clinicalservices');
            $this->cart = new Clinicalservices($this->registry);
            $this->cart->setArray($serviceform_info['service_item_array']);

            $services = $this->cart->getServices();
            $data['services'] = $services;

            foreach ($services as $clinicalservice_id => $service) {
                $service_item_info = $this->model_service_service_form->getServiceItem($serviceform_id, $clinicalservice_id);

                if (!empty($service_item_info)) {
                    $service_Item_id = $service_item_info['service_Item_id'];

                    $acupuncture_points = $this->model_service_service_form->getAcupuncturePointByServiceItemId($service_Item_id);

                    if (!empty($acupuncture_points)) {
                        $data['services'][$clinicalservice_id]['acupuncture_points'] = $acupuncture_points;
                    } else {
                        $data['services'][$clinicalservice_id]['acupuncture_points'] = array();
                    }
                }
            }

            $data['services_subtotal'] = $this->cart->getFormatedSubTotal();
            $data['services_total_tax'] = $this->cart->getFormatedTotalTax();
            $data['services_total'] = $this->cart->getFormatedTotal();

            $data['totals'] = array();

            $totals = $this->model_service_service_form->getServiceTotals($serviceform_id);

            foreach ($totals as $total) {
                $data['totals'][] = array(
                    'title' => $total['title'],
                    'text' => $this->currency->format($total['value'], $this->config->get('config_currency')),
                );
            }

            $this->cart->clear();

            $url = '';

            if (isset($this->request->get['sort']))
                $url .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $url .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $url .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_invoice_prefix']))
                $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];

            if (isset($this->request->get['filter_name']))
                $url .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_customer_ic']))
                $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];

            if (isset($this->request->get['filter_customer_card']))
                $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];

            if (isset($this->request->get['filter_start_date']))
                $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];

            if (isset($this->request->get['filter_end_date']))
                $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];

            if (isset($this->request->get['filter_status_id']))
                $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];

            $data['cancel'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true);
            $data['edit'] = $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id . $url, true);

            if ($serviceform_info['info']['serviceform_action'] == '1') {
                $data['enable_edit'] = true;
            } else {
                $data['enable_edit'] = false;
            }

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('service/service_form_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    protected function getList()
    {

        if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = 'all';
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_start_date = $filter_date_start2;
        } else if (isset($this->request->get['filter_start_date'])) {
            $filter_start_date = $this->request->get['filter_start_date'];
        } else {
            $filter_start_date = '';
        }

        if ($filter_date_type != 'custom') {
            $filter_end_date = $filter_date_end2;
        } else if (isset($this->request->get['filter_end_date'])) {
            $filter_end_date = $this->request->get['filter_end_date'];
        } else {
            $filter_end_date = '';
        }


        if (isset($this->request->get['filter_invoice_prefix'])) {
            $filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
        } else {
            $filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $filter_customer_card = $this->request->get['filter_customer_card'];
        } else {
            $filter_customer_card = '';
        }

        if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '';
		}

        if (isset($this->request->get['filter_status_id'])) {
            $filter_status_id = $this->request->get['filter_status_id'];
        } else {
            $filter_status_id = '';
        }

        if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}

        if (isset($this->request->get['filter_service_name'])) {
			$filter_service_name = $this->request->get['filter_service_name'];
		} else {
			$filter_service_name = '';
		}

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'service_date';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_doctor_name'])) {
            $url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_status_id'])) {
            $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = [];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['breadcrumbs'][] = [
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true)
        ];

        $data['service_forms'] = [];

        $filter_data = [
            'filter_date_type'      => $filter_date_type,
            'filter_invoice_prefix' => $filter_invoice_prefix,
            'filter_name' => $filter_name,
            'filter_customer_ic' => $filter_customer_ic,
            'filter_customer_card' => $filter_customer_card,
            'filter_start_date' => $filter_start_date,
            'filter_end_date' => $filter_end_date,
            'filter_payment_status' => $filter_payment_status,
            'filter_status_id' => $filter_status_id,
            'filter_doctor_name' => $filter_doctor_name,
            'filter_service_name' => $filter_service_name,
            'filter_store_id'   => $filter_store_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        ];

        $results = $this->model_service_service_form->getServiceFormList($filter_data);
        $service_form_total = $this->model_service_service_form->totalServiceForm($filter_data);

        foreach ($results as $result) {
            $payment_label = '';

            switch ($result['order_action']) {
                case 1:
                    $payment_label = 'warning';
                    break;
                case 5:
                    $payment_label = 'success';
                    break;
                case 7:
                case 17:
                    $payment_label = 'danger';
                    break;
            }

            $label = '';

            switch ($result['serviceform_action']) {
                case 1:
                    $label = 'warning';
                    break;
                case 5:
                    $label = 'success';
                    break;
                case 7:
                    $label = 'danger';
                    break;
            }

            $data['service_forms'][] = array(
                'serviceform_id' => $result['service_form_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'name' => $result['name'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'label' => $label,
                'status_id' => $result['serviceform_action'],
                'status' => $result['status'],
                'total_item' => $result['total_item'],
                'total_price' => $this->currency->format($result['total_price'], $this->config->get('config_currency')),
                'order_invoice_prefix' => $result['order_invoice_prefix'],
                'order_id' => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true),
                'remark' => $result['remark'],
                'add_by' => $result['add_by'],
                'date_added' => $result['date_added'],
                'modifi_by' => $result['modifi_by'],
                'date_modified' => $result['date_modified'],
                'payment_label' => $payment_label,
                'payment_status_id' => $result['order_action'],
                'payment_status' => $result['payment_status'],
                'service_date' => date('Y-m-d', strtotime($result['service_date'])),
                'edit' => $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $result['service_form_id'] . $url, true),
                'info' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $result['service_form_id'] . $url, true)
            );
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status_id'])) {
            $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
        }

        if (isset($this->request->get['filter_doctor_name'])) {
            $url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        // $data['sort_service_date'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=service_date' . $url, true);
        // $data['sort_serviceno'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        // $data['sort_customer_name'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url, true);
        // $data['sort_customer_ic'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_ic' . $url, true);
        // $data['sort_customer_card_no'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_card' . $url, true);
        // $data['sort_post_no'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=post_no' . $url, true);
        // $data['sort_post_no'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=post_no' . $url, true);
        // $data['sort_total'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $url, true);
        // $data['sort_payment_status'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=order_action' . $url, true);
        // $data['sort_status'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($this->request->get['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
        }

        if (isset($this->request->get['filter_date_type'])) {
            $url .= '&filter_date_type=' . $this->request->get['filter_date_type'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_status_id'])) {
            $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
        }

        if (isset($this->request->get['filter_doctor_name'])) {
            $url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $service_form_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($service_form_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($service_form_total - $this->config->get('config_limit_admin'))) ? $service_form_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $service_form_total, ceil($service_form_total / $this->config->get('config_limit_admin')));

        $data['add'] = $this->url->link('service/service_form/addCustomer', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link("service/service_form/delete", 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['add_customer'] = $this->url->link("customer/customer/add", 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['edit_btn'] = false;
        $data['add_btn'] = false;

        //checking if got permission

        if ($this->user->hasPermission('modify', 'service/service_form')) {
            $data['edit_btn'] = true;
        }

        if ($this->user->hasPermission('modify', 'service/service_form')) {
            $data['add_btn'] = true;
        }

        $this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$data['user_view'] = $this->user->user_view;

        $data['user_token'] = $this->session->data['user_token'];

        $data['serviceform_status'] = $this->model_service_service_form->serviceFormStatusList();
        $data['service_statuses'] = $this->model_service_service_form->getServiceStatuses();
		$data['payment_statuses'] = $this->model_service_service_form->getPaymentStatuses();
		$data['transaction_no'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
		date_default_timezone_set('Asia/Kuala_Lumpur');
        $date = date('d-m-y h:i:s');
        $data['datetime'] = $date;

        $data['doctors'] = $this->model_service_service_form->getdoctorlist();
		$data['itemlist'] = $this->model_service_service_form->getservicename();
        $data['date_types'] = $this->getDateTypes();
		$data['filter_date_type'] = $filter_data['filter_date_type'];

        $data['filter_invoice_prefix'] = $filter_invoice_prefix;
        $data['filter_name'] = $filter_name;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_customer_card'] = $filter_customer_card;
        $data['filter_start_date'] = $filter_start_date;
        $data['filter_end_date'] = $filter_end_date;
        $data['filter_status_id'] = explode(',',$filter_status_id);
		$data['filter_payment_status'] = explode(',',$filter_payment_status);
		$data['filter_doctor_name'] = explode(',',$filter_doctor_name);
		$data['filter_service_name'] = explode(',',$filter_service_name);
		$data['filter_store_id'] = explode(',',$filter_store_id);

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/service_form_list', $data));
    }

    protected function getForm()
    {
        $this->document->addScript('view/javascript/herbal/jquery.form.js');

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $this->cart->clear();

        $this->session->data['serviceform_id'] = false;

        $serviceform_id = isset($this->request->get['serviceform_id']) ? $this->request->get['serviceform_id'] : 0;

        $serviceno = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

        $data["form_memory_service_no"] = isset($this->request->post['serviceno']) ? // if request post from form
            $this->request->post['serviceno'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'invoice_prefix') :
                $serviceno
            ); //serviceno

        $data["form_memory_service_date"] = isset($this->request->post['date_added']) ? // if request post from form
            $this->request->post['date_added'] : (isset($this->request->get['serviceform_id']) ?
                DATE('Y-m-d', strtotime($this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'date_added'))) :
                NULL
            ); //service date

        $data["form_memory_customer_ic"] = isset($this->request->post['customer_ic']) ? // if request post from form
            $this->request->post['customer_ic'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'customer_ic') :
                NULL
            ); //customer_ic

        $data["form_memory_customer_card"] = isset($this->request->post['customer_card']) ? // if request post from form
            $this->request->post['customer_card'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'customer_card') :
                NULL
            ); //customer_card

        $data["form_memory_customer_first_name"] = isset($this->request->post['customer_first_name']) ? // if request post from form
            $this->request->post['customer_first_name'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'firstname') :
                NULL
            ); //customer_first_name

        $data["form_memory_customer_last_name"] = isset($this->request->post['customer_last_name']) ? // if request post from form
            $this->request->post['customer_last_name'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'lastname') :
                NULL
            ); //customer_last_name

        $data["form_memory_customer_gender"] = isset($this->request->post['customer_gender']) ? // if request post from form
            $this->request->post['customer_gender'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'gender') :
                NULL
            ); //customer_gender

        $data["form_memory_customer_dob"] = isset($this->request->post['dob']) ? // if request post from form
            $this->request->post['dob'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'dob') :
                NULL
            ); //customer_dob

        $data['form_memory_customer_age'] = $this->calculateAge($data['form_memory_customer_dob']) . ' ' . $this->language->get('text_age');

        $data["form_memory_customer_address1"] = isset($this->request->post['customer_address1']) ? // if request post from form
            $this->request->post['customer_address1'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'address_1') :
                NULL
            ); //customer_address line 1

        $data["form_memory_customer_address2"] = isset($this->request->post['customer_address2']) ? // if request post from form
            $this->request->post['customer_address2'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'address_2') :
                NULL
            ); //customer_address line 2

        $data["form_memory_customer_address3"] = isset($this->request->post['customer_address3']) ? // if request post from form
            $this->request->post['customer_address3'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'address_3') :
                NULL
            ); //customer_address line 3

        $data["form_memory_customer_city"] = isset($this->request->post['customer_city']) ? // if request post from form
            $this->request->post['customer_city'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'city') :
                NULL
            ); //customer_address line 3

        $data["form_memory_customer_postcode"] = isset($this->request->post['customer_postcode']) ? // if request post from form
            $this->request->post['customer_postcode'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'postcode') :
                NULL
            ); //customer_postcode

        $data["form_memory_customer_countries"] = isset($this->request->post['customer_countries']) ? // if request post from form
            $this->request->post['customer_countries'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'country_id') :
                NULL
            ); //customer_countries

        $data["form_memory_customer_state"] = isset($this->request->post['customer_state']) ? // if request post from form
            $this->request->post['customer_state'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'zone') :
                NULL
            ); //customer_state

        $data["form_memory_customer_fax"] = isset($this->request->post['customer_fax']) ? // if request post from form
            $this->request->post['customer_fax'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'fax') :
                NULL
            ); //customer_phone

        $data["form_memory_customer_phone"] = isset($this->request->post['customer_phone']) ? // if request post from form
            $this->request->post['customer_phone'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'telephone') :
                NULL
            ); //customer_phone

        $data["form_memory_customer_phone2"] = isset($this->request->post['customer_phone2']) ? // if request post from form
            $this->request->post['customer_phone2'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'telephone2') :
                NULL
            ); //customer_phone2

        $data["form_memory_customer_home"] = isset($this->request->post['customer_home']) ? // if request post from form
            $this->request->post['customer_home'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'home') :
                NULL
            ); //customer_home

        $data["form_memory_service_action"] = isset($this->request->post['action']) ? // if request post from form
            $this->request->post['action'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'serviceform_action') :
                0
            ); //service form action

        $data["form_memory_service_remark"] = isset($this->request->post['remark']) ? // if request post from form
            $this->request->post['remark'] : (isset($this->request->get['serviceform_id']) ?
                $this->model_service_service_form->getServiceFormColumn($this->request->get['serviceform_id'], 'remark') :
                ''
            ); //service form action

        if (isset($this->request->get['serviceform_id'])) {
            $service1_session = $this->model_service_service_form->getServiceItemSesionFormat($this->request->get['serviceform_id']);
            $memory_services1 = $this->cart->setArray($service1_session);
        } else {
            $service1_session = array();
            $memory_services1 = array();
        }

        if (isset($this->request->get['history_id'])) {
            $service2_session = $this->model_service_service_form->getServiceItemSesionFormat($this->request->get['history_id']);
            $memory_services2 = $this->cart->setArray($service2_session);
        } else {
            $service2_session = array();
            $memory_services2 = array();
        }

        $memory_services_merge = array_merge($memory_services1, $memory_services2);

        $memory_services = array();

        foreach ($memory_services_merge as $service) {
            $memory_services[$service['service_id']] = $service;
        }

        $this->currency->set($this->config->get('config_currency'));

        $service_session_merge = array_merge($service1_session, $service2_session);

        $service_session = array();

        foreach ($service_session_merge as $service_merge) {
            $service_session[$service_merge['service_id']] = $service_merge;
        }

        $this->cart->setArray($service_session);

        foreach ($memory_services as $id => $service) {
            $memory_services[$id]['price'] = $this->currency->format($service['price'], $this->config->get('config_currency'));
            $memory_services[$id]['tax'] = $this->currency->format($service['tax'], $this->config->get('config_currency'));
        }

        $data['form_memory_services'] = json_encode($memory_services);

        if (isset($this->request->get['serviceform_id'])) {
            $service_items = $this->model_service_service_form->getServiceItems($this->request->get['serviceform_id']);

            if (!empty($service_items)) {
                foreach ($service_items as $item) {
                    $acupuncture_from_service = $this->model_service_service_form->getAcupuncturePointByServiceItemId($item['service_Item_id']);

                    if (!empty($acupuncture_from_service)) {
                        foreach ($acupuncture_from_service as $acupuncture_point) {
                            $acupuncture_points[] = array(
                                'acupuncture_point_id' => $acupuncture_point['acupuncture_id'],
                                'acupuncture_point' => $acupuncture_point['acupuncture_point'],
                                'num_of_acupuncture' => $acupuncture_point['num_of_acupuncture']
                            );
                        }
                    } else {
                        $acupuncture_points = array();
                    }

                    $service_acupuncture1[] = array(
                        'id' => $item['clinicalservice_id'],
                        'acupuncture_points' => $acupuncture_points
                    );

                    unset($acupuncture_points);
                }
            } else {
                $service_acupuncture1 = array();
            }
        }

        if (isset($this->request->get['history_id'])) {
            $service_items = $this->model_service_service_form->getServiceItems($this->request->get['history_id']);

            if (!empty($service_items)) {
                foreach ($service_items as $item) {
                    $acupuncture_from_service = $this->model_service_service_form->getAcupuncturePointByServiceItemId($item['service_Item_id']);

                    if (!empty($acupuncture_from_service)) {
                        foreach ($acupuncture_from_service as $acupuncture_point) {
                            $acupuncture_points[] = array(
                                'acupuncture_point_id' => $acupuncture_point['acupuncture_id'],
                                'acupuncture_point' => $acupuncture_point['acupuncture_point'],
                                'num_of_acupuncture' => $acupuncture_point['num_of_acupuncture']
                            );
                        }
                    } else {
                        $acupuncture_points = array();
                    }

                    $service_acupuncture2[] = array(
                        'id' => $item['clinicalservice_id'],
                        'acupuncture_points' => $acupuncture_points
                    );

                    unset($acupuncture_points);
                }
            } else {
                $service_acupuncture2 = array();
            }
        } else {
            $service_acupuncture2 = array();
        }

        $service_acupuncture = array_merge($service_acupuncture1, $service_acupuncture2);

        $data['form_service_acupuncture'] = json_encode($service_acupuncture);

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true)
        );

        if (isset($this->request->get['serviceform_id'])) {
            $serviceform_data = $this->model_service_service_form->getServiceForm($this->request->get['serviceform_id']);

            // if ((isset($this->request->get['serviceform_id'])) && ($serviceform_data['info']['serviceform_action'] == '1') && (empty($serviceform_data['info']['order_invoice_prefix']))) {
                // $data['change_cus'] = 1;
                $data['button_change_customer'] = $this->language->get('button_change_customer');
                $data['change_customer'] = $this->url->link('service/service_form/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $this->request->get['serviceform_id'], true);
            // } else {
            //     $data['change_cus'] = 0;
            // }

            $data['customer_id'] = $serviceform_data['info']['customer_id'];
        }

        // $data['edit_service_form'] = isset($this->request->get['serviceform_id']) ? true : false;
        $data['edit_service_form'] = true;
        $data['serviceform_item_tab'] = isset($this->request->get['serviceform_item_tab']) ? '1' : '0';
        $data['serviceform_history_tab'] = isset($this->request->get['serviceform_history_tab']) ? '1' : '0';

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . $this->request->get['filter_name'];
        }

        if (isset($this->request->get['filter_ic'])) {
            $url .= '&filter_ic=' . $this->request->get['filter_ic'];
        }

        if (isset($this->request->get['filter_customer_card'])) {
            $url .= '&filter_customer_card=' . $this->request->get['filter_customer_card'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if (isset($this->request->get['filter_status_id'])) {
            $url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
        }

        $data['cancel'] = $this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['serviceform_id'])) {
            $url .= '&serviceform_id=' . $this->request->get['serviceform_id'];
        }

        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : '';
        $data['error_name_customer_ic'] = $this->language->get('error_service_form_customer_ic');
        $data['error_name_card'] = $this->language->get('error_service_form_customer_card');
        $data['error_name_first_name'] = $this->language->get('error_service_form_first_name');
        $data['error_name_last_name'] = $this->language->get('error_service_form_last_name');
        $data['error_name_address'] = $this->language->get('error_service_form_address');
        $data['error_name_city'] = $this->language->get('error_service_form_city');
        $data['error_name_postcode'] = $this->language->get('error_service_form_postcode');
        $data['error_name_phone'] = $this->language->get('error_service_form_phone');

        $data['error_name_staff'] = $this->language->get('error_service_form_staff');
        $data['error_name_service'] = $this->language->get('error_service_form_service');

        $data['error_category'] = $this->language->get('error_category');
        $data['error_ic'] = $this->language->get('error_ic');

        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : '';
        unset($this->session->data['success']);

        $data['action'] = $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['user_token'] = $this->session->data['user_token'];
        $data['serviceform_id'] = $this->model_service_service_form->validServiceFormId($serviceform_id) ? $serviceform_id : false;
        $data['text_form'] = !(isset($this->request->get['serviceform_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['serviceform_status'] = $this->model_service_service_form->serviceFormStatusList();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/service_form_form', $data));
    }

    public function changeCustomer()
    {
        $this->load->language('service/service_form');
        $this->load->model('service/service_form');

        $this->document->setTitle($this->language->get('button_change_customer'));

        $serviceform_id = $this->request->get['serviceform_id'];

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateChangeCustomer()) {
            //update customer id into service table
            $this->model_service_service_form->updateCustomer($serviceform_id, $this->request->post['customer_id']);

            $this->response->redirect($this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id, true));
        }

        $serviceform_data = $this->model_service_service_form->getServiceForm($serviceform_id);

        // if (($serviceform_data['info']['serviceform_action'] == '5') && (!empty($serviceform_data['info']['order_invoice_prefix']))) {
        //     $this->response->redirect($this->url->link('service/service_form', 'user_token=' . $this->session->data['user_token'], true));
        // }

        $data['heading_title'] = $this->language->get('button_change_customer');

        $data['text_form'] = $this->language->get('button_change_customer');

        $data['error_not_found'] = $this->language->get('error_not_found');

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id, true)
        );

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($serviceform_data)) {
            $data['invoice_prefix'] = $serviceform_data['info']['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = '';
        }

        if (isset($this->request->post['customer_name'])) {
            $data['customer_name'] = $this->request->post['customer_name'];
        } else {
            $data['customer_name'] = '';
        }

        if (isset($this->request->post['customer_id'])) {
            $data['customer_id'] = $this->request->post['customer_id'];
        } else {
            $data['customer_id'] = '';
        }

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        } else {
            $data['customer_ic'] = '';
        }

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        } else {
            $data['customer_card'] = '';
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['cancel'] = $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id, true);
        $data['action'] = $this->url->link('service/service_form/changeCustomer', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $serviceform_id, true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('service/change_customer_form', $data));
    }

    public function customer_list()
    {
        $this->load->language('service/service_form');

        $this->document->setTitle($this->language->get('text_customer_list'));

        $this->load->model('service/service_form');

        if (isset($this->request->get['customer_name'])) {
            $customer_name = $this->request->get['customer_name'];
        } else {
            $customer_name = NULL;
        }

        if (isset($this->request->get['customer_ic'])) {
            $customer_ic = $this->request->get['customer_ic'];
        } else {
            $customer_ic = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['customer_name'])) {
            $url .= '&customer_name=' . urlencode(html_entity_decode($this->request->get['customer_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_ic'])) {
            $url .= '&customer_ic=' . urlencode(html_entity_decode($this->request->get['customer_ic'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['customers'] = array();

        $filter_data = array(
            'customer_name' => $customer_name,
            'customer_ic' => $customer_ic,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_customers = $this->model_service_service_form->getTotalCustomers($filter_data);
        $results = $this->model_service_service_form->getCustomers($filter_data);
        foreach ($results as $result) {
            $data['customers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'customer_card' => $result['customer_card'],
                'data_encoded' => htmlspecialchars(json_encode($result))
            );
        }

        $data['text_list'] = $this->language->get('text_customer_list');

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('service/service_form/customer_list', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['customer_name'] = $customer_name;
        $data['customer_ic'] = $customer_ic;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/service_customer_name_list', $data));
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'service/service_form')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $services = $this->cart->getServices();

        if ($this->request->post['action'] == 5 && empty($services)) {
            $this->error['warning'] = $this->language->get('error_no_service');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateCustomerForm()
    {
        if (!$this->user->hasPermission('modify', 'service/service_form')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }


        if ($this->request->post['customer_id'] == 0) {
            if ((utf8_strlen($this->request->post['firstname']) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
                $this->error['firstname'] = $this->language->get('error_firstname');
            }

            if ((utf8_strlen($this->request->post['lastname']) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
                $this->error['lastname'] = $this->language->get('error_lastname');
            }

            if ((utf8_strlen($this->request->post['telephone']) < 3) || (utf8_strlen($this->request->post['telephone']) > 32)) {
                $this->error['telephone'] = $this->language->get('error_telephone');
            }

            if ((utf8_strlen($this->request->post['customer_ic']) < 3) || (utf8_strlen($this->request->post['customer_ic']) > 32)) {
                $this->error['customer_ic'] = $this->language->get('error_customer_ic');
            }

            if (!empty($this->request->post['email'])) {
                if ((utf8_strlen($this->request->post['email']) > 96) || !preg_match('/^[^\@]+@.*\.[a-z]{2,6}$/i', $this->request->post['email'])) {
                    $this->error['email'] = $this->language->get('error_email');
                }

                $customer_info = $this->model_service_service_form->getCustomerByEmail($this->request->post['email']);

                if (!isset($this->request->get['customer_id'])) {
                    if ($customer_info) {
                        $this->error['warning'] = $this->language->get('error_exists');
                    }
                } else {
                    if ($customer_info && ($this->request->get['customer_id'] != $customer_info['customer_id'])) {
                        $this->error['warning'] = $this->language->get('error_exists');
                    }
                }
            }

            $this->load->model('customer/custom_field');

            $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $this->request->post['customer_group_id']));

            foreach ($custom_fields as $custom_field) {
                if (($custom_field['location'] == 'account') && $custom_field['required'] && empty($this->request->post['custom_field'][$custom_field['custom_field_id']])) {
                    $this->error['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                }
            }

            if ($this->request->post['password'] || (!isset($this->request->get['customer_id']))) {
                if ($this->request->post['password'] != $this->request->post['confirm']) {
                    $this->error['confirm'] = $this->language->get('error_confirm');
                }
            }

            if (isset($this->request->post['address'])) {
                foreach ($this->request->post['address'] as $key => $value) {
                    if ((utf8_strlen($value['firstname']) < 1) || (utf8_strlen($value['firstname']) > 32)) {
                        $this->error['address'][$key]['firstname'] = $this->language->get('error_firstname');
                    }

                    if ((utf8_strlen($value['lastname']) < 1) || (utf8_strlen($value['lastname']) > 32)) {
                        $this->error['address'][$key]['lastname'] = $this->language->get('error_lastname');
                    }

                    if ((utf8_strlen($value['address_1']) < 3) || (utf8_strlen($value['address_1']) > 128)) {
                        $this->error['address'][$key]['address_1'] = $this->language->get('error_address_1');
                    }

                    if ((utf8_strlen($value['city']) < 2) || (utf8_strlen($value['city']) > 128)) {
                        $this->error['address'][$key]['city'] = $this->language->get('error_city');
                    }

                    $this->load->model('localisation/country');

                    $country_info = $this->model_localisation_country->getCountry($value['country_id']);

                    if ($country_info && $country_info['postcode_required'] && (utf8_strlen($value['postcode']) < 2 || utf8_strlen($value['postcode']) > 10)) {
                        $this->error['address'][$key]['postcode'] = $this->language->get('error_postcode');
                    }

                    if ($value['country_id'] == '') {
                        $this->error['address'][$key]['country'] = $this->language->get('error_country');
                    }

                    if (!isset($value['zone_id']) || $value['zone_id'] == '') {
                        $this->error['address'][$key]['zone'] = $this->language->get('error_zone');
                    }

                    foreach ($custom_fields as $custom_field) {
                        if (($custom_field['location'] == 'address') && $custom_field['required'] && empty($value['custom_field'][$custom_field['custom_field_id']])) {
                            $this->error['address'][$key]['custom_field'][$custom_field['custom_field_id']] = sprintf($this->language->get('error_custom_field'), $custom_field['name']);
                        }
                    }
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete()
    {
        if (!$this->user->hasPermission('delete', 'service/service_form') && !$this->user->userpermission('delete', 'service/service_form')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    protected function validateChangeCustomer()
    {
        if (!$this->user->hasPermission('modify', 'service/service_form')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post['customer_id'] == 0) {
            $this->error['warning'] = $this->language->get('error_select_customer');
        }

        return !$this->error;
    }

    public function getServiceFormHistory()
    {
        $this->load->language('service/service_form');
        $this->load->model('service/service_form');

        $this->document->setTitle($this->language->get('heading_title'));

        if (isset($this->request->get['customer_id'])) {
            $customer_id = $this->request->get['customer_id'];
        } else {
            $customer_id = null;
        }

        if (isset($this->request->get['serviceform_id'])) {
            $serviceform_id = $this->request->get['serviceform_id'];
        } else {
            $serviceform_id = null;
        }

        if (isset($this->request->get['filter_start_date'])) {
            $filter_start_date = $this->request->get['filter_start_date'];
        } else {
            $filter_start_date = null;
        }

        if (isset($this->request->get['filter_end_date'])) {
            $filter_end_date = $this->request->get['filter_end_date'];
        } else {
            $filter_end_date = null;
        }

        if (isset($this->request->get['filter_service_name'])) {
			$filter_service_name = $this->request->get['filter_service_name'];
		} else {
			$filter_service_name = '';
		}

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['serviceform_id'])) {
            $url .= '&serviceform_id=' . $this->request->get['serviceform_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        $data['service_forms'] = array();

        $filter_data = array(
            'filter_start_date' => $filter_start_date,
            'filter_end_date' => $filter_end_date,
            'filter_service_name' => $filter_service_name,
            'customer_id' => $customer_id,
            'history_serviceform_id' => $serviceform_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $serviceFormList = $this->model_service_service_form->getServiceFormList($filter_data);
        $service_form_total = $this->model_service_service_form->totalServiceForm($filter_data);

        if (!empty($serviceFormList)) {
            foreach ($serviceFormList as $service) {
                $data['service_forms'][] = array(
                    'serviceform_id' => $service['service_form_id'],
                    'service_date' => $service['service_date'],
                    'invoice_prefix' => $service['invoice_prefix'],
                    'remark' => nl2br($service['remark'])
                );
            }
        }

        $language_arr = array('text_serviceform_history_list', 'button_filter', 'entry_start_date', 'entry_end_date', 'column_date', 'column_serviceno', 'column_action', 'text_no_results', 'column_remark');

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        $data['user_token'] = $this->session->data['user_token'];

        $url = '';

        if (isset($this->request->get['serviceform_id'])) {
            $url .= '&serviceform_id=' . $this->request->get['serviceform_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_sales_date'] = $this->url->link('service/service_form/getServiceFormHistory', 'user_token=' . $this->session->data['user_token'] . '&sort=a.service_date' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('service/service_form/getServiceFormHistory', 'user_token=' . $this->session->data['user_token'] . '&sort=a.invoice_prefix' . $url, true);

        $url = '';

        if (isset($this->request->get['serviceform_id'])) {
            $url .= '&serviceform_id=' . $this->request->get['serviceform_id'];
        }

        if (isset($this->request->get['customer_id'])) {
            $url .= '&customer_id=' . $this->request->get['customer_id'];
        }

        if (isset($this->request->get['filter_service_name'])) {
            $url .= '&filter_service_name=' . $this->request->get['filter_service_name'];
        }

        if (isset($this->request->get['filter_start_date'])) {
            $url .= '&filter_start_date=' . $this->request->get['filter_start_date'];
        }

        if (isset($this->request->get['filter_end_date'])) {
            $url .= '&filter_end_date=' . $this->request->get['filter_end_date'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $service_form_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/service_form/getServiceFormHistory', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($service_form_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($service_form_total - $this->config->get('config_limit_admin'))) ? $service_form_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $service_form_total, ceil($service_form_total / $this->config->get('config_limit_admin')));

        $data['serviceform_id'] = $serviceform_id;
        $data['customer_id'] = $this->request->get['customer_id'];
        $data['filter_start_date'] = $filter_start_date;
        $data['filter_end_date'] = $filter_end_date;
        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/serviceform_history_list', $data));
    }

    public function getServiceHistory()
    {
        $this->load->model('service/service_form');
        $this->load->language('service/service_form');

        $json = array();
        $service_item = array();

        $serviceform_id = $this->request->get['serviceform_id'];

        $service_item_details = $this->model_service_service_form->getServiceItems($serviceform_id);

        $this->load->model('user/user');

        foreach ($service_item_details as $service) {
            $user_info = $this->model_user_user->getUser($service['user_id']);
            $acupuncture_points = $this->model_service_service_form->getAcupuncturePointByServiceItemId($service['service_Item_id']);

            $service_item[] = array(
                'servicename' => $service['servicename'],
                'staffname' => $user_info['firstname'] . ' ' . $user_info['lastname'],
                'serviceminutes' => $service['serviceminutes'],
                'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                'acupuncture_points' => $acupuncture_points
            );
        }

        $json['entry_service_staff'] = $this->language->get('entry_service_staff');
        $json['entry_service_name'] = $this->language->get('entry_service_name');
        $json['entry_service_minute'] = $this->language->get('entry_service_minute');
        $json['entry_service_net_amount'] = $this->language->get('entry_service_net_amount');
        $json['text_no_service_item'] = $this->language->get('text_no_service_item');
        $json['column_acupuncture_point'] = $this->language->get('column_acupuncture_point');
        $json['column_num_of_acupuncture'] = $this->language->get('column_num_of_acupuncture');
        $json['service_items'] = $service_item;

        return $this->response->setOutput(json_encode($json));
    }

    public function getAcupuncturePointInfo()
    {
        $json = array();

        $this->load->language('service/service_form');
        $this->load->model('service/service_form');

        $ac_point_info = $this->model_service_service_form->getAcupunctureJson($this->request->get['acupuncture_id']);

        $json['error'] = '';
        $json['entry_location'] = $this->language->get('entry_location');
        $json['entry_ways'] = $this->language->get('entry_ways');
        $json['entry_symptoms'] = $this->language->get('entry_symptoms');

        if (!empty($ac_point_info)) {
            $json['location'] = $ac_point_info['location'];
            $json['ways'] = $ac_point_info['ways'];
            $json['symptoms'] = $ac_point_info['symptoms'];
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function acupuncturePointListByMeridian()
    {
        $this->load->language('service/service_form');
        $this->load->model('service/service_form');

        $this->document->setTitle($this->language->get('text_acupuncture_list'));

        if (isset($this->request->get['clinicalservice_id'])) {
            $clinicalservice_id = $this->request->get['clinicalservice_id'];
        } else {
            $clinicalservice_id = '';
        }

        if (isset($this->request->get['row'])) {
            $row = $this->request->get['row'];
        } else {
            $row = '';
        }

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $filter_acupuncture_point = $this->request->get['filter_acupuncture_point'];
        } else {
            $filter_acupuncture_point = null;
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $filter_acupuncture_point_code = $this->request->get['filter_acupuncture_point_code'];
        } else {
            $filter_acupuncture_point_code = null;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = null;
        }

        if (isset($this->request->get['filter_body_part'])) {
            $filter_body_part = $this->request->get['filter_body_part'];
        } else {
            $filter_body_part = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'a.acupuncture_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $url .= '&filter_acupuncture_point=' . $this->request->get['filter_acupuncture_point'];
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $url .= '&filter_acupuncture_point_code=' . $this->request->get['filter_acupuncture_point_code'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['filter_body_part'])) {
            $url .= '&filter_body_part=' . $this->request->get['filter_body_part'];
        }

        $data['acupuncture_points'] = array();

        $filter_data = array(
            'filter_acupuncture_point' => $filter_acupuncture_point,
            'filter_acupuncture_point_code' => $filter_acupuncture_point_code,
            'filter_acupuncture' => $filter_acupuncture,
            'filter_body_part' => $filter_body_part,
            'clinicalservice_id' => $clinicalservice_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $acupuncture_points_total = $this->model_service_service_form->getTotalAcupuncturePointsByMeridian($filter_data);
        $results = $this->model_service_service_form->getAcupuncturePointsByMeridian($filter_data);

        foreach ($results as $result) {
            $data['acupuncture_points'][] = array(
                'acupuncture_id' => $result['acupuncture_id'],
                'name' => $result['name'],
                'code' => $result['code'],
                'jingluo' => $result['jingluo'],
                'location' => $result['location'],
                'ways' => $result['ways'],
                'symptoms' => $result['symptoms'],
                'encoded_data' => htmlspecialchars(json_encode($result))
            );
        }

        $data['acupunctures'] = $this->model_service_service_form->getAcupunctures();
        $data['body_parts'] = $this->model_service_service_form->getBodyParts();

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('service/service_form/acupuncturePointListByMeridian', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);
        $data['sort_code'] = $this->url->link('service/service_form/acupuncturePointListByMeridian', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $url . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $url .= '&filter_acupuncture_point=' . $this->request->get['filter_acupuncture_point'];
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $url .= '&filter_acupuncture_point_code=' . $this->request->get['filter_acupuncture_point_code'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        if (isset($this->request->get['filter_body_part'])) {
            $url .= '&filter_body_part=' . $this->request->get['filter_body_part'];
        }

        $pagination = new Pagination();
        $pagination->total = $acupuncture_points_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/service_form/acupuncturePointListByMeridian', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($acupuncture_points_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($acupuncture_points_total - $this->config->get('config_limit_admin'))) ? $acupuncture_points_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $acupuncture_points_total, ceil($acupuncture_points_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_acupuncture_point'] = $filter_acupuncture_point;
        $data['filter_acupuncture_point_code'] = $filter_acupuncture_point_code;
        $data['filter_acupuncture'] = $filter_acupuncture;
        $data['filter_body_part'] = $filter_body_part;

        $data['clinicalservice_id'] = $clinicalservice_id;
        $data['row'] = $row;

        $data['user_token'] = $this->session->data['user_token'];
        $data['search_by_body_part_link'] = $this->url->link('service/service_form/acupuncturePointListByBodyPart', 'user_token=' . $this->session->data['user_token'] . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/acupuncture_point_list', $data));
    }

    public function acupuncturePointListByMeridianDiagram()
    {
        $this->load->language('service/service_form');

        $this->load->model('service/service_form');
        $this->load->model('tool/image');

        if (isset($this->request->get['clinicalservice_id'])) {
            $clinicalservice_id = $this->request->get['clinicalservice_id'];
        } else {
            $clinicalservice_id = NULL;
        }

        if (isset($this->request->get['row'])) {
            $row = $this->request->get['row'];
        } else {
            $row = NULL;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = 195;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'a.acupuncture_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        $data['acupuncture_points'] = [];

        $results = $this->model_service_service_form->getAcupuncturePointsDiagram($filter_acupuncture);

        if (!empty($results)) {
            foreach ($results as $result) {
                if (($result['x_coordinate'] > 0) && ($result['y_coordinate'] > 0)) {
                    $tooltip_data = $result['name'];

                    $data['acupuncture_points'][] = [
                        'acupuncture_id' => $result['acupuncture_id'],
                        'name' => $result['name'],
                        'x_coordinate' => $result['x_coordinate'],
                        'y_coordinate' => $result['y_coordinate'],
                        'location' => $result['location'],
                        'ways' => $result['ways'],
                        'symptoms' => $result['symptoms'],
                        'tooltip_data' => $tooltip_data
                    ];
                }
            }
        }

        $data['meridian_diagrams'] = [];

        $meridian_diagrams = $this->model_service_service_form->getAcupunctures();

        if (!empty($meridian_diagrams)) {
            foreach ($meridian_diagrams as $meridian) {
                $data['meridian_diagrams'][] = [
                    'acupuncture_id' => $meridian['acupuncture_id'],
                    'name' => $meridian['name'],
                    'image' => $this->model_tool_image->resize($meridian['image'], 100, 100)
                ];
            }
        }

        $single_diagram = !empty($filter_acupuncture) ? $this->model_service_service_form->getAcupunctureJson($filter_acupuncture) : [];

        $data['single_image'] = !empty($single_diagram) ? HTTPS_IMAGE . $single_diagram['image'] : '';
        $data['single_image_name'] = !empty($single_diagram) ? $single_diagram['name'] : '';

        $data['filter_acupuncture'] = $filter_acupuncture;

        $data['clinicalservice_id'] = $clinicalservice_id;
        $data['row'] = $row;

        $data['user_token'] = $this->session->data['user_token'];

        /* echo '<pre>';
          print_r($data);
          echo '</pre>'; */

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/acupuncture_point_diagram', $data));
    }

    public function acupuncturePointListByBodyPart()
    {
        $this->load->language('service/service_form');
        $this->load->model('service/service_form');

        $this->document->setTitle($this->language->get('text_acupuncture_list'));

        if (isset($this->request->get['clinicalservice_id'])) {
            $clinicalservice_id = $this->request->get['clinicalservice_id'];
        } else {
            $clinicalservice_id = '';
        }

        if (isset($this->request->get['row'])) {
            $row = $this->request->get['row'];
        } else {
            $row = '';
        }

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $filter_acupuncture_point = $this->request->get['filter_acupuncture_point'];
        } else {
            $filter_acupuncture_point = null;
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $filter_acupuncture_point_code = $this->request->get['filter_acupuncture_point_code'];
        } else {
            $filter_acupuncture_point_code = null;
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $filter_acupuncture = $this->request->get['filter_acupuncture'];
        } else {
            $filter_acupuncture = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'a.acupuncture_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $url .= '&filter_acupuncture_point=' . $this->request->get['filter_acupuncture_point'];
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $url .= '&filter_acupuncture_point_code=' . $this->request->get['filter_acupuncture_point_code'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        $data['acupuncture_points'] = array();

        $filter_data = array(
            'filter_acupuncture_point' => $filter_acupuncture_point,
            'filter_acupuncture_point_code' => $filter_acupuncture_point_code,
            'filter_acupuncture' => $filter_acupuncture,
            'clinicalservice_id' => $clinicalservice_id,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $acupuncture_points_total = $this->model_service_service_form->getTotalAcupuncturePoints($filter_data);
        $results = $this->model_service_service_form->getAcupuncturePoints($filter_data);

        foreach ($results as $result) {
            $data['acupuncture_points'][] = array(
                'acupuncture_id' => $result['acupuncture_id'],
                'name' => $result['name'],
                'code' => $result['code'],
                'jingluo' => $result['jingluo'],
                'location' => $result['location'],
                'ways' => $result['ways'],
                'symptoms' => $result['symptoms'],
                'encoded_data' => htmlspecialchars(json_encode($result))
            );
        }

        $data['acupunctures'] = $this->model_service_service_form->getAcupunctures();

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('service/service_form/acupuncturePointListByBodyPart', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $url . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);
        $data['sort_code'] = $this->url->link('service/service_form/acupuncturePointListByBodyPart', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $url . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['filter_acupuncture_point'])) {
            $url .= '&filter_acupuncture_point=' . $this->request->get['filter_acupuncture_point'];
        }

        if (isset($this->request->get['filter_acupuncture_point_code'])) {
            $url .= '&filter_acupuncture_point_code=' . $this->request->get['filter_acupuncture_point_code'];
        }

        if (isset($this->request->get['filter_acupuncture'])) {
            $url .= '&filter_acupuncture=' . $this->request->get['filter_acupuncture'];
        }

        $pagination = new Pagination();
        $pagination->total = $acupuncture_points_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('service/service_form/acupuncturePointListByBodyPart', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($acupuncture_points_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($acupuncture_points_total - $this->config->get('config_limit_admin'))) ? $acupuncture_points_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $acupuncture_points_total, ceil($acupuncture_points_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_acupuncture_point'] = $filter_acupuncture_point;
        $data['filter_acupuncture_point_code'] = $filter_acupuncture_point_code;
        $data['filter_acupuncture'] = $filter_acupuncture;

        $data['clinicalservice_id'] = $clinicalservice_id;
        $data['row'] = $row;

        $data['user_token'] = $this->session->data['user_token'];
        $data['search_by_meridian_link'] = $this->url->link('service/service_form/acupuncturePointListByMeridian', 'user_token=' . $this->session->data['user_token'] . '&clinicalservice_id=' . $clinicalservice_id . '&row=' . $row, true);

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/bp_acupuncture_point_list', $data));
    }

    public function sfuSessionGetTotal()
    {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('clinicalservices');
        $this->cart = new Clinicalservices($this->registry);

        //total
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;
        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $getService = $this->cart->getServices();
        $data['service'] = $getService;

        $this->response->setOutput($this->load->view('service/service_form_cart', $data));
    }

    public function totalData()
    {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($this->config->get('total_' . $result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            }

            $sort_order = array();

            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        return $totals;
    }

    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['filter_acupuncture'])) {
            if (isset($this->request->get['filter_acupuncture'])) {
                $filter_acupuncture = $this->request->get['filter_acupuncture'];
            } else {
                $filter_acupuncture = '';
            }

            $this->load->model('service/service_form');

            $filter_data = array(
                'filter_acupuncture' => $filter_acupuncture,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_service_service_form->getAutoCompleteAcupunctures($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'acupuncture_id' => $result['acupuncture_id'],
                    'name' => $result['name']
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function findCustomer()
    {
        $this->load->model('herbal/herbal');
        $this->load->language('herbal/herbal');

        $json = array();

        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json = $this->model_herbal_herbal->getCustomerByIC($data);

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $json['success'] = "Customer Details";
        }

        return $this->response->setOutput(json_encode($json));
    }

    private function calculateAge($dob)
    {
        $date_of_birth = date('m/d/Y', strtotime($dob));

        $birthDate = explode("/", $date_of_birth);

        $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));

        return $age;
    }

    public function customfield()
    {
        $json = array();

        $this->load->model('customer/custom_field');

        // Customer Group
        if (isset($this->request->get['customer_group_id'])) {
            $customer_group_id = $this->request->get['customer_group_id'];
        } else {
            $customer_group_id = $this->config->get('config_customer_group_id');
        }

        $custom_fields = $this->model_customer_custom_field->getCustomFields(array('filter_customer_group_id' => $customer_group_id));

        foreach ($custom_fields as $custom_field) {
            $json[] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'required' => empty($custom_field['required']) || $custom_field['required'] == 0 ? false : true
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function getDateByDateType($type) {
		$timezone = new DateTimeZone('Asia/Kuala_Lumpur');
        $today = new DateTime('now', $timezone);

        $yesterday = clone $today;
        $yesterday->modify('-1 day');
        $start_of_week = clone $today;
        $start_of_week->modify('monday this week');
        $start_of_month = clone $today;
        $start_of_month->modify('first day of this month');
        $start_of_year = clone $today;
        $start_of_year->modify('first day of January this year');

        $last_week = clone $today;
        $last_week->modify('monday last week');
        $last_month = clone $today;
        $last_month->modify('first day of last month');
        $last_year = clone $today;
        $last_year->modify('first day of January last year');

		$date = [];
		switch ($type) {
			case 'today':
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'yesterday':
				$start_date = $yesterday->format('Y-m-d');
				$end_date   = $yesterday->format('Y-m-d');
				break;
            case 'last_week':
                $start_date = $last_week->format('Y-m-d');
				$end_date   = $last_week->modify('+6 days')->format('Y-m-d');
				break;
            case 'last_month':
                $start_date = $last_month->format('Y-m-d');
                $end_date   = $last_month->modify('last day of')->format('Y-m-d');
                break;
            case 'last_year':
                $start_date = $last_year->format('Y-m-d');
                $end_date   = $last_year->modify('last day of December')->format('Y-m-d');
                break;
			case 'past':
				$start_date = null;
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_week':
				$start_date = $start_of_week->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_month':
				$start_date = $start_of_month->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'this_year':
				$start_date = $start_of_year->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
				break;
			case 'last7days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-6 days')->format('Y-m-d');
				break;
            case 'last14days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-13 days')->format('Y-m-d');    
                break;
            case 'last21days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-20 days')->format('Y-m-d');
                break;
			case 'last30days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-29 days')->format('Y-m-d');
				break;
            case 'last60days':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-59 days')->format('Y-m-d');
                break;
			case 'last90days':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-89 days')->format('Y-m-d');
				break;
			case 'last1year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
            case 'last3year':
                $end_date   = $today->format('Y-m-d');
                $start_date = $today->modify('-3 year')->format('Y-m-d');
                break;
			case 'last5year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-5 year')->format('Y-m-d');
				break;
			case 'last_year_this_year':
                $end_date   = $today->format('Y-m-d');
				$start_date = $today->modify('-1 year')->format('Y-m-d');
				break;
			case 'all':
				$start_date = null;
				$end_date   = null;
				break;
			default:
				$start_date = $today->format('Y-m-d');
				$end_date   = $today->format('Y-m-d');
		}

		$date = [
			'date_start' => $start_date,
			'date_end'   => $end_date,
		];
		return $date;
	}

	protected function getDateTypes() {
		$result = [
			array(
				'name' => 'Today',
				'code' => 'today'
			),
			array(
				'name' => 'Yesterday',
				'code' => 'yesterday'
			),
            array(
                'name' => 'Last Week',
                'code' => 'last_week'
            ),
            array(
                'name' => 'Last Month',
                'code' => 'last_month'
            ),
            array(
                'name' => 'Last Year',
                'code' => 'last_year'
            ),
			array(
				'name' => 'This Week',
				'code' => 'this_week'
			),
			array(
				'name' => 'This Month',
				'code' => 'this_month'
			),
			array(
				'name' => 'This Year',
				'code' => 'this_year'
			),
			array(
				'name' => 'Year to date (YTD)',
				'code' => 'last_year_this_year'
			),
			array(
				'name' => 'Last 7 days',
				'code' => 'last7days'
			),
            array(
				'name' => 'Last 14 days',
				'code' => 'last14days'
			),
            array(
				'name' => 'Last 21 days',
				'code' => 'last21days'
			),
			array(
				'name' => 'Last 30 days',
				'code' => 'last30days'
			),
            array(
				'name' => 'Last 60 days',
				'code' => 'last60days'
			),
			array(
				'name' => 'Last 90 days',
				'code' => 'last90days'
			),
			array(
                'name' => 'Last 1 years',
                'code' => 'last1year'
            ),
            array(
                'name' => 'Last 3 years',
                'code' => 'last3year'
            ),
            array(
                'name' => 'Last 5 years',
                'code' => 'last5year'
            ),
            array(
				'name' => 'Past',
				'code' => 'past'
			),
			array(
				'name' => 'All Time',
				'code' => 'all'
			),
			array(
				'name' => 'Custom Range',
				'code' => 'custom'
			)
		];
		return $result;
	} 

    public function customer_autocomplete()
    {
        $json = array();

        if (
            isset($this->request->get['filter_name'])
            // isset($this->request->get['filter_gender'])||
            // isset($this->request->get['filter_add_by'])||
            // isset($this->request->get['filter_status'])||
            // isset($this->request->get['filter_approved'])

        ) {
            if (isset($this->request->get['filter_name'])) {
                $filter_name = $this->request->get['filter_name'];
            } else {
                $filter_name = '';
            }
            $this->load->model('service/service_form');

            $filter_data = array(
                'filter_name' => $filter_name,
                
              
                'start' => 0,
                'limit' => 5
            );



            $results = $this->model_service_service_form->getCustomersAutocomplete($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'customer_id' => $result['customer_id'],
                    'customer_ic' => $result['customer_ic'],
                    'customer_name' => $result['customer_name'],
                    'telephone' => $result['telephone']
                    
                );
            }
        }

        // $sort_order = array();

        // foreach ($json as $key => $value) {
        //     $sort_order[$key] = $value['name'];
        // }

        // array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addserviceform(){
        $this->load->model('service/service_form');
        $customer_id = (isset($this->request->post['customer_id'])) ? $this->request->post['customer_id'] : false;
            $serviceform_id = '';
        if($customer_id){
            $serviceform_id = $this->model_service_service_form->addNewServiceForm($customer_id);

        }

        if($serviceform_id){
            $json = array(
                'success' => true,
                'serviceform_id' => $serviceform_id
            );
        }else{
            $json = array(
                'success' => false
            );
        }

      


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }
}
