<?php

class ControllerSaleShippingModule extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('sale/shipping_module');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/shipping_module');
        $this->load->model('sale/customer_group');

        $this->getList();
    }

    protected function getList() {
        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_invoice'])) {
            $filter_invoice = $this->request->get['filter_invoice'];
        } else {
            $filter_invoice = null;
        }
        
        if (isset($this->request->get['filter_store_id'])) {
            if ($this->request->get['filter_store_id'] != '*') {
                $filter_store_id = $this->request->get['filter_store_id'];
            } else {
                $filter_store_id = NULL;
            }
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $filter_carrier = $this->request->get['filter_carrier'];
        } else {
            $filter_carrier = null;
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $filter_tracking_num = $this->request->get['filter_tracking_num'];
        } else {
            $filter_tracking_num = null;
        }

        if (isset($this->request->get['filter_got_tracking'])) {
            $filter_got_tracking = $this->request->get['filter_got_tracking'];
        } else {
            $filter_got_tracking = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }
        
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_got_tracking'])) {
            $url .= '&filter_got_tracking=' . $this->request->get['filter_got_tracking'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
        );

        $data['shipping'] = $this->url->link('sale/shipping_module/shipping', 'user_token=' . $this->session->data['user_token'], 'SSL');
        $data['print_cn'] = $this->url->link('extension/module/shipping_template/print_consignment_notes', 'user_token=' . $this->session->data['user_token'], 'SSL');

        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['orders'] = array();

        $filter_data = array(
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_order_id' => $filter_order_id,
            'filter_store_id' => $filter_store_id,
            'filter_order_status' => $filter_order_status,
            'filter_carrier' => $filter_carrier,
            'filter_invoice' => $filter_invoice,
            'filter_tracking_num' => $filter_tracking_num,
            'filter_got_tracking' => $filter_got_tracking,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $this->load->model('tool/image');

        $results = $this->model_sale_shipping_module->getOrders($filter_data);

        $order_total = count($results);

        $results = array_slice($results, $start, $limit);

        foreach ($results as $result) {

            if ($result['carrier_id'] > 0) {
                $carrier_info = $this->model_sale_shipping_module->getCarrier($result['carrier_id']);
                $carrier_url = !empty($carrier_info) ? str_replace('{tracking_number}', $result['tracking_number'], $carrier_info['tracking_url']) : '';
                $carrier_image = !empty($carrier_info) ? $this->model_tool_image->resize($carrier_info['image'], 110, 30) : '';
            } else {
                $carrier_url = '';
                $carrier_image = '';
            }

            $invoice_date = $this->model_sale_shipping_module->orderInvoiceDate($result['order_id'], '3');
            $payment_date = $this->model_sale_shipping_module->orderInvoiceDate($result['order_id'], '5');
            if (!empty($invoice_date['date_added'])) {
                $invoice_date = date('Y-m-d', strtotime($invoice_date['date_added']));
            } else {
                $invoice_date = '-';
            }

            if (!empty($payment_date['date_added'])) {
                $payment_date = date('Y-m-d', strtotime($payment_date['date_added']));
            } else {
                $payment_date = '-';
            }


            $data['orders'][] = array(
                'order_id' => $result['order_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'order_status_id' => $result['order_status_id'],
                'status' => $result['status'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'invoice_date' => $invoice_date,
                'payment_date' => $payment_date,
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'carrier_id' => $result['carrier_id'],
                'tracking_num' => $result['tracking_number'],
                'total_weight' => number_format($result['total_weight'], 2),
                'carrier_url' => $carrier_url,
                'carrier_image' => $carrier_image,
                'print_cn' => $this->url->link('extension/module/shipping_template/print_consignment_note', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'], true),
                'view' => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, 'SSL')
            );
        }
        
        $data['text_print_consignment_note'] = 'Print Consignment Note';

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_got_tracking'])) {
            $url .= '&filter_got_tracking=' . $this->request->get['filter_got_tracking'];
        }
        
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=o.order_id' . $url, 'SSL');
        $data['sort_invoice'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=o.invoice_prefix' . $url, 'SSL');
        $data['sort_status'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, 'SSL');
        $data['sort_date_added'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_added' . $url, 'SSL');
        $data['sort_invoice_date'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=oh.date_added' . $url, 'SSL');
        $data['sort_date_modified'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_modified' . $url, 'SSL');
        $data['sort_total_weight'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . '&sort=o.total_weight' . $url, 'SSL');

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }
        
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_got_tracking'])) {
            $url .= '&filter_got_tracking=' . $this->request->get['filter_got_tracking'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_date_added_from'] = $filter_date_added_from;
        $data['filter_date_added_to'] = $filter_date_added_to;
        $data['filter_order_id'] = $filter_order_id;
        $data['filter_invoice'] = $filter_invoice;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_carrier'] = $filter_carrier;
        $data['filter_tracking_num'] = $filter_tracking_num;
        $data['filter_got_tracking'] = $filter_got_tracking;
        $data['filter_date_modified'] = $filter_date_modified;
        $data['filter_store_id'] = $filter_store_id;

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
        $data['carriers'] = $this->model_sale_shipping_module->getCarriers();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/shipping_module_list', $data));
    }

    public function info() {
        $this->load->model('sale/shipping_module');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }

        $order_info = $this->model_sale_shipping_module->getOrder($order_id);

        if ($order_info) {
            $this->load->language('sale/shipping_module');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['user_token'] = $this->session->data['user_token'];

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }

            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_carrier'])) {
                $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
            }

            if (isset($this->request->get['filter_tracking_num'])) {
                $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
            }

            if (isset($this->request->get['filter_got_tracking'])) {
                $url .= '&filter_got_tracking=' . $this->request->get['filter_got_tracking'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
            );

            $data['shipping'] = $this->url->link('sale/shipping_module/shipping', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], 'SSL');
            
            $data['invoice_pdf'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=true', true);
            $data['invoiceSO'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1' . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['invoiceDO'] = $this->url->link('sale/order/invoiceDO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1' . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['print_cn'] = $this->url->link('extension/module/shipping_template/print_consignment_note', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['edit'] = $this->url->link('sale/order/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/shipping_module', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

            $data['order_id'] = $this->request->get['order_id'];

            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }

            $data['store_name'] = $order_info['store_name'];
            $data['invoice_no'] = $order_info['invoice_prefix'];
            $data['store_url'] = $order_info['store_url'];
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];

            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('sale/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $order_info['customer_id'], 'SSL');
            } else {
                $data['customer'] = '';
            }

            $this->load->model('sale/customer_group');

            $customer_group_info = $this->model_sale_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }

            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['fax'] = $order_info['fax'];
            $data['comment'] = nl2br($order_info['comment']);
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['payment_method'] = $order_info['payment_method'];
            $data['total'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

            $this->load->model('sale/customer');

            $data['reward'] = $order_info['reward'];

            $data['reward_total'] = $this->model_sale_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);

            $data['affiliate_firstname'] = $order_info['affiliate_firstname'];
            $data['affiliate_lastname'] = $order_info['affiliate_lastname'];

            if ($order_info['affiliate_id']) {
                $data['affiliate'] = $this->url->link('marketing/affiliate/edit', 'user_token=' . $this->session->data['user_token'] . '&affiliate_id=' . $order_info['affiliate_id'], 'SSL');
            } else {
                $data['affiliate'] = '';
            }

            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);

            $this->load->model('marketing/affiliate');

            $data['commission_total'] = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);

            $this->load->model('localisation/order_status');

            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);

            if ($order_status_info) {
                $data['order_status'] = $order_status_info['name'];
            } else {
                $data['order_status'] = '';
            }

            $data['order_status_id'] = $order_info['order_status_id'];

            $data['ip'] = $order_info['ip'];
            $data['forwarded_ip'] = $order_info['forwarded_ip'];
            $data['user_agent'] = $order_info['user_agent'];
            $data['accept_language'] = $order_info['accept_language'];
            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['date_modified'] = date($this->language->get('date_format_short'), strtotime($order_info['date_modified']));
            $data['payment_firstname'] = $order_info['payment_firstname'];
            $data['payment_lastname'] = $order_info['payment_lastname'];
            $data['payment_company'] = $order_info['payment_company'];
            $data['payment_address_1'] = $order_info['payment_address_1'];
            $data['payment_address_2'] = $order_info['payment_address_2'];
            $data['payment_city'] = $order_info['payment_city'];
            $data['payment_postcode'] = $order_info['payment_postcode'];
            $data['payment_zone'] = $order_info['payment_zone'];
            $data['payment_zone_code'] = $order_info['payment_zone_code'];
            $data['payment_country'] = $order_info['payment_country'];
            $data['card_no'] = $order_info['card_no'];
            $data['shipping_firstname'] = $order_info['shipping_firstname'];
            $data['shipping_lastname'] = $order_info['shipping_lastname'];
            $data['shipping_company'] = $order_info['shipping_company'];
            $data['shipping_address_1'] = $order_info['shipping_address_1'];
            $data['shipping_address_2'] = $order_info['shipping_address_2'];
            $data['shipping_city'] = $order_info['shipping_city'];
            $data['shipping_postcode'] = $order_info['shipping_postcode'];
            $data['shipping_zone'] = $order_info['shipping_zone'];
            $data['shipping_zone_code'] = $order_info['shipping_zone_code'];
            $data['shipping_country'] = $order_info['shipping_country'];

            $this->load->model('tool/upload');

            $data['products'] = array();

            $products = $this->model_sale_shipping_module->getOrderProducts($this->request->get['order_id']);
            $herbales = $this->model_sale_shipping_module->getHerbals($this->request->get['order_id']);
            $services = $this->model_sale_shipping_module->getServies($this->request->get['order_id']);
            // $brewings = $this->model_sale_shipping_module->getBrewings($this->request->get['order_id']);
            // $brewing_orders = $this->model_sale_shipping_module->getBrewingOrders($this->request->get['order_id']);

            $option_data = array();



            foreach ($herbales as $herbale) {
                $weight_class_unit = '';

                if ($herbale['collect_consultation_price'] == 1) {
                    $consultation_total = $this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;$this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']);

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['net_total']),
                        'tax' => $this->currency->format($herbale['gst']),
                        'total' => $this->currency->format($herbale['clinicalsale_total']),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], 'SSL')
                    );

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_consultation_price'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                        'tax' => $this->currency->format($herbale['d_gst']),
                        'total' => $this->currency->format($consultation_total),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], 'SSL')
                    );
                } else {
                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                        'tax' => $this->currency->format($herbale['d_gst']),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst']),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], 'SSL')
                    );

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_free_consultation'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format(0),
                        'tax' => $this->currency->format(0),
                        'total' => $this->currency->format(0),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], 'SSL')
                    );
                }
            }

            foreach ($services as $service) {

                $weight_class_unit = '';

                $data['products'][] = array(
                    'order_product_id' => $service['service_Item_id'],
                    'product_id' => $service['clinicalservice_id'],
                    'name' => $service['servicename'],
                    'model' => $service['invoice_prefix'],
                    'option' => $option_data,
                    'quantity' => 1,
                    'weight_class_unit' => $weight_class_unit,
                    'price' => $this->currency->format($service['price']),
                    'tax' => $this->currency->format($service['gst']),
                    'total' => $this->currency->format($service['net_amount'] + $service['gst']),
                    'href' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $service['service_form_id'], 'SSL')
                );
            }

            // foreach($brewings as $brewing){
            // 	$weight_class_unit = '';
            //
            // 	$data['products'][] = array(
            // 		'order_product_id'	=> $brewing['herbal_transfer_id'],
            // 		'product_id'		=> $brewing['herbal_transfer_id'],
            // 		'name'				=> $this->language->get('text_brewing'),
            // 		'model'				=> $brewing['tranfer_invoice'],
            // 		'option'			=> $option_data,
            // 		'quantity'			=> 1,
            // 		'weight_class_unit'	=> $weight_class_unit,
            // 		'price'				=> $this->currency->format($brewing['t_net']),
            // 		'tax'				=> $this->currency->format($brewing['t_gst']),
            // 		'total'				=> $this->currency->format($brewing['t_total']),
            // 		'href'      		=> $this->url->link('etcm/herbal/info', 'user_token=' . $this->session->data['user_token'] . '&herbal_transfer_id=' . $brewing['herbal_transfer_id'], 'SSL')
            // 	);
            // }
            // foreach($brewing_orders as $brewing_order){
            // 	$weight_class_unit = '';
            //
            // 	$data['products'][] = array(
            // 		'order_product_id'	=> $brewing_order['herbal_transfer_id'],
            // 		'product_id'		=> $brewing_order['herbal_transfer_id'],
            // 		'name'				=> $this->language->get('text_brewing_order'),
            // 		'model'				=> $brewing_order['tranfer_invoice'],
            // 		'option'			=> $option_data,
            // 		'quantity'			=> 1,
            // 		'weight_class_unit'	=> $weight_class_unit,
            // 		'price'				=> $this->currency->format($brewing_order['t_net']),
            // 		'tax'				=> $this->currency->format($brewing_order['t_gst']),
            // 		'total'				=> $this->currency->format($brewing_order['t_total']),
            // 		'href'      		=> $this->url->link('etcm/herbal_order/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_transfer_id=' . $brewing_order['herbal_transfer_id'], 'SSL')
            // 	);
            // }

            foreach ($products as $product) {


                $options = $this->model_sale_shipping_module->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

                foreach ($options as $option) {
                    if ($option['type'] != 'file') {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $option_data[] = array(
                                'name' => $option['name'],
                                'value' => $upload_info['name'],
                                'type' => $option['type'],
                                'href' => $this->url->link('tool/upload/download', 'user_token=' . $this->session->data['user_token'] . '&code=' . $upload_info['code'], 'SSL')
                            );
                        }
                    }
                }

                $this->load->model('sale/shipping_module');

                if ($product['weight_class_id'] > 0) {
                    $weight_class_unit = $this->model_sale_shipping_module->getWeightClassUnit($product['weight_class_id']);
                } else {
                    $weight_class_unit = '';
                }

                if (!empty($weight_class_id)) {
                    $weight_class_id = $weight_class_id;
                } else {
                    $weight_class_id = '';
                }

                $data['products'][] = array(
                    'order_product_id' => $product['order_product_id'],
                    'product_id' => $product['product_id'],
                    'name' => $product['name'],
                    'model' => $product['model'],
                    'option' => $option_data,
                    'quantity' => $product['quantity'],
                    'weight_class_unit' => $weight_class_unit,
                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], 'SSL')
                );
            }

            $data['vouchers'] = array();

            $vouchers = $this->model_sale_shipping_module->getOrderVouchers($this->request->get['order_id']);

            foreach ($vouchers as $voucher) {
                $data['vouchers'][] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('sale/voucher/edit', 'user_token=' . $this->session->data['user_token'] . '&voucher_id=' . $voucher['voucher_id'], 'SSL')
                );
            }

            $totals = $this->model_sale_shipping_module->getOrderTotals($this->request->get['order_id']);

            foreach ($totals as $total) {
                $data['totals'][] = array(
                    'title' => $total['title'],
                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                );
            }

            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            $data['order_status_id'] = $order_info['order_status_id'];

            // Unset any past sessions this page date_added for the api to work.
            unset($this->session->data['cookie']);

            // Set up the API session
            if ($this->user->hasPermission('modify', 'sale/shipping_module')) {
                $this->load->model('user/api');

                $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

                if ($api_info) {
                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));

                    $json = curl_exec($curl);

                    if (!$json) {
                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    } else {
                        $response = json_decode($json, true);
                    }

                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }
                }
            }

            if (isset($response['cookie'])) {
                $this->session->data['cookie'] = $response['cookie'];
            } else {
                $data['error_warning'] = $this->language->get('error_permission');
            }

            // Fraud
            $this->load->model('sale/fraud');

            $fraud_info = $this->model_sale_fraud->getFraud($order_info['order_id']);

            if ($fraud_info) {
                $data['country_match'] = $fraud_info['country_match'];

                if ($fraud_info['country_code']) {
                    $data['country_code'] = $fraud_info['country_code'];
                } else {
                    $data['country_code'] = '';
                }

                $data['high_risk_country'] = $fraud_info['high_risk_country'];
                $data['distance'] = $fraud_info['distance'];

                if ($fraud_info['ip_region']) {
                    $data['ip_region'] = $fraud_info['ip_region'];
                } else {
                    $data['ip_region'] = '';
                }

                if ($fraud_info['ip_city']) {
                    $data['ip_city'] = $fraud_info['ip_city'];
                } else {
                    $data['ip_city'] = '';
                }

                $data['ip_latitude'] = $fraud_info['ip_latitude'];
                $data['ip_longitude'] = $fraud_info['ip_longitude'];

                if ($fraud_info['ip_isp']) {
                    $data['ip_isp'] = $fraud_info['ip_isp'];
                } else {
                    $data['ip_isp'] = '';
                }

                if ($fraud_info['ip_org']) {
                    $data['ip_org'] = $fraud_info['ip_org'];
                } else {
                    $data['ip_org'] = '';
                }

                $data['ip_asnum'] = $fraud_info['ip_asnum'];

                if ($fraud_info['ip_user_type']) {
                    $data['ip_user_type'] = $fraud_info['ip_user_type'];
                } else {
                    $data['ip_user_type'] = '';
                }

                if ($fraud_info['ip_country_confidence']) {
                    $data['ip_country_confidence'] = $fraud_info['ip_country_confidence'];
                } else {
                    $data['ip_country_confidence'] = '';
                }

                if ($fraud_info['ip_region_confidence']) {
                    $data['ip_region_confidence'] = $fraud_info['ip_region_confidence'];
                } else {
                    $data['ip_region_confidence'] = '';
                }

                if ($fraud_info['ip_city_confidence']) {
                    $data['ip_city_confidence'] = $fraud_info['ip_city_confidence'];
                } else {
                    $data['ip_city_confidence'] = '';
                }

                if ($fraud_info['ip_postal_confidence']) {
                    $data['ip_postal_confidence'] = $fraud_info['ip_postal_confidence'];
                } else {
                    $data['ip_postal_confidence'] = '';
                }

                if ($fraud_info['ip_postal_code']) {
                    $data['ip_postal_code'] = $fraud_info['ip_postal_code'];
                } else {
                    $data['ip_postal_code'] = '';
                }

                $data['ip_accuracy_radius'] = $fraud_info['ip_accuracy_radius'];

                if ($fraud_info['ip_net_speed_cell']) {
                    $data['ip_net_speed_cell'] = $fraud_info['ip_net_speed_cell'];
                } else {
                    $data['ip_net_speed_cell'] = '';
                }

                $data['ip_metro_code'] = $fraud_info['ip_metro_code'];
                $data['ip_area_code'] = $fraud_info['ip_area_code'];

                if ($fraud_info['ip_time_zone']) {
                    $data['ip_time_zone'] = $fraud_info['ip_time_zone'];
                } else {
                    $data['ip_time_zone'] = '';
                }

                if ($fraud_info['ip_region_name']) {
                    $data['ip_region_name'] = $fraud_info['ip_region_name'];
                } else {
                    $data['ip_region_name'] = '';
                }

                if ($fraud_info['ip_domain']) {
                    $data['ip_domain'] = $fraud_info['ip_domain'];
                } else {
                    $data['ip_domain'] = '';
                }

                if ($fraud_info['ip_country_name']) {
                    $data['ip_country_name'] = $fraud_info['ip_country_name'];
                } else {
                    $data['ip_country_name'] = '';
                }

                if ($fraud_info['ip_continent_code']) {
                    $data['ip_continent_code'] = $fraud_info['ip_continent_code'];
                } else {
                    $data['ip_continent_code'] = '';
                }

                if ($fraud_info['ip_corporate_proxy']) {
                    $data['ip_corporate_proxy'] = $fraud_info['ip_corporate_proxy'];
                } else {
                    $data['ip_corporate_proxy'] = '';
                }

                $data['anonymous_proxy'] = $fraud_info['anonymous_proxy'];
                $data['proxy_score'] = $fraud_info['proxy_score'];

                if ($fraud_info['is_trans_proxy']) {
                    $data['is_trans_proxy'] = $fraud_info['is_trans_proxy'];
                } else {
                    $data['is_trans_proxy'] = '';
                }

                $data['free_mail'] = $fraud_info['free_mail'];
                $data['carder_email'] = $fraud_info['carder_email'];

                if ($fraud_info['high_risk_username']) {
                    $data['high_risk_username'] = $fraud_info['high_risk_username'];
                } else {
                    $data['high_risk_username'] = '';
                }

                if ($fraud_info['high_risk_password']) {
                    $data['high_risk_password'] = $fraud_info['high_risk_password'];
                } else {
                    $data['high_risk_password'] = '';
                }

                $data['bin_match'] = $fraud_info['bin_match'];

                if ($fraud_info['bin_country']) {
                    $data['bin_country'] = $fraud_info['bin_country'];
                } else {
                    $data['bin_country'] = '';
                }

                $data['bin_name_match'] = $fraud_info['bin_name_match'];

                if ($fraud_info['bin_name']) {
                    $data['bin_name'] = $fraud_info['bin_name'];
                } else {
                    $data['bin_name'] = '';
                }

                $data['bin_phone_match'] = $fraud_info['bin_phone_match'];

                if ($fraud_info['bin_phone']) {
                    $data['bin_phone'] = $fraud_info['bin_phone'];
                } else {
                    $data['bin_phone'] = '';
                }

                if ($fraud_info['customer_phone_in_billing_location']) {
                    $data['customer_phone_in_billing_location'] = $fraud_info['customer_phone_in_billing_location'];
                } else {
                    $data['customer_phone_in_billing_location'] = '';
                }

                $data['ship_forward'] = $fraud_info['ship_forward'];

                if ($fraud_info['city_postal_match']) {
                    $data['city_postal_match'] = $fraud_info['city_postal_match'];
                } else {
                    $data['city_postal_match'] = '';
                }

                if ($fraud_info['ship_city_postal_match']) {
                    $data['ship_city_postal_match'] = $fraud_info['ship_city_postal_match'];
                } else {
                    $data['ship_city_postal_match'] = '';
                }

                $data['score'] = $fraud_info['score'];
                $data['explanation'] = $fraud_info['explanation'];
                $data['risk_score'] = $fraud_info['risk_score'];
                $data['queries_remaining'] = $fraud_info['queries_remaining'];
                $data['maxmind_id'] = $fraud_info['maxmind_id'];
                $data['error'] = $fraud_info['error'];
            } else {
                $data['maxmind_id'] = '';
            }


            $this->load->model('module/order_tracking');
            $data['carriers'] = $this->model_module_order_tracking->getCarriers();

            $data['order_tracking_status'] = $this->config->get('order_tracking_status');
            $data['order_tracking_shipped'] = $this->config->get('order_tracking_shipped');
            $data['order_tracking_order_id'] = $order_id;


            $data['payment_action'] = $this->load->controller('payment/' . $order_info['payment_code'] . '/orderAction', '');

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('sale/shipping_module_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], 'SSL')
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function update_single_shipment() {
        $json = [];

        $this->load->language('sale/shipping_module');

        $this->load->model('sale/shipping_module');
        $this->load->model('localisation/country');

        $send_sms = new SMS($this->config->get('config_sms'));
        $order_tracking_number_sms_settings = $this->config->get('config_sms_customer_order_tracking_number');

        $country_id = $this->config->get('config_country_id');
        $country_info = $this->model_localisation_country->getCountry($country_id);
        $mobile_code = $country_info['mobile_code'];

        $order_ids = explode(",", $this->request->post['order_id']);

        foreach ($order_ids as $order_id) {
            $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
            $carrier_id = isset($this->request->post['carrier_id']) ? $this->request->post['carrier_id'] : false;
            $tracking_number = isset($this->request->post['tracking_number']) ? $this->request->post['tracking_number'] : '';
            $comment = isset($this->request->post['comment']) ? $this->request->post['comment'] : false;
            $notify = isset($this->request->post['notify']) ? $this->request->post['notify'] : 0;

            if ($order_status_id && $carrier_id) {
                $order_info = $this->model_sale_shipping_module->getOrder($order_id);
                $carrier_info = $this->model_sale_shipping_module->getCarrier($carrier_id);

                if (!empty($order_info) && !empty($carrier_info)) {
                    if ($notify > 0) {
                        // send sms to the customer for the tracking number 
                        if (!empty($order_info['telephone'])) {
                            $customer_telephone = $order_info['telephone'];

                            if (substr($customer_telephone, 0, 2) == '+6') {
                                $customer_telephone = ltrim($customer_telephone, '+6');
                            }

                            if ($order_tracking_number_sms_settings['status'] == '1') {
                                $find_sms_template = ['{order_id}', '{courier}', '{shipping_tracking}'];

                                $replace_sms_template = [
                                    'order_id' => $order_id,
                                    'courier' => $carrier_info['name'],
                                    'shipping_tracking' => $tracking_number
                                ];

                                $sms_message = str_replace($find_sms_template, $replace_sms_template, $order_tracking_number_sms_settings['template']);

                                $send_sms->sendTo($mobile_code, $customer_telephone);

                                if (preg_match('/\p{Han}+/u', $sms_message)) {
                                    $send_sms->changeContentType();
                                    $send_sms->convertUnicode($sms_message);
                                } else {
                                    $send_sms->setMessage($sms_message);
                                }

                                $send_sms->send();
                            }
                        }
                    }

                    // add order history
                    $this->model_sale_shipping_module->add_order_history($order_id, $order_status_id, $comment, $notify, $tracking_number, $carrier_id);

                    // update order status
                    $this->model_sale_shipping_module->updateCancel($order_status_id, $order_id);

                    // update tracking shipment
                    $this->model_sale_shipping_module->update_carrier($order_id, $carrier_id, $tracking_number,$order_status_id);
     
                    $this->session->data['success'] = $this->language->get('text_success_update_shipment');

                    $json = [
                        'error' => false,
                        'message' => 'update shipment success'
                    ];
                } else {
                    $error_arr['warning'] = $this->language->get('error_warning');

                    $json = [
                        'error' => true,
                        'error_arr' => $error_arr,
                        'message' => 'order not found'
                    ];
                }
            } else {
                $error_arr = [];

                if (!$order_status_id) {
                    $error_arr['order_status'] = $this->language->get('error_order_status');
                }

                if (!$carrier_id) {
                    $error_arr['carrier'] = $this->language->get('error_carrier');
                }

                if (!empty($error_arr)) {
                    $error_arr['warning'] = $this->language->get('error_warning');
                }

                $json = [
                    'error' => true,
                    'error_arr' => $error_arr,
                    'message' => 'cannot get post data'
                ];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function createInvoiceNo() {
        $this->load->language('sale/shipping_module');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $json['error'] = $this->language->get('error_permission');
        } elseif (isset($this->request->get['order_id'])) {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/shipping_module');

            $invoice_no = $this->model_sale_shipping_module->createInvoiceNo($order_id);

            if ($invoice_no) {
                $json['invoice_no'] = $invoice_no;
            } else {
                $json['error'] = $this->language->get('error_action');
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addReward() {
        $this->load->language('sale/shipping_module');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/shipping_module');

            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            if ($order_info && $order_info['customer_id'] && ($order_info['reward'] > 0)) {
                $this->load->model('sale/customer');

                $reward_total = $this->model_sale_customer->getTotalCustomerRewardsByOrderId($order_id);

                if (!$reward_total) {
                    $this->model_sale_customer->addReward($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['reward'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_reward_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeReward() {
        $this->load->language('sale/shipping_module');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/shipping_module');

            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            if ($order_info) {
                $this->load->model('sale/customer');

                $this->model_sale_customer->deleteReward($order_id);
            }

            $json['success'] = $this->language->get('text_reward_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addCommission() {
        $this->load->language('sale/shipping_module');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/shipping_module');

            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            if ($order_info) {
                $this->load->model('marketing/affiliate');

                $affiliate_total = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($order_id);

                if (!$affiliate_total) {
                    $this->model_marketing_affiliate->addTransaction($order_info['affiliate_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['commission'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_commission_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeCommission() {
        $this->load->language('sale/shipping_module');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/shipping_module')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/shipping_module');

            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            if ($order_info) {
                $this->load->model('marketing/affiliate');

                $this->model_marketing_affiliate->deleteTransaction($order_id);
            }

            $json['success'] = $this->language->get('text_commission_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function country() {
        $json = array();

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);

        if ($country_info) {
            $this->load->model('localisation/zone');

            $json = array(
                'country_id' => $country_info['country_id'],
                'name' => $country_info['name'],
                'iso_code_2' => $country_info['iso_code_2'],
                'iso_code_3' => $country_info['iso_code_3'],
                'address_format' => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone' => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status' => $country_info['status']
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function history() {
        $this->load->language('sale/shipping_module');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['histories'] = array();

        $this->load->model('sale/shipping_module');

        $results = $this->model_sale_shipping_module->getOrderHistories($this->request->get['order_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['histories'][] = array(
                'notify' => $result['notify'] ? $this->language->get('text_yes') : $this->language->get('text_no'),
                'status' => $result['status'],
                'comment' => nl2br($result['comment']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $history_total = $this->model_sale_shipping_module->getTotalOrderHistories($this->request->get['order_id']);

        $pagination = new Pagination();
        $pagination->total = $history_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('sale/shipping_module/history', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . '&page={page}', 'SSL');

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($history_total - 10)) ? $history_total : ((($page - 1) * 10) + 10), $history_total, ceil($history_total / 10));

        $this->response->setOutput($this->load->view('sale/shipping_module_history', $data));
    }

    public function invoice() {
        $this->load->language('sale/shipping_module');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_CATALOG;
        } else {
            $data['base'] = HTTP_CATALOG;
        }

        $this->load->model('sale/shipping_module');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . ' ' . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . ' ' . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();

                $products = $this->model_sale_shipping_module->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_shipping_module->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_shipping_module->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_shipping_module->getOrderTotals($order_id);

                foreach ($totals as $total) {
                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/shipping_module_invoice', $data));
    }

    public function invoiceDO() {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/shipping_module_gst');
        } else {
            $this->load->language('sale/shipping_module');
        }

        $data = array();

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_CATALOG;
        } else {
            $data['base'] = HTTP_CATALOG;
        }

        $this->load->model('sale/shipping_module');
        $this->load->model('sale/excel_import');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_shipping_module->getOrder($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_shipping_module->getOrderProducts($order_id);
                $herbales = $this->model_sale_shipping_module->getUnPaidHerbals($order_id);
                $services = $this->model_sale_shipping_module->getUnPaidServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_shipping_module->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total']),
                            'sub_total' => $this->currency->format($herbale['net_total']),
                            'tax' => $this->currency->format($herbal_tax),
                            'total' => $this->currency->format($herbale['clinicalsale_total'])
                        );

                        $consultation_price = $this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_shipping_module->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                            'sub_total' => $this->currency->format($herbale['d_net_amount']),
                            'tax' => $this->currency->format($consultation_tax),
                            'total' => $this->currency->format($consultation_price)
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                            'sub_total' => $this->currency->format($herbale['d_net_amount']),
                            'tax' => $this->currency->format($herbale['d_gst']),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'])
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0),
                            'sub_total' => $this->currency->format(0),
                            'tax' => $this->currency->format(0),
                            'total' => $this->currency->format(0)
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price']),
                        'sub_total' => $this->currency->format($service['service_price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_shipping_module->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $qr_code_content = 'order_product_' . $product['order_product_id'];
                    $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . base64_encode($qr_code_content) . '&choe=UTF-8';

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount']),
                        'total' => $total,
                        'qr_code' => $qr_code
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_shipping_module->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_shipping_module->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }


                $data['total_gst_amount'] = $this->currency->format($total_tax + $shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                if (!empty($shipping)) {
                    $shipping_address = $shipping_address;
                } else {
                    $shipping_address = '';
                }

                $store_name_arr = explode(' - ', $order_info['store_name']);
                $store_name = $store_name_arr[0];

                $shipped_order_history_row = $this->model_sale_excel_import->get_order_history($order_id, 3);

                $date_added = !empty($shipped_order_history_row) ? $shipped_order_history_row['date_added'] : $order_info['date_added'];

                $carrier_info = ($order_info['carrier_id'] > 0) ? $this->model_sale_shipping_module->getCarrier($order_info['carrier_id']) : [];
                $carrier_name = !empty($carrier_info) ? $carrier_info['name'] : '';
                $tracking_number = !empty($order_info['tracking_number']) ? $order_info['tracking_number'] : '';

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($date_added)),
                    'store_name' => $store_name,
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'carrier_name' => $carrier_name,
                    'tracking_number' => $tracking_number,
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,);

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/shipping_module_invoice_do', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/shipping_module_invoice_do', $data));
    }

    public function invoiceHoald() {
        $this->load->language('sale/shipping_module');

        $data = array();

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_CATALOG;
        } else {
            $data['base'] = HTTP_CATALOG;
        }
        
        $this->load->model('sale/shipping_module');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_shipping_module->getOrder($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_shipping_module->getOrderProducts($order_id);
                $herbales = $this->model_sale_shipping_module->getHoaldHerbals($order_id);
                $services = $this->model_sale_shipping_module->getHoaldServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_shipping_module->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total']),
                            'sub_total' => $this->currency->format($herbale['net_total']),
                            'tax' => $this->currency->format($herbal_tax),
                            'total' => $this->currency->format($herbale['clinicalsale_total'])
                        );

                        $consultation_price = $this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_shipping_module->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_shipping_module->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                            'sub_total' => $this->currency->format($herbale['d_net_amount']),
                            'tax' => $this->currency->format($consultation_tax),
                            'total' => $this->currency->format($consultation_price)
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                            'sub_total' => $this->currency->format($herbale['d_net_amount']),
                            'tax' => $this->currency->format($herbale['d_gst']),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'])
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0),
                            'sub_total' => $this->currency->format(0),
                            'tax' => $this->currency->format(0),
                            'total' => $this->currency->format(0)
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price']),
                        'sub_total' => $this->currency->format($service['service_price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_shipping_module->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount']),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_shipping_module->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_shipping_module->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }



                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);




                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,);

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/shipping_module_invoice_hoald', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/shipping_module_invoice_hoald', $data));
    }

    public function shipping() {
        $this->load->language('sale/shipping_module');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_CATALOG;
        } else {
            $data['base'] = HTTP_CATALOG;
        }

        $this->load->model('sale/shipping_module');
        $this->load->model('sale/excel_import');
        $this->load->model('catalog/product');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_shipping_module->getOrder($order_id);

            // Make sure there is a shipping method
            if ($order_info && $order_info['shipping_code']) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();

                $products = $this->model_sale_shipping_module->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);

                    $option_data = array();

                    $options = $this->model_sale_shipping_module->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product_info['name'],
                        'model' => $product_info['model'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'location' => $product_info['location'],
                        'sku' => $product_info['sku'],
                        'upc' => $product_info['upc'],
                        'ean' => $product_info['ean'],
                        'jan' => $product_info['jan'],
                        'isbn' => $product_info['isbn'],
                        'mpn' => $product_info['mpn'],
                        'weight' => $this->weight->format($product_info['weight'], $this->config->get('config_weight_class_id'), $this->language->get('decimal_point'), $this->language->get('thousand_point'))
                    );
                }

                $shipped_order_history_row = $this->model_sale_excel_import->get_order_history($order_id, 3);

                $date_added = !empty($shipped_order_history_row) ? $shipped_order_history_row['date_added'] : $order_info['date_added'];

                $carrier_info = ($order_info['carrier_id'] > 0) ? $this->model_sale_shipping_module->getCarrier($order_info['carrier_id']) : [];
                $carrier_name = !empty($carrier_info) ? $carrier_info['name'] : '';
                $tracking_number = !empty($order_info['tracking_number']) ? $order_info['tracking_number'] : '';

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($date_added)),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'product' => $product_data,
                    'comment' => nl2br($order_info['comment']),
                    'carrier_name' => $carrier_name,
                    'tracking_number' => $tracking_number
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/order_shipping', $data));
    }

    public function api() {

        $json = array();

        // Store
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        $this->load->model('setting/store');

        $store_info = $this->model_setting_store->getStore($store_id);

        if ($store_info) {
            $url = $store_info['ssl'];
        } else {
            $url = HTTPS_CATALOG;
        }

        if (isset($this->session->data['cookie']) && isset($this->request->get['api'])) {
            // Include any URL perameters
            $url_data = array();

            foreach ($this->request->get as $key => $value) {
                if ($key != 'route' && $key != 'user_token') {
                    $url_data[$key] = $value;
                }
            }

            //html decode
            foreach ($this->request->post as $key => $value) {
                $this->request->post[$key] = html_entity_decode(($value), ENT_QUOTES, 'UTF-8');
            }

            $curl = curl_init();

            // Set SSL if required
            if (substr($url, 0, 5) == 'https') {
                curl_setopt($curl, CURLOPT_PORT, 443);
            }

            curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
            $header = array("Cache-Control: no-cache");
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($curl, CURLOPT_URL, $url . 'index.php?route=' . $this->request->get['api'] . ($url_data ? '&' . http_build_query($url_data) : ''));


            if ($this->request->post) {
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($this->request->post));
            }

            curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');
            $json = curl_exec($curl);

            curl_close($curl);
        }



        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput($json);
    }

}
