<?php
class ControllerSaleSendSms extends Controller{
    private $error = [];

    public function index(){
        $this->load->language('sale/send_sms');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/send_sms');

        $this->getList();
    }

    public function delete() {
		$this->load->language('sale/send_sms');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('sale/send_sms');

		if (isset($this->request->post['selected']) && $this->validateDelete()) {
			foreach ($this->request->post['selected'] as $sms_history_id) {
				$this->model_sale_send_sms->delete_sms_history($sms_history_id);
			}

			$this->session->data['success'] = $this->language->get('text_success_delete');

			$url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }
    
            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }
    
            if (isset($this->request->get['filter_send_by'])) {
                $url .= '&filter_send_by=' . $this->request->get['filter_send_by'];
            }
            
            if (isset($this->request->get['filter_message'])) {
                $url .= '&filter_message=' . $this->request->get['filter_message'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

			$this->response->redirect($this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . $url, 'SSL'));
		}

		$this->getList();
	}

    public function send(){
        $this->load->language('sale/send_sms');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/send_sms');
        $this->load->model('sale/customer_group');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        
        $send_sms = new SMS($this->config->get('config_sms'));

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $db_customer_data = [];

            $sms_message = $this->request->post['message'];

            if(($this->request->post['send_by'] == 'country') || ($this->request->post['send_by'] == 'customer_group')){
                if($this->request->post['send_by'] == 'customer_group'){
                    $customer_group_id = ($this->request->post['customer_group'] > 0) ? $this->request->post['customer_group'] : 0;

                    $filter_data = [
                        'customer_group_id'     => $customer_group_id
                    ];
                } else{
                    $country_id = ($this->request->post['country'] > 0) ? $this->request->post['country'] : 0;
                    $zone_id = ($this->request->post['zone'] > 0) ? $this->request->post['zone'] : 0;
    
                    $filter_data = [
                        'country_id'        => $country_id,
                        'zone_id'           => $zone_id
                    ];
                }

                $customer_list = $this->model_sale_send_sms->get_customers($filter_data);

                if(!empty($customer_list)){
                    foreach($customer_list as $customer){
                        $customer_telephone = !empty($customer['telephone']) ? $customer['telephone'] : '';

                        if(!empty($customer_telephone)){
                            $country_id = $this->config->get('config_country_id');
        					$country_info = $this->model_localisation_country->getCountry($country_id);
        					$mobile_code = $country_info['mobile_code'];

        					if(substr($customer_telephone, 0, 2) == '+6'){
        						$customer_telephone = ltrim($customer_telephone, '+6');
                            }

                            $send_sms->sendTo($mobile_code, $customer_telephone);

                            if(preg_match('/[^A-Za-z0-9\s\.\,]/', $sms_message)){
                                $send_sms->changeContentType();
                                $send_sms->convertUnicode($sms_message);
                            } else{
                                $send_sms->setMessage($sms_message);
                            }

                            $send_sms->send();

                            $db_customer_data[] = [
                                'customer_id'       => $customer['customer_id'],
                                'customer_name'     => $customer['customer_name'],
                                'telephone'         => $customer_telephone
                            ];
                        }                       
                    }

                    $sms_history_id = $this->model_sale_send_sms->add_sms_history($this->request->post, $db_customer_data);
                } else{
                    $sms_history_id = 0;
                }
            } else{
                $customer_ids = $this->request->post['customers'];
                $customer_id_arr = explode(',', $customer_ids);

                if(!empty($customer_id_arr)){
                    foreach($customer_id_arr as $customer_id){
                        $customer_info = $this->model_sale_send_sms->get_customer_by_id($customer_id);
                        
                        $customer_telephone = !empty($customer_info['telephone']) ? $customer_info['telephone'] : '';
                        $customer_name = !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '';

                        if(!empty($customer_telephone)){
                            $country_id = $this->config->get('config_country_id');
        					$country_info = $this->model_localisation_country->getCountry($country_id);
        					$mobile_code = $country_info['mobile_code'];

        					if(substr($customer_telephone, 0, 2) == '+6'){
        						$customer_telephone = ltrim($customer_telephone, '+6');
                            }
                        }

                        $send_sms->sendTo($mobile_code, $customer_telephone);

                        if(preg_match('/[^A-Za-z0-9\s\.\,]/', $sms_message)){
                            $send_sms->changeContentType();
                            $send_sms->convertUnicode($sms_message);
                        } else{
                            $send_sms->setMessage($sms_message);
                        }

                        $send_sms->send();

                        $db_customer_data[] = [
                            'customer_id'       => $customer_id,
                            'customer_name'     => $customer_name,
                            'telephone'         => $customer_telephone
                        ];
                    }

                    $sms_history_id = $this->model_sale_send_sms->add_sms_history($this->request->post, $db_customer_data);
                } else{
                    $sms_history_id = 0;
                }                
            }

            if($sms_history_id > 0){
                $this->session->data['success'] = $this->language->get('text_success');

                $this->response->redirect($this->url->link('sale/send_sms', 'token=' . $this->session->data['token'], 'SSL'));
            }            
        }

        $this->getForm();
    }

    public function view(){
        $this->load->language('sale/send_sms');
        
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/send_sms');

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . $url, 'SSL')
        );

        $language_arr = ['heading_title', 'button_cancel', 'text_view_info', 'column_send_by', 'column_num_of_recipient', 'column_date_added', 'column_message', 'column_recipients', 'column_customer_name', 'column_telephone', 'text_no_results'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $data['sms_history_info'] = [];

        if(isset($this->request->get['sms_history_id'])){
            $sms_history_id = $this->request->get['sms_history_id'];

            $sms_history_info = $this->model_sale_send_sms->get_sms_history($sms_history_id);

            if(!empty($sms_history_info)){
                $recipient_data = unserialize($sms_history_info['recipient_data']);
                $num_of_recipient = count($recipient_data);

                foreach($recipient_data as $index => $recipient){
                    $recipient_data[$index]['customer_url'] = $this->url->link('sale/customer/edit', 'token=' . $this->session->data['token'] . '&customer_id=' . $recipient['customer_id'], 'SSL');
                }

                $data['sms_history_info'] = [
                    'send_by'               => $this->language->get('text_' . $sms_history_info['send_method']),
                    'recipient_data'        => $recipient_data,
                    'num_of_recipient'      => $num_of_recipient,
                    'message'               => $sms_history_info['message'],
                    'date_added'            => date($this->language->get('date_format_short'), strtotime($sms_history_info['date_added']))
                ];
            } else{
                $this->response->redirect($this->url->link('sale/send_sms', 'token=' . $this->session->data['token'], 'SSL'));
            }
        } else{
            $this->response->redirect($this->url->link('sale/send_sms', 'token=' . $this->session->data['token'], 'SSL'));
        }

        $data['cancel'] = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'], 'SSL');

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/sms_history_info.tpl', $data));
    }

    protected function getList(){
        if (isset($this->request->get['filter_date_added_from'])) {
			$filter_date_added_from = $this->request->get['filter_date_added_from'];
		} else {
			$filter_date_added_from = null;
        }
        
        if (isset($this->request->get['filter_date_added_to'])) {
			$filter_date_added_to = $this->request->get['filter_date_added_to'];
		} else {
			$filter_date_added_to = null;
        }
        
        if (isset($this->request->get['filter_send_by'])) {
			$filter_send_by = $this->request->get['filter_send_by'];
		} else {
			$filter_send_by = null;
		}

        if (isset($this->request->get['filter_message'])) {
			$filter_message = $this->request->get['filter_message'];
		} else {
			$filter_message = null;
        }
        
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
        }

        $url = '';

		if (isset($this->request->get['filter_date_added_from'])) {
			$url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
		}

		if (isset($this->request->get['filter_date_added_to'])) {
			$url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
		}

		if (isset($this->request->get['filter_send_by'])) {
			$url .= '&filter_send_by=' . $this->request->get['filter_send_by'];
        }
        
        if (isset($this->request->get['filter_message'])) {
			$url .= '&filter_message=' . $this->request->get['filter_message'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
        }
        
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . $url, 'SSL')
        );

        $data['send_sms'] = $this->url->link('sale/send_sms/send', 'token=' . $this->session->data['token'], 'SSL');
        $data['delete'] = $this->url->link('sale/send_sms/delete', 'token=' . $this->session->data['token'] . $url, 'SSL');

        $data['sms_histories'] = array();

		$filter_data = array(
			'filter_date_added_from'    => $filter_date_added_from,
			'filter_date_added_to' 		=> $filter_date_added_to,
			'filter_send_by'			=> $filter_send_by,
			'filter_message'			=> $filter_message,
			'sort'  				    => $sort,
			'order' 				    => $order,
			'start' 				    => ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				    => $this->config->get('config_limit_admin')
		);
        
        $results = $this->model_sale_send_sms->get_sms_histories($filter_data);
        $total_sms_histories = $this->model_sale_send_sms->get_total_sms_histories($filter_data);
        
        if(!empty($results)){
            foreach($results as $result){
                $recipient_data = unserialize($result['recipient_data']);
                $num_of_recipient = count($recipient_data);

                $data['sms_histories'][] = [
                    'sms_history_id'        => $result['sms_history_id'],
                    'num_of_recipient'      => $num_of_recipient,
                    'message'               => $result['message'],
                    'send_by'               => $this->language->get('text_' . $result['send_method']),
                    'date_added'            => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'view'                  => $this->url->link('sale/send_sms/view', 'token=' . $this->session->data['token'] . '&sms_history_id=' . $result['sms_history_id'], 'SSL')
                ];
            }
        }

        $language_arr = ['heading_title', 'text_list', 'entry_date_added_from', 'entry_date_added_to', 'entry_send_by', 'entry_message', 'button_filter', 'text_customer_group', 'text_individual', 'text_country', 'text_no_results', 'column_message', 'column_send_by', 'column_date_added', 'column_action', 'column_num_of_recipient', 'button_view', 'button_send_sms', 'button_delete', 'text_confirm'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
        }
        
        if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
        }
        
        $url = '';

		if (isset($this->request->get['filter_date_added_from'])) {
			$url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
		}

		if (isset($this->request->get['filter_date_added_to'])) {
			$url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
		}

		if (isset($this->request->get['filter_send_by'])) {
			$url .= '&filter_send_by=' . $this->request->get['filter_send_by'];
		}

		if (isset($this->request->get['filter_message'])) {
			$url .= '&filter_message=' . $this->request->get['filter_message'];
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        // sort
		$data['sort_message'] = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . '&sort=message' . $url, 'SSL');
		$data['sort_send_by'] = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . '&sort=send_method' . $url, 'SSL');
		$data['sort_date_added'] = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . '&sort=date_added' . $url, 'SSL');

		$url = '';

		if (isset($this->request->get['filter_date_added_from'])) {
			$url .= '&filter_date_added_from=' . urlencode(html_entity_decode($this->request->get['filter_date_added_from'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_date_added_to'])) {
			$url .= '&filter_date_added_to=' . urlencode(html_entity_decode($this->request->get['filter_date_added_to'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_send_by'])) {
			$url .= '&filter_send_by=' . urlencode(html_entity_decode($this->request->get['filter_send_by'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_message'])) {
			$url .= '&filter_message=' . urlencode(html_entity_decode($this->request->get['filter_message'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        $pagination = new Pagination();
		$pagination->total = $total_sms_histories;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . $url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sms_histories) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sms_histories - $this->config->get('config_limit_admin'))) ? $total_sms_histories : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sms_histories, ceil($total_sms_histories / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
		$data['order'] = $order;

		$data['filter_date_added_from'] = $filter_date_added_from;
		$data['filter_date_added_to'] = $filter_date_added_to;
		$data['filter_send_by'] = $filter_send_by;
        $data['filter_message'] = $filter_message;

        $data['token'] = $this->session->data['token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/sms_history_list.tpl', $data));
    }

    protected function getForm(){
        $language_arr = ['heading_title', 'text_form', 'entry_send_by', 'text_customer_group', 'text_country', 'text_individual', 'entry_customer_group', 'text_select_all', 'button_select_customer', 'entry_customers', 'help_customers', 'entry_customer_name', 'help_customer_name', 'entry_country', 'entry_zone', 'error_select_customer', 'entry_details', 'entry_minimum_sms_credit', 'entry_current_sms_credit', 'entry_customer_number', 'entry_message', 'text_character_count', 'text_character', 'error_max_char_count', 'text_no_zone', 'button_send_sms', 'button_cancel'];

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'] . $url, 'SSL')
        );

        if (isset($this->request->post['send_by'])) {
			$data['send_by'] = $this->request->post['send_by'];
		} else {
			$data['send_by'] = 'customer_group';
        }

        if (isset($this->request->post['customer_group'])) {
			$data['customer_group'] = $this->request->post['customer_group'];
		} else {
			$data['customer_group'] = 'all';
        }

        if (isset($this->request->post['customers'])) {
			$data['customers'] = $this->request->post['customers'];
		} else {
			$data['customers'] = '';
        }

        if (isset($this->request->post['country'])) {
			$data['country'] = $this->request->post['country'];
		} else {
			$data['country'] = '129';
        }

        if (isset($this->request->post['zone'])) {
			$data['zone'] = $this->request->post['zone'];
		} else {
			$data['zone'] = '';
        }

        if (isset($this->request->post['message'])) {
			$data['message'] = $this->request->post['message'];
		} else {
			$data['message'] = '';
        }

        $config_check_credit = $this->config->get('config_sms_credit');
        $sms_check_credit = new SMS($config_check_credit);

        if(!empty($config_check_credit['host'])){
            $data['minimum_sms_credit'] = $config_check_credit['alert'];

            $credit_string = $sms_check_credit->checkCredit();
			$credit = explode(':', $credit_string);

			if(!empty($credit)){
				if($credit[0] == '1'){
					$data['current_sms_credit'] = $credit[1];
				} else{
					$data['current_sms_credit'] = 0;
				}
			}
        } else{
			$data['current_sms_credit'] = 0;
            $data['minimum_sms_credit'] = 0;
        }

        $sms_settings = $this->config->get('config_sms');

        $data['enable_send_sms'] = !empty($sms_settings['host']) ? true : false;
        
        $data['english_max_count'] = 165;
        $data['chinese_max_count'] = 65;

        $data['token'] = $this->session->data['token'];

        $data['action'] = $this->url->link('sale/send_sms/send', 'token=' . $this->session->data['token'], 'SSL');
        $data['cancel'] = $this->url->link('sale/send_sms', 'token=' . $this->session->data['token'], 'SSL');

        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
        $data['countries'] = $this->model_localisation_country->getCountries();
        $data['zones'] = $this->model_localisation_zone->getZonesByCountryId($data['country']);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/send_sms_from.tpl', $data));
    }

    public function get_customer_count(){
        $json = [];

        $this->load->model('sale/send_sms');

        $send_type = isset($this->request->get['send_type']) ? $this->request->get['send_type'] : false;

        if($send_type){
            if($send_type == 'customer_group'){
                $customer_group_id = isset($this->request->get['customer_group_id']) ? $this->request->get['customer_group_id'] : 0;

                $filter_data = [
                    'customer_group_id'     => $customer_group_id
                ];
            } elseif($send_type == 'country'){
                $country_id = isset($this->request->get['country_id']) ? $this->request->get['country_id'] : 0;
                $zone_id = isset($this->request->get['zone_id']) ? $this->request->get['zone_id'] : 0;

                $filter_data = [
                    'country_id'        => $country_id,
                    'zone_id'           => $zone_id
                ];
            }

            $customer_list = $this->model_sale_send_sms->get_customers($filter_data);

            if(!empty($customer_list)){
                $json['total_customer'] = count($customer_list);
            } else{
                $json['total_customer'] = 0;
            }
        } else{
            $json['total_customer'] = 0;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function get_zone(){
        $json = [];

        $this->load->model('localisation/zone');
       
        $zones = $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']);

        if(!empty($zones)){
            foreach($zones as $zone){
                $json['zones'][] = [
                    'zone_id'       => $zone['zone_id'],
                    'name'          => $zone['name']
                ];
            }
        } else{
            $json['zones'] = [];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function autocomplete(){
        $json = array();

		if (isset($this->request->get['filter_name'])) {
			if (isset($this->request->get['filter_name'])) {
				$filter_name = $this->request->get['filter_name'];
			} else {
				$filter_name = '';
            }

			$this->load->model('sale/send_sms');

			$filter_data = array(
				'filter_name'  => $filter_name,
				'start'        => 0,
				'limit'        => 5
			);

			$results = $this->model_sale_send_sms->get_autocomplete_customers($filter_data);

			foreach ($results as $result) {
				$json[] = array(
					'customer_id'       => $result['customer_id'],
					'customer_name'     => strip_tags(html_entity_decode($result['customer_name'], ENT_QUOTES, 'UTF-8')),					
					'telephone'         => $result['telephone']
				);
			}
		}

		$sort_order = array();

		foreach ($json as $key => $value) {
			$sort_order[$key] = $value['customer_name'];
		}

		array_multisort($sort_order, SORT_ASC, $json);

		$this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    protected function validateForm(){
        if (!$this->user->hasPermission('modify', 'sale/send_sms')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }
        
        $config_check_credit = $this->config->get('config_sms_credit');
        $sms_check_credit = new SMS($config_check_credit);

        if(($this->request->post['send_by'] == 'country') || ($this->request->post['send_by'] == 'customer_group')){
            if($this->request->post['send_by'] == 'customer_group'){
                $customer_group_id = ($this->request->post['customer_group'] > 0) ? $this->request->post['customer_group'] : 0;

                $filter_data = [
                    'customer_group_id'     => $customer_group_id
                ];
            } else{
                $country_id = ($this->request->post['country'] > 0) ? $this->request->post['country'] : 0;
                $zone_id = ($this->request->post['zone'] > 0) ? $this->request->post['zone'] : 0;

                $filter_data = [
                    'country_id'        => $country_id,
                    'zone_id'           => $zone_id
                ];
            }

            $customer_list = $this->model_sale_send_sms->get_customers($filter_data);

            $total_customer = !empty($customer_list) ? count($customer_list) : 0;
        } else{
            $customer_ids = !empty($this->request->post['customers']) ? $this->request->post['customers'] : '';

            if(!empty($customer_ids)){
                $customer_id_arr = explode(',', $customer_ids);

                $total_customer = !empty($customer_id_arr) ? count($customer_id_arr) : 0;
            } else{
                $total_customer = 0;
            }            
        }

        if(!empty($config_check_credit['host'])){
            $credit_string = $sms_check_credit->checkCredit();
			$credit = explode(':', $credit_string);

			if(!empty($credit)){
				if($credit[0] == '1'){
					$current_sms_credit = $credit[1];
				} else{
					$current_sms_credit = 0;
				}
			}
        } else{
			$current_sms_credit = 0;
        }

        if($total_customer >= $current_sms_credit){
            $this->error['warning'] = $this->language->get('error_credit_limit');
        }

        if($total_customer == 0){
            $this->error['warning'] = $this->language->get('error_no_customer');
        }

        if(empty($this->request->post['message'])){
            $this->error['warning'] = $this->language->get('error_empty_message');
        }
        
        if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
    }

    protected function validateDelete() {
		if (!$this->user->hasPermission('modify', 'sale/send_sms')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}
}
?>