<?php
class ControllerSaleSenangpayImport extends Controller{
    private $transaction_status = ['pending_payment', 'paid', 'failed'];
    private $error = [];

    public function index() {
        $this->load->language('sale/senangpay_import');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/senangpay_import');
        $this->load->model('localisation/country');

        //$send_sms = new SMS($this->config->get('config_sms'));

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateImportExcelForm()) {
            if (isset($this->request->post['senangpay_transactions'])) {
                $notify_customer_when_shipped = $this->request->post['notify_customer_when_shipped'];
                
				foreach ($this->request->post['senangpay_transactions'] as $transaction) {
                    $transaction_json = base64_decode($transaction);
                    $transaction_arr = json_decode($transaction_json, true);
                    
                    $import_settings_row = $this->model_sale_senangpay_import->get_setting_by_key('import_settings');
                    $import_settings = !empty($import_settings_row) ? unserialize($import_settings_row['value']) : [];
                    $order_status_id = !empty($import_settings) ? $import_settings['order_status_with_courier'] : 0;

                    $tracking_number = !empty($transaction_arr['tracking_number']) ? $transaction_arr['tracking_number'] : '';
                    $courier_service = !empty($transaction_arr['courier_service']) ? $transaction_arr['courier_service'] : '';
                    $courier_comment = !empty($transaction_arr['courier_comment']) ? $transaction_arr['courier_comment'] : '';

                    $country_id = $this->config->get('config_country_id');
                    $country_info = $this->model_localisation_country->getCountry($country_id);
                    $mobile_code = $country_info['mobile_code'];
                    
                    $order_tracking_number_sms_settings = $this->config->get('config_sms_customer_order_tracking_number');

                    if (!empty($tracking_number) && !empty($courier_service)) {
                        if (empty($shipped_order_history_row)) {
                            if ($notify_customer_when_shipped > 0) {
                                // send sms to the customer for the tracking number 
                                if (!empty($transaction_arr['telephone'])) {
                                    $customer_telephone = $transaction_arr['telephone'];

                                    if(substr($customer_telephone, 0, 2) == '+6'){
                                        $customer_telephone = ltrim($customer_telephone, '+6');
                                    }

                                    if ($order_tracking_number_sms_settings['status'] == '1') {
                                        $find_sms_template = ['{order_id}', '{courier}', '{shipping_tracking}'];

                                        $replace_sms_template = [
                                            'order_id'				=> $transaction_arr['order_id'],
                                            'courier'				=> $courier_service,
                                            'shipping_tracking'		=> $tracking_number
                                        ];

                                        $sms_message = str_replace($find_sms_template, $replace_sms_template, $order_tracking_number_sms_settings['template']);

                                        $send_sms->sendTo($mobile_code, $customer_telephone);

                                        if(preg_match('/[^A-Za-z0-9\s\.\,]/', $sms_message)){
                                            $send_sms->changeContentType();
                                            $send_sms->convertUnicode($sms_message);
                                        } else{
                                            $send_sms->setMessage($sms_message);
                                        }

                                        $send_sms->send();
                                    }											
                                }
                            }

                            // if different email address
                            if (!$transaction_arr['same_email']) {
                                $this->model_sale_senangpay_import->update_customer_order_email($transaction_arr['order_id'], $transaction_arr['email']);
                                $this->model_sale_senangpay_import->update_customer_email($transaction_arr['customer_id'], $transaction_arr['email']);
                            }

                            // if different telephone
                            if (!$transaction_arr['same_telephone']) {
                                $this->model_sale_senangpay_import->update_customer_order_telephone($transaction_arr['order_id'], $transaction_arr['telephone']);
                                $this->model_sale_senangpay_import->update_customer_telephone($transaction_arr['customer_id'], $transaction_arr['telephone']);
                            }

                            $this->model_sale_senangpay_import->add_order_history($transaction_arr['order_id'], $order_status_id, $notify_customer_when_shipped, $courier_comment);
                            $this->model_sale_senangpay_import->update_order_status($transaction_arr['order_id'], $order_status_id);
                        }
                    }
                }
            }

            $this->session->data['success'] = $this->language->get('text_success_import');

			$this->response->redirect($this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getList();
    }

    public function merchant_settings() {
        $this->load->language('sale/senangpay_import');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/senangpay_import');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_senangpay_import->save_settings($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success_merchant_settings');

			$this->response->redirect($this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getMerchantSettingsForm();
    }

    public function view_sp_transaction() {
        $this->load->language('sale/senangpay_import');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/senangpay_import');

        if (isset($this->request->get['transaction_ref'])) {
            $transaction_ref = $this->request->get['transaction_ref'];

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );
    
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true)
            );
                
            $api_response = $this->get_transaction($transaction_ref);

            $transaction_details = [];
            $data['transaction_details'] = [];
            $products = [];

            if ($api_response['status'] == '1') {
                $transaction_details = $api_response['data'][0];

                $order_status = str_replace(' ', '_', $transaction_details['payment_info']['status']);

                switch ($order_status) {
                    case 'pending_payment':
                        $label_status = 'label-warning';
                        break;
                    case 'paid':
                        $label_status = 'label-success';
                        break;
                    case 'failed':
                        $label_status = 'label-danger';
                        break;
                    default: 
                        $label_status = 'label-danger';
                        break;
                }

                $find_customer_telephone = [' ', '-'];
                $replace_customer_telephone = ['space' => '', 'dash' => ''];

                $customer_telephone = str_replace($find_customer_telephone, $replace_customer_telephone, $transaction_details['buyer_contact']['phone']);

                $products[] = [
                    'product_name'          => $transaction_details['product']['product_name'],
                    'product_description'   => $transaction_details['product']['description'],
                    'unit_price'            => $this->currency->format($transaction_details['order_detail']['unit_price'], $this->config->get('config_currency')),
                    'quantity'              => $transaction_details['order_detail']['quantity'],
                    'total'                 => $this->currency->format($transaction_details['order_detail']['grand_total'], $this->config->get('config_currency'))
                ];

                $data['transaction_details'] = [
                    'transaction_ref'       => $transaction_details['payment_info']['transaction_reference'],
                    'transaction_date'      => date($this->language->get('date_format_short'), $transaction_details['payment_info']['transaction_date']),
                    'payment_method'        => $transaction_details['payment_info']['payment_mode'],
                    'customer_name'         => $transaction_details['buyer_contact']['name'],
                    'telephone'             => $customer_telephone,
                    'email'                 => $transaction_details['buyer_contact']['email'],
                    'label_status'          => $label_status,
                    'status'                => $this->language->get('text_order_status_senangpay_' . $order_status),
                    'total'                 => $this->currency->format($transaction_details['order_detail']['grand_total'], $this->config->get('config_currency')),
                    'shipping_address_1'    => $transaction_details['delivery_address']['address_1'],
                    'shipping_address_2'    => $transaction_details['delivery_address']['address_2'],
                    'shipping_city'         => $transaction_details['delivery_address']['city'],
                    'shipping_postcode'     => $transaction_details['delivery_address']['postcode'],
                    'shipping_zone'         => $transaction_details['delivery_address']['state'],
                    'shipping_country'      => $transaction_details['delivery_address']['country'],
                    'note'                  => $transaction_details['buyer_contact']['Note'],
                    'products'              => $products
                ];
            }
        } else {
			$this->response->redirect($this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true));
        }

        $data['cancel'] = $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/senangpay_transaction_info', $data));
    }

    public function import() {
        $this->load->language('sale/senangpay_import');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/senangpay_import');
        $this->load->model('sale/customer');
        $this->load->model('setting/store');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        if (isset($this->request->post['selected']) && $this->validateImport()) {
            $store_id = $this->session->data['store_id'];
            $store_info = $this->model_setting_store->getStore($store_id);
            
            $store_name = !empty($store_info) ? $store_info['name'] : $this->config->get('config_name');
            $store_url = !empty($store_info) ? $store_info['url'] : HTTP_CATALOG;

            foreach ($this->request->post['selected'] as $transaction_ref) {
                $address = [];
    
                $transaction_details = $this->get_transaction($transaction_ref);
    
                if ($transaction_details['status'] == '1') {     
                    $imported_transaction_ref_row = $this->model_sale_senangpay_import->get_senangpay_transaction($transaction_ref);

                    if (empty($imported_transaction_ref_row)) {
                        $import_settings_row = $this->model_sale_senangpay_import->get_setting_by_key('import_settings');
                        $import_settings = !empty($import_settings_row) ? unserialize($import_settings_row['value']) : [];
                        $customer_group_id = !empty($import_settings) ? $import_settings['customer_group'] : 0;
                        $order_status_id = !empty($import_settings) ? $import_settings['order_status'] : 0;
        
                        $transaction_data = $transaction_details['data'][0];
    
                        $find_customer_telephone = [' ', '-'];
                        $replace_customer_telephone = ['space' => '', 'dash' => ''];

                        $customer_telephone = str_replace($find_customer_telephone, $replace_customer_telephone, $transaction_data['buyer_contact']['phone']);
        
                        $customer_info = $this->model_sale_senangpay_import->get_customer_by_telephone($customer_telephone);
                    
                        if (empty($customer_info)) {
                            $zone_info = $this->model_sale_senangpay_import->get_zone_by_name($transaction_data['delivery_address']['state']);
                            $zone_id = !empty($zone_info) ? $zone_info['zone_id'] : 0;
        
                            $country_info = $this->model_sale_senangpay_import->get_country_by_name($transaction_data['delivery_address']['country']);
                            $country_id = !empty($country_info) ? $country_info['country_id'] : 0;
        
                            $address[] = [
                                'firstname'     => $transaction_data['buyer_contact']['name'],
                                'lastname'      => '',
                                'company'       => '',
                                'address_1'     => $transaction_data['delivery_address']['address_1'],
                                'address_2'     => $transaction_data['delivery_address']['address_2'],
                                'address_3'     => '',
                                'city'          => $transaction_data['delivery_address']['city'],
                                'postcode'      => $transaction_data['delivery_address']['postcode'],
                                'zone_id'       => $zone_id,
                                'country_id'    => $country_id,
                                'default'       => 1
                            ];
        
                            $insert_customer_data = [
                                'firstname'             => $transaction_data['buyer_contact']['name'],
                                'lastname'              => '',
                                'customer_ic'           => '',
                                'customer_card'         => '',
                                'gender'                => '0',
                                'customer_group_id'     => $customer_group_id,
                                'email'                 => $transaction_data['buyer_contact']['email'],
                                'telephone'             => $customer_telephone,
                                'telephone2'            => '',
                                'home'                  => '',
                                'fax'                   => '',
                                'newsletter'            => '0',
                                'status'                => '1',
                                'password'              => '',
                                'approved'              => '1',
                                'safe'                  => '1',
                                'address'               => $address
                            ];
        
                            $customer_id = $this->model_sale_customer->addCustomer($insert_customer_data);  
                        } else {
                            $customer_id = $customer_info['customer_id'];

                            $zone_info = $this->model_sale_senangpay_import->get_zone_by_name($transaction_data['delivery_address']['state']);
                            $zone_id = !empty($zone_info) ? $zone_info['zone_id'] : 0;
        
                            $country_info = $this->model_sale_senangpay_import->get_country_by_name($transaction_data['delivery_address']['country']);
                            $country_id = !empty($country_info) ? $country_info['country_id'] : 0;
                            
                            $address = [
                                'firstname'     => $transaction_data['buyer_contact']['name'],
                                'lastname'      => '',
                                'company'       => '',
                                'address_1'     => $transaction_data['delivery_address']['address_1'],
                                'address_2'     => $transaction_data['delivery_address']['address_2'],
                                'address_3'     => '',
                                'city'          => $transaction_data['delivery_address']['city'],
                                'postcode'      => $transaction_data['delivery_address']['postcode'],
                                'zone_id'       => $zone_id,
                                'country_id'    => $country_id,
                                'default'       => 1
                            ];

                            $this->model_sale_senangpay_import->add_address($address, $customer_id);
                        }

                        $customer_info = $this->model_sale_senangpay_import->get_customer($customer_id);
                        $address_id = !empty($customer_info) ? $customer_info['address_id'] : 0;

                        $address_info = $this->model_sale_senangpay_import->get_address($address_id);

                        if (!empty($customer_info) && !empty($address_info)) {
                            $order_products = [];
                            $order_totals = [];
    
                            date_default_timezone_set($this->config->get('config_time_zone'));
    
                            $country_row = $this->model_localisation_country->getCountry($address_info['country_id']);
                            $country_name = !empty($country_row) ? $country_row['name'] : '';
    
                            $zone_row = $this->model_localisation_zone->getZone($address_info['zone_id']);
                            $zone_name = !empty($zone_row) ? $zone_row['name'] : '';
    
                            $product_info_by_name = $this->model_sale_senangpay_import->get_product_by_name($transaction_data['product']['description'] . ' ' . $transaction_data['product']['product_name']);
                            
                            if (!empty($product_info_by_name)) {
                                $product_id = $product_info_by_name['product_id'];
                            } else {
                                $insert_product = [
                                    'product_name'      => $transaction_data['product']['product_name'],
                                    'description'       => $transaction_data['product']['description'],
                                    'price'             => $transaction_data['order_detail']['unit_price']
                                ];
    
                                $product_id = $this->model_sale_senangpay_import->add_product($insert_product);
                            }
    
                            $product_info = $this->model_sale_senangpay_import->get_product($product_id);
    
                            if (!empty($product_info)) {
                                $order_products[] = [
                                    'product_id'            => $product_id,
                                    'name'                  => $product_info['name'],
                                    'model'                 => $product_info['model'],
                                    'quantity'              => $transaction_data['order_detail']['quantity'],
                                    'tax_class_id'          => $product_info['tax_class_id'],
                                    'price'                 => $product_info['price'],
                                    'net_amount'            => $product_info['price'],
                                    'total_net_amount'      => $product_info['price'] * $transaction_data['order_detail']['quantity'],
                                    'total'                 => $transaction_data['order_detail']['grand_total'],
                                    'tax'                   => $transaction_data['order_detail']['gst'],
                                    'total_tax'             => $transaction_data['order_detail']['gst'] * $transaction_data['order_detail']['quantity']
                                ];
                            }                      
    
                            $order_totals[] = [
                                'code'          => 'sub_total',
                                'title'         => 'Total Sales (Excl Tax)',
                                'value'         => $transaction_data['order_detail']['grand_total'],
                                'sort_order'    => '1'
                            ];
    
                            $order_totals[] = [
                                'code'          => 'shipping',
                                'title'         => 'Delivery Charge',
                                'value'         => $transaction_data['order_detail']['delivery_charge'],
                                'sort_order'    => '3'
                            ];
    
                            $order_totals[] = [
                                'code'          => 'tax',
                                'title'         => 'Tax',
                                'value'         => $transaction_data['order_detail']['gst'],
                                'sort_order'    => '5'
                            ];
    
                            $order_totals[] = [
                                'code'          => 'rounding',
                                'title'         => 'Rounding',
                                'value'         => 0,
                                'sort_order'    => '8'
                            ];
    
                            $order_totals[] = [
                                'code'          => 'total',
                                'title'         => 'Total Sales (Incl Tax)',
                                'value'         => $transaction_data['order_detail']['grand_total'],
                                'sort_order'    => '9'
                            ];
    
                            $insert_order_data = [
                                'store_id'              => $store_id,
                                'store_name'            => $store_name . ' - ' . $transaction_data['payment_info']['transaction_reference'],
                                'store_url'             => $store_url,
                                'customer_id'           => $customer_id,
                                'customer_group_id'     => $customer_info['customer_group_id'],
                                'firstname'             => $customer_info['firstname'],
                                'email'                 => $customer_info['email'],
                                'telephone'             => $customer_info['telephone'],
                                'payment_firstname'     => $customer_info['firstname'],
                                'payment_address_1'     => $address_info['address_1'],
                                'payment_address_2'     => $address_info['address_2'],
                                'payment_city'          => $address_info['city'],
                                'payment_postcode'      => $address_info['postcode'],
                                'payment_country'       => $country_name,
                                'payment_country_id'    => $address_info['country_id'],
                                'payment_zone_id'       => $address_info['zone_id'],
                                'payment_zone'          => $zone_name,
                                'payment_method'        => $transaction_data['payment_info']['payment_mode'],
                                'payment_code'          => 'senangPay',
                                'shipping_address_id'   => $address_info['address_id'],
                                'shipping_firstname'    => $customer_info['firstname'],
                                'shipping_address_1'    => $address_info['address_1'],
                                'shipping_address_2'    => $address_info['address_2'],
                                'shipping_city'         => $address_info['city'],
                                'shipping_postcode'     => $address_info['postcode'],
                                'shipping_country'      => $country_name,
                                'shipping_country_id'   => $address_info['country_id'],
                                'shipping_zone_id'      => $address_info['zone_id'],
                                'shipping_zone'         => $zone_name,
                                'shipping_method'       => 'Free Delivery',
                                'shipping_code'         => 'category_product_based.category_product_based_0',
                                'comment'               => $transaction_data['buyer_contact']['Note'],
                                'total'                 => $transaction_data['order_detail']['grand_total'],
                                'shipping_total'        => $transaction_data['order_detail']['delivery_charge'],
                                'order_status_id'       => $order_status_id,
                                'language_id'           => $this->config->get('config_language_id'),
                                'currency_id'           => $this->currency->getId($this->config->get('config_currency')),
                                'currency_code'         => $this->config->get('config_currency'),
                                'currency_value'        => $this->currency->getValue($this->config->get('config_currency')),
                                'ip'                    => $transaction_data['network_info']['ip'],
                                'user_agent'            => $transaction_data['network_info']['browser'],
                                'date_ordered'          => date('Y-m-d H:i:s', $transaction_data['payment_info']['transaction_date']),
                                'order_products'        => $order_products,
                                'order_totals'          => $order_totals
                            ];
    
    
                            $order_id = $this->model_sale_senangpay_import->add_order($insert_order_data);
    
                            if ($order_id > 0) {
                                $this->model_sale_senangpay_import->insert_senangpay_transaction($transaction_data['payment_info']['transaction_reference'], $order_id);
                            }
                        }
                    }                   
                }
            }

            $this->session->data['success'] = $this->language->get('text_success_import');

            $url = '';

            if (isset($this->request->get['filter_date_from'])) {
                $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
            }
    
            if (isset($this->request->get['filter_date_to'])) {
                $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
            }
            
            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }
    
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }
    
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }
    
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }
        
            $this->response->redirect($this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function import_excel() {
        $json = [];
		$full_return_transactions = [];
		$return_transactions = [];

        $this->load->model('sale/senangpay_import');

		$excel_filename = $this->request->files['excel_file']['name'];

		$ext = pathinfo($excel_filename, PATHINFO_EXTENSION);

		if(strtolower($ext) != 'xlsx'){
			$json = [
				'success'	=> false
			];
		} else{
            $this->load->library('PHPExcel');
			$this->excel = new PHPExcel();

			$obj_reader = PHPExcel_IOFactory::createReader('Excel2007');
			$obj_php_excel = $obj_reader->load($this->request->files['excel_file']['tmp_name']);

			$sheet = $obj_php_excel->getActiveSheet();
			$highest_row = $sheet->getHighestRow();
            $highest_column = $sheet->getHighestColumn();

			$sheets = [];

			for ($row = 1; $row <= $highest_row; $row++) {
				$sheets[$row] = $sheet->rangeToArray('A' . $row . ':' . $highest_column . $highest_row, null, true, false)[0];
			}

            $transactions_imported = [];
			$headers = array_shift($sheets);
			$header = array_filter($headers);

			foreach($sheets as $d => $dt) {
				if (is_array($dt)) {
					$transactions_imported[$d] = [];
					foreach ($dt as $rd => $row) {
						if (in_array($rd, array_keys($header))) {
							$transactions_imported[$d][$header[$rd]] = $row;
						}
					}
				}
            }
            
            if(!empty($transactions_imported)){
				foreach($transactions_imported as $transaction){
					$got_order_id = array_key_exists('Order ID', $transaction) ? true : false;
					$got_courier_service = array_key_exists('Courier Service', $transaction) ? true : false;
					$got_tracking_number = array_key_exists('Tracking Number', $transaction) ? true : false;
					$got_customer_name = array_key_exists('Customer Name', $transaction) ? true : false;
					$got_transaction_ref = array_key_exists('Transaction Reference', $transaction) ? true : false;
					$got_total = array_key_exists('Total', $transaction) ? true : false;
					$got_telephone = array_key_exists('Telephone', $transaction) ? true : false;
					$got_email = array_key_exists('Email', $transaction) ? true : false;

					if ($got_order_id && $got_courier_service && $got_tracking_number && $got_customer_name && $got_transaction_ref && $got_total && $got_telephone && $got_email) {
                        if (!is_null($transaction['Order ID'])) {
                            $order_row = $this->model_sale_senangpay_import->get_order($transaction['Order ID']);

                            $customer_id = !empty($order_row) ? $order_row['customer_id'] : 0;
                            $customer_row = ($customer_id > 0) ? $this->model_sale_senangpay_import->get_customer($customer_id) : [];

                            $db_telephone = !empty($customer_row) ? $customer_row['telephone'] : '';
                            
                            $find_telephone = ['-', ' '];
                            $replace_telephone = ['dash' => '', 'space'	=> ''];
        
                            $excel_telephone = str_replace($find_telephone, $replace_telephone, $transaction['Telephone']);
                            $excel_telephone_arr = explode('/', $excel_telephone);
                            $excel_telephone = $excel_telephone_arr[0];

                            $db_email = !empty($customer_row) ? $customer_row['email'] : '';
                            $excel_email = $transaction['Email'];

                            $same_telephone = ($db_telephone == $excel_telephone) ? true : false;
                            $same_email = ($db_email == $excel_email) ? true : false;

                            $courier_service = !empty($transaction['Courier Service']) ? $transaction['Courier Service'] : '';
                            $tracking_number = !empty($transaction['Tracking Number']) ? $transaction['Tracking Number'] : '';
                        
                            $courier_data = !empty($courier_service) ? $this->model_sale_senangpay_import->get_courier_data_by_name($courier_service) : [];
						    $courier_comment = !empty($courier_data) ? $courier_data['name'] . ' ' . $tracking_number . ' ' . str_replace('{tracking_number}', $tracking_number, $courier_data['tracking_url']) : '';

                            $return_transactions[] = [
                                'order_id'              => $transaction['Order ID'],
                                'transaction_ref'       => str_replace("'", "", $transaction['Transaction Reference']),
                                'courier_service'       => $courier_service,
                                'tracking_number'       => $tracking_number,
                                'courier_comment'       => $courier_comment,
                                'customer_id'           => (int)$customer_id,
                                'customer_name'         => $transaction['Customer Name'],
                                'telephone'             => $excel_telephone,
                                'email'                 => $excel_email,
                                'same_telephone'        => $same_telephone,
                                'same_email'            => $same_email,
                                'total'                 => $this->currency->format($transaction['Total'], $this->config->get('config_currency')),
                                'order_url'             => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $transaction['Order ID'], true),
                                'customer_url'          => !empty($customer_row) ? $this->url->link('sale/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $customer_row['customer_id'], true) : ''
                            ];
                        }                        
                    }
                }
            }

            if (!empty($return_transactions)) {
				$order_id_column = array_column($return_transactions, 'order_id');
	
				array_multisort($return_transactions, SORT_NUMERIC, $order_id_column, SORT_DESC);
	
				foreach ($return_transactions as $transaction) {
					$full_return_transactions[] = [
						'data'				=> $transaction,
						'encrypted_data'	=> base64_encode(json_encode($transaction))
					];
				}
	
				$json = array(
					'success' 				=> true,
					'total_transaction'		=> count($full_return_transactions),
					'respond' 				=> $full_return_transactions
				);
			} else {
				$json = [
					'success'	=> false
				];
            }
        }

        $this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
    }

    public function imported_transaction_export() {
        $this->load->language('sale/senangpay_import');
        
        $this->load->model('sale/senangpay_import');
        $this->load->model('localisation/order_status');

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel =  new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()   ->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
        ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
        ->setTitle('Title')
        ->setSubject('Subject')
        ->setDescription('Description')
        ->setKeywords('report etcm.me')
        ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()  ->setName('Arial')
                                                    ->setSize(10);

        // Table Data

        // get data collection from database
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = date('Y-m-01');
        }

        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $filter_date_to = date('Y-m-t');
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = '';
        }

        $filter_data = [
            'filter_date_from'      => $filter_date_from,
            'filter_date_to'        => $filter_date_to,
            'filter_order_status'   => $filter_order_status
        ];

        $table_collection = [];

        $results = $this->model_sale_senangpay_import->get_imported_transactions($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $order_status_row = $this->model_localisation_order_status->getOrderStatus($result['order_status_id']);
                $order_status = !empty($order_status_row) ? $order_status_row['name'] : '';
                $customer_name = !empty($result['lastname']) ? $result['firstname'] . ' ' . $result['lastname'] : $result['firstname'];

                $table_collection[] = [
                    'order_id'                  => $result['order_id'],
                    'transaction_reference'     => "'" . $result['transaction_reference'],
                    'customer_name'             => $customer_name,
                    'telephone'                 => chunk_split($result['telephone'], 3, ' '),
                    'email'                     => $result['email'],
                    'total'                     => $result['total'],
                    'transaction_date'          => date('Y-m-d', strtotime($result['date_ordered'])),
                    'order_status'              => $order_status,
                    'courier_service'           => '',
                    'tracking_number'           => ''
                ];
            }
        }

        $table = array();

        $table_header = array(//table headers
			$this->language->get('column_excel_order_id'),
			$this->language->get('column_excel_transaction_ref'),
			$this->language->get('column_excel_customer_name'),
			$this->language->get('column_excel_telephone'),
			$this->language->get('column_excel_email'),
			$this->language->get('column_excel_total'),
			$this->language->get('column_excel_transaction_date'),
			$this->language->get('column_excel_order_status'),
			$this->language->get('column_excel_courier_service'),
			$this->language->get('column_excel_tracking_number')
		);
        
        $table[] = $table_header;//add header to table
        
        $table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 1;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
        
        $currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
        
        $objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="'. $this->language->get('text_senangpay_imported_transactions') . ' ' . $filter_date_from . ' to ' . $filter_date_to . '.xlsx"');
        $objWriter->save('php://output');
    }

    protected function getList() {
        if (isset($this->request->get['filter_date_from'])) {
            $filter_date_from = $this->request->get['filter_date_from'];
        } else {
            $filter_date_from = date('Y-m-01');
        }
        
        if (isset($this->request->get['filter_date_to'])) {
            $filter_date_to = $this->request->get['filter_date_to'];
        } else {
            $first_day_of_the_month = date('Y-m-01');

            $filter_date_to = date('Y-m-d', strtotime($first_day_of_the_month. ' + 31 days'));
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }
        
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
        }
        
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['error_text_warning'] = $this->language->get('error_warning');

        $api_response = [];
        $data['transactions'] = [];

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        date_default_timezone_set($this->config->get('config_time_zone'));

        $filter_data = array(
            'filter_date_from'                  => $filter_date_from,
            'filter_date_to'                    => $filter_date_to,
            'filter_status'                     => $filter_status,
            'sort'                              => $sort,
			'order'                             => $order
        );

        $merchant_id_row = $this->model_sale_senangpay_import->get_setting_by_key('merchant_id');
        $merchant_id = !empty($merchant_id_row) ? $merchant_id_row['value'] : '';

        $secret_key_row = $this->model_sale_senangpay_import->get_setting_by_key('secret_key');
        $secret_key = !empty($secret_key_row) ? $secret_key_row['value'] : '';

        $transaction_list_row = $this->model_sale_senangpay_import->get_setting_by_key('transaction_list');
        $transaction_list = !empty($transaction_list_row) ? unserialize($transaction_list_row['value']) : '';
        $transaction_list_api = $transaction_list['api'];

        $find_transaction_list_api = [
            '{merchant_id}',
            '{timestamp_start}',
            '{timestamp_end}',
            '{hash}'
        ];

        $hash = md5($merchant_id . $secret_key . strtotime($filter_data['filter_date_from']) . strtotime($filter_data['filter_date_to']));

        $replace_transaction_list_api = [
            'merchant_id'       => $merchant_id,
            'timestamp_start'   => strtotime($filter_data['filter_date_from']),
            'timestamp_end'     => strtotime($filter_data['filter_date_to']),
            'hash'              => $hash
        ];

        $transaction_list_api = str_replace($find_transaction_list_api, $replace_transaction_list_api, $transaction_list_api);

        $api_response = $this->call_api_get($transaction_list_api);

        if (!empty($api_response)) {
            if ($api_response['status'] == '1') {
                foreach ($api_response['data'] as $transaction) {
                    $transaction_ref = $transaction['payment_info']['transaction_reference'];
                    $order_status = str_replace(' ', '_', $transaction['payment_info']['status']);

                    $imported_transaction_ref_row = $this->model_sale_senangpay_import->get_senangpay_transaction($transaction_ref);
                    $imported_transaction_ref = !empty($imported_transaction_ref_row) ? $this->language->get('text_imported') : $this->language->get('text_not_import');
                    $imported_transaction_ref_label = !empty($imported_transaction_ref_row) ? 'label-success' : 'label-warning';

                    switch ($order_status) {
                        case 'pending_payment':
                            $label_status = 'label-warning';
                            break;
                        case 'paid':
                            $label_status = 'label-success';
                            break;
                        case 'failed':
                            $label_status = 'label-danger';
                            break;
                        default: 
                            $label_status = 'label-danger';
                            break;
                    }

                    $find_customer_telephone = [' ', '-'];
                    $replace_customer_telephone = ['space' => '', 'dash' => ''];

                    $customer_telephone = str_replace($find_customer_telephone, $replace_customer_telephone, $transaction['buyer_contact']['phone']);

                    $customer_info = $this->model_sale_senangpay_import->get_customer_by_telephone($customer_telephone);
                    $db_customer_name = !empty($customer_info) ? $customer_info['firstname'] . ' ' . $customer_info['lastname'] : '-';
                    $customer_url = !empty($customer_info) ? $this->url->link('sale/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $customer_info['customer_id'], true) : '';

                    if (!empty($filter_status)) {
                        if ($filter_status == $order_status) {
                            $data['transactions'][] = [
                                'order_id'              => !empty($imported_transaction_ref_row) ? $imported_transaction_ref_row['order_id'] : '-',
                                'transaction_ref'       => $transaction_ref,
                                'db_customer_name'      => $db_customer_name,
                                'customer_url'          => $customer_url,
                                'customer_name'         => $transaction['buyer_contact']['name'],
                                'email'                 => $transaction['buyer_contact']['email'],
                                'telephone'             => $customer_telephone,
                                'status'                => $this->language->get('text_order_status_senangpay_' . $order_status),
                                'label_status'          => $label_status,
                                'total'                 => $this->currency->format($transaction['order_detail']['grand_total'], $this->config->get('config_currency')),
                                'transaction_date'      => date($this->language->get('date_format_short'), $transaction['payment_info']['transaction_date']),
                                'import_status'         => $imported_transaction_ref,
                                'label_import_status'   => $imported_transaction_ref_label,
                                'view'                  => $this->url->link('sale/senangpay_import/view_sp_transaction', 'user_token=' . $this->session->data['user_token'] . '&transaction_ref=' . $transaction['payment_info']['transaction_reference'], true),
                                'order_url'             => !empty($imported_transaction_ref_row) ? $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $imported_transaction_ref_row['order_id'], true) : ''
                            ];
                        }
                    } else {
                        $data['transactions'][] = [
                            'order_id'              => !empty($imported_transaction_ref_row) ? $imported_transaction_ref_row['order_id'] : '-',
                            'transaction_ref'       => $transaction_ref,
                            'db_customer_name'      => $db_customer_name,
                            'customer_url'          => $customer_url,
                            'customer_name'         => $transaction['buyer_contact']['name'],
                            'email'                 => $transaction['buyer_contact']['email'],
                            'telephone'             => $customer_telephone,
                            'status'                => $this->language->get('text_order_status_senangpay_' . $order_status),
                            'label_status'          => $label_status,
                            'total'                 => $this->currency->format($transaction['order_detail']['grand_total'], $this->config->get('config_currency')),
                            'transaction_date'      => date($this->language->get('date_format_short'), $transaction['payment_info']['transaction_date']),
                            'import_status'         => $imported_transaction_ref,
                            'label_import_status'   => $imported_transaction_ref_label,
                            'view'                  => $this->url->link('sale/senangpay_import/view_sp_transaction', 'user_token=' . $this->session->data['user_token'] . '&transaction_ref=' . $transaction['payment_info']['transaction_reference'], true),
                            'order_url'             => !empty($imported_transaction_ref_row) ? $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $imported_transaction_ref_row['order_id'], true) : ''
                        ];    
                    }
                }
            }
        }
       
        $transaction_total = count($data['transactions']);

        $data['transactions'] = array_slice($data['transactions'], $start, $limit);

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
        }
        
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
			$data['selected'] = (array)$this->request->post['selected'];
		} else {
			$data['selected'] = array();
        }

        if (isset($this->request->post['senangpay_transactions'])) {
			$data['senangpay_transactions'] = $this->request->post['senangpay_transactions'];
		} else {
			$data['senangpay_transactions'] = [];
		}

		if (isset($this->request->post['notify_customer_when_shipped'])) {
			$data['notify_customer_when_shipped'] = $this->request->post['notify_customer_when_shipped'];
		} else {
			$data['notify_customer_when_shipped'] = '0';
		}
        
        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
        }
        
        // sort

        if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $url = '';

        if (isset($this->request->get['filter_date_from'])) {
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        }

        if (isset($this->request->get['filter_date_to'])) {
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        }
        
        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

        foreach ($this->transaction_status as $status) {
            $data['transaction_statuses'][] = [
                'status'        => $status,
                'status_text'   => $this->language->get('text_order_status_senangpay_' . $status)
            ];
        }

        $data['total_transaction'] = 0;

        $data['export_date_from'] = date('Y-m-01');
        $data['export_date_to'] = date('Y-m-t');

        $data['import'] = $this->url->link('sale/senangpay_import/import', 'user_token=' . $this->session->data['user_token'], true);
        $data['import_excel_action'] = $this->url->link('sale/senangpay_import/import_excel', 'user_token=' . $this->session->data['user_token'], true);
        $data['action'] = $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true);
        $data['senangpay_merchant_settings'] = $this->url->link('sale/senangpay_import/merchant_settings', 'user_token=' . $this->session->data['user_token'], true);

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        
        $pagination = new Pagination();
		$pagination->total = $transaction_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($transaction_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($transaction_total - $this->config->get('config_limit_admin'))) ? $transaction_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $transaction_total, ceil($transaction_total / $this->config->get('config_limit_admin')));
        
        $data['user_token'] = $this->session->data['user_token'];

        $data['filter_date_from'] = $filter_date_from;
        $data['filter_date_to'] = $filter_date_to;
        $data['filter_status'] = $filter_status;

        $data['sort'] = $sort;
        $data['order'] = $order;
        
        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/senangpay_import_list', $data));
    }

    protected function getMerchantSettingsForm() {
        $senangpay_settings = $this->get_settings();

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('sale/senangpay_import/merchant_settings', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('sale/senangpay_import', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
        }
        
        if (isset($this->error['merchant_id'])) {
			$data['error_merchant_id'] = $this->error['merchant_id'];
		} else {
			$data['error_merchant_id'] = '';
        }
        
        if (isset($this->error['secret_key'])) {
			$data['error_secret_key'] = $this->error['secret_key'];
		} else {
			$data['error_secret_key'] = '';
        }
        
        if (isset($this->error['import_customer_group'])) {
			$data['error_import_customer_group'] = $this->error['import_customer_group'];
		} else {
			$data['error_import_customer_group'] = '';
        }
        
        if (isset($this->error['import_order_status'])) {
			$data['error_import_order_status'] = $this->error['import_order_status'];
		} else {
			$data['error_import_order_status'] = '';
        }
        
        if (isset($this->error['order_status_with_courier'])) {
			$data['error_order_status_with_courier'] = $this->error['order_status_with_courier'];
		} else {
			$data['error_order_status_with_courier'] = '';
		}

        if (isset($this->request->post['merchant_id'])) {
            $data['merchant_id'] = $this->request->post['merchant_id'];
        } elseif (!empty($senangpay_settings)) {
            $data['merchant_id'] = $senangpay_settings['merchant_id'];
        } else {
            $data['merchant_id'] = '';
        }

        if (isset($this->request->post['secret_key'])) {
            $data['secret_key'] = $this->request->post['secret_key'];
        } elseif (!empty($senangpay_settings)) {
            $data['secret_key'] = $senangpay_settings['secret_key'];
        } else {
            $data['secret_key'] = '';
        }

        if (isset($this->request->post['transaction_list'])) {
            $data['transaction_list'] = $this->request->post['transaction_list'];
        } elseif (!empty($senangpay_settings)) {
            $data['transaction_list'] = $senangpay_settings['transaction_list'];
        } else {
            $data['transaction_list'] = [];
        }

        if (isset($this->request->post['transaction_details'])) {
            $data['transaction_details'] = $this->request->post['transaction_details'];
        } elseif (!empty($senangpay_settings)) {
            $data['transaction_details'] = $senangpay_settings['transaction_details'];
        } else {
            $data['transaction_details'] = [];
        }

        if (isset($this->request->post['import_settings'])) {
            $data['import_settings'] = $this->request->post['import_settings'];
        } elseif (!empty($senangpay_settings)) {
            $data['import_settings'] = $senangpay_settings['import_settings'];
        } else {
            $data['import_settings'] = [];
        }

        $this->load->model('sale/customer_group');
        $this->load->model('localisation/order_status');

        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('sale/senangpay_merchant_settings', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/senangpay_import')) {
			$this->error['warning'] = $this->language->get('error_permission');
        }
        
        if (empty($this->request->post['merchant_id'])) {
            $this->error['merchant_id'] = $this->language->get('error_merchant_id');
        }

        if (empty($this->request->post['secret_key'])) {
            $this->error['secret_key'] = $this->language->get('error_secret_key');
        }

        if (empty($this->request->post['import_settings']['customer_group'])) {
            $this->error['import_customer_group'] = $this->language->get('error_import_customer_group');
        }

        if (empty($this->request->post['import_settings']['order_status'])) {
            $this->error['import_order_status'] = $this->language->get('error_import_order_status');
        }

        if (empty($this->request->post['import_settings']['order_status_with_courier'])) {
            $this->error['order_status_with_courier'] = $this->language->get('error_order_status_with_courier');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateImport() {
        if (!$this->user->hasPermission('modify', 'sale/senangpay_import')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
    }

    protected function validateImportExcelForm() {
		if (!$this->user->hasPermission('modify', 'sale/senangpay_import')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (empty($this->request->post['senangpay_transactions'])) {
            $this->error['warning'] = $this->language->get('error_import_senangpay_transaction');
		} 
		
		if ($this->error && !isset($this->error['warning'])) {
			$this->error['warning'] = $this->language->get('error_warning');
		}

		return !$this->error;
	}

    private function get_settings(){
        $setting_results = [];

        $this->load->model('sale/senangpay_import');

        $settings = $this->model_sale_senangpay_import->get_settings();

        if(!empty($settings)){
            foreach($settings as $setting){
                if($setting['serialized'] == '1'){
                    $setting_results[$setting['setting_key']] = unserialize($setting['value']);
                } else{
                    $setting_results[$setting['setting_key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }

    private function get_transaction($transaction_ref) {
        $merchant_id_row = $this->model_sale_senangpay_import->get_setting_by_key('merchant_id');
        $merchant_id = !empty($merchant_id_row) ? $merchant_id_row['value'] : '';

        $secret_key_row = $this->model_sale_senangpay_import->get_setting_by_key('secret_key');
        $secret_key = !empty($secret_key_row) ? $secret_key_row['value'] : '';

        $transaction_details_row = $this->model_sale_senangpay_import->get_setting_by_key('transaction_details');
        $transaction_details = !empty($transaction_details_row) ? unserialize($transaction_details_row['value']) : '';
        $transaction_details_api = $transaction_details['api'];

        $find_transaction_details_api = [
            '{merchant_id}',
            '{transaction_reference}',
            '{hash}'
        ];

        $hash = md5($merchant_id . $secret_key . $transaction_ref);

        $replace_transaction_details_api = [
            'merchant_id'               => $merchant_id,
            'transaction_reference'     => $transaction_ref,
            'hash'                      => $hash
        ];

        $transaction_details_api = str_replace($find_transaction_details_api, $replace_transaction_details_api, $transaction_details_api);

        return $this->call_api_get($transaction_details_api);
    }

    private function call_api_get($url) {
        $url = htmlspecialchars_decode($url);
        
        $response = file_get_contents($url);

		return json_decode($response, true);
    }
}
?>