<?php

class ControllerSalePurchaseRequest extends Controller {

    private $error = array();
    private $status_arr = [5, 2, 7, 1];

    public function index() {
        $this->load->language('sale/purchase_request');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_request');

        $this->getList();
    }

    public function add() {

        $this->load->language('catalog/manufacturer');
        $this->load->language('sale/purchase_request');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_request');
        unset($this->session->data['cookie']);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_sale_purchase_request->addPurchaseRequest($this->request->post, $this->cart);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function edit() {

        $this->load->language('sale/purchase_request');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_request');

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

        if ($this->model_sale_purchase_request->purchaseRequestExistsById($purchase_request_id)) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
                $this->model_sale_purchase_request->editPurchaseRequest($this->request->get['purchase_request_id'], $this->request->post, $this->cart);

                $this->session->data['success'] = $this->language->get('text_success');

                $this->cart->clear();

                $url = '';

                if ((isset($this->request->get['filter_transaction_start']))) {
                    $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
                }

                if ((isset($this->request->get['filter_transaction_end']))) {
                    $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
                }

                if (isset($this->request->get['filter_order_status'])) {
                    $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
                }

                if (isset($this->request->get['sort'])) {
                    $url .= '&sort=' . $this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order=' . $this->request->get['order'];
                }

                if (isset($this->request->get['page'])) {
                    $url .= '&page=' . $this->request->get['page'];
                }

                $this->response->redirect($this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true));
            }

            $this->getForm();
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function info() {
        $this->load->language('sale/purchase_request');

        $this->document->setTitle($this->language->get('heading_title'));

        $data['user_token'] = $this->session->data['user_token'];

        $this->load->model('sale/purchase_request');

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

        $data['purchase_request_id'] = $this->request->get['purchase_request_id'];

        if ($this->model_sale_purchase_request->purchaseRequestExistsById($purchase_request_id)) {

            if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validatePermissionOnly()) {

                $action = isset($this->request->post['action']) ? $this->request->post['action'] : false;

                if ($action && $action == 'update_status') {
                    $this->model_sale_purchase_request->editPurchaseRequestStatus($purchase_request_id, $this->request->post);
                    $this->session->data['success'] = $this->language->get('text_success');

                    $url = '';

                    if ((isset($this->request->get['filter_transaction_start']))) {
                        $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
                    }

                    if ((isset($this->request->get['filter_transaction_end']))) {
                        $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
                    }

                    if (isset($this->request->get['filter_order_status'])) {
                        $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
                    }

                    if (isset($this->request->get['sort'])) {
                        $url .= '&sort=' . $this->request->get['sort'];
                    }

                    if (isset($this->request->get['order'])) {
                        $url .= '&order=' . $this->request->get['order'];
                    }

                    if (isset($this->request->get['page'])) {
                        $url .= '&page=' . $this->request->get['page'];
                    }

                    $this->response->redirect($this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true));
                } else if ($action && $action == 'revise_supplier') {
                    $this->model_sale_purchase_request->purchaseRequestSupplierRevise($purchase_request_id, $this->request->post);

                    $url = '';

                    if ((isset($this->request->get['filter_transaction_start']))) {
                        $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
                    }

                    if ((isset($this->request->get['filter_transaction_end']))) {
                        $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
                    }

                    if (isset($this->request->get['filter_order_status'])) {
                        $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
                    }

                    if (isset($this->request->get['sort'])) {
                        $url .= '&sort=' . $this->request->get['sort'];
                    }

                    if (isset($this->request->get['order'])) {
                        $url .= '&order=' . $this->request->get['order'];
                    }

                    if (isset($this->request->get['page'])) {
                        $url .= '&page=' . $this->request->get['page'];
                    }

                    $this->response->redirect($this->url->link('sale/purchase_request/info', 'user_token=' . $this->session->data['user_token'] . $url . '&purchase_request_id=' . $purchase_request_id . '&tab_supplier=tab-supplier-' . $this->request->post['manufacturer_id'], true));
                }
            }

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $data['edit'] = $this->url->link('sale/purchase_request/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_request_id . $url, true);
            $data['cancel'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true);
            $data['action'] = $this->url->link('sale/purchase_request/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_request_id . $url, true);

            $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

            if (isset($this->request->get['purchase_request_id'])) {
                $purchase_request_info = $this->model_sale_purchase_request->getPurchaseRequest($purchase_request_id);
            } else {
                $purchase_request_info = array();
            }

            $label = '';

            switch ($purchase_request_info['order_status_id']) {
                case 1:
                case 2:
                    $label = 'warning';
                    break;
                case 5:
                    $label = 'success';
                    break;
                case 7:
                case 17:
                    $label = 'danger';
                    break;
            }

            $data['purchase_request_info'] = $purchase_request_info;
            $data['purchase_request_info']['label'] = $label;

            if (isset($this->request->post['order_status_id'])) {
                $data['order_status_id'] = $this->request->post['order_status_id'];
            } elseif (isset($this->request->get['purchase_request_id'])) {
                $data['order_status_id'] = $purchase_request_info['order_status_id'];
            }

            $available_order_status = array(2, 5);
            $this->load->model('localisation/order_status');
            $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
            $data['order_statuses'] = array();
            foreach ($order_statuses as $order_status) {
                if (in_array($order_status['order_status_id'], $available_order_status))
                    $data['order_statuses'][] = $order_status;
            }

            if (isset($this->request->get['purchase_request_id'])) {

                $supplier_respond = $this->model_sale_purchase_request->getRespondPurchaseRequestSuppliesInfo($purchase_request_id);

                //currency format
                foreach ($supplier_respond as $manufacturer_id => $supplier) {
                    $label = '';

                    switch ($supplier['status']) {
                        case 1:
                        case 19:
                            $label = 'warning';
                            break;
                        case 5:
                            $label = 'success';
                            break;
                        case 7:
                        case 17:
                            $label = 'danger';
                            break;
                    }

                    $supplier_respond[$manufacturer_id]['label'] = $label;

                    foreach ($supplier_respond[$manufacturer_id]['products'] as $index => $product) {
                        $supplier_respond[$manufacturer_id]['products'][$index]['revise'] = number_format(round($supplier_respond[$manufacturer_id]['products'][$index]['revise'], 4), 2);

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_revise'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['revise'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_price'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['price'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_net_amount'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['net_amount'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_total_net_amount'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['total_net_amount'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_total'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['total'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_tax'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['tax'], $this->config->get('config_currency'));

                        $supplier_respond[$manufacturer_id]['products'][$index]['formatted_total_tax'] = $this->currency->format($supplier_respond[$manufacturer_id]['products'][$index]['total_tax'], $this->config->get('config_currency'));

                        foreach ($supplier_respond[$manufacturer_id]['total'] as $total_index => $total) {
                            $supplier_respond[$manufacturer_id]['total'][$total_index]['text'] = $this->currency->format($total['value'], $this->config->get('config_currency'));
                        }
                    }
                }
            } else {
                $supplier_respond = array();
            }
            $data['supplier_respond'] = $supplier_respond;

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('sale/purchase_request_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function library() {

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->po = new Purchase_order($this->registry);
    }

    public function productRequestCart() {
        $this->load->language('sale/purchase_request');

        $data['text_no_result'] = $this->language->get('text_no_result');

        $data['column_code'] = $this->language->get('column_code');
        $data['column_product'] = $this->language->get('column_product');
        $data['column_quantity'] = $this->language->get('column_quantity');
        $data['column_price'] = $this->language->get('column_price');
        $data['column_total'] = $this->language->get('column_total');
        $data['column_action'] = $this->language->get('column_action');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->po = new Purchase_order($this->registry);
        $data['products'] = $this->po->getProducts();

        $this->response->setOutput($this->load->view('sale/purchase_request_cart', $data));
    }

    public function addProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_order($this->registry);


            $json = array(
                'success' => true,
                'respond' => $this->po->add($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addProductOrderItemByRange() {
        $json = array('success' => false);

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($ranges) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_order($this->registry);
            //$this->po->clear();
            //$this->po->addRange($ranges);

            $json = array(
                'success' => true,
                'respond' => $this->po->addRange($ranges)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addProductOrderItemByPosRange() {
        $json = array('success' => false);

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($ranges) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_order($this->registry);
            //$this->po->clear();
            //$this->po->addRange($ranges);

            $json = array(
                'success' => true,
                'respond' => $this->po->addPosRange($ranges)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function editProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_order($this->registry);


            $json = array(
                'success' => true,
                'respond' => $this->po->edit($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function deleteProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->po->remove($product_id)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function clearProductOrderItem() {
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->po = new Purchase_order($this->registry);
        $this->po->clear();

        $json = array(
            'success' => true
        );

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function purchaseRequestList() {
        $this->load->language('sale/purchase_request');
        $this->load->model('sale/purchase_request');

        $data['manufacturer_id'] = isset($this->request->get['manufacturer_id']) ? $this->request->get['manufacturer_id'] : 0;
        $data['callback'] = isset($this->request->get['callback']) ? $this->request->get['callback'] : 0;

        if (isset($this->request->get['filter_transaction_start'])) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = null;
        }

        if (isset($this->request->get['filter_transaction_end'])) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = null;
        }

        if (isset($this->request->get['manufacturer_id'])) {
            $filter_manufacturer_id = $this->request->get['manufacturer_id'];
        } else {
            $filter_manufacturer_id = null;
        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_transaction_start'])) {
            $url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
        }

        if (isset($this->request->get['filter_transaction_end'])) {
            $url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
        }

        if (isset($this->request->get['manufacturer_id'])) {
            $url .= '&manufacturer_id=' . $this->request->get['manufacturer_id'];
        }
        $data['purchase_requests'] = array();

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_manufacturer_id' => $filter_manufacturer_id,
            'filter_manufacturer_status' => 5,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $purchase_request_total = $this->model_sale_purchase_request->getTotalPurchaseRequest($filter_data);

        $results = $this->model_sale_purchase_request->getPurchaseRequests($filter_data);

        foreach ($results as $result) {
            $data['purchase_requests'][] = array(
                'purchase_request_id' => $result['purchase_request_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'respond' => $result['total_supplier_respond'] . '/' . $result['total_supplier'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        if (!empty($data['purchase_requests'])) {
            foreach ($data['purchase_requests'] as $index => $purchase_requests) {
                $data['purchase_requests'][$index]['select_data'] = htmlspecialchars(json_encode($purchase_requests));
            }
        }

        $data['text_list'] = $this->language->get('text_list');
        $data['text_no_results'] = $this->language->get('text_no_results');
        //$data['text_confirm'] = $this->language->get('text_confirm');

        $data['column_transaction_start'] = $this->language->get('column_transaction_start');
        $data['column_transaction_end'] = $this->language->get('column_transaction_end');
        $data['column_invoice_prefix'] = $this->language->get('column_invoice_prefix');
        $data['column_total_respond'] = $this->language->get('column_total_respond');
        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_action'] = $this->language->get('column_action');

        $data['button_filter'] = $this->language->get('button_filter');

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
       


        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
       

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $purchase_request_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_request/purchaseRequestList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($purchase_request_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($purchase_request_total - $this->config->get('config_limit_admin'))) ? $purchase_request_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $purchase_request_total, ceil($purchase_request_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;
        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['user_token'] = $this->session->data['user_token'];
        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/purchase_request_list', $data));
    }

    public function productRequestTotal() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);

        //total
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;

        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $getProduct = $this->cart->getProducts();
        $data['products'] = $getProduct;

        $this->response->setOutput($this->load->view('sale/purchase_request_cart', $data));
    }

    protected function getList() {

        if ((isset($this->request->get['filter_transaction_start']))) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = NULL;
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = NULL;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = NULL;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['invoice'] = $this->url->link('sale/purchase_request/invoiceA5', 'user_token=' . $this->session->data['user_token'], true);
        $data['invoice_pdf'] = $this->url->link('sale/purchase_request/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['shipping'] = $this->url->link('sale/purchase_request/shipping', 'user_token=' . $this->session->data['user_token'], true);
        $data['receipt'] = $this->url->link('sale/purchase_request/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['insert'] = $this->url->link('sale/purchase_request/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['add'] = $this->url->link('sale/purchase_request/add', 'user_token=' . $this->session->data['user_token'], true);

        $data['orders'] = array();

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_order_status' => $filter_order_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_purchase_request->getTotalPurchaseRequest($filter_data);

        $results = $this->model_sale_purchase_request->getPurchaseRequests($filter_data);

        foreach ($results as $result) {
            $label = '';
            switch ($result['order_status_id']) {
                case 1:
                case 2:
                    $label = 'warning';
                    break;
                case 5:
                    $label = 'success';
                    break;
                case 7:
                    $label = 'danger';
                    break;
            }

            $data['orders'][] = array(
                'purchase_request_id' => $result['purchase_request_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'order_status_id' => $result['order_status_id'],
                'total_respond' => $result['total_supplier_respond'] . '/' . $result['total_supplier'],
                'order_status' => $result['order_status'],
                'purchase_order_exist' => $result['exist_status'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'view' => $this->url->link('sale/purchase_request/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $result['purchase_request_id'] . $url, true),
                'edit' => $this->url->link('sale/purchase_request/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $result['purchase_request_id'] . $url, true),
                'delete' => $this->url->link('sale/purchase_request/delete', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $result['purchase_request_id'] . $url, true),
                'label' => $label,
                'purchase_order' => $this->url->link('sale/purchase_order/add', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $result['purchase_request_id'] . $url, true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';
        
		

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }
        

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
       


        $data['sort_purchase_request_id'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=purchase_request_id' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        $data['sort_order_status'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $url, true);
        $data['sort_total_supplier_respond'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=total_supplier_respond ' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . '&sort=date_modified' . $url, true);
        
        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['filter_order_status'] = $filter_order_status;

        $this->load->model('localisation/order_status');

        foreach ($this->status_arr as $order_status_id) {
            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_status_id);

            if (!empty($order_status_info)) {
                $data['order_statuses'][] = $order_status_info;
            }
        }

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_request_list', $data));
    }

    public function getForm() {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['purchase_request_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];
        $data['store_id'] = $this->session->data['store_id'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (isset($this->request->get['purchase_request_id'])) {
            $data['action'] = $this->url->link('sale/purchase_request/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $this->request->get['purchase_request_id'] . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/purchase_request/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        }

        $data['cancel'] = $this->url->link('sale/purchase_request', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

        $data['purchase_request_id'] = !empty($purchase_request_id) ? $this->request->get['purchase_request_id'] : 0;

        $manufacturer_id = isset($this->request->get['manufacturer_id']) ? $this->request->get['manufacturer_id'] : 0;

        $data['manufacturer_id'] = !empty($manufacturer_id) ? $this->request->get['manufacturer_id'] : 0;

        if (isset($this->request->get['purchase_request_id'])) {
            $purchase_request_info = $this->model_sale_purchase_request->getPurchaseRequest($purchase_request_id);
        } else {
            $purchase_request_info = array();
        }

        if (isset($this->request->get['purchase_request_id'])) {
            $data['invoice_prefix'] = $purchase_request_info['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_request', 'store' => $this->session->data['store_id']));
        }


        if (isset($this->request->post['supplies'])) {
            $data['supplies'] = $this->request->post['supplies'];
        } elseif (isset($this->request->get['purchase_request_id'])) {

            $data['supplies'] = $purchase_request_info['supplies'];
        } else {
            $data['supplies'] = array();
        }

        if (isset($this->request->post['order_status_id'])) {
            $data['order_status_id'] = $this->request->post['order_status_id'];
        } elseif (isset($this->request->get['purchase_request_id'])) {
            $data['order_status_id'] = $purchase_request_info['order_status_id'];
        } else {
            $data['order_status_id'] = 1;
        }

        if (isset($this->request->post['comment'])) {
            $data['comment'] = $this->request->post['comment'];
        } elseif (isset($this->request->get['purchase_request_id'])) {
            $data['comment'] = $purchase_request_info['comment'];
        } else {
            $data['comment'] = '';
        }

        $available_order_status = array();
        if (isset($this->request->get['purchase_request_id'])) {
            if ($purchase_request_info['order_status_id'] == 1) {//is pendding
                $available_order_status = array(1, 2, 7);
            } else {
                $available_order_status = array($purchase_request_info['order_status_id']);
            }
        } else {
            $available_order_status = array(1, 2);
        }
        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $data['order_statuses'] = array();
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $available_order_status))
                $data['order_statuses'][] = $order_status;
        }

        if ($this->request->server['REQUEST_METHOD'] != 'POST') {
            $this->cart->clear();

            if (isset($this->request->get['purchase_request_id'])) {
                $purchase_request_item = $this->model_sale_purchase_request->getPurchaseRequestItemsArray($this->request->get['purchase_request_id']);
                foreach ($purchase_request_item as $product_id => $quantity)
                    $this->cart->add($product_id, $quantity);
            }
        }

        if (!empty($data['order_statuses'])) {
            foreach ($data['order_statuses'] as $index => $order_statuses) {
                $data['order_statuses'][$index]['select_data'] = htmlspecialchars(json_encode($order_statuses));
            }
        }

        $data['purchase_request_item'] = $this->cart->getProducts();
        $data['json_purchase_request_item'] = json_encode($this->cart->getProducts());

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_request_form', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_request')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!($this->cart->totalProduct() > 0)) {
            $this->error['name']['cart'] = $this->language->get('error_empty_cart');
            $this->error['warning'] = $this->language->get('error_empty_cart');
        }

        if (!isset($this->request->post['supplies'])) {
            $this->error['warning'] = $this->language->get('error_empty_supplier');
        } else {
            foreach ($this->request->post['supplies'] as $counter => $supplier) {
                if (empty($supplier['manufacturer_id'])) {
                    $this->error['name']['supplies'][$counter] = $this->language->get('error_invalid_supplier');
                }
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validatePermissionOnly() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_request')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get($value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($this->config->get($result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data, $total, $taxes);
            }

            $sort_order = array();

            foreach ($total_data as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $total_data);
        }
        return $total_data;
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////

    public function invoice() {
        $this->load->language('sale/purchase_request');

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/purchase_request');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_purchase_request->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . ' ' . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . ' ' . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();

                $products = $this->model_sale_purchase_request->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_purchase_request->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_purchase_request->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_purchase_request->getOrderTotals($order_id);

                foreach ($totals as $total) {
                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/purchase_request_invoice', $data));
    }

    public function invoiceA5() {
        $this->load->language('sale/purchase_request');

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/purchase_request');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_purchase_request->getPurchaseRequest($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['store_owner'],
                    'lastname' => '-',
                    'company' => $order_info['store_name'],
                    'address_1' => '-',
                    'address_2' => '-',
                    'city' => '-',
                    'postcode' => '-',
                    'zone' => '-',
                    'zone_code' => '-',
                    'country' => '-'
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                /*
                  if ($order_info['shipping_address_format']) {
                  $format = $order_info['shipping_address_format'];
                  } else {
                  $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                  }


                  $find = array(
                  '{firstname}',
                  '{lastname}',
                  '{company}',
                  '{address_1}',
                  '{address_2}',
                  '{city}',
                  '{postcode}',
                  '{zone}',
                  '{zone_code}',
                  '{country}'
                  );

                  $replace = array(
                  'firstname' => $order_info['shipping_firstname'],
                  'lastname'  => $order_info['shipping_lastname'],
                  'company'   => $order_info['shipping_company'],
                  'address_1' => $order_info['shipping_address_1'],
                  'address_2' => $order_info['shipping_address_2'],
                  'city'      => $order_info['shipping_city'],
                  'postcode'  => $order_info['shipping_postcode'],
                  'zone'      => $order_info['shipping_zone'],
                  'zone_code' => $order_info['shipping_zone_code'],
                  'country'   => $order_info['shipping_country']
                  );

                  $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
                 */
                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_purchase_request->getPurchaseRequestItems($order_id);

                $option_data = array();

                /*
                  foreach ($products as $product) {
                  $option_data = array();

                  $options = $this->model_sale_purchase_request->getOrderOptions($order_id, $product['order_product_id']);

                  foreach ($options as $option) {
                  if ($option['type'] != 'file') {
                  $value = $option['value'];
                  } else {
                  $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                  if ($upload_info) {
                  $value = $upload_info['name'];
                  } else {
                  $value = '';
                  }
                  }

                  $option_data[] = array(
                  'name'  => $option['name'],
                  'value' => $value
                  );
                  }

                  if(!array_key_exists($product['tax_code'], $data['tax'])){
                  $data['tax'][$product['tax_code']] = array(
                  'net_amount' 		=> $this->currency->format($product['net_amount'],$order_info['currency_code'], $order_info['currency_value']),
                  'tax' 				=> $this->currency->format(0,$order_info['currency_code'], $order_info['currency_value']),
                  'value_net_amount' 	=> $product['net_amount'],
                  'value_tax_amount' 	=> 0
                  );
                  } else {
                  $data['tax'][$product['tax_code']]['value_net_amount'] += $product['net_amount'];
                  $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                  $data['tax'][$product['tax_code']]['net_amount'] =  $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'],$order_info['currency_code'], $order_info['currency_value']);
                  $data['tax'][$product['tax_code']]['tax'] =  $this->currency->format(0,$order_info['currency_code'], $order_info['currency_value']);
                  }



                  $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                  $product_data[] = array(
                  'name'     => $product['name'],
                  'model'    => $product['model'],
                  'sympol'   => $product['tax_code'],
                  'option'   => $option_data,
                  'quantity' => $product['quantity'],
                  'price'    => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                  'tax'      => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                  'total'    => $total,
                  );


                  }
                 */

                $total_data = array();

                $totals = $this->model_sale_purchase_request->getPurchaseRequestTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);


                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['store_email'],
                    'telephone' => $order_info['store_telephone'],
                    'shipping_address' => '-',
                    'shipping_method' => '-',
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => '-',
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }


        //PDF INVOICE 

        $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
        $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
        $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
        $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
        $data['is_pdf'] = false;


        if (isset($this->request->get['pdf']) && count($data['orders']) >= 1) {
            $data['is_pdf'] = true;

            require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
            $dompdf = new DOMPDF();
            $dompdf->set_paper($this->config->get('pdf_invoice_page_size'), $this->config->get('pdf_invoice_page_orientation'));
            $dompdf->load_html($this->load->view('sale/order_invoice_a5', $data));
            $dompdf->render();

            // PDF file name
            if (count($data['orders']) > 1) {  // multiple orders printed in same file
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {

                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );

                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));

                if (!$order_info['invoice_no']) {
                    $pdf_file_name = $order_id . '.pdf';
                }
            }
            // PDF file name stop
            // check if autosend is enabled (this means if called from ajax)
            if (isset($this->request->get['pdf_autosend'])) {
                $pdf_file_location = $this->config->get('pdf_invoice_save_location') . $pdf_file_name;

                $pdf_saved = file_put_contents($pdf_file_location, $dompdf->output());

                if ($pdf_saved !== false) {  // PDF was saved on disk
                    $this->sendEmailPDFInvoice($order_id, $pdf_file_location);
                }
            } else {  // print PDF button is clicked
                if ($this->config->get('pdf_invoice_invoice_button') == "browser") {
                    $dompdf->stream($pdf_file_name, array('Attachment' => 0));
                } else {
                    $dompdf->stream($pdf_file_name);
                }
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser" )) {
            $this->response->setOutput($this->load->view('sale/purchase_request_invoice_a5', $data));
        }
    }

    public function invoiceHoald() {
        $this->load->language('sale/purchase_request');

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/purchase_request');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_purchase_request->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_purchase_request->getOrderProducts($order_id);
                $herbales = $this->model_sale_purchase_request->getHoaldHerbals($order_id);
                $services = $this->model_sale_purchase_request->getHoaldServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                        'tax' => $this->currency->format($herbale['d_gst']),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'])
                    );
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_purchase_request->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format($product['net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $product['net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += $product['net_amount'];
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_purchase_request->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_purchase_request->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }



                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);




                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }


        //$data['net_amount'] = 
        //PDF INVOICE 

        $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
        $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
        $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
        $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
        $data['is_pdf'] = false;


        if (isset($this->request->get['pdf']) && count($data['orders']) >= 1) {
            $data['is_pdf'] = true;

            require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
            $dompdf = new DOMPDF();
            $dompdf->set_paper($this->config->get('pdf_invoice_page_size'), $this->config->get('pdf_invoice_page_orientation'));
            $dompdf->load_html($this->load->view('sale/purchase_request_invoice_hoald', $data));
            $dompdf->render();

            // PDF file name
            if (count($data['orders']) > 1) {  // multiple orders printed in same file
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {

                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );

                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));

                if (!$order_info['invoice_no']) {
                    $pdf_file_name = $order_id . '.pdf';
                }
            }
            // PDF file name stop
            // check if autosend is enabled (this means if called from ajax)
            if (isset($this->request->get['pdf_autosend'])) {
                $pdf_file_location = $this->config->get('pdf_invoice_save_location') . $pdf_file_name;

                $pdf_saved = file_put_contents($pdf_file_location, $dompdf->output());

                if ($pdf_saved !== false) {  // PDF was saved on disk
                    $this->sendEmailPDFInvoice($order_id, $pdf_file_location);
                }
            } else {  // print PDF button is clicked
                if ($this->config->get('pdf_invoice_invoice_button') == "browser") {
                    $dompdf->stream($pdf_file_name, array('Attachment' => 0));
                } else {
                    $dompdf->stream($pdf_file_name);
                }
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser" )) {
            $this->response->setOutput($this->load->view('sale/purchase_request_invoice_hoald', $data));
        }
    }

    public function invoiceReceipt() {
        $this->load->language('sale/purchase_request');

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/purchase_request');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $data['print_time'] = date("Y-m-d H:i:s");


        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_purchase_request->getPurchaseRequest($order_id);

            $data['staff_name'] = $order_info['store_owner'];

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $data['whit_tax'] = 0;
                $data['product_tax'] = 0;
                $data['non_tax'] = 0;
                $data['product_non'] = 0;

                $products = $this->model_sale_purchase_request->getPurchaseRequestItems($order_id);

                $option_data = array();

                foreach ($products as $product) {
                    $option_data = array();

                    /*
                      $options = $this->model_sale_purchase_request->getOrderOptions($order_id, $product['order_product_id']);

                      foreach ($options as $option) {
                      if ($option['type'] != 'file') {
                      $value = $option['value'];
                      } else {
                      $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                      if ($upload_info) {
                      $value = $upload_info['name'];
                      } else {
                      $value = '';
                      }
                      }

                      $option_data[] = array(
                      'name'  => $option['name'],
                      'value' => $value
                      );
                      }
                     */

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format($product['net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $product['net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += $product['net_amount'];
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => $product['quantity'],
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $total,
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_purchase_request->getPurchaseRequestTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {

                        $shipping += $total['value'];

                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['currency'] = $this->currency->getSymbolLeft();

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'telephone' => $order_info['store_telephone'],
                    'product' => $product_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        //PDF INVOICE 

        $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
        $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
        $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
        $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
        $data['is_pdf'] = false;


        if (isset($this->request->get['pdf']) && count($data['orders']) >= 1) {
            $data['is_pdf'] = true;

            require_once(DIR_SYSTEM . 'library/dompdf/dompdf_config.inc.php');
            $dompdf = new DOMPDF();
            $paper_size = array(0, 0, 238, 500);
            $dompdf->set_paper($paper_size, 'portrait');
            $dompdf->load_html($this->load->view('sale/purchase_request_receipt', $data));
            $dompdf->render();

            // PDF file name
            if (count($data['orders']) > 1) {  // multiple orders printed in same file
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {

                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );

                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));

                if (!$order_info['invoice_no']) {
                    $pdf_file_name = $order_id . '.pdf';
                }
            }



            // PDF file name stop
            // check if autosend is enabled (this means if called from ajax)

            if (isset($this->request->get['pdf_autosend'])) {
                $pdf_file_location = $this->config->get('pdf_invoice_save_location') . $pdf_file_name;

                $pdf_saved = file_put_contents($pdf_file_location, $dompdf->output());

                if ($pdf_saved !== false) {  // PDF was saved on disk
                    $this->sendEmailPDFInvoice($order_id, $pdf_file_location);
                }
            } else {  // print PDF button is clicked
                if ($this->config->get('pdf_invoice_invoice_button') == "browser") {
                    $dompdf->stream($pdf_file_name, array('Attachment' => 0));
                } else {
                    $dompdf->stream($pdf_file_name);
                }
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser" )) {
            $this->response->setOutput($this->load->view('sale/purchase_request_receipt', $data));
        }
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_transaction'])) {
            $this->load->model('sale/purchase_request');

            $filter_transaction = isset($this->request->get['filter_transaction']) ? $this->request->get['filter_transaction'] : '';

            $filter_manufacturer_id = isset($this->request->get['filter_manufacturer_id']) ? $this->request->get['filter_manufacturer_id'] : '';

            $filter_data = array(
                'filter_transaction' => $filter_transaction,
                'filter_manufacturer_id' => $filter_manufacturer_id,
                'filter_manufacturer_status' => 5,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_sale_purchase_request->getPurchaseRequests($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'purchase_request_id' => $result['purchase_request_id'],
                    'manufacturer_id' => $result['manufacturer_id'],
                    'invoice_prefix' => $result['invoice_prefix']
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['invoice_prefix'];
        }

        array_multisort($sort_order, SORT_DESC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}
