<?php

class ControllerSalePurchaseQuotation extends Controller {

    private $error = array();
    private $order_status_arr = [7, 5, 1, 19];

    public function index() {
        $this->load->language('sale/purchase_quotation');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_quotation');
        $this->load->model('localisation/order_status');

        $this->getList();
    }

    public function edit() {
        $this->load->language('sale/purchase_quotation');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_quotation');
        $this->load->model('sale/purchase_request');
        $this->load->model('localisation/order_status');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_Order($this->registry);

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {

            //total
            $total_data = array();
            $total_data = $this->totalData();

            $this->model_sale_purchase_quotation->editPurchaseQuotation($purchase_request_id, $this->request->post, $this->cart, $total_data);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_manufacturer_status'])) {
                $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function view() {
        $this->load->language('sale/purchase_quotation');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_quotation');
        $this->load->model('sale/purchase_request');
        $this->load->model('localisation/order_status');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_Order($this->registry);

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('sale/purchase_quotation/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_request_id . $url, true);
        $data['cancel'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $label = '';

        if (isset($this->request->get['purchase_request_id'])) {
            $purchase_request_info = $this->model_sale_purchase_quotation->getPurchaseQuotation($purchase_request_id);
        } else {
            $purchase_request_info = array();
        }

        switch ($purchase_request_info['order_status_id']) {
            case 1:
            case 2:
                $label = 'warning';
                break;
            case 5:
                $label = 'success';
                break;
            case 7:
                $label = 'danger';
                break;
        }

        $data['purchase_request_info'] = $purchase_request_info;
        $data['purchase_request_info']['label'] = $label;

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (isset($this->request->get['purchase_request_id'])) {
            $data['status'] = $purchase_request_info['manufacturer_status_id'];
        } else {
            $data['status'] = 1;
        }

        if ($this->request->server['REQUEST_METHOD'] != 'POST') {
            $this->cart->clear();

            if (isset($this->request->get['purchase_request_id'])) {
                $purchase_request_item = $this->model_sale_purchase_quotation->getPurchaseRequestItemsArray($this->request->get['purchase_request_id']);
                foreach ($purchase_request_item as $product_id => $product)
                    $this->cart->add($product_id, $product['quantity'], $this->currency->format($product['price'], $this->config->get('config_currency'), '', '', false));
            }
        }

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $data['purchase_request_info'] = array(
            'invoice_prefix' => $purchase_request_info['invoice_prefix'],
            'manufacturer_status_id' => $purchase_request_info['manufacturer_status_id'],
            'manufacturer_status' => $purchase_request_info['manufacturer_status'],
            'order_status_id' => $purchase_request_info['order_status_id'],
            'order_status' => $purchase_request_info['order_status'],
            'comment' => $purchase_request_info['comment'],
            'date_added' => date($this->language->get('date_format_short'), strtotime($purchase_request_info['date_added'])),
            'label' => $label
        );

        $data['purchase_request_products'] = $this->cart->getProducts();
        $data['json_purchase_request_products'] = json_encode($data['purchase_request_products']);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_quotation_info', $data));
    }

    public function getList() {

        if ((isset($this->request->get['filter_transaction_start']))) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = NULL;
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = NULL;
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $filter_manufacturer_status = $this->request->get['filter_manufacturer_status'];
        } else {
            $filter_manufacturer_status = NULL;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = NULL;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_manufacturer_status' => $filter_manufacturer_status,
            'filter_order_status' => $filter_order_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
        $data['sort_manufacturer_status'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . '&sort=manufacturer_status' . $url, true);
        $data['sort_order_status'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $url, true);


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['purchase_quotations'] = array();

        $purchase_quotations = $this->model_sale_purchase_quotation->getPurchaseQuotations($filter_data);

        foreach ($purchase_quotations as $purchase_quotation) {
            $manufacturer_status_label = '';
            switch ($purchase_quotation['manufacturer_status_id']) {
                case 1:
                case 19:
                    $manufacturer_status_label = 'warning';
                    break;
                case 5:
                    $manufacturer_status_label = 'success';
                    break;
                case 7:
                    $manufacturer_status_label = 'danger';
                    break;
            }

            $order_status_label = '';
            switch ($purchase_quotation['order_status_id']) {
                case 1:
                case 2:
                    $order_status_label = 'warning';
                    break;
                case 5:
                    $order_status_label = 'success';
                    break;
                case 7:
                    $order_status_label = 'danger';
                    break;
            }

            $data['purchase_quotations'][] = array(
                'purchase_request_id' => $purchase_quotation['purchase_request_id'],
                'invoice_prefix' => $purchase_quotation['invoice_prefix'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($purchase_quotation['date_added'])),
                'order_status_id' => $purchase_quotation['order_status_id'],
                'order_status' => $purchase_quotation['order_status'],
                'manufacturer_status_id' => $purchase_quotation['manufacturer_status_id'],
                'manufacturer_status' => $purchase_quotation['manufacturer_status'],
                'edit' => $this->url->link('sale/purchase_quotation/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_quotation['purchase_request_id'] . $url, true),
                'view' => $this->url->link('sale/purchase_quotation/view', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_quotation['purchase_request_id'] . $url, true),
                'manufacturer_status_label' => $manufacturer_status_label,
                'order_status_label' => $order_status_label
            );
        }

        $total_quotation = $this->model_sale_purchase_quotation->getTotalPurchaseQuotation($filter_data);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_quotation;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_quotation) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_quotation - $this->config->get('config_limit_admin'))) ? $total_quotation : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_quotation, ceil($total_quotation / $this->config->get('config_limit_admin')));

        foreach ($this->order_status_arr as $order_status_id) {
            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_status_id);

            if (!empty($order_status_info)) {
                $data['order_statuses'][] = $order_status_info;
            }
        }

        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['filter_manufacturer_status'] = $filter_manufacturer_status;
        $data['filter_order_status'] = $filter_order_status;

        $data['user_token'] = $this->session->data['user_token'];

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_quotation_list', $data));
    }

    public function getForm() {

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : 0;

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_manufacturer_status'])) {
            $url .= '&filter_manufacturer_status=' . $this->request->get['filter_manufacturer_status'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('sale/purchase_quotation/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_request_id=' . $purchase_request_id . $url, true);
        $data['cancel'] = $this->url->link('sale/purchase_quotation', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['purchase_request_id'])) {
            $purchase_request_info = $this->model_sale_purchase_quotation->getPurchaseQuotation($purchase_request_id);
        } else {
            $purchase_request_info = array();
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (isset($this->request->get['purchase_request_id'])) {
            $data['status'] = $purchase_request_info['manufacturer_status_id'];
        } else {
            $data['status'] = 1;
        }

        if ($this->request->server['REQUEST_METHOD'] != 'POST') {
            $this->cart->clear();

            if (isset($this->request->get['purchase_request_id'])) {
                $purchase_request_item = $this->model_sale_purchase_quotation->getPurchaseRequestItemsArray($this->request->get['purchase_request_id']);
                foreach ($purchase_request_item as $product_id => $product)
                    $this->cart->add($product_id, $product['quantity'], number_format(round($product['price'], 4), 4));
            }
        }
        $cartProducts = $this->cart->getProducts();
        foreach ($cartProducts as $product_id => $product) {
            $cartProducts[$product_id]['revice'] = $this->currency->getSymbolLeft($purchase_request_info['currency_code']) . number_format(round($this->model_sale_purchase_quotation->getPurchaseRequestRevice($purchase_request_id, $product_id, $this->model_sale_purchase_quotation->getManufacturerId($this->session->data['user_id'])), 4), 2) . $this->currency->getSymbolRight($purchase_request_info['currency_code']);
        }

        $data['purchase_request_products'] = $cartProducts;
        $data['json_purchase_request_products'] = json_encode($data['purchase_request_products']);

        $data['order_statuses'] = array();

        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();

        $available_order_status = array();

        switch ($purchase_request_info['manufacturer_status_id']) {
            case 1:
                $available_order_status = array(1, 5, 7);
                break;
            case 19:
                $available_order_status = array(5);
                break;
            default:
                $available_order_status = array($purchase_request_info['manufacturer_status_id']);
        }

        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $data['order_statuses'] = array();
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $available_order_status))
                $data['order_statuses'][] = $order_status;
        }

        $data['purchase_request_info'] = array(
            'invoice_prefix' => $purchase_request_info['invoice_prefix'],
            'manufacturer_status_id' => $purchase_request_info['manufacturer_status_id'],
            'manufacturer_status' => $purchase_request_info['manufacturer_status'],
            'order_status_id' => $purchase_request_info['order_status_id'],
            'order_status' => $purchase_request_info['order_status'],
            'comment' => $purchase_request_info['comment'],
            'date_added' => date($this->language->get('date_format_short'), strtotime($purchase_request_info['date_added'])),
        );

        $label = '';

        switch ($purchase_request_info['order_status_id']) {
            case 1:
            case 2:
                $label = 'warning';
                break;
            case 5:
                $label = 'success';
                break;
            case 7:
                $label = 'danger';
                break;
        }

        $data['purchase_request_info'] = $purchase_request_info;
        $data['purchase_request_info']['label'] = $label;

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['purchase_request_id'] = $purchase_request_id;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_quotation_form', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_quotation')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    //ajax
    public function editPurchaseRequestItemPrice() {
        $json = array('success' => false);

        $purchase_request_id = (isset($this->request->post['purchase_request_id'])) ? $this->request->post['purchase_request_id'] : false;
        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $price = (isset($this->request->post['price'])) ? $this->request->post['price'] : false;

        if ($purchase_request_id && $product_id && $price) {
            $this->load->model('sale/purchase_quotation');

            $purchase_request_info = $this->model_sale_purchase_quotation->getPurchaseQuotation($purchase_request_id);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->po = new Purchase_Order($this->registry);

            $respond = $this->po->editPrice($product_id, number_format(round($price, 4), 2));

            foreach ($respond as $product_id => $product) {
                $respond[$product_id]['revice'] = $this->currency->getSymbolLeft($purchase_request_info['currency_code']) . number_format(round($this->model_sale_purchase_quotation->getPurchaseRequestRevice($purchase_request_id, $product_id, $this->model_sale_purchase_quotation->getManufacturerId($this->session->data['user_id'])), 4), 4) . $this->currency->getSymbolRight($purchase_request_info['currency_code']);
            }

            $json = array(
                'success' => true,
                'respond' => $respond
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function purchaseRequestOrderTotal() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_Order($this->registry);

        //total
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();
        $data['total_data'] = $total_data;

        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $getProduct = $this->cart->getProducts();
        $data['products'] = $getProduct;

        $this->response->setOutput($this->load->view('sale/purchase_invoice_cart', $data));
    }

    public function totalData() {
        $this->load->model('pos/extension');
        
        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($result['code'] != 'credit') {
                if ($this->config->get('total_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }
        return $totals;
    }

}

?>