<?php

class ControllerSalePurchaseOrder extends Controller {

    private $error = array();
    private $payment_status_arr = [17, 5, 2];
    private $order_status_arr = [7, 5, 1];

    public function index() {
        $this->load->language('sale/purchase_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_order');

        $this->getList();
    }

    // ajax
    public function selectPurchaseRequest() {
        $json = array('success' => false);

        $manufacturer_id = (isset($this->request->post['manufacturer_id'])) ? $this->request->post['manufacturer_id'] : false;
        $purchase_request_id = (isset($this->request->post['purchase_request_id'])) ? $this->request->post['purchase_request_id'] : false;

        if ($manufacturer_id && $purchase_request_id) {
            $this->load->model('sale/purchase_order');
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);
            $this->cart->clear();

            $products = $this->model_sale_purchase_order->selectPurchaseRequest($manufacturer_id, $purchase_request_id);

            foreach ($products as $product) {
                $this->cart->add($product['product_id'], $product['quantity'], number_format(round($product['price'], 4), 4));
            }

            $json = array(
                'success' => true,
                'test'  => $this->totalData(),
                'respond' => $this->cart->getProducts()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function selectPurchaseRequestByInvoice() {
        $json = array('success' => false);

        $manufacturer_id = (isset($this->request->post['manufacturer_id'])) ? $this->request->post['manufacturer_id'] : false;
        $invoice = (isset($this->request->post['invoice'])) ? $this->request->post['invoice'] : false;

        if ($manufacturer_id && $invoice) {
            $this->load->model('sale/purchase_order');
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);
            $this->cart->clear();

            $purchase_request = $this->model_sale_purchase_order->selectPurchaseRequestByInvoice($manufacturer_id, $invoice);

            foreach ($purchase_request['products'] as $product) {
                $this->cart->add($product['product_id'], $product['quantity'], number_format(round($product['price'], 4), 4));
            }

            $json = array(
                'success' => true,
                'respond' => array(
                    'id' => $purchase_request['purchase_request_id'],
                    'products' => $this->cart->getProducts()
                )
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function productOrderCart() {
        $this->load->language('sale/purchase_order');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);
        $data['products'] = $this->cart->getProducts();

        $this->response->setOutput($this->load->view('sale/purchase_order_cart', $data));
    }

    public function addProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->add($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addProductOrderItemByRange() {
        $json = array('sucess' => false);

        $manufacturer_id = (isset($this->request->post['manufacturer_id'])) ? $this->request->post['manufacturer_id'] : false;
        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($manufacturer_id && $ranges) {
            $this->load->model('sale/purchase_order');
            $products = $this->model_sale_purchase_order->getPurchaseOrderByInvoicePrefix($manufacturer_id, $ranges);

            $this->load->library('tax');
            $this->tax = new Tax($this->registry);
            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            foreach ($products as $product) {
                $this->cart->add($product['product_id'], $product['quantity'], $product['price']);
            }

            $json = array(
                'success' => true,
                'respond' => $this->cart->getProducts()
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function addProductOrderItemByPosRange() {
        $json = array('success' => false);

        $ranges = (isset($this->request->post['ranges'])) ? $this->request->post['ranges'] : array();

        if ($ranges) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->addPosRange($ranges)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function editProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $quantity = (isset($this->request->post['quantity'])) ? $this->request->post['quantity'] : false;

        if ($product_id && $quantity) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->edit($product_id, $quantity)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function editProductPrice() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;
        $price = (isset($this->request->post['price'])) ? $this->request->post['price'] : false;

        if ($product_id && $price) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->editPrice($product_id, number_format(round($price, 4), 4))
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function purchaseOrderList() {
        $this->load->language('sale/purchase_order');
        $this->load->model('sale/purchase_order');

        if (isset($this->request->get['filter_transaction_start'])) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = null;
        }

        if (isset($this->request->get['filter_transaction_end'])) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = null;
        }

        if (isset($this->request->get['filter_manufacturer_id'])) {
            $filter_manufacturer_id = $this->request->get['filter_manufacturer_id'];
        } else {
            $filter_manufacturer_id = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_not_payment_status'])) {
            $filter_not_payment_status = $this->request->get['filter_not_payment_status'];
        } else {
            $filter_not_payment_status = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_transaction_start'])) {
            $url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
        }

        if (isset($this->request->get['filter_transaction_end'])) {
            $url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
        }

        if (isset($this->request->get['filter_manufacturer_id'])) {
            $url .= '&filter_manufacturer_id=' . $this->request->get['filter_manufacturer_id'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_not_payment_status'])) {
            $url .= '&filter_not_payment_status=' . $this->request->get['filter_not_payment_status'];
        }

        $data['purchase_orders'] = array();

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_manufacturer_id' => $filter_manufacturer_id,
            'filter_order_status' => $filter_order_status,
            'filter_not_payment_status' => $filter_not_payment_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $purchase_order_total = $this->model_sale_purchase_order->getTotalPurchaseOrder($filter_data);

        $results = $this->model_sale_purchase_order->getPurchaseOrders($filter_data);

        foreach ($results as $result) {
            $data['purchase_orders'][] = array(
                'purchase_order_id' => $result['purchase_order_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'total' => $this->currency->format($result['total'], $this->config->get('config_currency')),
                'manufacturer_name' => $result['manufacturer_name'],
                'manufacturer_code' => $result['manufacturer_code'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        if (!empty($data['purchase_orders'])) {
            foreach ($data['purchase_orders'] as $index => $purchase_orders) {
                $data['purchase_orders'][$index]['select_data'] = htmlspecialchars(json_encode($purchase_orders));
            }
        }

        $url = '';

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        $data['sort_total'] = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['callback'] = isset($this->request->get['callback']) ? $this->request->get['callback'] : false;
        $data['row'] = isset($this->request->get['row']) ? $this->request->get['row'] : '';

        $pagination = new Pagination();
        $pagination->total = $purchase_order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_order/purchaseOrderList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($purchase_order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($purchase_order_total - $this->config->get('config_limit_admin'))) ? $purchase_order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $purchase_order_total, ceil($purchase_order_total / $this->config->get('config_limit_admin')));

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['filter_manufacturer_id'] = $filter_manufacturer_id;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_not_payment_status'] = $filter_not_payment_status;

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/purchase_order_list', $data));
    }

    public function deleteProductOrderItem() {
        $json = array('success' => false);

        $product_id = (isset($this->request->post['product_id'])) ? $this->request->post['product_id'] : false;

        if ($product_id) {
            $this->load->library('tax');
            $this->tax = new Tax($this->registry);

            $this->load->library('purchase_order');
            $this->cart = new Purchase_order($this->registry);

            $json = array(
                'success' => true,
                'respond' => $this->cart->remove($product_id)
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function clearProductOrderItem() {
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);
        $this->cart->clear();

        $json = array(
            'success' => true
        );

        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function productOrderTotal() {
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);

        //total
        $total_data = array();
        $total = 0;

        $total_data = $this->totalData();

        $data['total_data'] = $total_data;

        $data['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        $getProduct = $this->cart->getProducts();
        $data['products'] = $getProduct;

        $this->response->setOutput($this->load->view('sale/purchase_order_cart', $data));
    }

    public function add() {

        $this->load->language('catalog/manufacturer');
        $this->load->language('sale/purchase_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_order');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);

        unset($this->session->data['cookie']);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            $this->model_sale_purchase_order->addPurchaseOrder($this->request->post, $this->cart);
            $this->cart->clear();

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_manufacturer_id']))) {
                $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('sale/purchase_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_order');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {
            //total
            $total_data = array();
            $total = 0;

            $total_data = $this->totalData();

            $this->model_sale_purchase_order->editPurchaseOrder($this->request->get['purchase_order_id'], $this->request->post, $this->cart, $total_data);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->cart->clear();

            $url = '';

            if ((isset($this->request->get['filter_transaction_start']))) {
                $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
            }

            if ((isset($this->request->get['filter_transaction_end']))) {
                $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function info() {
        $this->load->language('sale/purchase_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_order');

        //purchase receive
        if (isset($this->request->get['filter_transaction_start'])) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = null;
        }

        if (isset($this->request->get['filter_transaction_end'])) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = null;
        }

        if (isset($this->request->get['filter_manufacturer_id'])) {
            $filter_manufacturer_id = $this->request->get['filter_manufacturer_id'];
        } else {
            $filter_manufacturer_id = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        //purchase invoice
        if (isset($this->request->get['filter_invoice_transaction_start'])) {
            $filter_invoice_transaction_start = $this->request->get['filter_invoice_transaction_start'];
        } else {
            $filter_invoice_transaction_start = null;
        }

        if (isset($this->request->get['filter_invoice_transaction_end'])) {
            $filter_invoice_transaction_end = $this->request->get['filter_invoice_transaction_end'];
        } else {
            $filter_invoice_transaction_end = null;
        }

        if (isset($this->request->get['filter_invoice_manufacturer_id'])) {
            $filter_invoice_manufacturer_id = $this->request->get['filter_invoice_manufacturer_id'];
        } else {
            $filter_invoice_manufacturer_id = null;
        }

        if (isset($this->request->get['invoice_sort'])) {
            $invoice_sort = $this->request->get['invoice_sort'];
        } else {
            $invoice_sort = 'invoice_prefix';
        }

        if (isset($this->request->get['invoice_order'])) {
            $invoice_order = $this->request->get['invoice_order'];
        } else {
            $invoice_order = 'DESC';
        }

        if (isset($this->request->get['invoice_page'])) {
            $invoice_page = $this->request->get['invoice_page'];
        } else {
            $invoice_page = 1;
        }

        $purchase_order_id = isset($this->request->get['purchase_order_id']) ? $this->request->get['purchase_order_id'] : 0;

        if ($this->model_sale_purchase_order->purchaseOrderExistById($purchase_order_id)) {
            $url = '';

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $data['edit'] = $this->url->link('sale/purchase_order/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . $url, true);
            $data['cancel'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true);

            if (isset($this->request->get['purchase_order_id'])) {
                $purchase_order_info = $this->model_sale_purchase_order->getPurchaseOrder($purchase_order_id);
            } else {
                $purchase_order_info = array();
            }

            $product_order_products = $this->model_sale_purchase_order->getPurchaseOrderItems($purchase_order_id);

            $got_receive_history = isset($this->request->get['tab_receive_history']) ? true : false;

            $got_invoice_history = isset($this->request->get['tab_invoice_history']) ? true : false;

            $order_status_label = '';
            switch ($purchase_order_info['order_status_id']) {
                case 1:
                case 2;
                    $order_status_label = 'warning';
                    break;
                case 5:
                    $order_status_label = 'success';
                    break;
                case 7:
                    $order_status_label = 'danger';
                    break;
            }

            $payment_status_label = '';
            switch ($purchase_order_info['payment_status_id']) {
                case 2:
                    $payment_status_label = 'warning';
                    break;
                case 5:
                    $payment_status_label = 'success';
                    break;
                case 17:
                    $payment_status_label = 'danger';
                    break;
            }

            $data['purchase_order_info'] = array(
                'invoice_prefix' => $purchase_order_info['invoice_prefix'],
                'order_status_id' => $purchase_order_info['order_status_id'],
                'order_status' => $purchase_order_info['order_status'],
                'payment_status_id' => $purchase_order_info['payment_status_id'],
                'payment_status' => $purchase_order_info['payment_status'],
                'comment' => $purchase_order_info['comment'],
                'manufacturer_name' => $purchase_order_info['manufacturer_name'],
                'manufacturer_code' => $purchase_order_info['manufacturer_code'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($purchase_order_info['date_added'])),
                'product_order_products' => $product_order_products,
                'order_status_label' => $order_status_label,
                'payment_status_label' => $payment_status_label
            );


            $this->load->library('purchase_receive');
            $this->pr = new Purchase_receive($this->registry);

            //import purchase order product
            $this->pr->clear();
            $this->pr->import($purchase_order_id);

            //get all receive product
            $products = $this->model_sale_purchase_order->getReceiveProducts($purchase_order_id);
            foreach ($products as $product) {
                if (!$this->pr->has($product['product_id'])) {
                    $this->pr->add($product['product_id'], 0);
                }
            }

            $receive_products = $this->pr->getProducts();

            //set default receive quantity to 0
            foreach ($receive_products as $product_id => $product) {
                $receive_products[$product_id]['receive_quantity'] = 0;
            }

            //set receive quantity
            foreach ($products as $product) {
                $receive_products[$product['product_id']]['receive_quantity'] = $product['quantity'];
            }

            $data['receive_products'] = array();

            foreach ($receive_products as $product_id => $product) {
                $data['receive_products'][$product_id] = array(
                    'code' => $product['code'],
                    'name' => $product['name'],
                    'purchase_order' => $product['purchase_order'],
                    'receive_quantity' => $product['receive_quantity'],
                    'remain' => $product['remain']
                );
            }

            $url = '';

            //purchase receive
            if (isset($this->request->get['filter_transaction_start'])) {
                $url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
            }

            if (isset($this->request->get['filter_transaction_end'])) {
                $url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
            }

            if (isset($this->request->get['filter_manufacturer_id'])) {
                $url .= '&filter_manufacturer_id=' . $this->request->get['filter_manufacturer_id'];
            }

            //purchase invoice
            if (isset($this->request->get['filter_invoice_transaction_start'])) {
                $url .= '&filter_invoice_transaction_start=' . $this->request->get['filter_invoice_transaction_start'];
            }

            if (isset($this->request->get['filter_invoice_transaction_end'])) {
                $url .= '&filter_invoice_transaction_end=' . $this->request->get['filter_invoice_transaction_end'];
            }

            if (isset($this->request->get['filter_invoice_manufacturer_id'])) {
                $url .= '&filter_invoice_manufacturer_id=' . $this->request->get['filter_invoice_manufacturer_id'];
            }

            $data['receive_histories'] = array();

            $filter_data = array(
                'filter_transaction_start' => $filter_transaction_start,
                'filter_transaction_end' => $filter_transaction_end,
                'filter_manufacturer_id' => $filter_manufacturer_id,
                'sort' => $sort,
                'order' => $order,
                'start' => ($page - 1) * $this->config->get('config_limit_admin'),
                'limit' => $this->config->get('config_limit_admin')
            );

            $receive_history_total = $this->model_sale_purchase_order->getTotalPurchaseReceive($purchase_order_id, $filter_data);

            $receive_histories = $this->model_sale_purchase_order->getAllPurchaseReceive($purchase_order_id, $filter_data);

            foreach ($receive_histories as $history_id => $history) {
                $data['receive_histories'][$history_id] = array(
                    'purchase_receive_id' => $history['purchase_receive_id'],
                    'invoice_prefix' => $history['invoice_prefix'],
                    'date_added' => date($this->language->get('date_format_short'), strtotime($history['date_added'])),
                    'view' => $this->url->link('sale/purchase_receive/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_receive_id=' . $history['purchase_receive_id'], true)
                );
            }

            $url = '';

            if ($order == 'ASC') {
                $url .= '&order=DESC';
            } else {
                $url .= '&order=ASC';
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . '&sort=invoice_prefix' . $url . '&tab_receive_history=true', true);
            $data['sort_date_added'] = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . '&sort=date_added' . $url . '&tab_receive_history=true', true);

            $url = '';

            if ($invoice_order == 'ASC') {
                $url .= '&invoice_order=DESC';
            } else {
                $url .= '&invoice_order=ASC';
            }

            if (isset($this->request->get['invoice_page'])) {
                $url .= '&invoice_page=' . $this->request->get['invoice_page'];
            }

            $data['sort_invoice_invoice_prefix'] = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . '&invoice_sort=invoice_prefix' . $url . '&tab_invoice_history=true', true);
            $data['sort_invoice_date_added'] = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . '&invoice_sort=date_added' . $url . '&tab_invoice_history=true', true);

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            $pagination = new Pagination();
            $pagination->total = $receive_history_total;
            $pagination->page = $page;
            $pagination->limit = $this->config->get('config_limit_admin');
            $pagination->url = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . $url . '&purchase_order_id=' . $purchase_order_id . '&page={page}', true);

            $data['pagination'] = $pagination->render();

            $data['results'] = sprintf($this->language->get('text_pagination'), ($receive_history_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($receive_history_total - $this->config->get('config_limit_admin'))) ? $receive_history_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $receive_history_total, ceil($receive_history_total / $this->config->get('config_limit_admin')));

            $data['invoice_histories'] = array();

            $invoice_filter_data = array(
                'filter_transaction_start' => $filter_invoice_transaction_start,
                'filter_transaction_end' => $filter_invoice_transaction_end,
                'filter_manufacturer_id' => $filter_invoice_manufacturer_id,
                'sort' => $invoice_sort,
                'order' => $invoice_order,
                'start' => ($invoice_page - 1) * $this->config->get('config_limit_admin'),
                'limit' => $this->config->get('config_limit_admin')
            );

            $invoice_histories = $this->model_sale_purchase_order->getAllPurchaseInvoice($purchase_order_id, $invoice_filter_data);

            foreach ($invoice_histories as $invoice) {
                $data['invoice_histories'][] = array(
                    'purchase_invoice_id' => $invoice['purchase_invoice_id'],
                    'invoice_prefix' => $invoice['invoice_prefix'],
                    'date_added' => date($this->language->get('date_format_short'), strtotime($invoice['date_added'])),
                    'view' => $this->url->link('sale/purchase_invoice/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_invoice_id=' . $invoice['purchase_invoice_id'], true)
                );
            }

            $invoice_history_total = $this->model_sale_purchase_order->getTotalPurchaseInvoice($purchase_order_id, $filter_data);

            $url = '';

            if (isset($this->request->get['invoice_sort'])) {
                $url .= '&invoice_sort=' . $this->request->get['invoice_sort'];
            }

            if (isset($this->request->get['invoice_order'])) {
                $url .= '&invoice_order=' . $this->request->get['invoice_order'];
            }

            $invoice_pagination = new Pagination();
            $invoice_pagination->total = $invoice_history_total;
            $invoice_pagination->page = $invoice_page;
            $invoice_pagination->limit = $this->config->get('config_limit_admin');
            $invoice_pagination->url = $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . $url . '&purchase_order_id=' . $purchase_order_id . '&page={page}', true);

            $data['invoice_pagination'] = $invoice_pagination->render();

            $data['invoice_results'] = sprintf($this->language->get('text_pagination'), ($invoice_history_total) ? (($invoice_page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($invoice_page - 1) * $this->config->get('config_limit_admin')) > ($receive_history_total - $this->config->get('config_limit_admin'))) ? $invoice_history_total : ((($invoice_page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $invoice_history_total, ceil($invoice_history_total / $this->config->get('config_limit_admin')));

            //purchase receive
            $data['sort'] = $sort;
            $data['order'] = $order;

            $data['filter_transaction_start'] = $filter_transaction_start;
            $data['filter_transaction_end'] = $filter_transaction_end;
            $data['filter_manufacturer_id'] = $filter_manufacturer_id;
            $data['filter_invoice_transaction_start'] = $filter_invoice_transaction_start;
            $data['filter_invoice_transaction_end'] = $filter_invoice_transaction_end;
            $data['filter_invoice_manufacturer_id'] = $filter_invoice_manufacturer_id;

            //purchase invoice
            $data['invoice_sort'] = $invoice_sort;
            $data['invoice_order'] = $invoice_order;

            $data['purchase_order_id'] = $purchase_order_id;

            $data['user_token'] = $this->session->data['user_token'];

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('sale/purchase_order_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    public function delete() {
        $this->load->language('sale/purchase_order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/purchase_order');

        unset($this->session->data['cookie']);

        if (isset($this->request->get['order_id']) && $this->validate()) {
            // API
            $this->load->model('user/api');

            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

            if ($api_info) {
                $curl = curl_init();

                // Set SSL if required
                if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                    curl_setopt($curl, CURLOPT_PORT, 443);
                }

                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));

                $json = curl_exec($curl);

                if (!$json) {
                    $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                } else {
                    $response = json_decode($json, true);

                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }

                    curl_close($curl);
                }
            }
        }

        if (isset($this->session->data['cookie'])) {
            $curl = curl_init();

            // Set SSL if required
            if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                curl_setopt($curl, CURLOPT_PORT, 443);
            }

            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/order/delete&order_id=' . $this->request->get['order_id']);
            curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

            $json = curl_exec($curl);

            if (!$json) {
                $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
            } else {
                $response = json_decode($json, true);

                curl_close($curl);

                if (isset($response['error'])) {
                    $this->error['warning'] = $response['error'];
                }
            }
        }

        if (isset($response['error'])) {
            $this->error['warning'] = $response['error'];
        }

        if (isset($response['success'])) {
            $this->session->data['success'] = $response['success'];

            $url = '';

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList() {
        if ((isset($this->request->get['filter_transaction_start']))) {
            $filter_transaction_start = $this->request->get['filter_transaction_start'];
        } else {
            $filter_transaction_start = NULL;
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $filter_transaction_end = $this->request->get['filter_transaction_end'];
        } else {
            $filter_transaction_end = NULL;
        }

        if ((isset($this->request->get['filter_manufacturer_id']))) {
            $filter_manufacturer_id = $this->request->get['filter_manufacturer_id'];
        } else {
            $filter_manufacturer_id = NULL;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = NULL;
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $filter_payment_status = $this->request->get['filter_payment_status'];
        } else {
            $filter_payment_status = NULL;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'invoice_prefix';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_manufacturer_id']))) {
            $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['invoice'] = $this->url->link('sale/purchase_order/invoiceA5', 'user_token=' . $this->session->data['user_token'], true);
        $data['invoice_pdf'] = $this->url->link('sale/purchase_order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['shipping'] = $this->url->link('sale/purchase_order/shipping', 'user_token=' . $this->session->data['user_token'], true);
        $data['receipt'] = $this->url->link('sale/purchase_order/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['insert'] = $this->url->link('sale/purchase_order/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['add'] = $this->url->link('sale/purchase_order/add', 'user_token=' . $this->session->data['user_token'], true);

        $data['orders'] = array();

        $filter_data = array(
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end' => $filter_transaction_end,
            'filter_manufacturer_id' => $filter_manufacturer_id,
            'filter_order_status' => $filter_order_status,
            'filter_payment_status' => $filter_payment_status,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_purchase_order->getTotalPurchaseOrder($filter_data);

        $results = $this->model_sale_purchase_order->getPurchaseOrders($filter_data);

        foreach ($results as $result) {

            $order_status_label = '';
            switch ($result['order_status_id']) {
                case 1:
                case 2:
                    $order_status_label = 'warning';
                    break;
                case 5:
                    $order_status_label = 'success';
                    break;
                case 7:
                    $order_status_label = 'danger';
                    break;
            }

            $payment_status_label = '';
            switch ($result['payment_status_id']) {
                case 2:
                    $payment_status_label = 'warning';
                    break;
                case 5:
                    $payment_status_label = 'success';
                    break;
                case 17:
                    $payment_status_label = 'danger';
                    break;
            }

            $data['orders'][] = array(
                'purchase_order_id' => $result['purchase_order_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'order_status_id' => $result['order_status_id'],
                'order_status' => $result['order_status'],
                'payment_status_id' => $result['payment_status_id'],
                'payment_status' => $result['payment_status'],
                'total' => $this->currency->format($result['total'], $this->config->get('config_currency')),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'view' => $this->url->link('sale/purchase_order/info', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $result['purchase_order_id'] . $url, true),
                'edit' => $this->url->link('sale/purchase_order/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $result['purchase_order_id'] . $url, true),
                'delete' => $this->url->link('sale/purchase_order/delete', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $result['purchase_order_id'] . $url, true),
                'order_status_label' => $order_status_label,
                'payment_status_label' => $payment_status_label,
                'purchase_receive' => $this->url->link('sale/purchase_receive/add', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $result['purchase_order_id'] . $url, true),
                'purchase_receive_exist' => $result['purchase_receive_id'],
                'purchase_invoice_exist' => $result['purchase_invoice_id'],
                'purchase_invoice' => $this->url->link('sale/purchase_invoice/add', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $result['purchase_order_id'] . $url, true),
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_manufacturer_id']))) {
            $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_purchase_order_id'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=purchase_order_id' . $url, true);
        $data['sort_invoice_prefix'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $url, true);
        $data['sort_order_status'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $url, true);
        $data['sort_payment_status'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . '&sort=date_modified' . $url, true);

        $url = '';

        if ((isset($this->request->get['filter_transaction_start']))) {
            $url .= '&filter_transaction_start=' . urlencode(html_entity_decode($this->request->get['filter_transaction_start'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_transaction_end']))) {
            $url .= '&filter_transaction_end=' . urlencode(html_entity_decode($this->request->get['filter_transaction_end'], ENT_QUOTES, 'UTF-8'));
        }

        if ((isset($this->request->get['filter_manufacturer_id']))) {
            $url .= '&filter_manufacturer_id=' . urlencode(html_entity_decode($this->request->get['filter_manufacturer_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_payment_status'])) {
            $url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_transaction_start'] = $filter_transaction_start;
        $data['filter_transaction_end'] = $filter_transaction_end;
        $data['filter_manufacturer_id'] = $filter_manufacturer_id;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_payment_status'] = $filter_payment_status;

        $this->load->model('localisation/order_status');

        foreach ($this->payment_status_arr as $payment_status_id) {
            $payment_status_info = $this->model_localisation_order_status->getOrderStatus($payment_status_id);

            if (!empty($payment_status_info)) {
                $data['payment_statuses'][] = $payment_status_info;
            }
        }

        foreach ($this->order_status_arr as $order_status_id) {
            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_status_id);

            if (!empty($order_status_info)) {
                $data['order_statuses'][] = $order_status_info;
            }
        }

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_order_list', $data));
    }

    public function getForm() {
        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_form'] = !isset($this->request->get['purchase_order_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        $data['user_token'] = $this->session->data['user_token'];
        $data['store_id'] = $this->session->data['store_id'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;


        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $purchase_order_id = isset($this->request->get['purchase_order_id']) ? $this->request->get['purchase_order_id'] : 0;

        $data['purchase_order_id'] = !empty($purchase_order_id) ? $this->request->get['purchase_order_id'] : 0;

        $purchase_request_id = isset($this->request->get['purchase_request_id']) ? $this->request->get['purchase_request_id'] : false;

        $data['purchase_request_id'] = $purchase_request_id ? $this->request->get['purchase_request_id'] : 0;
        
        if (isset($this->request->get['purchase_request_id'])) {
            $purchase_request_info = $this->model_sale_purchase_order->getPurchaseOrderbyrequest($purchase_request_id);
        } else {
            $purchase_request_info = array();
        }

        $data['purchase_request_info'] = [];

        if (!empty($purchase_request_info)) {
            $data['purchase_request_info'] = [
                'purchase_request_invoice' => $purchase_request_info['purchase_request_prefix'],
                'purchase_request_id'      => $purchase_request_info['purchase_request_id'],
                'supplier_id'              => $purchase_request_info['manufacturer_id'],
                'supplier_name'            => $purchase_request_info['manufacturer_name'],
                'supplier_code'            => $purchase_request_info['manufacturer_code']
            ];           
        }

        $data['cancel'] = $this->url->link('sale/purchase_order', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['purchase_order_id'])) {
            $data['editmode'] = 1;
            $data['action'] = $this->url->link('sale/purchase_order/edit', 'user_token=' . $this->session->data['user_token'] . '&purchase_order_id=' . $purchase_order_id . $url, true);
        } else {
            $data['action'] = $this->url->link('sale/purchase_order/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        }

        if (isset($this->request->get['purchase_order_id'])) {
            $order_info = $this->model_sale_purchase_order->getPurchaseOrder($purchase_order_id);
        } else {
            $order_info = array();
        }

        if (!empty($order_info)) {
            $data['invoice_prefix'] = $order_info['invoice_prefix'];
            /* echo '<pre>';
              print_r($order_info);
              echo '</pre>'; */
        } else {
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/purchase_order', 'store' => $this->session->data['store_id']));
        }

        if (isset($this->request->post['supplier_name'])) {
            $data['supplier_name'] = $this->request->post['supplier_name'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['supplier_name'] = $order_info['manufacturer_name'];
        } else {
            $data['supplier_name'] = '';
        }

        if (isset($this->request->post['supplier_code'])) {
            $data['supplier_code'] = $this->request->post['supplier_code'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['supplier_code'] = $order_info['manufacturer_code'];
        } else {
            $data['supplier_code'] = '';
        }

        if (isset($this->request->post['supplier_id'])) {
            $data['supplier_id'] = $this->request->post['supplier_id'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['supplier_id'] = $order_info['manufacturer_id'];
        } else {
            $data['supplier_id'] = '';
        }

        if (isset($this->request->post['purchase_request_id'])) {
            $data['purchase_request_id'] = $this->request->post['purchase_request_id'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['purchase_request_id'] = $order_info['purchase_request_id'];
        } else {
            $data['purchase_request_id'] = '';
        }

        if (isset($this->request->post['purchase_request_invoice'])) {
            $data['purchase_request_invoice'] = $this->request->post['purchase_request_invoice'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['purchase_request_invoice'] = $order_info['purchase_request_invoice'];
        } else {
            $data['purchase_request_invoice'] = '';
        }


        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('purchase_order');
        $this->cart = new Purchase_order($this->registry);
        if ($this->request->server['REQUEST_METHOD'] != 'POST') {

            $this->cart->clear();

            $purchase_order_item = $this->model_sale_purchase_order->getPurchaseOrderItemsArray($purchase_order_id);

            foreach ($purchase_order_item as $product_id => $product)
                $this->cart->add($product_id, $product['quantity'], $product['price']);
        }
        $data['purchase_order_item'] = $this->cart->getProducts();

        //$data['order_status_id'] = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : $order_info['order_status_id'];

        if (isset($this->request->post['order_status_id'])) {
            $data['order_status_id'] = $this->request->post['order_status_id'];
        } elseif (isset($this->request->get['purchase_order_id'])) {
            $data['order_status_id'] = $order_info['order_status_id'];
        } else {
            $data['order_status_id'] = 1;
        }

        // Stores
        $this->load->model('setting/store');

        $data['stores'] = $this->model_setting_store->getStores();

        // Customer Groups
        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        // Custom Fields
        $this->load->model('sale/custom_field');

        $data['custom_fields'] = array();

        $custom_fields = $this->model_sale_custom_field->getCustomFields();

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_sale_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location']
            );
        }

        $available_order_status = array();
        if (isset($this->request->get['purchase_order_id'])) {
            if ($order_info['order_status_id'] == 1) {//is pendding
                $available_order_status = array(1, 5, 7);
            } else {
                $available_order_status = array($order_info['order_status_id']);
            }
        } else {
            $available_order_status = array(1, 5, 7);
        }

        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $data['order_statuses'] = array();
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $available_order_status))
                $data['order_statuses'][] = $order_status;
        }

        if (!empty($data['order_statuses'])) {
            foreach ($data['order_statuses'] as $index => $order_statuses) {
                $data['order_statuses'][$index]['select_data'] = htmlspecialchars(json_encode($order_statuses));
            }
        }

        $data['json_purchase_order_item'] = json_encode($this->cart->getProducts());

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        $data['voucher_min'] = $this->config->get('config_voucher_min');

        $this->load->model('sale/voucher_theme');

        $data['voucher_themes'] = $this->model_sale_voucher_theme->getVoucherThemes();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/purchase_order_form', $data));
    }

    protected function validateManufacturerForm() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $this->load->model('catalog/manufacturer');
        if (isset($this->request->get['manufacturer_id'])) {
            $manufacture_info = $this->model_catalog_manufacturer->getManufacturer($this->request->get['manufacturer_id']);
        }

        $name = $this->request->post['name'];
        if ((utf8_strlen($name) < 1) || (utf8_strlen($name) > 64)) {
            $this->error['name']['name'] = $this->language->get('error_name');
        } else {
            $is_current_name = false;

            if (isset($this->request->get['manufacturer_id'])) {
                $current_name = $manufacture_info['name'];

                $is_current_name = (strtolower($name) == strtolower($current_name)) ? true : false;
            }

            if ($this->model_catalog_manufacturer->manufacturerNameExists($name) && !$is_current_name) {
                $this->error['name']['name'] = $this->language->get('error_name_exists');
            }
        }

        $code = $this->request->post['code'];
        if ((utf8_strlen($code) < 1) || (utf8_strlen($code) > 64)) {
            $this->error['name']['code'] = $this->language->get('error_code');
        } else {
            $is_current_code = false;

            if (isset($this->request->get['manufacturer_id'])) {
                $current_code = $manufacture_info['code'];

                $is_current_code = (strtolower($code) == strtolower($current_code)) ? true : false;
            }

            if ($this->model_catalog_manufacturer->manufacturerCodeExists($code) && !$is_current_code) {
                $this->error['name']['code'] = $this->language->get('error_code_exists');
            }
        }


        if (empty($this->request->post['ic'])) {
            $this->error['name']['ic'] = $this->language->get('ic');
        }

        if (empty($this->request->post['periodfrom'])) {
            $this->error['name']['periodfrom'] = $this->language->get('error_periodfrom');
        }

        if (empty($this->request->post['periodto'])) {
            $this->error['name']['periodto'] = $this->language->get('error_periodto');
        }


        /*
          $opendate = trim($this->request->post['opendate']);
          if ((utf8_strlen($opendate) < 1)){
          $this->error['name']['opendate'] = $this->language->get('error_opendate');
          } */

        /*
          if ((utf8_strlen($this->request->post['personincharge']) < 1)) {
          $this->error['name']['personincharge'] = $this->language->get('error_personincharge');
          } */

        if ((utf8_strlen($this->request->post['address_1']) < 1)) {
            $this->error['name']['address_1'] = $this->language->get('error_address_1');
        }

        if ((utf8_strlen($this->request->post['city']) < 1)) {
            $this->error['name']['city'] = $this->language->get('error_city');
        }

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

        if ($country_info && $country_info['postcode_required'] && (utf8_strlen($this->request->post['postcode']) < 2 || utf8_strlen($$this->request->post['postcode']) > 10)) {
            $this->error['name']['postcode'] = $this->language->get('error_postcode');
        }

        if ($this->request->post['country_id'] == '') {
            $this->error['name']['country_id'] = $this->language->get('error_country');
        }

        if (!isset($this->request->post['zone_id']) || $this->request->post['zone_id'] == '') {
            $this->error['name']['zone_id'] = $this->language->get('error_zone');
        }

        if ((utf8_strlen($this->request->post['telephone1']) < 1)) {
            $this->error['name']['telephone1'] = $this->language->get('error_telephone1');
        }

        $email = trim($this->request->post['email']);

        if ((utf8_strlen($email) > 0)) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $this->error['name']['email'] = $this->language->get('error_email_format');
            } else {
                $is_current_mail = false;

                if (isset($this->request->get['manufacturer_id'])) {


                    $current_email = $manufacture_info['email'];

                    $is_current_mail = (strtolower($email) == strtolower($current_email)) ? true : false;
                }

                if ($this->model_catalog_manufacturer->manufacturerEmailExists($email) && !$is_current_mail) {
                    $this->error['name']['email'] = $this->language->get('error_email_exists');
                }

                //getManufacturer
            }
        }

        if (!isset($this->request->get['manufacturer_id'])) {
            if ((utf8_strlen($this->request->post['password']) < 4) || (utf8_strlen($this->request->post['password']) > 20)) {
                $this->error['name']['password'] = $this->language->get('error_password');
            }

            if ($this->request->post['password'] != $this->request->post['confirm']) {
                $this->error['name']['confirm'] = $this->language->get('error_confirm');
            }
        }


        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'sale/purchase_order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!($this->cart->totalProduct() > 0)) {

            $this->error['name']['empty_cart'] = $this->language->get('error_empty_cart');
            $this->error['warning'] = $this->language->get('error_empty_cart');
        }

        if (!$this->request->post['manufacturer_id'] > 0) {
            $this->error['name']['supplier_name'] = $this->language->get('error_supplier_name');
        }

        if (!$this->request->post['purchase_request_id'] > 0) {
            $this->error['name']['purchase_request_invoice'] = $this->language->get('error_purchase_request_invoice');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
        }

        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {
            if ($this->config->get('total_' . $result['code'] . '_status')) {
                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            }

            $sort_order = array();

            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        return $totals;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_transaction'])) {
            $this->load->model('sale/purchase_order');

            $filter_manufacturer_id = isset($this->request->get['filter_manufacturer_id']) ? $this->request->get['filter_manufacturer_id'] : '';

            $filter_transaction = isset($this->request->get['filter_transaction']) ? $this->request->get['filter_transaction'] : '';

            $filter_not_payment_status = isset($this->request->get['filter_not_payment_status']) ? $this->request->get['filter_not_payment_status'] : '';

            $filter_data = array(
                'filter_transaction' => $filter_transaction,
                'filter_manufacturer_id' => $filter_manufacturer_id,
                'filter_order_status' => 5,
                'filter_payment_status' => 17,
                'filter_not_payment_status' => $filter_not_payment_status,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_sale_purchase_order->getPurchaseOrders($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'purchase_order_id' => $result['purchase_order_id'],
                    'invoice_prefix' => $result['invoice_prefix']
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['purchase_order_id'];
        }

        array_multisort($sort_order, SORT_DESC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}
