<?php

class ControllerSalePrint extends Controller {
    public function index() {
        $this->load->language('sale/print');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('herbal/payment');
        $this->load->model('sale/order');
        $this->load->model('setting/setting');
        $this->load->model('sale/print');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], 'SSL')
        );

        $this->document->addStyle('view/stylesheet/payment.css?v=' . time());

        $data['sale'] = $this->config->get('config_order_print_setting');


        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['select_templete'] = $this->url->link('sale/print/selectprinttemplate', 'user_token=' . $this->session->data['user_token'], true);
        $data['action'] = $this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');


        $this->response->setOutput($this->load->view('sale/sale_print', $data));
    }

    public function printInvoiceList() {
        $this->load->language('sale/print');

        $this->load->language('sale/order_gst');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();


        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_invoice'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_invoice'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_invoice'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printReceiptList() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_receipt'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_receipt'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_receipt'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printInvoiceDo() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_do'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_do'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_do'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printInvoiceSo() {
        $this->load->language('herbal/print_prescription');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();

        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_order'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_order'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_order'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printInvoiceGst() {
        $this->load->language('sale/print');

        $this->load->language('sale/order_gst');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();


        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_invoice_gst'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_invoice_gst'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_invoice_gst'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function printInvoiceHold() {
        $this->load->language('sale/print');

        $this->load->language('sale/order_gst');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');

        $data = array();


        $data['title'] = $this->language->get('heading_title');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }
        $basic_data = [];
        $order_details = $this->allPrintData($orders);
        foreach ($order_details as $key => $value) {
            if ($key == 'basic_data') {
                $basic_data = $value;
                continue;
            }
            $data[$key] = $value;
        }

        $data['image_show'] = array();
        $data['image'] = isset($this->request->get['image']) ? $this->request->get['image'] : '';

        if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
            $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
        } else {
            $data['store_image'] = '';
        }

        $data['is_pdf'] = false;

        // PDF file name
        $pdf_file_name = date('Ymd_His') . '.pdf';
        if (isset($this->request->get['review']) && isset($this->request->get['pdf'])) {
            $printsale = $this->request->get['review'];
            $pdf = new PDF();
            //PDF INVOICE
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

            $data['is_pdf'] = true;

            $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            date_default_timezone_set('Asia/Kuala_Lumpur');
            $data['time'] = date("Y-m-d H:i:s A");
            $this->response->setOutput($pdf->pdf($this->load->view($printsale, $data), $pdf_file_name, $page_size, $show));
        } elseif (isset($this->request->get['pdf'])) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            if (empty($setting['sale_hold'])) {
                $this->response->redirect($this->url->link('sale/print', 'user_token=' . $this->session->data['user_token'], true));
            } else {
                $template = $setting['sale_hold'];
                $pdf = new PDF();
                //PDF INVOICE
                $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
                $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
                $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
                $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
                $page_format = ($this->config->get('pdf_invoice_page_orientation') == "landscape") ? '-L' : '';

                $data['is_pdf'] = true;

                $show = ($this->config->get('pdf_invoice_invoice_button') != "browser") ? 'D' : 'I';
                $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
                $data['pdf'] = true;
                date_default_timezone_set('Asia/Kuala_Lumpur');
                $data['time'] = date("Y-m-d H:i:s A");
                $this->response->setOutput($pdf->pdf($this->load->view($template, $data), $pdf_file_name, $page_size, $show));
            }
        }

        if (!isset($this->request->get['pdf']) || (isset($this->request->get['pdf']) && $this->config->get('pdf_invoice_invoice_button') != "browser")) {
            $setting = $this->config->get('config_order_print_setting');
            $template = '';
            $template = $setting['sale_hold'];
            $this->response->setOutput($this->load->view($template, $data));
        }
    }

    public function selectPrintTemplate() {
        $this->load->model('setting/setting');
        $this->load->model('sale/print');
        $this->load->language('sale/order');
        $this->load->language('sale/print');


        $sale_invoice = (isset($this->request->post['sale_invoice'])) ? $this->request->post['sale_invoice'] : '';
        $sale_receipt = (isset($this->request->post['sale_receipt'])) ? $this->request->post['sale_receipt'] : '';
        $sale_do = (isset($this->request->post['sale_do'])) ? $this->request->post['sale_do'] : '';
        $sale_order = (isset($this->request->post['sale_order'])) ? $this->request->post['sale_order'] : '';
        $sale_invoice_gst = (isset($this->request->post['sale_invoice_gst'])) ? $this->request->post['sale_invoice_gst'] : '';
        $sale_hold = (isset($this->request->post['sale_hold'])) ? $this->request->post['sale_hold'] : '';



        $selecttemplate = array(
            'sale_invoice' => $sale_invoice,
            'sale_receipt' => $sale_receipt,
            'sale_do'      => $sale_do,
            'sale_order'   => $sale_order,
            'sale_invoice_gst' => $sale_invoice_gst,
            'sale_hold' => $sale_hold
        );



        $jsontemplete = json_encode($selecttemplate);
        $print_value = $this->config->get('config_order_print_setting');
        if (empty($print_value)) {
            $this->model_sale_print->addprintsetting($jsontemplete);
        } else {
            $this->model_sale_print->insertprintsetting($jsontemplete);
        }



        $this->session->data['success'] = $this->language->get('text_success');



        $this->response->redirect($this->url->link('herbal/print', 'user_token=' . $this->session->data['user_token'], true));
    }

    public function allPrintData($orders) {
        $this->load->language('sale/order');

        $this->load->model('sale/print');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $this->load->model('setting/setting');

        $this->load->model('sale/order');


        $data = array();

        foreach ($orders as $order_id) {
            $basic_data = $this->model_sale_print->getOrder($order_id);

            $store_info = $this->model_setting_setting->getSetting('config', $basic_data['store_id']);
            $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
            $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

            if ($this->config->get('config_logo') && file_exists(DIR_IMAGE . $this->config->get('config_logo'))) {
                $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_logo');
            } else {
                $data['store_image'] = '';
            }

            if ($store_info) {
                $store_address = $store_info['config_address'];
                $store_telephone = $store_info['config_telephone'];
                $store_fax = $store_info['config_fax'];
                $store_number = $store_info['config_number'];
                $store_gstno = $store_info['config_gstno'];
                $store_country = $country['name'];
                $store_zone = $zone['name'];
                $store_email     = $this->config->get('config_email');
            } else {
                $store_address = $this->config->get('config_address');
                $store_telephone = $this->config->get('config_telephone');
                $store_fax = $this->config->get('config_fax');
                $store_number = '';
                $store_gstno = '';
                $store_country = '';
                $store_zone = '';
                $store_email     = $this->config->get('config_email');
            }

            $invoice_no = $basic_data['invoice_prefix'];

            if ($basic_data['payment_address_format']) {
                $format = $basic_data['payment_address_format'];
            } else {
                $format = '{firstname} {lastname}';
            }

            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_method}'
            );

            $replace = array(
                'firstname' => $basic_data['payment_firstname'],
                'lastname' => $basic_data['payment_lastname'],
                'company' => $basic_data['payment_company'],
                'address_1' => $basic_data['payment_address_1'],
                'address_2' => $basic_data['payment_address_2'],
                'city' => $basic_data['payment_city'],
                'postcode' => $basic_data['payment_postcode'],
                'zone' => $basic_data['payment_zone'],
                'zone_code' => $basic_data['payment_zone_code'],
                'country' => $basic_data['payment_country'],
                'payment_method' => $basic_data['payment_method']
            );

            $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));
            $data['fullname'] = $basic_data['payment_firstname'] . ' ' . $basic_data['payment_lastname'];
            if ($basic_data['shipping_address_format']) {
                $format = $basic_data['shipping_address_format'];
            } else {
                $format = '{firstname} {lastname}';
            }

            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}',
                '{payment_method}'
            );

            $replace = array(
                'firstname' => $basic_data['shipping_firstname'],
                'lastname' => $basic_data['shipping_lastname'],
                'company' => $basic_data['shipping_company'],
                'address_1' => $basic_data['shipping_address_1'],
                'address_2' => $basic_data['shipping_address_2'],
                'city' => $basic_data['shipping_city'],
                'postcode' => $basic_data['shipping_postcode'],
                'zone' => $basic_data['shipping_zone'],
                'zone_code' => $basic_data['shipping_zone_code'],
                'country' => $basic_data['shipping_country'],
                'payment_method' => $basic_data['payment_method']

            );

            $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            $this->load->model('tool/upload');

            $product_data = array();
            $data['tax'] = array();
            $data['whit_tax'] = 0;
            $data['product_tax'] = 0;
            $data['non_tax'] = 0;
            $data['product_non'] = 0;
            $total_quantity = 0;

            $products = $this->model_sale_order->getOrderProducts($order_id);
            $herbales = $this->model_sale_order->getPaidHerbals($order_id);
            $services = $this->model_sale_order->getPaidServies($order_id);


            $option_data = array();

            foreach ($herbales as $herbale) {
                if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                    $data['tax'][$herbale['tax_code']] = array(
                        'net_amount' => $this->currency->format($herbale['d_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']),
                        'tax' => $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']),
                        'value_net_amount' => $herbale['d_net_amount'],
                        'value_tax_amount' => 0
                    );
                } else {
                    $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                    $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                    $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                    $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']);
                }

                if ($herbale['collect_consultation_price'] == 1) {
                    $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                    $total_quantity = $total_quantity + 1;

                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'code'  =>  $herbale['invoice_prefix'],
                        'model' => $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                    );

                    $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;//
                    $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                    $total_quantity = $total_quantity + 1;

                    $product_data[] = array(
                        'name' => $this->language->get('text_consultation_price'),
                        'model' => $herbale['invoice_prefix'],
                        'code'  =>  $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['total_d_gst'], $this->config->get('config_currency'))
                    );
                } else {
                    $total_quantity = $total_quantity + 1;

                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'code'  =>  $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['subtotal'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($herbale['subtotal'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['tax'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['total'], $this->config->get('config_currency'))
                    );

                    $total_quantity = $total_quantity + 1;


                    $product_data[] = array(
                        'name' => $this->language->get('text_free_consultation'),
                        'model' => $herbale['invoice_prefix'],
                        'code'  =>  $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format(0, $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                        'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                        'total' => $this->currency->format(0, $this->config->get('config_currency'))
                    );
                }
            }

            foreach ($services as $service) {
                if (!array_key_exists($service['tax_code'], $data['tax'])) {
                    $data['tax'][$service['tax_code']] = array(
                        'net_amount' => $this->currency->format($service['service_price'], $basic_data['currency_code'], $basic_data['currency_value']),
                        'tax' => $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']),
                        'value_net_amount' => $service['service_price'],
                        'value_tax_amount' => 0
                    );
                } else {
                    $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                    $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                    $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                    $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']);
                }

                $total_quantity = $total_quantity + 1;


                $product_data[] = array(
                    'name' => $service['servicename'],
                    'code'  =>  $service['invoice_prefix'],
                    'model' => $service['invoice_prefix'],
                    'sympol' => $service['tax_code'],
                    'option' => $option_data,
                    'quantity' => 1,
                    'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                    'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                    'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                );
            }

            foreach ($products as $product) {
                $option_data = array();

                $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                $product_info = $this->model_catalog_product->getProduct($product['product_id']);
                foreach ($options as $option) {
                    if ($option['type'] != 'file') {
                        $value = $option['value'];
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $value = $upload_info['name'];
                        } else {
                            $value = '';
                        }
                    }

                    $option_data[] = array(
                        'name' => $option['name'],
                        'value' => $value
                    );
                }

                if (!array_key_exists($product['tax_code'], $data['tax'])) {
                    $data['tax'][$product['tax_code']] = array(
                        'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $basic_data['currency_code'], $basic_data['currency_value']),
                        'tax' => $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']),
                        'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                        'value_tax_amount' => 0
                    );
                } else {
                    $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                    $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                    $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                    $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']);
                }



                $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $basic_data['currency_code'], $basic_data['currency_value']);


                $total_quantity = $total_quantity + $product['quantity'];


                $product_data[] = array(
                    'name' => $product['model'],
                    'code' => $product_info['code'],
                    'model' => $product['model'],
                    'sympol' => $product['tax_code'],
                    'option' => $option_data,
                    'quantity' => $product['quantity'],
                    'price' => $this->currency->format($product['price'], $basic_data['currency_code'], $basic_data['currency_value']),
                    'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $basic_data['currency_code'], $basic_data['currency_value']),
                    'total' => $total,

                );
            }

            $total_item = count($product_data);

            $voucher_data = array();

            $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

            foreach ($vouchers as $voucher) {
                $voucher_data[] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $basic_data['currency_code'], $basic_data['currency_value'])
                );
            }

            $total_data = array();

            $totals = $this->model_sale_order->getOrderTotals($order_id);
            $total_tax = 0;
            $sub_total = 0;
            $rounding = 0;
            $shipping = 0;
            $alltotal = 0;



            foreach ($totals as $total) {
                $total_data[] = array(
                    'title' => str_replace('_', '', $total['code']),
                    'text' => $this->currency->format($total['value'], $basic_data['currency_code'], $basic_data['currency_value'], $this->config->get('config_currency')),
                );

                if ($total['code'] == 'sub_total') {
                    $sub_total += $total['value'];
                }

                if ($total['code'] == 'rounding') {
                    $rounding += $total['value'];
                }

                if ($total['code'] == 'total') {
                    $alltotal += $total['value'];
                }


                if ($total['code'] == 'shipping') {
                    $shipping += $total['value'];

                    if (!array_key_exists($total['tax_code'], $data['tax'])) {
                        $data['tax'][$total['tax_code']] = array(
                            'net_amount' => $this->currency->format($total['value'], $basic_data['currency_code'], $basic_data['currency_value']),
                            'tax' => $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']),
                            'value_net_amount' => $total['value'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                        $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                        $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                    }
                }

                if ($total['code'] == 'tax') {
                    $total_tax += $total['value'];
                    if (!array_key_exists($total['tax_code'], $data['tax'])) {
                        $data['tax'][$total['tax_code']] = array(
                            'net_amount' => $this->currency->format(0, $basic_data['currency_code'], $basic_data['currency_value']),
                            'tax' => $this->currency->format($total['value'], $basic_data['currency_code'], $basic_data['currency_value']),
                            'value_net_amount' => 0,
                            'value_tax_amount' => $total['value']
                        );
                    } else {
                        $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                        $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                        $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                        $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $basic_data['currency_code'], $basic_data['currency_value']);
                    }
                }
            }


            $product_list[] = array(
                'name' => 'RHIZOMA CIMICIFUGAE',
                'code'  =>  'SM01',
                'model' => 'RHIZOMA CIMICIFUGAE',
                'sympol' => '',
                'quantity' => 1,
                'price' => 'RM 20.00',
                'tax' => '',
                'total' => 'RM20.00',
            );
            // $data['total_tax'] = $this->currency->format($total_tax, $basic_data['currency_code'], $basic_data['currency_value']);
            // $data['sub_total'] = $this->currency->format($sub_total, $basic_data['currency_code'], $basic_data['currency_value']);
            // $data['rounding'] = $this->currency->format($rounding, $basic_data['currency_code'], $basic_data['currency_value']);
            // $data['shipping'] = $this->currency->format($shipping, $basic_data['currency_code'], $basic_data['currency_value']);
            // $data['alltotal'] = $this->currency->format($alltotal, $basic_data['currency_code'], $basic_data['currency_value']);

            $data['currency'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));
            if (!empty($order_id)) {
                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date('Y-m-d', strtotime($basic_data['invoice_date'])),
                    'time_added' => date("H:i:s", strtotime($basic_data['invoice_date'])),
                    'store_name' => $basic_data['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'telephone' => $basic_data['telephone'],
                    'firstname' => $basic_data['firstname'],
                    'lastname' => $basic_data['lastname'],
                    'product' => $product_data,
                    'total' => $total_data,
                    'comment' => nl2br($basic_data['comment']),
                    'staff_firstname' => $basic_data['staff_firstname'],
                    'staff_lastname' => $basic_data['staff_lastname'],
                    'payment_method' => $basic_data['payment_method'],
                    'total_quantity' => $total_quantity,
                    'total_item' => $total_item,
                    'total_data' => $total_data,
                );
            } else {
                $data['orders'][] = array(
                    'date_added' => '2023-01-01',
                    'store_name' => $basic_data['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'email'  => 'abc@gmail.com',
                    'invoice_no' => 'PS-1000000001',
                    'telephone' => '0124889876',
                    'firstname' => 'Cheong',
                    'lastname' => 'Ong',
                    'sub_total' => 'RM 1.00',
                    'payment_method' => 'CIMB Bank',
                    'payment_address' => 'Cheong Ong',
                    'shipping_address' => 'Cheong Ong',
                    'product' => $product_list,

                );
            }
        }


        // echo"<pre>";
        // print_r($data);
        // echo"</pre>";

        return $data;
    }
}
