<?php

class ControllerSaleOrderWholesaler extends Controller
{
    private $error = array();

    public function index()
    {
        //load default language
        $this->load->language('sale/order_wholesaler');

        //set document title
        $this->document->setTitle($this->language->get('heading_title'));

        //load default model
        $this->load->model('sale/order_wholesaler');
        $this->load->model('sale/customer_group');

        //get list
        $this->getList();
    }

    //If done then clone for function edit($this->getForm()), delete, copy (bt delete and copy is $this->getList())
    public function add()
    {

        //load default language
        $this->load->language('sale/order_wholesaler');

        //set the document title
        $this->document->setTitle($this->language->get('heading_title'));

        //load default model
        $this->load->model('sale/order_wholesaler');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

    

            //echo '<pre>';
            //print_r($this->request->post);
            //echo '</pre>';

            //**Add Order Wholesaler
            $this->model_sale_order_wholesaler->addOrderWholesaler($this->request->post);

            //Get Text Success
            $this->session->data['success'] = $this->language->get('text_success');

            //**redirect query string
            $querystring = '';

            //**Get Filter Order Id
            if (isset($this->request->get['filter_order_id'])) {
                $querystring .= '&filter_name=' . $this->request->get['filter_order_id'];
            }

            //**Get Filter Order Invoice Prefix
            if (isset($this->request->get['filter_invoice'])) {
                $querystring .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get Filter Customer Name
            if (isset($this->request->get['filter_customer'])) {
                $querystring .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get Filter Order Status
            if (isset($this->request->get['filter_order_status'])) {
                $querystring .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            //**Get Filter Order Total
            if (isset($this->request->get['filter_total'])) {
                $querystring .= '&filter_total=' . $this->request->get['filter_total'];
            }

            //**Get Filter Order Date Added
            if (isset($this->request->get['filter_date_added'])) {
                $querystring .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            //**Get Filter Order Date Modified
            if (isset($this->request->get['filter_date_modified'])) {
                $querystring .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            //**Get Filter Order Store Id
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_ids=' . $this->request->get['filter_store_id'];
            }

            //**Get Sorting Type
            if (isset($this->request->get['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            //**Get Sort Ordering (ASC or DESC)
            if (isset($this->request->get['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }

            //**Get Sort Order Pagination Page Number
            if (isset($this->request->get['page'])) {
                $querystring .= '&page=' . $this->request->get['page'];
            }

            //**redirect
            $this->response->redirect($this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        } else {
            $this->session->data['warning'] = $this->language->get('text_errors');
        }

        //getForm
        $this->getForm();
    }

    public function edit()
    {

        //load default language
        $this->load->language('sale/order_wholesaler');

        //set the document title
        $this->document->setTitle($this->language->get('heading_title'));

        //load default model
        $this->load->model('sale/order_wholesaler');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            //**Add Order Wholesaler
            $this->model_sale_order_wholesaler->editOrderWholesaler($this->request->post);

            //Get Text Success
            $this->session->data['success'] = $this->language->get('text_success');

            //**redirect query string
            $querystring = '';

            //**Get Filter Order Id
            if (isset($this->request->get['filter_order_id'])) {
                $querystring .= '&filter_name=' . $this->request->get['filter_order_id'];
            }

            //**Get Filter Order Invoice Prefix
            if (isset($this->request->get['filter_invoice'])) {
                $querystring .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get Filter Customer Name
            if (isset($this->request->get['filter_customer'])) {
                $querystring .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get Filter Order Status
            if (isset($this->request->get['filter_order_status'])) {
                $querystring .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            //**Get Filter Order Total
            if (isset($this->request->get['filter_total'])) {
                $querystring .= '&filter_total=' . $this->request->get['filter_total'];
            }

            //**Get Filter Order Date Added
            if (isset($this->request->get['filter_date_added'])) {
                $querystring .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            //**Get Filter Order Date Modified
            if (isset($this->request->get['filter_date_modified'])) {
                $querystring .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            //**Get Filter Order Store Id
            if (isset($this->request->get['filter_store_id'])) {
                $querystring .= '&filter_store_ids=' . $this->request->get['filter_store_id'];
            }

            //**Get Sorting Type
            if (isset($this->request->get['sort'])) {
                $querystring .= '&sort=' . $this->request->get['sort'];
            }

            //**Get Sort Ordering (ASC or DESC)
            if (isset($this->request->get['order'])) {
                $querystring .= '&order=' . $this->request->get['order'];
            }

            //**Get Sort Order Pagination Page Number
            if (isset($this->request->get['page'])) {
                $querystring .= '&page=' . $this->request->get['page'];
            }

            //**redirect
            $this->response->redirect($this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $querystring, true));

            //$this->response->redirect($this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'], true));
        } else {
            $this->session->data['warning'] = $this->language->get('text_errors');
            //$this->response->redirect($this->url->link('sale/order_wholesaler/add', 'user_token=' .$this->session->data['user_token'], true)) ;
        }

        //getForm
        $this->getForm();
    }

    protected function getForm()
    {
        $this->load->model('customer/customer');

        $data['heading_title'] = $this->language->get('heading_title');

        //**Text Form
        $data['text_form'] = isset($this->request->get['order_id']) ? $this->language->get('text_edit_order') : $this->language->get('text_add_order');

        //**Order
        $data['order_products'] = array();
        $data['order_vouchers'] = array();
        $data['order_herbal'] = array();
        $data['order_service'] = array();
        $data['stock_affect'] = 1;

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['wholesaler_name'])) {
            $data['error_whoselar_name'] = $this->error['wholesaler_name'];
        } else {
            $data['error_whoselar_name'] = array();
        }

        if (isset($this->error['invoice_prefix'])) {
            $data['error_invoice_prefix'] = $this->error['invoice_prefix'];
        } else {
            $data['error_invoice_prefix'] = array();
        }

        if (isset($this->error['product_item'])) {
            $data['error_product_empty'] = $this->error['product_item'];
        } else {
            $data['error_product_empty'] = array();
        }



        if (isset($this->error['date_added'])) {
            $data['error_date'] = $this->error['date_added'];
        } else {
            $data['error_date'] = array();
        }

        if (isset($this->error['status'])) {
            $data['error_order_status'] = $this->error['status'];
        } else {
            $data['error_order_status'] = array();
        }

        //**Redirect Url
        $url = '';

        //**Get filter order id
        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        //**Get filter invoice prefix
        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        //**Get filter customer name
        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        //**Get filter order status
        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        //**Get filter order total
        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        //**Get filter order date_added
        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        //**Get filter order date modified
        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        //**Get filter order store id
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**Get order column sorting type
        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        //**Get sort ordering (ASC or DESC)
        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        //**Get sort order's page number
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        //** Get breadcrumbs
        $data['breadcrumbs'] = array();

        //** Get breadcrumbs redirect link for common dashboard
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        //** Get breadcrumbs redirect link for order_wholesaler page
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );


        if (isset($this->request->get['order_id'])) {
            $order_info = $this->model_sale_order_wholesaler->getWholesalerOrder($this->request->get['order_id']);


            $data['order_id'] = $this->request->get['order_id'];
        }

        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        
        if (isset($this->request->post['invoice_prefix'])) {
            $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        } elseif (!empty($order_info['invoice_prefix'])) {
            $data['invoice_prefix'] = $order_info['invoice_prefix'];
        } else {
            $data['invoice_prefix'] = '';
        }
        
        if (isset($this->request->post['payment_address'])) {
            $data['payment_address'] = $this->request->post['payment_address'];
        } else if (!empty($order_info['payment_address_id'])) {
            $data['payment_address'] =  $order_info['payment_address_id'];
        } else {
            $data['payment_address'] = 0;
        }

        if (isset($this->request->post['shipping_address'])) {
            $data['shipping_address'] = $this->request->post['shipping_address'];
        } else if (!empty($order_info['shipping_address_id'])) {
            $data['shipping_address'] =  $order_info['shipping_address_id'];
        } else {
            $data['shipping_address'] = 0;
        }

        if (isset($this->request->post['wholesaler_id'])) {
            $data['customer_address'] = $this->model_sale_order_wholesaler->getCustomerAddress($this->request->post['wholesaler_id']);
        } elseif (!empty($order_info['customer_id'])) {
            $data['customer_address'] = $this->model_sale_order_wholesaler->getCustomerAddress($order_info['customer_id']);
        } else {
            $data['customer_address'] = [];
        }

        if (isset($this->request->post['wholesaler_id'])) {
            $data['wholesaler_id'] = $this->request->post['wholesaler_id'];
        } elseif (!empty($order_info['customer_id'])) {
            $data['wholesaler_id'] = $order_info['customer_id'];
        } else {
            $data['wholesaler_id'] = '';
        }

        if (isset($this->request->post['date_added'])) {
            $data['date_added'] = $this->request->post['date_added'];
        } elseif (!empty($order_info['invoice_date'])) {
            $data['date_added'] = date('Y-m-d', strtotime($order_info['invoice_date']));
        } else {
            $data['date_added'] = '';
        }

        if (isset($this->request->post['comment'])) {
            $data['comment'] = $this->request->post['comment'];
        } elseif (!empty($order_info['comment'])) {
            $data['comment'] = $order_info['comment'];
        } else {
            $data['comment'] = '';
        }

        if (isset($this->request->post['stock_affect'])) {
            $data['stock_affect'] = $this->request->post['stock_affect'];
        } elseif (isset($this->request->get['order_id'])) {
            $data['stock_affect'] = $order_info['stock_affect'];
        } else {
            $data['stock_affect'] = true;
        }

        if (isset($this->request->post['customer_group_id'])) {
            $data['customer_group_id'] = $this->request->post['customer_group_id'];
        } elseif (!empty($order_info['customer_group_id'])) {
            $data['customer_group_id'] = $order_info['customer_group_id'];
        } else {
            $data['customer_group_id'] = '';
        }

        if (isset($this->request->post['wholesaler_name'])) {
            $data['wholesaler_name'] = $this->request->post['wholesaler_name'];
        } elseif (!empty($order_info['firstname'])) {
            $data['wholesaler_name'] = $order_info['firstname'] . ' ' . $order_info['lastname'];
        } else {
            $data['wholesaler_name'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($order_info['order_status_id'])) {
            $data['status'] = $order_info['order_status_id'];
        } else {
            $data['status'] = 1;
        }

        if (isset($this->request->post['payment_method'])) {
            $data['payment_method'] = $this->request->post['payment_method'];
        } elseif (!empty($order_info['payment_method'])) {
            $data['payment_method'] = $order_info['payment_code'];
        } else {
            $data['payment_method'] = 'pay_by_cash';
        }

        $data['allow_edit_payment_amount'] = TRUE;
        $data['disabled'] = FALSE;
        $data['payment_methods'] = $this->model_sale_order_wholesaler->getPaymentMethods();

        

        if(!empty($this->request->post['product_item'])) {
            $product_count =0;
            $total_weights = 0;

            foreach($this->request->post['product_item'] as $productItem) {
                $product_code = $this->model_sale_order_wholesaler->getProductCode($productItem['product_id']);
                $product_weight = $this->model_sale_order_wholesaler->getWeightValue($productItem['weight_class']);


                $data['products'][] = array(
                    'product_id' => $productItem['product_id'],
                    'product_name' => $productItem['product_name'],
                    'product_code' =>  $product_code,
                    'tax_format' => $productItem['format'],
                    'product_quantity' => (float)$productItem['quantity'],
                    'product_price' => (float)$productItem['product_price'],
                    'weight_class_id' => $productItem['weight_class'],
                    'weight_value' => $product_weight,
                    'total_weight' => $productItem['total_weight'],
                    'product_total' => $productItem['hidden-total'],
                    'h_total' =>$productItem['hidden-total'],
                    'h_subtotal' => $productItem['hidden-subtotal'],
                    'product_subtotal'=> $productItem['hidden-subtotal'],
                    'h_tax' => $productItem['hidden-tax'],
                    'h_taxes' => $productItem['hidden-taxes'],
                    'product_taxes' => $productItem['hidden-taxes']




                );
                $product_count++;
            }
            $data['sub_total'] = $this->request->post['product_data']['hidden-total-subtotal'];
            $data['h_subtotal'] = $this->request->post['product_data']['hidden-total-subtotal'];
            $data['total_tax'] = $this->request->post['product_data']['hidden-total-tax'];
            $data['h_total_tax'] = $this->request->post['product_data']['hidden-total-tax'];
            $data['h_rounding'] = $this->request->post['product_data']['hidden-total-rouding'];
            $data['rounding'] = $this->request->post['product_data']['hidden-total-rouding'];
            $data['alltotal'] = $this->request->post['product_data']['hidden-final-total'];
            $data['h_total'] = $this->request->post['product_data']['hidden-final-total'];

            $total_weights += $this->request->post['product_data']['hidden-total-weight-value'];
            $data['total_weights'] = number_format($total_weights, 2);
            $data['product_count'] = $product_count;


            }elseif (!empty($order_info)) {
            $data['products'] = array();
            $data['totals'] = array();
            $products = $this->model_sale_order_wholesaler->getOrderProducts($this->request->get['order_id']);

            $order_totals = $this->model_sale_order_wholesaler->getOrderTotals($this->request->get['order_id']);

            $total_weights = 0;
            $product_count = 0;
            foreach ($products as $product) {

                $options = $this->model_sale_order_wholesaler->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

                $product_code = $this->model_sale_order_wholesaler->getProductCode($product['product_id']);

                $product_weight = $this->model_sale_order_wholesaler->getWeightValue($product['weight_class_id']);

                $default_weight = $this->model_sale_order_wholesaler->getWeightValue($product['default_conversion']);

                $total_weights += $product['total_weight'];

                $data['products'][] = array(
                    'order_id' => $this->request->get['order_id'],
                    'order_product_id' => $product['order_product_id'],
                    'product_id' => $product['product_id'],
                    'product_name' => $product['name'],
                    'product_code' => $product_code,
                    'tax_format' => $product['tax_format'],
                    'product_quantity' => (float)$product['quantity'],
                    'product_price' => (float)$product['price'],
                    'weight_class_id' => $product['weight_class_id'],
                    'weight_value' => $product_weight,
                    'default_weight' => $product['default_conversion'],
                    'd_weight_value' => $default_weight,
                    'total_weight' => $product['total_weight'],
                    'h_subtotal' => $product['total_net_amount'],
                    'product_subtotal' => $this->currency->format($product['total_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                    'h_tax' => $product['tax'],
                    'product_tax' => $this->currency->format($product['tax'], $order_info['currency_code'], $order_info['currency_value']),
                    'h_taxes' => $product['total_tax'],
                    'product_taxes' => $this->currency->format($product['total_tax'], $order_info['currency_code'], $order_info['currency_value']),
                    'h_total' => $product['total'],
                    'product_total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true)
                );
                $product_count++;
            }



            $data['product_count'] = $product_count;
            $data['total_weights'] = number_format($total_weights, 2);

            $total_tax = 0;
            $sub_total = 0;
            $rounding = 0;
            $alltotal = 0;
            $total_br = 0;
            foreach ($order_totals as $order) {

                if ($order['code'] == 'sub_total') {
                    $sub_total += $order['value'];
                }

                if ($order['code'] == 'rounding') {
                    $rounding += $order['value'];
                }

                if ($order['code'] == 'total') {
                    $alltotal += $order['value'];
                }

                if ($order['code'] == 'tax') {
                    $total_tax += $order['value'];
                }
            }

            $total_br = $sub_total + $total_tax;
            $data['total_br'] = $this->currency->format($total_br, $order_info['currency_code'], $order_info['currency_value']);
            $data['h_total_br'] = $total_br;
            $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
            $data['h_subtotal'] = $sub_total;
            $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
            $data['h_rounding'] = $rounding;
            //$data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'],$order_info['currency_value']);
            $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);
            $data['h_total'] = $alltotal;
            $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
            $data['h_total_tax'] = $total_tax;
            $data['totals'][] = array(
                'subtotal' => $data['sub_total'],
                'roudning' => $data['rounding'],
                'alltotal' => $data['alltotal'],
                'total_tax' => $data['total_tax']
            );
        }
        else{
            $data['products']= array();
            $data['sub_total'] = '';
            $data['h_subtotal'] = '';
            $data['total_tax'] = '';
            $data['h_total_tax'] = '';
            $data['h_rounding'] = '';
            $data['rounding'] = '';
            $data['alltotal'] = '';
            $data['h_total'] ='';
        }
            

        
        if (isset($this->request->post['weight_class'])) {
            $data['weight_class_id'] = $this->request->post['weight_class_id'];
        } else {
            $data['weight_class_id'] = 1;
        }

        if (isset($this->request->post['product_id'])) {
            $data['product_id'] = $this->request->post['product_id'];
        } else {
            $data['product_id'] = '';
        }

        // if (isset($this->request->post['product_name'])) {
        //     $data['product_name'] = $this->request->post['product_name'];
        // } else {
        //     $data['product_name'] = '';
        // }

        // if (isset($this->request->post['product_code'])) {
        //     $data['product_code'] = $this->request->post['product_code'];
        // } else {
        //     $data['product_code'] = '';
        // }

        // if (isset($this->request->post['product_price'])) {
        //     $data['product_price'] = $this->request->post['product_price'];
        // } else {
        //     $data['product_price'] = '';
        // }

        // if (isset($this->request->post['product_quantity'])) {
        //     $data['product_quantity'] = $this->request->post['product_quantity'];
        // } else {
        //     $data['product_quantity'] = '';
        // }

        // if (isset($this->request->post['product_subtotal'])) {
        //     $data['product_subtotal'] = $this->request->post['product_subtotal'];
        // } else {
        //     $data['product_subtotal'] = '';
        // }

        $data['cancel'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->request->get['order_id'])) {
            $data['action'] = $this->url->link('sale/order_wholesaler/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'], true);
        } else {
            $data['action'] = $this->url->link('sale/order_wholesaler/add', 'user_token=' . $this->session->data['user_token'], true);
        }

        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $filter_keys    = array('1', '2', '5', '7', '10', '11', '15', '17');
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $filter_keys)) {
                $data['order_statuses'][]  = [
                    'order_status_id' => $order_status['order_status_id'],
                    'name' => $order_status['name']
                ];
            }
        }

        $this->load->model('sale/order_wholesaler');
        $data['weight_datas'] = $this->model_sale_order_wholesaler->getWeightClass();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        // var_dump($data);

        $this->response->setOutput($this->load->view('sale/order_wholesaler_form', $data));
    }

    public function getOrderStatusColor($order_status_id)
    {
        $color = '#000';
        switch ($order_status_id) {
            case '0':
                $color = '#000';
                break;
            case '1':
                $color = '#ff5722';
                break;
            case '2':
                $color = '#03a9f4';
                break;
            case '3':
                $color = '#8d6e63';
                break;
            case '5':
                $color = '#00c853';
                break;
            case '7':
                $color = '#ff1744';
                break;
            case '15':
                $color = '#283593';
                break;
            case '17':
                $color = '#9c27b0';
                break;
            default:
                $color = '#000';
                break;
        }
        return $color;
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['filter_invoice'])) {
            $filter_invoice = $this->request->get['filter_invoice'];
        } else {
            $filter_invoice = null;
        }

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_store_id']) && $this->request->get['filter_store_id'] != 0) {
            $filter_store_id = $this->request->get['filter_store_id'];
        } else {
            $filter_store_id = $this->session->data['store_id'];;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_completed'])) {
            $filter_date_completed = $this->request->get['filter_date_completed'];
        } else {
            $filter_date_completed = null;
        }

        if (isset($this->request->get['filter_comment'])) {
            $filter_comment = $this->request->get['filter_comment'];
        } else {
            $filter_comment = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        //**Redirect Url
        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        //**Get filter order id
        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        //**Get filter invoice prefix
        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        //**Get filter customer name
        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        //**Get filter order status
        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        //**Get filter order total
        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        //**Get filter order date_added
        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_completed'])) {
            $url .= '&filter_date_completed=' . $this->request->get['filter_date_completed'];
        }

        if (isset($this->request->get['filter_comment'])) {
            $url .= '&filter_comment=' . $this->request->get['filter_comment'];
        }

        //**Get filter order date modified
        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        //**Get filter order store id
        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        //**Get order column sorting type
        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        //**Get sort ordering (ASC or DESC)
        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        //**Get sort order's page number
        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['orders'] = array();

        $filter_data = array(
            'filter_date_added_from'    => $filter_date_added_from,
            'filter_date_added_to'        => $filter_date_added_to,
            'filter_customer_group'     => $filter_customer_group,
            'filter_order_id' => $filter_order_id,
            'filter_invoice' => $filter_invoice,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status,
            'filter_total' => $filter_total,
            'filter_store_id' => $filter_store_id,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'filter_date_completed' => $filter_date_completed,
            'filter_comment' => $filter_comment,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $orders = $this->model_sale_order_wholesaler->getWholesalerOrders($filter_data);
        $total_orders = $this->model_sale_order_wholesaler->getTotalWholesalerOrders($filter_data);

        foreach ($orders as $order_row) {

            $invoice_date = (!empty($order_row['invoice_date']) && !empty($order_row['invoice_prefix'])) ? date($this->language->get('date_format_short'), strtotime($order_row['invoice_date'])) : '-';
            $date_completed = !empty($order_row['date_completed']) ? date($this->language->get('date_format_short'), strtotime($order_row['date_completed'])) : '-';


            if (!empty($order_row['comment'])) {
                $date_comment = $order_row['comment'];
            } else {
                $date_comment = '-';
            }

            $customer_group_row = $this->model_sale_customer_group->getCustomerGroup($order_row['customer_group_id']);
            $customer_group = !empty($customer_group_row) ? $customer_group_row['name'] : '';

            $status_color = $this->getOrderStatusColor($order_row['order_status_id']);

            $data['orders'][] = array(
                'order_id' => $order_row['order_id'],
                'customer' => $order_row['customer'],
                'customer_group'    => $customer_group,
                'status' => $order_row['status'],
                'status_color' => $status_color,
                'shipping_code' => $order_row['shipping_code'],
                'total' => $this->currency->format($order_row['total'], $order_row['currency_code'], $order_row['currency_value']),
                'currency_code' => $order_row['currency_code'],
                'currency_value' => $order_row['currency_value'],
                'invoice_prefix' => $order_row['invoice_prefix'],
                'date_added' => date($this->language->get('date_format_short'), strtotime($order_row['date_added'])),
                'date_completed' => $date_completed,
                'invoice_date' => $invoice_date,
                'date_modified' => date($this->language->get('date_format_short'), strtotime($order_row['date_modified'])),
                'comment' => $date_comment,
                'order_status_id' => $order_row['order_status_id'],
                'view' => $this->url->link('sale/order_wholesaler/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order_row['order_id'] . $url, true),
                'edit' => $this->url->link('sale/order_wholesaler/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order_row['order_id'] . $url, true),
                'export' => $this->url->link('sale/order_wholesaler/export_excel', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $order_row['order_id'], true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_completed'])) {
            $url .= '&filter_date_completed=' . $this->request->get['filter_date_completed'];
        }

        if (isset($this->request->get['filter_comment'])) {
            $url .= '&filter_comment=' . $this->request->get['filter_comment'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=o.order_id' . $url, true);
        $data['sort_invoice'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=o.invoice_prefix' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, true);
        $data['sort_customer_group'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_group_id' . $url, true);
        $data['sort_status'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_completed'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=oh.date_completed' . $url, true);
        $data['sort_comment'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=oh.comment' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_modified' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_completed'])) {
            $url .= '&filter_date_completed=' . $this->request->get['filter_date_completed'];
        }

        if (isset($this->request->get['filter_comment'])) {
            $url .= '&filter_comment=' . $this->request->get['filter_comment'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['receipt'] = $this->url->link('sale/order_wholesaler/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['invoice'] = $this->url->link('sale/order_wholesaler/invoiceA5', 'user_token=' . $this->session->data['user_token'], true);
        $data['invoice_pdf'] = $this->url->link('sale/order_wholesaler/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=true', true);
        $data['shipping'] = $this->url->link('sale/order_wholesaler/invoiceDO', 'user_token=' . $this->session->data['user_token'], true);

        $data['receipt'] = $this->url->link('sale/order_wholesaler/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['insert'] = $this->url->link('sale/order/add', 'user_token=' . $this->session->data['user_token'], true);
        //$data['invoice_pdf'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int)$this->request->get['order_id'].'&pdf=1', true);
        $data['add'] = $this->url->link('sale/order_wholesaler/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['online_import_settings'] = $this->url->link('sale/order_wholesaler/settings', 'user_token=' . $this->session->data['user_token'], true);

        $pagination = new Pagination();
        $pagination->total = $total_orders;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_orders) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_orders - $this->config->get('config_limit_admin'))) ? $total_orders : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_orders, ceil($total_orders / $this->config->get('config_limit_admin')));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_invoice'] = $filter_invoice;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_total'] = $filter_total;
        $data['filter_store_id'] = $filter_store_id;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_customer_group'] = $filter_customer_group;
        $data['filter_date_completed'] = $filter_date_completed;
        $data['filter_comment'] = $filter_comment;
        $data['filter_date_modified'] = $filter_date_modified;
        $data['filter_date_added_from']  = $filter_date_added_from;
        $data['filter_date_added_to'] = $filter_date_added_to;

        $this->load->model('localisation/order_status');

        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        $filter_keys    = array('1', '2', '5', '7', '10', '11', '15', '17');
        foreach ($order_statuses as $order_status) {
            if (in_array($order_status['order_status_id'], $filter_keys)) {
                $data['order_statuses'][]  = [
                    'order_status_id' => $order_status['order_status_id'],
                    'name' => $order_status['name']
                ];
            }
        }

        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/order_wholesaler_list', $data));
    }

    public function info()
    {
        //load default language
        $this->load->language('sale/order_wholesaler');

        //set document title
        $this->document->setTitle($this->language->get('heading_title'));

        //** Load model -> sale -> order_wholesaler.php
        $this->load->model('sale/order_wholesaler');

        //** Get order id
        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }

        //** Use order id to get data from the getWholesalerOrder function inside the default model
        $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);

        // API login
        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        // API login
        $this->load->model('user/api');

        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

        if ($api_info && $this->user->hasPermission('modify', 'sale/order')) {
            $session = new Session($this->config->get('session_engine'), $this->registry);

            $session->start();

            $this->model_user_api->deleteApiSessionBySessonId($session->getId());

            $this->model_user_api->addApiSession($api_info['api_id'], $session->getId(), $this->request->server['REMOTE_ADDR']);

            $session->data['api_id'] = $api_info['api_id'];

            $data['api_token'] = $session->getId();
        } else {
            $data['api_token'] = '';
        }

        //** If order info is not empty then load the data
        if ($order_info) {

            $data['store_id'] = $order_info['store_id'];

            //** Load language -> sale -> order_wholesaler.php
            $this->load->language('sale/order_wholesaler');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['user_token'] = $this->session->data['user_token'];

            $url = '';

            //**Get filter order id
            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            //**Get filter invoice prefix
            if (isset($this->request->get['filter_invoice'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get filter customer name
            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            //**Get filter order status
            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            //**Get filter order total
            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            //**Get filter order date_added
            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            //**Get filter order date modified
            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            //**Get filter order store id
            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            //**Get order column sorting type
            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            //**Get sort ordering (ASC or DESC)
            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            //**Get sort order's page number
            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            //** Set the button redirect link
            $data['export_excel'] = $this->url->link('sale/order_wholesaler/export_excel', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['shipping'] = $this->url->link('sale/order_wholesaler/shipping', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['invoice'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1', true);
            $data['invoice_gst'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1&gst=1', true);

            $data['sale_order'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1', true);
            $data['sale_order_gst'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1&gst=1', true);

            $data['delivery_note'] = $this->url->link('sale/order/invoiceDO', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1', true);
            $data['delivery_note_gst'] = $this->url->link('sale/order/invoiceDO', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1&gst=1', true);

            $data['invoice_pdf'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=1', true);

            $data['edit'] = $this->url->link('sale/order_wholesaler/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url, true);

            $data['order_id'] = $this->request->get['order_id'];

            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }

            $data['store_name'] = $order_info['store_name'];
            $data['invoice_no'] = $order_info['invoice_prefix'];
            $data['store_url'] = $order_info['store_url'];
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];

            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $order_info['customer_id'], true);
            } else {
                $data['customer'] = '';
            }

            $this->load->model('customer/customer_group');

            $customer_group_info = $this->model_customer_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }

            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['fax'] = $order_info['fax'];
            $data['comment'] = nl2br($order_info['comment']);
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['payment_method'] = $order_info['payment_method'];
            $data['total'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);


            $this->load->model('customer/customer');
            $data['reward'] = $order_info['reward'];
            $data['reward_total'] = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);
            if ($order_info['affiliate_id']) {
                $data['affiliate'] = $this->url->link('marketing/affiliate/edit', 'user_token=' . $this->session->data['user_token'] . '&affiliate_id=' . $order_info['affiliate_id'], true);
            } else {
                $data['affiliate'] = '';
            }
            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);

            $this->load->model('marketing/affiliate');
            $data['commission_total'] = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($this->request->get['order_id']);

            $this->load->model('localisation/order_status');
            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);
            if ($order_status_info) {
                $data['order_status'] = $order_status_info['name'];
            } else {
                $data['order_status'] = '';
            }

            $data['order_status_id'] = $order_info['order_status_id'];
            $data['order_status_color'] = $this->getOrderStatusColor($order_info['order_status_id']);
            $data['ip'] = $order_info['ip'];
            $data['forwarded_ip'] = $order_info['forwarded_ip'];
            $data['user_agent'] = $order_info['user_agent'];
            $data['accept_language'] = $order_info['accept_language'];
            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['date_modified'] = date($this->language->get('date_format_short'), strtotime($order_info['date_modified']));
            $data['payment_firstname'] = $order_info['payment_firstname'];
            $data['payment_lastname'] = $order_info['payment_lastname'];
            $data['payment_company'] = $order_info['payment_company'];
            $data['payment_address_1'] = $order_info['payment_address_1'];
            $data['payment_address_2'] = $order_info['payment_address_2'];
            $data['payment_city'] = $order_info['payment_city'];
            $data['payment_postcode'] = $order_info['payment_postcode'];
            $data['payment_zone'] = $order_info['payment_zone'];
            $data['payment_zone_code'] = $order_info['payment_zone_code'];
            $data['payment_country'] = $order_info['payment_country'];
            $data['card_no'] = $order_info['card_no'];
            $data['shipping_firstname'] = $order_info['shipping_firstname'];
            $data['shipping_lastname'] = $order_info['shipping_lastname'];
            $data['shipping_company'] = $order_info['shipping_company'];
            $data['shipping_address_1'] = $order_info['shipping_address_1'];
            $data['shipping_address_2'] = $order_info['shipping_address_2'];
            $data['shipping_city'] = $order_info['shipping_city'];
            $data['shipping_postcode'] = $order_info['shipping_postcode'];
            $data['shipping_zone'] = $order_info['shipping_zone'];
            $data['shipping_zone_code'] = $order_info['shipping_zone_code'];
            $data['shipping_country'] = $order_info['shipping_country'];

            $this->load->model('tool/upload');

            $data['products'] = array();

            $products = $this->model_sale_order_wholesaler->getOrderProducts($this->request->get['order_id']);
            $herbales = $this->model_sale_order_wholesaler->getHerbals($this->request->get['order_id']);
            $services = $this->model_sale_order_wholesaler->getServies($this->request->get['order_id']);

            $option_data = array();

            foreach ($herbales as $herbale) {

                $data['products'][] = array(
                    'order_product_id' => $herbale['clinical_sale_id'],
                    'product_id' => $herbale['clinical_sale_id'],
                    'name' => $this->language->get('text_herbal'),
                    'model' => $herbale['invoice_prefix'],
                    'option' => $option_data,
                    'quantity' => 1,
                    'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                    'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                    'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency')),
                    'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], true)
                );
            }

            foreach ($services as $service) {

                $data['products'][] = array(
                    'order_product_id' => $service['service_Item_id'],
                    'product_id' => $service['clinicalservice_id'],
                    'name' => $service['servicename'],
                    'model' => $service['invoice_prefix'],
                    'option' => $option_data,
                    'quantity' => 1,
                    'price' => $this->currency->format($service['price']),
                    'tax' => $this->currency->format($service['gst']),
                    'total' => $this->currency->format($service['net_amount'] + $service['gst']),
                    'href' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $service['service_form_id'], true)
                );
            }

            foreach ($products as $product) {

                $options = $this->model_sale_order_wholesaler->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

                foreach ($options as $option) {
                    if ($option['type'] != 'file') {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $option_data[] = array(
                                'name' => $option['name'],
                                'value' => $upload_info['name'],
                                'type' => $option['type'],
                                'href' => $this->url->link('tool/upload/download', 'user_token=' . $this->session->data['user_token'] . '&code=' . $upload_info['code'], true)
                            );
                        }
                    }
                }

                $data['products'][] = array(
                    'order_product_id' => $product['order_product_id'],
                    'product_id' => $product['product_id'],
                    'name' => $product['name'],
                    'model' => $product['model'],
                    'option' => $option_data,
                    'quantity' => number_format($product['quantity'], 2),
                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true)
                );
            }

            $data['vouchers'] = array();

            $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($this->request->get['order_id']);

            foreach ($vouchers as $voucher) {
                $data['vouchers'][] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('sale/voucher/edit', 'user_token=' . $this->session->data['user_token'] . '&voucher_id=' . $voucher['voucher_id'], true)
                );
            }

            $totals = $this->model_sale_order_wholesaler->getOrderTotals($this->request->get['order_id']);

            foreach ($totals as $total) {
                $data['totals'][] = array(
                    'title' => $total['title'],
                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                );
            }

            $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
            $filter_keys    = array('1', '2', '5', '7', '10', '11', '15', '17');
            foreach ($order_statuses as $order_status) {
                if (in_array($order_status['order_status_id'], $filter_keys)) {
                    $data['order_statuses'][]  = [
                        'order_status_id' => $order_status['order_status_id'],
                        'name' => $order_status['name']
                    ];
                }
            }

            $data['order_status_id'] = $order_info['order_status_id'];

            /*if (isset($response['cookie'])) {
                $this->session->data['cookie'] = $response['cookie'];
            } else {
                $data['error_warning'] = $this->language->get('error_permission');
            }*/

            //**Fraud
            $this->load->model('sale/fraud');

            $fraud_info = $this->model_sale_fraud->getFraud($order_info['order_id']);

            if ($fraud_info) {
                $data['country_match'] = $fraud_info['country_match'];

                if ($fraud_info['country_code']) {
                    $data['country_code'] = $fraud_info['country_code'];
                } else {
                    $data['country_code'] = '';
                }

                $data['high_risk_country'] = $fraud_info['high_risk_country'];
                $data['distance'] = $fraud_info['distance'];

                if ($fraud_info['ip_region']) {
                    $data['ip_region'] = $fraud_info['ip_region'];
                } else {
                    $data['ip_region'] = '';
                }

                if ($fraud_info['ip_city']) {
                    $data['ip_city'] = $fraud_info['ip_city'];
                } else {
                    $data['ip_city'] = '';
                }

                $data['ip_latitude'] = $fraud_info['ip_latitude'];
                $data['ip_longitude'] = $fraud_info['ip_longitude'];

                if ($fraud_info['ip_isp']) {
                    $data['ip_isp'] = $fraud_info['ip_isp'];
                } else {
                    $data['ip_isp'] = '';
                }

                if ($fraud_info['ip_org']) {
                    $data['ip_org'] = $fraud_info['ip_org'];
                } else {
                    $data['ip_org'] = '';
                }

                $data['ip_asnum'] = $fraud_info['ip_asnum'];

                if ($fraud_info['ip_user_type']) {
                    $data['ip_user_type'] = $fraud_info['ip_user_type'];
                } else {
                    $data['ip_user_type'] = '';
                }

                if ($fraud_info['ip_country_confidence']) {
                    $data['ip_country_confidence'] = $fraud_info['ip_country_confidence'];
                } else {
                    $data['ip_country_confidence'] = '';
                }

                if ($fraud_info['ip_region_confidence']) {
                    $data['ip_region_confidence'] = $fraud_info['ip_region_confidence'];
                } else {
                    $data['ip_region_confidence'] = '';
                }

                if ($fraud_info['ip_city_confidence']) {
                    $data['ip_city_confidence'] = $fraud_info['ip_city_confidence'];
                } else {
                    $data['ip_city_confidence'] = '';
                }

                if ($fraud_info['ip_postal_confidence']) {
                    $data['ip_postal_confidence'] = $fraud_info['ip_postal_confidence'];
                } else {
                    $data['ip_postal_confidence'] = '';
                }

                if ($fraud_info['ip_postal_code']) {
                    $data['ip_postal_code'] = $fraud_info['ip_postal_code'];
                } else {
                    $data['ip_postal_code'] = '';
                }

                $data['ip_accuracy_radius'] = $fraud_info['ip_accuracy_radius'];

                if ($fraud_info['ip_net_speed_cell']) {
                    $data['ip_net_speed_cell'] = $fraud_info['ip_net_speed_cell'];
                } else {
                    $data['ip_net_speed_cell'] = '';
                }

                $data['ip_metro_code'] = $fraud_info['ip_metro_code'];
                $data['ip_area_code'] = $fraud_info['ip_area_code'];

                if ($fraud_info['ip_time_zone']) {
                    $data['ip_time_zone'] = $fraud_info['ip_time_zone'];
                } else {
                    $data['ip_time_zone'] = '';
                }

                if ($fraud_info['ip_region_name']) {
                    $data['ip_region_name'] = $fraud_info['ip_region_name'];
                } else {
                    $data['ip_region_name'] = '';
                }

                if ($fraud_info['ip_domain']) {
                    $data['ip_domain'] = $fraud_info['ip_domain'];
                } else {
                    $data['ip_domain'] = '';
                }

                if ($fraud_info['ip_country_name']) {
                    $data['ip_country_name'] = $fraud_info['ip_country_name'];
                } else {
                    $data['ip_country_name'] = '';
                }

                if ($fraud_info['ip_continent_code']) {
                    $data['ip_continent_code'] = $fraud_info['ip_continent_code'];
                } else {
                    $data['ip_continent_code'] = '';
                }

                if ($fraud_info['ip_corporate_proxy']) {
                    $data['ip_corporate_proxy'] = $fraud_info['ip_corporate_proxy'];
                } else {
                    $data['ip_corporate_proxy'] = '';
                }

                $data['anonymous_proxy'] = $fraud_info['anonymous_proxy'];
                $data['proxy_score'] = $fraud_info['proxy_score'];

                if ($fraud_info['is_trans_proxy']) {
                    $data['is_trans_proxy'] = $fraud_info['is_trans_proxy'];
                } else {
                    $data['is_trans_proxy'] = '';
                }

                $data['free_mail'] = $fraud_info['free_mail'];
                $data['carder_email'] = $fraud_info['carder_email'];

                if ($fraud_info['high_risk_username']) {
                    $data['high_risk_username'] = $fraud_info['high_risk_username'];
                } else {
                    $data['high_risk_username'] = '';
                }

                if ($fraud_info['high_risk_password']) {
                    $data['high_risk_password'] = $fraud_info['high_risk_password'];
                } else {
                    $data['high_risk_password'] = '';
                }

                $data['bin_match'] = $fraud_info['bin_match'];

                if ($fraud_info['bin_country']) {
                    $data['bin_country'] = $fraud_info['bin_country'];
                } else {
                    $data['bin_country'] = '';
                }

                $data['bin_name_match'] = $fraud_info['bin_name_match'];

                if ($fraud_info['bin_name']) {
                    $data['bin_name'] = $fraud_info['bin_name'];
                } else {
                    $data['bin_name'] = '';
                }

                $data['bin_phone_match'] = $fraud_info['bin_phone_match'];

                if ($fraud_info['bin_phone']) {
                    $data['bin_phone'] = $fraud_info['bin_phone'];
                } else {
                    $data['bin_phone'] = '';
                }

                if ($fraud_info['customer_phone_in_billing_location']) {
                    $data['customer_phone_in_billing_location'] = $fraud_info['customer_phone_in_billing_location'];
                } else {
                    $data['customer_phone_in_billing_location'] = '';
                }

                $data['ship_forward'] = $fraud_info['ship_forward'];

                if ($fraud_info['city_postal_match']) {
                    $data['city_postal_match'] = $fraud_info['city_postal_match'];
                } else {
                    $data['city_postal_match'] = '';
                }

                if ($fraud_info['ship_city_postal_match']) {
                    $data['ship_city_postal_match'] = $fraud_info['ship_city_postal_match'];
                } else {
                    $data['ship_city_postal_match'] = '';
                }

                $data['score'] = $fraud_info['score'];
                $data['explanation'] = $fraud_info['explanation'];
                $data['risk_score'] = $fraud_info['risk_score'];
                $data['queries_remaining'] = $fraud_info['queries_remaining'];
                $data['maxmind_id'] = $fraud_info['maxmind_id'];
                $data['error'] = $fraud_info['error'];
            } else {
                $data['maxmind_id'] = '';
            }

            $data['payment_action'] = $this->load->controller('payment/' . $order_info['payment_code'] . '/orderAction', '');

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('sale/order_wholesaler_info', $data));
        } else {

            $data['store_id'] = 0;

            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    protected function validate()
    {

        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function createInvoiceNo()
    {

        $this->load->language('sale/order_wholesaler');

        $json = array();

        $invoice_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));



        if ($invoice_no) {
            $json['invoice_no'] = $invoice_no;
        } else {
            $json['error'] = $this->language->get('error_action');
        }


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addReward()
    {

        $this->load->language('sale/order_wholesaler');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order_wholesaler');

            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info && $order_info['customer_id'] && ($order_info['reward'] > 0)) {
                $this->load->model('customer/customer');

                $reward_total = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($order_id);

                if (!$reward_total) {
                    $this->model_customer_customer->addReward($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['reward'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_reward_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeReward()
    {

        $this->load->language('sale/order_wholesaler');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order_wholesaler');

            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info) {
                $this->load->model('customer/customer');

                $this->model_customer_customer->deleteReward($order_id);
            }

            $json['success'] = $this->language->get('text_reward_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addCommission()
    {

        $this->load->language('sale/order_wholesaler');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order_wholesaler');

            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info) {
                $this->load->model('marketing/affiliate');

                $affiliate_total = $this->model_marketing_affiliate->getTotalTransactionsByOrderId($order_id);

                if (!$affiliate_total) {
                    $this->model_marketing_affiliate->addTransaction($order_info['affiliate_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['commission'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_commission_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeCommission()
    {

        $this->load->language('sale/order_wholesaler');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order_wholesaler');

            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info) {
                $this->load->model('marketing/affiliate');

                $this->model_marketing_affiliate->deleteTransaction($order_id);
            }

            $json['success'] = $this->language->get('text_commission_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function country()
    {
        $json = array();

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);

        if ($country_info) {
            $this->load->model('localisation/zone');

            $json = array(
                'country_id' => $country_info['country_id'],
                'name' => $country_info['name'],
                'iso_code_2' => $country_info['iso_code_2'],
                'iso_code_3' => $country_info['iso_code_3'],
                'address_format' => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone' => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status' => $country_info['status']
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function history()
    {

        $this->load->language('sale/order_wholesaler');

        $data['text_no_results'] = $this->language->get('text_no_results');

        $data['column_date_added'] = $this->language->get('column_date_added');
        $data['column_status'] = $this->language->get('column_status');
        $data['column_notify'] = $this->language->get('column_notify');
        $data['column_comment'] = $this->language->get('column_comment');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['histories'] = array();

        $this->load->model('sale/order_wholesaler');

        $results = $this->model_sale_order_wholesaler->getOrderHistories($this->request->get['order_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['histories'][] = array(
                'notify' => $result['notify'] ? $this->language->get('text_yes') : $this->language->get('text_no'),
                'status' => $result['status'],
                'comment' => nl2br($result['comment']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $history_total = $this->model_sale_order_wholesaler->getTotalOrderHistories($this->request->get['order_id']);

        $pagination = new Pagination();
        $pagination->total = $history_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('sale/order_wholesaler/history', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($history_total - 10)) ? $history_total : ((($page - 1) * 10) + 10), $history_total, ceil($history_total / 10));

        $this->response->setOutput($this->load->view('sale/order_wholesaler_history', $data));
    }

    public function update_stock()
    {
        $this->load->model('sale/order_wholesaler');
        $json = [];
        $order_id = !empty($this->request->post['order_id']) ? $this->request->post['order_id'] : 0;
        $order_status_id = !empty($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : 0;
        $current_status_id = !empty($this->request->post['current_status_id']) ? $this->request->post['current_status_id'] : 0;
        if (!empty($order_id) && !empty($order_status_id) && !empty($current_status_id)) {
            $json['msg'] = 'success';
            $this->model_sale_order_wholesaler->updateStock($order_id, $order_status_id, $current_status_id);
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function update_status()
    {
        $this->load->model('sale/order_wholesaler');
        $json = [];
        $order_id = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;
        $json['order_status_id'] = 0;
        if (!empty($order_id)) {
            $json['msg'] = 'success';
            $json['order_status_id'] = $this->model_sale_order_wholesaler->getCurrentOrderStatus($order_id);
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function invoice()
    {
        $this->load->language('sale/order');
        $this->load->library('weight');
        $this->weight = new Weight($this->registry);
        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {

            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . ' ' . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . ' ' . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);

                foreach ($totals as $total) {
                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/order_wholesaler_invoice', $data));
    }

    public function invoiceSO()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_wholesaler_gst');
        } else {
            $this->load->language('sale/order_wholesaler');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);

                $option_data = array();

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }


                $data['total_gst_amount'] = $this->currency->format($total_tax + $shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                if (!empty($shipping)) {
                    $shipping_address = $shipping_address;
                } else {
                    $shipping_address = '';
                }


                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_wholesaler_invoice_so', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_wholesaler_invoice_so', $data));
    }

    public function invoiceDO()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_wholesaler_gst');
        } else {
            $this->load->language('sale/order_wholesaler');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;
        $pdf = true;
        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);

                $option_data = array();

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }


                $data['total_gst_amount'] = $this->currency->format($total_tax + $shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                if (!empty($shipping)) {
                    $shipping_address = $shipping_address;
                } else {
                    $shipping_address = '';
                }


                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_wholesaler_invoice_do', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_wholesaler_invoice_do', $data));
    }

    public function invoiceA5()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_wholesaler_gst');
        } else {
            $this->load->language('sale/order_wholesaler');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);
                $herbales = $this->model_sale_order_wholesaler->getPaidHerbals($order_id);
                $services = $this->model_sale_order_wholesaler->getPaidServies($order_id);

                $option_data = array();
                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'sub_total' => $this->currency->format($service['service_price']),
                        'price' => $this->currency->format($service['price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'unit' => $this->weight->getUnit($product['weight_class_id']),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }

                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['store_gstno'] = $this->config->get('store_gstno');

                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);



                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'sub_total' => $data['sub_total'],
                    'rounding' => $data['rounding'],
                    'shipping' => $data['shipping'],
                    'alltotal' => $data['alltotal'],
                    'total_tax' => $data['total_tax'],
                    'tax' => $data['tax']
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_wholesaler_invoice_a5', $data), $pdf_file_name, $page_size, $show));
        }

        $this->response->setOutput($this->load->view('sale/order_wholesaler_invoice_a5', $data));
    }

    public function invoiceHoald()
    {

        $this->load->language('sale/order_wholesaler');

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order_wholesaler->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);
                $herbales = $this->model_sale_order_wholesaler->getHoaldHerbals($order_id);
                $services = $this->model_sale_order_wholesaler->getHoaldServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                        'sub_total' => $this->currency->format($herbale['d_net_amount']),
                        'tax' => $this->currency->format($herbale['d_gst']),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'])
                    );
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price']),
                        'sub_total' => $this->currency->format($service['service_price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount']),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_invoice_hoald', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('saleorder_wholesaler_invoice_hoald', $data));
    }

    public function invoiceReceipt()
    {

        $this->load->language('sale/order_wholesaler');

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $data['print_time'] = date("Y-m-d H:i:s");


        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {

            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);

            $data['staff_name'] = $order_info['staff_name'];

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                $this->load->model('tool/upload');

                $product_data = array();
                $data['tax'] = array();
                $data['whit_tax'] = 0;
                $data['product_tax'] = 0;
                $data['non_tax'] = 0;
                $data['product_non'] = 0;

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);
                $herbales = $this->model_sale_order_wholesaler->getPaidHerbals($order_id);
                $services = $this->model_sale_order_wholesaler->getPaidServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'sympol' => $herbale['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation']),
                        'tax' => $this->currency->format($herbale['d_gst']),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'])
                    );
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price']),
                        'tax' => $this->currency->format($service['gst']),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'])
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => $product['model'],
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order_wholesaler->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order_wholesaler->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {

                        $shipping += $total['value'];

                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['currency'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'telephone' => $order_info['telephone'],
                    'product' => $product_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'tax' => $data['tax'],
                    'total_tax' => $data['total_tax'],
                    'sub_total' => $data['sub_total'],
                    'rounding' => $data['rounding'],
                    'shipping' => $data['shipping'],
                    'alltotal' => $data['alltotal']
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            $show = 'I';
            $page_size = array(80, 500);
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_receipt', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_wholesaler_receipt', $data));
    }

    public function shipping()
    {

        $this->load->language('sale/order_wholesaler');

        $data['title'] = $this->language->get('text_shipping');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order_wholesaler');

        $this->load->model('catalog/product');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);

            // Make sure there is a shipping method
            if ($order_info && $order_info['shipping_code']) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');

                $product_data = array();

                $products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);

                    $option_data = array();

                    $options = $this->model_sale_order_wholesaler->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product_info['name'],
                        'model' => $product_info['model'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'location' => $product_info['location'],
                        'sku' => $product_info['sku'],
                        'upc' => $product_info['upc'],
                        'ean' => $product_info['ean'],
                        'jan' => $product_info['jan'],
                        'isbn' => $product_info['isbn'],
                        'mpn' => $product_info['mpn'],
                        'weight' => $this->weight->format($product_info['weight'], $this->config->get('config_weight_class_id'), $this->language->get('decimal_point'), $this->language->get('thousand_point'))
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'product' => $product_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/order_wholesaler_shipping', $data));
    }

    public function export_excel()
    {
        $this->load->language('sale/order_wholesaler');
        $this->load->model('sale/order_wholesaler');

        $table_collection = array();

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];

            $order_info = $this->model_sale_order_wholesaler->getWholesaler_Order($order_id);
            $order_products = $this->model_sale_order_wholesaler->getOrderProducts($order_id);

            if (!empty($order_info)) {
                if (!empty($order_products)) {
                    foreach ($order_products as $product) {
                        $table_collection[] = [
                            'product_id' => $product['product_id'],
                            'model' => $product['model'],
                            'name' => $product['name'],
                            'quantity' => $product['quantity'],
                            'price' => $product['price'],
                            'total' => $product['total']
                        ];
                    }

                    //get user detail
                    $this->load->model('user/user');
                    $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

                    //get gst code
                    $this->load->model('setting/store');
                    //$gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));
                    //load php excel
                    $this->load->library('PHPExcel');
                    $objPHPExcel = new PHPExcel();

                    // Set document properties
                    $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                        ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                        ->setTitle("Title")
                        ->setSubject("Subject")
                        ->setDescription("Description")
                        ->setKeywords("report qiangyitang")
                        ->setCategory("report excel");
                    // Set default font
                    $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
                        ->setSize(10);

                    $table = array();

                    $table[] = array('Report Name : ', $this->language->get('heading_title'));
                    $table[] = array('Invoice Prefix : ', $order_info['invoice_prefix']);
                    $table[] = array('Store Name : ', $this->config->get('config_name'));

                    $table[] = array();

                    $table_header = array( //table headers
                        $this->language->get('column_product_id'),
                        $this->language->get('column_product_code'),
                        $this->language->get('column_product_name'),
                        $this->language->get('column_quantity'),
                        $this->language->get('column_price'),
                        $this->language->get('column_total')
                    );

                    $table[] = $table_header; //add header to table

                    $table_data = $table_collection;
                    $row = [];

                    $total_row = 0;
                    foreach ($table_data as $key => $data) {
                        $row = array();
                        foreach ($data as $key => $value) {
                            $row[] = $value;
                        }
                        $table[] = $row; //add data row to table
                        $total_row++;
                    }

                    //  Styling
                    $autosize_column_index = 'A';
                    foreach ($table_header as $header) { //loop each header
                        $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
                        $autosize_column_index++;
                    }

                    $header_index_s_column = 'A';
                    $header_index_e_column = $header_index_s_column;
                    foreach ($table_header as $col)
                        $header_index_e_column++;
                    $header_index_row = 5;
                    $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

                    $header_style = array(
                        'alignment' => array(
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
                        ),
                        'font' => array(
                            'bold' => true
                        )
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

                    $currency_style = array(
                        'alignment' => array(
                            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
                        ),
                        'numberformat' => array(
                            'code' => "0.00"
                        )
                    );

                    $objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
                    $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
                    $objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

                    // Add Array To Excel
                    $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


                    // Rename worksheet
                    $sheettitle = $this->language->get('heading_title');
                    $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
                    $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

                    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                    $objPHPExcel->setActiveSheetIndex(0);

                    $filename = $this->language->get('heading_title') . '_' . $order_info['invoice_prefix'];

                    // Save Excel 2007 file
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
                    //ob_end_clean();
                    // We'll be outputting an excel file
                    header('Content-type: application/vnd.ms-excel');

                    // It will be called file.xls
                    header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
                    $objWriter->save('php://output');
                }
            }
        }
    }

    public function wholesaler_name()
    {
        $this->load->language('openwindow/wholesaler');
        $this->load->model('sale/order_wholesaler');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = NULL;
        }

        if (isset($this->request->get['ic_num'])) {
            $ic_num = $this->request->get['ic_num'];
        } else {
            $ic_num = NULL;
        }

        if (isset($this->request->get['email'])) {
            $email = $this->request->get['email'];
        } else {
            $email = NULL;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = NULL;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['ic_num'])) {
            $url .= '&ic_num=' . urlencode(html_entity_decode($this->request->get['ic_num'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['email'])) {
            $url .= '&email=' . urlencode(html_entity_decode($this->request->get['email'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . urlencode(html_entity_decode($this->request->get['filter_customer_group'], ENT_QUOTES, 'UTF-8'));
        }

        $data['wholesalers'] = array();

        $filter_data = array(
            'name' => $name,
            'ic_num' => $ic_num,
            'email' => $email,
            'filter_customer_group' => $filter_customer_group,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_wholesaler = $this->model_sale_order_wholesaler->TotalWholesalers($filter_data);

        $results = $this->model_sale_order_wholesaler->getWholesalers($filter_data);

        foreach ($results as $result) {
            $data['wholesalers'][] = array(
                'customer_id' => $result['customer_id'],
                'customer_name' => $result['customer_name'],
                'customer_ic' => $result['customer_ic'],
                'email' => $result['email'],
                'customer_group_id' => $result['customer_group_id']
            );
        }

        if (!empty($data['wholesalers'])) {
            foreach ($data['wholesalers'] as $index => $wholesalers) {
                $data['wholesalers'][$index]['select_data'] = htmlspecialchars(json_encode($wholesalers), ENT_QUOTES, 'UTF-8');
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        // Customer Groups
        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        $pagination = new Pagination();
        $pagination->total = $total_wholesaler;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/order_wholesaler/wholesaler_name', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_wholesaler) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_wholesaler - $this->config->get('config_limit_admin'))) ? $total_wholesaler : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_wholesaler, ceil($total_wholesaler / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['ic_num'] = $ic_num;
        $data['email'] = $email;
        $data['filter_customer_group'] = $filter_customer_group;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/wholesaler_name_list', $data));
    }

    public function wholesaler_product()
    {
        $this->load->language('sale/order_wholesaler');
        $this->load->model('sale/order_wholesaler');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = '';
        }

        if (isset($this->request->get['code'])) {
            $code = $this->request->get['code'];
        } else {
            $code = '';
        }

        if (isset($this->request->get['customer_group_id'])) {
            $customer_group_id = $this->request->get['customer_group_id'];
        } else {
            $customer_group_id = NULL;
        }

        if (isset($this->request->get['date'])) {
            $date = date('Ymd', strtotime($this->request->get['date']));
        } else {
            $date = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['code'])) {
            $url .= '&code=' . urlencode(html_entity_decode($this->request->get['code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['customer_group_id'])) {
            $url .= '&customer_group_id=' . urlencode(html_entity_decode($this->request->get['customer_group_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['row_id'])) {
            $url .= '&row_id=' . urlencode(html_entity_decode($this->request->get['row_id'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['date'])) {
            $url .= '&date=' . urlencode(html_entity_decode($this->request->get['date'], ENT_QUOTES, 'UTF-8'));
        }

        $data['products'] = array();

        $filter_data = array(
            'name' => $name,
            'code' => $code,
            'customer_group_id' => $customer_group_id,
            'date' => $date,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $total_products = $this->model_sale_order_wholesaler->getTotalWholesalerProducts($filter_data);
        $results = $this->model_sale_order_wholesaler->getWholesalerProducts($filter_data);

        foreach ($results as $result) {
            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'product_name' => $result['product_name'],
                'product_code' => $result['product_code'],
                'product_weight_class' => $result['product_weight_class'],
                'product_weight_class_id' => $result['product_weight_class_id'],
                'product_price' => $result['product_price']
            );
        }

        if (!empty($data['products'])) {
            foreach ($data['products'] as $index => $products) {
                $data['products'][$index]['select_data'] = htmlspecialchars(json_encode($products), ENT_QUOTES, 'UTF-8');
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $total_products;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');;
        $pagination->url = $this->url->link('sale/order_wholesaler/wholesaler_product', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_products) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_products - $this->config->get('config_limit_admin'))) ? $total_products : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_products, ceil($total_products / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['code'] = $code;
        $data['row_id'] = $this->request->get['row_id'];
        $data['customer_group_id'] = $customer_group_id;
        $data['date'] = $date;

        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/wholesaler_product_list', $data));
    }

    //New added by Yi Xuan on 8/9/2016
    //Check Discount + Check Special
    public function checkDiscount()
    {
        $json = array();
        $discount_filter_data = array();
        $this->load->model('sale/order_wholesaler');

        if (isset($this->request->post)) {
            if (isset($this->request->post['product_id'])) {
                $product_id = $this->request->post['product_id'];
            } else {
                $product_id = '';
            }
            if (isset($this->request->post['product_quantity'])) {
                $product_quantity = $this->request->post['product_quantity'];
            } else {
                $product_quantity = '';
            }
            if (isset($this->request->post['customer_group_id'])) {
                $customer_group_id = $this->request->post['customer_group_id'];
            } else {
                $customer_group_id = '';
            }
            if (isset($this->request->post['date'])) {
                $date = date('Ymd', strtotime($this->request->post['date']));
            } else {
                $date = '';
            }
            if (isset($this->request->post['rows'])) {
                $rows = $this->request->post['rows'];
            } else {
                $rows = '';
            }

            $discount_filter_data = array(
                'product_id' => $product_id,
                'product_quantity' => $product_quantity,
                'customer_group_id' => $customer_group_id,
                'date' => $date,
                'rows' => $rows
            );

            $getSpecials = $this->model_sale_order_wholesaler->checkSpecial($discount_filter_data);

            $getDiscounts = $this->model_sale_order_wholesaler->checkDiscount($discount_filter_data);

            if ($getSpecials) {
                foreach ($getSpecials as $getSpecial) {
                    $json = array(
                        'price' => $getSpecial['price']
                    );
                }
            } else {
                if ($getDiscounts) {

                    foreach ($getDiscounts as $getDiscount) {
                        $json = array(
                            'price' => $getDiscount['price']
                        );
                    }
                } else {
                    $json = array();
                }
            }
        } else {
            $json = array();
        }

        header('Content-Type: application/json');
        echo json_encode($json);
    }

    public function getShippingAddress()
    {
        $json = array();
        $this->load->model('sale/order_wholesaler');
        if (isset($this->request->post)) {
            $customer_id = $this->request->post['customer_id'];
            $shipping_address = $this->model_sale_order_wholesaler->getShippingAddress($customer_id);
            foreach ($shipping_address as $shad_id => $sh_ad) {
                $name = $sh_ad['firstname'] . ' ' . $sh_ad['lastname'];
                if (!empty($sh_ad['zone_id'])) {
                    $zone = $this->model_sale_order_wholesaler->getZoneById($sh_ad['zone_id']);
                } else {
                    $zone = '';
                }
                if (!empty($sh_ad['country_id'])) {
                    $country = $this->model_sale_order_wholesaler->getCountryById($sh_ad['country_id']);
                } else {
                    $country = '';
                }
                $address = $sh_ad['address_1'] . ' ' . $sh_ad['address_2'] . ' ' . $sh_ad['address_3'] . ' ' . $sh_ad['postcode'] . ' ' . $sh_ad['city'] . ' ' . $zone . ' ' . $country;
                $shipping_address = $name . ' , ' . $address;
                $json[$sh_ad['address_id']]['address'] = $shipping_address;
            }
        } else {
            $json = array();
        }
        header('Content-Type: application/json');
        echo json_encode($json);
    }

    public function getPaymentAddress()
    {
        $json = array();
        $this->load->model('sale/order_wholesaler');
        if (isset($this->request->post)) {
            $customer_id       =  $this->request->post['customer_id'];
            $payment_address = $this->model_sale_order_wholesaler->getShippingAddress($customer_id);
            foreach ($payment_address as $payadd_id => $pay_ad) {
                $name      = $pay_ad['firstname'] . ' ' . $pay_ad['lastname'];
                if (!empty($pay_ad['zone_id'])) {
                    $zone    = $this->model_sale_order_wholesaler->getZoneById($pay_ad['zone_id']);
                } else {
                    $zone = '';
                }
                if (!empty($pay_ad['country_id'])) {
                    $country = $this->model_sale_order_wholesaler->getCountryById($pay_ad['country_id']);
                } else {
                    $country = '';
                }
                $address = $pay_ad['address_1'] . ' ' . $pay_ad['address_2'] . ' ' . $pay_ad['address_3'] . ' ' . $pay_ad['postcode'] . ' ' . $pay_ad['city'] . ' ' . $zone . ' ' . $country;
                $payment_address = $name . ' , ' . $address;
                $json[$pay_ad['address_id']]['address'] = $payment_address;
            }
        } else {
            $json = array();
        }
        header('Content-Type: application/json');
        echo json_encode($json);
    }

    public function calculatePrice()
    {
        $json = array();

        $this->load->model('catalog/product');

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $default_qty = 1;

        if (isset($this->request->post)) {
            $product_id = $this->request->post['product_id'];
            $product_price = $this->request->post['product_price'];
            $quantity = $this->request->post['quantity'];
            $rows = $this->request->post['rows'];

            $amount = $product_price * $quantity;
            $d_amount = $product_price * $default_qty;

            $product_info = $this->model_catalog_product->getProduct($product_id);

            $tax_class_id = $product_info['tax_class_id'];

            $tax_value = $this->tax->calculateTax($amount, $tax_class_id);
            $d_tax_value = $this->tax->calculateTax($d_amount, $tax_class_id);

            $json = array(
                'subtotal' => $this->currency->format($tax_value['net_amount'], $this->config->get('config_currency')),
                'tax' => $this->currency->format($tax_value['tax'], $this->config->get('config_currency')),
                'taxes' => $this->currency->format($d_tax_value['tax'], $this->config->get('config_currency')),
                'total' => $this->currency->format($tax_value['total'], $this->config->get('config_currency')),
                'format' => $tax_value['format']
            );
        } else {
            $json = array();
        }

        header('Content-Type: application/json');
        echo json_encode($json);
    }

    protected function validateForm()
    {
        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler') && !$this->user->userpermissions('modify', 'sale/order_wholesaler')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        $product_datas = $this->request->post['product_data'];

        if ($product_datas) {

            if ((utf8_strlen($product_datas['hidden-total-subtotal']) < 1) || (utf8_strlen($product_datas['hidden-total-subtotal']) > 255)) {
                $this->error['warning'] = $this->language->get('error_warning');
            }


            if ((utf8_strlen($product_datas['hidden-total-tax']) < 1) || (utf8_strlen($product_datas['hidden-total-tax']) > 255)) {
                $this->error['warning'] = $this->language->get('error_warning');
            }

            if ((utf8_strlen($product_datas['hidden-total-rouding']) < 1) || (utf8_strlen($product_datas['hidden-total-rouding']) > 255)) {
                $this->error['warning'] = $this->language->get('error_warning');
            }

            if ((utf8_strlen($product_datas['hidden-final-total']) < 1) || (utf8_strlen($product_datas['hidden-final-total']) > 255)) {
                $this->error['warning'] = $this->language->get('error_warning');
            }

            if ((utf8_strlen($product_datas['hidden-total-weight-value']) < 1) || (utf8_strlen($product_datas['hidden-total-weight-value']) > 255)) {
                $this->error['warning'] = $this->language->get('error_warning');
            }

            if ($product_datas['rows'] < 1) {
                $this->error['warning'] = $this->language->get('error_warning');
                $this->error['product_item'] = $this->language->get('error_product_empty');

            } else {
                $product_items = $this->request->post['product_item'];
                foreach ($product_items as $pid => $product_item) {
                    if ((utf8_strlen($product_item['product_id']) < 1) || (utf8_strlen($product_item['product_id']) > 255)) {
                        $this->error['warning'] = $this->language->get('error_warning');
                    }
                }
            }
        }

        if ((utf8_strlen($this->request->post['wholesaler_name']) < 1) || (utf8_strlen($this->request->post['wholesaler_name']) > 255)) {
            $this->error['wholesaler_name'] = $this->language->get('error_whoselar_name');
            $this->error['warning'] = $this->language->get('error_warning');
        }

        if ((utf8_strlen($this->request->post['wholesaler_id']) < 1) || (utf8_strlen($this->request->post['wholesaler_id']) > 255)) {
            $this->error['wholesaler_id'] = $this->language->get('error_whoselar_name');
            $this->error['warning'] = $this->language->get('error_warning');
        }

        /* check if user keyin only */

        if(!empty($this->request->post['invoice_prefix'])) {
            $order_id = !empty($this->request->get['order_id']) ? $this->request->get['order_id'] : 0;
            $order_info= $this->model_sale_order_wholesaler->getOrderByInvoicePrefix($this->request->post['invoice_prefix']);
            if(!empty($order_info)) {
                if($order_info['order_id'] != $order_id) {
                    $this->error['invoice_prefix'] = $this->language->get('error_invoice_prefix');
                    $this->error['warning'] = $this->language->get('error_warning');
                }
            }
        }
   
     
        

        if ((utf8_strlen($this->request->post['status']) < 1) || (utf8_strlen($this->request->post['status']) > 64)) {
            $this->error['status'] = $this->language->get('error_order_status');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    public function api()
    {
        $json = array();

        // Store
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        $this->load->model('setting/store');

        $store_info = $this->model_setting_store->getStore($store_id);

        if ($store_info) {
            $url = $store_info['ssl'];
        } else {
            $url = HTTPS_CATALOG;
        }

        if (isset($this->session->data['cookie']) && isset($this->request->get['api'])) {
            // Include any URL perameters
            $url_data = array();

            foreach ($this->request->get as $key => $value) {
                if ($key != 'route' && $key != 'user_token') {
                    $url_data[$key] = $value;
                }
            }

            //html decode
            foreach ($this->request->post as $key => $value) {
                $this->request->post[$key] = html_entity_decode($value, ENT_QUOTES, 'UTF-8');
            }

            $curl = curl_init();

            // Set SSL if required
            if (substr($url, 0, 5) == 'https') {
                curl_setopt($curl, CURLOPT_PORT, 443);
            }

            curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
            $header = array("Cache-Control: no-cache");
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($curl, CURLOPT_URL, $url . 'index.php?route=' . $this->request->get['api'] . ($url_data ? '&' . http_build_query($url_data) : ''));


            if ($this->request->post) {
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($this->request->post));
            }

            curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');
            $json = curl_exec($curl);

            curl_close($curl);
        }



        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput($json);
    }

    //add by alia

    public function settings()
    {
        $this->load->language('sale/order_wholesaler');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/order_wholesaler');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateSettingsForm()) {
            $this->model_sale_order_wholesaler->save_settings($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success_import_settings');

            $this->response->redirect($this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getSettingsForm();
    }

    protected function validateSettingsForm()
    {
        if (!$this->user->hasPermission('modify', 'sale/order_wholesaler')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['customer_group'])) {
            $this->error['customer_group'] = $this->language->get('error_customer_group');
        }


        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function getSettingsForm()
    {
        $import_settings = $this->get_settings();

        // var_dump($import_settings);
        // die();
        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('sale/order_wholesaler/settings', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('sale/order_wholesaler', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['config_order_wholesaler_customer_group'])) {
            $data['error_order_wholesale_customer_group'] = $this->error['config_order_wholesaler_customer_group'];
        } else {
            $data['error_order_wholesale_customer_group'] = '';
        }


        if (isset($this->request->post['config_order_wholesaler_customer_group'])) {
            $data['config_order_wholesaler_customer_group'] = $this->request->post['config_order_wholesaler_customer_group'];
        } elseif (!empty($import_settings)) {
            $data['config_order_wholesaler_customer_group'] = $import_settings['config_order_wholesaler_customer_group'];
        } else {
            $data['config_order_wholesaler_customer_group'] = '';
        }



        $this->load->model('sale/customer_group');


        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/online_setting_form', $data));
    }

    private function get_settings()
    {
        $setting_results = [];

        $this->load->model('sale/order_wholesaler');

        $settings = $this->model_sale_order_wholesaler->get_settings();
        // var_dump($settings);
        // die();
        if (!empty($settings)) {
            foreach ($settings as $setting) {
                if ($setting['serialized'] == '1') {
                    $setting_results[$setting['key']] = unserialize($setting['value']);
                } else {
                    $setting_results[$setting['key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }
}
