<?php

class ControllerSaleCustomerPaymentMethod extends Controller {

    private $error = [];

    public function index() {
        $this->load->language('sale/customer_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment_method');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

        $this->getList();
    }

    public function add() {
        $this->load->language('sale/customer_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment_method');
        
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_sale_customer_payment_method->addCustomerPaymentMethod($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_code'])) {
                $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('sale/customer_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment_method');

        if (!isset($this->request->get['customer_payment_method_id'])) {

            $this->response->redirect($this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'], true));
        }
            
        
            // if(!empty($this->request->get['customer_payment_method_id']) && $this->editvalidateForm()){
            //     $this->response->redirect($this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'], true));
            // }
            

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->editvalidateForm()) {
            $this->model_sale_customer_payment_method->editCustomerPaymentMethod($this->request->post, $this->request->get['customer_payment_method_id']);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_code'])) {
                $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }



        $this->getForm();
    }

    public function delete() {  
        $this->load->language('sale/customer_payment_method');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/customer_payment_method');


        if(!empty($this->request->get['customer_payment_method_id']) && $this->validateDelete($this->request->get['customer_payment_method_id'])){
            $this->model_sale_customer_payment_method->deleteCustomerPaymentMethod($this->request->get['customer_payment_method_id']);
            $this->session->data['success'] = $this->language->get('text_success');

        }

        if (isset($this->request->post['selected'])) {
            foreach ($this->request->post['selected'] as $customer_payment_method_id) {
                if (isset($this->request->post['selected']) && $this->validateDelete($customer_payment_method_id)) {

                    $this->model_sale_customer_payment_method->deleteCustomerPaymentMethod($customer_payment_method_id);
                }
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['filter_payment_method_name'])) {
                $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_accounting_code'])) {
                $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_sql_code'])) {
                $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_status'])) {
                $url .= '&filter_status=' . $this->request->get['filter_status'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    protected function getList() {
        if (isset($this->request->get['filter_payment_method_name'])) {
            $filter_payment_method_name = $this->request->get['filter_payment_method_name'];
        } else {
            $filter_payment_method_name = '';
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $filter_sql_accounting_code = $this->request->get['filter_sql_accounting_code'];
        } else {
            $filter_sql_accounting_code = '';
        }

        if (isset($this->request->get['filter_sql_code'])) {
            $filter_sql_code = $this->request->get['filter_sql_code'];
        } else {
            $filter_sql_code = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = '';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = '';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_code'])) {
            $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('sale/customer_payment_method/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('sale/customer_payment_method/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['payment_methods'] = array();

        $filter_data = array(
            'filter_payment_method_name' => $filter_payment_method_name,
            'filter_sql_accounting_code' => $filter_sql_accounting_code,
            'filter_sql_code' => $filter_sql_code,
            'filter_status' => $filter_status,
            'sort' => $sort,
            'order' => $order
        );

        $start = ($page - 1) * $this->config->get('config_limit_admin');
        $limit = $this->config->get('config_limit_admin');

        $results = $this->model_sale_customer_payment_method->getCustomerPaymentMethods($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $payment_method_name_arr = $result['payment_method_name'];
                $payment_method_name = $payment_method_name_arr;

                if (!empty($filter_payment_method_name)) {
                    if ($payment_method_name && $filter_payment_method_name) {
                        $data['payment_methods'][] = [
                            'customer_payment_method_id' => $result['customer_payment_method_id'],
                            'payment_method_name' => $payment_method_name,
                            'code'  => $result['code'],
                            'sql_accounting_code' => $result['sql_accounting_code'],
                            'sort_order' => $result['sort_order'],
                            'status' => $result['status'],
                            'allow_deleted' => $result['allow_deleted'],
                            'add_by' => $result['add_by'],
                            'default' => $result['default'],
                            'date_added' => date('Y-m-d h:i:s' ,strtotime($result['date_added'])),
                            'date_modify' => date('Y-m-d h:i:s' ,strtotime($result['date_modified'])),
                            'edit' => $this->url->link('sale/customer_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_method_id=' . $result['customer_payment_method_id'], true),
                            'delete' => $this->url->link('sale/customer_payment_method/delete', 'user_token=' . $this->session->data['user_token'] .'&customer_payment_method_id='.$result['customer_payment_method_id'].'&sql_code='.$result['code'].'&default='.$result['default'] , true)
                        ];
                    }
                } else {
                    $data['payment_methods'][] = [
                        'customer_payment_method_id' => $result['customer_payment_method_id'],
                        'payment_method_name' => $payment_method_name,
                        'code'  => $result['code'],
                        'sql_accounting_code' => $result['sql_accounting_code'],
                        'sort_order' => $result['sort_order'],
                        'status' => $result['status'] == '1',
                        'allow_deleted' => $result['allow_deleted'],
                        'add_by' => $result['add_by'],
                        'default' => $result['default'],
                        'date_added' => date('Y-m-d h:i:s' ,strtotime($result['date_added'])),
                        'date_modify' => date('Y-m-d h:i:s' ,strtotime($result['date_modified'])),
                        'edit' => $this->url->link('sale/customer_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_method_id=' . $result['customer_payment_method_id'], true),
                        'delete' => $this->url->link('sale/customer_payment_method/delete', 'user_token=' . $this->session->data['user_token'] .'&customer_payment_method_id='.$result['customer_payment_method_id'].'&sql_code='.$result['code'].'&default='.$result['default'] , true)
                    ];
                }

                
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'payment_method_name') {
                $payment_method_name_column = array_column($data['payment_methods'], 'payment_method_name');

                if ($order == 'ASC') {
                    array_multisort($data['payment_methods'], SORT_NUMERIC, $payment_method_name_column, SORT_ASC);
                } else {
                    array_multisort($data['payment_methods'], SORT_NUMERIC, $payment_method_name_column, SORT_DESC);
                }
            }
        }

        $total_payment_methods = count($data['payment_methods']);

        $data['payment_methods'] = array_slice($data['payment_methods'], $start, $limit);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_code'])) {
            $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        // sort
        $data['sort_payment_method_name'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_method_name' . $url, true);
        $data['sort_sql_code'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=sql_code' . $url, true);
        $data['sort_sql_accounting_code'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=sql_accounting_code' . $url, true);
        $data['sort_status'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_sort_order'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $url, true);
        $data['sort_date_modify'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . '&sort=date_modify' . $url, true);


        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_code'])) {
            $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_payment_methods;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_payment_methods) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_payment_methods - $this->config->get('config_limit_admin'))) ? $total_payment_methods : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_payment_methods, ceil($total_payment_methods / $this->config->get('config_limit_admin')));

        $data['filter_payment_method_name'] = $filter_payment_method_name;
        $data['filter_sql_accounting_code'] = $filter_sql_accounting_code;
        $data['filter_sql_code'] = $filter_sql_code;
        $data['filter_status'] = $filter_status;

        $data['button_validate'] = false;
        if ($this->user->hasPermission('modify', 'sale/customer_payment_method')) {
            $data['button_validate'] = true;
        }

        

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/customer_payment_method_list', $data));
    }

    protected function getForm() {
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['payment_method_name'])) {
            $data['error_payment_method_name'] = $this->error['payment_method_name'];
        } else {
            $data['error_payment_method_name'] = [];
        }

        if (isset($this->error['sql_code'])) {
            $data['error_sql_accounting_code'] = $this->error['sql_code'];
        } else {
            $data['error_sql_accounting_code'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_payment_method_name'])) {
            $url .= '&filter_payment_method_name=' . urlencode(html_entity_decode($this->request->get['filter_payment_method_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_accounting_code'])) {
            $url .= '&filter_sql_accounting_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_accounting_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_sql_code'])) {
            $url .= '&filter_sql_code=' . urlencode(html_entity_decode($this->request->get['filter_sql_code'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['customer_payment_method_id'])) {
            $data['action'] = $this->url->link('sale/customer_payment_method/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        }else {
            $data['action'] = $this->url->link('sale/customer_payment_method/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_payment_method_id=' . $this->request->get['customer_payment_method_id'] . $url, true);
      
        }
           

        $data['cancel'] = $this->url->link('sale/customer_payment_method', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['customer_payment_method_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $payment_method_info = $this->model_sale_customer_payment_method->getCustomerPaymentMethod($this->request->get['customer_payment_method_id']);
            $payment_method_info_name = $this->model_sale_customer_payment_method->getCustomerPaymentMethodname($this->request->get['customer_payment_method_id']);

        }


        $data['text_form'] = isset($this->request->get['customer_payment_method_id']) ? $this->language->get('text_edit') : $this->language->get('text_add');

        if (isset($this->request->post['payment_method_name'])) {
            $data['payment_method_name'] = $this->request->post['payment_method_name'];
        } elseif (!empty($payment_method_info)) {
            $data['payment_method_name'] = $payment_method_info_name;
        } else {
            $data['payment_method_name'] = [];
        }

        if (isset($this->request->post['sql_accounting_code'])) {
            $data['sql_accounting_code'] = $this->request->post['sql_accounting_code'];
        } elseif (!empty($payment_method_info)) {
            $data['sql_accounting_code'] = $payment_method_info['sql_accounting_code'];
        } else {
            $data['sql_accounting_code'] = '';
        }

        if (isset($this->request->post['sql_code'])) {
            $data['sql_code'] = $this->request->post['sql_code'];
        } elseif (!empty($payment_method_info)) {
            $data['sql_code'] = $payment_method_info['code'];
        } else {
            $data['sql_code'] = '';
        }


        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($payment_method_info)) {
            $data['status'] = $payment_method_info['status'];
        } else {
            $data['status'] = '';
        }

        if (isset($this->request->post['sort_order'])) {
            $data['sort_order'] = $this->request->post['sort_order'];
        } elseif (!empty($payment_method_info)) {
            $data['sort_order'] = $payment_method_info['sort_order'];
        } else {
            $data['sort_order'] = '';
        }

        if (isset($this->request->post['default'])) {
            $data['default'] = $this->request->post['default'];
        } elseif (!empty($payment_method_info)) {
            $data['default'] = $payment_method_info['default'];
        } else {
            $data['default'] = '';
        }

        if (isset($this->request->post['date_added'])) {
            $data['date_added'] = $this->request->post['date_added'];
        } elseif (!empty($payment_method_info)) {
            $data['date_added'] = $payment_method_info['date_added'];
        } else {
            $data['date_added'] = '';
        }


        $data['button_validate'] = false;
        if ($this->user->hasPermission('modify', 'sale/customer_payment_method')) {
            $data['button_validate'] = true;
        }

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/customer_payment_method_form', $data));
    }

    protected function validateForm() {

        $results = $this->model_sale_customer_payment_method->getcode();

        if (!$this->user->hasPermission('modify', 'sale/customer_payment_method')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['payment_method_name'] as $language_id => $name) {
            if (empty($name)) {
                $this->error['payment_method_name'][$language_id] = $this->language->get('error_payment_method_name');
            }
        }
        
        foreach ($results as $result){

            if ($this->request->post['sql_code'] == $result['code']){
                $this->error['sql_code'] = $this->language->get('error_sql_code_duplicated');
            }
        }
        if (empty($this->request->post['sql_code'])) {
            $this->error['sql_code'] = $this->language->get('error_sql_accounting_code');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function editvalidateForm() {

        $this->load->model('sale/customer_payment_method');

        $results = $this->model_sale_customer_payment_method->getcode();
        $allows = $this->model_sale_customer_payment_method->getallowdeleted($this->request->get['customer_payment_method_id']);

        if (!$this->user->hasPermission('modify', 'sale/customer_payment_method')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (isset($this->request->post['payment_method_name']) == '') {
          
                $this->error['payment_method_name'] = $this->language->get('error_payment_method_name');
            
        }

        foreach($allows as $allow){
            if($allow['allow_deleted'] == 0){
                $this->error['warning'] = $this->language->get('error_not_allow_edit');
            }
        }
        
       
        if (empty($this->request->post['sql_code'])) {
            $this->error['sql_code'] = $this->language->get('error_sql_accounting_code');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function validateDelete($customer_payment_method_id) {
        $this->load->model('sale/customer_payment_method');
        // foreach ($customer_payment_method_ids as $customer_payment_method_id) {

        $results = $this->model_sale_customer_payment_method->getallowdeleted($customer_payment_method_id);
        // }
        $payments = $this->model_sale_customer_payment_method->getorder();

        if (!$this->user->hasPermission('modify', 'sale/customer_payment_method')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        

      foreach($results as $result){
        if($result['default'] == 1 ){
            $this->error['warning'] = $this->language->get('error_not_allow_delete');
        }
        if($result['allow_deleted'] == 0){
            $this->error['warning'] = $this->language->get('error_not_allow_delete');
        }
      }

      if(isset($this->request->get['sql_code'])){
      foreach($payments as $payment){
      if($this->request->get['sql_code'] == $payment['payment_method']){
        $this->error['warning'] = $this->language->get('error_using_payment');
      }
    }
    }

        return !$this->error;
    }

    public function default_data(){

        $this->load->model('sale/customer_payment_method');

        $payment_id = null;
		if (isset($this->request->post['payment_id'])) {
			$payment_id = $this->request->post['payment_id'];
		}
        
        $this->model_sale_customer_payment_method->editCustomerPaymentMethodDefault($payment_id);
        
    }

    public function enabled_data(){

        $this->load->model('sale/customer_payment_method');

        $payment_id = null;
		if (isset($this->request->post['payment_id'])) {
			$payment_id = $this->request->post['payment_id'];
		}
        
        $this->model_sale_customer_payment_method->editCustomerPaymentMethodEnabled($payment_id);
        
    }

    public function disabled_data(){

        $this->load->model('sale/customer_payment_method');

        $payment_id = null;
		if (isset($this->request->post['payment_id'])) {
			$payment_id = $this->request->post['payment_id'];
		}
        
        $this->model_sale_customer_payment_method->editCustomerPaymentMethodDisabled($payment_id);
        
    }

    public function delete_data(){
        $this->load->model('sale/customer_payment_method');

        $payment_id = null;
		if (isset($this->request->post['payment_id'])) {
			$payment_id = $this->request->post['payment_id'];
		}

        $this->model_sale_customer_payment_method->deleteCustomerPaymentMethod($payment_id);
    }

}

?>