<?php
class ControllerReportTopup extends Controller {
	public function index() {
		$this->load->language('report/topup');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/topup');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_customername'])) {
			$filter_customername = $this->request->get['filter_customername'];
		} else {
			$filter_customername = NULL;
		}
		
		if (isset($this->request->get['filter_customeric'])) {
			$filter_customeric = $this->request->get['filter_customeric'];
		} else {
			$filter_customeric = NULL;
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_action'])) {
			$filter_action = $this->request->get['filter_action'];
		} else {
			$filter_action = NULL;
		}
		
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_customername'])) {
			$url .= '&filter_customername=' . $this->request->get['filter_customername'];
		}
		
		if (isset($this->request->get['filter_customeric'])) {
			$url .= '&filter_customeric=' . $this->request->get['filter_customeric'];
		}
		
		if (isset($this->request->get['filter_action'])) {
			$url .= '&filter_action=' . $this->request->get['filter_action'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/topup', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/topup/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_customername'   => $filter_customername,
			'filter_customeric'     => $filter_customeric,
			'filter_action'         => $filter_action,
			'filter_store_id' 		=> $filter_store_id,
			'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start']   = $filter_date_start;
		$data['filter_date_end']     = $filter_date_end;
		$data['filter_customername'] = $filter_customername;
		$data['filter_action']       = $filter_action;
		$data['filter_customeric']   = $filter_customeric;
		$data['filter_store_id']     = $filter_store_id;
		
		
		//**data
		$data['user_view'] = $this->user->user_view;
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$data['topup'] = array();
		$topup = $this->model_report_topup->getTopupSummary($filter_data);
		foreach($topup as $topup){
			$data['topup'][] = array(
				'date' => date('Y-m-d', strtotime($topup['date'])),
				'name' => $topup['firstname'] .' '.$topup['lastname'],
				'customer_ic' => $topup['customer_ic'],
				'telephone' => $topup['telephone'],
				'customer_card' => $topup['customer_card'],
				'amout' => $this->currency->format($topup['amount'],$this->config->get('config_currency')),
				'description' => $topup['description'],
			);
			
		}
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_action'])) {
			$querystringforsort .= '&filter_action=' . $this->request->get['filter_action'];
		}
		
		if (isset($this->request->get['filter_customername'])) {
			$querystringforsort .= '&filter_customername=' . $this->request->get['filter_customername'];
		}
		
		if (isset($this->request->get['filter_customeric'])) {
			$querystringforsort .= '&filter_customeric=' . $this->request->get['filter_customeric'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_date'] = $this->url->link('report/topup', 'user_token=' . $this->session->data['user_token'] . '&sort=ct.date_added' . $querystringforsort, true);
		$data['sort_firstname'] = $this->url->link('report/topup', 'user_token=' . $this->session->data['user_token'] . '&sort=cc.firstname' . $querystringforsort, true);
		$data['sort_customer_ic'] = $this->url->link('report/topup', 'user_token=' . $this->session->data['user_token'] . '&sort=cc.customer_ic' . $querystringforsort, true);
		$data['sort_amount'] = $this->url->link('report/topup', 'user_token=' . $this->session->data['user_token'] . '&sort=ct.amount' . $querystringforsort, true);
		
		//**language
		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_list'] = $this->language->get('text_list');
		
		$data['text_all_store'] = $this->language->get('text_all_store');
		
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_all'] = $this->language->get('text_all');
		
		$data['entry_date_start'] = $this->language->get('entry_date_start');
		$data['entry_date_end'] = $this->language->get('entry_date_end');
		$data['entry_store'] = $this->language->get('entry_store');
		$data['entry_customername'] = $this->language->get('entry_customername');
		$data['entry_customeric'] = $this->language->get('entry_customeric');
		$data['entry_action'] = $this->language->get('entry_action');
		
		$data['button_filter'] = $this->language->get('button_filter');
		$data['button_export_excel'] = $this->language->get('button_export_excel');
		
		$data['column_date'] = $this->language->get('column_date');
		$data['column_customername'] = $this->language->get('column_customername');
		$data['column_customeric'] = $this->language->get('column_customeric');
		$data['column_customerphone'] = $this->language->get('column_customerphone');
		$data['column_customerremark'] = $this->language->get('column_customerremark');
		$data['column_customeramount'] = $this->language->get('column_customeramount');

		$data['text_total_herbal_remedies'] = $this->language->get('text_total_herbal_remedies');
		$data['text_total_service_form'] = $this->language->get('text_total_service_form');
		$data['text_total_pos'] = $this->language->get('text_total_pos');
		$data['text_total_subtotal'] = $this->language->get('text_total_subtotal');
		$data['text_total_tax'] = $this->language->get('text_total_tax');
		$data['text_total'] = $this->language->get('text_total');
		$data['text_add'] = $this->language->get('text_add');
		$data['text_drop'] = $this->language->get('text_drop');
		$data['text_all'] = $this->language->get('text_all');
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		
		if (isset($this->request->get['filter_customername'])) {
			$url .= '&filter_customername=' . $this->request->get['filter_customername'];
		}
		
		if (isset($this->request->get['filter_customeric'])) {
			$url .= '&filter_customeric=' . $this->request->get['filter_customeric'];
		}
		
		if (isset($this->request->get['filter_action'])) {
			$url .= '&filter_action=' . $this->request->get['filter_action'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total = $this->model_report_topup->getTopupSummaryTotal($filter_data);
		$total_topup_result = $total['total'];
		
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_topup_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_topup_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_topup_result - $this->config->get('config_limit_admin'))) ? $total_topup_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_topup_result, ceil($total_topup_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/topup', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/topup');
		$this->load->language('report/topup');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_customername'])) {
			$filter_customername = $this->request->get['filter_customername'];
		} else {
			$filter_customername = NULL;
		}
		
		if (isset($this->request->get['filter_customeric'])) {
			$filter_customeric = $this->request->get['filter_customeric'];
		} else {
			$filter_customeric = NULL;
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_action'])) {
			$filter_action = $this->request->get['filter_action'];
		} else {
			$filter_action = NULL;
		}
		
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_customername'   => $filter_customername,
			'filter_customeric'     => $filter_customeric,
			'filter_action'         => $filter_action,
			'filter_store_id' 		=> $filter_store_id,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$topup = $this->model_report_topup->getTopupSummary($filter_data);
		
		$table_collection = array();
		
		foreach($topup as $topup){
			$table_collection[] = array(
				'date' => date('Y-m-d', strtotime($topup['date'])),
				'name' => $topup['firstname'] .' '.$topup['lastname'],
				'customer_ic' => $topup['customer_ic'],
				'telephone' => $topup['telephone'],
				'description' => $topup['description'],
				'amout' => $this->currency->format($topup['amount'],$this->config->get('config_currency'), '', false)
				
			);
			
		}
		
		$table = array();
		/*
		$table[] = array("Total Herbal Remedies" 	, '');
		$table[] = array("Total Service Form" 		, '');
		$table[] = array("Total Product Form POS" 	, '');
		$table[] = array("Total Subtotal" 			,'');
		$table[] = array("Total GST" 				, '');
		$table[] = array("Total" 					, '');
		
		$table[] = array(); // add a space
		*/
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		$table_header = array(//table headers
			$this->language->get('column_date'),
			$this->language->get('column_customername'),
			$this->language->get('column_customeric'),
			$this->language->get('column_customerphone'),
			$this->language->get('column_customerremark'),
			$this->language->get('column_customeramount')
		);
		$table[] = $table_header;//add header to table
		
		$total_row = 0;
		
		$table_data = $table_collection;
		$row;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			
			$total_row ++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		
		$customer_ic_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($customer_ic_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>