<?php
class ControllerReportSaleTransaction extends Controller {
	public function index() {
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

		$msc = microtime(true);
		$this->load->language('report/sale_transaction');

		$this->document->setTitle($this->language->get('heading_title'));

		$url = $this->getFilterUrl();

		$data['breadcrumbs'] = [];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		];

		$data['breadcrumbs'][] = [
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/sale_transaction', 'user_token=' . $this->session->data['user_token'] . $url, true)
		];

		//urls
		$data['export_excel'] = $this->url->link('report/sale_transaction/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		$data['export_duplicate'] = $this->url->link('report/sale_transaction/exportExcelDuplicate', 'user_token=' . $this->session->data['user_token'], true);

		$this->load->model('report/sale_transaction');

		$data['orders'] = [];
		$orders = [];

		$filter_data = $this->getFiltersData();
		$filter_data_with_pagination = $this->getFiltersData(true);

		$total_transactions = $this->model_report_sale_transaction->getTotalTransaction($filter_data);
		$transactions = $this->model_report_sale_transaction->getTransaction($filter_data_with_pagination);

		$data['check_duplicates'] = $this->model_report_sale_transaction->checkduplicate();

		$filter_data_date = array(
			'year_start'					=>date('Y-01-01'),
			'year_end'						=>date('Y-12-31'),

		);

		$orders = $this->model_report_sale_transaction->getInvoiceNotSequence($filter_data_date);
		$previousOrders = null;

		$pagenumber=0;
		foreach ($orders as $order) {
			if ($previousOrders) {
				if ($this->checkInvoiceInSequence($order, $previousOrders)) {
					$pagenumber++;
				}
			}
			$previousOrders = $order;
		}
		$data['number_invoice'] = $pagenumber;


		// Total Sales & Customer Count
		$total_transaction 	= !empty($total_transactions['total_orders']) ? $total_transactions['total_orders'] : 0;
		$total_customers 	=  0;
		$walkin_customers 	= !empty($total_transactions['walkin_customers']) ? $total_transactions['walkin_customers'] : 0;
		$members 	        = !empty($total_transactions['members']) ? $total_transactions['members'] : 0;
		$total_customers    = $walkin_customers + $members;

		// Totals Pricing
		$total_herbal1 			= !empty($total_transactions['medicine_total1']) ? $total_transactions['medicine_total1'] : 0;
		$total_herbal2 			= !empty($total_transactions['medicine_total2']) ? $total_transactions['medicine_total2'] : 0;
		$total_consultation     = !empty($total_transactions['consultation_total']) ? $total_transactions['consultation_total'] : 0;
		$total_medical          = !empty($total_transactions['medical_total']) ? $total_transactions['medical_total'] : 0;
		$total_service          = !empty($total_transactions['service_total']) ? $total_transactions['service_total'] : 0;
		$tottal_service_charge  = !empty($total_transactions['service_charge']) ? $total_transactions['service_charge'] : 0;
		$total_pos         		= !empty($total_transactions['pos_total']) ? $total_transactions['pos_total'] : 0;
		$total_subtotal        	= !empty($total_transactions['subtotal']) ? $total_transactions['subtotal'] : 0;
		$total_shipping        	= !empty($total_transactions['shipping']) ? $total_transactions['shipping'] : 0;
		$total_tax         	   	= !empty($total_transactions['tax']) ? $total_transactions['tax'] : 0;
		$total_rounding			= !empty($total_transactions['rounding']) ? $total_transactions['rounding'] : 0;
		$total_sales         	= !empty($total_transactions['total']) ? $total_transactions['total'] : 0;
		$total_member_amount    = !empty($total_transactions['total_member_amount']) ? $total_transactions['total_member_amount'] : 0;
		$total_walkin_amount    = !empty($total_transactions['total_walkin_amount']) ? $total_transactions['total_walkin_amount'] : 0;

		$total_herbal = 0;
		$total_herbal = (float)($total_herbal1 + $total_herbal2);
		$total_payment_total = 0;
		$total_payment_total = $total_medical + $total_service + $total_pos;

		$total_payment_checked = false;
		$formatted_total_subtotal = $this->currency->format($total_subtotal, $this->config->get('config_currency'));
		$formatted__total_payment_total = $this->currency->format($total_payment_total, $this->config->get('config_currency'));

		if (strcmp($formatted_total_subtotal, $formatted__total_payment_total) == 0) {
			$total_payment_checked = true;
		}

		$total_member_percentage  = 0;
		$total_walkin_percentage  = 0;
		$total_customers_percentage = 0;
		if (!empty($total_sales)) {
			$total_member_percentage    = round(((float)$total_member_amount / (float)$total_sales) * 100, 2);
			$total_walkin_percentage    = round(((float)$total_walkin_amount / (float)$total_sales) * 100, 2);
			$total_customers_percentage = round(((float)$total_sales / (float)$total_sales) * 100, 2);
		}
		$total_members_percentage_text          = $total_member_percentage . '%';
		$total_walkin_customers_percentage_text = $total_walkin_percentage . '%';
		$total_customers_percentage_text        = $total_customers_percentage . '%';

		$data['total_payment_checked']  = $total_payment_checked;
		$data['total_customers']        = $total_customers;
		$data['total_members']          = $members;
		$data['total_walkin_customers'] = $walkin_customers;

		$total_members_count_percentage   = 0;
		$total_walkin_count_percentage    = 0;
		$total_customers_count_percentage = 0;
		if (!empty($total_customers)) {
			$total_customers_count_percentage = round(((float)$total_customers / (float)$total_customers) * 100, 2);
			$total_walkin_count_percentage    = round(((float)$walkin_customers / (float)$total_customers) * 100, 2);
			$total_members_count_percentage   = round(((float)$members / (float)$total_customers) * 100, 2);
		}
		$total_members_count_percentage_text     = $total_members_count_percentage . '%';
		$total_walkin_customers_percentage_text	= $total_walkin_count_percentage . '%';
		$total_customers_count_percentage_text  = $total_customers_count_percentage . '%';

		$data['total_members_count_percentage_text']   = $total_members_count_percentage_text;
		$data['total_walkin_count_percentage_text']    = $total_walkin_customers_percentage_text;
		$data['total_customers_count_percentage_text'] = $total_customers_count_percentage_text;

		foreach ($transactions as $transaction) {
			$herbal_consultation    = 0;
			$medical_record_checked = false;
			$payment_total          = 0;
			$payment_total_checked  = false;

			$order_id 				= !empty($transaction['order_id']) ? $transaction['order_id'] : 0;
			$invoice_prefix 		= !empty($transaction['invoice_prefix']) ? $transaction['invoice_prefix'] : '';
			$invoice_date 			= !empty($transaction['invoice_date']) ? $transaction['invoice_date'] : '';
			$customer_id 			= !empty($transaction['customer_id']) ? $transaction['customer_id'] : 0;
			$customer_name 			= !empty($transaction['customer_name']) ? $transaction['customer_name'] : '';
			$customer_ic 			= !empty($transaction['customer_ic']) ? $transaction['customer_ic'] : '';
			$customer_email 		= !empty($transaction['email']) ? $transaction['email'] : '';
			$customer_telephone 	= !empty($transaction['telephone']) ? $transaction['telephone'] : '';
			$customer_group 		= !empty($transaction['customer_group']) ? $transaction['customer_group'] : '';
			$customer_type 			= !empty($transaction['customer_type']) ? $transaction['customer_type'] : '';
			$order_status_id 		= !empty($transaction['order_status_id']) ? $transaction['order_status_id'] : 0;
			$order_status_name 		= !empty($transaction['order_status_name']) ? $transaction['order_status_name'] : '';
			$herbal_total1 			= !empty($transaction['medicine_total1']) ? $transaction['medicine_total1'] : 0;
			$herbal_total2 			= !empty($transaction['medicine_total2']) ? $transaction['medicine_total2'] : 0;
			$consultation_total 	= !empty($transaction['consultation_total']) ? $transaction['consultation_total'] : 0;
			$medical_record_total 	= !empty($transaction['medical_record_total']) ? $transaction['medical_record_total'] : 0;
			$service_charge			= !empty($transaction['service_charge']) ? $transaction['service_charge'] : 0;
			$service_total 			= !empty($transaction['service_total']) ? $transaction['service_total'] : 0;
			$pos_selling 			= !empty($transaction['pos_selling']) ? $transaction['pos_selling'] : 0;
			$subtotal 				= !empty($transaction['subtotal']) ? $transaction['subtotal'] : 0;
			$shipping 				= !empty($transaction['shipping']) ? $transaction['shipping'] : 0;
			$tax 					= !empty($transaction['tax']) ? $transaction['tax'] : 0;
			$rounding 				= !empty($transaction['rounding']) ? $transaction['rounding'] : 0;
			$total 					= !empty($transaction['total']) ? $transaction['total'] : 0;
			$comment 				= !empty($transaction['comment']) ? $transaction['comment'] : '';
			$payment_method 		= !empty($transaction['payment_method']) ? $transaction['payment_method'] : '';

			if ($customer_type == '1') {
				$customer_type_text = $this->language->get('text_walk_in_customer');
			} elseif ($customer_type == 2) {
				$customer_type_text = $this->language->get('text_customer');
			} else {
				$customer_type_text = 'Invalid Customer Type';
			}

			$order_status_label = '';
			switch ($order_status_id) {
				case 1:
					$order_status_label = 'warning';
					break;
				case 5:
					$order_status_label = 'success';
					break;
				case 7:
				case 17:
					$order_status_label = 'danger';
					break;
			}

			$herbal_total = 0;
			$herbal_total = $herbal_total1 + $herbal_total2;

			$herbal_consultation = $herbal_total + $consultation_total;

			if ((float)$medical_record_total == (float)$herbal_consultation) {
				$medical_record_checked = true;
			}

			$payment_total = $medical_record_total + $service_total + $pos_selling;

			$formatted_subtotal = $this->currency->format($subtotal, $this->config->get('config_currency'));
			$formatted_payment_total = $this->currency->format($payment_total, $this->config->get('config_currency'));

			if (strcmp($formatted_subtotal, $formatted_payment_total) == 0) {
				$payment_total_checked = true;
			}

			$data['orders'][] = [
				'invoice_prefix' 			=> $invoice_prefix,
				'invoice_date'   			=> date('D, d M Y H:i', strtotime($invoice_date)),
				'customer_name'   			=> $customer_name,
				'customer_ic'               => $customer_ic,
				'customer_email'            => $customer_email,
				'customer_telephone'        => $customer_telephone,
				'customer_group' 			=> $customer_group,
				'customer_type'     		=> $customer_type,
				'status'					=> $order_status_name,
				'order_status_id'			=> (int)$order_status_id,
				'comment'					=> $comment,
				'label'						=> $order_status_label,
				'herbal'					=> $this->currency->format($herbal_total, $this->config->get('config_currency')),
				'consultation'				=> $this->currency->format($consultation_total, $this->config->get('config_currency')),
				'medical_record_checked' 	=> $medical_record_checked,
				'medical_record'    		=> $this->currency->format($medical_record_total, $this->config->get('config_currency')),
				'service'					=> $this->currency->format($service_total, $this->config->get('config_currency')),
				'pos'						=> $this->currency->format($pos_selling, $this->config->get('config_currency')),
				'payment_method'    		=> $payment_method,
				'service_charge'			=> $this->currency->format($service_charge, $this->config->get('config_currency')),
				'cstotal'					=> $this->currency->format($medical_record_total, $this->config->get('config_currency')),
				'sftotal'					=> $this->currency->format($service_total, $this->config->get('config_currency')),
				'pos_selling'				=> $this->currency->format($pos_selling, $this->config->get('config_currency')),
				'payment_total'				=> $this->currency->format($payment_total, $this->config->get('config_currency')),
				'payment_total_checked' 	=> $payment_total_checked,
				'subtotal'					=> $this->currency->format($subtotal, $this->config->get('config_currency')),
				'shipping'					=> $this->currency->format($shipping, $this->config->get('config_currency')),
				'rounding'					=> $this->currency->format($rounding, $this->config->get('config_currency')),
				'tax'        				=> $this->currency->format($tax, $this->config->get('config_currency')),
				'total'      				=> $this->currency->format($total, $this->config->get('config_currency')),
				'info' 						=> $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int)$order_id, true),
				'customer_info' 			=>  $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id_id=' . (int)$customer_id, true),
			];
		}

		$data['total_member_percentage']   = $total_members_percentage_text;
		$data['total_walkin_percentage']   = $total_walkin_customers_percentage_text;
		$data['total_customer_percentage'] = $total_customers_percentage_text;
		$data['total_member_amount'] = $this->currency->format($total_member_amount, $this->config->get('config_currency'));
		$data['total_walkin_amount'] = $this->currency->format($total_walkin_amount, $this->config->get('config_currency'));

		$data['total_herbal'] = $this->currency->format($total_herbal, $this->config->get('config_currency'));
		$data['total_consultation'] = $this->currency->format($total_consultation, $this->config->get('config_currency'));
		$data['total_service'] = $this->currency->format($total_service, $this->config->get('config_currency'));
		$data['total_pos'] = $this->currency->format($total_pos, $this->config->get('config_currency'));
		$data['tottal_service_charge'] = $this->currency->format($tottal_service_charge, $this->config->get('config_currency'));
		
		$data['total_tax'] = $this->currency->format($total_tax, $this->config->get('config_currency'));
		$data['total_shipping'] = $this->currency->format($total_shipping, $this->config->get('config_currency'));
		$data['total_rounding'] = $this->currency->format($total_rounding, $this->config->get('config_currency'));
		$data['total_subtotal'] = $this->currency->format($total_subtotal, $this->config->get('config_currency'));
		$data['total_sales'] = $this->currency->format($total_sales, $this->config->get('config_currency'));

		$data['currency_format'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));

		$data['user_token'] = $this->session->data['user_token'];

		$page = $filter_data['page'];
		$data['sort'] = $filter_data['sort'];
		$data['order'] = $filter_data['order'];

		$data['filter_date_type']        = $filter_data['filter_date_type'];
		$data['filter_date_start']        = $filter_data['filter_date_start'];
		$data['filter_date_end']          = $filter_data['filter_date_end'];
		$data['filter_transaction_start'] = $filter_data['filter_transaction_start'];
		$data['filter_transaction_end']   = $filter_data['filter_transaction_end'];
		$data['filter_customer_type']     = explode(',', $filter_data['filter_customer_type']);
		$data['filter_customer_name']     = $filter_data['filter_customer_name'];
		$data['filter_customer_group']    = $filter_data['filter_customer_group'];
		$data['filter_payment_method']    = explode(',', $filter_data['filter_payment_method']);
		$data['filter_comment']           = $filter_data['filter_comment'];
		$data['filter_store_id']          = explode(',', $filter_data['filter_store_id']);
		$data['count']              	  = (($page - 1) * $this->config->get('config_limit_admin'));
		$data['filter_order_status_id']   = explode(',',  $filter_data['filter_order_status_id']);

		// Systsem User Permission
		$data['user_view'] = $this->user->user_view;

		$data['export_excel_permission'] = false;
		if ($this->user->hasPermission('modify', 'report/sale_transaction')) {
			$data['export_excel_permission'] = true;
		}

		$data['order_access_permission'] = false;
		if ($this->user->hasPermission('access', 'sale/order')) {
			$data['order_access_permission'] = true;
		}

		$pagination_url = $this->getFilterUrl(true);

		$pagination = new Pagination();
		$pagination->total = $total_transaction;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sale_transaction', 'user_token=' . $this->session->data['user_token'] . $pagination_url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$this->load->model('setting/store');
		$data['stores'] = [];

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		$data['date_types'] = $this->getDateTypes();

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$data['payment_methods'] = $this->model_report_sale_transaction->getPaymentMethod();

		$this->load->model('sale/customer_group');
		$data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$msc = microtime(true) - $msc;

		$this->response->setOutput($this->load->view('report/sale_transaction', $data));
	}

	public function exportExcel() {
		$this->load->model('report/sale');
		$this->load->model('report/sale_transaction');
		$this->load->language('report/sale_transaction');

		//** filter data
		$filter_data = $this->getFiltersData();
		$filter_date_start = $filter_data['filter_date_start'];
		$filter_date_end   = $filter_data['filter_date_end'];

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setTitle("Title")
			->setSubject("Subject")
			->setDescription("Description")
			->setKeywords("report ptcm.etcm.me webceo")
			->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
			->setSize(11);
		// Table Data

		$table_collection = [];

		//get data collection from database
		$transactions = $this->model_report_sale_transaction->getTransaction($filter_data);
		foreach ($transactions as $transaction) {
			$order_id 				= !empty($transaction['order_id']) ? $transaction['order_id'] : 0;
			$invoice_prefix 		= !empty($transaction['invoice_prefix']) ? $transaction['invoice_prefix'] : '';
			$invoice_date 			= !empty($transaction['invoice_date']) ? $transaction['invoice_date'] : '';
			$customer_id 			= !empty($transaction['customer_id']) ? $transaction['customer_id'] : 0;
			$customer_name 			= !empty($transaction['customer_name']) ? $transaction['customer_name'] : '';
			$customer_card 			= !empty($transaction['customer_card']) ? $transaction['customer_card'] : '';
			$customer_email 		= !empty($transaction['email']) ? $transaction['email'] : '';
			$customer_telephone 	= !empty($transaction['telephone']) ? $transaction['telephone'] : '';
			$customer_group 		= !empty($transaction['customer_group']) ? $transaction['customer_group'] : '';
			$customer_type 			= !empty($transaction['customer_type']) ? $transaction['customer_type'] : '';
			$order_status_id 		= !empty($transaction['order_status_id']) ? $transaction['order_status_id'] : 0;
			$order_status_name 		= !empty($transaction['order_status_name']) ? $transaction['order_status_name'] : '';
			$herbal_total1 			= !empty($transaction['medicine_total1']) ? $transaction['medicine_total1'] : 0;
			$herbal_total2 			= !empty($transaction['medicine_total2']) ? $transaction['medicine_total2'] : 0;
			$herbal_total           = 0;
			$herbal_total           = $herbal_total1 + $herbal_total2;
			$consultation_total 	= !empty($transaction['consultation_total']) ? $transaction['consultation_total'] : 0;
			$medical_record_total 	= !empty($transaction['medical_record_total']) ? $transaction['medical_record_total'] : 0;
			$service_charge			= !empty($transaction['service_charge']) ? $transaction['service_charge'] : 0;
			$service_total 			= !empty($transaction['service_total']) ? $transaction['service_total'] : 0;
			$pos_selling 			= !empty($transaction['pos_selling']) ? $transaction['pos_selling'] : 0;
			$subtotal 				= !empty($transaction['subtotal']) ? $transaction['subtotal'] : 0;
			$shipping 				= !empty($transaction['shipping']) ? $transaction['shipping'] : 0;
			$tax 					= !empty($transaction['tax']) ? $transaction['tax'] : 0;
			$rounding 				= !empty($transaction['rounding']) ? $transaction['rounding'] : 0;
			$total 					= !empty($transaction['total']) ? $transaction['total'] : 0;
			$comment 				= !empty($transaction['comment']) ? $transaction['comment'] : '';
			$payment_method 		= !empty($transaction['payment_method']) ? $transaction['payment_method'] : '';

			$herbals_list 		= !empty($transaction['herbals_prefix']) ? $transaction['herbals_prefix'] : '';
			$services_list 		= !empty($transaction['services_prefix']) ? $transaction['services_prefix'] : '';
			$products_list 		= !empty($transaction['products_prefix']) ? $transaction['products_prefix'] : '';

			$table_collection[] = [
				'order_id'				=> (int)$order_id,
				'invoice_date'      	=> date('Y-m-d', strtotime($invoice_date)),
				'invoice_prefix' 		=> $invoice_prefix,
				'customer_id'			=> $customer_id,
				'customer_name'   		=> $customer_name,
				'customer_group'    	=> $customer_group,
				'customer_card'       	=> $customer_card,
				'cstotal'				=> (float)$herbal_total,
				'consultation'          => (float)$consultation_total,
				'sftotal'				=> (float)$service_total,
				'pos_selling'			=> (float)$pos_selling,
				'subtotal'				=> (float)$subtotal,
				'service_charge'		=> (float)$service_charge,
				'shipping'				=>(float)$shipping, 
				'tax'        			=> (float)$tax,
				'rounding'				=> (float)$rounding,
				'total'      			=> (float)$total,
				'payment_method' 		=> $payment_method,
				'comment'				=> $comment,
				'order_status_name'     => $order_status_name,
				'invoice_time'      	=> date('d M Y H:i', strtotime($invoice_date)),
				'herbals_list'		    => $herbals_list,
				'services_list'		    => $services_list,
				'products_list'         => $products_list
			];
		}

		$total_transactions = $this->model_report_sale_transaction->getTotalTransaction($filter_data);
		$total_herbal 			= !empty($total_transactions['herbal_total']) ? $total_transactions['herbal_total'] : 0;
		$total_consultation     = !empty($total_transactions['consultation_total']) ? $total_transactions['consultation_total'] : 0;
		$total_medical          = !empty($total_transactions['medical_total']) ? $total_transactions['medical_total'] : 0;
		$total_service          = !empty($total_transactions['service_total']) ? $total_transactions['service_total'] : 0;
		$total_pos         		= !empty($total_transactions['pos_total']) ? $total_transactions['pos_total'] : 0;
		$total_service_charge   = !empty($total_transactions['service_charge']) ? $total_transactions['service_charge'] : 0;
		$total_subtotal        	= !empty($total_transactions['subtotal']) ? $total_transactions['subtotal'] : 0;
		$total_shipping        	= !empty($total_transactions['shipping']) ? $total_transactions['shipping'] : 0;
		$total_tax         	   	= !empty($total_transactions['tax']) ? $total_transactions['tax'] : 0;
		$total_rounding			= !empty($total_transactions['rounding']) ? $total_transactions['rounding'] : 0;
		$total_sales         	= !empty($total_transactions['total']) ? $total_transactions['total'] : 0;
		$total_member_amount    = !empty($total_transactions['total_member_amount']) ? $total_transactions['total_member_amount'] : 0;
		$total_walkin_amount    = !empty($total_transactions['total_walkin_amount']) ? $total_transactions['total_walkin_amount'] : 0;

		$total_member_percentage  = 0;
		$total_walkin_percentage  = 0;
		if (!empty($total_sales)) {
			$total_member_percentage    = round(((float)$total_member_amount / (float)$total_sales) * 100, 2);
			$total_walkin_percentage    = round(((float)$total_walkin_amount / (float)$total_sales) * 100, 2);
		}
		$total_members_percentage_text          = $total_member_percentage . '%';
		$total_walkin_customers_percentage_text = $total_walkin_percentage . '%';

		$table_collection[] = [
			'', '', '', '', '', '', '',
			$total_herbal,
			$total_consultation,
			$total_service,
			$total_pos,
			$total_subtotal,
			$total_service_charge,
			$total_shipping,
			$total_tax,
			$total_rounding,
			$total_sales,
			'', '', '', '', '', '', '',
		];

		$table = [];

		$table[] = ['Report Name : ', $this->language->get('heading_title')];
		$table[] = ['Filter Date : ', $filter_date_start, $filter_date_end];

		$table[] = [];
		$table[] = ['Total Sales : ', $total_sales];
		$table[] = ['Member : ', $total_members_percentage_text];
		$table[] = ['Walk In Customer : ', $total_walkin_customers_percentage_text];
		$table[] = ['Member : ', $total_member_amount];
		$table[] = ['Walk In Customer : ', $total_walkin_amount];

		$table[] = []; // add a space

		$table_header = [ //table headers
			'Order ID#',
			'Invoice Date',
			'Invoice Number',
			'Customer ID#',
			'Customer',
			'Customer Group',
			'Member Card No.',
			'Medicine',
			'Consultation',
			'Service',
			'POS/Product Sales',
			'Subtotal',
			'Service Charge',
			'Shipping',
			'Tax(0%)',
			'Rounding',
			'Total',
			'Payment Method',
			'Comment',
			'Order Status',
			'Invoice Creation Time',
			'Herbals List',
			'Services List',
			'Products List',
		];

		$table[] = $table_header; //add header to table
		$total_row = 0;
		$table_data = $table_collection;

		foreach ($table_data as $key => $data) {
			$row = array();
			foreach ($data as $key => $value) {
				$row[] = $value;
			}
			$table[] = $row; //add data row to table

			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach ($table_header as $header) { //loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach ($table_header as $col) $header_index_e_column++;
		$header_index_row = 10;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$textformat_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "000000000000"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($textformat_style); // top

		$currenct_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currenct_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currenct_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currenct_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currenct_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currenct_style);

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	/**
	 * Get all the filetring data and searching data
	 *param @objects
	 * @return void
	 */
	protected function getFiltersData($pagination = false) {
        /** Filters */
        $config_appointment_date_type = !empty($this->config->get('config_order_transaction_list_date_type')) ? $this->config->get('config_order_transaction_list_date_type') : 'today';

        if (isset($this->request->get['filter_date_type'])) {
            $filter_date_type = $this->request->get['filter_date_type'];
        } else {
            $filter_date_type = $config_appointment_date_type;
        }

        $date_from_datetypes = $this->getDateByDateType($filter_date_type);
        $filter_date_start2 = $date_from_datetypes['date_start'];
        $filter_date_end2 = $date_from_datetypes['date_end'];

        if ($filter_date_type != 'custom') {
            $filter_date_start = $filter_date_start2;
        } else if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = null;
        }

        if ($filter_date_type != 'custom') {
            $filter_date_end = $filter_date_end2;
        } else if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = null;
        }

		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}

		if (isset($this->request->get['filter_customer_type'])) {
			$filter_customer_type = $this->request->get['filter_customer_type'];
		} else {
			$filter_customer_type = null;
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$filter_customer_name = $this->request->get['filter_customer_name'];
		} else {
			$filter_customer_name = '';
		}

		if (isset($this->request->get['filter_customer_group'])) {
			$filter_customer_group = $this->request->get['filter_customer_group'];
		} else {
			$filter_customer_group = null;
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = null;
		}

		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = '1,5';
		}

		if (isset($this->request->get['filter_comment'])) {
			$filter_comment = $this->request->get['filter_comment'];
		} else {
			$filter_comment = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date_added';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		$start = null;
		$limit = null;
		if (!empty($pagination)) {
			$start = ($page - 1) * $this->config->get('config_limit_admin');
			$limit =  $this->config->get('config_limit_admin');
		}

		return [
            'filter_date_type'         => $filter_date_type,
            'filter_date_start'        => $filter_date_start,
            'filter_date_end'          => $filter_date_end,
            'filter_transaction_start' => $filter_transaction_start,
            'filter_transaction_end'   => $filter_transaction_end,
            'filter_customer_type'     => $filter_customer_type,
            'filter_customer_name'     => $filter_customer_name,
            'filter_customer_group'    => $filter_customer_group,
            'filter_payment_method'    => $filter_payment_method,
            'filter_store_id'          => $filter_store_id,
            'filter_order_status_id'   => $filter_order_status_id,
            'filter_comment'           => $filter_comment,
            'sort'                     => $sort,
            'order'                    => $order,
            'page'                     => $page,
            'start'                    => $start,
            'limit'                    => $limit,
        ];
	}

	/** Get the url that inclues filters data and search data.
	 * param boolean 
	 * return string
	 * true:  Show all list. (Used for listing count)
	 * false: Not includes, sort, order, and page (Used for listing with pagination)
	 */
	protected function getFilterUrl($all = false) {
		$url = '';
		if (isset($this->request->get['filter_date_type'])) {
			$url .= '&filter_date_type=' . urlencode(html_entity_decode($this->request->get['filter_date_type'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}

		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}

		if (isset($this->request->get['filter_customer_type'])) {
			$url .= '&filter_customer_type=' . $this->request->get['filter_customer_type'];
		}

		if (isset($this->request->get['filter_customer_name'])) {
			$url .= '&filter_customer_name=' . urlencode(html_entity_decode($this->request->get['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_customer_group'])) {
			$url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['filter_comment'])) {
			$url .= '&filter_comment=' . urlencode(html_entity_decode($this->request->get['filter_comment'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (empty($all)) {
			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}
		}

		return $url;
	}

	/** Get Start Date and End Date Based on Date Type
	 * param @string
	 * return @ array (
	 * @ date/time $start_date
	 * @ date/time $end_date )
	 */
	protected function getDateByDateType($type) {
		date_default_timezone_set("Asia/Kuala_Lumpur");
		$date = [];
		switch ($type) {
			case 'today':
				$start_date = date('Y-m-d');
				$end_date   = date('Y-m-d');
				break;
			case 'yesterday':
				$start_date = date('Y-m-d', strtotime(' - 1days'));
				$end_date   = date('Y-m-d', strtotime(' - 1days'));
				break;
			case 'past':
				$start_date = '';
				$end_date   = date('Y-m-d');
				break;
			case 'this_week':
				$start_date = date('Y-m-d', strtotime('Monday this week'));
				$end_date   = date('Y-m-d', strtotime('Sunday this week'));
				break;
			case 'this_month':
				$start_date = date('Y-m-d', strtotime('first day of this month'));
				$end_date   = date('Y-m-d', strtotime('last day of this month'));
				break;
			case 'this_year':
				$start_date = date('Y-m-d', strtotime('first day of January ' . date('Y')));
				$end_date   = date('Y-m-d', strtotime('last day of December ' . date('Y')));
				break;
			case 'last7days':
				$start_date = date('Y-m-d', strtotime(' - 7 days'));
				$end_date   = date('Y-m-d');
				break;
			case 'last30days':
				$start_date = date('Y-m-d', strtotime(' - 30 days'));
				$end_date   = date('Y-m-d');
				break;
			case 'last90days':
				$start_date = date('Y-m-d', strtotime(' - 90 days'));
				$end_date   = date('Y-m-d');
				break;
			case 'last1year':
				$start_date = date('Y-m-d', strtotime(' - 1 year'));
				$end_date   = date('Y-m-d');
				break;
			case 'last5year':
				$start_date = date('Y-m-d', strtotime(' - 5 year'));
				$end_date   = date('Y-m-d');
				break;
			case 'last_year_this_year':
				$start_date = date('Y-m-d', strtotime(' - 1 year'));
				$end_date   = date('Y-m-d', strtotime('last day of December ' . date('Y')));
				break;
			case 'all':
				$start_date = '';
				$end_date   = '';
				break;
			default:
				$start_date = date('Y-m-d');
				$end_date   = date('Y-m-d');
		}

		$date = [
			'date_start' => $start_date,
			'date_end'   => $end_date,
		];
		return $date;
	}

	/** Get All Date Types (Default date types set at here)
	 * return @ array (
	 * @ string $name, $code )
	 */
	protected function getDateTypes() {
		$this->language->load('report/sale_transaction');
		$result = [
			array(
				'name' => 'Today',
				'code' => 'today'
			),
			array(
				'name' => 'Yesterday',
				'code' => 'yesterday'
			),
			array(
				'name' => 'This Week',
				'code' => 'this_week'
			),
			array(
				'name' => 'This Month',
				'code' => 'this_month'
			),
			array(
				'name' => 'This Year',
				'code' => 'this_year'
			),
			array(
				'name' => 'Year to date (YTD)',
				'code' => 'last_year_this_year'
			),
			array(
				'name' => 'Last 7 days',
				'code' => 'last7days'
			),
			array(
				'name' => 'Last 30 days',
				'code' => 'last30days'
			),
			array(
				'name' => 'Last 90 days',
				'code' => 'last90days'
			),
			array(
                'name' => 'Last 1 years',
                'code' => 'last1year'
            ),
            array(
                'name' => 'Last 5 years',
                'code' => 'last5year'
            ),
			array(
				'name' => 'All Time',
				'code' => 'all'
			),
			array(
				'name' => 'Custom',
				'code' => 'custom'
			)
		];
		return $result;
	}

	public function getDuplicateInvoices(){
        $this->load->language('report/sale_transaction');

        $this->load->model('report/sale_transaction');
  
        $product_name = isset($this->request->get['filter_product_name']) ? $this->request->get['filter_product_name'] : '';
        $product_code = isset($this->request->get['filter_product_code']) ? $this->request->get['filter_product_code'] : '';
        
        $filter = ['filter_product_name' => $product_name,  'filter_product_code' => $product_code];

        $data['product_name'] = $product_name;
        $data['product_code'] = $product_code;


        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

		$filter_data = array(
			'start'                  		=> ($page - 1) * 10,
			'limit'                  		=> 10
		);

        $orders= $this->model_report_sale_transaction->duplicatelist($filter_data);

        foreach($orders as $order){
            // echo"<pre>";
            // print_r($order_product);
            // echo"</pre>";
            $data['products'][] = array(
                'order_id'          => $order['order_id'],
                'invoice_prefix'            => $order['invoice_prefix'],
                'customer'			=> $order['customer'],
				'total'           => $this->currency->format($order['total'], $this->config->get('config_currency')),
                'payment_method'  => $order['payment_method'],
                'date_added'    => $order['date_added'],
                'invoice_date'    => $order['invoice_date'],
                'comment'    => $order['comment'],

                );
        }


        $total_order_product = $this->model_report_sale_transaction->duplicatelist_total();

        $pagination = new Pagination();
        $pagination->total = $total_order_product;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('report/sale_transaction/getDuplicateInvoices', 'user_token=' . $this->session->data['user_token'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_order_product) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($total_order_product - 10)) ? $total_order_product : ((($page - 1) * 10) + 10), $total_order_product, ceil($total_order_product / 10));



        

        $this->response->setOutput($this->load->view('report/sale_transaction_duplicate_list', $data));

    }

	public function exportExcelDuplicate()
	{

		$this->load->model('report/sale_transaction');
		$this->load->language('report/sale_transaction');

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$filter_data = array(
			
		);

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setTitle("Title")
			->setSubject("Subject")
			->setDescription("Description")
			->setKeywords("report ptcm.etcm.me webceo")
			->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
			->setSize(10);
		// Table Data

		//get data collection from database

		$table_collection = array();
		$orders= $this->model_report_sale_transaction->duplicatelist($filter_data);
		foreach($orders as $order){
            // echo"<pre>";
            // print_r($order_product);
            // echo"</pre>";
			$table_collection[] = array(
                'order_id'          => $order['order_id'],
                'invoice_prefix'            => $order['invoice_prefix'],
                'customer'			=> $order['customer'],
                'total'           => $this->currency->format($order['total'], $this->config->get('config_currency')),
                'payment_method'  => $order['payment_method'],
                'date_added'    => $order['date_added'],
                'invoice_date'    => $order['invoice_date'],
                'comment'    => $order['comment'],

                );
        }

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));

		$table[] = array(); // add a space
		$table[] = array();
		//$table[] = array('Report Details : ');

		$table_header = array( //table headers
			$this->language->get('column_order_id'),
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_customer_name'),
			$this->language->get('column_total'),
			$this->language->get('column_payment_method'),
			$this->language->get('column_date_added'),
			$this->language->get('column_invoice_date'),
			$this->language->get('column_comment')
		);
		$table[] = $table_header; //add header to table
		
		$table_data = $table_collection;
		$row = 0;
		$total_row = 0;
		foreach ($table_data as $key => $data) {
			$row = array();
			foreach ($data as $key => $value) {
				$row[] = $value;
			}
			$table[] = $row; //add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach ($table_header as $header) { //loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach ($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
	
		
		//debug test
		//$table = array("one", "two", "three");

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title');

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function getInviceNotInSequence() {

		$this->load->language('report/sale_transaction');

        $this->load->model('report/sale_transaction');

		if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }


		$filter_data = array(
			'year_start'					=>date('Y-01-01'),
			'year_end'						=>date('Y-12-31'),
			'start'                  		=> ($page - 1) * 10,
			'limit'                  		=> 10
		);

	$previousOrders = null;

	$orders = $this->model_report_sale_transaction->getInvoiceNotSequence($filter_data);
	$pagenumber=0;
	foreach ($orders as $order) {
		if ($previousOrders) {
			if ($this->checkInvoiceInSequence($order, $previousOrders)) {

				$data['products'][] = array(
					'order_id'          => $order['id'],
					'invoice_prefix'            => $order['number'], 
					'date_added'    => $order['date'],
					);
				$pagenumber++;
			}
		}
		$previousOrders = $order;
	}
	$data['number_invoice'] = $pagenumber;

	// $total_order_product = $pagenumber;

    //     $pagination = new Pagination();
    //     $pagination->total = $total_order_product;
    //     $pagination->page = $page;
    //     $pagination->limit = 10;
    //     $pagination->url = $this->url->link('report/sale_transaction/getInviceNotInSequence', 'user_token=' . $this->session->data['user_token'] . '&page={page}', true);

    //     $data['pagination'] = $pagination->render();

    //     $data['results'] = sprintf($this->language->get('text_pagination'), ($total_order_product) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($total_order_product - 10)) ? $total_order_product : ((($page - 1) * 10) + 10), $total_order_product, ceil($total_order_product / 10));


	$this->response->setOutput($this->load->view('report/sale_transaction_invoice_not_sequence', $data));

	}

	protected function checkInvoiceInSequence($currentOrder, $previousOrder) {
		// Extract numerical parts of invoice numbers
		$currentNumber = $currentOrder['number'];
		$previousNumber = $previousOrder['number'];
	
		// Check if the numbering is sequential and the date is greater than the previous invoice's date
		if (($currentNumber < $previousNumber) || $currentOrder['date'] < $previousOrder['date']) {
			return true;
		}
	
		return false;
	}


}
