<?php
class ControllerReportSaleSummary extends Controller
{

	public function index()
	{
		$msc = microtime(true);
		$this->load->model('report/sale_summary');
		$this->load->language('report/sale_summary');
		$languages = $this->load->language('report/summary');
		foreach ($languages as $l => $lang) {
			$data[$l] = $lang;
		}

		$this->document->setTitle($this->language->get('heading_title'));

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_store_id'])) {
			if ($this->request->get['filter_store_id'] != '*') {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '3,5';
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/sale_summary/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_payment_method' => $filter_payment_method,
			'sort'					=> $sort,
			'order'					=> $order,
			// 'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			// 'limit' 				=> $this->config->get('config_limit_admin')
		);

		$start = ($page - 1) * $this->config->get('config_limit_admin');
		$limit =  $this->config->get('config_limit_admin');

		$sales =  $this->model_report_sale_summary->getSalesSummary($filter_data);

		$total_sales_result = count($sales);

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = $filter_store_id;
		if (!empty($filter_payment_status)) {
			$data['filter_payment_status'] = explode(',', $filter_payment_status);
		} else {
			$data['filter_payment_status'] = [];
		}
		$data['filter_payment_method'] = $filter_payment_method;

		//**data

		$this->load->model('setting/store');
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$data['user_view'] = $this->user->user_view;

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		$data['payment_methods'] = $this->model_report_sale_summary->getPaymentMethod();

		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;

		//listing data
		$data['sales'] = array();
		$sales = $this->model_report_sale_summary->getSalesSummary($filter_data);

		$total_herbal_remedies = 0;
		$total_collect_price = 0;
		$total_doctor = 0;
		$total_service_form = 0;
		$total_subtotal = 0;
		$total_exchange_points_subtotal =  0;
		$total_exchange_points_tax =  0;
		$total_tax = 0;
		$total_rounding = 0;
		$total_shipping = 0;
		$total_sales = 0;
		if (!empty($sales)) {
			foreach ($sales as $sale) {
				$data['sales'][] = array(
					'date' => date('Y-m-d', strtotime($sale['date'])),
					'herbal_remedies' => $this->currency->format($sale['herbal_remedies'], $this->config->get('config_currency')),
					'collect_price' => $this->currency->format($sale['collect_price'], $this->config->get('config_currency')),
					'doctor' => $this->currency->format($sale['doctor'], $this->config->get('config_currency')),
					'service_form' => $this->currency->format($sale['service_form'], $this->config->get('config_currency')),
					'pos' => $this->currency->format($sale['pos'], $this->config->get('config_currency')),
					'expoint_subtotal' => $this->currency->format($sale['expoint_subtotal'], $this->config->get('config_currency')),
					'expoint_tax' => $this->currency->format($sale['expoint_tax'], $this->config->get('config_currency')),
					'subtotal' => $this->currency->format($sale['subtotal'], $this->config->get('config_currency')),
					'tax' => $this->currency->format($sale['tax'], $this->config->get('config_currency')),
					'rounding' => $this->currency->format($sale['rounding'], $this->config->get('config_currency')),
					'shipping' => $this->currency->format($sale['shipping'], $this->config->get('config_currency')),
					'total' => $this->currency->format($sale['total'], $this->config->get('config_currency'))
				);
				$total_herbal_remedies += $sale['herbal_remedies'];
				$total_collect_price += $sale['collect_price'];
				$total_doctor += $sale['doctor'];
				$total_service_form += $sale['service_form'];
				$total_subtotal += $sale['subtotal'];
				$total_exchange_points_subtotal += $sale['expoint_subtotal'];
				$total_exchange_points_tax +=  $sale['expoint_tax'];
				$total_tax += $sale['tax'];
				$total_rounding += $sale['rounding'];
				$total_shipping += $sale['shipping'];
				$total_sales += $sale['total'];
			}
		}

		$data['sales'] = array_slice($data['sales'], $start, $limit);

		//$total_herbal_remedies = $this->model_report_sale_summary->getSalesSummaryTotalHermedies($filter_data);
		//$total_doctor = $this->model_report_sale_summary->getSalesSummaryTotalDoctor($filter_data);
		//$total_service_form = $this->model_report_sale_summary->getSalesSummaryTotalServiceForm($filter_data);
		//$total_subtotal = $this->model_report_sale_summary->getSalesSummaryTotalSubtotal($filter_data);
		$total_pos = $total_subtotal - ($total_doctor + $total_service_form);
		//$total_exchange_points_subtotal =  $this->model_report_sale_summary->getSalesSummaryTotalExchangeSubtotal($filter_data);
		//$total_exchange_points_tax =  $this->model_report_sale_summary->getSalesSummaryTotalExchangeTax($filter_data);
		//$total_tax = $this->model_report_sale_summary->getSalesSummaryTotalTax($filter_data);
		//$total_rounding = $this->model_report_sale_summary->getSalesSummaryTotalRounding($filter_data);
		//$total_shipping = $this->model_report_sale_summary->getSalesSummaryTotalShipping($filter_data);
		//$total_sales = $this->model_report_sale_summary->getSalesSummaryTotalSales($filter_data);
		$data['total_herbal_remedies'] = $this->currency->format($total_herbal_remedies, $this->config->get('config_currency'));
		$data['total_collect_price'] = $this->currency->format($total_collect_price, $this->config->get('config_currency'));
		$data['total_doctor'] = $this->currency->format($total_doctor, $this->config->get('config_currency'));
		$data['total_service_form'] = $this->currency->format($total_service_form, $this->config->get('config_currency'));
		$data['total_pos'] = $this->currency->format($total_pos, $this->config->get('config_currency'));
		$data['total_exchange_points_subtotal'] = $this->currency->format($total_exchange_points_subtotal, $this->config->get('config_currency'));
		$data['total_exchange_points_tax'] = $this->currency->format($total_exchange_points_tax, $this->config->get('config_currency'));
		$data['total_subtotal'] = $this->currency->format($total_subtotal, $this->config->get('config_currency'));
		$data['total_tax'] = $this->currency->format($total_tax, $this->config->get('config_currency'));
		$data['total_rounding'] = $this->currency->format($total_rounding, $this->config->get('config_currency'));
		$data['total_shipping'] = $this->currency->format($total_shipping, $this->config->get('config_currency'));
		$data['total_sales'] = $this->currency->format($total_sales, $this->config->get('config_currency'));


		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';

		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$querystringforsort .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

		$data['sort_date'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, true);
		$data['sort_herbal_remedies'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=herbal_remedies' . $querystringforsort, true);
		$data['sort_service_form'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=service_form' . $querystringforsort, true);
		$data['sort_pos'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=pos' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_date'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, true);
		$data['sort_subtotal'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);

		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}


		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sale_summary', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/sale_summary')){
			$data['user_modify'] = true;
		}

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));

		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$msc = microtime(true) - $msc;

		//**layout
		$this->response->setOutput($this->load->view('report/sale_summary', $data));
	}

	public function exportExcel()
	{

		$this->load->model('report/sale_summary');
		$this->load->language('report/sale_summary');

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_store_id'])) {
			if ($this->request->get['filter_store_id'] != '*') {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		// if (isset($this->request->get['filter_payment_status'])) {
		// 	if($this->request->get['filter_payment_status']){
		// 		$filter_payment_status = $this->request->get['filter_payment_status'];
		// 	} else {
		// 		$filter_payment_status = '';
		// 	}
		// } else {
		// 	$filter_payment_status = 5;
		// }

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '3,5';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'sort'					=> $sort,
			'order'					=> $order
		);

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
			->setTitle("Title")
			->setSubject("Subject")
			->setDescription("Description")
			->setKeywords("report ptcm.etcm.me webceo")
			->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
			->setSize(10);
		// Table Data

		//get data collection from database
		$sales = $this->model_report_sale_summary->getSalesSummary($filter_data);

		$table_collection = array();
		$total_herbal_remedies = 0;
		$total_collect_price = 0;
		$total_doctor = 0;
		$total_service_form = 0;
		$total_subtotal = 0;
		$total_exchange_points_subtotal =  0;
		$total_exchange_points_tax =  0;
		$total_tax = 0;
		$total_rounding = 0;
		$total_shipping = 0;
		$total_sales = 0;
		foreach ($sales as $sale) {
			$table_collection[] = array(
				'date' => date('Y-m-d', strtotime($sale['date'])),
				'herbal_remedies' => $this->currency->format($sale['herbal_remedies'], $this->config->get('config_currency'), '', false),
				'collect_price' => $this->currency->format($sale['collect_price'], $this->config->get('config_currency'), '', false),
				'doctor' => $this->currency->format($sale['doctor'], $this->config->get('config_currency'), '', false),
				'service_form' => $this->currency->format($sale['service_form'], $this->config->get('config_currency'), '', false),
				'pos' => $this->currency->format($sale['pos'], $this->config->get('config_currency'), '', false),
				'expoint_subtotal' => $this->currency->format($sale['expoint_subtotal'], $this->config->get('config_currency'), '', false),
				'expoint_tax' => $this->currency->format($sale['expoint_tax'], $this->config->get('config_currency'), '', false),
				'subtotal' => $this->currency->format($sale['subtotal'], $this->config->get('config_currency'), '', false),
				'shipping' => $this->currency->format($sale['shipping'], $this->config->get('config_currency'), '', false),
				'tax' => $this->currency->format($sale['tax'], $this->config->get('config_currency'), '', false),
				'rounding' => $this->currency->format($sale['rounding'], $this->config->get('config_currency'), '', false),
				'total' => $this->currency->format($sale['total'], $this->config->get('config_currency'), '', false)
			);

			$total_herbal_remedies += $sale['herbal_remedies'];
			$total_collect_price += $sale['collect_price'];
			$total_doctor += $sale['doctor'];
			$total_service_form += $sale['service_form'];
			$total_subtotal += $sale['subtotal'];
			$total_exchange_points_subtotal += $sale['expoint_subtotal'];
			$total_exchange_points_tax +=  $sale['expoint_tax'];
			$total_tax += $sale['tax'];
			$total_rounding += $sale['rounding'];
			$total_shipping += $sale['shipping'];
			$total_sales += $sale['total'];
		}

		//$total_herbal_remedies = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalHermedies($filter_data), $this->config->get('config_currency'), '', false);
		//$total_doctor = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalDoctor($filter_data), $this->config->get('config_currency'), '', false);
		//$total_service_form = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalServiceForm($filter_data), $this->config->get('config_currency'), '', false);
		//$total_subtotal = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalSubtotal($filter_data), $this->config->get('config_currency'), '', false);
		//$total_pos = $this->currency->format($total_subtotal - ($total_doctor + $total_service_form), $this->config->get('config_currency'), '', false);
		//$total_tax = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalTax($filter_data), $this->config->get('config_currency'), '', false);
		//$total_rounding = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalRounding($filter_data), $this->config->get('config_currency'), '', false);
		//$total_shipping = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalShipping($filter_data), $this->config->get('config_currency'), '', false);
		//$total_sales = $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalSales($filter_data), $this->config->get('config_currency'), '', false);
		//$total_exchange_points_subtotal =  $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalExchangeSubtotal($filter_data), $this->config->get('config_currency'), '', false);
		//$total_exchange_points_tax =  $this->currency->format($this->model_report_sale_summary->getSalesSummaryTotalExchangeTax($filter_data), $this->config->get('config_currency'), '', false);
		$total_herbal_remedies = $this->currency->format($total_herbal_remedies, $this->config->get('config_currency'), '', false);
		$total_collect_price = $this->currency->format($total_collect_price, $this->config->get('config_currency'), '', false);
		$total_doctor = $this->currency->format($total_doctor, $this->config->get('config_currency'), '', false);
		$total_service_form = $this->currency->format($total_service_form, $this->config->get('config_currency'), '', false);
		$total_subtotal = $this->currency->format($total_subtotal, $this->config->get('config_currency'), '', false);
		$total_pos = $this->currency->format($total_subtotal - ($total_doctor + $total_service_form), $this->config->get('config_currency'), '', false);
		$total_tax = $this->currency->format($total_tax, $this->config->get('config_currency'), '', false);
		$total_rounding = $this->currency->format($total_rounding, $this->config->get('config_currency'), '', false);
		$total_shipping = $this->currency->format($total_shipping, $this->config->get('config_currency'), '', false);
		$total_sales = $this->currency->format($total_sales, $this->config->get('config_currency'), '', false);
		$total_exchange_points_subtotal =  $this->currency->format($total_exchange_points_subtotal, $this->config->get('config_currency'), '', false);
		$total_exchange_points_tax =  $this->currency->format($total_exchange_points_tax, $this->config->get('config_currency'), '', false);

		$table_collection[] = array(
			'',
			$total_herbal_remedies,
			$total_collect_price,
			$total_doctor,
			$total_service_form,
			$total_pos,
			$total_exchange_points_subtotal,
			$total_exchange_points_tax,
			$total_subtotal,
			$total_shipping,
			$total_tax,
			$total_rounding,
			$total_sales
		);

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

		$table[] = array(); // add a space

		//$table[] = array('Report Details : ');

		$table_header = array( //table headers
			$this->language->get('column_date'),
			$this->language->get('column_herbal_remedies'),
			$this->language->get('column_collect_price'),
			$this->language->get('column_doctor'),
			$this->language->get('column_service_form'),
			$this->language->get('column_pos'),
			$this->language->get('column_expoint_subtotal'),
			$this->language->get('column_expoint_tax'),
			$this->language->get('column_subtotal'),
			$this->language->get('column_shipping'),
			$this->language->get('column_tax'),
			$this->language->get('column_rounding'),
			$this->language->get('column_total')
		);
		$table[] = $table_header; //add header to table

		$table_data = $table_collection;
		$row = 0;
		$total_row = 0;
		foreach ($table_data as $key => $data) {
			$row = array();
			foreach ($data as $key => $value) {
				$row[] = $value;
			}
			$table[] = $row; //add data row to table
			$total_row++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach ($table_header as $header) { //loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach ($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

		//debug test
		//$table = array("one", "two", "three");

		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	protected function c_format($data)
	{
		return $this->currency->format($data, $this->config->get('config_currency'));
	}

	protected function print_data($data)
	{
		echo '<pre>';
		print_r($data);
		echo '</pre>';
	}
}
