<?php
class ControllerReportSaleByCategory extends Controller {
	protected function c_format($data) {
		return $this->currency->format($data,$this->config->get('config_currency'));
	}

	protected function print_data($data) {
		echo '<pre>';
		print_r($data);
		echo '</pre>';
	}

	public function index() {
		$msc = microtime(true);
		$this->load->model('report/sale_by_category');
		$this->load->language('report/sale_by_category');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');

        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');

        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		// $languages = $this->load->language('report/sale_by_category');
		// foreach ($languages as $l => $lang) {
		// 	$data[$l] = $lang;
		// }

		$this->document->setTitle($this->language->get('heading_title'));
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = 5;
			}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/sale_by_category/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_category' => $filter_category,
			'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_payment_status'] = explode(',',$filter_payment_status);
		$data['filter_category'] = explode(',',$filter_category);
		
		//**data
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$data['user_view'] = $this->user->user_view;
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['payment_methods'] = $this->model_report_sale_by_category->getPaymentMethod();

		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$data['sales'] = array();
		

		$categories = $this->model_report_sale_by_category->getCategories();


		foreach ($categories as $category) {
			$data['categories'][] = array(
				'category_id' => $category['category_id'],
				'name' => $category['name']
			);
		}

		
		
	
		$total_sale_num= 0; 
		$total_num = 0; 
		
			$categorys = $this->model_report_sale_by_category->getcategoryhodtotal($filter_data);
		
		

		foreach($categorys as $category){
		// 	echo"<pre>";
		// print_r($category);
		// echo"</pre>";
			$data['categorys'][] = array(
				'category' => $category['name'],
				'total_sale' => $category['total_sale'],
                'total' => $this->currency->format($category['total_amount'],$this->config->get('config_currency')),

			);
			$total_sale_num += $category['total_sale'] ; 
			$total_num += $category['total_amount']; 
		
			
		}
		$data['total_sale_num'] = $total_sale_num;
		$data['total_num'] = $this->currency->format($total_num,$this->config->get('config_currency'));

		
		
		// $total_herbal_remedies = $this->model_report_sale_by_category->getSalesSummaryTotalHermedies($filter_data);
		// $total_doctor = $this->model_report_sale_by_category->getSalesSummaryTotalDoctor($filter_data);
		// $total_service_form = $this->model_report_sale_by_category->getSalesSummaryTotalServiceForm($filter_data);
		// $total_subtotal = $this->model_report_sale_by_category->getSalesSummaryTotalSubtotal($filter_data);
		// $total_pos = $total_subtotal - ($total_herbal_remedies + $total_doctor + $total_service_form);
		// $total_exchange_points_subtotal =  $this->model_report_sale_by_category->getSalesSummaryTotalExchangeSubtotal($filter_data);
		// $total_exchange_points_tax =  $this->model_report_sale_by_category->getSalesSummaryTotalExchangeTax($filter_data);
		// $total_tax = $this->model_report_sale_by_category->getSalesSummaryTotalTax($filter_data);
		// $total_rounding = $this->model_report_sale_by_category->getSalesSummaryTotalRounding($filter_data);
		// $total_shipping = $this->model_report_sale_by_category->getSalesSummaryTotalShipping($filter_data);
		// $total_sales = $this->model_report_sale_by_category->getSalesSummaryTotalSales($filter_data);
		
		// $data['total_herbal_remedies'] = $this->currency->format($total_herbal_remedies, $this->config->get('config_currency'));
		// $data['total_doctor'] = $this->currency->format($total_doctor, $this->config->get('config_currency'));
		// $data['total_service_form'] = $this->currency->format($total_service_form, $this->config->get('config_currency'));
		// $data['total_pos'] = $this->currency->format($total_pos, $this->config->get('config_currency'));
		// $data['total_exchange_points_subtotal'] = $this->currency->format($total_exchange_points_subtotal, $this->config->get('config_currency'));
		// $data['total_exchange_points_tax'] = $this->currency->format($total_exchange_points_tax, $this->config->get('config_currency'));
		// $data['total_subtotal'] = $this->currency->format($total_subtotal, $this->config->get('config_currency'));
		// $data['total_tax'] = $this->currency->format($total_tax, $this->config->get('config_currency'));
		// $data['total_rounding'] = $this->currency->format($total_rounding, $this->config->get('config_currency'));
		// $data['total_shipping'] = $this->currency->format($total_shipping, $this->config->get('config_currency'));
		// $data['total_sales'] = $this->currency->format($total_sales, $this->config->get('config_currency'));
		
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$querystringforsort .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_date'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, 'SSL');
		$data['sort_herbal_remedies'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=herbal_remedies' . $querystringforsort, 'SSL');
		$data['sort_service_form'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=service_form' . $querystringforsort, 'SSL');
		$data['sort_pos'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=pos' . $querystringforsort, 'SSL');
		$data['sort_tax'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, 'SSL');$data['sort_date'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=date' . $querystringforsort, 'SSL');
		$data['sort_subtotal'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, 'SSL');
		$data['sort_total'] = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, 'SSL');
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_sale_by_category->getcategoryhodTotalnumber($filter_data);
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/sale_by_category', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$msc = microtime(true)-$msc;
		/*echo '<pre>';
		print_r($msc);
		echo '</pre>';*/
		
		//**layout
		$this->response->setOutput($this->load->view('report/sale_by_category', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/sale_by_category');
		$this->load->language('report/sale_by_category');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = 5;
			}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'date';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_category' 		=> $filter_category,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$sales = $this->model_report_sale_by_category->getSalesSummary($filter_data);

		$categorys = $this->model_report_sale_by_category->getcategoryhodtotal($filter_data);
		
		
		$table_collection = array();
		
		

		$total_sale_num= 0; 
		$total_num = 0; 
		
			$categorys = $this->model_report_sale_by_category->getcategoryhodtotal($filter_data);
		
		

		foreach($categorys as $category){
			$table_collection[] = array(
				'category' => $category['name'],
				'total_sale' => $category['total_sale'],
                'total' => $this->currency->format($category['total_amount'],$this->config->get('config_currency')),

			);
		
			$total_sale_num += $category['total_sale'] ; 
			$total_num += $category['total_amount']; 
		
			
		}
		$data['total_sale_num'] = $total_sale_num;
		$data['total_num'] = $this->currency->format($total_num,$this->config->get('config_currency'));

		$table_collection[] = array(
			'Total',$data['total_sale_num'],$data['total_num']
		);
		
		// $total_herbal_remedies = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalHermedies($filter_data), $this->config->get('config_currency'), '', false);
		// $total_doctor = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalDoctor($filter_data), $this->config->get('config_currency'), '', false);
		// $total_service_form = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalServiceForm($filter_data), $this->config->get('config_currency'), '', false);
		// $total_subtotal = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalSubtotal($filter_data), $this->config->get('config_currency'), '', false);
		// $total_pos = $this->currency->format($total_subtotal - ($total_herbal_remedies + $total_doctor + $total_service_form), $this->config->get('config_currency'), '', false);
		// $total_tax = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalTax($filter_data), $this->config->get('config_currency'), '', false);
		// $total_rounding = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalRounding($filter_data), $this->config->get('config_currency'), '', false);
		// $total_shipping = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalShipping($filter_data), $this->config->get('config_currency'), '', false);
		// $total_sales = $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalSales($filter_data), $this->config->get('config_currency'), '', false);
		
		// $total_exchange_points_subtotal =  $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalExchangeSubtotal($filter_data), $this->config->get('config_currency'), '', false);
		// $total_exchange_points_tax =  $this->currency->format($this->model_report_sale_by_category->getSalesSummaryTotalExchangeTax($filter_data), $this->config->get('config_currency'), '', false);
		
		// $table_collection[] = array(
		// 	'',
		// 	$total_herbal_remedies,
		// 	$total_doctor,
		// 	$total_service_form,
		// 	$total_pos,
		// 	$total_exchange_points_subtotal,
		// 	$total_exchange_points_tax,
		// 	$total_subtotal,
		// 	$total_shipping,
		// 	$total_tax,
		// 	$total_rounding,
		// 	$total_sales
		// );
		
		$table = array();
		
		/*
		$table[] = array('Report Summary : ');
		
		$total_herbal_remedies = $this->model_report_sale->getSalesSummaryTotalHermedies($filter_data);
		$total_doctor = $this->model_report_sale->getSalesSummaryTotalDoctor($filter_data);
		$total_service_form = $this->model_report_sale->getSalesSummaryTotalServiceForm($filter_data);
		$total_subtotal = $this->model_report_sale->getSalesSummaryTotalSubtotal($filter_data);
		$total_pos = $total_subtotal - ($total_doctor + $total_service_form);
		$total_tax = $this->model_report_sale->getSalesSummaryTotalTax($filter_data);
		$total_rounding = $this->model_report_sale->getSalesSummaryTotalRounding($filter_data);
		$total_shipping = $this->model_report_sale->getSalesSummaryTotalShipping($filter_data);
		$total_sales = $this->model_report_sale->getSalesSummaryTotalSales($filter_data);
		
		
		$table[] = array($this->language->get('text_total_herbal_remedies') , $this->currency->format($total_herbal_remedies, $this->config->get('config_currency')));
		$table[] =  array($this->language->get('text_total_doctor') 		, $this->currency->format($total_doctor, $this->config->get('config_currency')));
		$table[] = array($this->language->get('text_total_pos')				, $this->currency->format($total_pos, $this->config->get('config_currency')));
		$table[] = array($this->language->get('text_total_service_form') 	, $this->currency->format($total_doctor, $this->config->get('config_currency')));
		$table[] = array($this->language->get('text_total_subtotal') 		, $this->currency->format($total_tax, $this->config->get('config_currency')));
		$table[] =  array($this->language->get('text_total_shipping') 		, $this->currency->format($total_shipping, $this->config->get('config_currency')));
		$table[] = array($this->language->get('text_total_tax')				, $this->currency->format($total_rounding, $this->config->get('config_currency')));
		$table[] =  array($this->language->get('text_total_rounding') 		, $this->currency->format($total_rounding, $this->config->get('config_currency')));
		$table[] = array( $this->language->get('text_total') 				, $this->currency->format($total_sales, $this->config->get('config_currency')));
		*/
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array(); // add a space
		
		//$table[] = array('Report Details : ');
		
		$table_header = array(//table headers
			$this->language->get('column_category'),
			$this->language->get('column_total_sale'),
			$this->language->get('column_total_sales')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row));
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("J" . ($header_index_row + 1) . ":J" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>