<?php
class ControllerReportPurchaseInvoiceDetailByStock extends Controller{
	public function index(){
		$this->load->language('report/purchase_invoice_detail_by_stock');
		
		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/purchase');
		
		//**filter
		if (isset($this->request->get['filter_supplier_invoice_start'])) {
			$filter_supplier_invoice_start = $this->request->get['filter_supplier_invoice_start'];
		} else {
			$filter_supplier_invoice_start = '';
		}
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$filter_supplier_invoice_end = $this->request->get['filter_supplier_invoice_end'];
		} else {
			$filter_supplier_invoice_end = '';
		}
		
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$filter_supplier_invoice_end = $this->request->get['filter_supplier_invoice_end'];
		} else {
			$filter_supplier_invoice_end = '';
		}
		
		if (isset($this->request->get['filter_from'])) {
			$filter_from = $this->request->get['filter_from'];
		} else {
			$filter_from = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_supplier_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_manufacturer_name'])) {
			$filter_manufacturer_name = $this->request->get['filter_manufacturer_name'];
		} else {
			$filter_manufacturer_name = NULL;
		}
		
		if (isset($this->request->get['filter_manufacturer_code'])) {
			$filter_manufacturer_code = $this->request->get['filter_manufacturer_code'];
		} else {
			$filter_manufacturer_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = NULL;
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			if($this->request->get['filter_order_status_id']){
				$filter_order_status_id = $this->request->get['filter_order_status_id'];
			} else {
				$filter_order_status_id = '';
			}
		} else {
			$filter_order_status_id = 5;
		}
		
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pi.date_added';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		
		if (isset($this->request->get['filter_supplier_invoice_start'])) {
			$url .= '&filter_supplier_invoice_start=' . $this->request->get['filter_supplier_invoice_start'];
		}
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$url .= '&filter_supplier_invoice_end=' . $this->request->get['filter_supplier_invoice_end'];
		}
		
		if (isset($this->request->get['filter_from'])) {
			$url .= '&filter_from=' . $this->request->get['filter_from'];
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_manufacturer_name'])) {
			$url .= '&filter_manufacturer_name=' . $this->request->get['filter_manufacturer_name'];
		}
		
		if (isset($this->request->get['filter_manufacturer_code'])) {
			$url .= '&filter_manufacturer_code=' . $this->request->get['filter_manufacturer_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			if($this->request->get['filter_order_status_id'] != '*'){
				$filter_order_status_id = $this->request->get['filter_order_status_id'];
			} else {
				$filter_order_status_id = '';
			}
			
		} else {
			$filter_order_status_id = 5;
		}
		
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		//urls
		$data['export_excel'] = $this->url->link('report/purchase_invoice_detail_by_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_supplier_invoice_start' => $filter_supplier_invoice_start,
			'filter_supplier_invoice_end' => $filter_supplier_invoice_end,
			'filter_from' 				=> $filter_from,
			'filter_transaction_start'	=> $filter_transaction_start,
			'filter_transaction_end'	=> $filter_transaction_end,
			'filter_date_start' 		=> $filter_date_start,
			'filter_date_end' 			=> $filter_date_end,
			'filter_manufacturer_name'	=> $filter_manufacturer_name,
			'filter_manufacturer_code' 	=> $filter_manufacturer_code,
			'filter_name_cn'			=> $filter_name_cn,
			'filter_name_en'			=> $filter_name_en,
			'filter_product_code'		=> $filter_product_code,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start' 					=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 					=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_supplier_invoice_start'] = $filter_supplier_invoice_start;
		$data['filter_supplier_invoice_end'] = $filter_supplier_invoice_end;
		$data['filter_from'] = $filter_from;
		$data['filter_transaction_start'] = $filter_transaction_start;
		$data['filter_transaction_end'] = $filter_transaction_end;
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_manufacturer_name'] = $filter_manufacturer_name;
		$data['filter_manufacturer_code'] = $filter_manufacturer_code;
		$data['filter_name_cn'] = $filter_name_cn;
		$data['filter_name_en'] = $filter_name_en;
		$data['filter_product_code'] = $filter_product_code;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_order_status_id'] = $filter_order_status_id;
		
		
		//**data
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$this->load->library('weight');
		$this->weight = new Weight($this->registry);
		
		$data['purchases'] = array();
		$purchases = $this->model_report_purchase->getPurchaseInvoiceDetailByStockReport($filter_data);
		
		foreach($purchases as $purchase){
			$from = '';
			switch($purchase['type']){
				case 1:
					$from = 'Purchase Order';
					break;
				case 2:
					$from = 'Herbal Remedies';
					break;
				case 3:
					$from = 'POS';
					break;
				default:
			}
			
			$data['purchases'][] = array(
				'date_added' => date($this->language->get('date_format_short'), strtotime($purchase['date_added'])),
				'invoice_prefix' => $purchase['invoice_prefix'],
				'supplier_invoice' => $purchase['supplier_invoice'],
				'manufacturer_code' => $purchase['manufacturer_code'],
				'manufacturer_name' => $purchase['manufacturer_name'],
				'from' => $from,
				'purchase_order' => $purchase['purchase_order'],
				'product_code' => $purchase['product_code'],
				'english_name' => $purchase['english_name'],
				'chinese_name' => $purchase['chinese_name'],
				'quantity' => $purchase['quantity'],
				'unit_price' => $this->currency->format($purchase['unit_price'], $purchase['currency_code'], $purchase['currency_value']),
				'total_net_amount' => $this->currency->format($purchase['total_net_amount'], $purchase['currency_code'], $purchase['currency_value']),
				'total_tax' => $this->currency->format($purchase['total_tax'], $purchase['currency_code'], $purchase['currency_value']),
				'total' => $this->currency->format($purchase['total'], $purchase['currency_code'], $purchase['currency_value'])
			);
		}
		
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_supplier_invoice_start'])) {
			$querystringforsort .= '&filter_supplier_invoice_start=' . $this->request->get['filter_supplier_invoice_start'];
		}
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$querystringforsort .= '&filter_supplier_invoice_end=' . $this->request->get['filter_supplier_invoice_end'];
		}
		
		if (isset($this->request->get['filter_from'])) {
			$querystringforsort .= '&filter_from=' . $this->request->get['filter_from'];
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_manufacturer_name'])) {
			$querystringforsort .= '&filter_manufacturer_name=' . $this->request->get['filter_manufacturer_name'];
		}
		
		if (isset($this->request->get['filter_manufacturer_code'])) {
			$querystringforsort .= '&filter_manufacturer_code=' . $this->request->get['filter_manufacturer_code'];
		}
		
		if(isset($this->request->get['filter_name_cn'])) {
			$querystringforsort .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if(isset($this->request->get['filter_name_en'])) {
			$querystringforsort .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if(isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if(isset($this->request->get['filter_order_status_id'])) {
			$querystringforsort .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_date_added'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=pi.date_added' . $querystringforsort, true);
		$data['sort_invoice_prefix'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
		$data['sort_supplier_invoice'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=supplier_invoice' . $querystringforsort, true);
		$data['sort_manufacturer_code'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=manufacturer_code' . $querystringforsort, true);
		$data['sort_manufacturer_name'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=manufacturer_name' . $querystringforsort, true);
		$data['sort_from'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=from' . $querystringforsort, true);
		$data['sort_purchase_order'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=purchase_invoice' . $querystringforsort, true);
		$data['sort_product_code'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=product_code' . $querystringforsort, true);
		$data['sort_english_name'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=english_name' . $querystringforsort, true);
		$data['sort_chinese_name'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=chinese_name' . $querystringforsort, true);
		$data['sort_order_qty'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
		$data['sort_quantity'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
		$data['sort_unit_price'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=unit_price' . $querystringforsort, true);
		$data['sort_total_net_amount'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_net_amount' . $querystringforsort, true);
		$data['sort_total_tax'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_supplier_invoice_start'])) {
			$url .= '&filter_supplier_invoice_start=' . $this->request->get['filter_supplier_invoice_start'];
		}
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$url .= '&filter_supplier_invoice_end=' . $this->request->get['filter_supplier_invoice_end'];
		}
		
		if (isset($this->request->get['filter_from'])) {
			$url .= '&filter_from=' . $this->request->get['filter_from'];
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_manufacturer_name'])) {
			$url .= '&filter_manufacturer_name=' . $this->request->get['filter_manufacturer_name'];
		}
		
		if (isset($this->request->get['filter_manufacturer_code'])) {
			$url .= '&filter_manufacturer_code=' . $this->request->get['filter_manufacturer_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_purchase->getTotalPurchaseInvoiceDetailByStockReport($filter_data);
		
		
		$data['total_quantity'] = $this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalQuantity($filter_data);
		$data['total_net_amount'] = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalNetAmount($filter_data), $this->config->get('config_currency'));
		$data['total_tax'] = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalTotalTax($filter_data), $this->config->get('config_currency'));
		$data['total_sales'] = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalSales($filter_data), $this->config->get('config_currency'));
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/purchase_invoice_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/purchase_invoice_detail_by_stock', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/purchase');
		$this->load->language('report/purchase_invoice_detail_by_stock');
		
		//**filter
		if (isset($this->request->get['filter_supplier_invoice_start'])) {
			$filter_supplier_invoice_start = $this->request->get['filter_supplier_invoice_start'];
		} else {
			$filter_supplier_invoice_start = '';
		}
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$filter_supplier_invoice_end = $this->request->get['filter_supplier_invoice_end'];
		} else {
			$filter_supplier_invoice_end = '';
		}
		
		
		if (isset($this->request->get['filter_supplier_invoice_end'])) {
			$filter_supplier_invoice_end = $this->request->get['filter_supplier_invoice_end'];
		} else {
			$filter_supplier_invoice_end = '';
		}
		
		if (isset($this->request->get['filter_from'])) {
			$filter_from = $this->request->get['filter_from'];
		} else {
			$filter_from = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_supplier_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-d');
		}
		
		if (isset($this->request->get['filter_manufacturer_name'])) {
			$filter_manufacturer_name = $this->request->get['filter_manufacturer_name'];
		} else {
			$filter_manufacturer_name = NULL;
		}
		
		if (isset($this->request->get['filter_manufacturer_code'])) {
			$filter_manufacturer_code = $this->request->get['filter_manufacturer_code'];
		} else {
			$filter_manufacturer_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = NULL;
		}
		
		if (isset($this->request->get['filter_order_status_id'])) {
			if($this->request->get['filter_order_status_id']){
				$filter_order_status_id = $this->request->get['filter_order_status_id'];
			} else {
				$filter_order_status_id = '';
			}
		} else {
			$filter_order_status_id = 5;
		}
		
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'pi.date_added';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//** filter data
		$filter_data = array(
			'filter_supplier_invoice_start' => $filter_supplier_invoice_start,
			'filter_supplier_invoice_end' => $filter_supplier_invoice_end,
			'filter_from' 				=> $filter_from,
			'filter_transaction_start'	=> $filter_transaction_start,
			'filter_transaction_end'	=> $filter_transaction_end,
			'filter_date_start' 		=> $filter_date_start,
			'filter_date_end' 			=> $filter_date_end,
			'filter_manufacturer_name'	=> $filter_manufacturer_name,
			'filter_manufacturer_code' 	=> $filter_manufacturer_code,
			'filter_name_cn'			=> $filter_name_cn,
			'filter_name_en'			=> $filter_name_en,
			'filter_product_code'		=> $filter_product_code,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//get gst code
		$this->load->model('setting/store');
		$gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$table_collection = array();
		$purchases = $this->model_report_purchase->getPurchaseInvoiceDetailByStockReport($filter_data);
		
		foreach($purchases as $purchase){
			$from = '';
			switch($purchase['type']){
				case 1:
					$from = 'Purchase Order';
					break;
				case 2:
					$from = 'Herbal Remedies';
					break;
				case 3:
					$from = 'POS';
					break;
				default:
			}
			
			$table_collection[] = array(
				'date_added' => date($this->language->get('date_format_short'), strtotime($purchase['date_added'])),
				'invoice_prefix' => $purchase['invoice_prefix'],
				'supplier_invoice' => $purchase['supplier_invoice'],
				'manufacturer_code' => $purchase['manufacturer_code'],
				'manufacturer_name' => $purchase['manufacturer_name'],
				'from' => $from,
				'purchase_order' => $purchase['purchase_order'],
				'product_code' => $purchase['product_code'],
				'english_name' => $purchase['english_name'],
				'chinese_name' => $purchase['chinese_name'],
				'unit_price' => $this->currency->format($purchase['unit_price'], $purchase['currency_code'], $purchase['currency_value'], false),
				'quantity' => $purchase['quantity'],
				'total_net_amount' => $this->currency->format($purchase['total_net_amount'], $purchase['currency_code'], $purchase['currency_value'], false),
				'total_tax' => $this->currency->format($purchase['total_tax'], $purchase['currency_code'], $purchase['currency_value'], false),
				'total' => $this->currency->format($purchase['total'], $purchase['currency_code'], $purchase['currency_value'], false)
			);
		}
		
		$total_quantity = $this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalQuantity($filter_data);
		$total_net_amount = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalNetAmount($filter_data), $this->config->get('config_currency'), '', false);
		$total_tax = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalTotalTax($filter_data), $this->config->get('config_currency'), '', false);
		$total_sales = $this->currency->format($this->model_report_purchase->getPurchaseInvoiceDetailByStockReportTotalSales($filter_data), $this->config->get('config_currency'), '', false);
		
		$table_collection[] = array('', '', '', '', '', '', '', '', '', '', '', $total_quantity, $total_net_amount, $total_tax, $total_sales);
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array();
		
		$table_header = array(//table headers
			$this->language->get('column_date'),
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_supplier_invoice'),
			$this->language->get('column_supplier_code'),
			$this->language->get('column_supplier'),
			$this->language->get('column_from'),
			$this->language->get('column_purchase_order'),
			$this->language->get('column_product_code'),
			$this->language->get('column_english_name'),
			$this->language->get('column_chinese_name'),
			$this->language->get('column_unit_price'),
			$this->language->get('column_quantity'),
			$this->language->get('column_total_net_amount'),
			$this->language->get('column_total_tax'),
			$this->language->get('column_total')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$text_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($text_style);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($text_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		
		
		
		$objPHPExcel->getActiveSheet()->getStyle("K" . ($header_index_row + 1) . ":K" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("L" . ($header_index_row + 1) . ":L" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("M" . ($header_index_row + 1) . ":M" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("N" . ($header_index_row + 1) . ":N" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("O" . ($header_index_row + 1) . ":O" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>