<?php
class ControllerReportProductStockAlert extends Controller {
	public function index() {
		
		$this->load->language('report/product_stock_alert');

		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

		$this->document->setTitle($this->language->get('heading_title'));
		
		
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = [];
		}
		
		if (isset($this->request->get['filter_price_from'])) {
			$filter_price_from = $this->request->get['filter_price_from'];
		} else {
			$filter_price_from = '';
		}
		
		if (isset($this->request->get['filter_search_type'])) {
			$filter_search_type = $this->request->get['filter_search_type'];
		} else {
			$filter_search_type = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_status_id'])) {
			$filter_status_id = $this->request->get['filter_status_id'];
		} else {
			$filter_status_id = NULL;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'code';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		$url = '';
		
		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_price_from'])) {
			$url .= '&filter_price_from=' . $this->request->get['filter_price_from'];
		}
		
		if (isset($this->request->get['filter_search_type'])) {
			$url .= '&filter_search_type=' . $this->request->get['filter_search_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_status_id'])) {
			$url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		
		//urls
		$data['export_excel'] = $this->url->link('report/product_stock_alert/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/product_stock_alert');

		$data['products'] = array();

		$filter_data = array(
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category,
			'filter_price_from'			=> $filter_price_from,
			'filter_search_type'		=> $filter_search_type,
			'filter_store_id'			=> $filter_store_id,
			'filter_status_id' 	=> $filter_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start'                  	=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                  	=> $this->config->get('config_limit_admin')
		);

		$data['categories'] = array();
		$categories = $this->model_report_product_stock_alert->getCategories();


		foreach ($categories as $category) {
			$data['categories'][] = array(
				'category_id' => $category['category_id'],
				'name' => $category['name']
			);
		}

		$product_total = $this->model_report_product_stock_alert->getProductStockAlertTotal($filter_data);

		$results = $this->model_report_product_stock_alert->getProductStockAlert($filter_data);
		foreach ($results as $result) {
			$data['products'][] = array(
				'store_name' => $result['store_name'],
				'code'		=> $result['code'],
				'status'	=> $result['status'],
				'name'     	=> $result['name'],
				'chinesename' => $result['chinesename'],
				'englishname' => $result['englishname'],
				'category'	=> implode(array_column($this->model_report_product_stock_alert->getCategoryall([],$result['product_id']),'category')),
				'weight_class' => $result['unit'],
				'onhand_quantity'  => $result['onhand_quantity'],
				'reorder_quantity'  => $result['reorder_quantity'],
				'check_detail' => $this->url->link('report/product_movement', 'user_token=' . $this->session->data['user_token'] . '&product_id=' .$result['product_id'].'&filter_store_id='.$this->session->data['store_id'] , true)
			);
		}
		
		$data['total_tax'] = $this->currency->format($this->model_report_product_stock_alert->getPurchasedTotalTax($filter_data), $this->config->get('config_currency'));
		$data['total_sales'] =  $this->currency->format($this->model_report_product_stock_alert->getPurchasedTotalSales($filter_data), $this->config->get('config_currency'));

		

		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_product_name'])) {
			$querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$querystringforsort .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		if (isset($this->request->get['filter_search_type'])) {
			$querystringforsort .= '&filter_search_type=' . $this->request->get['filter_search_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_status_id'])) {
			$querystringforsort .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_name'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
		$data['sort_code'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
		$data['sort_category'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=category' . $querystringforsort, true);
		$data['sort_type'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=type' . $querystringforsort, true);
		$data['sort_onhand_quantity'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=onhand_quantity' . $querystringforsort, true);
		$data['sort_reorder_quantity'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=reorder_quantity' . $querystringforsort, true);
		$data['sort_store_name'] = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . '&sort=store_name' . $querystringforsort, true);
		
		
		$url = '';

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}
		
		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}
		
		
		if (isset($this->request->get['filter_search_type'])) {
			$url .= '&filter_search_type=' . $this->request->get['filter_search_type'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_status_id'])) {
			$url .= '&filter_status_id=' . $this->request->get['filter_status_id'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/product_stock_alert', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));
		
		$data['filter_product_name'] = $filter_product_name;
		$data['filter_product_code'] = $filter_product_code;
		$data['filter_category'] = $filter_category;
		$data['filter_price_from'] = $filter_price_from;
		$data['filter_search_type'] = $filter_search_type;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_status_id'] = $filter_status_id;
        $data['page'] = ($page - 1) * $this->config->get('config_limit_admin');

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/product_stock_alert', $data));
	}
	
	private function productTypeText($id){
		$text = '';
		switch($id){
			case 1:
				$text = $this->language->get('text_product');
				break;
			case 2:
				$text = $this->language->get('text_material');
				break;
		}
		
		return $text;
	}
	
	public function exportExcel(){
		
		$this->load->model('report/product_stock_alert');
		$this->load->language('report/product_stock_alert');
		
		//**filter
		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}
		
		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}
		
		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}

		if (isset($this->request->get['filter_search_type'])) {
			$filter_search_type = $this->request->get['filter_search_type'];
		} else {
			$filter_search_type = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_status_id'])) {
			$filter_status_id = $this->request->get['filter_status_id'];
		} else {
			$filter_status_id = NULL;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'code';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}
		
		$filter_data = array(
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category,
			'filter_search_type'		=> $filter_search_type,
			'filter_store_id'			=> $filter_store_id,
			'filter_status_id' 	=> $filter_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$results = $this->model_report_product_stock_alert->getProductStockAlert($filter_data);
		
		$table_collection = array();
		
		foreach ($results as $result) {
			if($result['status'] == 1){
			$status = $this->language->get('text_enable');
			}else{
			$status = $this->language->get('text_disable');
			}
			$table_collection[] = array(
				'code'		=> $result['code'],
				'name'     	=> $result['name']." "."(".$status.")",
				'category'	=> implode(array_column($this->model_report_product_stock_alert->getCategoryall([],$result['product_id']),'category')),
				'store_name' => $result['store_name'],
				'onhand_quantity'  => $result['onhand_quantity'].$result['unit'],
				'reorder_quantity'  => $result['reorder_quantity'].$result['unit'],
				
			);
		}
		
		$table = array();
		/*
		$table[] = array("Total Herbal Remedies" 	, '');
		$table[] = array("Total Service Form" 		, '');
		$table[] = array("Total Product Form POS" 	, '');
		$table[] = array("Total Subtotal" 			,'');
		$table[] = array("Total GST" 				, '');
		$table[] = array("Total" 					, '');
		
		$table[] = array(); // add a space
		*/
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array(); // add a space
		
		$table_header = array(//table headers
			$this->language->get('column_code'),
			$this->language->get('column_name'),
			$this->language->get('column_category'),
			$this->language->get('column_store_name'),
			$this->language->get('column_onhand_quantity'),
			$this->language->get('column_reorder_quantity')
		);
		$table[] = $table_header;//add header to table
		
		$total_row = 0;
		
		$table_data = $table_collection;
		$row;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 3;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$product_code_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("A" . ($header_index_row + 1) . ":A" . ($header_index_row + 1 + $total_row))->applyFromArray($product_code_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$objPHPExcel->getActiveSheet()->setTitle($this->language->get('heading_title'));
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
		
		$today = date('Y-m-d H i s');
		$filename = $this->language->get('heading_title') . $today ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}