<?php
class ControllerReportProductStock extends Controller
{
	public function index()
	{

		$this->load->language('report/product_stock');

		//add css and js for multiselection
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
		$this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$filter_location = $this->request->get['filter_location'];
		} else {
			$filter_location = '';
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$filter_batch_date_start = $this->request->get['filter_batch_date_start'];
		} else {
			$filter_batch_date_start = '';
		}
		if (isset($this->request->get['filter_batch_date_end'])) {
			$filter_batch_date_end = $this->request->get['filter_batch_date_end'];
		} else {
			$filter_batch_date_end = '';
		}

		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}

		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'product_name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		$url = '';
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$url .= '&filter_location=' . $this->request->get['filter_location'];
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$url .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
		}

		if (isset($this->request->get['filter_batch_date_end'])) {
			$url .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/product_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/product');
		$this->load->model('report/product_stock');

		$data['products'] = array();

		$filter_data = array(
			'filter_store_id'			=> $filter_store_id,
			'filter_location'			=> $filter_location,
			'filter_batch_date_start'	=> $filter_batch_date_start,
			'filter_batch_date_end'		=> $filter_batch_date_end,
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category,
			'sort'						=> $sort,
			'order'						=> $order
		);

		$start = ($page - 1) * $this->config->get('config_limit_admin');
		$limit = $this->config->get('config_limit_admin');

		//data
		$this->load->model('setting/store');

		$arr_stores = array();
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$arr_stores[0] = $sname . $this->language->get('text_default');
		$data['stores'][] = array(
			'store_id' => 0,
			'name' => $sname . $this->language->get('text_default')
		);
		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$arr_stores[$store['store_id']] = $store['name'];
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name' => $store['name']
			);
		}
		$data['user_view'] = $this->user->user_view;

		if ($this->user->user_view == 1) {
			$data['locations'] = $this->model_report_product_stock->getAllLocations();
		} else {
			$data['locations'] = $this->model_report_product_stock->getLocations();
		}

		$arr_location = array();
		$arr_location[0] = 'Default Location';
		$locations = $this->model_report_product_stock->getLocationName();
		foreach ($locations as $location) {
			$arr_location[$location['location_id']] = $location['name'];
		}

		$results = $this->model_report_product_stock->getProductStock($filter_data);
		$product_total = count($results);
		// $onhand_quntitys = $this->model_report_product_stock->getProductOnhandQuantity();


		// foreach($onhand_quntitys as $onhand_quntity){
		// 	$data['onhand_quantity'][] = array(
		// 		'onhand_quantity' => $onhand_quntity['quantity'],
		// 	);
		// }

		$language_id = $this->config->get('config_language_id');
		if (!empty($results)) {
			foreach ($results as $result) {
				if ($language_id == 1) {
					$product_name = $result['en_name'];
				} else {
					$product_name = $result['cn_name'];
				}
				// foreach($onhand_quntitys as $onhand_quntity){
				// 	$quantity = $onhand_quntity['quantity'];
				// }
				
				$store_id = ($result['store_id'] == '') ? 0 : $result['store_id'];
				$location_id = ($result['location_id'] == '') ? 0 : $result['location_id'];
				$batch_date = ($result['batch_date'] == '') ? '0000-00-00' : $result['batch_date'];
				// $quantity = ($result['quantity'] == '') ? 0 : $result['quantity'];
				$data['products'][] = array(
					'product_id'	=> $result['product_id'],
					'code'			=> $result['code'],
					'name'   	  	=> $product_name,
					'en_name' 		=> $result['en_name'],
					'cn_name' 		=> $result['cn_name'],
					'category'		=> $result['category'],
					'unit'			=> $result['unit'],
					'store'     	=> isset($arr_stores[$store_id]) ? $arr_stores[$store_id] : 'Invalid Store ID',
					'store_id'		=> $store_id,
					'quantity'		=> $this->model_report_product_stock->getProductOnhandQuantity($result['product_id'],$store_id),
					'location'     	=> isset($arr_location[$location_id]) ? $arr_location[$location_id] : 'Invalid Location ID',
					'batch_date'    => $batch_date,
					'info' 			=> $this->url->link('report/product_movement', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'] , true),
				);
			}
		}
		$data['products'] = array_slice($data['products'], $start, $limit);

		$data['user_token'] = $this->session->data['user_token'];
		$data['cancel'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['categories'] = array();
		$categories = $this->model_report_product_stock->getCategories();


		foreach ($categories as $category) {
			$data['categories'][] = array(
				'category_id' => $category['category_id'],
				'name' => $category['name']
			);
		}

		//rebuild querystring for sorting
		$querystringforsort = '';

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$querystringforsort .= '&filter_location=' . $this->request->get['filter_location'];
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$querystringforsort .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
		}

		if (isset($this->request->get['filter_batch_date_end'])) {
			$querystringforsort .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$querystringforsort .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_category'])) {
			$querystringforsort .= '&filter_category=' . $this->request->get['filter_category'];
		}


		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

		if ($language_id == 1) {
			$data['sort_name'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=en_name' . $querystringforsort, true);
		} else {
			$data['sort_name'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=cn_name' . $querystringforsort, true);
		}
		$data['sort_code'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
		$data['sort_store'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=store_id' . $querystringforsort, true);
		$data['sort_location'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=location_id' . $querystringforsort, true);
		$data['sort_quantity'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
		$data['sort_batch_date'] = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=batch_date' . $querystringforsort, true);


		$url = '';

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$url .= '&filter_location=' . $this->request->get['filter_location'];
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$url .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
		}

		if (isset($this->request->get['filter_batch_date_end'])) {
			$url .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$data['export_all'] = $this->url->link('report/product_stock/export_excel_all', 'user_token=' . $this->session->data['user_token'], true);
		$data['export_search'] = $this->url->link('report/product_stock/export_excel_searched', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$pagination = new Pagination();
		$pagination->total = $product_total;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/product_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

		$data['filter_store_id'] = explode(',', $filter_store_id);
		$data['filter_location'] = explode(',', $filter_location);
		$data['filter_category'] = explode(',', $filter_category);
		$data['filter_batch_date_start'] = $filter_batch_date_start;
		$data['filter_batch_date_end'] = $filter_batch_date_end;
		$data['filter_product_name'] = $filter_product_name;
		$data['filter_product_code'] = $filter_product_code;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('report/product_stock', $data));
	}

	public function export_excel_all()
	{
		$this->load->language('report/product_stock');
		$this->load->model('report/product_stock');


		$product_info = $this->model_report_product_stock->getProductStockItemAll();

		if (!empty($product_info)) {
			// get user detail
			$this->load->model('user/user');
			$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

			// load php Excel
			$this->load->library('PHPExcel');
			$objPHPExcel = new PHPExcel();

			// Set document properties
			$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
				->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
				->setTitle('Title')
				->setSubject('Subject')
				->setDescription('Description')
				->setKeywords('report qiangyitang.com')
				->setCategory('report excel');

			// Set default font
			$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
				->setSize(10);

			$arr_stores = array();
			$data['stores'] = array();

			$sname = $this->config->get('config_name');

			$arr_stores[0] = $sname . $this->language->get('text_default');
			$data['stores'][] = array(
				'store_id' => 0,
				'name' => $sname . $this->language->get('text_default')
			);

			$product_item = $this->model_report_product_stock->getProductStockItemAll();

			$table_collection = array();

			if (!empty($product_item)) {
				foreach ($product_item as $item) {
					$store_id = ($item['store_id'] == '') ? 0 : $item['store_id'];
					$table_collection[] = [
						'code' => $item['code'],
						'name' => $item['cn_name'] . " " . $item['en_name'],
						'category' => $item['category'],
						'store'   => isset($arr_stores[$store_id]) ? $arr_stores[$store_id] : 'Invalid Store ID',
						'quantity' => $item['quantity'] . " " . $item['unit']
					];
				}
			}


			$table = array();

			$table[] = array('Report Name : ', $this->language->get('heading_title'));
			date_default_timezone_set("Asia/Kuala_Lumpur");
			$table[] = array('Date Export: ', date('m/d/Y h:i:s a'));

			$table[] = array();

			$table_header = array(
				$this->language->get('column_code'),
				$this->language->get('column_name'),
				$this->language->get('column_category'),
				$this->language->get('column_store'),
				$this->language->get('column_quantity')
			);

			$table[] = $table_header;

			$total_row = 0;

			$table_data = $table_collection;
			// $row;

			foreach ($table_data as $key => $data) {
				$row = array();

				foreach ($data as $key => $value) {
					$row[] = $value;
				}
				$table[] = $row;

				$total_row++;
			}

			// Styling
			$autosize_column_index = 'A';
			foreach ($table_header as $header) {
				$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
				$autosize_column_index++;
			}

			$header_index_s_column = 'A';
			$header_index_e_column = $header_index_s_column;
			foreach ($table_header as $col)
				$header_index_e_column++;
			$header_index_row = 4;
			$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

			$header_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				),
				'font' => array(
					'bold' => true
				)
			);
			$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

			$currency_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
				),
				'numberformat' => array(
					'code' => "0.00"
				)
			);

			$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

			// Add Array To Excel
			$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

			// Rename worksheet
			$sheettitle = $this->language->get('heading_title');
			$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
			$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

			// Set active sheet index to the first sheet, so Excel opens this as the first sheet
			$objPHPExcel->setActiveSheetIndex(0);

			$filename = $this->language->get('heading_title') . '_All';

			// Save Excel 2007 file
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			//ob_end_clean();
			// We'll be outputting an excel file
			header('Content-type: application/vnd.ms-excel');

			// It will be called file.xls
			header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
			$objWriter->save('php://output');
		}
	}

	public function export_excel_searched()
	{
		$this->load->language('report/product_stock');
		$this->load->model('report/product_stock');


		if (isset($this->request->get['filter_store_id'])) {
			$filter_store_id = $this->request->get['filter_store_id'];
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$filter_location = $this->request->get['filter_location'];
		} else {
			$filter_location = '';
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$filter_batch_date_start = $this->request->get['filter_batch_date_start'];
		} else {
			$filter_batch_date_start = '';
		}
		if (isset($this->request->get['filter_batch_date_end'])) {
			$filter_batch_date_end = $this->request->get['filter_batch_date_end'];
		} else {
			$filter_batch_date_end = '';
		}

		if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
		}

		if (isset($this->request->get['filter_product_code'])) {
			$filter_product_code = $this->request->get['filter_product_code'];
		} else {
			$filter_product_code = '';
		}

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = '';
		}

		$url = '';
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_location'])) {
			$url .= '&filter_location=' . $this->request->get['filter_location'];
		}

		if (isset($this->request->get['filter_batch_date_start'])) {
			$url .= '&filter_batch_date_start=' . $this->request->get['filter_batch_date_start'];
		}

		if (isset($this->request->get['filter_batch_date_end'])) {
			$url .= '&filter_batch_date_end=' . $this->request->get['filter_batch_date_end'];
		}

		if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
		}

		if (isset($this->request->get['filter_product_code'])) {
			$url .= '&filter_product_code=' . $this->request->get['filter_product_code'];
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . $this->request->get['filter_category'];
		}

		$filter_data = array(
			'filter_store_id'			=> $filter_store_id,
			'filter_location'			=> $filter_location,
			'filter_batch_date_start'	=> $filter_batch_date_start,
			'filter_batch_date_end'		=> $filter_batch_date_end,
			'filter_product_name'		=> $filter_product_name,
			'filter_product_code'		=> $filter_product_code,
			'filter_category'			=> $filter_category
		);

		$product_info = $this->model_report_product_stock->getProductStockItemAll();

		if (!empty($product_info)) {
			// get user detail
			$this->load->model('user/user');
			$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

			// load php Excel
			$this->load->library('PHPExcel');
			$objPHPExcel = new PHPExcel();

			// Set document properties
			$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
				->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
				->setTitle('Title')
				->setSubject('Subject')
				->setDescription('Description')
				->setKeywords('report qiangyitang.com')
				->setCategory('report excel');

			// Set default font
			$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
				->setSize(10);

			$arr_stores = array();
			$data['stores'] = array();

			$sname = $this->config->get('config_name');

			$arr_stores[0] = $sname . $this->language->get('text_default');
			$data['stores'][] = array(
				'store_id' => 0,
				'name' => $sname . $this->language->get('text_default')
			);

			$product_item = $this->model_report_product_stock->getProductStockItemSearched($filter_data);

			$table_collection = array();

			if (!empty($product_item)) {
				foreach ($product_item as $item) {
					$store_id = ($item['store_id'] == '') ? 0 : $item['store_id'];
					$table_collection[] = [
						'code' => $item['code'],
						'name' => $item['cn_name'] . " " . $item['en_name'],
						'category' => $item['category'],
						'store'   => isset($arr_stores[$store_id]) ? $arr_stores[$store_id] : 'Invalid Store ID',
						'quantity' => $item['quantity'] . " " . $item['unit']
					];
				}
			}


			$table = array();

			$table[] = array('Report Name : ', $this->language->get('heading_title'));
			date_default_timezone_set("Asia/Kuala_Lumpur");
			$table[] = array('Date Export: ', date('m/d/Y h:i:s a'));

			$table[] = array();

			$table_header = array(
				$this->language->get('column_code'),
				$this->language->get('column_name'),
				$this->language->get('column_category'),
				$this->language->get('column_store'),
				$this->language->get('column_quantity')
			);

			$table[] = $table_header;

			$total_row = 0;

			$table_data = $table_collection;
			// $row;

			foreach ($table_data as $key => $data) {
				$row = array();

				foreach ($data as $key => $value) {
					$row[] = $value;
				}
				$table[] = $row;

				$total_row++;
			}

			// Styling
			$autosize_column_index = 'A';
			foreach ($table_header as $header) {
				$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
				$autosize_column_index++;
			}

			$header_index_s_column = 'A';
			$header_index_e_column = $header_index_s_column;
			foreach ($table_header as $col)
				$header_index_e_column++;
			$header_index_row = 4;
			$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

			$header_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				),
				'font' => array(
					'bold' => true
				)
			);
			$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

			$currency_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
				),
				'numberformat' => array(
					'code' => "0.00"
				)
			);

			$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

			// Add Array To Excel
			$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

			// Rename worksheet
			$sheettitle = $this->language->get('heading_title');
			$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
			$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

			// Set active sheet index to the first sheet, so Excel opens this as the first sheet
			$objPHPExcel->setActiveSheetIndex(0);

			$filename = $this->language->get('heading_title') . '_Searched';

			// Save Excel 2007 file
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			//ob_end_clean();
			// We'll be outputting an excel file
			header('Content-type: application/vnd.ms-excel');

			// It will be called file.xls
			header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
			$objWriter->save('php://output');
		}
	}

	public function export_excel_selected()
	{
		$this->load->language('report/product_stock');
		$this->load->model('report/product_stock');

		if (isset($this->request->get['products'])) {
			$product_ids = explode(",", $this->request->get['products']);


			$product_info = $this->model_report_product_stock->getProductStockItemAll();

			if (!empty($product_info)) {
				// get user detail
				$this->load->model('user/user');
				$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

				// load php Excel
				$this->load->library('PHPExcel');
				$objPHPExcel = new PHPExcel();

				// Set document properties
				$objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
					->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
					->setTitle('Title')
					->setSubject('Subject')
					->setDescription('Description')
					->setKeywords('report qiangyitang.com')
					->setCategory('report excel');

				// Set default font
				$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
					->setSize(10);

				$arr_stores = array();
				$data['stores'] = array();

				$sname = $this->config->get('config_name');

				$arr_stores[0] = $sname . $this->language->get('text_default');
				$data['stores'][] = array(
					'store_id' => 0,
					'name' => $sname . $this->language->get('text_default')
				);

				$table_collection = array();
				foreach ($product_ids as $product_id) {

					$product_item = $this->model_report_product_stock->getProductStockItemSelected($product_id);

					if (!empty($product_item)) {
						foreach ($product_item as $item) {
							$store_id = ($item['store_id'] == '') ? 0 : $item['store_id'];
							$table_collection[] = [
								'code' => $item['code'],
								'name' => $item['cn_name'] . " " . $item['en_name'],
								'category' => $item['category'],
								'store'   => isset($arr_stores[$store_id]) ? $arr_stores[$store_id] : 'Invalid Store ID',
								'quantity' => $item['quantity'] . " " . $item['unit']
							];
						}
					}
				}

				$table = array();

				$table[] = array('Report Name : ', $this->language->get('heading_title'));
				date_default_timezone_set("Asia/Kuala_Lumpur");
				$table[] = array('Date Export: ', date('m/d/Y h:i:s a'));

				$table[] = array();

				$table_header = array(
					$this->language->get('column_code'),
					$this->language->get('column_name'),
					$this->language->get('column_category'),
					$this->language->get('column_store'),
					$this->language->get('column_quantity')
				);

				$table[] = $table_header;

				$total_row = 0;

				$table_data = $table_collection;
				// $row;

				foreach ($table_data as $key => $data) {
					$row = array();

					foreach ($data as $key => $value) {
						$row[] = $value;
					}
					$table[] = $row;

					$total_row++;
				}

				// Styling
				$autosize_column_index = 'A';
				foreach ($table_header as $header) {
					$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
					$autosize_column_index++;
				}

				$header_index_s_column = 'A';
				$header_index_e_column = $header_index_s_column;
				foreach ($table_header as $col)
					$header_index_e_column++;
				$header_index_row = 4;
				$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

				$header_style = array(
					'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
					),
					'font' => array(
						'bold' => true
					)
				);
				$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

				$currency_style = array(
					'alignment' => array(
						'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
					),
					'numberformat' => array(
						'code' => "0.00"
					)
				);

				$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

				// Add Array To Excel
				$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

				// Rename worksheet
				$sheettitle = $this->language->get('heading_title');
				$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
				$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

				// Set active sheet index to the first sheet, so Excel opens this as the first sheet
				$objPHPExcel->setActiveSheetIndex(0);

				$filename = $this->language->get('heading_title') . '_Selected';

				// Save Excel 2007 file
				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
				//ob_end_clean();
				// We'll be outputting an excel file
				header('Content-type: application/vnd.ms-excel');

				// It will be called file.xls
				header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
				$objWriter->save('php://output');
			}
		}
	}

	public function sync_qty()
	{
		$this->load->model('report/product_stock');
		$this->load->model('report/product_movement');

		$product_id = null;
		$store_id = null;
		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		}
		if (isset($this->request->post['store_id'])) {
			$store_id = $this->request->post['store_id'];
		}

		if ($product_id && ($store_id !== null)) {
			$stock_info = $this->model_report_product_stock->getProductSummaryByStore($product_id, $store_id);
			$result = array();
			$datetime = date('Y-m-d') . "  23:59:59";
			foreach ($stock_info as $info) {
				$location_id = $info['location_id'];
				$batch_date = $info['batch_date'];
				$close_qty = $this->model_report_product_movement->getProductStockByTransaction($datetime, $product_id, $store_id, $location_id, $batch_date);
				$result[] = array(
					"product_id" => $info['product_id'],
					"location_id" => $info['location_id'],
					"store_id" => $info['store_id'],
					"batch_date" => $info['batch_date'],
					"onhand_quantity" => $info['onhand_quantity'],
					"close_qty" => $close_qty,
					"modify_by" => $this->session->data['user_id']
				);
			}
			$result['success'] = true;
			$this->model_report_product_stock->updateProductQuantity($result);
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($result));
		}
	}

	public function getProductList()
    {
        $this->load->language('report/product_stock');
        $this->load->model('report/product_stock');

        if (isset($this->request->get['name'])) {
            $name = $this->request->get['name'];
        } else {
            $name = NULL;
        }

        if (isset($this->request->get['code'])) {
            $code = $this->request->get['code'];
        } else {
            $code = NULL;
        }
        if (isset($this->request->get['product_type'])) {
            $product_type = $this->request->get['product_type'];
        } else {
            $product_type = 2;
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';
        if (isset($this->request->get['row_id'])) {
            $url .= '&row_id=' . $this->request->get['row_id'];
        }

        if (isset($this->request->get['name'])) {
            $url .= '&name=' . urlencode(html_entity_decode($this->request->get['name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['code'])) {
            $url .= '&code=' . $this->request->get['code'];
        }

        if (isset($this->request->get['product_type'])) {
            $url .= '&product_type=' . $this->request->get['product_type'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }
		$product_id = $this->request->get['product_id'];
		$store_id = $this->request->get['store_id'];
		
        $data['user_token'] = $this->session->data['user_token'];
        $data['products'] = array();
        // $filter_data = array(
        //     'name' => $name,
        //     'code' => $code,
        //     'start' => ($page - 1) * $this->config->get('config_limit_admin'),
        //     'limit' => $this->config->get('config_limit_admin')
        // );

        // $product_total = $this->model_catalog_product->getTotalProductForStockReceived($filter_data);
        $results = $this->model_report_product_stock->productdetail($product_id,$store_id);


		
        foreach	($results as $result) {
            $data['products'][] = array(
                'product_id' => $result['product_id'],
                'batch_date' => $result['batch_date'],
                'warehouse' => $result['warehouse'],
                'zone' => $result['zone'],
                'lot' => $result['lot'],
                'quantity' => $result['quantity'],
				'info' => $this->url->link('report/product_movement', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'] . '&filter_batch_date_start=' .$result['batch_date'] .  '&filter_location=' .$result['location_id'] . '&filter_date_type=all' , true)
            );
        }
	

        // $pagination = new Pagination();
        // $pagination->total = $product_total;
        // $pagination->page = $page;
        // $pagination->limit = $this->config->get('config_limit_admin');;
        // $pagination->url = $this->url->link('report/product-stock/getProductList', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        // $data['pagination'] = $pagination->render();

        // $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['name'] = $name;
        $data['code'] = $code;
        $data['product_type'] = $product_type;
        $data['row_id'] = isset($this->request->get['row_id']) ? $this->request->get['row_id'] : false;
        $data['header'] = $this->load->controller('common/header/pop_header');

        $this->response->setOutput($this->load->view('openwindow/product_detail', $data));
    }
}
