<?php
class ControllerReportProductSerialNum extends Controller {
    private $error = [];
    private $status_arr = [1, 7, 5];

    public function index() {
        $this->load->language('report/product_serial_num');

		$this->document->setTitle($this->language->get('heading_title'));
		
        $this->load->model('report/product_serial_num');
        $this->load->model('localisation/order_status');

        if (isset($this->request->get['filter_production_date_from'])) {
			$filter_production_date_from = $this->request->get['filter_production_date_from'];
		} else {
			$filter_production_date_from = '';
        }
        
        if (isset($this->request->get['filter_production_date_to'])) {
			$filter_production_date_to = $this->request->get['filter_production_date_to'];
		} else {
			$filter_production_date_to = '';
        }
        
        if (isset($this->request->get['filter_expiry_date_from'])) {
			$filter_expiry_date_from = $this->request->get['filter_expiry_date_from'];
		} else {
			$filter_expiry_date_from = '';
        }
        
        if (isset($this->request->get['filter_expiry_date_to'])) {
			$filter_expiry_date_to = $this->request->get['filter_expiry_date_to'];
		} else {
			$filter_expiry_date_to = '';
        }
       
        if (isset($this->request->get['filter_invoice_prefix'])) {
			$filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
		} else {
			$filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_serial_num'])) {
			$filter_serial_num = $this->request->get['filter_serial_num'];
		} else {
			$filter_serial_num = '';
        }
        
        if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
        }

        if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = '';
        }
        
        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

        $url = '';

        if (isset($this->request->get['filter_production_date_from'])) {
			$url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
			$url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
			$url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
			$url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
			$url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
			$url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        
        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
        }
        
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['serial_nums'] = array();

        $filter_data = array(
            'filter_production_date_from'   => $filter_production_date_from,
            'filter_production_date_to'     => $filter_production_date_to,
            'filter_expiry_date_from'       => $filter_expiry_date_from,
            'filter_expiry_date_to'         => $filter_expiry_date_to,
            'filter_invoice_prefix'         => $filter_invoice_prefix,
            'filter_serial_num'             => $filter_serial_num,
            'filter_product_name'           => $filter_product_name,
            'filter_status'                 => $filter_status,
            'sort'					        => $sort,
            'order'					        => $order
        );
    
        $data['export_excel'] = $this->url->link('report/product_serial_num/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
        
        $data['total_quantity'] = 0;
        $data['total_actual_quantity'] = 0;
        $data['total_reject_quantity'] = 0;
        $data['total_quantity_left'] = 0;
        $data['total_scanned_quantity'] = 0;
        $data['total_scanned_orders'] = 0;

        $results = $this->model_report_product_serial_num->getSerialNums($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $temp_scanned_orders = [];
                $total_reject_quantity = 0;
                $total_scanned_quantity = 0;

                $production_qcs = $this->model_report_product_serial_num->get_production_qc($result['production_id']);
                $scanned_productions = $this->model_report_product_serial_num->get_scanned_production($result['production_id']);
                $scanned_orders = $this->model_report_product_serial_num->get_order_scanned($result['production_id']);

                $status_info = $this->model_localisation_order_status->getOrderStatus($result['status']);
                $status_name = !empty($status_info) ? $status_info['name'] : '';

                if (!empty($production_qcs)) {
                    foreach ($production_qcs as $qc) {
                        $total_reject_quantity += $qc['reject_quantity'];
                    }
                }

                if (!empty($scanned_productions)) {
                    foreach ($scanned_productions as $production) {
                        $total_scanned_quantity += $production['quantity'];
                    }
                }

                if (!empty($scanned_orders)) {
                    foreach ($scanned_orders as $order_row) {
                        $temp_scanned_orders[$order_row['order_id']][] = $order_row;
                    }
                }

                $quantity_left = $result['actual_quantity'] - $total_reject_quantity;

                $data['serial_nums'][] = [
                    'production_id'     => $result['production_id'],
                    'invoice_prefix'    => $result['invoice_prefix'],
                    'serial_num'        => $result['serial_num'],
                    'production_date'   => date($this->language->get('date_format_short'), strtotime($result['production_date'])),
                    'expiry_date'       => date($this->language->get('date_format_short'), strtotime($result['expiry_date'])),
                    'product_name'      => $result['product_name'],
                    'quantity'          => $result['quantity'],
                    'actual_quantity'   => $result['actual_quantity'],
                    'reject_quantity'   => $total_reject_quantity,
                    'quantity_left'     => $quantity_left,
                    'scanned_quantity'  => $total_scanned_quantity,
                    'scanned_orders'    => count($temp_scanned_orders),
                    'status'            => $result['status'],
                    'status_name'       => $status_name,
                    'view'              => $this->url->link('report/product_serial_num/info', 'user_token=' . $this->session->data['user_token'] . '&production_id=' . $result['production_id'] . $url, true)
                ];

                $data['total_quantity'] += $result['quantity'];
                $data['total_actual_quantity'] += $result['actual_quantity'];
                $data['total_reject_quantity'] += $total_reject_quantity;
                $data['total_quantity_left'] += $quantity_left;
                $data['total_scanned_quantity'] += $total_scanned_quantity;
                $data['total_scanned_orders'] += count($temp_scanned_orders);
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'invoice_prefix') {
                $invoice_prefix_column = array_column($data['serial_nums'], 'invoice_prefix');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $invoice_prefix_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $invoice_prefix_column, SORT_DESC);
                }
            } else if ($sort == 'serial_num') {
                $serial_num_column = array_column($data['serial_nums'], 'serial_num');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $serial_num_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $serial_num_column, SORT_DESC);
                }
            } else if ($sort == 'product_name') {
                $product_name_column = array_column($data['serial_nums'], 'product_name');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $product_name_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $product_name_column, SORT_DESC);
                }
            } else if ($sort == 'production_date') {
                $production_date_column = array_column($data['serial_nums'], 'production_date');
                $production_date_column = array_map('strtotime', $production_date_column);
                
                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $production_date_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $production_date_column, SORT_DESC);
                }
            } else if ($sort == 'expiry_date') {
                $expiry_date_column = array_column($data['serial_nums'], 'expiry_date');
                $expiry_date_column = array_map('strtotime', $expiry_date_column);

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $expiry_date_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $expiry_date_column, SORT_DESC);
                }
            } else if ($sort == 'quantity') {
                $quantity_column = array_column($data['serial_nums'], 'quantity');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $quantity_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $quantity_column, SORT_DESC);
                }
            } else if ($sort == 'actual_quantity') {
                $actual_quantity_column = array_column($data['serial_nums'], 'actual_quantity');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $actual_quantity_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $actual_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'reject_quantity') {
                $reject_quantity_column = array_column($data['serial_nums'], 'reject_quantity');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $reject_quantity_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $reject_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'quantity_left') {
                $quantity_left_column = array_column($data['serial_nums'], 'quantity_left');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $quantity_left_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $quantity_left_column, SORT_DESC);
                }
            } else if ($sort == 'scanned_quantity') {
                $scanned_quantity_column = array_column($data['serial_nums'], 'scanned_quantity');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $scanned_quantity_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $scanned_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'scanned_orders') {
                $scanned_orders_column = array_column($data['serial_nums'], 'scanned_orders');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $scanned_orders_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $scanned_orders_column, SORT_DESC);
                }
            } else if ($sort == 'status') {
                $status_column = array_column($data['serial_nums'], 'status');

                if($order == 'ASC'){
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $status_column, SORT_ASC);
                } else{
                    array_multisort($data['serial_nums'], SORT_NUMERIC, $status_column, SORT_DESC);
                }
            } 
        }

        $total_serial_nums = count($data['serial_nums']);

        $limit = $this->config->get('config_limit_admin');
        $start = ($page * $limit) - $limit;
        
        $data['serial_nums'] = array_slice($data['serial_nums'], $start, $limit);

        $querystringforsort = '';
		if (isset($this->request->get['filter_production_date_from'])) {
			$querystringforsort .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
		}

		if (isset($this->request->get['filter_production_date_to'])) {
			$querystringforsort .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
		}

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $querystringforsort .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $querystringforsort .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $querystringforsort .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $querystringforsort .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $querystringforsort .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
            $querystringforsort .= '&filter_status=' . $this->request->get['filter_status'];
        }

        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        // sort
        $data['sort_invoice_prefix'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
        $data['sort_serial_num'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=serial_num' . $querystringforsort, true);
        $data['sort_product_name'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=product_name' . $querystringforsort, true);
        $data['sort_quantity'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity' . $querystringforsort, true);
        $data['sort_actual_quantity'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=actual_quantity' . $querystringforsort, true);
        $data['sort_reject_quantity'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=reject_quantity' . $querystringforsort, true);
        $data['sort_quantity_left'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=quantity_left' . $querystringforsort, true);
        $data['sort_production_date'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=production_date' . $querystringforsort, true);
        $data['sort_expiry_date'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=expiry_date' . $querystringforsort, true);
        $data['sort_scanned_quantity'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=scanned_quantity' . $querystringforsort, true);
        $data['sort_scanned_orders'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=scanned_orders' . $querystringforsort, true);
        $data['sort_status'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $querystringforsort, true);

        $url = '';

        if (isset($this->request->get['filter_production_date_from'])) {
            $url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
            $url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
            $url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
            $url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
            $url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
            $url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
            $url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['production_statuses'] = [];

        foreach ($this->status_arr as $status_id) {
            $status_info = $this->model_localisation_order_status->getOrderStatus($status_id);

            if (!empty($status_info)) {
                $data['production_statuses'][] = [
                    'status_id'     => $status_id,
                    'name'          => $status_info['name']
                ];
            }
        }

        $pagination = new Pagination();
        $pagination->total = $total_serial_nums;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_serial_nums) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_serial_nums - $this->config->get('config_limit_admin'))) ? $total_serial_nums : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_serial_nums, ceil($total_serial_nums / $this->config->get('config_limit_admin')));

        $data['filter_production_date_from'] = $filter_production_date_from;
		$data['filter_production_date_to'] = $filter_production_date_to;
        $data['filter_expiry_date_from'] = $filter_expiry_date_from;
        $data['filter_expiry_date_to'] = $filter_expiry_date_to;
        $data['filter_invoice_prefix'] = $filter_invoice_prefix;
        $data['filter_serial_num'] = $filter_serial_num;
        $data['filter_product_name'] = $filter_product_name;
        $data['filter_status'] = $filter_status;

        $data['user_token'] = $this->session->data['user_token'];
        
        $data['sort'] = $sort;
        $data['order'] = $order;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('report/product_serial_num', $data));
    }

    public function info() {
        $this->load->language('report/product_serial_num');

		$this->document->setTitle($this->language->get('heading_title'));
		
        $this->load->model('report/product_serial_num');
        $this->load->model('catalog/production');
        $this->load->model('localisation/order_status');

        $url = '';
        
        if (isset($this->request->get['filter_production_date_from'])) {
			$url .= '&filter_production_date_from=' . $this->request->get['filter_production_date_from'];
        }

        if (isset($this->request->get['filter_production_date_to'])) {
			$url .= '&filter_production_date_to=' . $this->request->get['filter_production_date_to'];
        }

        if (isset($this->request->get['filter_expiry_date_from'])) {
			$url .= '&filter_expiry_date_from=' . $this->request->get['filter_expiry_date_from'];
        }

        if (isset($this->request->get['filter_expiry_date_to'])) {
			$url .= '&filter_expiry_date_to=' . $this->request->get['filter_expiry_date_to'];
        }

        if (isset($this->request->get['filter_invoice_prefix'])) {
			$url .= '&filter_invoice_prefix=' . $this->request->get['filter_invoice_prefix'];
        }

        if (isset($this->request->get['filter_serial_num'])) {
			$url .= '&filter_serial_num=' . $this->request->get['filter_serial_num'];
        }

        if (isset($this->request->get['filter_product_name'])) {
			$url .= '&filter_product_name=' . $this->request->get['filter_product_name'];
        }

        if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . $this->request->get['filter_status'];
        }
        
        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['production_id'])) {
            $this->response->redirect($this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'], true));   
        } else {
            $production_id = $this->request->get['production_id'];

            $production_info = $this->model_catalog_production->getProduction($production_id);
            $production_histories = $this->model_catalog_production->getProductionQc($production_id);

            $data['qc_histories'] = [];
            $data['total_reject_quantity'] = 0;
            
            if (!empty($production_histories)) {
                foreach ($production_histories as $history) {
                    $data['qc_histories'][] = [
                        'reason_reject'         => $history['reason_reject'],
                        'reject_quantity'       => $history['reject_quantity'],
                        'date_added'            => date($this->language->get('date_format_short'), strtotime($history['date_added']))
                    ];

                    $data['total_reject_quantity'] += $history['reject_quantity'];
                }
            }

            $temp_scanned_orders = [];
            $total_scanned_quantity = 0;
            $return_scanned_orders = [];
            $final_scanned_orders = [];

            $data['total_quantity_purchased'] = 0;
            $data['total_scanned_quantity'] = 0;

            if (!empty($production_info)) {
                $scanned_productions = $this->model_report_product_serial_num->get_scanned_production($production_id);
                $scanned_orders = $this->model_report_product_serial_num->get_order_scanned($production_id);

                if (!empty($scanned_productions)) {
                    foreach ($scanned_productions as $production) {
                        $order_product_row = $this->model_report_product_serial_num->get_order_product($production['order_product_id']);

                        $order_id = !empty($order_product_row) ? $order_product_row['order_id'] : 0;

                        $order_info = ($order_id > 0) ? $this->model_report_product_serial_num->get_order($order_id) : [];

                        $return_scanned_orders[$order_id . '-' . $production['order_product_id']][] = [
                            'scanned_quantity'      => $production['quantity']
                        ];
                    }
                }

                if (!empty($return_scanned_orders)) {
                    foreach ($return_scanned_orders as $order_id_order_product_id => $scanned_times) {
                        $order_id_order_product_id_arr = explode('-', $order_id_order_product_id);
                        $order_id = $order_id_order_product_id_arr[0];
                        $order_product_id = $order_id_order_product_id_arr[1];

                        $order_product_row = $this->model_report_product_serial_num->get_order_product($order_product_id);
                        $order_info = ($order_id > 0) ? $this->model_report_product_serial_num->get_order($order_id) : [];

                        $total_order_scanned_quantity = 0;

                        foreach ($scanned_times as $scan) {
                            $total_order_scanned_quantity += $scan['scanned_quantity'];
                        }

                        $final_scanned_orders[] = [
                            'order_id'              => $order_id,
                            'customer_name'         => !empty($order_info) ? $order_info['firstname'] . ' ' . $order_info['lastname'] : '',
                            'telephone'             => !empty($order_info) ? $order_info['telephone'] : '',
                            'email'                 => !empty($order_info) ? $order_info['email'] : '',
                            'product_name'          => !empty($order_product_row) ? $order_product_row['name'] : '',
                            'quantity_purchased'    => !empty($order_product_row) ? (int)$order_product_row['quantity'] : 0,
                            'scanned_quantity'      => $total_order_scanned_quantity,
                            'order_url'             => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $order_id, true)
                        ];

                        $data['total_quantity_purchased'] += !empty($order_product_row) ? (int)$order_product_row['quantity'] : 0;
                        $data['total_scanned_quantity'] += $total_order_scanned_quantity;
                        $total_scanned_quantity += $total_order_scanned_quantity;
                    }
                }

                if (!empty($scanned_orders)) {
                    foreach ($scanned_orders as $order_row) {
                        $temp_scanned_orders[$order_row['order_id']][] = $order_row;
                    }
                }

                $status_info = $this->model_localisation_order_status->getOrderStatus($production_info['status']);
                $status_name = !empty($status_info) ? $status_info['name'] : '';

                $production_stocks = $this->model_catalog_production->getProductionStocks($production_id);

                $data['production_info'] = [
                    'invoice_prefix'        => $production_info['invoice_prefix'],
                    'serial_num'            => $production_info['serial_num'],
                    'production_date'       => date($this->language->get('date_format_short'), strtotime($production_info['production_date'])),
                    'expiry_date'           => date($this->language->get('date_format_short'), strtotime($production_info['expiry_date'])),
                    'product_name'          => $production_info['product_name'],
                    'quantity'              => $production_info['quantity'],
                    'actual_quantity'       => $production_info['actual_quantity'],
                    'reject_quantity'       => $data['total_reject_quantity'],
                    'quantity_left'         => $production_info['actual_quantity'] - $data['total_reject_quantity'],
                    'scanned_quantity'      => $total_scanned_quantity,
                    'total_scanned_orders'  => count($temp_scanned_orders),
                    'scanned_orders'        => $final_scanned_orders,
                    'status_name'           => $status_name,
                    'production_stock'      => $production_stocks
                ];
            }
        }

        $data['cancel'] = $this->url->link('report/product_serial_num', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		$this->response->setOutput($this->load->view('report/product_serial_num_info', $data));
    }

    public function exportExcel() {
        $this->load->language('report/product_serial_num');
        $this->load->model('report/product_serial_num');
        $this->load->model('localisation/order_status');

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel =  new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()   ->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
        ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
        ->setTitle('Title')
        ->setSubject('Subject')
        ->setDescription('Description')
        ->setKeywords('report etcm.me')
        ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()  ->setName('Arial')
                                                    ->setSize(10);

        // Table Data

        // get data collection from database
        if (isset($this->request->get['filter_production_date_from'])) {
			$filter_production_date_from = $this->request->get['filter_production_date_from'];
		} else {
			$filter_production_date_from = '';
        }
        
        if (isset($this->request->get['filter_production_date_to'])) {
			$filter_production_date_to = $this->request->get['filter_production_date_to'];
		} else {
			$filter_production_date_to = '';
        }
        
        if (isset($this->request->get['filter_expiry_date_from'])) {
			$filter_expiry_date_from = $this->request->get['filter_expiry_date_from'];
		} else {
			$filter_expiry_date_from = '';
        }
        
        if (isset($this->request->get['filter_expiry_date_to'])) {
			$filter_expiry_date_to = $this->request->get['filter_expiry_date_to'];
		} else {
			$filter_expiry_date_to = '';
        }
        
        if (isset($this->request->get['filter_invoice_prefix'])) {
			$filter_invoice_prefix = $this->request->get['filter_invoice_prefix'];
		} else {
			$filter_invoice_prefix = '';
        }

        if (isset($this->request->get['filter_serial_num'])) {
			$filter_serial_num = $this->request->get['filter_serial_num'];
		} else {
			$filter_serial_num = '';
        }
        
        if (isset($this->request->get['filter_product_name'])) {
			$filter_product_name = $this->request->get['filter_product_name'];
		} else {
			$filter_product_name = '';
        }

        if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = '';
        }
        
        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

        $filter_data = array(
            'filter_production_date_from'   => $filter_production_date_from,
            'filter_production_date_to'     => $filter_production_date_to,
            'filter_expiry_date_from'       => $filter_expiry_date_from,
            'filter_expiry_date_to'         => $filter_expiry_date_to,
            'filter_invoice_prefix'         => $filter_invoice_prefix,
            'filter_serial_num'             => $filter_serial_num,
            'filter_product_name'           => $filter_product_name,
            'filter_status'                 => $filter_status,
            'sort'					        => $sort,
            'order'					        => $order
        );

        $table_collection = [];

        $results = $this->model_report_product_serial_num->getSerialNums($filter_data);

        $grand_total_quantity = 0;
        $grand_total_actual_quantity = 0;
        $grand_total_reject_quantity = 0;
        $grand_total_quantity_left = 0;
        $grand_total_scanned_quantity = 0;
        $grand_total_scanned_orders = 0;

        if (!empty($results)) {
            foreach ($results as $result) {
                $temp_scanned_orders = [];
                $total_reject_quantity = 0;
                $total_scanned_quantity = 0;

                $production_qcs = $this->model_report_product_serial_num->get_production_qc($result['production_id']);
                $scanned_productions = $this->model_report_product_serial_num->get_scanned_production($result['production_id']);
                $scanned_orders = $this->model_report_product_serial_num->get_order_scanned($result['production_id']);

                if (!empty($production_qcs)) {
                    foreach ($production_qcs as $qc) {
                        $total_reject_quantity += $qc['reject_quantity'];
                    }
                }

                if (!empty($scanned_productions)) {
                    foreach ($scanned_productions as $production) {
                        $total_scanned_quantity += $production['quantity'];
                    }
                }

                if (!empty($scanned_orders)) {
                    foreach ($scanned_orders as $order_row) {
                        $temp_scanned_orders[$order_row['order_id']][] = $order_row;
                    }
                }

                $quantity_left = $result['actual_quantity'] - $total_reject_quantity;

                $status_info = $this->model_localisation_order_status->getOrderStatus($result['status']);
                $status_name = !empty($status_info) ? $status_info['name'] : '';

                $table_collection[] = [
                    'invoice_prefix'    => $result['invoice_prefix'],
                    'serial_num'        => $result['serial_num'],
                    'product_name'      => $result['product_name'],
                    'production_date'   => date($this->language->get('date_format_short'), strtotime($result['production_date'])),
                    'expiry_date'       => date($this->language->get('date_format_short'), strtotime($result['expiry_date'])),
                    'quantity'          => $result['quantity'],
                    'actual_quantity'   => $result['actual_quantity'],
                    'reject_quantity'   => $total_reject_quantity,
                    'quantity_left'     => $quantity_left,
                    'scanned_quantity'  => $total_scanned_quantity,
                    'scanned_orders'    => count($temp_scanned_orders),
                    'status_name'       => $status_name
                ];

                $grand_total_quantity += $result['quantity'];
                $grand_total_actual_quantity += $result['actual_quantity'];
                $grand_total_reject_quantity += $total_reject_quantity;
                $grand_total_quantity_left += $quantity_left;
                $grand_total_scanned_quantity += $total_scanned_quantity;
                $grand_total_scanned_orders += count($temp_scanned_orders);
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'invoice_prefix') {
                $invoice_prefix_column = array_column($table_collection, 'invoice_prefix');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $invoice_prefix_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $invoice_prefix_column, SORT_DESC);
                }
            } else if ($sort == 'serial_num') {
                $serial_num_column = array_column($table_collection, 'serial_num');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $serial_num_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $serial_num_column, SORT_DESC);
                }
            } else if ($sort == 'product_name') {
                $product_name_column = array_column($table_collection, 'product_name');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $product_name_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $product_name_column, SORT_DESC);
                }
            } else if ($sort == 'production_date') {
                $production_date_column = array_column($table_collection, 'production_date');
                $production_date_column = array_map('strtotime', $production_date_column);
                
                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $production_date_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $production_date_column, SORT_DESC);
                }
            } else if ($sort == 'expiry_date') {
                $expiry_date_column = array_column($table_collection, 'expiry_date');
                $expiry_date_column = array_map('strtotime', $expiry_date_column);

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $expiry_date_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $expiry_date_column, SORT_DESC);
                }
            } else if ($sort == 'quantity') {
                $quantity_column = array_column($table_collection, 'quantity');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $quantity_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $quantity_column, SORT_DESC);
                }
            } else if ($sort == 'actual_quantity') {
                $actual_quantity_column = array_column($table_collection, 'actual_quantity');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $actual_quantity_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $actual_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'reject_quantity') {
                $reject_quantity_column = array_column($table_collection, 'reject_quantity');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $reject_quantity_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $reject_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'quantity_left') {
                $quantity_left_column = array_column($table_collection, 'quantity_left');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $quantity_left_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $quantity_left_column, SORT_DESC);
                }
            } else if ($sort == 'scanned_quantity') {
                $scanned_quantity_column = array_column($table_collection, 'scanned_quantity');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $scanned_quantity_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $scanned_quantity_column, SORT_DESC);
                }
            } else if ($sort == 'scanned_orders') {
                $scanned_orders_column = array_column($table_collection, 'scanned_orders');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $scanned_orders_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $scanned_orders_column, SORT_DESC);
                }
            } else if ($sort == 'status_name') {
                $status_name_column = array_column($table_collection, 'status_name');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $status_name_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $status_name_column, SORT_DESC);
                }
            }
        }

        $table_collection[] = [
            '',
            '',
            '',
            '',
            '',
            $grand_total_quantity,
            $grand_total_actual_quantity,
            $grand_total_reject_quantity,
            $grand_total_quantity_left,
            $grand_total_scanned_quantity, 
            $grand_total_scanned_orders
        ];

        $table = array();

        $table_header = array(//table headers
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_serial_num'),
			$this->language->get('column_product_name'),
			$this->language->get('column_production_date'),
			$this->language->get('column_expiry_date'),
			$this->language->get('column_quantity'),
			$this->language->get('column_actual_quantity'),
			$this->language->get('column_reject_quantity'),
			$this->language->get('column_quantity_left'),
			$this->language->get('column_scanned_quantity'),
			$this->language->get('column_scanned_orders'),
			$this->language->get('column_status')
        );
        
        $table[] = ['Report Name :', $this->language->get('heading_title')];
        
        $table[] = [];

        $table[] = $table_header;//add header to table
        
        $table_data = $table_collection;
		$row;
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 3;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
    
        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="'. $this->language->get('heading_title') . '.xlsx"');
        $objWriter->save('php://output');
    }
}
?>