<?php
class ControllerReportPosShipping extends Controller {
	public function index() {
		$this->load->language('report/pos_shipping');

		$this->document->setTitle($this->language->get('heading_title'));
		
		$this->load->model('report/pos');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			if($this->request->get['filter_payment_status']){
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
		} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_shipping_name'])) {
			$filter_shipping_name = $this->request->get['filter_shipping_name'];
		} else {
			$filter_shipping_name = '';
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_shipping_name'])) {
			$url .= '&filter_shipping_name=' . $this->request->get['filter_shipping_name'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		//urls
		$data['export_excel'] = $this->url->link('report/pos_shipping/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end' => $filter_transaction_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_shipping_name'	=> $filter_shipping_name,
			'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_transaction_start'] = $filter_transaction_start;
		$data['filter_transaction_end'] = $filter_transaction_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_payment_status'] = $filter_payment_status;
		$data['filter_shipping_name'] = $filter_shipping_name;
		
		//**data
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		$this->load->library('weight');
		$this->weight = new Weight($this->registry);
		
		$data['sales'] = array();
		$sales = $this->model_report_pos->getShipping($filter_data);
		
		foreach($sales as $sale){
			$label = '';

			switch($sale['order_status_id']){
				case 1:
					$label = 'warning';
					break;
				case 5:
					$label = 'success';
					break;
				case 7:
				case 17:
					$label = 'danger';
					break;
			}

			$data['sales'][] = array(
				'invoice_prefix'	=> $sale['invoice_prefix'],
				'date_added'		=> date('Y-m-d', strtotime($sale['date_added'])),
				'title'				=> $sale['title'],
				'order_status_id'	=> $sale['order_status_id'],
				'label'				=> $label,
				'order_status'		=> $sale['order_status'],
				'cost' 				=> $this->currency->format($sale['cost'],$this->config->get('config_currency')),
				'tax' 				=> $this->currency->format($sale['tax'],$this->config->get('config_currency')),
				'total' 			=> $this->currency->format($sale['total'],$this->config->get('config_currency'))
			);
		}
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$querystringforsort .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$querystringforsort .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if(isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if(isset($this->request->get['filter_shipping_name'])) {
			$querystringforsort .= '&filter_shipping_name=' . $this->request->get['filter_shipping_name'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_invoice_prefix'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
		$data['sort_date_added'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystringforsort, true);
		$data['sort_title'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=title' . $querystringforsort, true);
		$data['sort_status'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $querystringforsort, true);
		$data['sort_cost'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=cost' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		
		//**language
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_shipping_name'])) {
			$url .= '&filter_shipping_name=' . $this->request->get['filter_shipping_name'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_pos->getShippingTotal($filter_data);
		
		$data['total_cost'] = $this->currency->format($this->model_report_pos->getShippingTotalCost($filter_data),$this->config->get('config_currency'));
		$data['total_tax'] = $this->currency->format($this->model_report_pos->getShippingTotalTax($filter_data),$this->config->get('config_currency'));
		$data['total_shipping'] = $this->currency->format($this->model_report_pos->getShippingTotalShipping($filter_data),$this->config->get('config_currency'));
		
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/pos_shipping', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/pos_shipping', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/pos');
		$this->load->language('report/pos_shipping');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			if($this->request->get['filter_payment_status']){
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
		} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end' => $filter_transaction_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'sort'					=> $sort,
			'order'					=> $order
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$sales = $this->model_report_pos->getShipping($filter_data);
		
		$table_collection = array();
		
		foreach($sales as $sale){
			$table_collection[] = array(
				'invoice_prefix'	=> $sale['invoice_prefix'],
				'date_added'		=> date('Y-m-d', strtotime($sale['date_added'])),
				'title'				=> $sale['title'],
				'order_status'		=> $sale['order_status'],
				'cost' 			=> $this->currency->format($sale['cost'],$this->config->get('config_currency'), '', false),
				'tax' 				=> $this->currency->format($sale['tax'],$this->config->get('config_currency'), '', false),
				'total' 			=> $this->currency->format($sale['total'],$this->config->get('config_currency'), '', false)
			);
		}
		
		$total_cost = $this->currency->format($this->model_report_pos->getShippingTotalCost($filter_data),$this->config->get('config_currency'), '', false);
		$total_tax = $this->currency->format($this->model_report_pos->getShippingTotalTax($filter_data),$this->config->get('config_currency'), '', false);
		$total_shipping = $this->currency->format($this->model_report_pos->getShippingTotalShipping($filter_data),$this->config->get('config_currency'), '', false);
		
		$table_collection[] = array(
			'', '', '', '',
			$total_cost,
			$total_tax,
			$total_shipping
		);
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		$table[] = array();
		/*
		$table[] = array('Report Summary : ');
		
		$total_cost = $this->currency->format($this->model_report_pos->getShippingTotalCost($filter_data),$this->config->get('config_currency'));
		$total_tax = $this->currency->format($this->model_report_pos->getShippingTotalTax($filter_data),$this->config->get('config_currency'));
		$total_shipping = $this->currency->format($this->model_report_pos->getShippingTotalShipping($filter_data),$this->config->get('config_currency'));
		
		$table[] = array($this->language->get('text_total_cost'), $total_cost);
		$table[] = array($this->language->get('text_total_tax'), $total_tax);
		$table[] = array($this->language->get('text_total_shipping'), $total_shipping);
		
		$table[] = array(); // add a space
		
		$table[] = array('Report Details : ');
		*/
		
		$table_header = array(//table headers
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_date_added'),
			$this->language->get('column_title'),
			$this->language->get('column_status'),
			$this->language->get('column_cost'),
			$this->language->get('column_tax'),
			$this->language->get('column_total')
		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		
		$total_row = 0;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":F" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		//debug test
		//$table = array("one", "two", "three");
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>