<?php
class ControllerReportHerbalremediesDetailByStock extends Controller {
	public function index() {
		$this->load->language('report/herbalremedies_detail_by_stock');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');
		
		$this->load->model('report/sale');		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
				$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			if(!empty($this->request->get['form_transaction'])){
				$filter_date_start = '';
			}else{
				$filter_date_start = date('Y-m-01');
			}
		}

		if (isset($this->request->get['filter_date_end'])) {
				$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			if(!empty($this->request->get['form_transaction'])){
				$filter_date_end = '';
			}else{
				$filter_date_end = date('Y-m-t');
			}
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else{
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_order_status'])) {
				$filter_order_status = $this->request->get['filter_order_status'];
			} else {
			$filter_order_status = 5;
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = NULL;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		//**querystring
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_order_status'])) {
			$url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}

		if (isset($this->request->get['filter_payment_method'])) {
			$url .= '&filter_payment_method=' . $this->request->get['filter_payment_method'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}
		
		//** sitemap
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);
		//urls
		$data['export_excel'] = $this->url->link('report/herbalremedies_detail_by_stock/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);
		
		//** filter data
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end' => $filter_transaction_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_order_status'	=> $filter_order_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'filter_model'			=> $filter_model,
			'sort'					=> $sort,
			'order'					=> $order,
			'start' 				=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit' 				=> $this->config->get('config_limit_admin')
		);
		
		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_transaction_start'] = $filter_transaction_start;
		$data['filter_transaction_end'] = $filter_transaction_end;
		$data['filter_store_id'] = $filter_store_id;
		$data['filter_payment_status'] = explode(',',$filter_payment_status);
		$data['filter_order_status'] = explode(',',$filter_order_status);
		$data['filter_payment_method'] = explode(',',$filter_payment_method);
		$data['filter_code'] = $filter_code;
		$data['filter_name_cn'] = $filter_name_cn;
		$data['filter_name_en'] = $filter_name_en;
		$data['filter_model'] = $filter_model;
		
		//**data
		$data['user_view'] = $this->user->user_view;
		
		$this->load->model('setting/store');
		$data['stores'] = array();
		
		$sname = $this->config->get('config_name');
		
		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);
		
		$stores = $this->model_setting_store->getStores();
		
		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}
		
		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		$data['payment_methods'] = $this->model_report_sale->getPaymentMethod();
		
		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;
		
		//listing data
		
		$this->load->library('weight');
		$this->weight = new Weight($this->registry);
		
		$data['sales'] = array();
		$sales = $this->model_report_sale->getHerbalremediesDetailByStock($filter_data);


		foreach($sales as $sale){
			$label = ''; 

			switch($sale['payment_status_id']){
				case 1:
					$label = 'warning';
					break;
				case 5:
					$label = 'success';
					break;
				case 7:
				case 17:
					$label = 'danger';
					break;
			}
				
			$data['sales'][] = array(
				'invoice_prefix' 	=> $sale['invoice_prefix'],
				'sales_date' 		=> date('Y-m-d', strtotime($sale['sales_date'])),
				'product_id' 		=> $sale['product_id'],
				'code' 				=> $sale['code'],
				'en_name' 			=> $sale['en_name'],
				'cn_name' 			=> $sale['cn_name'],
				'model' 			=> $sale['model'],
				'payment_status' 	=> $sale['payment_status'],
				'label'				=> $label,
				'payment_status_id' => $sale['payment_status_id'],
				'costprice' 		=> $this->currency->format($sale['costprice'],$this->config->get('config_currency')),
				'price' 			=> $this->currency->format($sale['price'],$this->config->get('config_currency')),
				'quantity' 			=> $this->weight->convert($sale['weight'], $sale['weight_class_id'], $this->config->get('config_weight_class_id')),
				'total_cost' 		=> $this->currency->format(($sale['costprice'] * $sale['total_weight']),$this->config->get('config_currency')),
				'total_sale'		=> $this->currency->format($sale['rowtotal'],$this->config->get('config_currency')),
				'percent'			=> round((($sale['rowtotal'] - ($sale['costprice'] * $sale['total_weight'])) / $sale['rowtotal']) * 100,2) . '%'
			);
			
		}

		
		
		//** soting url
		//rebuild querystring for sorting
		$querystringforsort = '';
		
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$querystringforsort .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$querystringforsort .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if(isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if(isset($this->request->get['filter_order_status'])) {
			$querystringforsort .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}
		
		if(isset($this->request->get['filter_code'])) {
			$querystringforsort .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if(isset($this->request->get['filter_name_cn'])) {
			$querystringforsort .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if(isset($this->request->get['filter_name_en'])) {
			$querystringforsort .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if(isset($this->request->get['filter_model'])) {
			$querystringforsort .= '&filter_model=' . $this->request->get['filter_model'];
		}
		
		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
		
		$data['sort_invoice_prefix'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=invoice_prefix' . $querystringforsort, true);
		$data['sort_sales_date'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=sales_date' . $querystringforsort, true);
		$data['sort_product_id'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=product_id' . $querystringforsort, true);
		$data['sort_code'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
		$data['sort_en_name'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=en_name' . $querystringforsort, true);
		$data['sort_cn_name'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=cn_name' . $querystringforsort, true);
		$data['sort_model'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=model' . $querystringforsort, true);
		$data['sort_payment_status'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=payment_status' . $querystringforsort, true);
		$data['sort_costprice'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=costprice' . $querystringforsort, true);
		$data['sort_price'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=price' . $querystringforsort, true);
		$data['sort_total_weight'] = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . '&sort=total_weight' . $querystringforsort, true);
		
		//**language
		
		
		//**querysting for pagination
		$url = '';
		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
		}
		
		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}
		
		if (isset($this->request->get['filter_order_status'])) {
			$url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
		}
		
		if (isset($this->request->get['filter_code'])) {
			$url .= '&filter_code=' . $this->request->get['filter_code'];
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$url .= '&filter_name_cn=' . $this->request->get['filter_name_cn'];
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$url .= '&filter_name_en=' . $this->request->get['filter_name_en'];
		}
		
		if (isset($this->request->get['filter_model'])) {
			$url .= '&filter_model=' . $this->request->get['filter_model'];
		}
		
		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}
		
		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}
		
		$total_sales_result = $this->model_report_sale->getHerbalremediesDetailByStockTotal($filter_data);
		$data['total_quantity'] = $this->weight->format($this->model_report_sale->getHerbalremediesDetailByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		$data['final_total_cost'] = $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalCost($filter_data),$this->config->get('config_currency'));
		$data['final_total_sale'] = $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalSale($filter_data),$this->config->get('config_currency'));
		//**pagination
		$pagination = new Pagination();
		$pagination->total = $total_sales_result;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/herbalremedies_detail_by_stock', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/herbalremedies_detail_by_stock')){
			$data['user_modify'] = true;
		}

		$data['pagination'] = $pagination->render();
		
		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_sales_result) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_sales_result - $this->config->get('config_limit_admin'))) ? $total_sales_result : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_sales_result, ceil($total_sales_result / $this->config->get('config_limit_admin')));
		
		//**template
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		
		//**layout
		$this->response->setOutput($this->load->view('report/herbalremedies_detail_by_stock', $data));
	}
	
	public function exportExcel(){
		
		$this->load->model('report/sale');
		$this->load->language('report/herbalremedies_detail_by_stock');
		
		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}
		
		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}
		
		if (isset($this->request->get['filter_transaction_start'])) {
			$filter_transaction_start = $this->request->get['filter_transaction_start'];
		} else {
			$filter_transaction_start = '';
		}
		
		if (isset($this->request->get['filter_transaction_end'])) {
			$filter_transaction_end = $this->request->get['filter_transaction_end'];
		} else {
			$filter_transaction_end = '';
		}
		
		if (isset($this->request->get['filter_store_id'])) {
				$filter_store_id = $this->request->get['filter_store_id'];
			} else{
			$filter_store_id = $this->session->data['store_id'];
		}
		
		if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
			$filter_payment_status = 5;
		}
		
		if (isset($this->request->get['filter_order_status'])) {
				$filter_order_status = $this->request->get['filter_order_status'];
			} else {
			$filter_order_status = 5;
		}
		
		if (isset($this->request->get['filter_payment_method'])) {
			$filter_payment_method = $this->request->get['filter_payment_method'];
		} else {
			$filter_payment_method = '';
		}
		
		if (isset($this->request->get['filter_code'])) {
			$filter_code = $this->request->get['filter_code'];
		} else {
			$filter_code = NULL;
		}
		
		if (isset($this->request->get['filter_name_cn'])) {
			$filter_name_cn = $this->request->get['filter_name_cn'];
		} else {
			$filter_name_cn = NULL;
		}
		
		if (isset($this->request->get['filter_name_en'])) {
			$filter_name_en = $this->request->get['filter_name_en'];
		} else {
			$filter_name_en = NULL;
		}
		
		if (isset($this->request->get['filter_model'])) {
			$filter_model = $this->request->get['filter_model'];
		} else {
			$filter_model = NULL;
		}
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}
		
		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'invoice_prefix';
		}
		
		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}
		
		$filter_data = array(
			'filter_date_start' 	=> $filter_date_start,
			'filter_date_end' 		=> $filter_date_end,
			'filter_transaction_start' => $filter_transaction_start,
			'filter_transaction_end' => $filter_transaction_end,
			'filter_store_id' 		=> $filter_store_id,
			'filter_payment_status'	=> $filter_payment_status,
			'filter_order_status'	=> $filter_order_status,
			'filter_payment_method'	=> $filter_payment_method,
			'filter_code'			=> $filter_code,
			'filter_name_cn'		=> $filter_name_cn,
			'filter_name_en'		=> $filter_name_en,
			'filter_model'			=> $filter_model,
			'sort'					=> $sort,
			'order'					=> $order,
		);
		
		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);
		
		//get gst code
		$this->load->model('setting/store');
		// $gstno = $this->model_setting_store->getGstCode($this->config->get('config_store_id'));
		
		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();
		
		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data
		
		//get data collection from database
		$sales = $this->model_report_sale->getHerbalremediesDetailByStock($filter_data);
		
		$table_collection = array();
		
		foreach($sales as $sale){
			$table_collection[] = array(
				'sales_date' 		=> date('Y-m-d', strtotime($sale['sales_date'])),
				'invoice_prefix' 	=> $sale['invoice_prefix'],
				'product_id' 		=> $sale['product_id'],
				'code' 				=> $sale['code'],
				'model' 			=> $sale['model'],
				'costprice' 		=> $this->currency->format($sale['costprice'],$this->config->get('config_currency')),
				'price' 			=> $this->currency->format($sale['price'],$this->config->get('config_currency')),
				'quantity' 			=> $this->weight->convert($sale['weight'], $sale['weight_class_id'], $this->config->get('config_weight_class_id')),
				'total_cost' 		=> $sale['costprice'] * $sale['total_weight'],
				'total_sale'		=> $sale['rowtotal'],
				'percent'			=> round((($sale['rowtotal'] - ($sale['costprice'] * $sale['total_weight'])) / $sale['rowtotal']) * 100,2) . '%'
			);
			
		}
	
		
		$total_quantity = $this->weight->format($this->model_report_sale->getHerbalremediesDetailByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		$final_total_cost= $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalCost($filter_data),$this->config->get('config_currency'));
		$final_total_sale = $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalSale($filter_data),$this->config->get('config_currency'));
		
		
		$table_collection[] = array('', '', '', '', '', '', '', $total_quantity,$final_total_cost,$final_total_sale,'');
		
		$table = array();
		
		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
		
		/*
		$table[] = array('Report Summary : ');
		
		$total_cost = $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalCost($filter_data),$this->config->get('config_currency'));
		$total_selling_price = $this->currency->format($this->model_report_sale->getHerbalremediesDetailByStockTotalSellingPrice($filter_data),$this->config->get('config_currency'));
		$total_quantity = $this->weight->format($this->model_report_sale->getHerbalremediesDetailByStockTotalQuantity($filter_data),$this->config->get('config_weight'));
		
		$table[] = array($this->language->get('text_total_cost'), 			$total_cost);
		$table[] = array($this->language->get('text_total_selling_price'),	$total_selling_price);
		$table[] = array($this->language->get('text_total_quantity'), 		$total_quantity);
		*/
		$table[] = array(); // add a space
		
		//$table[] = array('Report Detail : ');
		
		$table_header = array(//table headers
			$this->language->get('column_sales_date'),
			$this->language->get('column_invoice_prefix'),
			$this->language->get('column_product_id'),
			$this->language->get('column_product_code'),
			$this->language->get('column_model'),
			$this->language->get('column_cost'),
			$this->language->get('column_price'),
			$this->language->get('column_quantity'),
			$this->language->get('text_total_cost'),
			$this->language->get('text_total_selling_price'),
			$this->language->get('text_total_percent'),

		);
		$table[] = $table_header;//add header to table
		
		$table_data = $table_collection;
		$row;
		$total_row = 0;
		
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table
			$total_row ++;
		}
		
		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}
		
		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";
		
		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);
		
		$product_id_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
			),
			'numberformat' => array(
				'code' => "0000"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($product_id_style);
		
		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		
		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);
		
	
		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);
	
		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);
	
		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;
		
		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');
		
		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}
}
?>