<?php
class ControllerReportHerbalremediesByDoctor extends Controller {
	public function index() {
		error_reporting(E_ALL);

		// echo "test ok";
		$this->load->language('report/herbalremedies_by_doctor');
		$this->document->addScript('view/javascript/bootstrap/js/bootstrap-multiselect.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-multiselect.css');
        $this->document->addScript('view/javascript/bootstrap/js/bootstrap-select.min.js');
        $this->document->addStyle('view/javascript/bootstrap/css/bootstrap-select.css');

		$this->document->setTitle($this->language->get('heading_title'));

		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}

		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = 5;
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 5;
		}
		
		
		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . $url, true)
		);

		//urls
		$data['export_excel'] = $this->url->link('report/herbalremedies_by_doctor/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

		$this->load->model('report/herbalremedies');

		$data['orders'] = array();

		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			'filter_doctor_name' 				=> $filter_doctor_name,
			'filter_store_id' 			=> $filter_store_id,
			'filter_payment_status' 	=> $filter_payment_status,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order,
			'start'                 	=> ($page - 1) * $this->config->get('config_limit_admin'),
			'limit'                 	=> $this->config->get('config_limit_admin')
		);
		$results = $this->model_report_herbalremedies->getHerbalremediesByDoctor($filter_data);

		$total = $this->model_report_herbalremedies->getTotalHerbalremediesByDoctor($filter_data);

		$total_transaction = count($total);

		foreach ($results as $result) {
			$data['orders'][] = array(
				'total_cs'			=> $result['total_cs'],
				'doctor_name'		=> $result['doctor_name'],
				'doctor_id'			=> $result['doctor_id'],
				'medicine_total' 	=> $this->currency->format($result['medical_total'], $this->config->get('config_currency')),
				'medical_total'  	=> $this->currency->format($result['medicine_total1'] + $result['medicine_total2'], $this->config->get('config_currency')),
				'payment_total'		=> $this->currency->format($result['payment_total'], $this->config->get('config_currency')),
				'clinicalsale_consultation' => $this->currency->format($result['consultation_total'], $this->config->get('config_currency')),
				'info' 				=> $this->url->link('report/herbalremedies_by_transaction', 'user_token=' . $this->session->data['user_token'] . '&filter_doctor_name='. $result['doctor_id'].'&filter_invoice_date_start='.$filter_date_start.'&filter_invoice_date_end='.$filter_date_end , true)
			);
		}

		$data['total_by_doctor'] = array();

		$total_cs = 0;
		$total_medical_total = 0;
		$total_medicine_total = 0;
		$clinicalsale_consultation = 0;
		$payment_total = 0;


		foreach($total as $result){
			$total_cs += $result['total_cs'];
			$total_medicine_total += $result['medical_total'];
			$total_medical_total += $result['medicine_total1'] + $result['medicine_total2'];
			$clinicalsale_consultation += $result['consultation_total'];
			$payment_total += $result['payment_total'] ;

		}

		$data['total_by_doctor'] = array(
			'total_cs'			=> $total_cs,
			'total_medicine_total'	=> $this->currency->format($total_medicine_total, $this->config->get('config_currency')),
			'total_medical_total'	=> $this->currency->format($total_medical_total, $this->config->get('config_currency')),
			'clinicalsale_consultation'	=> $this->currency->format($clinicalsale_consultation, $this->config->get('config_currency')),
			'payment_total'	=> $this->currency->format($payment_total, $this->config->get('config_currency')),		

		);

		

		$data['user_token'] = $this->session->data['user_token'];
		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['user_view'] = $this->user->user_view;

		$this->load->model('setting/store');
		$data['stores'] = array();

		$sname = $this->config->get('config_name');

		$data['stores'][] = array(
			'store_id' => 0,
			'name'     => $sname . $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name'     => $store['name']
			);
		}

		$this->load->model('localisation/order_status');
		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		//rebuild querystring for sorting
		$querystringforsort = '';
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$querystringforsort .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$querystringforsort .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$querystringforsort .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$querystringforsort .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		$querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

		$data['sort_name'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
		$data['sort_total_cs'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=total_cs' . $querystringforsort, true);
		$data['sort_subtotal'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=subtotal' . $querystringforsort, true);
		$data['sort_tax'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=tax' . $querystringforsort, true);
		$data['sort_total'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=total' . $querystringforsort, true);
		$data['sort_d_subtotal'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=d_subtotal' . $querystringforsort, true);
		$data['sort_d_tax'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=d_tax' . $querystringforsort, true);
		$data['sort_d_total'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . '&sort=d_total' . $querystringforsort, true);

		$url = '';

		if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
		}

		if (isset($this->request->get['filter_store_id'])) {
			$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $total_transaction;
		$pagination->page = $page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

		$data['user_modify'] = false;
		if($this->user->hasPermission('modify', 'report/herbalremedies_by_doctor')){
			$data['user_modify'] = true;
		}

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

		$data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
		$data['filter_doctor_name'] = explode(',',$filter_doctor_name);
		$data['filter_store_id'] = explode(',',$filter_store_id);
		$data['filter_payment_status'] = explode(',',$filter_payment_status);
		$data['filter_order_status_id'] = explode(',',$filter_order_status_id);
		$data['doctors'] = $this->model_report_herbalremedies->getdoctorlist();


		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('report/herbalremedies_by_doctor', $data));

	}

	public function info(){
		$doctor_id = isset($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : 0;

		$this->load->model('user/user');
		$doctor = $this->model_user_user->getDoctor($doctor_id);

		if(!empty($doctor)){
			//load default model
			$this->load->model('report/herbalremedies');

			//load default language
			$this->load->language('report/herbalremedies_by_doctor');

			$data['name'] = $doctor['firstname'] . ' ' . $doctor['lastname'];

			if (isset($this->request->get['filter_date_start'])) {
				$filter_date_start = $this->request->get['filter_date_start'];
			} else {
				$filter_date_start = date('Y-m-01');
			}
	
			if (isset($this->request->get['filter_date_end'])) {
				$filter_date_end = $this->request->get['filter_date_end'];
			} else {
				$filter_date_end = date('Y-m-t');
			}
	
			if (isset($this->request->get['filter_doctor_name'])) {
				$filter_doctor_name = $this->request->get['filter_doctor_name'];
			} else {
				$filter_doctor_name = '';
			}
	
			if (isset($this->request->get['filter_store_id'])) {
				if($this->request->get['filter_store_id'] != '*'){
					$filter_store_id = $this->request->get['filter_store_id'];
				} else {
					$filter_store_id = '';
				}
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}
	
			if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
	
			if (isset($this->request->get['filter_order_status_id'])) {
				$filter_order_status_id = $this->request->get['filter_order_status_id'];
			} else {
				$filter_order_status_id = 0;
			}

			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}

			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
			} else {
				$sort = 'clinical_sale_id';
			}

			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
			} else {
				$order = 'ASC';
			}


			if (isset($this->request->get['info_page'])) {
				$info_page = $this->request->get['info_page'];
			} else {
				$info_page = 1;
			}


			$filter_data = array(
				'filter_date_start'	    	=> $filter_date_start,
				'filter_date_end'	    	=> $filter_date_end,
				'filter_payment_status' 	=> $filter_payment_status,
				'filter_store_id' 			=> $filter_store_id,
				'filter_doctor_name'		=> $filter_doctor_name,
				'filter_order_status_id' 	=> $filter_order_status_id,
				'sort'						=> $sort,
				'order'						=> $order,
				'start'                 	=> ($info_page - 1) * $this->config->get('config_limit_admin'),
				'limit'                 	=> $this->config->get('config_limit_admin')
			);

			$transaction_item = $this->model_report_herbalremedies->getHerbalremediesByDoctorInfo($doctor_id, $filter_data);
			$total = $this->model_report_herbalremedies->getTotalHerbalremediesByDoctorInfo($doctor_id, $filter_data);

			$total_transaction = count($total);

			//set document title
			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}

			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
			} else {
				$sort = 'sales_date';
			}

			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
			} else {
				$order = 'DESC';
			}

			//**sitemap
			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'], true)
			);

			//**text
			

			//**entry


			$data['user_token'] = $this->session->data['user_token'];
			$data['sort'] = $sort;
			$data['order'] = $order;

			//**data
			foreach($transaction_item as $product){
				$data['transaction_item'][] = array(
					'sales_date' => date($this->language->get('date_format_short'), strtotime($product['sales_date'])),
					'invoice_prefix' => $product['invoice_prefix'],
					'subtotal' => $this->currency->format($product['subtotal'], $this->config->get('config_currency')),
					'tax' => $this->currency->format($product['tax'], $this->config->get('config_currency')),
					'total' => $this->currency->format($product['total'], $this->config->get('config_currency')),
					'd_subtotal' => $this->currency->format($product['d_subtotal'], $this->config->get('config_currency')),
					'd_tax' => $this->currency->format($product['d_tax'], $this->config->get('config_currency')),
					'd_total' => $this->currency->format($product['d_total'], $this->config->get('config_currency'))
				);
			}

			$data['grand_total'] = array();

			$total_subtotal = 0;
			$total_tax = 0;
			$total_total = 0;
			$total_d_subtotal = 0;
			$total_d_tax = 0;
			$total_d_total = 0;

			foreach($total as $result){
				$total_subtotal += $result['subtotal'];
				$total_tax += $result['tax'];
				$total_total += $result['total'];
				$total_d_subtotal += $result['d_subtotal'];
				$total_d_tax += $result['d_tax'];
				$total_d_total += $result['d_total'];
			}

			$data['grand_total'] = array(
				'subtotal'		=> $this->currency->format($total_subtotal, $this->config->get('config_currency')),
				'tax'			=> $this->currency->format($total_tax, $this->config->get('config_currency')),
				'total'			=> $this->currency->format($total_total, $this->config->get('config_currency')),
				'd_subtotal'	=> $this->currency->format($total_d_subtotal, $this->config->get('config_currency')),
				'd_tax'			=> $this->currency->format($total_d_tax, $this->config->get('config_currency')),
				'd_total'		=> $this->currency->format($total_d_total, $this->config->get('config_currency'))
			);

			//**url
			$url = '';

			if (isset($this->request->get['filter_date_start'])) {
				$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
			}

			if (isset($this->request->get['filter_date_end'])) {
				$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_transaction_start'])) {
				$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
			}

			if (isset($this->request->get['filter_transaction_end'])) {
				$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
			}

			if (isset($this->request->get['filter_doctor_name'])) {
				$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
			}

			if (isset($this->request->get['filter_store_id'])) {
				$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}

			if (isset($this->request->get['filter_payment_status'])) {
				$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$data['cancel'] = $this->url->link('report/herbalremedies_by_doctor', 'user_token=' . $this->session->data['user_token'] . $url, true);
			$data['export_excel'] = $this->url->link('report/herbalremedies_by_doctor/exportExcelInfo', 'user_token=' . $this->session->data['user_token'] . '&doctor_id=' . $this->request->get['doctor_id'] . $url, true);

			$url = '';

			if (isset($this->request->get['filter_date_start'])) {
				$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
			}

			if (isset($this->request->get['filter_date_end'])) {
				$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
			}

			if (isset($this->request->get['filter_order_status_id'])) {
				$url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
			}

			if (isset($this->request->get['filter_transaction_start'])) {
				$url .= '&filter_transaction_start=' . $this->request->get['filter_transaction_start'];
			}

			if (isset($this->request->get['filter_transaction_end'])) {
				$url .= '&filter_transaction_end=' . $this->request->get['filter_transaction_end'];
			}

			if (isset($this->request->get['filter_doctor_name'])) {
				$url .= '&filter_doctor_name=' . $this->request->get['filter_doctor_name'];
			}

			if (isset($this->request->get['filter_store_id'])) {
				$url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
			}

			if (isset($this->request->get['filter_payment_status'])) {
				$url .= '&filter_payment_status=' . $this->request->get['filter_payment_status'];
			}

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			$pagination = new Pagination();
			$pagination->total = $total_transaction;
			$pagination->page = $info_page;
			$pagination->limit = $this->config->get('config_limit_admin');
			$pagination->url = $this->url->link('report/herbalremedies_by_doctor/info', 'user_token=' . $this->session->data['user_token'] . '&doctor_id=' . $doctor_id . $url . '&info_page={page}', true);

			$data['pagination'] = $pagination->render();

			$data['results'] = sprintf($this->language->get('text_pagination'), ($total_transaction) ? (($info_page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($info_page - 1) * $this->config->get('config_limit_admin')) > ($total_transaction - $this->config->get('config_limit_admin'))) ? $total_transaction : ((($info_page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_transaction, ceil($total_transaction / $this->config->get('config_limit_admin')));

			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');

			$this->response->setOutput($this->load->view('report/herbalremedies_by_doctor_info', $data));
		} else{
			$this->load->language('error/not_found');

			$this->document->setTitle($this->language->get('heading_title'));

			$data['heading_title'] = $this->language->get('heading_title');

			$data['text_not_found'] = $this->language->get('text_not_found');

			$data['breadcrumbs'] = array();

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_home'),
				'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
			);

			$data['header'] = $this->load->controller('common/header');
			$data['column_left'] = $this->load->controller('common/column_left');
			$data['footer'] = $this->load->controller('common/footer');
			

			$this->response->setOutput($this->load->view('error/not_found', $data));
		}

	}

	public function exportExcel(){
		$this->load->model('report/herbalremedies');
		$this->load->language('report/herbalremedies_by_doctor');

		//**filter
		if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

		if (isset($this->request->get['filter_doctor_name'])) {
			$filter_doctor_name = $this->request->get['filter_doctor_name'];
		} else {
			$filter_doctor_name = '';
		}

		if (isset($this->request->get['filter_store_id'])) {
			if($this->request->get['filter_store_id'] != '*'){
				$filter_store_id = $this->request->get['filter_store_id'];
			} else {
				$filter_store_id = '';
			}
		} else {
			$filter_store_id = $this->session->data['store_id'];
		}

		if (isset($this->request->get['filter_payment_status'])) {
			$filter_payment_status = $this->request->get['filter_payment_status'];
		} else {
			$filter_payment_status = '';
		}

		if (isset($this->request->get['filter_order_status_id'])) {
			$filter_order_status_id = $this->request->get['filter_order_status_id'];
		} else {
			$filter_order_status_id = 0;
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

		//** filter data
		$filter_data = array(
			'filter_date_start'	     	=> $filter_date_start,
			'filter_date_end'	     	=> $filter_date_end,
			// 'filter_transaction_start' 	=> $filter_transaction_start,
			// 'filter_transaction_end' 	=> $filter_transaction_end,
			'filter_doctor_name' 		=> $filter_doctor_name,
			'filter_payment_status' 	=> $filter_payment_status,
			'filter_store_id' 			=> $filter_store_id,
			'filter_order_status_id'	=> $filter_order_status_id,
			'sort'						=> $sort,
			'order'						=> $order
		);

		//get user detail
		$this->load->model('user/user');
		$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

		//load php excel
		$this->load->library('PHPExcel');
		$objPHPExcel = new PHPExcel();

		// Set document properties
		$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
										->setTitle("Title")
										->setSubject("Subject")
										->setDescription("Description")
										->setKeywords("report ptcm.etcm.me webceo")
										->setCategory("report excel");
		// Set default font
		$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
													->setSize(10);
		// Table Data

		//get data collection from database
		$results = $this->model_report_herbalremedies->getHerbalremediesByDoctor($filter_data);
		$total = $this->model_report_herbalremedies->getTotalHerbalremediesByDoctor($filter_data);

		$table_collection = array();

		foreach ($results as $result) {
			$table_collection[] = array(
				'doctor_name'		=> $result['doctor_name'],
				'total_cs'			=> $result['total_cs'],
				'medicine_total' 	=> $this->currency->format($result['medical_total'], $this->config->get('config_currency')),
				'medical_total'  	=> $this->currency->format($result['medicine_total1'] + $result['medicine_total2'], $this->config->get('config_currency')),
				'clinicalsale_consultation' => $this->currency->format($result['consultation_total'], $this->config->get('config_currency')),
				'payment_total'		=> $this->currency->format($result['payment_total'], $this->config->get('config_currency')),

			);
		}

		$total_cs = 0;
		$total_medicine_total = 0;
		$total_medical_total = 0;
		$clinicalsale_consultation = 0;
		$payment_total = 0;


		foreach($total as $result){
			$total_cs += $result['total_cs'];
			$total_medicine_total += $result['medical_total'];
			$total_medical_total += $result['medicine_total1'] + $result['medicine_total2'];
			$clinicalsale_consultation += $result['consultation_total'];
			$payment_total += $result['payment_total'] ;

		}

		

		$table_collection[] = array(
			'',
			$total_cs,
			$total_medicine_total,
			$total_medical_total,
			$clinicalsale_consultation,
			$payment_total

		);

		$table = array();

		$table[] = array('Report Name : ', $this->language->get('heading_title'));
		$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

		$table[] = array(); // add a space

		//$table[] = array('Report Details : ');

		$table_header = array(//table headers
			$this->language->get('column_name'),
			$this->language->get('column_total_cs'),
			$this->language->get('column_medicine_total'),
			$this->language->get('column_total'),
			$this->language->get('column_collect_consultation'),
			$this->language->get('column_payment_total')

		);
		$table[] = $table_header;//add header to table

		$total_row = 0;

		$table_data = $table_collection;
		$row;
		foreach($table_data as $key => $data){
			$row = array();
			foreach($data as $key => $value){
				$row[] = $value;
			}
			$table[] = $row;//add data row to table

			$total_row ++;
		}

		//  Styling
		$autosize_column_index = 'A';
		foreach($table_header as $header){//loop each header
			$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
			$autosize_column_index++;
		}

		$header_index_s_column = 'A';
		$header_index_e_column = $header_index_s_column;
		foreach($table_header as $col) $header_index_e_column++;
		$header_index_row = 4;
		$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

		$header_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
			),
			'font' => array(
				'bold' => true
			)
		);
		$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

		$currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

		$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
		$objPHPExcel->getActiveSheet()->getStyle("I" . ($header_index_row + 1) . ":I" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);


		// Add Array To Excel
		$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


		// Rename worksheet
		$sheettitle = $this->language->get('heading_title');
		$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
		$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

		// Set active sheet index to the first sheet, so Excel opens this as the first sheet
		$objPHPExcel->setActiveSheetIndex(0);

		$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

		// Save Excel 2007 file
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		//ob_end_clean();
		// We'll be outputting an excel file
		header('Content-type: application/vnd.ms-excel');

		// It will be called file.xls
		header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
		$objWriter->save('php://output');
	}

	public function exportExcelInfo(){
		$doctor_id = isset($this->request->get['doctor_id']) ? $this->request->get['doctor_id'] : 0;

		$this->load->model('user/user');
		$doctor = $this->model_user_user->getDoctor($doctor_id);

		if(!empty($doctor)){
			//load default model
			$this->load->model('report/herbalremedies');

			//load default language
			$this->load->language('report/herbalremedies_by_doctor');

			$doctor_name = $doctor['firstname'] . ' ' . $doctor['lastname'];

			if (isset($this->request->get['filter_date_start'])) {
				$filter_date_start = $this->request->get['filter_date_start'];
			} else {
				$filter_date_start = date('Y-m-01');
			}
	
			if (isset($this->request->get['filter_date_end'])) {
				$filter_date_end = $this->request->get['filter_date_end'];
			} else {
				$filter_date_end = date('Y-m-t');
			}
	
			if (isset($this->request->get['filter_doctor_name'])) {
				$filter_doctor_name = $this->request->get['filter_doctor_name'];
			} else {
				$filter_doctor_name = '';
			}
	
			if (isset($this->request->get['filter_store_id'])) {
				if($this->request->get['filter_store_id'] != '*'){
					$filter_store_id = $this->request->get['filter_store_id'];
				} else {
					$filter_store_id = '';
				}
			} else {
				$filter_store_id = $this->session->data['store_id'];
			}
	
			if (isset($this->request->get['filter_payment_status'])) {
				$filter_payment_status = $this->request->get['filter_payment_status'];
			} else {
				$filter_payment_status = '';
			}
	
			if (isset($this->request->get['filter_order_status_id'])) {
				$filter_order_status_id = $this->request->get['filter_order_status_id'];
			} else {
				$filter_order_status_id = 0;
			}

			if (isset($this->request->get['page'])) {
				$page = $this->request->get['page'];
			} else {
				$page = 1;
			}

			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
			} else {
				$sort = 'name';
			}

			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
			} else {
				$order = 'ASC';
			}


			if (isset($this->request->get['info_page'])) {
				$info_page = $this->request->get['info_page'];
			} else {
				$info_page = 1;
			}


			$filter_data = array(
				'filter_date_start'	     	=> $filter_date_start,
				'filter_date_end'	     	=> $filter_date_end,
				'filter_doctor_name'		=> $filter_doctor_name,
				'filter_payment_status' 	=> $filter_payment_status,
				'filter_store_id' 			=> $filter_store_id,
				'filter_order_status_id' 	=> $filter_order_status_id,
				'sort'						=> $sort,
				'order'						=> $order
			);

			$user_info = $this->model_user_user->getUser($this->session->data['user_id']);

			//load php excel
			$this->load->library('PHPExcel');
			$objPHPExcel = new PHPExcel();

			// Set document properties
			$objPHPExcel->getProperties()	->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
											->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
											->setTitle("Title")
											->setSubject("Subject")
											->setDescription("Description")
											->setKeywords("report")
											->setCategory("report excel");
			// Set default font
			$objPHPExcel->getDefaultStyle()->getFont()	->setName('Arial')
														->setSize(10);

			// Table Data

			//get data collection from database
			$results = $this->model_report_herbalremedies->getTotalHerbalremediesByDoctorInfo($doctor_id, $filter_data);

			$table_collection = array();

			foreach ($results as $result) {
				$table_collection[] = array(
					'date_added' 		=> date($this->language->get('date_format_short'), strtotime($result['sales_date'])),
					'invoice_prefix'	=> $result['invoice_prefix'],
					'subtotal' 			=> $this->currency->format($result['subtotal'], $this->config->get('config_currency'), '', false),
					'tax'				=> $this->currency->format($result['tax'], $this->config->get('config_currency'), '', false),
					'total'				=> $this->currency->format($result['total'], $this->config->get('config_currency'), '', false),
					'd_subtotal' 		=> $this->currency->format($result['d_subtotal'], $this->config->get('config_currency'), '', false),
					'd_tax'				=> $this->currency->format($result['d_tax'], $this->config->get('config_currency'), '', false),
					'd_total'			=> $this->currency->format($result['d_total'], $this->config->get('config_currency'), '', false)
				);
			}

			$total_subtotal = 0;
			$total_tax = 0;
			$total_total = 0;
			$total_d_subtotal = 0;
			$total_d_tax = 0;
			$total_d_total = 0;

			foreach ($results as $result) {
				$total_subtotal += $result['subtotal'];
				$total_tax += $result['tax'];
				$total_total += $result['total'];
				$total_d_subtotal += $result['d_subtotal'];
				$total_d_tax += $result['d_tax'];
				$total_d_total += $result['d_total'];
			}

			$table_collection[] = array(
				'',
				'',
				$total_subtotal,
				$total_tax,
				$total_total,
				$total_d_subtotal,
				$total_d_tax,
				$total_d_total
			);

			$table = array();

			$table[] = array('Report Name : ', $this->language->get('heading_title'));
			$table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);
			$table[] = array('Chinese Physician Name : ', $doctor_name);

			$table[] = array(); // add a space

			$table_header = array(//table headers
				$this->language->get('column_date'),
				$this->language->get('column_invoice_prefix'),
				$this->language->get('column_subtotal'),
				$this->language->get('column_tax'),
				$this->language->get('column_total'),
				$this->language->get('column_consultation_subtotal'),
				$this->language->get('column_consultation_tax'),
				$this->language->get('column_consultation_total')
			);
			$table[] = $table_header;//add header to table

			$total_row = 0;

			$table_data = $table_collection;
			$row;
			foreach($table_data as $key => $data){
				$row = array();
				foreach($data as $key => $value){
					$row[] = $value;
				}
				$table[] = $row;//add data row to table

				$total_row ++;
			}

			//  Styling
			$autosize_column_index = 'A';
			foreach($table_header as $header){//loop each header
				$objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
				$autosize_column_index++;
			}

			$header_index_s_column = 'A';
			$header_index_e_column = $header_index_s_column;
			foreach($table_header as $col) $header_index_e_column++;
			$header_index_row = 5;
			$header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

			$header_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
				),
				'font' => array(
					'bold' => true
				)
			);
			$objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

			$currency_style = array(
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
				),
				'numberformat' => array(
					'code' => "0.00"
				)
			);

			$objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
			$objPHPExcel->getActiveSheet()->getStyle("D" . ($header_index_row + 1) . ":D" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
			$objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
			$objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
			$objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
			$objPHPExcel->getActiveSheet()->getStyle("H" . ($header_index_row + 1) . ":H" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

			// Add Array To Excel
			$objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


			// Rename worksheet
			$sheettitle = $this->language->get('heading_title');
			$sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
			$objPHPExcel->getActiveSheet()->setTitle($sheettitle);

			// Set active sheet index to the first sheet, so Excel opens this as the first sheet
			$objPHPExcel->setActiveSheetIndex(0);

			$filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

			// Save Excel 2007 file
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
			//ob_end_clean();
			// We'll be outputting an excel file
			header('Content-type: application/vnd.ms-excel');

			// It will be called file.xls
			header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
			$objWriter->save('php://output');
		}
	}
}
