<?php
class ControllerReportCustomerInfo extends Controller{
    private $error = array();

    public function index(){
        $this->load->language('report/customer_info');
        $this->load->model('report/customer_info');

        $this->document->setTitle($this->language->get('heading_title'));

        if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

        if (isset($this->request->get['filter_customer_name'])) {
            $filter_customer_name = $this->request->get['filter_customer_name'];
        } else {
            $filter_customer_name = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = NULL;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = NULL;
        }

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'customer_name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['customers'] = array();

        $filter_data = array(
            'filter_date_start'         => $filter_date_start,
            'filter_date_end'           => $filter_date_end,
            'filter_customer_name'      => $filter_customer_name,
            'filter_customer_ic'        => $filter_customer_ic,
            'filter_gender'             => $filter_gender,
            'filter_doctor'             => $filter_doctor,
            'sort'					    => $sort,
            'order'					    => $order
        );

        $results = $this->model_report_customer_info->getCustomers($filter_data);

        if(!empty($results)){
            foreach($results as $result){
                $num_of_services = 0;

                $customer_id = $result['customer_id'];

                $herbals = $this->model_report_customer_info->getHerbals($filter_data, $customer_id);
                $services = $this->model_report_customer_info->getServices($filter_data, $customer_id);

                if (!empty($services)) {
                    foreach ($services as $service) {
                        $service_form_id = $service['service_form_id'];
                        $service_item = $this->model_report_customer_info->getServiceItemBySevice($service_form_id, $filter_data);

                        $num_of_services += count($service_item);
                    }
                }
                
                $num_of_herbals = count($herbals);

                $herbal_amount = 0;
                $service_amount = 0;

                if(!empty($herbals)){
                    foreach($herbals as $herbal){
                        $h_amount = $herbal['total_d_gst'];

                        $herbal_amount += $h_amount;
                    }
                }

                if(!empty($services)){
                    foreach($services as $service){
                        $service_form_id = $service['service_form_id'];
                        $service_item = $this->model_report_customer_info->getServiceItemBySevice($service_form_id, $filter_data);

                        if (!empty($service_item)) {
                            foreach ($service_item as $item) {
                                $s_amount = $item['total'];

                                $service_amount += $s_amount;
                            }
                        }                      
                    }
                }

                $text_gender = ($result['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');

                if(($num_of_herbals > 0) || ($num_of_services > 0)){
                    if ($filter_doctor) {
                        if (($num_of_herbals > 0) || ($num_of_services > 0)) {
                            $data['customers'][] = array(
                                'customer_id'               => $customer_id,
                                'customer_name'             => $result['customer_name'],
                                'customer_ic'               => $result['customer_ic'],
                                'gender'                    => $text_gender,
                                'num_of_herbals'            => $num_of_herbals,
                                'herbal_amount'             => $herbal_amount,
                                'herbal_amount_formatted'   => $this->currency->format($herbal_amount, $this->config->get('config_currency')),
                                'num_of_services'           => $num_of_services,
                                'service_amount'            => $service_amount,
                                'service_amount_formatted'  => $this->currency->format($service_amount, $this->config->get('config_currency')),
                                'date_added'                => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                                'view'                      => $this->url->link('report/customer_info/info', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true)
                            );
                        }
                    } else {
                        $data['customers'][] = array(
                            'customer_id'               => $customer_id,
                            'customer_name'             => $result['customer_name'],
                            'customer_ic'               => $result['customer_ic'],
                            'gender'                    => $text_gender,
                            'num_of_herbals'            => $num_of_herbals,
                            'herbal_amount'             => $herbal_amount,
                            'herbal_amount_formatted'   => $this->currency->format($herbal_amount, $this->config->get('config_currency')),
                            'num_of_services'           => $num_of_services,
                            'service_amount'            => $service_amount,
                            'service_amount_formatted'  => $this->currency->format($service_amount, $this->config->get('config_currency')),
                            'date_added'                => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                            'view'                      => $this->url->link('report/customer_info/info', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $result['customer_id'] . $url, true)
                        );
                    }                    
                }
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'num_of_herbals') {
                $num_of_herbals_column = array_column($data['customers'], 'num_of_herbals');

                if($order == 'ASC'){
                    array_multisort($data['customers'], SORT_NUMERIC, $num_of_herbals_column, SORT_ASC);
                } else{
                    array_multisort($data['customers'], SORT_NUMERIC, $num_of_herbals_column, SORT_DESC);
                }
            } else if ($sort == 'herbal_amount') {
                $herbal_amount_column = array_column($data['customers'], 'herbal_amount');

                if($order == 'ASC'){
                    array_multisort($data['customers'], SORT_NUMERIC, $herbal_amount_column, SORT_ASC);
                } else{
                    array_multisort($data['customers'], SORT_NUMERIC, $herbal_amount_column, SORT_DESC);
                }
            } else if ($sort == 'num_of_services') {
                $num_of_services_column = array_column($data['customers'], 'num_of_services');

                if($order == 'ASC'){
                    array_multisort($data['customers'], SORT_NUMERIC, $num_of_services_column, SORT_ASC);
                } else{
                    array_multisort($data['customers'], SORT_NUMERIC, $num_of_services_column, SORT_DESC);
                }
            } else if ($sort == 'service_amount') {
                $service_amount_column = array_column($data['customers'], 'service_amount');

                if($order == 'ASC'){
                    array_multisort($data['customers'], SORT_NUMERIC, $service_amount_column, SORT_ASC);
                } else{
                    array_multisort($data['customers'], SORT_NUMERIC, $service_amount_column, SORT_DESC);
                }
            }
        }

        $total_customers = count($data['customers']);

        $limit = $this->config->get('config_limit_admin');
		$show = ($page * $limit) - $limit;

        $data['customers'] = array_slice($data['customers'], $show, $limit);

        $data['export_excel'] = $this->url->link('report/customer_info/exportExcel', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $language_arr = array('heading_title', 'button_export_excel', 'text_list', 'entry_date_start', 'entry_date_end', 'entry_customer_name', 'entry_customer_ic', 'entry_gender', 'text_male', 'text_female', 'button_filter', 'text_no_results', 'column_customer_name', 'column_customer_ic', 'column_date_added', 'column_gender', 'column_action', 'button_view', 'text_information', 'column_num_of_service', 'column_num_of_herbals', 'column_herbals_amount', 'column_service_amount', 'entry_doctor');

        foreach($language_arr as $language){
            $data[$language] = $this->language->get($language);
        }

        $querystringforsort = '';
		if (isset($this->request->get['filter_date_start'])) {
			$querystringforsort .= '&filter_date_start=' . $this->request->get['filter_date_start'];
		}

		if (isset($this->request->get['filter_date_end'])) {
			$querystringforsort .= '&filter_date_end=' . $this->request->get['filter_date_end'];
		}

        if (isset($this->request->get['filter_customer_name'])) {
            $querystringforsort .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $querystringforsort .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $querystringforsort .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $querystringforsort .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_customer_name'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_name' . $querystringforsort, true);
        $data['sort_customer_ic'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_ic' . $querystringforsort, true);
        $data['sort_gender'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=gender' . $querystringforsort, true);
        $data['sort_date_added'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=date_added' . $querystringforsort, true);
        $data['sort_num_of_herbals'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=num_of_herbals' . $querystringforsort, true);
        $data['sort_herbal_amount'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=herbal_amount' . $querystringforsort, true);
        $data['sort_num_of_services'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=num_of_services' . $querystringforsort, true);
        $data['sort_service_amount'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . '&sort=service_amount' . $querystringforsort, true);

        $url = '';

        if (isset($this->request->get['filter_date_start'])) {
            $url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
        }

        if (isset($this->request->get['filter_date_end'])) {
            $url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
        }

        if (isset($this->request->get['filter_customer_name'])) {
            $url .= '&filter_customer_name=' . $this->request->get['filter_customer_name'];
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $url .= '&filter_customer_ic=' . $this->request->get['filter_customer_ic'];
        }

        if (isset($this->request->get['filter_gender'])) {
            $url .= '&filter_gender=' . $this->request->get['filter_gender'];
        }

        if (isset($this->request->get['filter_doctor'])) {
            $url .= '&filter_doctor=' . $this->request->get['filter_doctor'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $total_customers;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($total_customers) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($total_customers - $this->config->get('config_limit_admin'))) ? $total_customers : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $total_customers, ceil($total_customers / $this->config->get('config_limit_admin')));

        $data['doctors'] = [];

        $doctors = $this->model_report_customer_info->getDoctors();

        if (!empty($doctors)) {
            foreach ($doctors as $doctor) {
                $data['doctors'][] = [
                    'doctor_id'     => $doctor['user_id'],
                    'doctor_name'   => $doctor['firstname'] . ' ' . $doctor['lastname']
                ];
            }
        }

        $data['filter_date_start'] = $filter_date_start;
		$data['filter_date_end'] = $filter_date_end;
        $data['filter_customer_name'] = $filter_customer_name;
        $data['filter_customer_ic'] = $filter_customer_ic;
        $data['filter_gender'] = $filter_gender;
        $data['filter_doctor'] = $filter_doctor;

        $data['user_token'] = $this->session->data['user_token'];
        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('report/customer_info', $data));
    }

    public function info(){
        $this->load->language('report/customer_info');

        $this->load->model('report/customer_info');
        $this->load->model('sale/customer');
        $this->load->model('user/user');

        $this->document->setTitle($this->language->get('heading_title'));

        if(isset($this->request->get['customer_id'])){
            if (isset($this->request->get['filter_date_start'])) {
    			$filter_date_start = $this->request->get['filter_date_start'];
    		} else {
    			$filter_date_start = date('Y-m-01');
    		}

    		if (isset($this->request->get['filter_date_end'])) {
    			$filter_date_end = $this->request->get['filter_date_end'];
    		} else {
    			$filter_date_end = date('Y-m-t');
    		}

            $url = '';

            if (isset($this->request->get['filter_date_start'])) {
    			$url .= '&filter_date_start=' . $this->request->get['filter_date_start'];
    		}

    		if (isset($this->request->get['filter_date_end'])) {
    			$url .= '&filter_date_end=' . $this->request->get['filter_date_end'];
    		}

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $language_arr = array('heading_title', 'button_cancel', 'text_details', 'tab_information', 'tab_clinical_sale', 'tab_service_form', 'tab_order', 'column_customer_name', 'column_customer_card', 'column_customer_ic', 'column_telephone', 'column_email', 'column_gender', 'column_date_added', 'column_address', 'column_invoice_prefix', 'column_subtotal', 'column_total', 'column_tax', 'text_no_results', 'column_rounding', 'column_shipping', 'button_export_excel', 'tab_clinical_sale_by_physician', 'column_physician_name', 'column_total_cs', 'column_total_subtotal', 'column_total_tax', 'column_total_total', 'column_total_d_subtotal', 'column_total_d_tax', 'column_total_d_total', 'tab_service_form_physician', 'column_total_sf', 'column_total_sf_subtotal', 'column_total_sf_tax', 'column_total_sf_total', 'tab_service_form_service', 'column_clinical_service');

            foreach($language_arr as $language){
                $data[$language] = $this->language->get($language);
            }

            $customer_info = $this->model_sale_customer->getCustomer($this->request->get['customer_id']);

            if(!empty($customer_info)){
                $data['customer_name'] = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
                $data['customer_card'] = $customer_info['customer_card'];
                $data['customer_ic'] = $customer_info['customer_ic'];
                $data['telephone'] = $customer_info['telephone'];
                $data['email'] = $customer_info['email'];
                $data['gender'] = ($customer_info['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');
                $data['date_added'] = date($this->language->get('date_format_short'), strtotime($customer_info['date_added']));
            }

            $addresses = $this->model_sale_customer->getAddresses($this->request->get['customer_id']);

            $this->load->model('localisation/country');
            $this->load->model('localisation/zone');

            $data['addresses'] = array();

            if(!empty($addresses)){
                foreach($addresses as $address){
                    $address_1 = !empty($address['address_1']) ? $address['address_1'] . ', ' : '';
                    $address_2 = !empty($address['address_2']) ? $address['address_2'] . ', ' : '';
                    $address_3 = !empty($address['address_3']) ? $address['address_3'] . ', ' : '';
                    $postcode = !empty($address['postcode']) ? $address['postcode'] . ' ' : '';
                    $city = !empty($address['city']) ? $address['city'] . ', ' : '';

                    $country_id = ($address['country_id'] > 0) ? $address['country_id'] : 0;
                    $country_info = $this->model_localisation_country->getCountry($country_id);
                    $country = !empty($country_info) ? $country_info['name'] : '';

                    $zone_id = ($address['zone_id'] > 0) ? $address['zone_id'] : 0;
                    $zone_info = $this->model_localisation_zone->getZone($zone_id);
                    $zone = !empty($zone_info) ? $zone_info['name'] . ' ' : '';

                    $full_address = $address_1 . $address_2 . $address_3 . $postcode . $city . $zone . $country;

                    $data['addresses'][] = array(
                        'address'   => strtoupper($full_address)
                    );
                }
            }

            $filter_data = array(
                'filter_date_start'     => $filter_date_start,
                'filter_date_end'       => $filter_date_end
            );

            $data['herbals'] = array();

            $herbals_by_physicians = array();
            $data['herbals_by_physicians'] = array();
            $data['total_herbals_by_physicians'] = array();

            $herbals = $this->model_report_customer_info->getHerbals($filter_data, $this->request->get['customer_id']);

            $subtotal_herbal = 0;
            $tax_herbal = 0;
            $total_herbal = 0;

            if(!empty($herbals)){
                foreach($herbals as $herbal){
                    $subtotal_herbal += $herbal['d_net_amount'];
                    $tax_herbal += $herbal['d_gst'];
                    $total_herbal += $herbal['total_d_gst'];

                    $data['herbals'][] = array(
                        'clinical_sale_id'  => $herbal['clinical_sale_id'],
                        'invoice_prefix'    => $herbal['invoice_prefix'],
                        'subtotal'          => $this->currency->format($herbal['d_net_amount'],$this->config->get('config_currency')),
                        'tax'               => $this->currency->format($herbal['d_gst'],$this->config->get('config_currency')),
                        'total'             => $this->currency->format($herbal['total_d_gst'],$this->config->get('config_currency')),
                        'date_added'        => date($this->language->get('date_format_short'), strtotime($herbal['date_added'])),
                        'view'              => $this->url->link('herbal/herbal/getInfo','user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbal['clinical_sale_id'], true)
                    );
                }

                $data['total_herbals'] = array(
                    'subtotal'      => $this->currency->format($subtotal_herbal,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_herbal,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_herbal,$this->config->get('config_currency'))
                );
            } else{
                $data['total_herbals'] = array(
                    'subtotal'      => $this->currency->format($subtotal_herbal,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_herbal,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_herbal,$this->config->get('config_currency'))
                );
            }

            $grandtotal_cs = 0;
            $grandtotal_subtotal = 0;
            $grandtotal_tax = 0;
            $grandtotal_total = 0;
            $grandtotal_d_subtotal = 0;
            $grandtotal_d_tax = 0;
            $grandtotal_d_total = 0;
            
            if(!empty($herbals)){
                foreach($herbals as $herbal){
                    $doctor_info = $this->model_user_user->getUser($herbal['doctor_id']);
                    $doctor_name = !empty($doctor_info) ? $doctor_info['firstname'] . ' ' . $doctor_info['lastname'] : '';

                    $herbals_by_physicians[$herbal['doctor_id']]['doctor_id'] = $herbal['doctor_id'];
                    $herbals_by_physicians[$herbal['doctor_id']]['doctor_name'] = $doctor_name;
                    $herbals_by_physicians[$herbal['doctor_id']]['herbals'][] = $herbal;
                }

                $total_subtotal = 0;
                $total_tax = 0;
                $total_total = 0;
                $total_d_subtotal = 0;
                $total_d_tax = 0;
                $total_d_total = 0;

                foreach ($herbals_by_physicians as $doctor_id => $herbals) {
                    $herbals_by_physicians[$doctor_id]['total_cs'] = count($herbals['herbals']);

                    foreach ($herbals['herbals'] as $herbal) {
                        $total_subtotal += $herbal['net_total'];
                        $total_tax += $herbal['gst'];
                        $total_total += $herbal['clinicalsale_total'];
                        $total_d_subtotal += $herbal['d_net_amount'];
                        $total_d_tax += $herbal['d_gst'];
                        $total_d_total += $herbal['total_d_gst'];
                    }

                    $herbals_by_physicians[$doctor_id]['subtotal'] = $this->currency->format($total_subtotal,$this->config->get('config_currency'));
                    $herbals_by_physicians[$doctor_id]['tax'] = $this->currency->format($total_tax,$this->config->get('config_currency'));
                    $herbals_by_physicians[$doctor_id]['total'] = $this->currency->format($total_total,$this->config->get('config_currency'));
                    $herbals_by_physicians[$doctor_id]['d_subtotal'] = $this->currency->format($total_d_subtotal,$this->config->get('config_currency'));
                    $herbals_by_physicians[$doctor_id]['d_tax'] = $this->currency->format($total_d_tax,$this->config->get('config_currency'));
                    $herbals_by_physicians[$doctor_id]['d_total'] = $this->currency->format($total_d_total,$this->config->get('config_currency'));

                    $grandtotal_cs += count($herbals['herbals']);
                    $grandtotal_subtotal += $total_subtotal;
                    $grandtotal_tax += $total_tax;
                    $grandtotal_total += $total_total;
                    $grandtotal_d_subtotal += $total_d_subtotal;
                    $grandtotal_d_tax += $total_d_tax;
                    $grandtotal_d_total += $total_d_total;

                    unset($herbals_by_physicians[$doctor_id]['herbals']);
                }

                $data['total_herbals_by_physicians'] = [
                    'total_cs'      => $grandtotal_cs,
                    'subtotal'      => $this->currency->format($grandtotal_subtotal,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($grandtotal_tax,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($grandtotal_total,$this->config->get('config_currency')),
                    'd_subtotal'    => $this->currency->format($grandtotal_d_subtotal,$this->config->get('config_currency')),
                    'd_tax'         => $this->currency->format($grandtotal_d_tax,$this->config->get('config_currency')),
                    'd_total'       => $this->currency->format($grandtotal_d_total,$this->config->get('config_currency'))
                ];
            } else {
                $data['total_herbals_by_physicians'] = [
                    'total_cs'      => $grandtotal_cs,
                    'subtotal'      => $this->currency->format($grandtotal_subtotal,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($grandtotal_tax,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($grandtotal_total,$this->config->get('config_currency')),
                    'd_subtotal'    => $this->currency->format($grandtotal_d_subtotal,$this->config->get('config_currency')),
                    'd_tax'         => $this->currency->format($grandtotal_d_tax,$this->config->get('config_currency')),
                    'd_total'       => $this->currency->format($grandtotal_d_total,$this->config->get('config_currency'))
                ];
            }

            $data['herbals_by_physicians'] = array_values($herbals_by_physicians);

            $data['services'] = array();

            $services = $this->model_report_customer_info->getServices($filter_data, $this->request->get['customer_id']);

            $subtotal_service = 0;
            $tax_service = 0;
            $total_service = 0;

            if(!empty($services)){
                foreach($services as $service){
                    $subtotal_service += $service['net_amount'];
                    $tax_service += $service['t_gst'];
                    $total_service += $service['total_price'];

                    $data['services'][] = array(
                        'service_form_id'       => $service['service_form_id'],
                        'invoice_prefix'        => $service['invoice_prefix'],
                        'subtotal'              => $this->currency->format($service['net_amount'],$this->config->get('config_currency')),
                        'tax'                   => $this->currency->format($service['t_gst'],$this->config->get('config_currency')),
                        'total'                 => $this->currency->format($service['total_price'],$this->config->get('config_currency')),
                        'date_added'            => date($this->language->get('date_format_short'), strtotime($service['date_added'],$this->config->get('config_currency'))),
                        'view'                  => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $service['service_form_id'])
                    );
                }

                $data['total_services'] = array(
                    'subtotal'      => $this->currency->format($subtotal_service.$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_service,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_service,$this->config->get('config_currency'))
                );
            } else{
                $data['total_services'] = array(
                    'subtotal'      => $this->currency->format($subtotal_service,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_service,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_service,$this->config->get('config_currency'))
                );
            }

            $services_by_physician = array();
            $data['services_by_physician'] = array();
            $data['total_services_by_physician'] = array();

            $grandtotal_sf = 0;
            $grandtotal_price = 0;
            $grandtotal_tax = 0;
            $grandtotal_total = 0;

            if (!empty($services)) {
                foreach ($services as $service) {
                    $service_form_id = $service['service_form_id'];
                    $service_items = $this->model_report_customer_info->getServiceItemBySevice($service_form_id);

                    if (!empty($service_items)) {
                        foreach ($service_items as $item) {
                            $services_by_physician[$item['user_id']]['service_items'][] = $item;
                        }
                    }
                }

                foreach ($services_by_physician as $doctor_id => $service_items) {
                    $total_price = 0;
                    $total_tax = 0;
                    $total_total = 0;

                    $services_by_physician[$doctor_id]['doctor_id'] = $doctor_id;

                    $doctor_info = $this->model_user_user->getUser($doctor_id);
                    $doctor_name = !empty($doctor_info) ? $doctor_info['firstname'] . ' ' . $doctor_info['lastname'] : '';
                    
                    $services_by_physician[$doctor_id]['doctor_name'] = $doctor_name;
                    $services_by_physician[$doctor_id]['total_sf'] = count($service_items['service_items']);

                    foreach ($service_items['service_items'] as $item) {
                        $total_price += $item['price'];
                        $total_tax += $item['gst'];
                        $total_total += $item['total'];
                    }

                    $services_by_physician[$doctor_id]['total_subtotal'] = $this->currency->format($total_price,$this->config->get('config_currency'));
                    $services_by_physician[$doctor_id]['total_tax'] = $this->currency->format($total_tax,$this->config->get('config_currency'));
                    $services_by_physician[$doctor_id]['total_total'] = $this->currency->format($total_total,$this->config->get('config_currency'));

                    $grandtotal_sf += count($service_items['service_items']);
                    $grandtotal_price += $total_price;
                    $grandtotal_tax += $total_tax;
                    $grandtotal_total += $total_total;

                    unset($services_by_physician[$doctor_id]['service_items']);
                }

                $data['total_services_by_physician'] = [
                    'total_sf'          => $grandtotal_sf,
                    'total_subtotal'    => $this->currency->format($grandtotal_price,$this->config->get('config_currency')),
                    'total_tax'         => $this->currency->format($grandtotal_tax,$this->config->get('config_currency')),
                    'total_total'       => $this->currency->format($grandtotal_total,$this->config->get('config_currency')),
                ];
            } else {
                $data['total_services_by_physician'] = [
                    'total_sf'          => $grandtotal_sf,
                    'total_subtotal'    => $this->currency->format($grandtotal_price,$this->config->get('config_currency')),
                    'total_tax'         => $this->currency->format($grandtotal_tax,$this->config->get('config_currency')),
                    'total_total'       => $this->currency->format($grandtotal_total,$this->config->get('config_currency')),
                ];
            }

            $data['services_by_physician'] = array_values($services_by_physician);

            $services_by_service = array();
            $data['services_by_service'] = array();
            $data['total_services_by_service'] = array();

            $grandtotal_subtotal_scs = 0;
            $grandtotal_tax_scs = 0;
            $grandtotal_total_scs = 0;

            if (!empty($services)) {
                foreach ($services as $service) {
                    $service_form_id = $service['service_form_id'];
                    $service_items = $this->model_report_customer_info->getServiceItemBySevice($service_form_id);

                    if (!empty($service_items)) {
                        foreach ($service_items as $item) {
                            $services_by_service[$item['clinicalservice_id']]['clinicalservice_id'] = $item['clinicalservice_id'];

                            $clinicalservice_info = $this->model_report_customer_info->getClinicalService($item['clinicalservice_id']);

                            $clinicalservice_name = !empty($clinicalservice_info) ? $clinicalservice_info['name'] : '';

                            $services_by_service[$item['clinicalservice_id']]['clinicalservice_name'] = $clinicalservice_name;
                            $services_by_service[$item['clinicalservice_id']]['service_items'][] = $item;
                        }
                    }
                }

                foreach ($services_by_service as $clinicalservice_id => $services) {
                    $total_subtotal = 0;
                    $total_tax = 0;
                    $total_total = 0;
                    
                    foreach ($services['service_items'] as $item) {
                        $total_subtotal += $item['net_amount'];
                        $total_tax += $item['gst'];
                        $total_total += $item['total'];
                    }

                    $services_by_service[$clinicalservice_id]['subtotal'] = $this->currency->format($total_subtotal,$this->config->get('config_currency'));
                    $services_by_service[$clinicalservice_id]['tax'] = $this->currency->format($total_tax,$this->config->get('config_currency'));
                    $services_by_service[$clinicalservice_id]['total'] = $this->currency->format($total_total,$this->config->get('config_currency'));

                    $grandtotal_subtotal_scs += $total_subtotal;
                    $grandtotal_tax_scs += $total_tax;
                    $grandtotal_total_scs += $total_total;

                    unset($services_by_service[$clinicalservice_id]['service_items']);
                }                   

                $data['total_services_by_service'] = [
                    'subtotal'      => $this->currency->format($grandtotal_subtotal_scs,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($grandtotal_tax_scs,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($grandtotal_total_scs,$this->config->get('config_currency'))
                ];
            } else {
                $data['total_services_by_service'] = [
                    'subtotal'      => $this->currency->format($grandtotal_subtotal_scs,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($grandtotal_tax_scs,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($grandtotal_total_scs,$this->config->get('config_currency'))
                ];
            }

            $data['services_by_service'] = array_values($services_by_service);

            $data['orders'] = array();

            $orders = $this->model_report_customer_info->getOrders($filter_data, $this->request->get['customer_id']);

            $subtotal_order = 0;
            $tax_order = 0;
            $total_order = 0;
            $rounding_order = 0;
            $shipping_order = 0;

            if(!empty($orders)){
                foreach($orders as $order){
                    $data['orders'][$order['order_id']] = array(
                        'order_id'          => $order['order_id'],
                        'invoice_prefix'    => $order['invoice_prefix'],
                        'date_added'        => date($this->language->get('date_format_short'), strtotime($order['date_added'])),
                        'view'              => $this->url->link('sale/order/info','user_token=' . $this->session->data['user_token'] . '&order_id=' . $order['order_id'], true)
                    );
                }

                foreach($data['orders'] as $order_id => $order){
                    $order_total = $this->model_report_customer_info->getOrderTotals($order_id);

                    $data['orders'][$order_id]['tax'] = 0;
                    $data['orders'][$order_id]['shipping'] = 0;

                    if(!empty($order_total)){
                        foreach($order_total as $total){
                            if($total['code'] == 'sub_total'){
                                $data['orders'][$order_id]['subtotal'] = $total['value'];
                            } elseif(($total['code'] == 'tax') && ($total['tax_key'] == '88')){
                                $data['orders'][$order_id]['tax'] += $total['value'];
                            } elseif(($total['code'] == 'tax') && ($total['tax_key'] == '92')){
                                $data['orders'][$order_id]['tax'] += $total['value'];
                            } elseif($total['code'] == 'shipping'){
                                $data['orders'][$order_id]['shipping'] = $total['value'];
                            } elseif($total['code'] == 'rounding'){
                                $data['orders'][$order_id]['rounding'] = $total['value'];
                            } elseif($total['code'] == 'total'){
                                $data['orders'][$order_id]['total'] = $total['value'];
                            }
                        }
                    }
                }
            }


            foreach($data['orders'] as $order_id => $order){
                $data['orders'][$order_id]['tax'] = $order['tax'];
                $data['orders'][$order_id]['shipping'] = $order['shipping'];
            }

            if(!empty($data['orders'])){
                foreach($data['orders'] as $order_id => $order){
                    $subtotal_order += $order['subtotal'];
                    $tax_order += $order['tax'];
                    $total_order += $order['total'];
                    $shipping_order += $order['shipping'];
                    $rounding_order += $order['rounding'];

                    $data['orders'][$order_id]['subtotal'] = $this->currency->format($order['subtotal'],$this->config->get('config_currency'));
                    $data['orders'][$order_id]['tax'] = $this->currency->format($order['tax'],$this->config->get('config_currency'));
                    $data['orders'][$order_id]['total'] = $this->currency->format($order['total'],$this->config->get('config_currency'));
                    $data['orders'][$order_id]['shipping'] = $this->currency->format($order['shipping'],$this->config->get('config_currency'));
                    $data['orders'][$order_id]['rounding'] = $this->currency->format($order['rounding'],$this->config->get('config_currency'));
                }

                $data['total_orders'] = array(
                    'subtotal'      => $this->currency->format($subtotal_order,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_order,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_order,$this->config->get('config_currency')),
                    'rounding'      => $this->currency->format($rounding_order,$this->config->get('config_currency')),
                    'shipping'      => $this->currency->format($shipping_order,$this->config->get('config_currency'))
                );
            } else{
                $data['total_orders'] = array(
                    'subtotal'      => $this->currency->format($subtotal_order,$this->config->get('config_currency')),
                    'tax'           => $this->currency->format($tax_order,$this->config->get('config_currency')),
                    'total'         => $this->currency->format($total_order,$this->config->get('config_currency')),
                    'rounding'      => $this->currency->format($rounding_order,$this->config->get('config_currency')),
                    'shipping'      => $this->currency->format($shipping_order,$this->config->get('config_currency'))
                );
            }

            $data['orders'] = array_values($data['orders']);

            $data['cancel'] = $this->url->link('report/customer_info', 'user_token=' . $this->session->data['user_token'] . $url, true);
            $data['export_excel'] = $this->url->link('report/customer_info/exportInfoExcel', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $this->request->get['customer_id'] . $url, true);

        } else{
            $this->response->redirect($this->url->link('report/customer_info','user_token=' . $this->session->data['user_token'], true));
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('report/customer_info_details', $data));
    }

    public function exportExcel(){
        $this->load->language('report/customer_info');
        $this->load->model('report/customer_info');

        if (isset($this->request->get['filter_date_start'])) {
			$filter_date_start = $this->request->get['filter_date_start'];
		} else {
			$filter_date_start = date('Y-m-01');
		}

		if (isset($this->request->get['filter_date_end'])) {
			$filter_date_end = $this->request->get['filter_date_end'];
		} else {
			$filter_date_end = date('Y-m-t');
		}

        if (isset($this->request->get['filter_customer_name'])) {
            $filter_customer_name = $this->request->get['filter_customer_name'];
        } else {
            $filter_customer_name = '';
        }

        if (isset($this->request->get['filter_customer_ic'])) {
            $filter_customer_ic = $this->request->get['filter_customer_ic'];
        } else {
            $filter_customer_ic = '';
        }

        if (isset($this->request->get['filter_gender'])) {
            $filter_gender = $this->request->get['filter_gender'];
        } else {
            $filter_gender = NULL;
        }

        if (isset($this->request->get['filter_doctor'])) {
            $filter_doctor = $this->request->get['filter_doctor'];
        } else {
            $filter_doctor = NULL;
        }

        if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'customer_name';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'ASC';
		}

        $filter_data = array(
            'filter_date_start'         => $filter_date_start,
            'filter_date_end'           => $filter_date_end,
            'filter_customer_name'      => $filter_customer_name,
            'filter_customer_ic'        => $filter_customer_ic,
            'filter_gender'             => $filter_gender,
            'filter_doctor'             => $filter_doctor,
            'sort'					    => $sort,
            'order'					    => $order
        );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel =  new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()   ->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                                        ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                                        ->setTitle('Title')
                                        ->setSubject('Subject')
                                        ->setDescription('Description')
                                        ->setKeywords('report etcm.me')
                                        ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()  ->setName('Arial')
                                                    ->setSize(10);

        // Table Data

        // get data collection from database
        $results = $this->model_report_customer_info->getCustomers($filter_data);

        $table_collection = array();

        foreach($results as $result){
            $num_of_services = 0;

            $customer_id = $result['customer_id'];

            $herbals = $this->model_report_customer_info->getHerbals($filter_data, $customer_id);
            $services = $this->model_report_customer_info->getServices($filter_data, $customer_id);

            if (!empty($services)) {
                foreach ($services as $service) {
                    $service_form_id = $service['service_form_id'];
                    $service_item = $this->model_report_customer_info->getServiceItemBySevice($service_form_id, $filter_data);

                    $num_of_services += count($service_item);
                }
            }

            $num_of_herbals = count($herbals);

            $herbal_amount = 0;
            $service_amount = 0;

            if(!empty($herbals)){
                foreach($herbals as $herbal){
                    $h_amount = $herbal['total_d_gst'];

                    $herbal_amount += $h_amount;
                }
            }

            if(!empty($services)){
                foreach($services as $service){
                    $service_form_id = $service['service_form_id'];
                    $service_item = $this->model_report_customer_info->getServiceItemBySevice($service_form_id, $filter_data);

                    if (!empty($service_item)) {
                        foreach ($service_item as $item) {
                            $s_amount = $item['total'];

                            $service_amount += $s_amount;
                        }
                    }                      
                }
            }

            $gender_name = ($result['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');

            if(($num_of_herbals > 0 ) || ($num_of_services > 0)){
                if ($filter_doctor) {
                    if (($num_of_herbals > 0) || ($num_of_services > 0)) {
                        $table_collection[] = array(
                            'customer_name'      => $result['customer_name'],
                            'customer_ic'        => $result['customer_ic'],
                            'gender'             => $gender_name,
                            'num_of_herbals'     => $num_of_herbals,
                            'herbal_amount'      => $herbal_amount,
                            'num_of_services'    => $num_of_services,
                            'service_amount'     => $service_amount,
                            'date_added'         => date($this->language->get('date_format_short'), strtotime($result['date_added']))
                        );
                    }
                } else {
                    $table_collection[] = array(
                        'customer_name'      => $result['customer_name'],
                        'customer_ic'        => $result['customer_ic'],
                        'gender'             => $gender_name,
                        'num_of_herbals'     => $num_of_herbals,
                        'herbal_amount'      => $herbal_amount,
                        'num_of_services'    => $num_of_services,
                        'service_amount'     => $service_amount,
                        'date_added'         => date($this->language->get('date_format_short'), strtotime($result['date_added']))
                    );
                }                
            }
        }

        if (isset($sort) && isset($order)) {
            if ($sort == 'num_of_herbals') {
                $num_of_herbals_column = array_column($table_collection, 'num_of_herbals');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $num_of_herbals_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $num_of_herbals_column, SORT_DESC);
                }
            } else if ($sort == 'herbal_amount') {
                $herbal_amount_column = array_column($table_collection, 'herbal_amount');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $herbal_amount_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $herbal_amount_column, SORT_DESC);
                }
            } else if ($sort == 'num_of_services') {
                $num_of_services_column = array_column($table_collection, 'num_of_services');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $num_of_services_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $num_of_services_column, SORT_DESC);
                }
            } else if ($sort == 'service_amount') {
                $service_amount_column = array_column($table_collection, 'service_amount');

                if($order == 'ASC'){
                    array_multisort($table_collection, SORT_NUMERIC, $service_amount_column, SORT_ASC);
                } else{
                    array_multisort($table_collection, SORT_NUMERIC, $service_amount_column, SORT_DESC);
                }
            }
        }

        $table = array();

        $table[] = array('Report Name : ', $this->language->get('heading_title'));
        $table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

        $table[] = array();

        $table_header = array(
            $this->language->get('column_customer_name'),
            $this->language->get('column_customer_ic'),
            $this->language->get('column_gender'),
            $this->language->get('column_num_of_herbals'),
            $this->language->get('column_herbals_amount'),
            $this->language->get('column_num_of_service'),
            $this->language->get('column_service_amount'),
            $this->language->get('column_date_added')
        );

        $table[] = $table_header;

        $total_row = 0;

        $table_data = $table_collection;

        foreach($table_data as $key => $data){
            $row = array();

            foreach($data as $key => $value){
                $row[] = $value;
            }
            $table[] = $row;

            $total_row++;
        }

        // Styling
        $autosize_column_index = 'A';
        foreach($table_header as $header){
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach($table_header as $col) $header_index_e_column++;
        $header_index_row = 4;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font'  => array(
                'bold'  => true
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $general_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat'  => array(
                'code'  => '0000000000'
            )
        );

        $general_style2 = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat'  => array(
                'code'  => '000000000000'
            )
        );

        $currency_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
            ),
            'numberformat' => array(
                'code' => "0.00"
            )
        );

            $objPHPExcel->getActiveSheet()->getStyle("B" . ($header_index_row + 1) . ":B" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style2);
            $objPHPExcel->getActiveSheet()->getStyle("C" . ($header_index_row + 1) . ":C" . ($header_index_row + 1 + $total_row))->applyFromArray($general_style);
            $objPHPExcel->getActiveSheet()->getStyle("E" . ($header_index_row + 1) . ":E" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);
            $objPHPExcel->getActiveSheet()->getStyle("G" . ($header_index_row + 1) . ":G" . ($header_index_row + 1 + $total_row))->applyFromArray($currency_style);

        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end ;

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }

    public function exportInfoExcel(){
        $this->load->language('report/customer_info');
        $this->load->model('report/customer_info');
        $this->load->model('sale/customer');

        if(isset($this->request->get['customer_id'])){
            $customer_id = $this->request->get['customer_id'];
        } else{
            $customer_id = 0;
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date('Y-m-01');
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date('Y-m-t');
        }

        $filter_data = array(
            'filter_date_start'         => $filter_date_start,
            'filter_date_end'           => $filter_date_end
        );

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel =  new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()  ->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
                                       ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
                                       ->setTitle('Title')
                                       ->setSubject('Subject')
                                       ->setDescription('Description')
                                       ->setKeywords('report etcm.me')
                                       ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()  ->setName('Arial')
                                                    ->setSize(10);

        // Table Data

        // get data collection from database
        $customer_info = $this->model_sale_customer->getCustomer($customer_id);

        $herbal_remedies_collection = array();

        $herbals = $this->model_report_customer_info->getHerbals($filter_data, $this->request->get['customer_id']);

        $subtotal_herbal = 0;
        $tax_herbal = 0;
        $total_herbal = 0;

        if(!empty($herbals)){
            foreach($herbals as $herbal){
                $subtotal_herbal += $herbal['d_net_amount'];
                $tax_herbal += $herbal['d_gst'];
                $total_herbal += $herbal['total_d_gst'];

                $herbal_remedies_collection[] = array(
                    'date_added'        => date($this->language->get('date_format_short'), strtotime($herbal['date_added'])),
                    'invoice_prefix'    => $herbal['invoice_prefix'],
                    'subtotal'          => $herbal['d_net_amount'],
                    'tax'               => $herbal['d_gst'],
                    'total'             => $herbal['total_d_gst']
                );
            }

            $herbal_remedies_collection[] = array(
                '',
                '',
                $subtotal_herbal,
                $tax_herbal,
                $total_herbal
            );
        } else{
            $herbal_remedies_collection[] = array(
                '',
                '',
                $subtotal_herbal,
                $tax_herbal,
                $total_herbal
            );
        }

        $herbal_remedies_by_physician_collection = array();

        $grandtotal_cs = 0;
        $grandtotal_subtotal = 0;
        $grandtotal_tax = 0;
        $grandtotal_total = 0;
        $grandtotal_d_subtotal = 0;
        $grandtotal_d_tax = 0;
        $grandtotal_d_total = 0;
        
        if(!empty($herbals)){
            foreach($herbals as $herbal){
                $doctor_info = $this->model_user_user->getUser($herbal['doctor_id']);
                $doctor_name = !empty($doctor_info) ? $doctor_info['firstname'] . ' ' . $doctor_info['lastname'] : '';

                $herbals_by_physicians[$herbal['doctor_id']]['doctor_id'] = $herbal['doctor_id'];
                $herbals_by_physicians[$herbal['doctor_id']]['doctor_name'] = $doctor_name;
                $herbals_by_physicians[$herbal['doctor_id']]['herbals'][] = $herbal;
            }

            $total_subtotal = 0;
            $total_tax = 0;
            $total_total = 0;
            $total_d_subtotal = 0;
            $total_d_tax = 0;
            $total_d_total = 0;

            foreach ($herbals_by_physicians as $doctor_id => $herbals) {
                $herbals_by_physicians[$doctor_id]['total_cs'] = count($herbals['herbals']);

                foreach ($herbals['herbals'] as $herbal) {
                    $total_subtotal += $herbal['net_total'];
                    $total_tax += $herbal['gst'];
                    $total_total += $herbal['clinicalsale_total'];
                    $total_d_subtotal += $herbal['d_net_amount'];
                    $total_d_tax += $herbal['d_gst'];
                    $total_d_total += $herbal['total_d_gst'];
                }

                $grandtotal_cs += count($herbals['herbals']);
                $grandtotal_subtotal += $total_subtotal;
                $grandtotal_tax += $total_tax;
                $grandtotal_total += $total_total;
                $grandtotal_d_subtotal += $total_d_subtotal;
                $grandtotal_d_tax += $total_d_tax;
                $grandtotal_d_total += $total_d_total;

                $herbal_remedies_by_physician_collection[] = [
                    'doctor_name'       => $herbals['doctor_name'],
                    'total_cs'          => count($herbals['herbals']),
                    'subtotal'          => $total_subtotal,
                    'tax'               => $total_tax,
                    'total'             => $total_total,
                    'd_subtotal'        => $total_d_subtotal,
                    'd_tax'             => $total_d_tax,
                    'd_total'           => $total_d_total,
                ];
            }

            $herbal_remedies_by_physician_collection[] = [
                '',
                $grandtotal_cs,
                $grandtotal_subtotal,
                $grandtotal_tax,
                $grandtotal_total,
                $grandtotal_d_subtotal,
                $grandtotal_d_tax,
                $grandtotal_d_total
            ];
        } else {
            $herbal_remedies_by_physician_collection[] = [
                '',
                $grandtotal_cs,
                $grandtotal_subtotal,
                $grandtotal_tax,
                $grandtotal_total,
                $grandtotal_d_subtotal,
                $grandtotal_d_tax,
                $grandtotal_d_total
            ];
        }

        $herbal_remedies_header = array(
            $this->language->get('column_date_added'),
            $this->language->get('column_invoice_prefix'),
            $this->language->get('column_subtotal'),
            $this->language->get('column_tax'),
            $this->language->get('column_total')
        );

        $herbal_remedies_by_physician_header = array(
            $this->language->get('column_physician_name'),
            $this->language->get('column_total_cs'),
            $this->language->get('column_total_subtotal'),
            $this->language->get('column_total_tax'),
            $this->language->get('column_total_total'),
            $this->language->get('column_total_d_subtotal'),
            $this->language->get('column_total_d_tax'),
            $this->language->get('column_total_d_total')
        );

        $services_collection = array();

        $services = $this->model_report_customer_info->getServices($filter_data, $this->request->get['customer_id']);

        $subtotal_service = 0;
        $tax_service = 0;
        $total_service = 0;

        if(!empty($services)){
            foreach($services as $service){
                $subtotal_service += $service['net_amount'];
                $tax_service += $service['t_gst'];
                $total_service += $service['total_price'];

                $services_collection[] = array(
                    'date_added'            => date($this->language->get('date_format_short'), strtotime($service['date_added'])),
                    'invoice_prefix'        => $service['invoice_prefix'],
                    'subtotal'              => $service['net_amount'],
                    'tax'                   => $service['t_gst'],
                    'total'                 => $service['total_price']
                );
            }

            $services_collection[] = array(
                '',
                '',
                $subtotal_service,
                $tax_service,
                $total_service
            );
        } else{
            $services_collection[] = array(
                '',
                '',
                $subtotal_service,
                $tax_service,
                $total_service
            );
        }

        $services_header = $herbal_remedies_header;

        $services_by_physician_collection = array();

        $grandtotal_sf = 0;
        $grandtotal_price = 0;
        $grandtotal_tax = 0;
        $grandtotal_total = 0;

        if (!empty($services)) {
            foreach ($services as $service) {
                $service_form_id = $service['service_form_id'];
                $service_items = $this->model_report_customer_info->getServiceItemBySevice($service_form_id);

                if (!empty($service_items)) {
                    foreach ($service_items as $item) {
                        $services_by_physician[$item['user_id']]['service_items'][] = $item;
                    }
                }
            }

            foreach ($services_by_physician as $doctor_id => $service_items) {
                $total_price = 0;
                $total_tax = 0;
                $total_total = 0;

                $services_by_physician[$doctor_id]['doctor_id'] = $doctor_id;

                $doctor_info = $this->model_user_user->getUser($doctor_id);
                $doctor_name = !empty($doctor_info) ? $doctor_info['firstname'] . ' ' . $doctor_info['lastname'] : '';
                
                $services_by_physician[$doctor_id]['doctor_name'] = $doctor_name;
                $services_by_physician[$doctor_id]['total_sf'] = count($service_items['service_items']);

                foreach ($service_items['service_items'] as $item) {
                    $total_price += $item['price'];
                    $total_tax += $item['gst'];
                    $total_total += $item['total'];
                }

                $grandtotal_sf += count($service_items['service_items']);
                $grandtotal_price += $total_price;
                $grandtotal_tax += $total_tax;
                $grandtotal_total += $total_total;

                $services_by_physician_collection[] = [
                    'doctor_name'       => $doctor_name,
                    'total_sf'          => count($service_items['service_items']),
                    'total_price'       => $total_price,
                    'total_tax'         => $total_tax,
                    'total_total'       => $total_total                    
                ];
            }

            $services_by_physician_collection[] = [
                '',
                $grandtotal_sf,
                $grandtotal_price,
                $grandtotal_tax,
                $grandtotal_total
            ];
        } else {
            $services_by_physician_collection[] = [
                '',
                $grandtotal_sf,
                $grandtotal_price,
                $grandtotal_tax,
                $grandtotal_total
            ];
        }

        $services_by_physician_header = array(
            $this->language->get('column_physician_name'),
            $this->language->get('column_total_sf'),
            $this->language->get('column_total_sf_subtotal'),
            $this->language->get('column_total_sf_tax'),
            $this->language->get('column_total_sf_total')
        );

        $services_by_service_collection = array();

        $grandtotal_subtotal_scs = 0;
        $grandtotal_tax_scs = 0;
        $grandtotal_total_scs = 0;

        if (!empty($services)) {
            foreach ($services as $service) {
                $service_form_id = $service['service_form_id'];
                $service_items = $this->model_report_customer_info->getServiceItemBySevice($service_form_id);

                if (!empty($service_items)) {
                    foreach ($service_items as $item) {
                        $services_by_service[$item['clinicalservice_id']]['clinicalservice_id'] = $item['clinicalservice_id'];

                        $clinicalservice_info = $this->model_report_customer_info->getClinicalService($item['clinicalservice_id']);

                        $clinicalservice_name = !empty($clinicalservice_info) ? $clinicalservice_info['name'] : '';

                        $services_by_service[$item['clinicalservice_id']]['clinicalservice_name'] = $clinicalservice_name;
                        $services_by_service[$item['clinicalservice_id']]['service_items'][] = $item;
                    }
                }
            }

            foreach ($services_by_service as $clinicalservice_id => $services) {
                $total_subtotal = 0;
                $total_tax = 0;
                $total_total = 0;
                
                foreach ($services['service_items'] as $item) {
                    $total_subtotal += $item['net_amount'];
                    $total_tax += $item['gst'];
                    $total_total += $item['total'];
                }

                $services_by_service_collection[] = [
                    'clinicalservice_name'  => $services['clinicalservice_name'],
                    'subtotal'              => $total_subtotal,
                    'tax'                   => $total_tax,
                    'total'                 => $total_total
                ];

                $grandtotal_subtotal_scs += $total_subtotal;
                $grandtotal_tax_scs += $total_tax;
                $grandtotal_total_scs += $total_total;
            }                   

            $services_by_service_collection[] = [
                '',
                $grandtotal_subtotal_scs,
                $grandtotal_tax_scs,
                $grandtotal_total_scs
            ];
        } else {
            $services_by_service_collection[] = [
                '',
                $grandtotal_subtotal_scs,
                $grandtotal_tax_scs,
                $grandtotal_total_scs
            ];
        }

        $services_by_service_header = array(
            $this->language->get('column_clinical_service'),
            $this->language->get('column_total_sf_subtotal'),
            $this->language->get('column_total_sf_tax'),
            $this->language->get('column_total_sf_total')
        );

        $orders_collection = array();

        $orders = $this->model_report_customer_info->getOrders($filter_data, $this->request->get['customer_id']);

        $subtotal_order = 0;
        $tax_order = 0;
        $total_order = 0;
        $rounding_order = 0;
        $shipping_order = 0;

        if(!empty($orders)){
            foreach($orders as $order){
                $orders_collection[$order['order_id']] = array(
                    'date_added'        => date($this->language->get('date_format_short'), strtotime($order['date_added'])),
                    'invoice_prefix'    => $order['invoice_prefix']
                );
            }

            foreach($orders_collection as $order_id => $order){
                $order_total = $this->model_report_customer_info->getOrderTotals($order_id);

                $orders_collection[$order_id]['tax'] = 0;
                $orders_collection[$order_id]['shipping'] = 0;

                if(!empty($order_total)){
                    foreach($order_total as $total){
                        if($total['code'] == 'sub_total'){
                            $orders_collection[$order_id]['subtotal'] = $total['value'];
                        } elseif(($total['code'] == 'tax') && ($total['tax_key'] == '88')){
                            $orders_collection[$order_id]['tax'] += $total['value'];
                        } elseif(($total['code'] == 'tax') && ($total['tax_key'] == '92')){
                            $orders_collection[$order_id]['tax'] += $total['value'];
                        } elseif($total['code'] == 'shipping'){
                            $orders_collection[$order_id]['shipping'] = $total['value'];
                        } elseif($total['code'] == 'rounding'){
                            $orders_collection[$order_id]['rounding'] = $total['value'];
                        } elseif($total['code'] == 'total'){
                            $orders_collection[$order_id]['total'] = $total['value'];
                        }
                    }
                }
            }
        }


        foreach($orders_collection as $order_id => $order){
            $orders_collection[$order_id]['tax'] = $order['tax'];
            $orders_collection[$order_id]['shipping'] = $order['shipping'];
        }

        if(!empty($orders_collection)){
            foreach($orders_collection as $order_id => $order){
                $subtotal_order += $order['subtotal'];
                $tax_order += $order['tax'];
                $total_order += $order['total'];
                $shipping_order += $order['shipping'];
                $rounding_order += $order['rounding'];
            }

            $total_orders = array(
                '',
                '',
                $subtotal_order,
                $shipping_order,
                $tax_order,
                $rounding_order,
                $total_order
            );
        } else{
            $total_orders = array(
                '',
                '',
                $subtotal_order,
                $shipping_order,
                $tax_order,
                $rounding_order,
                $total_order
            );
        }

        $orders_collection_arr = array_values($orders_collection);

        unset($orders_collection);

        foreach ($orders_collection_arr as $order) {
            $orders_collection[] = array(
                'date_added'        => $order['date_added'],
                'invoice_prefix'    => $order['invoice_prefix'],
                'subtotal'          => $order['subtotal'],
                'shipping'          => $order['shipping'],
                'tax'               => $order['tax'],
                'rounding'          => $order['rounding'],
                'total'             => $order['total']
            );
        }

        $orders_collection[] = $total_orders;

        $order_header = array(
            $this->language->get('column_date_added'),
            $this->language->get('column_invoice_prefix'),
            $this->language->get('column_subtotal'),
            $this->language->get('column_shipping'),
            $this->language->get('column_tax'),
            $this->language->get('column_rounding'),
            $this->language->get('column_total')
        );

        $table = array();

        $table[] = array('Report Name : ', $this->language->get('heading_title'));
        $table[] = array('Filter Date : ', $filter_date_start, $filter_date_end);

        $table[] = array();

        if(!empty($customer_info)){
            $table[] = array($this->language->get('column_customer_name'), $customer_info['firstname'] . ' ' . $customer_info['lastname']);
            $table[] = array($this->language->get('column_customer_ic'), $customer_info['customer_ic']);

            $text_gender = ($customer_info['gender'] == '1') ? $this->language->get('text_male') : $this->language->get('text_female');

            $table[] = array($this->language->get('column_gender'), $text_gender);
            $table[] = array($this->language->get('column_date_added'), date($this->language->get('date_format_short'), strtotime($customer_info['date_added'])));
        }

        $table[] = array();

        $table[] = array($this->language->get('tab_clinical_sale'));
        $table[] = $herbal_remedies_header;

        $total_herbal_remedies_row = 0;

		$table_herbal_remedies_data = $herbal_remedies_collection;

		foreach($table_herbal_remedies_data as $key => $data){
			$hr_row = array();
			foreach($data as $key => $value){
				$hr_row[] = $value;
			}
			$table[] = $hr_row; //add data row to table

			$total_herbal_remedies_row++;
        }

        $table[] = array();

        $table[] = array($this->language->get('tab_clinical_sale_by_physician'));
        $table[] = $herbal_remedies_by_physician_header;
        
        $total_herbal_remedies_by_physician_row = 0;

        $table_herbal_remedies_by_physician_data = $herbal_remedies_by_physician_collection;

        foreach ($table_herbal_remedies_by_physician_data as $key => $data) {
            $hr_row = array();
            
            foreach($data as $key => $value){
				$hr_row[] = $value;
			}
            
            $table[] = $hr_row; //add data row to table

            $total_herbal_remedies_by_physician_row++;
        }

        $table[] = array();

        $table[] = array($this->language->get('tab_service_form'));
        $table[] = $services_header;

        $total_services_row = 0;

		$table_services_data = $services_collection;

		foreach($table_services_data as $key => $data){
			$s_row = array();
			foreach($data as $key => $value){
				$s_row[] = $value;
			}
			$table[] = $s_row; //add data row to table

			$total_services_row++;
		}

        $table[] = array();

        $table[] = array($this->language->get('tab_service_form_physician'));
        $table[] = $services_by_physician_header;

        $total_services_by_physician_row = 0;

		$table_services_by_physician_data = $services_by_physician_collection;

		foreach($table_services_by_physician_data as $key => $data){
			$sp_row = array();
            
            foreach($data as $key => $value){
				$sp_row[] = $value;
			}
			$table[] = $sp_row; //add data row to table

			$total_services_by_physician_row++;
        }
        
        $table[] = array();

        $table[] = array($this->language->get('tab_service_form_service'));
        $table[] = $services_by_service_header;

        $total_services_by_service_row = 0;

		$table_services_by_service_data = $services_by_service_collection;

		foreach($table_services_by_service_data as $key => $data){
			$ss_row = array();
            
            foreach($data as $key => $value){
				$ss_row[] = $value;
			}
			$table[] = $ss_row; //add data row to table

			$total_services_by_service_row++;
        }
        
        $table[] = array();

        $table[] = array($this->language->get('tab_order'));
        $table[] = $order_header;

        $total_orders_row = 0;

		$table_orders_data = $orders_collection;

		foreach($table_orders_data as $key => $data){
			$o_row = array();
			foreach($data as $key => $value){
				$o_row[] = $value;
			}
			$table[] = $o_row; //add data row to table

			$total_orders_row++;
		}

        // Styling
        // set autosize for header of herbal remedies
        $hr_autosize_column_index = 'A';
        foreach($herbal_remedies_header as $header){
            $objPHPExcel->getActiveSheet()->getColumnDimension($hr_autosize_column_index)->setAutoSize(true);
        }

        // set the header range of herbal remedies
        $hr_header_index_s_column = 'A';
        $hr_header_index_e_column = $hr_header_index_s_column;
        foreach($herbal_remedies_header as $col) $hr_header_index_e_column++;
        $hr_header_index_row = 10;
        $hr_header_index_range = "$hr_header_index_s_column$hr_header_index_row:$hr_header_index_e_column$hr_header_index_row";

        // set the header range of herbal remedies by physician
        $hrp_header_index_s_column = 'A';
        $hrp_header_index_e_column = $hrp_header_index_s_column;
        foreach($herbal_remedies_by_physician_header as $col) $hrp_header_index_e_column++;
        $hrp_header_index_row = $hr_header_index_row + $total_herbal_remedies_row + 3;
        $hrp_header_index_range = "$hrp_header_index_s_column$hrp_header_index_row:$hrp_header_index_e_column$hrp_header_index_row";

        // set the header range of services
        $s_header_index_s_column = 'A';
        $s_header_index_e_column = $s_header_index_s_column;
        foreach($services_header as $col) $s_header_index_e_column++;
        $s_header_index_row = $hrp_header_index_row + $total_herbal_remedies_by_physician_row + 3;
        $s_header_index_range = "$s_header_index_s_column$s_header_index_row:$s_header_index_e_column$s_header_index_row";

        // set the header range of services by physician
        $sp_header_index_s_column = 'A';
        $sp_header_index_e_column = $sp_header_index_s_column;
        foreach($services_by_physician_header as $col) $sp_header_index_e_column++;
        $sp_header_index_row = $s_header_index_row + $total_services_row + 3;
        $sp_header_index_range = "$sp_header_index_s_column$sp_header_index_row:$sp_header_index_e_column$sp_header_index_row";
   
        // set the header range of services by service
        $ss_header_index_s_column = 'A';
        $ss_header_index_e_column = $ss_header_index_s_column;
        foreach($services_by_service_header as $col) $ss_header_index_e_column++;
        $ss_header_index_row = $sp_header_index_row + $total_services_by_physician_row + 3;
        $ss_header_index_range = "$ss_header_index_s_column$ss_header_index_row:$ss_header_index_e_column$ss_header_index_row";
        
        // set the header range of orders
        $o_header_index_s_column = 'A';
        $o_header_index_e_column = $o_header_index_s_column;
        foreach($order_header as $col) $o_header_index_e_column++;
        $o_header_index_row = $ss_header_index_row + $total_services_by_service_row + 3;
        $o_header_index_range = "$o_header_index_s_column$o_header_index_row:$o_header_index_e_column$o_header_index_row";

        $general_style2 = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'numberformat'  => array(
                'code'  => '000000000000'
            )
        );

        $header_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font'  => array(
                'bold'  => true
            )
        );

        $bold_style = array(
            'alignment' => array(
                'horizontal'    => PHPExcel_Style_Alignment::HORIZONTAL_LEFT
            ),
            'font'  => array(
                'bold'  => true
            )
        );

        $currency_style = array(
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
			),
			'numberformat' => array(
				'code' => "0.00"
			)
		);

        // set autosize for report header, customer details
        $autosize_column_index_arr = array('A', 'B', 'C');

        foreach($autosize_column_index_arr as $autosize_column_index){
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
        }

        // ic formatting
        $objPHPExcel->getActiveSheet()->getStyle('B5')->applyFromArray($general_style2);

        // make the column bold and text align left
        $objPHPExcel->getActiveSheet()->getStyle('A4:A7')->applyFromArray($bold_style);
        $objPHPExcel->getActiveSheet()->getStyle('A9')->applyFromArray($bold_style);

        $hrp_title_row = $hr_header_index_row + $total_herbal_remedies_row + 2;
        $objPHPExcel->getActiveSheet()->getStyle('A' . $hrp_title_row)->applyFromArray($bold_style);

        $s_title_row = $hrp_header_index_row + $total_herbal_remedies_by_physician_row + 2;
        $objPHPExcel->getActiveSheet()->getStyle('A' . $s_title_row)->applyFromArray($bold_style);

        $sp_title_row = $s_header_index_row + $total_services_row + 2;
        $objPHPExcel->getActiveSheet()->getStyle('A' . $sp_title_row)->applyFromArray($bold_style);

        $ss_title_row = $sp_header_index_row + $total_services_by_physician_row + 2;
        $objPHPExcel->getActiveSheet()->getStyle('A' . $ss_title_row)->applyFromArray($bold_style);

        $o_title_row = $ss_header_index_row + $total_services_by_service_row + 2;
        $objPHPExcel->getActiveSheet()->getStyle('A' . $o_title_row)->applyFromArray($bold_style);

        // header style is text align center and bold for herbal remedies, services and orders
        $objPHPExcel->getActiveSheet()->getStyle($hr_header_index_range)->applyFromArray($header_style);
        $objPHPExcel->getActiveSheet()->getStyle($hrp_header_index_range)->applyFromArray($header_style);
        $objPHPExcel->getActiveSheet()->getStyle($s_header_index_range)->applyFromArray($header_style);
        $objPHPExcel->getActiveSheet()->getStyle($sp_header_index_range)->applyFromArray($header_style);
        $objPHPExcel->getActiveSheet()->getStyle($ss_header_index_range)->applyFromArray($header_style);
        $objPHPExcel->getActiveSheet()->getStyle($o_header_index_range)->applyFromArray($header_style);

        // herbal remedies column for currency format which are subtotal, tax and total
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($hr_header_index_row + 1) . ":C" . ($hr_header_index_row + 1 + $total_herbal_remedies_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($hr_header_index_row + 1) . ":D" . ($hr_header_index_row + 1 + $total_herbal_remedies_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($hr_header_index_row + 1) . ":E" . ($hr_header_index_row + 1 + $total_herbal_remedies_row))->applyFromArray($currency_style);

        // herbal remedies by physician column for currency format which are subtotal, tax and total
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($hrp_header_index_row + 1) . ":C" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($hrp_header_index_row + 1) . ":D" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($hrp_header_index_row + 1) . ":E" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("F" . ($hrp_header_index_row + 1) . ":F" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("G" . ($hrp_header_index_row + 1) . ":G" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("H" . ($hrp_header_index_row + 1) . ":H" . ($hrp_header_index_row + 1 + $total_herbal_remedies_by_physician_row))->applyFromArray($currency_style);

        // services column for currency format which are subtotal, tax and total
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($s_header_index_row + 1) . ":C" . ($s_header_index_row + 1 + $total_services_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($s_header_index_row + 1) . ":D" . ($s_header_index_row + 1 + $total_services_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($s_header_index_row + 1) . ":E" . ($s_header_index_row + 1 + $total_services_row))->applyFromArray($currency_style);

        // services by physician column for currency format which are subtotal, tax and total
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($sp_header_index_row + 1) . ":C" . ($sp_header_index_row + 1 + $total_services_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($sp_header_index_row + 1) . ":D" . ($sp_header_index_row + 1 + $total_services_by_physician_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($sp_header_index_row + 1) . ":E" . ($sp_header_index_row + 1 + $total_services_by_physician_row))->applyFromArray($currency_style);
        
        // services by service column for currency format which are subtotal, tax and total
        $objPHPExcel->getActiveSheet()->getStyle("B" . ($ss_header_index_row + 1) . ":B" . ($ss_header_index_row + 1 + $total_services_by_service_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($ss_header_index_row + 1) . ":C" . ($ss_header_index_row + 1 + $total_services_by_service_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($ss_header_index_row + 1) . ":D" . ($ss_header_index_row + 1 + $total_services_by_service_row))->applyFromArray($currency_style);

        // orders column for currency format which are subtotal, shipping, tax, rounding and total
        $objPHPExcel->getActiveSheet()->getStyle("C" . ($o_header_index_row + 1) . ":C" . ($o_header_index_row + 1 + $total_orders_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("D" . ($o_header_index_row + 1) . ":D" . ($o_header_index_row + 1 + $total_orders_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("E" . ($o_header_index_row + 1) . ":E" . ($o_header_index_row + 1 + $total_orders_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("F" . ($o_header_index_row + 1) . ":F" . ($o_header_index_row + 1 + $total_orders_row))->applyFromArray($currency_style);
        $objPHPExcel->getActiveSheet()->getStyle("G" . ($o_header_index_row + 1) . ":G" . ($o_header_index_row + 1 + $total_orders_row))->applyFromArray($currency_style);

        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);


        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $filename = $this->language->get('heading_title') . '_' . $filter_date_start . '_' . $filter_date_end . '_' . $customer_id;

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $filename . '.xlsx"');
        $objWriter->save('php://output');
    }
}
?>