<?php

class ControllerPrescriptionPulse extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/pulse');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/pulse');

        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/pulse');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/pulse');


        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_pulse->addPulse($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/pulse');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/pulse');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_prescription_pulse->editPulse($this->request->get['pulse_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            $this->response->redirect($this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/pulse');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/pulse');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $pulse_id)
                $this->model_prescription_pulse->deletePulse($pulse_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/pulse');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/pulse');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }

        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap data
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/pulse/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        $data['add'] = $this->url->link('prescription/pulse/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/pulse/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_pinyin' => $filter_pinyin,
            'filter_code' => $filter_code,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $data['filter_data'] = $filter_data;

        $data['pulses'] = array();

        $pulseList = $this->model_prescription_pulse->getPulseList($filter_data);

        foreach ($pulseList as $pulse) {
            $data['pulses'][] = array(
                'pulse_id' => $pulse['pulse_id'],
                'name' => $pulse['name'],
                'pinyin' => $pulse['pinyin'],
                'code' => $pulse['code'],
                'sort_order' => $pulse['sort_order'],
                'edit' => $this->url->link('prescription/pulse/edit', 'user_token=' . $this->session->data['user_token'] . '&pulse_id=' . $pulse['pulse_id'] . $querystring, true)
            );
        }

        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : NULL;
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_name'] = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);

        //rebuild querystring for pagination
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination
        $pulse_total = $this->model_prescription_pulse->totalPulse($filter_data);

        $pagination = new Pagination();
        $pagination->total = $pulse_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($pulse_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($pulse_total - $this->config->get('config_limit_admin'))) ? $pulse_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $pulse_total, ceil($pulse_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/pulse_list', $data));
    }

    public function openwindow() {

        $this->load->language('prescription/pulse');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/pulse');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;

        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;

        $data['pulses'] = array();

        $pulseList = $this->model_prescription_pulse->getPulseList($filter_data);
        foreach ($pulseList as $pulse) {
            $data['pulses'][] = array(
                'pulse_id' => $pulse['pulse_id'],
                'name' => $pulse['name'],
                'code' => $pulse['code'],
                'sort_order' => $pulse['sort_order'],
                'select' => $pulse['name'],
            );
        }

        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/pulse_list', $data));
    }

    public function pulseItem() {
        $json = array();

        $this->load->language('prescription/pulse');
        $this->load->model('prescription/pulse');

        $pulse_items = $this->model_prescription_pulse->getPulseItem($this->request->get['pulse_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');

        $json['pulse'] = array();

        if (!empty($pulse_items)) {
            foreach ($pulse_items as $item) {
                $json['pulse'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }

        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {

        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();
        if (isset($this->request->get['pulse_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_pulse->getPulseColumn($this->request->get['pulse_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_pulse_name"] = isset($this->request->post['pulse_name']) ? // if request post from form
                $this->request->post['pulse_name'] :
                (isset($this->request->get['pulse_id']) ? $nameMemory : array());

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['pulse_id']) ?
                $this->model_prescription_pulse->getPulseColumn($this->request->get['pulse_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['pulse_id']) ?
                $this->model_prescription_pulse->getPulseColumn($this->request->get['pulse_id'], 'code') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['pulse_id']) ?
                $this->model_prescription_pulse->getPulseColumn($this->request->get['pulse_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['pulse_id']) ?
                $this->model_prescription_pulse->getPulseColumn($this->request->get['pulse_id'], 'status') :
                1
                );

        $data["form_memory_pulse_items"] = isset($this->request->post['pulseitem']) ? // if request post from form
                $this->request->post['pulseitem'] :
                (
                isset($this->request->get['pulse_id']) ?
                $this->model_prescription_pulse->getPulseItemList($this->request->get['pulse_id']) :
                false
                );

        $data['text_form'] = !(isset($this->request->get['pulse_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //sitemap data
        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/pulse', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['pulse_id']))
            $querystring .= '&pulse_id=' . $this->request->get['pulse_id'];
        $action_mode = !(isset($this->request->get['pulse_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("prescription/pulse/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;
        $data['error_pulse_name'] = isset($this->error['pulse_name']) ? $this->error['pulse_name'] : NULL;

        $data['error_pulse_item_code'] = isset($this->error['diagnostic_item_code']) ? $this->error['diagnostic_item_code'] : NULL;
        $data['error_pulse_item_pinyin'] = isset($this->error['diagnostic_item_pinyin']) ? $this->error['diagnostic_item_pinyin'] : NULL;
        $data['error_pulse_item_pulse_name'] = isset($this->error['pulse_item_pulse_name']) ? $this->error['pulse_item_pulse_name'] : NULL;

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/pulse_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/pulse') && !$this->user->userpermission('modify', 'prescription/pulse'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general pulse name
        foreach ($this->request->post['pulse_name'] as $language_id => $value) {
            if (validIsNullOrEmpty($value['name']))
                $this->error['pulse_name'][$language_id] = $this->language->get('error_pulse_name');
        }

        //validate general pulse code
        $pulsecode = $this->request->post['code'];
        if (validIsNullOrEmpty($pulsecode))
            $this->error['name']['code'] = $this->language->get('error_pulse_code');

        $pulsepinyin = $this->request->post['pinyin'];
        if (validIsNullOrEmpty($pulsepinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_pulse_pinyin');

        //validate pulse item
        $pulseitems = isset($this->request->post['pulseitem']) ? $this->request->post['pulseitem'] : false;
        if ($pulseitems) {
            foreach ($pulseitems as $diseasitempos => $pulseitem) {

                //validate pulse item code
                $pulseitemcode = $pulseitem['code'];
                if (validIsNullOrEmpty($pulseitemcode))
                    $this->error['diagnostic_item_code'][$diseasitempos] = $this->language->get('error_pulse_code');

                $pulseitempinyin = $pulseitem['pinyin'];
                if (validIsNullOrEmpty($pulseitempinyin))
                    $this->error['diagnostic_item_pinyin'][$diseasitempos] = $this->language->get('error_pulse_pinyin');

                //validate general pulse name
                $pulseitemnames = $pulseitem['pulse_name'];
                foreach ($pulseitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['pulse_item_pulse_name'][$diseasitempos][$language_id] = $this->language->get('error_pulse_name');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/pulse') && !$this->user->userpermission('delete', 'prescription/pulse')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/pulse');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );

            $pulseList = $this->model_prescription_pulse->getPulseList($filter_data);

            foreach ($pulseList as $row => $pulse) {
                $json[] = array(
                    'pulse_id' => $pulse['pulse_id'],
                    'name' => $pulse['name'],
                    'code' => $pulse['code'],
                    'pinyin' => $pulse['pinyin']
                );
            }
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>
