<?php

class ControllerPrescriptionConsultation extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/consultation');
        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/consultation');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_consultation->addConsultation($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';
            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];
            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];
            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];
            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
            $this->response->redirect($this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/consultation');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_prescription_consultation->editConsultation($this->request->get['consultation_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];
            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];
            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];
            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
            $this->response->redirect($this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/consultation');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $consultation_id)
                $this->model_prescription_consultation->deleteConsultation($consultation_id);
            $this->session->data['success'] = $this->language->get('text_success');
        }

        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/consultation');
        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';
            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];
            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];
            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];
            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];
            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];
            $this->response->redirect($this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;
        $data['user_token'] = $user_token;
        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap ata
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'], true)
        );
        //query string
        $querystring = '';
        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];
        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];
        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];
        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];
        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/consultation/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['add'] = $this->url->link('prescription/consultation/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/consultation/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );
        $data['filter_data'] = $filter_data;
        $data['consultations'] = array();
        $consultationList = $this->model_prescription_consultation->getConsultationList($filter_data);
        foreach ($consultationList as $consultation) {
            $data['consultations'][] = array(
                'consultation_id' => $consultation['consultation_id'],
                'name' => $consultation['name'],
                'code' => $consultation['code'],
                'pinyin' => $consultation['pinyin'],
                'sort_order' => $consultation['sort_order'],
                'edit' => $this->url->link('prescription/consultation/edit', 'user_token=' . $this->session->data['user_token'] . '&consultation_id=' . $consultation['consultation_id'] . $querystring, true)
            );
        }
        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : NULL;
        unset($this->session->data['success']);
        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");
        $data['sort_name'] = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);
        //rebuild querystring for pagination
        $querystring = '';
        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];
        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];
        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];
        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        //pagination
        $consultation_total = $this->model_prescription_consultation->totalConsultation($filter_data);
        $pagination = new Pagination();
        $pagination->total = $consultation_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);
        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($consultation_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($consultation_total - $this->config->get('config_limit_admin'))) ? $consultation_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $consultation_total, ceil($consultation_total / $this->config->get('config_limit_admin')));
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['sort'] = $sort;
        $data['order'] = $order;
        $this->response->setOutput($this->load->view('prescription/consultation_list', $data));
    }

    public function openwindow() {
        $this->load->language('prescription/consultation');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/consultation');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;

        $filter_data = array(
            'filter_status' => 1,
        );
        $data['filter_data'] = $filter_data;
        $data['consultations'] = array();
        $consultationList = $this->model_prescription_consultation->getConsultationList($filter_data);
        foreach ($consultationList as $consultation) {
            $data['consultations'][] = array(
                'consultation_id' => $consultation['consultation_id'],
                'name' => $consultation['name'],
                'code' => $consultation['code'],
                'sort_order' => $consultation['sort_order'],
                'select' => $consultation['name'],
            );
        }
        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/consultation_list ', $data));
    }

    public function consultationItem() {
        $json = array();
        $this->load->language('prescription/consultation');
        $this->load->model('prescription/consultation');
        $consultation_items = $this->model_prescription_consultation->getConsultationItem($this->request->get['consultation_id']);
        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');
        $json['consultation'] = array();

        if (!empty($consultation_items)) {
            foreach ($consultation_items as $item) {
                $json['consultation'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }
        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();
        if (isset($this->request->get['consultation_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_consultation->getConsultationColumn($this->request->get['consultation_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_consultation_name"] = isset($this->request->post['consultation_name']) ? // if request post from form
                $this->request->post['consultation_name'] :
                (isset($this->request->get['consultation_id']) ? $nameMemory : array());

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['consultation_id']) ?
                $this->model_prescription_consultation->getConsultationColumn($this->request->get['consultation_id'], 'code') :
                NULL
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['consultation_id']) ?
                $this->model_prescription_consultation->getConsultationColumn($this->request->get['consultation_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['consultation_id']) ?
                $this->model_prescription_consultation->getConsultationColumn($this->request->get['consultation_id'], 'sort_order') :
                0
                );

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['consultation_id']) ?
                $this->model_prescription_consultation->getConsultationColumn($this->request->get['consultation_id'], 'status') :
                1
                );

        $data["form_memory_consultation_items"] = isset($this->request->post['consultationitem']) ? // if request post from form
                $this->request->post['consultationitem'] :
                (
                isset($this->request->get['consultation_id']) ?
                $this->model_prescription_consultation->getConsultationItemList($this->request->get['consultation_id']) :
                false
                );

        $data['text_form'] = !(isset($this->request->get['consultation_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'], true)
        );
        //query string
        $querystring = '';
        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];
        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];
        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];
        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];
        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];
        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];
        //urls
        $data['cancel'] = $this->url->link('prescription/consultation', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        if (isset($this->request->get['consultation_id']))
            $querystring .= '&consultation_id=' . $this->request->get['consultation_id'];
        $action_mode = !(isset($this->request->get['consultation_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("prescription/consultation/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->load->view('prescription/consultation_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/consultation') && !!$this->user->userpermission('modify', 'prescription/consultation'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general consultation name
        foreach ($this->request->post['consultation_name'] as $language_id => $value) {
            if (validIsNullOrEmpty($value['name']))
                $this->error['name']['name' . $language_id] = $this->language->get('error_consultation_name');
        }
        //validate general consultation code
        $consultationcode = $this->request->post['code'];
        if (validIsNullOrEmpty($consultationcode))
            $this->error['name']['code'] = $this->language->get('error_consultation_code');
        //validate general consultation code
        $consultationpinyin = $this->request->post['pinyin'];
        if (validIsNullOrEmpty($consultationpinyin))
            $this->error['name']['pinyin'] = $this->language->get('error_consultation_pinyin');
        //validate consultation item
        $consultationitems = isset($this->request->post['consultationitem']) ? $this->request->post['consultationitem'] : false;
        if ($consultationitems) {
            foreach ($consultationitems as $diseasitempos => $consultationitem) {
                //validate consultation item code
                $consultationitemcode = $consultationitem['code'];
                if (validIsNullOrEmpty($consultationitemcode))
                    $this->error['name']['consultationitem_' . $diseasitempos . '_code'] = $this->language->get('error_consultation_code');
                $consultationitempinyin = $consultationitem['pinyin'];
                if (validIsNullOrEmpty($consultationitempinyin))
                    $this->error['name']['consultationitem_' . $diseasitempos . '_pinyin'] = $this->language->get('error_consultation_pinyin');
                //validate general consultation name
                $consultationitemnames = $consultationitem['consultation_name'];
                foreach ($consultationitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['name']['consultationitem_' . $diseasitempos . '_name' . $language_id] = $this->language->get('error_consultation_name');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');
        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/consultation') && !$this->user->userpermission('delete', 'prescription/consultation')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

    public function autocomplete() {
        $json = array();
        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/consultation');
            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;
            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );
            $consultationList = $this->model_prescription_consultation->getConsultationList($filter_data);
            foreach ($consultationList as $row => $consultation) {
                $json[] = array(
                    'consultation_id' => $consultation['consultation_id'],
                    'name' => $consultation['name'],
                    'code' => $consultation['code'],
                    'pinyin' => $consultation['pinyin']
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>