<?php

class ControllerPrescriptionAcupuncture extends Controller {

    private $error = array();

    public function index() {
        $this->load->language('prescription/acupuncture');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture');
        $this->getList();
    }

    public function add() {
        $this->load->language('prescription/acupuncture');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/acupuncture');
        $this->load->model('tool/image');

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateForm()) {
            $this->model_prescription_acupuncture->addAcupuncture($this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function edit() {
        $this->load->language('prescription/acupuncture');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('prescription/acupuncture');
        $this->load->model('tool/image');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_prescription_acupuncture->editAcupuncture($this->request->get['acupuncture_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');

            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            if (isset($this->request->get['page']))
                $querystring .= '&page=' . $this->request->get['page'];

            if (isset($this->request->get['filter_name']))
                $querystring .= '&filter_name=' . $this->request->get['filter_name'];

            if (isset($this->request->get['filter_code']))
                $querystring .= '&filter_code=' . $this->request->get['filter_code'];

            if (isset($this->request->get['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    public function delete() {
        $this->load->language('prescription/acupuncture');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            $selected = $this->request->post['selected'];
            foreach ($selected as $acupuncture_id)
                $this->model_prescription_acupuncture->deleteAcupuncture($acupuncture_id);

            $this->session->data['success'] = $this->language->get('text_success');
        }
        $this->getList();
    }

    public function filter() {
        $this->load->language('prescription/acupuncture');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('prescription/acupuncture');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            //query string
            $querystring = '';

            if (isset($this->request->get['sort']))
                $querystring .= '&sort=' . $this->request->get['sort'];

            if (isset($this->request->get['order']))
                $querystring .= '&order=' . $this->request->get['order'];

            //post from filter form
            if (isset($this->request->post['filter_name']))
                $querystring .= '&filter_name=' . $this->request->post['filter_name'];

            if (isset($this->request->post['filter_code']))
                $querystring .= '&filter_code=' . $this->request->post['filter_code'];

            if (isset($this->request->post['filter_pinyin']))
                $querystring .= '&filter_pinyin=' . $this->request->post['filter_pinyin'];

            $this->response->redirect($this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . $querystring, true));
        }
        $this->getForm();
    }

    protected function getList() {
        //filter input memory
        $data["filter_name_memory"] = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
        $data["filter_code_memory"] = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
        $data["filter_pinyin_memory"] = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;
        $sort = isset($this->request->get['sort']) ? $this->request->get['sort'] : 'name';
        $order = isset($this->request->get['order']) ? $this->request->get['order'] : 'ASC';
        $page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

        $data['user_token'] = $user_token;

        $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : NULL;
        $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : NULL;
        $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : NULL;

        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'], true)
        );
        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //urls
        $data['filter'] = $this->url->link('prescription/acupuncture/filter', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['add'] = $this->url->link('prescription/acupuncture/add', 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        $data['delete'] = $this->url->link("prescription/acupuncture/delete", 'user_token=' . $this->session->data['user_token'] . $querystring, true);
        //filter data
        $filter_data = array(
            'sort' => $sort,
            'order' => $order,
            'filter_name' => $filter_name,
            'filter_code' => $filter_code,
            'filter_pinyin' => $filter_pinyin,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );
        $data['filter_data'] = $filter_data;
        $data['acupunctures'] = array();
        $acupunctureList = $this->model_prescription_acupuncture->getAcupunctureList($filter_data);

        foreach ($acupunctureList as $acupuncture) {
            $data['acupunctures'][] = array(
                'acupuncture_id' => $acupuncture['acupuncture_id'],
                'name' => $acupuncture['name'],
                'code' => $acupuncture['code'],
                'pinyin' => $acupuncture['pinyin'],
                'sort_order' => $acupuncture['sort_order'],
                'edit' => $this->url->link('prescription/acupuncture/edit', 'user_token=' . $this->session->data['user_token'] . '&acupuncture_id=' . $acupuncture['acupuncture_id'] . $querystring, true)
            );
        }
        //error warning
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';

        //success alert
        $data['success'] = isset($this->session->data['success']) ? $this->session->data['success'] : '';
        unset($this->session->data['success']);

        //rebuild querystring for sorting
        $querystringforsort = '';
        $querystringforsort .= "&order=" . (($order == "ASC") ? "DESC" : "ASC");

        $data['sort_name'] = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . '&sort=name' . $querystringforsort, true);
        $data['sort_code'] = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . '&sort=code' . $querystringforsort, true);
        $data['sort_sort_order'] = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . '&sort=sort_order' . $querystringforsort, true);
        $data['sort_pinyin'] = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . '&sort=pinyin' . $querystringforsort, true);
        //rebuild querystring for pagination
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        if (isset($this->request->get['filter_pinyin']))
            $querystring .= '&filter_pinyin=' . $this->request->get['filter_pinyin'];

        //pagination
        $acupuncture_total = $this->model_prescription_acupuncture->totalAcupuncture($filter_data);

        $pagination = new Pagination();
        $pagination->total = $acupuncture_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . $querystring . '&page={page}', true);

        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($acupuncture_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($acupuncture_total - $this->config->get('config_limit_admin'))) ? $acupuncture_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $acupuncture_total, ceil($acupuncture_total / $this->config->get('config_limit_admin')));

        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->response->setOutput($this->load->view('prescription/acupuncture_list', $data));
    }

    public function openwindow() {
        $this->load->language('prescription/acupuncture');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->addScript('view/javascript/herbal/load.js');
        $this->load->model('prescription/acupuncture');
        //querystring to variable
        $user_token = isset($this->request->get['user_token']) ? $this->request->get['user_token'] : false;

        $data['user_token'] = $user_token;
        //module view data

        $filter_data = array(
            'filter_status' => 1,
        );

        $data['filter_data'] = $filter_data;
        $data['acupunctures'] = array();

        $acupunctureList = $this->model_prescription_acupuncture->getAcupunctureList($filter_data);
        foreach ($acupunctureList as $acupuncture) {
            $data['acupunctures'][] = array(
                'acupuncture_id' => $acupuncture['acupuncture_id'],
                'name' => $acupuncture['name'],
                'code' => $acupuncture['code'],
                'sort_order' => $acupuncture['sort_order'],
                'select' => $acupuncture['name'],
            );
        }
        $data['header'] = $this->load->controller('common/header/pop_header');
        $this->response->setOutput($this->load->view('openwindow/acupuncture_list', $data));
    }

    public function acupunctureItem() {
        $json = array();
        $this->load->language('prescription/acupuncture');
        $this->load->model('prescription/acupuncture');

        $acupuncture_items = $this->model_prescription_acupuncture->getAcupunctureItem($this->request->get['acupuncture_id']);

        $json['entry_name'] = $this->language->get('entry_name');
        $json['entry_code'] = $this->language->get('entry_code');
        $json['acupuncture'] = array();

        if (!empty($acupuncture_items)) {
            foreach ($acupuncture_items as $item) {
                $json['acupuncture'][] = array(
                    'name' => $item['name'],
                    'code' => $item['code'],
                    'pinyin' => $item['pinyin']
                );
            }
        } else {
            $json['error'] = $this->language->get('error_empty');
        }
        return $this->response->setOutput(json_encode($json));
    }

    protected function getForm() {
        $this->load->model('localisation/language'); //load other module model
        $data['languages'] = $this->model_localisation_language->getLanguages(); //get languages
        //form input memory
        $nameMemory = array();
        if (isset($this->request->get['acupuncture_id'])) {
            foreach ($data['languages'] as $language) {
                $nameMemory[$language['language_id']] = array('name' => $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'name', false, $language['language_id']));
            }
        }
        $data["form_memory_acupuncture_name"] = isset($this->request->post['acupuncture_name']) ? // if request post from form
                $this->request->post['acupuncture_name'] :
                (isset($this->request->get['acupuncture_id']) ? $nameMemory : array());

        $data["form_memory_code"] = isset($this->request->post['code']) ? // if request post from form
                $this->request->post['code'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'code') :
                NULL
                );

        $data["form_memory_pinyin"] = isset($this->request->post['pinyin']) ? // if request post from form
                $this->request->post['pinyin'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'pinyin') :
                NULL
                );

        $data["form_memory_sort_order"] = isset($this->request->post['sort_order']) ? // if request post from form
                $this->request->post['sort_order'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'sort_order') :
                0
                );

        $data['image'] = isset($this->request->post['image']) ?
                $this->request->post['image'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'image') : ''
                );

        $data['thumb'] = isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image']) ?
                $this->model_tool_image->resize($this->request->post['image'], 100, 100) :
                (
                isset($this->request->get['acupuncture_id']) ? (!empty($this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'image')) ? $this->model_tool_image->resize($this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'image'), 100, 100) : $this->model_tool_image->resize('no_image.png', 100, 100)) : $this->model_tool_image->resize('no_image.png', 100, 100)
                );

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

        $data["form_memory_status"] = isset($this->request->post['status']) ? // if request post from form
                $this->request->post['status'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureColumn($this->request->get['acupuncture_id'], 'status') :
                1
                );

        $data["form_memory_acupuncture_items"] = isset($this->request->post['acupunctureitem']) ? // if request post from form
                $this->request->post['acupunctureitem'] :
                (
                isset($this->request->get['acupuncture_id']) ?
                $this->model_prescription_acupuncture->getAcupunctureItemList($this->request->get['acupuncture_id']) :
                false
                );

        //module data
        $data['text_form'] = !(isset($this->request->get['acupuncture_id'])) ? $this->language->get('text_add') : $this->language->get('text_edit');

        //sitemap data
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'], true)
        );

        //query string
        $querystring = '';

        if (isset($this->request->get['sort']))
            $querystring .= '&sort=' . $this->request->get['sort'];

        if (isset($this->request->get['order']))
            $querystring .= '&order=' . $this->request->get['order'];

        if (isset($this->request->get['page']))
            $querystring .= '&page=' . $this->request->get['page'];

        if (isset($this->request->get['filter_name']))
            $querystring .= '&filter_name=' . $this->request->get['filter_name'];

        if (isset($this->request->get['filter_code']))
            $querystring .= '&filter_code=' . $this->request->get['filter_code'];

        //urls
        $data['cancel'] = $this->url->link('prescription/acupuncture', 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        if (isset($this->request->get['acupuncture_id']))
            $querystring .= '&acupuncture_id=' . $this->request->get['acupuncture_id'];
        $action_mode = !(isset($this->request->get['acupuncture_id'])) ? 'add' : 'edit';
        $data['action'] = $this->url->link("prescription/acupuncture/" . $action_mode, 'user_token=' . $this->session->data['user_token'] . $querystring, true);

        //error
        $data['error_warning'] = isset($this->error['warning']) ? $this->error['warning'] : '';
        $data['error_acupuncture_name'] = isset($this->error['acupuncture_name']) ? $this->error['acupuncture_name'] : NULL;
        $data['error_name'] = isset($this->error['name']) ? $this->error['name'] : NULL;

        $data['error_acupuncture_item_code'] = isset($this->error['acupuncture_item_code']) ? $this->error['acupuncture_item_code'] : NULL;
        $data['error_acupuncture_item_acupuncture_name'] = isset($this->error['acupuncture_item_acupuncture_name']) ? $this->error['acupuncture_item_acupuncture_name'] : NULL;

        $acupuncture_body_parts = $this->model_prescription_acupuncture->getAcupunctureBodyParts();

        if (!empty($acupuncture_body_parts)) {
            foreach ($acupuncture_body_parts as $part) {
                $data['body_parts'][] = array(
                    'acupuncture_part_id' => $part['acupuncture_part_id'],
                    'name' => $part['name']
                );
            }
        }
        //load template module
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('prescription/acupuncture_form', $data));
    }

    protected function validateForm() {

        // validation function
        function validIsNullOrEmpty($str) {
            $trimStr = trim($str);
            return (empty($trimStr));
        }

        function validIsNumeric($str) {
            return is_numeric($str);
        }

        //permission checking
        if (!$this->user->hasPermission('modify', 'prescription/acupuncture') && !$this->user->userpermission('modify', 'prescription/acupuncture'))
            $this->error['warning'] = $this->language->get('error_permission');

        //validate general acupuncture name
        foreach ($this->request->post['acupuncture_name'] as $language_id => $value) {
            if (validIsNullOrEmpty($value['name']))
                $this->error['acupuncture_name'][$language_id] = $this->language->get('error_acupuncture_name');
        }

        //validate general acupuncture code
        $acupuncturecode = $this->request->post['code'];
        if (validIsNullOrEmpty($acupuncturecode))
            $this->error['name']['code'] = $this->language->get('error_acupuncture_code');

        $acupunctureitems = isset($this->request->post['acupunctureitem']) ? $this->request->post['acupunctureitem'] : false;
        if ($acupunctureitems) {
            foreach ($acupunctureitems as $diseasitempos => $acupunctureitem) {

                //validate acupuncture item code
                $acupunctureitemcode = $acupunctureitem['code'];
                if (validIsNullOrEmpty($acupunctureitemcode))
                    $this->error['acupuncture_item_code'][$diseasitempos] = $this->language->get('error_acupuncture_code');

                //validate general acupuncture name
                $acupunctureitemnames = $acupunctureitem['acupuncture_name'];
                foreach ($acupunctureitemnames as $language_id => $value) {
                    if (validIsNullOrEmpty($value['name']))
                        $this->error['acupuncture_item_acupuncture_name'][$diseasitempos][$language_id] = $this->language->get('error_acupuncture_name');
                }
            }
        }

        //error
        if ($this->error && !isset($this->error['warning']))
            $this->error['warning'] = $this->language->get('error_warning');

        return !$this->error;
    }

    protected function validateDelete() {
        if (!$this->user->hasPermission('delete', 'prescription/acupuncture') && !$this->user->userpermission('delete', 'prescription/acupuncture')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        foreach ($this->request->post['selected'] as $acupuncture_id) {
            $acupuncture_items = $this->model_prescription_acupuncture->getAcupunctureItem($acupuncture_id);

            if (count($acupuncture_items) > 0) {
                $this->error['warning'] = sprintf($this->language->get('error_acupuncture_items'), count($acupuncture_items));
            }
        }
        return !$this->error;
    }

    public function autocomplete() {
        $json = array();

        if (isset($this->request->get['filter_name']) || isset($this->request->get['filter_code']) || isset($this->request->get['filter_pinyin'])) {
            $this->load->model('prescription/acupuncture');

            $filter_name = isset($this->request->get['filter_name']) ? $this->request->get['filter_name'] : "";
            $filter_code = isset($this->request->get['filter_code']) ? $this->request->get['filter_code'] : "";
            $filter_pinyin = isset($this->request->get['filter_pinyin']) ? $this->request->get['filter_pinyin'] : "";

            $limit = isset($this->request->get['limit']) ? $this->request->get['limit'] : 5;

            $filter_data = array(
                'filter_name' => $filter_name,
                'filter_code' => $filter_code,
                'filter_pinyin' => $filter_pinyin,
                'start' => 0,
                'limit' => $limit
            );
            $acupunctureList = $this->model_prescription_acupuncture->getAcupunctureList($filter_data);

            foreach ($acupunctureList as $row => $acupuncture) {
                $json[] = array(
                    'acupuncture_id' => $acupuncture['acupuncture_id'],
                    'name' => $acupuncture['name'],
                    'code' => $acupuncture['code'],
                    'pinyin' => $acupuncture['pinyin']
                );
            }
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>