<?php

class ControllerPosSettings extends Controller {

    public function index() {

        $this->load->model('pos/pos');
        $this->language->load('pos/pos');
        $this->language->load('pos/setting');

        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('user/user_group');

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST')) {
            $this->model_setting_setting->editSetting('config_pos', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('pos/settings', 'user_token=' . $this->session->data['user_token'], true));
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $data['action'] = $this->url->link('pos/settings', 'user_token=' . $this->session->data['user_token'], true);

        $this->load->model('setting/store');
        $data['stores'] = $this->model_setting_store->getStores();
        $data['config_name'] = $this->config->get('config_name');
        $data['user_groups'] = $this->model_user_user_group->getUserGroups();

        if (isset($this->request->post['config_pos_user_group_id'])) {
            $data['config_pos_user_group_id'] = $this->request->post['config_pos_user_group_id'];
        } else {
            $data['config_pos_user_group_id'] = $this->config->get('config_pos_user_group_id');
        }

        if (isset($this->request->post['config_pos_printer'])) {
            $data['config_pos_printer'] = $this->request->post['config_pos_printer'];
        } else {
            $data['config_pos_printer'] = $this->config->get('config_pos_printer');
        }

        if (isset($this->request->post['config_pos_show_store_name'])) {
            $data['config_pos_show_store_name'] = $this->request->post['config_pos_show_store_name'];
        } else {
            $data['config_pos_show_store_name'] = $this->config->get('config_pos_show_store_name');
        }

        if (isset($this->request->post['pos_default_store'])) {
            $data['pos_default_store'] = $this->request->post['pos_default_store'];
        } else {
            $data['pos_default_store'] = $this->config->get('pos_default_store');
        }

        if (isset($this->request->post['config_pos_show_tin_no'])) {
            $data['config_pos_show_tin_no'] = $this->request->post['config_pos_show_tin_no'];
        } else {
            $data['config_pos_show_tin_no'] = $this->config->get('config_pos_show_tin_no');
        }

        if (isset($this->request->post['config_pos_show_telephone'])) {
            $data['config_pos_show_telephone'] = $this->request->post['config_pos_show_telephone'];
        } else {
            $data['config_pos_show_telephone'] = $this->config->get('config_pos_show_telephone');
        }

        if (isset($this->request->post['config_pos_show_address'])) {
            $data['config_pos_show_address'] = $this->request->post['config_pos_show_address'];
        } else {
            $data['config_pos_show_address'] = $this->config->get('config_pos_show_address');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['footer'] = $this->load->controller('common/footer');
        $data['column_left'] = $this->load->controller('common/column_left');

        $this->response->setOutput($this->load->view('pos/setting', $data));
    }

}

?>