<?php

class ControllerPosPos extends Controller {

    private $error = array();

    public function index() {



        $this->load->language('customer/customer');
        $this->load->language('pos/pos');

        $this->load->model('setting/setting');
        $this->load->model('pos/pos');
        $data['customer_id'] = 0;
        $data['customer_ic'] = '';
        if (!empty($this->request->get['customer_id'])) {
            $customer = $this->model_pos_pos->getCustomer($this->request->get['customer_id']);
            if (!empty($customer)) {
                $data['customer_id'] = $customer['customer_id'];
                $data['customer_ic'] = $customer['customer_ic'];
            }
        }

        $this->load->model('tool/image');

        //remove cart products
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->cart->clear();

        //set store id
        $data['store_id'] = $this->getStoreId();
        $this->session->data['store_id'] = $data['store_id'];
        $this->model_pos_pos->loadConfig(); //load pos configuration
        $this->currency->set($this->config->get('config_currency'));

        $data['default_store'] = $this->config->get('default_store');
        $data['show_store'] = $this->config->get('config_pos_show_store_name');
        $data['show_tin'] = $this->config->get('config_pos_show_tin_no');
        $data['show_address'] = $this->config->get('config_pos_show_address');
        $data['show_telephone'] = $this->config->get('config_pos_show_telephone');
        $data['store_name'] = $this->config->get('config_name');
        $data['config_address'] = $this->config->get('config_address');
        $data['nl2br_config_address'] = nl2br($data['config_address']);
        $data['config_telephone'] = $this->config->get('config_telephone');
        //$data['tin'] = $this->config->get('config_pos_tin_no');
        $data['tin'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $data['store_id']));
        $data['dashboard'] = $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true);
        unset($this->session->data['voucher']);
        unset($this->session->data['coupon']);
        unset($this->session->data['discount_amount']);
        unset($this->session->data['shipping_methods']);
        unset($this->session->data['shipping_address']);

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->language->load('pos/pos');

        $this->document->setTitle($this->language->get('heading_title'));

        $data['user'] = $this->user->getUserName();

        $default_country_id = $this->config->get('config_country_id');
        $default_zone_id = $this->config->get('config_zone_id');

        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $data['user_token'] = $this->session->data['user_token'];
        $data['text_select'] = 'Select';
        $data['button_upload'] = 'Upload';
        $data['name'] = $this->config->get('config_name');
        $data['pos_tin_no'] = $this->config->get('pos_tin_no');
        $data['pos_show_store_name'] = $this->config->get('pos_show_store_name');
        $data['pos_show_tin_no'] = $this->config->get('pos_show_tin_no');
        $data['default_amount'] = $this->currency->format('0.00', $this->config->get('config_currency'));
        $data['dicount_status'] = $this->config->get('discount_status');

        $data['logged'] = $this->language->get('text_hello') . ', ' . $this->user->getUserName() . '!';

        //language


        $data['customer_id'] = 0;
        $data['name'] = $this->language->get('walk_in_customer');
        $data['expire_date'] = date('Y-m-d');



        //get categories
        $categories = $this->model_pos_pos->getTopCategories();

        $data['categories'] = array();

        foreach ($categories as $category_info) {
            $data['categories'][] = array(
                'category_id' => $category_info['category_id'],
                'image' => $category_info['image'] ? $this->model_tool_image->resize($category_info['image'], 70, 70) : 'view/image/pos/logo.png',
                'name' => $category_info['name'],
            );
        }

        $balance = $this->model_pos_pos->get_user_balance($this->user->getId());
        $data['cash'] = $this->currency->format($balance['cash'], $this->config->get('config_currency'));
        $data['card'] = $this->currency->format($balance['card'], $this->config->get('config_currency'));
        $data['hold_carts'] = $this->model_pos_pos->get_hold_cart_list();
        $data['total_hold_cart'] = count($data['hold_carts']);

        //shipping
        unset($this->session->data['shipping_addres_id']);
        $this->session->data['shipping_addres_id'] = 0;

        $this->load->model('setting/store');
        $data['stores'] = $this->model_setting_store->getStores();

        $color_array = array('bg-lightBlue', 'bg-darkViolet', 'bg-darkCyan', 'bg-violet', 'bg-indigo', 'bg-magenta');
        $data['color_length'] = sizeof($color_array);

        $data['time'] = time();

        //load template

        $this->response->setOutput($this->load->view('pos/index', $data));
    }

    public function saveInvoice() {
        $this->session->data['invoice_html'] = $this->request->post['html'];
    }

    public function confirm() {

        unset($this->session->data['shipping_method']);

        $this->load->language('pos/pos');



        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);

        //shipping
        $this->load->model('customer/customer');

        $shipping = $this->model_customer_customer->getAddress($this->addShipping());

        $data['shipping_methods'] = array();
        if ($shipping) {
            $method_data = array();
            $this->load->model('extension/extension');
            $results = $this->model_extension_extension->getExtensions('shipping');
            $loop = 1;
            foreach ($results as $result) {
                if ($this->config->get('shipping_' . $result['code'] . '_status')) {
                    $this->load->model('shipping/' . $result['code']);

                    $quote = $this->{'model_shipping_' . $result['code']}->getQuote($shipping);
                    if ($quote) {
                        $method_data[$result['code']] = array(
                            'title' => $quote['title'],
                            'quote' => $quote['quote'],
                            'sort_order' => $quote['sort_order'],
                            'error' => $quote['error']
                        );
                    }
                }
            }

            $sort_order = array();


            foreach ($method_data as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $method_data);

            $this->session->data['shipping_methods'] = $method_data;
            $data['shipping_methods'] = $method_data;
            $loop = 1;
            foreach ($data['shipping_methods'] as $shipping_method) {

                if ($loop == 1) {
                    foreach ($shipping_method['quote'] as $quote) {
                        $shipping_data = explode('.', $quote['code']);
                    }
                }
                $loop ++;
            }
            $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
        }



        //list payment methods available
        $payment_address['country_id'] = $this->config->get('config_country_id');
        $payment_address['zone_id'] = $this->config->get('config_zone_id');

        // Totals
        $this->load->model('pos/extension');


        $totals = array();
        $total = 0;
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $points = $this->cart->getpoints();
        $reward = $this->cart->getreward();
        $results = $this->db->query("SELECT * FROM " . DB_PREFIX . "extension WHERE `type` = 'payment'")->rows;
        $cart_has_recurring = $this->cart->hasRecurringProducts();
        $method_data = [];
        foreach ($results as $result) {
            if ($this->config->get($result['code'] . '_status')) {
                $this->load->language('extension/payment/' . $result['code']); //load catalog language
                $this->load->model('extension/payment/' . $result['code']); //load catalog model
                $method = $this->{'model_extension_payment_' . $result['code']}->getMethod($payment_address, $total);
                if ($method) {
                    if ($cart_has_recurring > 0) {
                        if (method_exists($this->{'model_extension_payment_' . $result['code']}, 'recurringPayments')) {
                            if ($this->{'model_extension_payment_' . $result['code']}->recurringPayments() == true) {
                                $method_data[$result['code']] = $method;
                            }
                        }
                    } else {
                        $method_data[$result['code']] = $method;
                    }
                }
            }
        }
        $sort_order = array();

        foreach ($method_data as $key => $value) {
            $sort_order[$key] = $value['sort_order'];
        }
        array_multisort($sort_order, SORT_ASC, $method_data);

        $data['total_data'] = $totals;
        $data['total'] = round($total, 2);
        $data['points'] = $points;
        $data['reward'] = $reward;
        $data['payment_methods'] = $method_data;



        $data['shipp_price'] = 0;
        $data['user_token'] = $this->session->data['user_token'];

        //load template
        $this->response->setOutput($this->load->view('pos/confirm', $data));
    }

    public function updateConfirm() {

        unset($this->session->data['shipping_method']);

        $this->load->language('pos/pos');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax');
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);

        //shipping
        $this->load->model('customer/customer');
        $this->load->model('pos/pos');
        if (!isset($this->session->data['shipping_addres_id'])) {
            $this->session->data['shipping_addres_id'] = $this->model_pos_pos->getShippingId($this->request->get['order_id']);
        }

        $shipping = $this->model_customer_customer->getAddress($this->addShipping());


        $data['shipping_methods'] = array();
        $data['shipping'] = $this->model_pos_pos->getShippingMethod($this->request->get['order_id']);
        if ($shipping) {
            $method_data = array();
            $this->load->model('extension/extension');
            $results = $this->model_extension_extension->getExtensions('shipping');
            foreach ($results as $result) {
                if ($this->config->get($result['code'] . '_status')) {
                    $this->load->model('shipping/' . $result['code']);

                    $quote = $this->{'model_shipping_' . $result['code']}->getQuote($shipping);
                    if ($quote) {
                        $method_data[$result['code']] = array(
                            'title' => $quote['title'],
                            'quote' => $quote['quote'],
                            'sort_order' => $quote['sort_order'],
                            'error' => $quote['error']
                        );
                    }
                }
            }
            $sort_order = array();

            foreach ($method_data as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $method_data);

            $this->session->data['shipping_methods'] = $method_data;
            $data['shipping_methods'] = $method_data;
            if (!empty($data['shipping'])) {
                $shipping_data = explode('.', $data['shipping']);
                $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
            } else {

                $loop = 1;
                foreach ($data['shipping_methods'] as $shipping_method) {

                    if ($loop == 1) {
                        foreach ($shipping_method['quote'] as $quote) {
                            $shipping_data = explode('.', $quote['code']);
                        }
                    }
                    $loop ++;
                }
                $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];
            }
        }

        //list payment methods available
        $payment_address['country_id'] = $this->config->get('config_country_id');
        $payment_address['zone_id'] = $this->config->get('config_zone_id');

        //Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );


        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);


            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $total = $total;
        $points = $this->cart->getpoints();
        $reward = $this->cart->getreward();
        $results = $this->db->query("SELECT * FROM " . DB_PREFIX . "extension WHERE `type` = 'payment'")->rows;
        $cart_has_recurring = $this->cart->hasRecurringProducts();
        $method_data = array();

        foreach ($results as $result) {
            if ($this->config->get($result['code'] . '_status')) {
                $this->load->language('extension/payment/' . $result['code']); //load catalog language
                $this->load->model('extension/payment/' . $result['code']); //load catalog model
                $method = $this->{'model_extension_payment_' . $result['code']}->getMethod($payment_address, $total);
                if ($method) {
                    if ($cart_has_recurring > 0) {
                        if (method_exists($this->{'model_extension_payment_' . $result['code']}, 'recurringPayments')) {
                            if ($this->{'model_extension_payment_' . $result['code']}->recurringPayments() == true) {
                                $method_data[$result['code']] = $method;
                            }
                        }
                    } else {
                        $method_data[$result['code']] = $method;
                    }
                }
            }
        }
        $sort_order = array();

        foreach ($method_data as $key => $value) {
            $sort_order[$key] = $value['sort_order'];
        }
        array_multisort($sort_order, SORT_ASC, $method_data);



        $data['total'] = round($total, 2);
        $data['points'] = $points;
        $data['total_data'] = $totals;
        $data['reward'] = $reward;
        $data['payment_methods'] = $method_data;



        $data['shipp_price'] = 0;
        $data['user_token'] = $this->session->data['user_token'];
        $data['payment'] = $this->model_pos_pos->getPayment($this->request->get['order_id']);

        //load template
        $this->response->setOutput($this->load->view('pos/update_confirm', $data));
    }

    public function product() {

        $this->language->load('pos/product');
        $this->load->model('setting/setting');
        $this->load->model('pos/pos');
        $this->load->model('tool/image');

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $product_id = $this->request->get['product_id'];
        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $product_info = $this->model_pos_pos->getProduct($product_id);

        if ($product_info) {

            $data['heading_title'] = $product_info['name'];

            $this->load->model('catalog/review');

            $data['tab_description'] = $this->language->get('tab_description');
            $data['product_id'] = $this->request->get['product_id'];
            $data['model'] = $product_info['model'];

            if ($product_info['quantity'] <= 0) {
                $data['stock'] = $product_info['stock_status'];
            } elseif ($this->config->get('config_stock_display')) {
                $data['stock'] = $product_info['quantity'];
            } else {
                $data['stock'] = $this->language->get('text_instock');
            }

            $this->load->model('tool/image');

            if ($product_info['image']) {
                $data['thumb'] = $this->model_tool_image->resize($product_info['image'], $this->config->get('config_image_thumb_width'), $this->config->get('config_image_thumb_height'));
            } else {
                $data['thumb'] = '';
            }

            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $data['price'] = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));
            } else {
                $data['price'] = false;
            }

            if ((float) $product_info['special']) {
                $data['special'] = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->config->get('config_currency'));
            } else {
                $data['special'] = false;
            }

            if ($this->config->get('config_tax')) {
                $data['tax'] = $this->currency->format((float) $product_info['special'] ? $product_info['special'] : $product_info['price'], $this->config->get('config_currency'));
            } else {
                $data['tax'] = false;
            }

            $data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');

            //load template
            $this->response->setOutput($this->load->view('pos/product', $data));
        }
    }

    public function get_total() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        // Totals   
        $this->load->model('pos/extension');

        $totals = array();
        $total = 0;
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }


        echo $this->currency->format($total, $this->config->get('config_currency'));
    }

    public function discount() {

        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->session->data['discount_amount'] = $this->request->post['discount_amount'];
        $this->session->data['discount_type'] = $this->request->post['discount_type'];

        // Totals;

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $total_data = $this->totalData();
        }

        $json['total_data'] = $totals;

        $this->response->setOutput(json_encode($json));
    }

    public function clearCart() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('catalog/product');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->cart->clear();

        echo 'success: cart destroyed!';
    }

    public function removeFromCart() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('catalog/product');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->cart->remove($this->request->post['remove']);


        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $total_data = $this->totalData();
        }

        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        echo json_encode($json);
    }

    public function removeServiceFromCart() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('catalog/product');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->cart->removeService($this->request->post['remove']);

        // Totals
        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {

            $total_data = $this->totalData();
        }

        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        echo json_encode($json);
    }

    public function removeBrewingFromCart() {
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //
        $this->load->model('catalog/product');
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $this->cart->removeBrewing($this->request->post['remove']);
        //Total
        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();
        //Displat prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $total_data = $this->totalData();
        }
        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        echo json_encode($json);
    }

    public function removeBrewingOrderFromCart() {
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //
        $this->load->model('catalog/product');
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $this->cart->removeBrewingOrder($this->request->post['remove']);
        //Total
        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();
        //Displat prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $total_data = $this->totalData();
        }
        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        echo json_encode($json);
    }

    public function removeHerbalFromCart() {

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->model('catalog/product');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->cart->removeHerbal($this->request->post['remove']);

        // Totals

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {

            $total_data = $this->totalData();
        }

        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        echo json_encode($json);
    }

    public function addToCart() {
        $this->load->language('pos/pos');

        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->load->model('catalog/product');

        if (isset($this->request->post['product_id'])) {
            $product_id = $this->request->post['product_id'];
        } else {
            $product_id = 0;
        }

        // Totals
        $total = 0;
        $totals = array();
        $total_data = array(
            'totals' => &$totals,
            'total' => &$total
        );
        $product_info = $this->model_catalog_product->getProduct($product_id);
        if ($product_info) {

            if (isset($this->request->post['quantity'])) {
                $quantity = $this->request->post['quantity'];
            } else {
                $quantity = 1;
            }

            if (isset($this->request->post['option'])) {
                $option = array_filter($this->request->post['option']);
            } else {
                $option = array();
            }

            $product_options = $this->model_catalog_product->getProductOptions($this->request->post['product_id']);

            foreach ($product_options as $product_option) {
                if ($product_option['required'] && empty($option[$product_option['product_option_id']])) {
                    $json['error']['option'][$product_option['product_option_id']] = sprintf('%s field required', $product_option['name']);
                }
            }

            if (!$json) {
                if ($this->cart->checkStock($this->request->post['product_id'], $quantity)) {
                    $key = $this->cart->add($this->request->post['product_id'], $quantity, $option);
                } else {
                    $error[] = $this->language->get('error_product_not_available_continue');
                    $json['error'] = $error;
                }

                //validate
                $err_validation = $this->validateCart();
                if (!empty($err_validation)) {
                    //$qty_bkp = $this->session->data['cart'][$key];
                    $json['error'] = $err_validation;
                    $json['status'] = 0;
                    //$this->session->data['cart'][$key] = (float) $qty_bkp - 1;
                } else {
                    $json['success'] = 1;
                    $json['status'] = 1;
                }
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total_data = $this->totalData();
            }

            $json['total_data'] = $total_data;
            $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        }

        //html for cart
        $json['products'] = array();

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type']
                );
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($product['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }

            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($sub_tax['total'] * $product['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $tax = $this->currency->format($sub_tax['tax'] * $product['quantity'], $this->config->get('config_currency'));

            $json['products'][] = array(
                'key' => $product['key'],
                'name' => $product['name'],
                'code' => $product['code'],
                'model' => $product['model'],
                'unitprice' => $product['unitprice'],
                'reward' => $product['reward'],
                'points' => $product['points'],
                'option' => $option_data,
                'quantity' => $product['quantity'],
                'price' => $price,
                'tax' => $tax,
                'total' => $total,
                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
            );
        }

//        print_r($json['products']);
        $this->response->setOutput(json_encode($json));
    }

    public function getProductByCode() {

        if ($this->request->post['product_code']) {
            $product_code = $this->request->post['product_code'];
        } else {
            $product_code = false;
        }

        if ($this->request->post['product_qty']) {
            $quantity = $this->request->post['product_qty'];
        } else {
            $quantity = 1;
        }

        $this->load->model('pos/pos');

        $product = $this->model_pos_pos->getProductByCode($product_code);
        if (!empty($product[0]['product_id'])) {
            $json['success'] = 1;
            $json['product_id'] = $product[0]['product_id'];
            $json['has_option'] = $product[0]['options'] ? '1' : '0';
            $json['quantity'] = $quantity;
        } else {
            $json['error'] = array(
                'Products Code (' . $product_code . ')  is not available in the desired quantity or not in stock!');
        }

        $this->response->setOutput(json_encode($json));
    }

    function validateCart() {
        $this->load->language('pos/pos');

        $error = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $products = $this->cart->getProducts();

        foreach ($products as $key => $product) {
            if (!$product['stock']) {
                $error[] = $this->language->get('error_product_not_available') . ' (' . $product['name'] . ') ' . $this->language->get('error_product_not_available_continue');
            }

            if ($product['quantity'] == 0) {
                $this->cart->remove($key);
            }
        }
        if ($error)
            return $error;
        else
            return false;
    }

    public function updateCart() {

        $qty = $this->request->post['quantity'];
        $key = $this->request->post['key'];
        $qty_bkp = $this->session->data['cart'][$key]; //backup for restore if error in cart
        $this->session->data['cart'][$key] = (float) $qty;

        //validate
        $err_validation = $this->validateCart();

        if (!empty($err_validation)) {
            $json['error'] = $err_validation;
            $json['status'] = 0;
            $this->session->data['cart'][$key] = (float) $qty_bkp; //revert qty update
        } else {
            $json['success'] = 1;
            $json['status'] = 1;
        }

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);



        $total_data = array();
        $total = 0;

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $total_data = $this->totalData();
        }

        $json['total_data'] = $total_data;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));

        //html for cart
        $json['products'] = array();

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type']
                );
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($product['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }

            // Display prices
            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($sub_tax['total'] * $product['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $tax = $this->currency->format($sub_tax['tax'] * $product['quantity'], $this->config->get('config_currency'));

            $json['products'][] = array(
                'key' => $product['key'],
                'name' => $product['name'],
                'code' => $product['code'],
                'model' => $product['model'],
                'unitprice' => $product['unitprice'],
                'reward' => $product['reward'],
                'points' => $product['points'],
                'option' => $option_data,
                'quantity' => $product['quantity'],
                'price' => $price,
                'total' => $total,
                'tax' => $tax,
                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
            );
        }

        $this->response->setOutput(json_encode($json));
    }

    public function install() {
        /*
          if (!$this->checkVqmod()) {
          // not existing
          $this->language->load('pos/pos');
          $this->session->data['error'] = $this->language->get('text_vqmod_not_installed');
          $this->load->model('setting/extension');
          // remove from the extension table
          $this->model_setting_extension->uninstall('module', 'pos');
          return false;
          }
         */

        // create tables
        $this->load->model('pos/pos');
        // add default settings
        $this->load->model('setting/setting');
        // create vqmod files
        $this->createFile();

        // copy language file is English not set to default
        //$this->copyLangFile();
        //$this->model_setting_setting->editSetting('POS', array('pos_user_group_id' => 'Credit Card'));
        // add permission for report
        $this->load->model('user/user_group');
        $this->model_user_user_group->addPermission($this->user->getId(), 'access', 'pos/pos');
        $this->model_user_user_group->addPermission($this->user->getId(), 'modify', 'pos/pos');
    }

    public function uninstall() {
        // $this->load->model('pos/pos');
        // $this->model_pos_pos->deleteModuleTables();

        $this->load->model('setting/setting');

        // remove the files
        $this->deleteFile();


        // $this->model_setting_setting->deleteSetting('POS');
    }

    private function checkVqmod() {
        return file_exists(DIR_APPLICATION . '/../vqmod');
    }

    private function createFile() {
        $path = dirname(DIR_APPLICATION);
        rename($path . '/pos_', $path . '/pos');

        //set module status = 1
        $this->model_setting_setting->editSetting('pos', array('pos_user_group_id' => 1, 'pos_status' => 1));

        //rename(DIR_APPLICATION.'../admin/controller/pos/pos.php_',DIR_APPLICATION.'../admin/controller/pos/pos.php');
        unlink(DIR_APPLICATION . '../vqmod/mods.cache');
        rename(DIR_APPLICATION . '../vqmod/xml/pos.xml_', DIR_APPLICATION . '../vqmod/xml/pos.xml');
    }

    private function deleteFile() {
        //set module status = 0
        $this->model_setting_setting->editSetting('pos', array('pos_user_group_id' => 1, 'pos_status' => 0));

        //rename(DIR_APPLICATION.'../admin/controller/pos/pos.php',DIR_APPLICATION.'../admin/controller/pos/pos.php_');
        rename(DIR_APPLICATION . '../vqmod/xml/pos.xml', DIR_APPLICATION . '../vqmod/xml/pos.xml_');

        $path = dirname(DIR_APPLICATION);
        rename($path . '/pos', $path . '/pos_');
        //unlink(DIR_APPLICATION . '../vqmod/xml/pos.xml');
    }

    private function getStoreId() {

        /* $pos_default_store = $this->config->get('pos_default_store');

          if (isset($this->request->get['store_id'])) {
          $store_id = $this->request->get['store_id'];
          } else if(isset($pos_default_store)){
          $store_id = $pos_default_store;
          } else {
          $store_id = 0;
          // get the default store id
          $this->load->model('setting/store');
          $stores = $this->model_setting_store->getStores();
          if (!empty($stores)) {
          $store_id = $stores[0]['store_id'];
          }
          } */
        return $this->session->data['store_id'];
    }

    public function searchProducts() {

        $this->load->model('pos/pos');

        if (isset($this->request->post['q'])) {
            $q = $this->request->post['q'];
        } else {
            $q = '';
        }

        if (isset($this->request->post['page'])) {
            $page = $this->request->post['page'];
        } else {
            $page = 1;
        }

        $limit = 20;
        $offset = ($page - 1) * $limit;
        $total = $this->model_pos_pos->total_search_products($q);

        $products = $this->model_pos_pos->searchProducts($q, $limit, $offset);

        //check if last page
        $total_pages = ceil($total / $limit);
        if ($total_pages > $page) {
            $json['has_more'] = 1;
        }

        $json['products'] = array();
        foreach ($products as $product) {
            $json['products'][] = array('type' => 'P',
                'name' => $product['name'],
                'image' => !empty($product['image']) ? '../image/' . $product['image'] : '../image/no_image.jpg',
                'price_text' => $this->currency->format($product['price'], $this->config->get('config_currency')), //, $currency_code, $currency_value
                //'stock_text' => $product['quantity'], // . ' ' . $this->language->get('text_remaining'),
                'hasOptions' => $product['options'] ? '1' : '0',
                'id' => $product['product_id']
            );
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function getCategoryItems() {
        $json['categories'] = $json['products'] = array();
        $parent_category_id = $this->request->post['category_id'];
        // get the direct sub-category and product in the given category
        $this->load->model('pos/pos');
        $sub_categories = $this->model_pos_pos->getSubCategories($parent_category_id);

        if (isset($this->request->post['page'])) {
            $page = $this->request->post['page'];
        } else {
            $page = 1;
        }

        $limit = 20;
        $offset = ($page - 1) * $limit;
        $total = $this->model_pos_pos->total_products($parent_category_id);

        if ($page == 1) {
            foreach ($sub_categories as $sub_category) {
                $json['categories'][] = array('type' => 'C',
                    'name' => $sub_category['name'],
                    'image' => !empty($sub_category['image']) ? '../image/' . $sub_category['image'] : '../image/no_image.jpg',
                    'id' => $sub_category['category_id']
                );
            }
            //$category_offset = sizeof($json['categories']);
            //$offset += $category_offset;
            //$limit  -= $category_offset;
        }

        //check if last page
        if (($offset + $limit) < $total) {
            $json['has_more'] = 1;
        }

        $products = $this->model_pos_pos->getProducts($parent_category_id, $limit, $offset);

        $this->language->load('pos/pos');

        foreach ($products as $product) {
            $json['products'][] = array('type' => 'P',
                'name' => $product['name'],
                'image' => !empty($product['image']) ? '../image/' . $product['image'] : '../image/no_image.jpg',
                'price_text' => $this->currency->format($product['price'], $this->config->get('config_currency')), //, $currency_code, $currency_value
                'stock_text' => $product['quantity'], // . ' ' . $this->language->get('text_remaining'),
                'hasOptions' => $product['options'] ? '1' : '0',
                'id' => $product['product_id']
            );
        }

        return $this->response->setOutput(json_encode($json));
    }

    public function getProductOptions() {
        $json = array();
        $option_data = array();

        $this->load->model('catalog/product');
        $this->load->model('catalog/option');
        $product_options = $this->model_catalog_product->getProductOptions($this->request->post['product_id']);

        foreach ($product_options as $product_option) {
            $option_info = $this->model_catalog_option->getOption($product_option['option_id']);

            if ($option_info) {
                if ($option_info['type'] == 'select' || $option_info['type'] == 'radio' || $option_info['type'] == 'checkbox' || $option_info['type'] == 'image') {
                    $option_value_data = array();

                    foreach ($product_option['product_option_value'] as $product_option_value) {
                        $option_value_info = $this->model_catalog_option->getOptionValue($product_option_value['option_value_id']);

                        if ($option_value_info) {
                            $option_value_data[] = array(
                                'product_option_value_id' => $product_option_value['product_option_value_id'],
                                'option_value_id' => $product_option_value['option_value_id'],
                                'name' => $option_value_info['name'],
                                'price' => (float) $product_option_value['price'] ? $this->currency->format($product_option_value['price'], $this->config->get('config_currency')) : false,
                                'price_prefix' => $product_option_value['price_prefix']
                            );
                        }
                    }

                    $option_data[] = array(
                        'product_option_id' => $product_option['product_option_id'],
                        'option_id' => $product_option['option_id'],
                        'name' => $option_info['name'],
                        'type' => $option_info['type'],
                        'option_value' => $option_value_data,
                        'required' => $product_option['required']
                    );
                } else {
                    $option_data[] = array(
                        'product_option_id' => $product_option['product_option_id'],
                        'option_id' => $product_option['option_id'],
                        'name' => $option_info['name'],
                        'type' => $option_info['type'],
                        'option_value' => $product_option['value'],
                        'required' => $product_option['required']
                    );
                }
            }
        }

        $json['option_data'] = $option_data;
        $this->response->setOutput(json_encode($json));
    }

    public function addOrder() {

        //get product list
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->load->language('pos/pos');

        $data = array();
        $errors = '';
        $pg_type = $this->request->post['pg_type'];

        $payment_method = $this->request->post['payment_method'];
        $payment_name = $this->request->post['payment_name'];
        $customer_id = $this->request->post['customer_id'];
        $shipping_id = $this->request->post['shipping_addres_id'];

        $credit = $this->request->post['customer_credit'];
        $points = $this->request->post['customer_points'];
        $buy_points = $this->request->post['points'];
        $card_no = $this->request->post['card_no'];
        $paid = $this->request->post['paid'];
        $pay_total = $this->request->post['pay_total'];
        $data['comment'] = $this->request->post['comment'];

        if ($customer_id == 0) {
            $is_guest = true;
        } else {
            $is_guest = false;
        }

        if ($pay_total <= 0) {
            $errors .= $this->language->get('error_empty_cart') . '<br/>';
        }

        if (($payment_name == 'Card') && $card_no == '') {
            $errors .= $this->language->get('error_card') . '<br/>';
        }

        if (($payment_name == 'Credit') && $customer_id == 0) {
            $errors .= $this->language->get('error_customer') . '<br/>';
        }

        if (($payment_name == 'Points') && $customer_id == 0) {
            $errors .= $this->language->get('error_customer') . '<br/>';
        }

        if (($payment_method == 'Points') && $customer_id != 0 && empty($points)) {
            $errors .= $this->language->get('error_password') . '<br/>';
        }

        if (($payment_name == 'Points') && ($buy_points <= 0) && !empty($points)) {
            $errors .= $this->language->get('error_product_points') . '<br/>';
        }

        if (($payment_method == 'Credit') && $customer_id != 0 && empty($credit)) {
            $errors .= $this->language->get('error_password') . '<br/>';
        }


        if ($this->request->post['order_status_id'] == 5) {

            if (($payment_name == 'Points') && $points < $buy_points && !empty($points)) {
                $errors .= $this->language->get('error_points') . '<br/>';
            }

            if (($payment_name == 'Credit') && $credit < $paid && !empty($credit)) {
                $errors .= $this->language->get('error_credit') . '<br/>';
            }

            if (($payment_name == 'Cash') && $paid < $pay_total) {
                $errors .= $this->language->get('error_paymnet') . '<br/>';
            }

            if (($payment_name == 'Card') && $paid < $pay_total) {
                $errors .= $this->language->get('error_paymnet') . '<br/>';
            }
        }

        if ($errors != '') {
            $data['errors'] = $errors;
            $this->response->setOutput(json_encode($data));
            return;
        }

        $this->load->model('pos/pos');
        $this->load->model('customer/customer');

        $data['store_id'] = $this->getStoreId();

        $default_country_id = $this->config->get('config_country_id');
        $default_zone_id = $this->config->get('config_zone_id');


        $data['shipping_country_id'] = $default_country_id;
        $data['shipping_zone_id'] = $default_zone_id;
        $data['payment_country_id'] = $default_country_id;
        $data['payment_zone_id'] = $default_zone_id;
        $data['customer_id'] = 0;
        $data['customer_group_id'] = 1;
        $data['firstname'] = 'Walkin';
        $data['lastname'] = "Customer";
        $data['email'] = '';
        $data['telephone'] = '';
        $data['fax'] = '';

        $data['payment_firstname'] = 'Walkin';
        $data['payment_lastname'] = "Customer";
        $data['payment_company'] = '';
        $data['payment_company_id'] = '';
        $data['payment_tax_id'] = '';
        $data['payment_address_1'] = '';
        $data['payment_address_2'] = '';
        $data['payment_address_3'] = '';
        $data['payment_city'] = '';
        $data['payment_postcode'] = '';
        $data['payment_country_id'] = '';
        $data['payment_zone_id'] = '';
        $data['payment_method'] = $payment_method;
        $data['payment_name'] = $payment_name;
        $data['payment_code'] = 'in_store';



        $data['reward'] = $this->cart->getreward();
        if ($shipping_id != 0) {
            $shipping = $this->model_customer_customer->getAddress($shipping_id);
            $shipping_method = explode('.', $this->request->post['shipping_method']);
            $data['shipping_address_id'] = $shipping['address_id'];
            $data['shipping_firstname'] = $shipping['firstname'];
            $data['shipping_lastname'] = $shipping['lastname'];
            $data['shipping_company'] = $shipping['company'];
            $data['shipping_address_1'] = $shipping['address_1'];
            $data['shipping_address_2'] = $shipping['address_2'];
            $data['shipping_address_3'] = $shipping['address_3'];
            $data['shipping_city'] = $shipping['city'];
            $data['shipping_postcode'] = $shipping['postcode'];
            $data['shipping_country_id'] = $shipping['country_id'];
            $data['shipping_zone_id'] = $shipping['zone_id'];
            $data['shipping'] = $this->session->data['shipping_methods'][$shipping_method[0]];
            $data['shipping_method'] = $data['shipping']['quote'][$shipping_method[1]]['title'];
            $data['shipping_code'] = $this->request->post['shipping_method'];
            $data['shipping_total'] = $data['shipping']['quote'][$shipping_method[1]]['total'];
            $data['shipping_detail'] = array(
                'title' => $data['shipping']['title'],
                'code' => $this->request->post['shipping_method'],
                'cost' => $data['shipping']['quote'][$shipping_method[1]]['cost'],
                'tax_class_id' => $data['shipping']['quote'][$shipping_method[1]]['tax_class_id'],
                'tax' => $data['shipping']['quote'][$shipping_method[1]]['total'] - $data['shipping']['quote'][$shipping_method[1]]['cost'],
                'total' => $data['shipping']['quote'][$shipping_method[1]]['total'],
            );
        } else {
            $data['shipping_address_id'] = 0;
            $data['shipping_firstname'] = '';
            $data['shipping_lastname'] = '';
            $data['shipping_company'] = '';
            $data['shipping_address_1'] = '';
            $data['shipping_address_2'] = '';
            $data['shipping_address_3'] = '';
            $data['shipping_city'] = '';
            $data['shipping_postcode'] = '';
            $data['shipping_country_id'] = '';
            $data['shipping_zone_id'] = '';
            $data['shipping_method'] = 'Pickup From Store';
            $data['shipping_code'] = 'pickup.pickup';
            $data['shipping_total'] = 0;
            $data['shipping_detail'] = array();
        }



        if ($pg_type == 'opencart') {
            $data['order_status_id'] = $this->request->post['order_status_id'];
        } else {
            //$data['order_status_id'] = $this->config->get('config_order_status_id');//pos payment options chosen
            $data['order_status_id'] = $this->request->post['order_status_id'];
        }


        $data['affiliate_id'] = 0;
        $data['card_no'] = $card_no;
        $data['user_id'] = $this->user->getId();

        //override for customer
        if ($is_guest == false) {

            $customer = $this->model_pos_pos->getCustomer($customer_id);
            $payment_address = $this->model_customer_customer->getAddress($customer['address_id']);
            $data['customer_id'] = $customer_id;
            $data['customer_group_id'] = $customer['customer_group_id'];
            $data['firstname'] = $customer['firstname'];
            $data['lastname'] = $customer['lastname'];
            $data['email'] = $customer['email'];
            $data['telephone'] = $customer['telephone'];
            $data['fax'] = $customer['fax'];

            $data['payment_firstname'] = $customer['firstname'];
            $data['payment_lastname'] = $customer['lastname'];
            $data['payment_company'] = $payment_address['company'];
            $data['payment_address_1'] = $payment_address['address_1'];
            $data['payment_address_2'] = $payment_address['address_2'];
            $data['payment_address_3'] = $payment_address['address_3'];
            $data['payment_city'] = $payment_address['city'];
            $data['payment_postcode'] = $payment_address['postcode'];
            $data['payment_zone_id'] = $payment_address['zone_id'];
            $data['payment_country_id'] = $payment_address['country_id'];
            $data['payment_method'] = $payment_method;
            $data['payment_code'] = 'in_store';
        }



        $data['order_product'] = array();

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'product_option_id' => $option['product_option_id'],
                    'product_option_value_id' => $option['product_option_value_id'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type'],
                    'name' => $option['name'],
                );
            }

            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));

            $data['order_product'][] = array(
                'product_id' => $product['product_id'],
                'name' => $product['name'],
                'model' => $product['model'],
                'quantity' => $product['quantity'],
                'weight' => $product['weight'],
                'weight_class_id' => $product['weight_class_id'],
                'usedqty' => 1,
                'price' => $product['price'],
                'total' => $sub_tax['total'] * $product['quantity'],
                'net_amount' => $sub_tax['net_amount'],
                'total_net_amount' => $sub_tax['net_amount'] * $product['quantity'],
                'tax' => $sub_tax['tax'],
                'total_tax' => $sub_tax['tax'] * $product['quantity'],
                'tax_class_id' => $product['tax_class_id'],
                'tax_format' => $sub_tax['format'],
                'tax_code' => $this->tax->getClassCode($product['tax_class_id']),
                'reward' => $product['reward'],
                'points' => $product['points'],
                'order_option' => $option_data,
            );
        }//foreach products
        //add services
        $data['order_service'] = array();

        foreach ($this->cart->getServices() as $service) {

            $data['order_service'][] = array(
                'service_id' => $service['service_id'],
                'invoice_prefix' => $service['invoice_prefix'],
            );
        }//foreach services
        //add services
        $data['order_herbals'] = array();

        foreach ($this->cart->getHerbals() as $herbals) {

            $data['order_herbals'][] = array(
                'herbal_id' => $herbals['herbal_id'],
                'invoice_prefix' => $herbals['invoice_prefix'],
            );
        }//foreach services
        //Add Brewing
        $data['order_brewing'] = array();
        /* if (!empty($this->cart->getBrewings())) {
          foreach ($this->cart->getBrewings() as $brewings) {
          $data['order_brewing'][] = array(
          'brewing_id' => $brewings['brewing_id'],
          'invoice_prefix' => $brewings['invoice_prefix'],
          );
          }
          } */

        //Add Brewing
        $data['order_brewing_order'] = array();
        /* if (!empty($this->cart->getBrewingOrders())) {
          foreach ($this->cart->getBrewingOrders() as $brewing_orders) {
          $data['order_brewing'][] = array(
          'brewing_id' => $brewing_orders['brewing_id'],
          'invoice_prefix' => $brewing_orders['invoice_prefix'],
          );
          }
          } */

        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }


        $data['order_total'] = $total_data['totals'];

        if (isset($this->session->data['voucher'])) {
            $data['order_voucher'] = $this->session->data['voucher'];
        }

        // Gift Voucher
        $data['vouchers'] = array();

        if (!empty($this->session->data['vouchers'])) {
            foreach ($this->session->data['vouchers'] as $voucher) {
                $data['vouchers'][] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $this->config->get('config_currency'))
                );
            }
        }

        if ($pg_type == 'pos') {
            if ($payment_name == 'Card') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => $paid,
                    'points' => 0,
                    'credit' => 0,
                    'total' => $paid,
                );
            } elseif ($payment_name == 'Credit') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => 0,
                    'points' => 0,
                    'credit' => $paid,
                    'total' => $paid,
                );
            } elseif ($payment_name == 'Points') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => 0,
                    'points' => $paid,
                    'credit' => 0,
                    'total' => $paid,
                );
            } else {
                $data['payment'] = array(
                    'cash' => $paid,
                    'card' => 0,
                    'points' => 0,
                    'credit' => 0,
                    'total' => $paid,
                );
            }
        } else {
            $data['payment'] = array(
                'cash' => $total,
                'card' => 0,
                'points' => 0,
                'credit' => 0,
                'total' => $paid,
            );
        }



        //end of order total

        $json['customer_name'] = $data['firstname'] . ' ' . $data['lastname'];

        $order_id = $this->model_pos_pos->addOrder($data);

        unset($this->session->data['discount_amount']);

        if ($pg_type == 'pos') {
            if ($payment_method == 'Card') {
                $cash = 0;
                $card = $total;
            } else {
                $cash = $total;
                $card = 0;
            }
            $data = array(
                'user_id' => $this->user->getId(),
                'cash' => $cash,
                'card' => $card,
            );
            $this->model_pos_pos->addPayment($data);
        } else {
            $this->session->data['order_user_id'] = $this->user->getId();
            $this->session->data['order_id'] = $order_id;
            $this->session->data['payment_method']['code'] = $payment_method;
            $json['payment_link'] = HTTP_CATALOG . 'index.php?route=pos/index';
        }

        $json['order_id'] = $order_id;
        $balance = $this->model_pos_pos->get_user_balance($this->user->getId());
        $json['cash'] = $this->currency->format($balance['cash'], $this->config->get('config_currency'));
        $json['card'] = $this->currency->format($balance['card'], $this->config->get('config_currency'));

        $json['success'] = 'Success: new order placed with ID: ' . $order_id;
        $this->cart->clear();
        unset($this->session->data['shipping_address']);
        $this->response->setOutput(json_encode($json));
    }

//END add order

    public function editOrder() {

        //get product list
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);


        $data = array();
        $errors = '';
        $pg_type = $this->request->post['pg_type'];

        $payment_method = $this->request->post['payment_method'];
        $payment_name = $this->request->post['payment_name'];
        $customer_id = $this->request->post['customer_id'];
        $shipping_id = $this->request->post['shipping_addres_id'];
        $card_no = $this->request->post['card_no'];
        $order_id = $this->request->post['order_id'];
        $data['invoice_prefix'] = $this->request->post['invoice_prefix'];
        $data['comment'] = $this->request->post['comment'];

        $credit = $this->request->post['customer_credit'];
        $points = $this->request->post['customer_points'];
        $paid = $this->request->post['paid'];
        $buy_points = $this->request->post['points'];
        $card_no = $this->request->post['card_no'];
        $pay_total = $this->request->post['pay_total'];

        if ($customer_id == 0) {
            $is_guest = true;
        } else {
            $is_guest = false;
        }

        if ($pay_total <= 0) {
            $errors .= $this->language->get('error_empty_cart') . '<br/>';
        }

        if (($payment_name == 'Card') && $card_no == '') {
            $errors .= $this->language->get('error_card') . '<br/>';
        }

        if (($payment_name == 'Credit') && $customer_id == 0) {
            $errors .= $this->language->get('error_customer') . '<br/>';
        }

        if (($payment_name == 'Points') && $customer_id == 0) {
            $errors .= $this->language->get('error_customer') . '<br/>';
        }

        if (($payment_name == 'Points') && $customer_id != 0 && empty($points)) {
            $errors .= $this->language->get('error_password') . '<br/>';
        }

        if (($payment_name == 'Points') && ($buy_points <= 0) && !empty($points)) {
            $errors .= $this->language->get('error_product_points') . '<br/>';
        }

        if (($payment_name == 'Credit') && $customer_id != 0 && empty($credit)) {
            $errors .= $this->language->get('error_password') . '<br/>';
        }

        if ($this->request->post['order_status_id'] == 5) {

            if (($payment_name == 'Points') && $points < $buy_points && !empty($points)) {
                $errors .= $this->language->get('error_points') . '<br/>';
            }

            if (($payment_name == 'Credit') && $credit < $paid && !empty($credit)) {
                $errors .= $this->language->get('error_credit') . '<br/>';
            }

            if (($payment_name == 'Cash') && $paid < $pay_total) {
                $errors .= $this->language->get('error_paymnet') . '<br/>';
            }

            if (($payment_name == 'Card') && $paid < $pay_total) {
                $errors .= $this->language->get('error_paymnet') . '<br/>';
            }
        }



        if ($errors != '') {
            $data['errors'] = $errors;
            $this->response->setOutput(json_encode($data));
            return;
        }

        $this->load->model('pos/pos');
        $this->load->model('customer/customer');

        $data['store_id'] = $this->getStoreId();

        $default_country_id = $this->config->get('config_country_id');
        $default_zone_id = $this->config->get('config_zone_id');

        $data['shipping_country_id'] = $default_country_id;
        $data['shipping_zone_id'] = $default_zone_id;
        $data['payment_country_id'] = $default_country_id;
        $data['payment_zone_id'] = $default_zone_id;
        $data['customer_id'] = 0;
        $data['customer_group_id'] = 1;
        $data['firstname'] = 'Walkin';
        $data['lastname'] = "Customer";
        $data['email'] = '';
        $data['telephone'] = '';
        $data['fax'] = '';

        $data['payment_firstname'] = 'Walkin';
        $data['payment_lastname'] = "Customer";
        $data['payment_company'] = '';
        $data['payment_company_id'] = '';
        $data['payment_tax_id'] = '';
        $data['payment_address_1'] = '';
        $data['payment_address_2'] = '';
        $data['payment_address_3'] = '';
        $data['payment_city'] = '';
        $data['payment_postcode'] = '';
        $data['payment_country_id'] = '';
        $data['payment_zone_id'] = '';
        $data['payment_method'] = $payment_method;
        $data['payment_code'] = 'in_store';

        if ($shipping_id != 0) {
            $shipping = $this->model_customer_customer->getAddress($shipping_id);
            $shipping_method = explode('.', $this->request->post['shipping_method']);
            $data['shipping_address_id'] = $shipping['address_id'];
            $data['shipping_firstname'] = $shipping['firstname'];
            $data['shipping_lastname'] = $shipping['lastname'];
            $data['shipping_company'] = $shipping['company'];
            $data['shipping_address_1'] = $shipping['address_1'];
            $data['shipping_address_2'] = $shipping['address_2'];
            $data['shipping_address_3'] = $shipping['address_3'];
            $data['shipping_city'] = $shipping['city'];
            $data['shipping_postcode'] = $shipping['postcode'];
            $data['shipping_country_id'] = $shipping['country_id'];
            $data['shipping_zone_id'] = $shipping['zone_id'];
            $data['shipping'] = $this->session->data['shipping_methods'][$shipping_method[0]];
            $data['shipping_method'] = $data['shipping']['quote'][$shipping_method[1]]['title'];
            $data['shipping_code'] = $this->request->post['shipping_method'];
            $data['shipping_total'] = $data['shipping']['quote'][$shipping_method[1]]['total'];
            $data['shipping_detail'] = array(
                'title' => $data['shipping']['title'],
                'code' => $this->request->post['shipping_method'],
                'cost' => $data['shipping']['quote'][$shipping_method[1]]['cost'],
                'tax_class_id' => $data['shipping']['quote'][$shipping_method[1]]['tax_class_id'],
                'tax' => $data['shipping']['quote'][$shipping_method[1]]['total'] - $data['shipping']['quote'][$shipping_method[1]]['cost'],
                'total' => $data['shipping']['quote'][$shipping_method[1]]['total'],
            );
        } else {
            $data['shipping_address_id'] = 0;
            $data['shipping_firstname'] = '';
            $data['shipping_lastname'] = '';
            $data['shipping_company'] = '';
            $data['shipping_address_1'] = '';
            $data['shipping_address_2'] = '';
            $data['shipping_address_3'] = '';
            $data['shipping_city'] = '';
            $data['shipping_postcode'] = '';
            $data['shipping_country_id'] = '';
            $data['shipping_zone_id'] = '';
            $data['shipping_method'] = 'Pickup From Store';
            $data['shipping_code'] = 'pickup.pickup';
            $data['shipping_total'] = 0;
            $data['shipping_detail'] = array();
        }



        $data['affiliate_id'] = 0;
        $data['card_no'] = $card_no;
        $data['user_id'] = $this->user->getId();
        $data['order_status_id'] = $this->request->post['order_status_id'];


        //override for customer
        if ($is_guest == false) {

            $customer = $this->model_pos_pos->getCustomer($customer_id);
            $payment_address = $this->model_customer_customer->getAddress($customer['address_id']);
            $data['customer_id'] = $customer_id;
            $data['customer_group_id'] = $customer['customer_group_id'];
            $data['firstname'] = $customer['firstname'];
            $data['lastname'] = $customer['lastname'];
            $data['email'] = $customer['email'];
            $data['telephone'] = $customer['telephone'];
            $data['fax'] = $customer['fax'];

            $data['payment_firstname'] = $customer['firstname'];
            $data['payment_lastname'] = $customer['lastname'];
            $data['payment_company'] = $payment_address['company'];
            $data['payment_address_1'] = $payment_address['address_1'];
            $data['payment_address_2'] = $payment_address['address_2'];
            $data['payment_address_3'] = $payment_address['address_3'];
            $data['payment_city'] = $payment_address['city'];
            $data['payment_postcode'] = $payment_address['postcode'];
            $data['payment_zone_id'] = $payment_address['zone_id'];
            $data['payment_country_id'] = $payment_address['country_id'];
            $data['payment_method'] = $payment_method;
            $data['payment_code'] = 'in_store';
        }


        $data['payment_name'] = $payment_name;
        $data['order_product'] = array();

        $data['reward'] = $this->cart->getreward();

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'product_option_id' => $option['product_option_id'],
                    'product_option_value_id' => $option['product_option_value_id'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type'],
                    'name' => $option['name'],
                );
            }

            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));

            $data['order_product'][] = array(
                'product_id' => $product['product_id'],
                'name' => $product['name'],
                'model' => $product['model'],
                'quantity' => $product['quantity'],
                'weight' => $product['weight'],
                'weight_class_id' => $product['weight_class_id'],
                'usedqty' => 1,
                'price' => $product['price'],
                'total' => $sub_tax['total'] * $product['quantity'],
                'net_amount' => $sub_tax['net_amount'],
                'total_net_amount' => $sub_tax['net_amount'] * $product['quantity'],
                'tax' => $sub_tax['tax'],
                'total_tax' => $sub_tax['tax'] * $product['quantity'],
                'tax_class_id' => $product['tax_class_id'],
                'tax_format' => $sub_tax['format'],
                'tax_code' => $this->tax->getClassCode($product['tax_class_id']),
                'reward' => $product['reward'],
                'points' => $product['points'],
                'order_option' => $option_data,
            );
        }//foreach products
        //add services
        $data['order_service'] = array();

        foreach ($this->cart->getServices() as $service) {

            $data['order_service'][] = array(
                'service_id' => $service['service_id'],
                'invoice_prefix' => $service['invoice_prefix'],
            );
        }//foreach services
        //add herble
        $data['order_herbals'] = array();

        foreach ($this->cart->getHerbals() as $herble) {

            $data['order_herbals'][] = array(
                'herbal_id' => $herble['herbal_id'],
                'invoice_prefix' => $herble['invoice_prefix'],
            );
        }//foreach services
        //Add Brewing
        $data['order_brewing'] = array();
        foreach ($this->cart->getBrewings() as $brewings) {
            $data['order_brewing'][] = array(
                'brewing_id' => $brewings['brewing_id'],
                'invoice_prefix' => $brewings['invoice_prefix'],
            );
        }

        //Add Brewing
        $data['order_brewing_order'] = array();
        foreach ($this->cart->getBrewingOrders() as $brewing_orders) {
            $data['order_brewing_order'][] = array(
                'brewing_id' => $brewing_orders['brewing_id'],
                'invoice_prefix' => $brewing_orders['invoice_prefix'],
            );
        }

        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $data['order_total'] = $totals;

        if (isset($this->session->data['voucher'])) {
            $data['order_voucher'] = $this->session->data['voucher'];
        }

        // Gift Voucher
        $data['vouchers'] = array();

        if (!empty($this->session->data['vouchers'])) {
            foreach ($this->session->data['vouchers'] as $voucher) {
                $data['vouchers'][] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $this->config->get('config_currency'))
                );
            }
        }

        if ($pg_type == 'pos') {
            //record for counter payment
            $payment = array(
                'user_id' => $this->user->getId(),
                'total' => $total,
                'payment_method' => $payment_method
            );
            $this->model_pos_pos->editPayment($order_id, $payment);
        } else {
            $this->session->data['order_user_id'] = $data['user_id'];
            $this->session->data['order_id'] = $order_id;
            $this->session->data['payment_method']['code'] = $payment_method;
            $json['payment_link'] = HTTP_CATALOG . 'index.php?route=pos/index';
        }

        if ($pg_type == 'pos') {
            if ($payment_name == 'Card') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => $paid,
                    'points' => 0,
                    'credit' => 0,
                    'total' => $paid,
                );
            } elseif ($payment_name == 'Credit') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => 0,
                    'points' => 0,
                    'credit' => $paid,
                    'total' => $paid,
                );
            } elseif ($payment_name == 'Points') {
                $data['payment'] = array(
                    'cash' => 0,
                    'card' => 0,
                    'points' => $paid,
                    'credit' => 0,
                    'total' => $paid,
                );
            } else {
                $data['payment'] = array(
                    'cash' => $paid,
                    'card' => 0,
                    'points' => 0,
                    'credit' => 0,
                    'total' => $paid,
                );
            }
        } else {
            $data['payment'] = array(
                'cash' => $total,
                'card' => 0,
                'points' => 0,
                'credit' => 0,
                'total' => $paid,
            );
        }

        $this->model_pos_pos->editOrder($order_id, $data);
        unset($this->session->data['discount_amount']);
        $json['customer_name'] = $data['firstname'] . ' ' . $data['lastname'];
        $json['order_id'] = $order_id;
        $balance = $this->model_pos_pos->get_user_balance($this->user->getId());
        $json['cash'] = $this->currency->format($balance['cash'], $this->config->get('config_currency'));
        $json['card'] = $this->currency->format($balance['card'], $this->config->get('config_currency'));

        $json['success'] = 'Success: Order data updated with ID: ' . $order_id;

        $this->cart->clear();

        unset($this->session->data['shipping_address']);
        $this->response->setOutput(json_encode($json));
    }

    public function getProductByBarcode() {
        if ($this->request->post['barcode']) {
            $barcode = $this->request->post['barcode'];
        } else {
            $barcode = false;
        }

        $this->load->model('pos/pos');

        $product = $this->model_pos_pos->getProductByBarcode($barcode);

        $json['product_id'] = $product['product_id'];

        $json['has_option'] = $product['options'] ? '1' : '0';

        $this->response->setOutput(json_encode($json));
    }

    public function coupon() {

        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);


        $this->load->model('pos/coupon');


        $coupon_info = $this->model_pos_coupon->getCoupon($this->request->post['coupon']);

        if ($coupon_info) {
            $this->session->data['coupon'] = $this->request->post['coupon'];
        }

        // Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $json['total_data'] = $totals;

        $this->response->setOutput(json_encode($json));
    }

    public function voucher() {

        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);


        $this->load->model('pos/voucher');

        $voucher_info = $this->model_pos_voucher->getVoucher($this->request->post['voucher']);

        if ($voucher_info) {
            $this->session->data['voucher'] = $this->request->post['voucher'];
        }

        // Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $json['total_data'] = $totals;

        $this->response->setOutput(json_encode($json));
    }

    public function logout() {
        $this->user->logout();
        unset($this->session->data['user_token']);
        $this->response->redirect($this->url->link('pos/pos', '', true));
    }

    public function orders() {
        $this->load->language('pos/pos');

        $this->document->setTitle($this->language->get('heading_title'));


        $limit = 6; //per page limit

        $page = 1;

        $data = array(
            'filter_date_added' => date('Y-m-d'),
            'filter_store_id' => $this->session->data['store_id'],
            'order' => 'DESC',
            'start' => ($page - 1) * $limit,
            'limit' => $limit
        );
        $data['filter_order_status'] = 5;
        $this->load->model('sale/order');

        $order_total = $this->model_sale_order->getPosTotalOrders($data);

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getPosOrderStatuses();

        //get orders
        $result = $this->model_sale_order->getPosOrders($data);



        $data['rows'] = array();
        foreach ($result as $row) {
            $row['total'] = $this->currency->format($row['total'], $this->config->get('config_currency'));
            $data['rows'][] = $row;
        }

        //language

        $data['print_a5'] = 'index.php?route=sale/order/invoiceA5&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_receipt'] = 'index.php?route=sale/order/invoiceReceipt&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_hoald'] = 'index.php?route=sale/order/invoiceHoald&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';

        $data['text_missing'] = 'Missing Orders';
        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $limit;
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('pos/pos/ordersAJAX', 'user_token=' . $this->session->data['user_token'] . '&page={page}&filter_date_added=' . date('Y-m-d'), true);

        $data['pagination'] = $pagination->render();

        $data['filter_order_id'] = '';
        $data['filter_customer'] = '';
        $data['filter_invoice_id'] = '';
        $data['filter_order_status_id'] = 5;
        $data['filter_total'] = '';
        $data['filter_date_added'] = date('Y-m-d');
        $data['filter_date_modified'] = '';

        $this->response->setOutput($this->load->view('pos/orders', $data));
    }

    public function ordersAJAX() {

        $this->document->setTitle($this->language->get('heading_title'));

        $limit = 6; //per page limit

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_invoice_id'])) {
            $filter_invoice_id = $this->request->get['filter_invoice_id'];
        } else {
            $filter_invoice_id = null;
        }



        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = 5;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_invoice_id'])) {
            $url .= '&filter_invoice_id=' . $this->request->get['filter_invoice_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        } else {
            $url .= '&filter_date_added=' . date('Y-m-d');
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data = array(
            'filter_order_id' => $filter_order_id,
            'filter_store_id' => $this->session->data['store_id'],
            'filter_invoice_id' => $filter_invoice_id,
            'filter_customer' => $filter_customer,
            'filter_order_status' => $filter_order_status_id,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $limit,
            'limit' => $limit
        );

        $this->load->model('sale/order');

        $order_total = $this->model_sale_order->getPosTotalOrders($data);

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $rows = $this->model_sale_order->getPosOrders($data);

        $data['rows'] = array();

        foreach ($rows as $row) {
            $row['total'] = $this->currency->format($row['total'], $this->config->get('config_currency'));
            $data['rows'][] = $row;
        }

        $data['print_a5'] = 'index.php?route=sale/order/invoiceA5&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_receipt'] = 'index.php?route=sale/order/invoiceReceipt&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_hoald'] = 'index.php?route=sale/order/invoiceHoald&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';

        $data['text_missing'] = 'Missing Orders';
        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $limit;
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('pos/pos/ordersAJAX', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status_id'] = $filter_order_status_id;
        $data['filter_total'] = $filter_total;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            echo json_encode($data);
        } else {
            $this->response->setOutput($this->load->view('pos/orders', $data));
        }
    }

    public function getOrder() {

        unset($this->session->data['shipping_address']);
        unset($this->session->data['shipping_method']);

        $this->load->language('customer/customer');
        $this->load->model('sale/order');

        $json = array();

        $this->load->model('catalog/product');

        //customer info
        $this->load->model('pos/pos');
        $this->load->model('customer/customer');

        if (empty($this->request->get['customer_id']) && $this->request->get['customer_id'] == 0) {
            $json['customer'][] = array(
                'customer_id' => 0,
                'firstname' => $this->language->get('walk_in_customer'),
                'customer_ic' => '',
                'customer_card' => '',
                'validdate' => date('Y-m-d')
            );
            $this->session->data['shipping_addres_id'] = 0;
        } else {
            $customer = $this->model_pos_pos->getCustomer($this->request->get['customer_id']);
            $json['customer'][] = array(
                'customer_id' => $customer['customer_id'],
                'customer_card' => $customer['customer_card'],
                'customer_ic' => $customer['customer_ic'],
                'firstname' => $customer['firstname'],
                'validdate' => $customer['customer_validdate']
            );
            $json['shipping'][] = array();
            $json['shipping_address_id'] = $this->db->query('select shipping_address_id from `' . DB_PREFIX . 'order` where order_id="' . $this->request->get['order_id'] . '"')->row['shipping_address_id'];

            $this->session->data['shipping_addres_id'] = $json['shipping_address_id'];
            $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($json['shipping_address_id']);
            $json['shipping'] = $this->model_customer_customer->getAddresses($this->request->get['customer_id']);
        }

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);


        $order_products = $this->model_sale_order->getOrderCartProducts($this->request->get['order_id']);
        $this->cart->clear();
        foreach ($order_products as $order_product) {
            if (isset($order_product['order_option'])) {
                $order_option = $order_product['order_option'];
            } elseif (isset($this->request->get['order_id'])) {
                $order_option = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $order_product['order_product_id']);
            } else {
                $order_option = array();
            }

            $this->cart->add($order_product['product_id'], $order_product['quantity'], $order_option);
        }

        //html for cart
        $json['products'] = array();

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type']
                );
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($product['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }

            $sub_tax = $this->tax->calculateTax($product['price'], $product['tax_class_id'], $this->config->get('config_tax'));

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($sub_tax['total'] * $product['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $tax = $this->currency->format($sub_tax['tax'] * $product['quantity'], $this->config->get('config_currency'));

            $json['products'][] = array(
                'key' => $product['key'],
                'name' => $product['name'],
                'code' => $product['code'],
                'model' => $product['model'],
                'unitprice' => $product['unitprice'],
                'reward' => $product['reward'],
                'points' => $product['points'],
                'option' => $option_data,
                'quantity' => $product['quantity'],
                'price' => $price,
                'tax' => $tax,
                'total' => $total,
                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
            );
        }//foreach product in cart generate html
        //order Services
        $order_services = $this->model_pos_pos->getOrderCartServices($this->request->get['order_id']);


        foreach ($order_services as $order_service) {
            $this->cart->addService($order_service['service_form_id'], 1);
        }

        $json['services'] = array();

        foreach ($this->cart->getServices() as $service) {

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($service['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }


            $sub_tax = $this->tax->calculateTax($service['price'], $service['tax_class_id'], $this->config->get('config_tax'));

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($service['price'] * $service['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $tax = $this->currency->format($sub_tax['tax'] * $service['quantity'], $this->config->get('config_currency'));


            $json['services'][] = array(
                'key' => $service['key'],
                'name' => $service['name'],
                'unitprice' => $service['unitprice'],
                'invoice_prefix' => $service['invoice_prefix'],
                'gst' => $service['gst'],
                'customer_ic' => $service['customer_ic'],
                'quantity' => $service['quantity'],
                'price' => $price,
                'tax' => $tax,
                'total' => $total,
            );
        }//foreach product in services generate html
        //order herble
        $order_herble = $this->model_pos_pos->getOrderCartherbal($this->request->get['order_id']);

        foreach ($order_herble as $order_herble) {
            $this->cart->addHerbal($order_herble['clinical_sale_id'], 1);
        }

        $json['herbls'] = array();

        foreach ($this->cart->getHerbals() as $herbals) {

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($herbals['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }


            $sub_tax = $this->tax->calculateTax($herbals['price'], $herbals['tax_class_id'], $this->config->get('config_tax'));

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($herbals['price'] * $herbals['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $tax = $this->currency->format($sub_tax['tax'] * $herbals['quantity'], $this->config->get('config_currency'));

            $json['herbls'][] = array(
                'key' => $herbals['key'],
                'name' => $herbals['name'],
                'unitprice' => $herbals['unitprice'],
                'invoice_prefix' => $herbals['invoice_prefix'],
                'gst' => $herbals['gst'],
                'customer_ic' => $herbals['customer_ic'],
                'quantity' => $herbals['quantity'],
                'price' => $price,
                'tax' => $tax,
                'total' => $total,
            );
        }//foreach product in herbls generate html
        //Get Brewing
        $order_brewing = $this->model_pos_pos->getOrderCartBrewing($this->request->get['order_id']);
        if (!empty($order_brewing)) {
            foreach ($order_brewing as $order_brewing) {
                $this->cart->addBrewing($order_brewing['herbal_transfer_id'], 1);
            }
            $json['brewings'] = array();
            foreach ($this->cart->getBrewings() as $brewings) {
                //Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($brewings['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }

                $sub_tax = $this->tax->calculateTax($brewings['price'], $brewings['tax_class_id'], $this->config->get('config_tax'));
                //Display Total 
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($brewings['price'] * $brewings['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //Tax
                $tax = $this->currency->format($sub_tax['tax'] * $brewings['quantity'], $this->config->get('config_currency'));
                $json['brewings'][] = array(
                    'key' => $brewings['key'],
                    'name' => $brewings['name'],
                    'unitprice' => $brewings['unitprice'],
                    'invoice_prefix' => $brewings['invoice_prefix'],
                    'gst' => $brewings['gst'],
                    'customer_ic' => $brewings['customer_ic'],
                    'quantity' => $brewings['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        } else {
            $json['brewings'] = array();
        }

        //Get Brewing Order
        $order_brewing_order = $this->model_pos_pos->getOrderCartBrewingOrder($this->request->get['order_id']);
        if (!empty($order_brewing_order)) {
            foreach ($order_brewing_order as $order_brewing_order) {
                $this->cart->addBrewingOrder($order_brewing_order['herbal_transfer_id'], 1);
            }
            $json['brewing_orders'] = array();
            foreach ($this->cart->getBrewingOrders() as $brewing_orders) {
                //Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($brewing_orders['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }

                $sub_tax = $this->tax->calculateTax($brewing_orders['price'], $brewing_orders['tax_class_id'], $this->config->get('config_tax'));
                //Display Total 
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($brewing_orders['price'] * $brewing_orders['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //Tax
                $tax = $this->currency->format($sub_tax['tax'] * $brewing_orders['quantity'], $this->config->get('config_currency'));
                $json['brewing_orders'][] = array(
                    'key' => $brewing_orders['key'],
                    'name' => $brewing_orders['name'],
                    'unitprice' => $brewing_orders['unitprice'],
                    'invoice_prefix' => $brewing_orders['invoice_prefix'],
                    'gst' => $brewing_orders['gst'],
                    'customer_ic' => $brewing_orders['customer_ic'],
                    'quantity' => $brewing_orders['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        } else {
            $json['brewing_orders'] = array();
        }

        // Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'shipping' && $result['code'] != 'rounding') {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }
        //get order comment
        $json['comment'] = $this->db->query('select comment from `' . DB_PREFIX . 'order` where order_id="' . $this->request->get['order_id'] . '"')->row['comment'];
        $json['total_data'] = $totals;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        $json['order_id'] = $this->request->get['order_id'];
        $json['invoice_prefix'] = $this->request->get['invoice_prefix'];

        echo json_encode($json);
    }

    public function holds() {

        $this->load->language('pos/pos');

        $this->document->setTitle($this->language->get('heading_title'));

        $limit = 6; //per page limit

        $page = 1;

        $data = array(
            'order' => 'DESC',
            'start' => ($page - 1) * $limit,
            'limit' => $limit
        );
        $data['filter_order_status'] = 1;
        $this->load->model('sale/order');

        $order_total = $this->model_sale_order->getPosTotalOrders($data);

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getPosOrderStatuses();

        //get orders
        $result = $this->model_sale_order->getPosOrders($data);

        $data['rows'] = array();
        foreach ($result as $row) {
            $row['total'] = $this->currency->format($row['total'], $this->config->get('config_currency'));
            $data['rows'][] = $row;
        }

        //language

        $data['print_a5'] = 'index.php?route=sale/order/invoiceA5&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_receipt'] = 'index.php?route=sale/order/invoiceReceipt&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_hoald'] = 'index.php?route=sale/order/invoiceHoald&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';

        $data['text_missing'] = 'Missing Orders';
        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $data['user_token'] = $this->session->data['user_token'];

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $limit;
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('pos/pos/holdsAJAX', 'user_token=' . $this->session->data['user_token'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['filter_order_id'] = '';
        $data['filter_customer'] = '';
        $data['filter_invoice_id'] = '';
        $data['filter_order_status_id'] = 1;
        $data['filter_total'] = '';
        $data['filter_date_added'] = '';
        $data['filter_date_modified'] = '';

        $this->response->setOutput($this->load->view('pos/holds', $data));
    }

    public function holdsAJAX() {
        $this->load->language('pos/pos');

        $this->document->setTitle($this->language->get('heading_title'));

        $limit = 6; //per page limit

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_invoice_id'])) {
            $filter_invoice_id = $this->request->get['filter_invoice_id'];
        } else {
            $filter_invoice_id = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_invoice_id'])) {
            $url .= '&filter_invoice_id=' . $this->request->get['filter_invoice_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }


        $data = array(
            'filter_order_id' => $filter_order_id,
            'filter_invoice_id' => $filter_invoice_id,
            'filter_customer' => $filter_customer,
            'filter_order_status' => 1,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $limit,
            'limit' => $limit
        );

        $this->load->model('sale/order');

        $order_total = $this->model_sale_order->getPosTotalOrders($data);

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $rows = $this->model_sale_order->getPosOrders($data);

        $data['rows'] = array();

        foreach ($rows as $row) {
            $row['total'] = $this->currency->format($row['total'], $this->config->get('config_currency'));
            $data['rows'][] = $row;
        }

        $data['print_a5'] = 'index.php?route=sale/order/invoiceA5&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_receipt'] = 'index.php?route=sale/order/invoiceReceipt&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';
        $data['print_hoald'] = 'index.php?route=sale/order/invoiceHoald&user_token=' . $this->session->data['user_token'] . '&pdf=1&order_id=';

        $data['text_missing'] = 'Missing Orders';
        $data['currency_code'] = $this->config->get('config_currency');
        $data['currency_value'] = '1.0';
        $data['store_id'] = $this->getStoreId();
        $data['user_token'] = $this->session->data['user_token'];


        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $limit;
        $pagination->text = $this->language->get('text_pagination');
        $pagination->url = $this->url->link('pos/pos/holdsAJAX', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status_id'] = $filter_order_status_id;
        $data['filter_total'] = $filter_total;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            echo json_encode($data);
        } else {
            $this->response->setOutput($this->load->view('pos/holds', $data));
        }
    }

//get order

    public function hold_cart_delete() {
        $this->load->model('pos/pos');
        $this->model_pos_pos->hold_cart_delete($_POST['cart_holder_id']);
    }

    public function hold_cart() {

        $json = array();

        if ($_POST['name'] == '') {
            $json['error'] = 'Error: Please enter hold name.';
            echo json_encode($json);
            die();
        }

        $data = array(
            'name' => $this->request->post['name'],
            'cart' => $this->session->data['cart'],
            'user_id' => $this->user->getId(),
        );

        $this->load->model('pos/pos');

        $id = $this->model_pos_pos->hold_cart($data);

        //html update
        $row = $this->model_pos_pos->hold_cart_select($id);

        $json['html'] = '<tr><td>' . $row['name'] . '</td><td align="center">' . $row['date_created'] . '</td><td align="center">';
        $json['html'] .= "[<a data_cart_holder_id='" . $row["cart_holder_id"] . "' href='#' class='select'>Select</a>]&nbsp;";
        $json['html'] .= "[<a data_cart_holder_id='" . $row["cart_holder_id"] . "' href='#' class='delete'>Delete</a>]</td></tr>";

        $json['success'] = 'Success: cart moved to hold list.';

        echo json_encode($json);
    }

    public function hold_cart_select() {

        $this->load->model('pos/pos');

        $row = $this->model_pos_pos->hold_cart_select($_POST['cart_holder_id']);

        $this->session->data['cart'] = unserialize($row['cart']);

        $json['products'] = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        foreach ($this->cart->getProducts() as $product) {

            $option_data = array();

            foreach ($product['option'] as $option) {
                if ($option['type'] != 'file') {
                    $value = $option['value'];
                } else {
                    $filename = $this->encryption->decrypt($option['value']);

                    $value = utf8_substr($filename, 0, utf8_strrpos($filename, '.'));
                }

                $option_data[] = array(
                    'name' => $option['name'],
                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value),
                    'type' => $option['type']
                );
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $price = $this->currency->format($product['price'], $this->config->get('config_currency'));
            } else {
                $price = false;
            }

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $total = $this->currency->format($this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'], $this->config->get('config_currency'));
            } else {
                $total = false;
            }

            //tax
            $a = $product['price'] * $product['quantity'];
            $b = $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'];
            $tax = $this->currency->format($b - $a, $this->config->get('config_currency'));

            $json['products'][] = array(
                'key' => $product['key'],
                'name' => $product['name'],
                'model' => $product['model'],
                'option' => $option_data,
                'quantity' => $product['quantity'],
                'price' => $price,
                'total' => $total,
                'tax' => $tax,
                'href' => $this->url->link('product/product', 'product_id=' . $product['product_id']),
            );
        }//foreach product in cart generate html
        // Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        $json['total_data'] = $totals;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        $json['success'] = 'Success: cart restored from hold list.';

        echo json_encode($json);
    }

    public function print_invoice() {
        /* $printer = "ST-EP4 Printer";
          $ph = printer_open($printer);
          printer_set_option($ph, PRINTER_MODE, "RAW");
          printer_set_option($ph, PRINTER_PAPER_FORMAT, PRINTER_FORMAT_CUSTOM);
          printer_set_option($ph, PRINTER_PAPER_LENGTH, 80);
          printer_set_option($ph, PRINTER_MODE, "RAW");
          printer_start_doc($ph,"Invice");
          printer_start_page($ph);
          $font = printer_create_font("Arial", 12, 12, false, false, false, false, 0);
          printer_select_font($ph, $font);
          printer_write($ph,"tines");
          printer_start_page($ph);
          printer_end_doc($ph);
          printer_close($ph); */
    }

    //Add by Chew Yi Xuan ON 2017-07-13 Start//
    //Get Items
    public function getItems() {
        $this->load->language('pos/pos');
        $this->load->model('pos/pos');
        $this->document->setTitle($this->language->get('heading_title'));
        $data = array();
        $url = '';
        //Column
        //entry
        $data['entry_date_from'] = $this->language->get('entry_date_from');
        $data['entry_date_to'] = $this->language->get('entry_date_to');

        $data['item_types'][] = array(
            'name' => $this->language->get('text_all')
        );
        $data['item_types'][] = array(
            'name' => $this->language->get('text_herbal_remedies')
        );
        $data['item_types'][] = array(
            'name' => $this->language->get('text_service')
        );
        $data['item_types'][] = array(
            'name' => $this->language->get('text_brewing')
        );

        if (!empty($this->request->get['filter_id'])) {
            $data['filter_id'] = $this->request->get['filter_id'];
            $url .= '&filter_id=' . $this->request->get['filter_id'];
        } else {
            $data['filter_id'] = null;
        }

        if (!empty($this->request->get['filter_type'])) {
            $data['filter_type'] = $this->request->get['filter_type'];
            $url .= '&filter_type=' . $this->request->get['filter_type'];
        } else {
            $data['filter_type'] = NULL;
        }

        if (!empty($this->request->get['filter_invoice_prefix'])) {
            $data['filter_invoice_prefix'] = $this->request->get['filter_invoice_prefix'];
            $url .= '&filter_invoice_prefix=' . urlencode(html_entity_decode($data['filter_invoice_prefix'], ENT_QUOTES, 'UTF-8'));
        } else {
            $data['filter_invoice_prefix'] = null;
        }

        if (!empty($this->request->get['filter_customer_ic'])) {
            $data['filter_customer_ic'] = $this->request->get['filter_customer_ic'];
            $url .= '&filter_customer_ic=' . urlencode(html_entity_decode($data['filter_customer_ic'], ENT_QUOTES, 'UTF-8'));
        } else {
            $data['filter_customer_ic'] = null;
        }

        if (!empty($this->request->get['filter_customer_name'])) {
            $data['filter_customer_name'] = $this->request->get['filter_customer_name'];
            $url .= '&filter_customer_name=' . urlencode(html_entity_decode($data['filter_customer_name'], ENT_QUOTES, 'UTF-8'));
        } else {
            $data['filter_customer_name'] = null;
        }

        if (!empty($this->request->get['filter_date_added'])) {
            $data['filter_date_added'] = $this->request->get['filter_date_added'];
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        } else {
            $data['filter_date_added'] = null;
        }

        if (!empty($this->request->get['filter_date_modified'])) {
            $data['filter_date_modified'] = $this->request->get['filter_date_modified'];
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        } else {
            $data['filter_date_modified'] = null;
        }

        if (!empty($this->request->get['filter_date_from'])) {
            $data['filter_date_from'] = $this->request->get['filter_date_from'];
            $url .= '&filter_date_from=' . $this->request->get['filter_date_from'];
        } else {
            $data['filter_date_from'] = null;
        }

        if (!empty($this->request->get['filter_date_to'])) {
            $data['filter_date_to'] = $this->request->get['filter_date_to'];
            $url .= '&filter_date_to=' . $this->request->get['filter_date_to'];
        } else {
            $data['filter_date_to'] = null;
        }

        if (isset($this->request->get['filter_hour'])) {
            $data['filter_hour'] = $this->request->get['filter_hour'];
            $url .= '&filter_hour=' . $this->request->get['filter_hour'];
        } else {
            $data['filter_hour'] = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $data['filter_total'] = $this->request->get['filter_total'];
            $url .= '&filter_total=' . urlencode(html_entity_decode($data['filter_total'], ENT_QUOTES, 'UTF-8'));
        } else {
            $data['filter_total'] = null;
        }

        if (!empty($this->request->get['sort'])) {
            $data['sort'] = $this->request->get['sort'];
            $url .= '&sort=' . $data['sort'];
        } else {
            $data['sort'] = 'a.date_added';
        }

        if (isset($this->request->get['order'])) {
            $data['order'] = $this->request->get['order'];
            $url .= '&order=' . $data['order'];
        } else {
            $data['order'] = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
            $data['page'] = $page;
            $url .= '&page=' . $page;
        } else {
            $page = 1;
        }

        if (isset($this->request->get['limit'])) {
            $data['limit'] = $this->request->get['limit'];
        } else {
            $data['limit'] = 5;
        }

        $data['start'] = ($page - 1 ) * $data['limit'];

        $getAllItems = $this->model_pos_pos->getAllItemsByFilterData($data);
        $items_total = $this->model_pos_pos->getAllItemsTotalByFilterData($data);
        $data['items_total'] = $items_total;
        if (!empty($getAllItems)) {
            $all_items = $this->sortAllItems($getAllItems);
            $data['all_items'] = $all_items['all_items'];
        } else {
            $data['all_items'] = array();
        }

        $data['original_url'] = "index.php?route=pos/pos/getItems&user_token=" . $this->session->data['user_token'];
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $data['date_today'] = date('Y-m-d');
        $data['this_hour'] = date('Y-m-d H');
        $data['user_token'] = $this->session->data['user_token'];
        $pagination = new Pagination();
        $pagination->total = $items_total;
        $pagination->page = $page;
        $pagination->limit = $data['limit'];
        $pagination->url = $this->url->link('pos/pos/getItems', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);
        $data['pagination'] = $pagination->render();
        $data['results'] = sprintf($this->language->get('text_pagination'), ($items_total) ? (($page - 1) * 5) + 1 : 0, ((($page - 1) * 5) > ($items_total - 5)) ? $items_total : ((($page - 1) * 5) + 5), $items_total, ceil($items_total / 5));
        $this->response->setOutput($this->load->view('pos/items', $data));
    }

    //Sort Items
    public function sortAllItems($all_items) {
        $this->load->language('pos/pos');
        $this->load->library('tax');
        $this->load->library('currency');
        $this->load->library('pos_cart');
        $this->tax = new Tax($this->registry);
        $this->currency = new Currency($this->registry);
        $this->cart = new Pos_cart($this->registry);
        $text_herbal_remedies = $this->language->get('text_herbal_remedies');
        $text_brewing = $this->language->get('text_brewing');
        $text_service = $this->language->get('text_service');
        $data = array();
        if (!empty($this->cart->getServices())) {
            $data['service_key'] = array_keys($this->cart->getServices());
        } else {
            $data['service_key'] = array();
        }
        if (!empty($this->cart->getHerbals())) {
            $data['herbal_key'] = array_keys($this->cart->getHerbals());
        } else {
            $data['herbal_key'] = array();
        }
        if (!empty($all_items)) {
            foreach ($all_items as $id => $item) {
                //Date Added
                if (!empty($item['date_added']) && $item['date_added'] != '0000-00-00') {
                    $date_added = $item['date_added'];
                    $time = date('H:m:s A', strtotime($item['date_added']));
                    $day = date('l', strtotime($item['date_added']));
                } else {
                    $date_added = '-';
                    $time = '-';
                    $day = '-';
                }
                //Date Modified
                if (!empty($item['date_modified']) && $item['date_modified'] != '0000-00-00') {
                    $date_modified = $item['date_modified'];
                } else {
                    $date_modified = '-';
                }
                //Invoice Prefix
                if (!empty($item['invoice_prefix'])) {
                    $invoice_prefix = $item['invoice_prefix'];
                } else {
                    $invoice_prefix = '-';
                }
                //Customer Name
                if (!empty($item['customer_name'])) {
                    $customer_name = $item['customer_name'];
                } else {
                    $customer_name = '-';
                }
                //Customer IC
                if (!empty($item['customer_ic'])) {
                    $customer_ic = $item['customer_ic'];
                } else {
                    $customer_ic = '-';
                }
                //Total
                if (!empty($item['total'])) {
                    $total = $item['total'];
                } else {
                    $total = 0;
                }
                //Store Id
                if (isset($item['store_id'])) {
                    $store_id = $item['store_id'];
                } else {
                    $store_id = NULL;
                }
                //Id
                if (isset($item['id'])) {
                    $id = $item['id'];
                } else {
                    $id = NULL;
                }
                //Type
                if (!empty($item['type'])) {
                    if ($item['type'] == 1) {
                        $type = $item['type'];
                        $type_name = $text_herbal_remedies;
                    } else if ($item['type'] == 2) {
                        $type = $item['type'];
                        $type_name = $text_service;
                    } else if ($item['type'] == 3) {
                        $type = $item['type'];
                        $type_name = $text_brewing;
                    } else {
                        $type = 0;
                        $type_name = '-';
                    }
                } else {
                    $type = 0;
                    $type_name = '-';
                }
                //Checking in cart
                if (!empty($item['type']) && !empty($item['id'])) {
                    if ($item['type'] == 1) {
                        if (!empty($data['herbal_key'])) {
                            if (in_array($item['id'], $data['herbal_key'])) {
                                $in_cart = 1;
                                $key = $data['herbal_key'];
                            } else {
                                $in_cart = 0;
                                $key = 0;
                            }
                        } else {
                            $in_cart = 0;
                            $key = 0;
                        }
                    } else if ($item['type'] == 2) {
                        if (!empty($data['service_key'])) {
                            if (in_array($item['id'], $data['service_key'])) {
                                $in_cart = 1;
                                $key = $data['service_key'];
                            } else {
                                $in_cart = 0;
                                $key = 0;
                            }
                        } else {
                            $in_cart = 0;
                            $key = 0;
                        }
                    } else {
                        $in_cart = 0;
                        $key = 0;
                    }
                } else {
                    $in_cart = 0;
                    $key = 0;
                }
                $data['all_items'][] = array(
                    'id' => $id,
                    'invoice_prefix' => $invoice_prefix,
                    'customer_name' => $customer_name,
                    'customer_ic' => $customer_ic,
                    'in_cart' => $in_cart,
                    'type' => $type,
                    'type_name' => $type_name,
                    'price' => $total,
                    'total' => $this->currency->format($total, $this->config->get('config_currency')),
                    'store_id' => $store_id,
                    'time' => $time,
                    'day' => $day,
                    'date_added' => $date_added,
                    'key' => $key,
                    'date_modified' => $date_modified,
                );
            }
        } else {
            $data = array();
        }
        return $data;
    }

    //Add Item To Cart
    public function addItemtoCart() {
        $this->load->language('pos/pos');
        $this->load->language('customer/customer');
        $this->load->model('pos/pos');
        $this->load->model('customer/customer');
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $json = array();
        if (!empty($this->request->post)) {
            if (!empty($this->request->post['customer_ic'])) {
                $data['customer_ic'] = $this->request->post['customer_ic'];
                $json['shipping'][] = array();
                $json = $this->model_customer_customer->selectCustomers($data);
                if (!empty($json)) {
                    $this->cart->addCustomerGroupId($json[0]['customer_group_id']);
                    $this->session->data['customer_id'] = $json[0]['customer_id'];
                    $json['shipping'] = $this->model_customer_customer->getAddresses($json[0]['customer_id']);
                    $json['shipping_address_id'] = isset($this->session->data['shipping_addres_id']) ? $this->session->data['shipping_addres_id'] : 0;
                    if (!empty($this->request->post['id']) && !empty($this->request->post['type'])) {
                        $type = $this->request->post['type'];
                        $id = $this->request->post['id'];
                        if ($type == 1) {
                            $json['herbal_key'] = $this->addHerbalToCart($id);
                            if (!empty($json['herbal_key'])) {
                                $json['success'] = 'Add Herbal_' . $id . ' to Cart Successfully !';
                            } else {
                                $json['error_failed'] = 'Add Herbal_' . $id . ' Failed !';
                            }
                        } else if ($type == 2) {
                            $json['service_key'] = $this->addServiceToCart($id);
                            if (!empty($json['service_key'])) {
                                $json['success'] = 'Add Services_' . $id . ' to Cart Successfully !';
                            } else {
                                $json['error_failed'] = 'Add Service_' . $id . ' Failed !';
                            }
                        } else {
                            $json['error_add'] = 'No adding !';
                        }
                        $json['herbals'] = $this->getHerbalsInCart();
                        $json['services'] = $this->getServicesInCart();
                        $cartTotal = $this->getCartTotalData();
                        $json['total'] = $cartTotal['total'];
                        $json['total_data'] = $cartTotal['total_data'];
                    } else {
                        $json['error_id_type'] = 'No Id & Type !';
                    }
                } else {
                    $json['error_customer'] = 'No customer data';
                }
            } else {
                $json['error_customer_ic'] = 'Empty IC !';
            }
        } else {
            $json['error_post'] = 'Empty Post Data !';
        }
        $this->response->addHeader('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    //Get Cart Total
    public function getCartTotalData() {
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos Cart
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $this->load->model('pos/extension');
        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );
        $json = array();

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();
            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }
            array_multisort($sort_order, SORT_ASC, $results);
            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);
                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }
                $sort_order = array();
                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }
                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }
        $json['total_data'] = $totals;
        $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
        return $json;
    }

    //Get Herbal In Pos Cart
    public function getHerbalsInCart() {
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos Cart
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $json['herbals'] = array();
        if (!empty($this->cart->getHerbals())) {
            foreach ($this->cart->getHerbals() as $herbals) {
                $this->session->data['shipping_addres_id'] = $herbals['shipping_address_id'];
                $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($herbals['shipping_address_id']);
                //Get Tax
                $tax = $this->model_pos_pos->getHerbalTotalTax($herbals['herbal_id']);
                //Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($herbals['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }
                //Sub Tax
                $sub_tax = $this->tax->calculateTax($herbals['price'], $herbals['tax_class_id'], $this->config->get('config_tax'));
                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($herbals['price'] * $herbals['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //Tax
                $tax = $this->currency->format($sub_tax['tax'] * $herbals['quantity'], $this->config->get('config_currency'));
                $json['herbals'][] = array(
                    'key' => $herbals['key'],
                    'name' => $herbals['name'],
                    'unitprice' => $herbals['unitprice'],
                    'invoice_prefix' => $herbals['invoice_prefix'],
                    'gst' => $herbals['gst'],
                    'customer_ic' => $herbals['customer_ic'],
                    'quantity' => $herbals['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        } else {
            $json['herbals'] = array();
        }
        return $json['herbals'];
    }

    //Get Service In Pos Cart
    public function getServicesInCart() {
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos Cart
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $json['services'] = array();
        if (!empty($this->cart->getServices())) {
            foreach ($this->cart->getServices() as $service) {
                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($service['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }
                //Sub Tax
                $sub_tax = $this->tax->calculateTax($service['price'], $service['tax_class_id'], $this->config->get('config_tax'));
                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($service['price'] * $service['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //tax
                $tax = $this->currency->format($sub_tax['tax'] * $service['quantity'], $this->config->get('config_currency'));
                $json['services'][] = array(
                    'key' => $service['key'],
                    'name' => $service['name'],
                    'unitprice' => $service['unitprice'],
                    'invoice_prefix' => $service['invoice_prefix'],
                    'gst' => $service['gst'],
                    'customer_ic' => $service['customer_ic'],
                    'quantity' => $service['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        } else {
            $json['services'] = array();
        }
        return $json['services'];
    }

    //Add Service to Pos Cart
    function addServiceToCart($service_id) {
        $json = array();
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos Cart
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        $this->load->model('pos/pos');
        if (!empty($service_id)) {
            $service_id = $service_id;
        } else {
            $service_id = 0;
        }
        $services = $this->model_pos_pos->getServicesByServiceId($service_id);
        if (!empty($services)) {
            foreach ($services as $items) {
                $key = $this->cart->addService($items['service_form_id'], 1);
                $json['service_key'][] = $key;
            }
        } else {
            $json['service_key'] = array();
        }
        return $json['service_key'];
    }

    //Add Herbal To Pos Cart
    function addHerbalToCart($clinical_sale_id) {
        $json = array();
        //Customer
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax
        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);
        //Pos Cart
        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);
        $this->load->model('pos/pos');
        if (!empty($clinical_sale_id)) {
            $clinical_sale_id = $clinical_sale_id;
        } else {
            $clinical_sale_id = 0;
        }
        $herbal = $this->model_pos_pos->getHerbalByClinicalsaleId($clinical_sale_id);
        if (!empty($herbal)) {
            foreach ($herbal as $items) {
                $key = $this->cart->addHerbal($items['clinical_sale_id'], 1);
                $json['herbal_key'][] = $key;
            }
        } else {
            $json['herbal_key'] = array();
        }
        return $json['herbal_key'];
    }

    //Add by Chew Yi Xuan ON 2017-07-13  End //

    public function searchCustomer() {

        $this->load->language('customer/customer');
        $this->load->model('customer/customer');

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        if (isset($this->request->post['customer_card'])) {
            $data['customer_card'] = $this->request->post['customer_card'];
        }
        if (isset($this->request->post['customer_ic'])) {
            $data['customer_ic'] = $this->request->post['customer_ic'];
        }

        $json['shipping'][] = array();
        $json = $this->model_customer_customer->selectCustomers($data);
        $this->cart->clearService();
        $this->cart->clearHerbal();
        //$this->cart->clearBrewing();
        //$this->cart->clearBrewingOrder();

        if (empty($json)) {
            $json['errors'] = $this->language->get('error_not_exists');
        } else {
            $this->session->data['customer_id'] = $json[0]['customer_id'];
            $this->cart->addCustomerGroupId($json[0]['customer_group_id']);
            $json['shipping'] = $this->model_customer_customer->getAddresses($json[0]['customer_id']);
            $json['service'] = $this->addServices($json[0]['customer_id']);
            $json['herbale'] = $this->addHerbal($json[0]['customer_id']);
            $json['brewing'] = []; //$this->addBrewing($json[0]['customer_id']);
            $json['brewing_order'] = []; //$this->addBrewingOrder($json[0]['customer_id']);
            $json['shipping_address_id'] = isset($this->session->data['shipping_addres_id']) ? $this->session->data['shipping_addres_id'] : 0;
            $json['success'] = "Member Details";
        }
        return $this->response->setOutput(json_encode($json));
    }

    //add service
    function addServices($customer_id) {
        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->load->model('pos/pos');

        if ($customer_id) {
            $customer_id = $customer_id;
        } else {
            $customer_id = 0;
        }

        $services = $this->model_pos_pos->getServices($customer_id);

        if ($services) {
            foreach ($services as $items) {
                $key = $this->cart->addService($items['service_form_id'], 1);
            }

            $totals = array();
            $total = 0;
            $taxes = $this->cart->getTaxes();

            $total_data = array(
                'totals' => &$totals,
                'taxes' => &$taxes,
                'total' => &$total
            );


            $this->load->model('pos/extension');

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');

                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
                }

                array_multisort($sort_order, SORT_ASC, $results);
                foreach ($results as $result) {
                    if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                        $this->load->model('pos/' . $result['code']);
                        $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                    }

                    $sort_order = array();

                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }
            }
            $json['total_data'] = $totals;
            $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));

            //html for cart
            $json['services'] = array();
            foreach ($this->cart->getServices() as $service) {

                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($service['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }

                $sub_tax = $this->tax->calculateTax($service['price'], $service['tax_class_id'], $this->config->get('config_tax'));

                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($service['price'] * $service['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }

                //tax
                $tax = $this->currency->format($sub_tax['tax'] * $service['quantity'], $this->config->get('config_currency'));

                $json['services'][] = array(
                    'key' => $service['key'],
                    'name' => $service['name'],
                    'unitprice' => $service['unitprice'],
                    'invoice_prefix' => $service['invoice_prefix'],
                    'gst' => $service['gst'],
                    'customer_ic' => $service['customer_ic'],
                    'quantity' => $service['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        }
        return $json;
    }

    function addBrewing($customer_id) {
        $json = array();
        //Customer Library
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax Library
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos cart Library
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        //Model
        $this->load->model('pos/pos');
        $this->load->model('customer/customer');
        if ($customer_id) {
            $customer_id = $customer_id;
        } else {
            $customer_id = 0;
        }
        //Get Brewing
        $brewing = $this->model_pos_pos->getBrewing($customer_id);
        if ($brewing) {
            foreach ($brewing as $items) {
                $key = $this->cart->addBrewing($items['herbal_transfer_id'], 1);
            }
            $total = 0;
            $totals = array();
            $taxes = $this->cart->getTaxes();

            $total_data = array(
                'totals' => &$totals,
                'taxes' => &$taxes,
                'total' => &$total
            );
            $this->load->model('pos/extension');
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);
                foreach ($results as $result) {
                    if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                        $this->load->model('pos/' . $result['code']);
                        $this->{'model_pos_' . $result['code']}->getTotalAmount($total_data, $total, $taxes);
                    }
                    $sort_order = array();
                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }
                    array_multisort($sort_order, SORT_ASC, $totals);
                }
            }
            $json['total_data'] = $totals;
            $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
            //Get Brewing In Cart
            $json['brewings'] = array();
            foreach ($this->cart->getBrewings() as $brewings) {
                $this->session->data['shipping_address_id'] = $brewings['shipping_address_id'];
                $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($brewings['shipping_address_id']);
                //$tax = $this->model_pos_pos->getBrewingTotalTax($brewings['herbal_transfer_id']);
                //Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($brewings['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }
                //Get Tax 
                $sub_tax = $this->tax->calculateTax($brewings['price'], $brewings['tax_class_id'], $this->config->get('config_tax'));
                //Display total
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($brewings['price'] * $brewings['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //Tax
                $tax = $this->currency->format($sub_tax['tax'] * $brewings['quantity'], $this->config->get('config_currency'));
                $json['brewings'][] = array(
                    'key' => $brewings['key'],
                    'name' => $brewings['name'],
                    'unitprice' => $brewings['unitprice'],
                    'invoice_prefix' => $brewings['invoice_prefix'],
                    'gst' => $brewings['gst'],
                    'customer_ic' => $brewings['customer_ic'],
                    'quantity' => $brewings['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        }
        return $json;
    }

    function addBrewingOrder($customer_id) {
        $json = array();
        //Customer Library
        $this->load->library('customer');
        $this->customer = new Customer($this->registry);
        //Tax Library
        $this->load->library('tax');
        $this->tax = new Tax($this->registry);
        //Pos cart Library
        $this->load->library('pos_cart');
        $this->cart = new Pos_cart($this->registry);
        //Model
        $this->load->model('pos/pos');
        $this->load->model('customer/customer');
        if ($customer_id) {
            $customer_id = $customer_id;
        } else {
            $customer_id = 0;
        }
        //Get Brewing
        $brewing = $this->model_pos_pos->getBrewingOrder($customer_id);
        if ($brewing) {
            foreach ($brewing as $items) {
                $key = $this->cart->addBrewingOrder($items['herbal_transfer_id'], 1);
            }
            $total = 0;
            $totals = array();
            $taxes = $this->cart->getTaxes();

            $total_data = array(
                'totals' => &$totals,
                'taxes' => &$taxes,
                'total' => &$total
            );
            $this->load->model('pos/extension');
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');
                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
                }
                array_multisort($sort_order, SORT_ASC, $results);
                foreach ($results as $result) {
                    if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                        $this->load->model('pos/' . $result['code']);
                        $this->{'model_pos_' . $result['code']}->getTotalAmount($total_data, $total, $taxes);
                    }
                    $sort_order = array();
                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }
                    array_multisort($sort_order, SORT_ASC, $totals);
                }
            }
            $json['total_data'] = $totals;
            $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));
            //Get Brewing In Cart
            $json['brewings'] = array();
            foreach ($this->cart->getBrewingOrders() as $brewings) {
                $this->session->data['shipping_addres_id'] = $brewings['shipping_address_id'];
                $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($brewings['shipping_address_id']);
                //$tax = $this->model_pos_pos->getBrewingTotalTax($brewings['herbal_transfer_id']);
                //Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($brewings['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }
                //Get Tax 
                $sub_tax = $this->tax->calculateTax($brewings['price'], $brewings['tax_class_id'], $this->config->get('config_tax'));
                //Display total
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($brewings['price'] * $brewings['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }
                //Tax
                $tax = $this->currency->format($sub_tax['tax'] * $brewings['quantity'], $this->config->get('config_currency'));
                $json['brewings'][] = array(
                    'key' => $brewings['key'],
                    'name' => $brewings['name'],
                    'unitprice' => $brewings['unitprice'],
                    'invoice_prefix' => $brewings['invoice_prefix'],
                    'gst' => $brewings['gst'],
                    'customer_ic' => $brewings['customer_ic'],
                    'quantity' => $brewings['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                    'shipping_address_id' => $brewings['shipping_address_id']
                );
            }
        }
        return $json;
    }

    //add herbale
    function addHerbal($customer_id) {
        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->load->model('pos/pos');
        $this->load->model('customer/customer');

        if ($customer_id) {
            $customer_id = $customer_id;
        } else {
            $customer_id = 0;
        }

        $herbal = $this->model_pos_pos->getHerbal($customer_id);

        if ($herbal) {
            foreach ($herbal as $items) {
                $key = $this->cart->addHerbal($items['clinical_sale_id'], 1);
            }

            $total = 0;
            $totals = array();
            $taxes = $this->cart->getTaxes();

            $total_data = array(
                'totals' => &$totals,
                'taxes' => &$taxes,
                'total' => &$total
            );

            $this->load->model('pos/extension');

            // Display prices
            if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                $sort_order = array();
                $results = $this->model_pos_extension->getExtensions('total');

                foreach ($results as $key => $value) {
                    $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
                }

                array_multisort($sort_order, SORT_ASC, $results);
                foreach ($results as $result) {
                    if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                        $this->load->model('pos/' . $result['code']);
                        $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                    }

                    $sort_order = array();

                    foreach ($totals as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }

                    array_multisort($sort_order, SORT_ASC, $totals);
                }
            }
            $json['total_data'] = $totals;
            $json['total'] = $this->currency->format($total, $this->config->get('config_currency'));

            //html for cart
            $json['herbals'] = array();
            foreach ($this->cart->getHerbals() as $herbals) {

                $this->session->data['shipping_addres_id'] = $herbals['shipping_address_id'];
                $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($herbals['shipping_address_id']);

                $tax = $this->model_pos_pos->getHerbalTotalTax($herbals['herbal_id']);


                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $price = $this->currency->format($herbals['price'], $this->config->get('config_currency'));
                } else {
                    $price = false;
                }

                $sub_tax = $this->tax->calculateTax($herbals['price'], $herbals['tax_class_id'], $this->config->get('config_tax'));

                // Display prices
                if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
                    $total = $this->currency->format($herbals['price'] * $herbals['quantity'], $this->config->get('config_currency'));
                } else {
                    $total = false;
                }

                //tax
                $tax = $this->currency->format($sub_tax['tax'] * $herbals['quantity'], $this->config->get('config_currency'));

                $json['herbals'][] = array(
                    'key' => $herbals['key'],
                    'name' => $herbals['name'],
                    'unitprice' => $herbals['unitprice'],
                    'invoice_prefix' => $herbals['invoice_prefix'],
                    'gst' => $herbals['gst'],
                    'customer_ic' => $herbals['customer_ic'],
                    'quantity' => $herbals['quantity'],
                    'price' => $price,
                    'tax' => $tax,
                    'total' => $total,
                );
            }
        }
        return $json;
    }

    public function customerLogin() {
        $this->load->language('customer/customer');
        $this->load->model('pos/pos');

        if (isset($this->request->post['password'])) {
            $password = $this->request->post['password'];
        } else {
            $password = " ";
        }
        if (isset($this->request->post['customer_id'])) {
            $customer_id = $this->request->post['customer_id'];
        } else {
            $customer_id = " ";
        }

        if ($this->user->customerLogin($customer_id, $password)) {
            $json['success'] = "Cridit Details";
            $json['amount'] = $this->model_pos_pos->getTotalAmount($customer_id);
            $json['points'] = $this->model_pos_pos->getTotalReward($customer_id);
        } else {
            $json['errors'] = $this->language->get('error_not_match');
        }
        return $this->response->setOutput(json_encode($json));
    }

    public function addShipping() {
        $this->load->model('customer/customer');
        if (isset($this->request->post['shipping_addres'])) {
            $this->session->data['shipping_addres_id'] = $this->request->post['shipping_addres'];
            $this->session->data['shipping_address'] = $this->model_customer_customer->getAddress($this->request->post['shipping_addres']);
        }

        if (!isset($this->session->data['shipping_addres_id'])) {
            $this->session->data['shipping_addres_id'] = 0;
        }

        return $this->session->data['shipping_addres_id'];
    }

    public function totalData() {
        $this->load->model('pos/extension');

        $total_data = array();
        $sort_order = array();

        $totals = array();
        $taxes = $this->cart->getTaxes();
        $total = 0;

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        $results = $this->model_pos_extension->getExtensions('total');

        foreach ($results as $key => $value) {
            $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
        }
        array_multisort($sort_order, SORT_ASC, $results);

        foreach ($results as $result) {

            if ($this->config->get($result['type'] . '_' . $result['code'] . '_status') && $result['code'] != 'credit' && $result['code'] != 'reward') {

                $this->load->model('pos/' . $result['code']);
                $this->{'model_pos_' . $result['code']}->getTotal($total_data);
            };

            $sort_order = array();

            foreach ($totals as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }

            array_multisort($sort_order, SORT_ASC, $totals);
        }

        return $totals;
    }

    public function setShipping() {

        $json = array();

        $this->load->library('customer');
        $this->customer = new Customer($this->registry);

        $this->load->library('tax'); //
        $this->tax = new Tax($this->registry);

        $this->load->library('pos_cart'); //
        $this->cart = new Pos_cart($this->registry);

        $this->load->model('pos/pos');
        $this->load->model('customer/customer');

        $shipping_data = explode('.', $_POST['shipping_method']);
        $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping_data[0]]['quote'][$shipping_data[1]];


        // Totals
        $this->load->model('pos/extension');

        $total = 0;
        $totals = array();
        $taxes = $this->cart->getTaxes();

        $total_data = array(
            'totals' => &$totals,
            'taxes' => &$taxes,
            'total' => &$total
        );

        // Display prices
        if (($this->config->get('config_customer_price') && $this->customer->isLogged()) || !$this->config->get('config_customer_price')) {
            $sort_order = array();

            $results = $this->model_pos_extension->getExtensions('total');

            foreach ($results as $key => $value) {
                $sort_order[$key] = $this->config->get($value['type'] . '_' . $value['code'] . '_sort_order');
            }

            array_multisort($sort_order, SORT_ASC, $results);

            foreach ($results as $result) {
                if ($this->config->get($result['type'] . '_' . $result['code'] . '_status')) {
                    $this->load->model('pos/' . $result['code']);

                    $this->{'model_pos_' . $result['code']}->getTotal($total_data);
                }

                $sort_order = array();

                foreach ($totals as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $totals);
            }
        }

        echo json_encode($json);
        $json['total'] = $total;
        $json['total_data'] = $totals;

        echo json_encode($json);
    }

}

?>
