<?php

class ControllerNotificationNotificationSetting extends Controller {

    private $error = [];

    public function index() {
        $this->load->language('notification/notification_setting');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('notification/notification_setting');

        $this->getForm();
    }

    protected function getForm() {
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_notification_notification_setting->save_settings($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('notification/notification', 'user_token=' . $this->session->data['user_token'], true));
        }

        $notification_settings = $this->get_settings();

        $language_arr = ['heading_title', 'button_cancel', 'button_save', 'text_form', 'tab_notification_settings', 'tab_notification_options', 'tab_notification_template', 'entry_notification_status', 'text_enabled', 'text_disabled', 'entry_show_time_ago', 'entry_hide_old_time_ago', 'text_hours', 'help_hide_old_time_ago', 'entry_notification_type', 'entry_placement', 'text_bottom', 'text_top', 'text_notification_success', 'text_notification_info', 'text_notification_danger', 'text_notification_warning', 'text_left', 'text_right', 'text_center', 'entry_allow_dismiss', 'help_allow_dismiss', 'entry_show_progressbar', 'help_show_progressbar', 'entry_animate_enter', 'help_animate_enter', 'text_seconds', 'entry_animate_exit', 'help_animate_exit', 'entry_delay', 'help_delay', 'entry_zindex', 'help_zindex', 'entry_time_ago_minute', 'help_time_ago_minute', 'entry_time_ago_hour', 'help_time_ago_hour', 'entry_time_ago_day', 'help_time_ago_day', 'entry_new_appointment_title_template', 'entry_new_appointment_message_template', 'help_new_appointment_message_template', 'text_new_appointment_notification', 'entry_new_appointment_notification_status', 'text_cancel_appointment_notification', 'entry_cancel_appointment_notification_status', 'entry_cancel_appointment_title_template', 'entry_cancel_appointment_message_template', 'help_cancel_appointment_message_template', 'entry_reconfirm_appointment_notification_status', 'entry_reconfirm_appointment_title_template', 'entry_reconfirm_appointment_message_template', 'text_reconfirm_appointment_notification', 'help_reconfirm_appointment_message_template', 'entry_new_clinical_sale_status', 'entry_new_clinical_sale_title_template', 'entry_new_clinical_sale_message_template', 'text_new_clinical_sale_notification', 'help_new_clinical_sale_message_template', 'text_new_service_form_notification', 'entry_new_service_form_status', 'entry_new_service_form_title_template', 'entry_new_service_form_message_template', 'help_new_service_form_message_template'];

        foreach ($language_arr as $language) {
            $data[$language] = $this->language->get($language);
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['delay'])) {
            $data['error_delay'] = $this->error['delay'];
        } else {
            $data['error_delay'] = '';
        }

        if (isset($this->error['time_ago_minute'])) {
            $data['error_time_ago_minute'] = $this->error['time_ago_minute'];
        } else {
            $data['error_time_ago_minute'] = [];
        }

        if (isset($this->error['time_ago_hour'])) {
            $data['error_time_ago_hour'] = $this->error['time_ago_hour'];
        } else {
            $data['error_time_ago_hour'] = [];
        }

        if (isset($this->error['time_ago_day'])) {
            $data['error_time_ago_day'] = $this->error['time_ago_day'];
        } else {
            $data['error_time_ago_day'] = [];
        }

        if (isset($this->error['new_appointment_title_template'])) {
            $data['error_new_appointment_title_template'] = $this->error['new_appointment_title_template'];
        } else {
            $data['error_new_appointment_title_template'] = [];
        }

        if (isset($this->error['new_appointment_message_template'])) {
            $data['error_new_appointment_message_template'] = $this->error['new_appointment_message_template'];
        } else {
            $data['error_new_appointment_message_template'] = [];
        }

        if (isset($this->error['cancel_appointment_title_template'])) {
            $data['error_cancel_appointment_title_template'] = $this->error['cancel_appointment_title_template'];
        } else {
            $data['error_cancel_appointment_title_template'] = [];
        }

        if (isset($this->error['cancel_appointment_message_template'])) {
            $data['error_cancel_appointment_message_template'] = $this->error['cancel_appointment_message_template'];
        } else {
            $data['error_cancel_appointment_message_template'] = [];
        }

        if (isset($this->error['reconfirm_appointment_title_template'])) {
            $data['error_reconfirm_appointment_title_template'] = $this->error['reconfirm_appointment_title_template'];
        } else {
            $data['error_reconfirm_appointment_title_template'] = [];
        }

        if (isset($this->error['reconfirm_appointment_message_template'])) {
            $data['error_reconfirm_appointment_message_template'] = $this->error['reconfirm_appointment_message_template'];
        } else {
            $data['error_reconfirm_appointment_message_template'] = [];
        }

        if (isset($this->error['new_clinical_sale_title_template'])) {
            $data['error_new_clinical_sale_title_template'] = $this->error['new_clinical_sale_title_template'];
        } else {
            $data['error_new_clinical_sale_title_template'] = [];
        }

        if (isset($this->error['new_clinical_sale_message_template'])) {
            $data['error_new_clinical_sale_message_template'] = $this->error['new_clinical_sale_message_template'];
        } else {
            $data['error_new_clinical_sale_message_template'] = [];
        }

        if (isset($this->error['new_service_form_title_template'])) {
            $data['error_new_service_form_title_template'] = $this->error['new_service_form_title_template'];
        } else {
            $data['error_new_service_form_title_template'] = [];
        }

        if (isset($this->error['new_service_form_message_template'])) {
            $data['error_new_service_form_message_template'] = $this->error['new_service_form_message_template'];
        } else {
            $data['error_new_service_form_message_template'] = [];
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('notification/notification_setting', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (isset($this->request->post['notification_status'])) {
            $data['notification_status'] = $this->request->post['notification_status'];
        } else if (!empty($notification_settings)) {
            $data['notification_status'] = $notification_settings['notification_status'];
        } else {
            $data['notification_status'] = 0;
        }

        if (isset($this->request->post['hide_old_time_ago'])) {
            $data['hide_old_time_ago'] = $this->request->post['hide_old_time_ago'];
        } else if (!empty($notification_settings)) {
            $data['hide_old_time_ago'] = $notification_settings['hide_old_time_ago'];
        } else {
            $data['hide_old_time_ago'] = '';
        }

        if (isset($this->request->post['show_time_ago'])) {
            $data['show_time_ago'] = $this->request->post['show_time_ago'];
        } else if (!empty($notification_settings)) {
            $data['show_time_ago'] = $notification_settings['show_time_ago'];
        } else {
            $data['show_time_ago'] = 0;
        }

        if (isset($this->request->post['notification_type'])) {
            $data['notification_type'] = $this->request->post['notification_type'];
        } else if (!empty($notification_settings)) {
            $data['notification_type'] = $notification_settings['notification_type'];
        } else {
            $data['notification_type'] = '';
        }

        if (isset($this->request->post['notification_placement_from'])) {
            $data['notification_placement_from'] = $this->request->post['notification_placement_from'];
        } else if (!empty($notification_settings)) {
            $data['notification_placement_from'] = $notification_settings['notification_placement_from'];
        } else {
            $data['notification_placement_from'] = '';
        }

        if (isset($this->request->post['notification_placement_align'])) {
            $data['notification_placement_align'] = $this->request->post['notification_placement_align'];
        } else if (!empty($notification_settings)) {
            $data['notification_placement_align'] = $notification_settings['notification_placement_align'];
        } else {
            $data['notification_placement_align'] = '';
        }

        if (isset($this->request->post['notification_allow_dismiss'])) {
            $data['notification_allow_dismiss'] = $this->request->post['notification_allow_dismiss'];
        } else if (!empty($notification_settings)) {
            $data['notification_allow_dismiss'] = $notification_settings['notification_allow_dismiss'];
        } else {
            $data['notification_allow_dismiss'] = 0;
        }

        if (isset($this->request->post['notification_show_progressbar'])) {
            $data['notification_show_progressbar'] = $this->request->post['notification_show_progressbar'];
        } else if (!empty($notification_settings)) {
            $data['notification_show_progressbar'] = $notification_settings['notification_show_progressbar'];
        } else {
            $data['notification_show_progressbar'] = 0;
        }

        if (isset($this->request->post['notification_animate_enter'])) {
            $data['notification_animate_enter'] = $this->request->post['notification_animate_enter'];
        } else if (!empty($notification_settings)) {
            $data['notification_animate_enter'] = $notification_settings['notification_animate_enter'];
        } else {
            $data['notification_animate_enter'] = '';
        }

        if (isset($this->request->post['notification_animate_exit'])) {
            $data['notification_animate_exit'] = $this->request->post['notification_animate_exit'];
        } else if (!empty($notification_settings)) {
            $data['notification_animate_exit'] = $notification_settings['notification_animate_exit'];
        } else {
            $data['notification_animate_exit'] = '';
        }

        if (isset($this->request->post['notification_delay'])) {
            $data['notification_delay'] = $this->request->post['notification_delay'];
        } else if (!empty($notification_settings)) {
            $data['notification_delay'] = $notification_settings['notification_delay'];
        } else {
            $data['notification_delay'] = '';
        }

        if (isset($this->request->post['notification_zindex'])) {
            $data['notification_zindex'] = $this->request->post['notification_zindex'];
        } else if (!empty($notification_settings)) {
            $data['notification_zindex'] = $notification_settings['notification_zindex'];
        } else {
            $data['notification_zindex'] = '';
        }

        if (isset($this->request->post['time_ago_template'])) {
            $data['time_ago_template'] = $this->request->post['time_ago_template'];
        } else if (!empty($notification_settings['time_ago_template'])) {
            $data['time_ago_template'] = $notification_settings['time_ago_template'];
        } else {
            $data['time_ago_template'] = [];
        }

        if (isset($this->request->post['new_appointment_notification_status'])) {
            $data['new_appointment_notification_status'] = $this->request->post['new_appointment_notification_status'];
        } else if (!empty($notification_settings)) {
            $data['new_appointment_notification_status'] = $notification_settings['new_appointment_notification_status'];
        } else {
            $data['new_appointment_notification_status'] = 0;
        }

        if (isset($this->request->post['new_appointment_notification_template'])) {
            $data['new_appointment_notification_template'] = $this->request->post['new_appointment_notification_template'];
        } else if (!empty($notification_settings)) {
            $data['new_appointment_notification_template'] = $notification_settings['new_appointment_notification_template'];
        } else {
            $data['new_appointment_notification_template'] = [];
        }

        if (isset($this->request->post['cancel_appointment_notification_status'])) {
            $data['cancel_appointment_notification_status'] = $this->request->post['cancel_appointment_notification_status'];
        } else if (!empty($notification_settings)) {
            $data['cancel_appointment_notification_status'] = $notification_settings['cancel_appointment_notification_status'];
        } else {
            $data['cancel_appointment_notification_status'] = 0;
        }

        if (isset($this->request->post['cancel_appointment_notification_template'])) {
            $data['cancel_appointment_notification_template'] = $this->request->post['cancel_appointment_notification_template'];
        } else if (!empty($notification_settings)) {
            $data['cancel_appointment_notification_template'] = $notification_settings['cancel_appointment_notification_template'];
        } else {
            $data['cancel_appointment_notification_template'] = [];
        }

        if (isset($this->request->post['reconfirm_appointment_notification_status'])) {
            $data['reconfirm_appointment_notification_status'] = $this->request->post['reconfirm_appointment_notification_status'];
        } else if (!empty($notification_settings)) {
            $data['reconfirm_appointment_notification_status'] = $notification_settings['reconfirm_appointment_notification_status'];
        } else {
            $data['reconfirm_appointment_notification_status'] = 0;
        }

        if (isset($this->request->post['reconfirm_appointment_notification_template'])) {
            $data['reconfirm_appointment_notification_template'] = $this->request->post['reconfirm_appointment_notification_template'];
        } else if (!empty($notification_settings)) {
            $data['reconfirm_appointment_notification_template'] = $notification_settings['reconfirm_appointment_notification_template'];
        } else {
            $data['reconfirm_appointment_notification_template'] = [];
        }

        if (isset($this->request->post['new_clinical_sale_notification_status'])) {
            $data['new_clinical_sale_notification_status'] = $this->request->post['new_clinical_sale_notification_status'];
        } else if (!empty($notification_settings)) {
            $data['new_clinical_sale_notification_status'] = $notification_settings['new_clinical_sale_notification_status'];
        } else {
            $data['new_clinical_sale_notification_status'] = 0;
        }

        if (isset($this->request->post['new_clinical_sale_notification_template'])) {
            $data['new_clinical_sale_notification_template'] = $this->request->post['new_clinical_sale_notification_template'];
        } else if (!empty($notification_settings)) {
            $data['new_clinical_sale_notification_template'] = $notification_settings['new_clinical_sale_notification_template'];
        } else {
            $data['new_clinical_sale_notification_template'] = [];
        }

        if (isset($this->request->post['new_service_form_notification_status'])) {
            $data['new_service_form_notification_status'] = $this->request->post['new_service_form_notification_status'];
        } else if (!empty($notification_settings)) {
            $data['new_service_form_notification_status'] = $notification_settings['new_service_form_notification_status'];
        } else {
            $data['new_service_form_notification_status'] = 0;
        }

        //if (isset($this->request->post['new_purchase_order_notification_status'])) {
        // $data['new_purchase_order_notification_status'] = $this->request->post['new_purchase_order_notification_status'];
        //} else if (!empty($notification_settings)) {
        //$data['new_purchase_order_notification_status'] = $notification_settings['new_purchase_order_notification_status'];
        //} else {
        //$data['new_purchase_order_notification_status'] = 0;
        //}
        // if (isset($this->request->post['new_purchase_receive_notification_status'])) {
        //   $data['new_purchase_receive_notification_status'] = $this->request->post['new_purchase_receive_notification_status'];
        // } else if (!empty($notification_settings)) {
        //  $data['new_purchase_receive_notification_status'] = $notification_settings['new_purchase_receive_notification_status'];
        // } else {
        // $data['new_purchase_receive_notification_status'] = 0;
        //}
        // if (isset($this->request->post['new_purchase_invoice_notification_status'])) {
        //  $data['new_purchase_invoice_notification_status'] = $this->request->post['new_purchase_invoice_notification_status'];
        // } else if (!empty($notification_settings)) {
        //  $data['new_purchase_invoice_notification_status'] = $notification_settings['new_purchase_invoice_notification_status'];
        // } else {
        //   $data['new_purchase_invoice_notification_status'] = 0;
        //}

        if (isset($this->request->post['new_service_form_notification_template'])) {
            $data['new_service_form_notification_template'] = $this->request->post['new_service_form_notification_template'];
        } else if (!empty($notification_settings)) {
            $data['new_service_form_notification_template'] = $notification_settings['new_service_form_notification_template'];
        } else {
            $data['new_service_form_notification_template'] = [];
        }

        //if (isset($this->request->post['new_purchase_order_notification_template'])) {
        //  $data['new_purchase_order_notification_template'] = $this->request->post['new_purchase_order_notification_template'];
        // } else if (!empty($notification_settings)) {
        //  $data['new_purchase_order_notification_template'] = $notification_settings['new_purchase_order_notification_template'];
        // } else {
        //  $data['new_purchase_order_notification_template'] = [];
        //}
        //if (isset($this->request->post['new_purchase_receive_notification_template'])) {
        //   $data['new_purchase_receive_notification_template'] = $this->request->post['new_purchase_receive_notification_template'];
        //} else if (!empty($notification_settings)) {
        //   $data['new_purchase_receive_notification_template'] = $notification_settings['new_purchase_receive_notification_template'];
        // } else {
        // $data['new_purchase_receive_notification_template'] = [];
        //}
        // if (isset($this->request->post['new_purchase_invoice_notification_template'])) {
        // $data['new_purchase_invoice_notification_template'] = $this->request->post['new_purchase_invoice_notification_template'];
        // } else if (!empty($notification_settings)) {
        //   $data['new_purchase_invoice_notification_template'] = $notification_settings['new_purchase_invoice_notification_template'];
        // } else {
        //    $data['new_purchase_invoice_notification_template'] = [];
        // }

        $data['animations_enter'] = ['bounce', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'jello', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight', 'bounceInUp', 'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRight', 'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'flip', 'flipInX', 'flipInY', 'lightSpeedIn', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'slideInUp', 'slideInDown', 'slideInLeft', 'slideInRight', 'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp', 'hinge', 'rollIn'];

        $data['animations_exit'] = ['bounce', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'jello', 'bounceOut', 'bounceOutDown', 'bounceOutLeft', 'bounceOutRight', 'bounceOutUp', 'fadeOut', 'fadeOutDown', 'fadeOutDownBig', 'fadeOutLeft', 'fadeOutLeftBig', 'fadeOutRight', 'fadeOutRightBig', 'fadeOutUp', 'fadeOutUpBig', 'flip', 'flipInX', 'flipInY', 'flipOutX', 'flipOutY', 'lightSpeedOut', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight', 'slideOutUp', 'slideOutDown', 'slideOutLeft', 'slideOutRight', 'zoomOut', 'zoomOutDown', 'zoomOutLeft', 'zoomOutRight', 'zoomOutUp', 'hinge', 'rollOut'];

        $this->load->model('localisation/language');
        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['action'] = $this->url->link('notification/notification_setting', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('notification/notification', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('notification/notification_setting', $data));
    }

    protected function validateForm() {
        if (!$this->user->hasPermission('modify', 'notification/notification_setting')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (utf8_strlen($this->request->post['notification_delay']) < 1 || !is_numeric($this->request->post['notification_delay'])) {
            $this->error['delay'] = $this->language->get('error_delay');
        }

        if ($this->request->post['show_time_ago'] == '1') {
            foreach ($this->request->post['time_ago_template'] as $language_id => $value) {
                if (utf8_strlen($value['time_ago_minute']) < 1 || strpos($value['time_ago_minute'], '{time_counter}') === false) {
                    $this->error['time_ago_minute'][$language_id] = $this->language->get('error_time_ago_minute');
                }

                if (utf8_strlen($value['time_ago_hour']) < 1 || strpos($value['time_ago_hour'], '{time_counter}') === false) {
                    $this->error['time_ago_hour'][$language_id] = $this->language->get('error_time_ago_hour');
                }

                if (utf8_strlen($value['time_ago_day']) < 1 || strpos($value['time_ago_day'], '{time_counter}') === false) {
                    $this->error['time_ago_day'][$language_id] = $this->language->get('error_time_ago_day');
                }
            }
        }

        foreach ($this->request->post['new_appointment_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_appointment_title_template'][$language_id] = $this->language->get('error_new_appointment_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_appointment_message_template'][$language_id] = $this->language->get('error_new_appointment_message_template');
            }
        }

        foreach ($this->request->post['cancel_appointment_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['cancel_appointment_title_template'][$language_id] = $this->language->get('error_cancel_appointment_title_template');
            }

            if (empty($value['message'])) {
                $this->error['cancel_appointment_message_template'][$language_id] = $this->language->get('error_cancel_appointment_message_template');
            }
        }

        foreach ($this->request->post['reconfirm_appointment_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['reconfirm_appointment_title_template'][$language_id] = $this->language->get('error_reconfirm_appointment_title_template');
            }

            if (empty($value['message'])) {
                $this->error['reconfirm_appointment_message_template'][$language_id] = $this->language->get('error_reconfirm_appointment_message_template');
            }
        }

        foreach ($this->request->post['new_clinical_sale_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_clinical_sale_title_template'][$language_id] = $this->language->get('error_new_clinical_sale_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_clinical_sale_message_template'][$language_id] = $this->language->get('error_new_clinical_sale_message_template');
            }
        }

        foreach ($this->request->post['new_service_form_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_service_form_title_template'][$language_id] = $this->language->get('error_new_service_form_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_service_form_message_template'][$language_id] = $this->language->get('error_new_service_form_message_template');
            }
        }

        foreach ($this->request->post['new_purchase_order_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_purchase_order_title_template'][$language_id] = $this->language->get('error_new_purchase_order_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_purchase_order_title_template'][$language_id] = $this->language->get('error_new_purchase_order_message_template');
            }
        }

        foreach ($this->request->post['new_purchase_receive_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_purchase_receive_title_template'][$language_id] = $this->language->get('error_new_purchase_receive_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_purchase_receive_title_template'][$language_id] = $this->language->get('error_new_purchase_receive_message_template');
            }
        }

        foreach ($this->request->post['new_purchase_invoice_notification_template'] as $language_id => $value) {
            if (empty($value['title'])) {
                $this->error['new_purchase_invoice_title_template'][$language_id] = $this->language->get('error_new_purchase_invoice_title_template');
            }

            if (empty($value['message'])) {
                $this->error['new_purchase_invoice_title_template'][$language_id] = $this->language->get('error_new_purchase_invoice_message_template');
            }
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    private function get_settings() {
        $setting_results = [];

        $this->load->model('notification/notification_setting');

        $settings = $this->model_notification_notification_setting->get_settings();

        if (!empty($settings)) {
            foreach ($settings as $setting) {
                if ($setting['serialized'] == '1') {
                    $setting_results[$setting['setting_key']] = unserialize($setting['value']);
                } else {
                    $setting_results[$setting['setting_key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }

}

?>