<?php

class ControllerNotificationNotification extends Controller {

    private $error = [];

    public function index() {
        $this->load->language('notification/notification');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('notification/notification');

        $this->getList();
    }

    protected function getList() {

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('notification/notification', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['notifications'] = [];

        $this->notification = new Notification($this->registry);

        $all_notification = $this->model_notification_notification->get_all_notification();

        if (!empty($all_notification)) {
            foreach ($all_notification as $notification) {
                $notification_details = $this->notification->get_notification_details($notification['notification_id']);

                $notification_title = !empty($notification_details['title']) ? $notification_details['title'] : '';
                $notification_message = !empty($notification_details['message']) ? $notification_details['message'] : '';
                $notification_url = !empty($notification_details['url']) ? $notification_details['url'] : '';

                $data['notifications'][] = [
                    'notification_id' => $notification['notification_id'],
                    'module' => $notification['module'],
                    'title' => $notification_title,
                    'message' => $notification_message,
                    'url' => $notification_url,
                    'had_read' => $notification['had_read'],
                    'time_ago' => $this->notification->timeAgoSecondsToText($notification['time_ago'])
                ];
            }
        }

        $data['user_token'] = $this->session->data['user_token'];

        $data['settings'] = $this->url->link('notification/notification_setting', 'user_token=' . $this->session->data['user_token'], true);
        $data['delete_all'] = $this->url->link('notification/notification/delete', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('notification/notification_list', $data));
    }

    public function delete() {
        $this->load->language('notification/notification');
        $this->load->model('notification/notification');

        $this->model_notification_notification->delete_all_notification();

        $this->session->data['success'] = $this->language->get('text_success_delete');

        $this->response->redirect($this->url->link('notification/notification', 'user_token=' . $this->session->data['user_token'], true));
    }

    public function mark_as_read() {
        $json = [];

        $this->load->model('notification/notification');

        if (isset($this->request->post['notification_id'])) {
            $notification_id = $this->request->post['notification_id'];

            $edited_row = $this->model_notification_notification->mark_notification_read($notification_id);

            if ($edited_row == 1) {
                $json = [
                    'error' => 0,
                    'message' => 'mark notification as read successfully'
                ];
            } else {
                $json = [
                    'error' => 1,
                    'message' => 'failed to mark notification as read'
                ];
            }
        } else {
            $json = [
                'error' => 1,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

}

?>
