<?php

class ControllerModuleGeneratorPro extends controller {

    public function index() {
        $this->load->model('module/generator_pro');
        $this->load->language('module/generator_pro');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->getList();
    }

    public function getList() {
        $this->load->model('module/generator_pro');
        $this->load->language('module/generator_pro');

        $this->document->setTitle($this->language->get('heading_title'));

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->get['filter_title'])) {
            $filter_title = $this->request->get['filter_title'];
        } else {
            $filter_title = '';
        }

        if (isset($this->request->get['filter_description'])) {
            $filter_description = $this->request->get['filter_description'];
        } else {
            $filter_description = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'date_added';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_title'])) {
            $url .= '&filter_title=' . urlencode(html_entity_decode($this->request->get['filter_title'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . urlencode(html_entity_decode($this->request->get['filter_description'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('module/generator_pro/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('module/generator_pro/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['qr_list'] = array();

        $filter_data = array(
            'filter_title' => $filter_title,
            'filter_description' => $filter_description,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );
        
        $qr_total = $this->model_module_generator_pro->getTotalQr();

        $results = $this->model_module_generator_pro->getQrList($filter_data);

        foreach ($results as $result) {
            $data['qr_list'][] = array(
                'qr_id' => $result['qr_id'],
                'title' => $result['title'],
                'description' => $result['description'],
                'url' => $result['value'],
                'type' => $result['type'],
                'qr' => $this->url->link('module/generator_pro/qr_code', 'user_token=' . $this->session->data['user_token'] . '&qr_id=' . $result['qr_id'], true),
                'edit' => $this->url->link('module/generator_pro/edit', 'user_token=' . $this->session->data['user_token'] . '&qr_id=' . $result['qr_id'] . $url, true)
            );
        }
        
        $data['user_token'] = $this->session->data['user_token'];
        
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($sort) && isset($order)) {
            if ($sort == 'qr_id') {
                $qr_id_column = array_column($data['qr_list'], 'qr_id');

                if ($order == 'ASC') {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $qr_id_column, SORT_ASC);
                } else {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $qr_id_column, SORT_DESC);
                }
            } elseif ($sort == 'title') {
                $title_column = array_column($data['qr_list'], 'title');

                if ($order == 'ASC') {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $title_column, SORT_ASC);
                } else {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $title_column, SORT_DESC);
                }
            } elseif ($sort == 'description') {
                $description_column = array_column($data['qr_list'], 'description');

                if ($order == 'ASC') {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $description_column, SORT_ASC);
                } else {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $description_column, SORT_DESC);
                }
            } elseif ($sort == 'type') {
                $type_column = array_column($data['qr_list'], 'type');

                if ($order == 'ASC') {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $type_column, SORT_ASC);
                } else {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $type_column, SORT_DESC);
                }
            } elseif ($sort == 'value') {
                $url_column = array_column($data['qr_list'], 'value');

                if ($order == 'ASC') {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $url_column, SORT_ASC);
                } else {
                    array_multisort($data['qr_list'], SORT_NUMERIC, $url_column, SORT_DESC);
                }
            }
        }

        $url = '';

        if (isset($this->request->get['filter_title'])) {
            $url .= '&filter_title=' . urlencode(html_entity_decode($this->request->get['filter_title'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . urlencode(html_entity_decode($this->request->get['filter_description'], ENT_QUOTES, 'UTF-8'));
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        $data['sort_qr_id'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . '&sort=qr_id' . $url, true);
        $data['sort_description'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . '&sort=description' . $url, true);
        $data['sort_url'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . '&sort=value' . $url, true);
        $data['sort_type'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . '&sort=type' . $url, true);
        $data['sort_title'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . '&sort=title' . $url, true);

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $url = '';

        if (isset($this->request->get['filter_title'])) {
            $url .= '&filter_title=' . urlencode(html_entity_decode($this->request->get['filter_title'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_description'])) {
            $url .= '&filter_description=' . urlencode(html_entity_decode($this->request->get['filter_description'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $data['filter_title'] = $filter_title;
        $data['filter_description'] = $filter_description;

        $data['sort'] = $sort;
        $data['order'] = $order;


        $pagination = new Pagination();
        $pagination->total = $qr_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($qr_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($qr_total - $this->config->get('config_limit_admin'))) ? $qr_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $qr_total, ceil($qr_total / $this->config->get('config_limit_admin')));

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('module/generator_pro_list', $data));
    }

    public function add() {
        $this->load->language('module/generator_pro');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('module/generator_pro');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
            $this->model_module_generator_pro->addQr($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function edit() {
        $this->load->language('module/generator_pro');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('module/generator_pro');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {

            $this->model_module_generator_pro->editQr($this->request->get['qr_id'], $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getForm();
    }

    public function delete() {
        $this->load->language('module/generator_pro');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('module/generator_pro');

        if (isset($this->request->post['selected']) && $this->validateDelete()) {
            foreach ($this->request->post['selected'] as $qr_id) {
                $this->model_module_generator_pro->deleteQr($qr_id);
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $url = '';

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function getForm() {
        $data['text_form'] = !isset($this->request->get['qr_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $this->load->model('module/generator_pro');
        $this->load->language('module/generator_pro');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['title'])) {
            $data['error_title'] = $this->error['title'];
        } else {
            $data['error_title'] = array();
        }

        if (isset($this->error['description'])) {
            $data['error_description'] = $this->error['description'];
        } else {
            $data['error_description'] = array();
        }

        if (isset($this->error['type'])) {
            $data['error_type'] = $this->error['type'];
        } else {
            $data['error_type'] = '';
        }

        if (isset($this->error['value'])) {
            $data['error_value'] = $this->error['value'];
        } else {
            $data['error_value'] = '';
        }

        $url = '';

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['qr_id'])) {
            $data['action'] = $this->url->link('module/generator_pro/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('module/generator_pro/edit', 'user_token=' . $this->session->data['user_token'] . '&qr_id=' . $this->request->get['qr_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('module/generator_pro', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['qr_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $qr_info = $this->model_module_generator_pro->getQr($this->request->get['qr_id']);
        }

        $data['user_token'] = $this->session->data['user_token'];

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();
        
        if (isset($this->request->post['qr_description'])) {
            $data['qr_description'] = $this->request->post['qr_description'];
        } elseif (isset($this->request->get['qr_id'])) {
            $data['qr_description'] = $this->model_module_generator_pro->getQrDescriptions($this->request->get['qr_id']);
        } else {
            $data['qr_description'] = array();
        }
        
        if (isset($this->request->post['type'])) {
            $data['type'] = $this->request->post['type'];
        } elseif (!empty($qr_info)) {
            $data['type'] = $qr_info['type'];
        } else {
            $data['type'] = '';
        }
        
        if (isset($this->request->post['value'])) {
            $data['value'] = $this->request->post['value'];
        } elseif (!empty($qr_info)) {
            $data['value'] = $qr_info['value'];
        } else {
            $data['value'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('module/generator_pro_form', $data));
    }

    public function validateForm() {
        if (!$this->user->hasPermission('modify', 'module/generator_pro')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        foreach ($this->request->post['qr_description'] as $language_id => $value) {
            if ((utf8_strlen($value['title']) < 2) || (utf8_strlen($value['title']) > 255)) {
                $this->error['title'][$language_id] = $this->language->get('error_title');
            }
        }

        foreach ($this->request->post['qr_description'] as $language_id => $value) {
            if ((utf8_strlen($value['description']) < 2) || (utf8_strlen($value['description']) > 255)) {
                $this->error['description'][$language_id] = $this->language->get('error_description');
            }
        }

        if (empty($this->request->post['value'])) {
            $this->error['value'] = $this->language->get('error_value');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }
    
     protected function validateDelete() {
        if (!$this->user->hasPermission('modify', 'module/generator_pro')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
    
    public function qr_code(){
        $this->load->model('module/generator_pro');

        $qr_info = $this->model_module_generator_pro->getUrl($this->request->get['qr_id']);
        
        $data['qr_info'] = array();
        
        $data['qr_info'][]= array(
            'qr_code' => 'http://chart.apis.google.com/chart?chs='. 500 . 'x' . 500 .'&cht=qr&chl=' . urlencode($qr_info['value']) . '&choe=UTF-8' 
        );
  
        include_once DIR_SYSTEM . 'library/mpdf60/mpdf.php';

        $filename = $this->language->get('text_pdf_qr') . '.pdf';

        $mpdf = new mPDF('utf-8', 'A5');
        $mpdf->writeHTML($this->load->view('module/generator_pro_qr', $data));
        $mpdf->Output($filename, 'I');
//        
//        $this->response->setOutput($this->load->view('module/generator_pro_qr', $data));
        }
    }

?>